/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex2latex;

import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.latex.Environment;
import com.dickimawbooks.texparserlib.latex2latex.L2LMathGroup;
import java.io.IOException;

public class L2LEnvironment
extends Environment {
    public L2LEnvironment(String string) {
        super(string);
    }

    public L2LEnvironment(String string, int n) {
        super(string, n);
    }

    @Override
    public Object clone() {
        L2LEnvironment l2LEnvironment = new L2LEnvironment(this.getName(), this.getMode());
        l2LEnvironment.addAll(this);
        return l2LEnvironment;
    }

    private void processInlineMath(TeXParser teXParser) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        char c = teXParser.getEscChar();
        char c2 = teXParser.getBgChar();
        char c3 = teXParser.getEgChar();
        L2LMathGroup l2LMathGroup = new L2LMathGroup(true, "" + c + "begin" + c2 + this.getName() + c3, "" + c + "end" + c2 + this.getName() + c3);
        while (this.size() > 0) {
            l2LMathGroup.add((Object)this.pop());
        }
        l2LMathGroup.process(teXParser);
    }

    private void processDisplayMath(TeXParser teXParser) throws IOException {
        String string;
        String string2;
        Writeable writeable = teXParser.getListener().getWriteable();
        char c = teXParser.getEscChar();
        char c2 = teXParser.getBgChar();
        char c3 = teXParser.getEgChar();
        String string3 = this.getName();
        if (string3.equals("displaymath")) {
            string2 = c + "[";
            string = c + "]";
        } else {
            string2 = "" + c + "begin" + c2 + string3 + c3;
            string = "" + c + "end" + c2 + string3 + c3;
        }
        L2LMathGroup l2LMathGroup = new L2LMathGroup(false, string2, string);
        while (this.size() > 0) {
            l2LMathGroup.add((Object)this.pop());
        }
        l2LMathGroup.process(teXParser);
    }

    private void processText(TeXParser teXParser) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        char c = teXParser.getEscChar();
        char c2 = teXParser.getBgChar();
        char c3 = teXParser.getEgChar();
        writeable.write(c);
        writeable.write("begin");
        writeable.write(c2);
        writeable.write(this.getName());
        writeable.write(c3);
        teXParser.startGroup();
        while (this.size() > 0) {
            TeXObject teXObject = this.pop();
            if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                writeable.write(teXObject.toString(teXParser));
                continue;
            }
            teXObject.process(teXParser, this);
        }
        teXParser.endGroup();
        writeable.write(c);
        writeable.write("end");
        writeable.write(c2);
        writeable.write(this.getName());
        writeable.write(c3);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        int n = this.getMode();
        n = n == -1 ? teXParser.getSettings().getMode() : n;
        switch (n) {
            case 1: {
                this.processInlineMath(teXParser);
                break;
            }
            case 2: {
                this.processDisplayMath(teXParser);
                break;
            }
            default: {
                this.processText(teXParser);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

