/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import java.io.IOException;
import java.nio.file.Path;

public class L2HImage
implements Expandable {
    private Path path;
    private String mimetype;
    private String name;
    private int width = 0;
    private int height = 0;
    private TeXObject alt;

    public L2HImage(Path path) {
        this(path, null, 0, 0, null, null);
    }

    public L2HImage(Path path, String string) {
        this(path, string, 0, 0, null, null);
    }

    public L2HImage(Path path, String string, int n, int n2, String string2, TeXObject teXObject) {
        this.path = path;
        this.width = n;
        this.height = n2;
        this.alt = teXObject;
        if (string == null) {
            this.updateMimeType();
        } else {
            this.mimetype = string;
        }
        if (string2 != null) {
            string2 = string2.replaceAll("[^\\w]", "");
        }
    }

    public Object clone() {
        return new L2HImage(this.path, this.mimetype, this.width, this.height, this.name, this.alt == null ? null : (TeXObject)this.alt.clone());
    }

    protected void updateMimeType() {
        String string = this.path.getName(this.path.getNameCount() - 1).toString();
        int n = string.lastIndexOf(".");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(n).toLowerCase();
        }
        if (string2.equals("jpg") || string2.equals("jpeg")) {
            this.mimetype = "image/jpeg";
        } else if (string2.equals("png")) {
            this.mimetype = "image/png";
        } else if (string2.equals("pdf")) {
            this.mimetype = "application/pdf";
        }
    }

    public void setAlt(TeXObject teXObject) {
        this.alt = teXObject;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public String toString() {
        return String.format("%s[path=%s,width=%d,height=%d,type=%s,name=%s,alt=%s]", this.getClass().getName(), this.path, this.width, this.height, this.mimetype, this.name, this.alt);
    }

    public boolean isPar() {
        return false;
    }

    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.alt.string(teXParser);
    }

    public String format() {
        return this.alt == null ? "" : this.alt.format();
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<object data=\"%s\"", this.getData()));
        if (this.width != 0) {
            stringBuilder.append(String.format(" width=\"%d\"", this.width));
        }
        if (this.height != 0) {
            stringBuilder.append(String.format(" height=\"%d\"", this.height));
        }
        if (this.mimetype != null) {
            stringBuilder.append(String.format(" type=\"%s\"", this.mimetype));
        }
        if (this.name != null) {
            stringBuilder.append(String.format(" name=\"%s\"", this.name));
        }
        stringBuilder.append(">");
        teXObjectList.add(new HtmlTag(stringBuilder.toString()));
        if (this.alt != null) {
            teXObjectList.add(this.alt);
        }
        teXObjectList.add(new HtmlTag("</object>"));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<object data=\"%s\"", this.getData()));
        if (this.width != 0) {
            stringBuilder.append(String.format(" width=\"%d\"", this.width));
        }
        if (this.height != 0) {
            stringBuilder.append(String.format(" height=\"%d\"", this.height));
        }
        if (this.mimetype != null) {
            stringBuilder.append(String.format(" type=\"%s\"", this.mimetype));
        }
        if (this.name != null) {
            stringBuilder.append(String.format(" name=\"%s\"", this.name));
        }
        stringBuilder.append(">");
        teXObjectList2.add(new HtmlTag(stringBuilder.toString()));
        if (this.alt != null) {
            if (this.alt instanceof Expandable) {
                TeXObjectList teXObjectList3 = teXParser == teXObjectList ? ((Expandable)((Object)this.alt)).expandfully(teXParser) : ((Expandable)((Object)this.alt)).expandfully(teXParser, teXObjectList);
                if (teXObjectList3 == null) {
                    teXObjectList2.add(this.alt);
                } else {
                    teXObjectList2.addAll(teXObjectList3);
                }
            } else {
                teXObjectList2.add(this.alt);
            }
        }
        teXObjectList2.add(new HtmlTag("</object>"));
        return teXObjectList2;
    }

    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Path getPath() {
        return this.path;
    }

    private String getData() {
        int n = this.path.getNameCount();
        if (n == 1) {
            return this.path.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.path.getName(0).toString());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.path.getName(i).toString());
        }
        return stringBuilder.toString();
    }

    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        Writeable writeable = teXParser.getListener().getWriteable();
        writeable.write(String.format("<object data=\"%s\"", this.getData()));
        if (this.width != 0) {
            writeable.write(String.format(" width=\"%d\"", this.width));
        }
        if (this.height != 0) {
            writeable.write(String.format(" height=\"%d\"", this.height));
        }
        if (this.mimetype != null) {
            writeable.write(String.format(" type=\"%s\"", this.mimetype));
        }
        if (this.name != null) {
            writeable.write(String.format(" name=\"%s\"", this.name));
        }
        writeable.write(">");
        if (this.alt != null) {
            if (teXParser == teXObjectList) {
                this.alt.process(teXParser);
            } else {
                this.alt.process(teXParser, teXObjectList);
            }
        }
        writeable.write("</object>");
    }
}

