; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i8_stride5_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,3,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[1,2,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[2,3,2,3]
; SSE-NEXT:    psrlq $48, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; SSE-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    psrld $16, %xmm1
; SSE-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1],xmm6[2],xmm1[2],xmm6[3],xmm1[3]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movd %xmm3, %eax
; SSE-NEXT:    movw %ax, (%rsi)
; SSE-NEXT:    movd %xmm4, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    movd %xmm5, %eax
; SSE-NEXT:    movw %ax, (%rcx)
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    movw %ax, (%r8)
; SSE-NEXT:    movd %xmm6, %eax
; SSE-NEXT:    movw %ax, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX2-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX2-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX2-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX2-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX2-FP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX2-FP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX2-FP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX2-FP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX2-FCP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX2-FCP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX2-FCP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX2-FCP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512-FCP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512-FCP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512-FCP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512-FCP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512DQ-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512DQ-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512DQ-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512DQ-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512DQ-FCP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512DQ-FCP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512DQ-FCP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512DQ-FCP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512BW-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512BW-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512BW-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512BW-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512BW-FCP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512BW-FCP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512BW-FCP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512BW-FCP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512DQ-BW-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512DQ-BW-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512DQ-BW-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512DQ-BW-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,6,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[2,7,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[3,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vpextrw $0, %xmm3, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vpextrw $0, %xmm4, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vpextrw $0, %xmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <10 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <10 x i8> %wide.vec, <10 x i8> poison, <2 x i32> <i32 0, i32 5>
  %strided.vec1 = shufflevector <10 x i8> %wide.vec, <10 x i8> poison, <2 x i32> <i32 1, i32 6>
  %strided.vec2 = shufflevector <10 x i8> %wide.vec, <10 x i8> poison, <2 x i32> <i32 2, i32 7>
  %strided.vec3 = shufflevector <10 x i8> %wide.vec, <10 x i8> poison, <2 x i32> <i32 3, i32 8>
  %strided.vec4 = shufflevector <10 x i8> %wide.vec, <10 x i8> poison, <2 x i32> <i32 4, i32 9>
  store <2 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <2 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <2 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <2 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i8_stride5_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm4[8],xmm2[9],xmm4[9],xmm2[10],xmm4[10],xmm2[11],xmm4[11],xmm2[12],xmm4[12],xmm2[13],xmm4[13],xmm2[14],xmm4[14],xmm2[15],xmm4[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[3,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3],xmm3[4],xmm4[4],xmm3[5],xmm4[5],xmm3[6],xmm4[6],xmm3[7],xmm4[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm4[0],xmm6[1],xmm4[1],xmm6[2],xmm4[2],xmm6[3],xmm4[3],xmm6[4],xmm4[4],xmm6[5],xmm4[5],xmm6[6],xmm4[6],xmm6[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm6[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm6[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm7[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[1,2,3,0,4,5,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,65535,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm5, %xmm8
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1],xmm7[2],xmm4[2],xmm7[3],xmm4[3],xmm7[4],xmm4[4],xmm7[5],xmm4[5],xmm7[6],xmm4[6],xmm7[7],xmm4[7]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm7[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm8[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm4[0],xmm8[1],xmm4[1],xmm8[2],xmm4[2],xmm8[3],xmm4[3],xmm8[4],xmm4[4],xmm8[5],xmm4[5],xmm8[6],xmm4[6],xmm8[7],xmm4[7]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm2[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm8[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,0,1,2,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[2,1,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movd %xmm1, (%rsi)
; SSE-NEXT:    movd %xmm6, (%rdx)
; SSE-NEXT:    movd %xmm7, (%rcx)
; SSE-NEXT:    movd %xmm4, (%r8)
; SSE-NEXT:    movd %xmm3, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vmovdqa (%rdi), %xmm1
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vmovd %xmm3, (%rsi)
; AVX-NEXT:    vmovd %xmm4, (%rdx)
; AVX-NEXT:    vmovd %xmm5, (%rcx)
; AVX-NEXT:    vmovd %xmm6, (%r8)
; AVX-NEXT:    vmovd %xmm0, (%r9)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX2-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX2-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX2-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX2-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX2-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vmovd %xmm3, (%rsi)
; AVX2-NEXT:    vmovd %xmm4, (%rdx)
; AVX2-NEXT:    vmovd %xmm5, (%rcx)
; AVX2-NEXT:    vmovd %xmm6, (%r8)
; AVX2-NEXT:    vmovd %xmm0, (%r9)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX2-FP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX2-FP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX2-FP-NEXT:    vmovd %xmm3, (%rsi)
; AVX2-FP-NEXT:    vmovd %xmm4, (%rdx)
; AVX2-FP-NEXT:    vmovd %xmm5, (%rcx)
; AVX2-FP-NEXT:    vmovd %xmm6, (%r8)
; AVX2-FP-NEXT:    vmovd %xmm0, (%r9)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX2-FCP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX2-FCP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX2-FCP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX2-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX2-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX2-FCP-NEXT:    vmovd %xmm3, (%rsi)
; AVX2-FCP-NEXT:    vmovd %xmm4, (%rdx)
; AVX2-FCP-NEXT:    vmovd %xmm5, (%rcx)
; AVX2-FCP-NEXT:    vmovd %xmm6, (%r8)
; AVX2-FCP-NEXT:    vmovd %xmm0, (%r9)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512-NEXT:    vmovd %xmm3, (%rsi)
; AVX512-NEXT:    vmovd %xmm4, (%rdx)
; AVX512-NEXT:    vmovd %xmm5, (%rcx)
; AVX512-NEXT:    vmovd %xmm6, (%r8)
; AVX512-NEXT:    vmovd %xmm0, (%r9)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512-FCP-NEXT:    vmovd %xmm3, (%rsi)
; AVX512-FCP-NEXT:    vmovd %xmm4, (%rdx)
; AVX512-FCP-NEXT:    vmovd %xmm5, (%rcx)
; AVX512-FCP-NEXT:    vmovd %xmm6, (%r8)
; AVX512-FCP-NEXT:    vmovd %xmm0, (%r9)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512DQ-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512DQ-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-NEXT:    vmovd %xmm3, (%rsi)
; AVX512DQ-NEXT:    vmovd %xmm4, (%rdx)
; AVX512DQ-NEXT:    vmovd %xmm5, (%rcx)
; AVX512DQ-NEXT:    vmovd %xmm6, (%r8)
; AVX512DQ-NEXT:    vmovd %xmm0, (%r9)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512DQ-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-FCP-NEXT:    vmovd %xmm3, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovd %xmm4, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovd %xmm5, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovd %xmm6, (%r8)
; AVX512DQ-FCP-NEXT:    vmovd %xmm0, (%r9)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512BW-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512BW-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    vmovd %xmm3, (%rsi)
; AVX512BW-NEXT:    vmovd %xmm4, (%rdx)
; AVX512BW-NEXT:    vmovd %xmm5, (%rcx)
; AVX512BW-NEXT:    vmovd %xmm6, (%r8)
; AVX512BW-NEXT:    vmovd %xmm0, (%r9)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512BW-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512BW-FCP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512BW-FCP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512BW-FCP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512BW-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512BW-FCP-NEXT:    vmovd %xmm3, (%rsi)
; AVX512BW-FCP-NEXT:    vmovd %xmm4, (%rdx)
; AVX512BW-FCP-NEXT:    vmovd %xmm5, (%rcx)
; AVX512BW-FCP-NEXT:    vmovd %xmm6, (%r8)
; AVX512BW-FCP-NEXT:    vmovd %xmm0, (%r9)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512DQ-BW-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512DQ-BW-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-NEXT:    vmovd %xmm3, (%rsi)
; AVX512DQ-BW-NEXT:    vmovd %xmm4, (%rdx)
; AVX512DQ-BW-NEXT:    vmovd %xmm5, (%rcx)
; AVX512DQ-BW-NEXT:    vmovd %xmm6, (%r8)
; AVX512DQ-BW-NEXT:    vmovd %xmm0, (%r9)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovd {{.*#+}} xmm0 = [0,5,10,15,0,0,0,0,0,0,0,0,0,0,0,0]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm4 = xmm1[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm0, %xmm4, %xmm4
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm5 = xmm1[2,3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm0, %xmm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm6 = xmm1[3,4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm0, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[4,5,6,7,8,9,10,11,12,13,14,15],xmm2[0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm3, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm4, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm5, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm6, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <20 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <20 x i8> %wide.vec, <20 x i8> poison, <4 x i32> <i32 0, i32 5, i32 10, i32 15>
  %strided.vec1 = shufflevector <20 x i8> %wide.vec, <20 x i8> poison, <4 x i32> <i32 1, i32 6, i32 11, i32 16>
  %strided.vec2 = shufflevector <20 x i8> %wide.vec, <20 x i8> poison, <4 x i32> <i32 2, i32 7, i32 12, i32 17>
  %strided.vec3 = shufflevector <20 x i8> %wide.vec, <20 x i8> poison, <4 x i32> <i32 3, i32 8, i32 13, i32 18>
  %strided.vec4 = shufflevector <20 x i8> %wide.vec, <20 x i8> poison, <4 x i32> <i32 4, i32 9, i32 14, i32 19>
  store <4 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <4 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <4 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <4 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i8_stride5_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm4
; SSE-NEXT:    movdqa 16(%rdi), %xmm3
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm6[8],xmm5[9],xmm6[9],xmm5[10],xmm6[10],xmm5[11],xmm6[11],xmm5[12],xmm6[12],xmm5[13],xmm6[13],xmm5[14],xmm6[14],xmm5[15],xmm6[15]
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    por %xmm5, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[0,0,1,1]
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm8, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm6[8],xmm8[9],xmm6[9],xmm8[10],xmm6[10],xmm8[11],xmm6[11],xmm8[12],xmm6[12],xmm8[13],xmm6[13],xmm8[14],xmm6[14],xmm8[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3],xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; SSE-NEXT:    pand %xmm9, %xmm7
; SSE-NEXT:    pandn %xmm8, %xmm9
; SSE-NEXT:    por %xmm7, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm9[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm2, %xmm7
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pslld $24, %xmm8
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,0,255,255,255,255,0,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    pand %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm9
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm6[8],xmm9[9],xmm6[9],xmm9[10],xmm6[10],xmm9[11],xmm6[11],xmm9[12],xmm6[12],xmm9[13],xmm6[13],xmm9[14],xmm6[14],xmm9[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    pandn %xmm9, %xmm10
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3],xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    por %xmm10, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm7[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm10, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [65535,65535,65535,0,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm7, %xmm10
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm9[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm11, %xmm11
; SSE-NEXT:    movdqa %xmm7, %xmm9
; SSE-NEXT:    pandn %xmm11, %xmm9
; SSE-NEXT:    por %xmm10, %xmm9
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm4, %xmm10
; SSE-NEXT:    por %xmm11, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm6[8],xmm11[9],xmm6[9],xmm11[10],xmm6[10],xmm11[11],xmm6[11],xmm11[12],xmm6[12],xmm11[13],xmm6[13],xmm11[14],xmm6[14],xmm11[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1],xmm10[2],xmm6[2],xmm10[3],xmm6[3],xmm10[4],xmm6[4],xmm10[5],xmm6[5],xmm10[6],xmm6[6],xmm10[7],xmm6[7]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[3,1],xmm11[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm10[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm11, %xmm11
; SSE-NEXT:    pand %xmm7, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm10[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm12, %xmm12
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pandn %xmm12, %xmm10
; SSE-NEXT:    por %xmm11, %xmm10
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm8[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    movq %xmm5, (%rsi)
; SSE-NEXT:    movq %xmm2, (%rdx)
; SSE-NEXT:    movq %xmm9, (%rcx)
; SSE-NEXT:    movq %xmm10, (%r8)
; SSE-NEXT:    movq %xmm7, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm3 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[0,2,4,6,8,10,12,7,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,6,11],zero,zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,2,4,6,8,10,12,9,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm0[2,7,12],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,2,4,6,8,10,1,11,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm0[3,8,13],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[0,2,4,6,8,10,3,13,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,2,4,6,8,10,5,15,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovq %xmm3, (%rsi)
; AVX-NEXT:    vmovq %xmm4, (%rdx)
; AVX-NEXT:    vmovq %xmm5, (%rcx)
; AVX-NEXT:    vmovq %xmm6, (%r8)
; AVX-NEXT:    vmovq %xmm0, (%r9)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm3, (%rsi)
; AVX2-NEXT:    vmovq %xmm4, (%rdx)
; AVX2-NEXT:    vmovq %xmm5, (%rcx)
; AVX2-NEXT:    vmovq %xmm6, (%r8)
; AVX2-NEXT:    vmovq %xmm0, (%r9)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FP-NEXT:    vmovq %xmm3, (%rsi)
; AVX2-FP-NEXT:    vmovq %xmm4, (%rdx)
; AVX2-FP-NEXT:    vmovq %xmm5, (%rcx)
; AVX2-FP-NEXT:    vmovq %xmm6, (%r8)
; AVX2-FP-NEXT:    vmovq %xmm0, (%r9)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vmovq %xmm3, (%rsi)
; AVX2-FCP-NEXT:    vmovq %xmm4, (%rdx)
; AVX2-FCP-NEXT:    vmovq %xmm5, (%rcx)
; AVX2-FCP-NEXT:    vmovq %xmm6, (%r8)
; AVX2-FCP-NEXT:    vmovq %xmm0, (%r9)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm3, (%rsi)
; AVX512-NEXT:    vmovq %xmm4, (%rdx)
; AVX512-NEXT:    vmovq %xmm5, (%rcx)
; AVX512-NEXT:    vmovq %xmm6, (%r8)
; AVX512-NEXT:    vmovq %xmm0, (%r9)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovq %xmm3, (%rsi)
; AVX512-FCP-NEXT:    vmovq %xmm4, (%rdx)
; AVX512-FCP-NEXT:    vmovq %xmm5, (%rcx)
; AVX512-FCP-NEXT:    vmovq %xmm6, (%r8)
; AVX512-FCP-NEXT:    vmovq %xmm0, (%r9)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    vmovq %xmm3, (%rsi)
; AVX512DQ-NEXT:    vmovq %xmm4, (%rdx)
; AVX512DQ-NEXT:    vmovq %xmm5, (%rcx)
; AVX512DQ-NEXT:    vmovq %xmm6, (%r8)
; AVX512DQ-NEXT:    vmovq %xmm0, (%r9)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovq %xmm3, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovq %xmm4, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovq %xmm5, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovq %xmm6, (%r8)
; AVX512DQ-FCP-NEXT:    vmovq %xmm0, (%r9)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vmovq %xmm3, (%rsi)
; AVX512BW-NEXT:    vmovq %xmm4, (%rdx)
; AVX512BW-NEXT:    vmovq %xmm5, (%rcx)
; AVX512BW-NEXT:    vmovq %xmm6, (%r8)
; AVX512BW-NEXT:    vmovq %xmm0, (%r9)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-FCP-NEXT:    vmovq %xmm3, (%rsi)
; AVX512BW-FCP-NEXT:    vmovq %xmm4, (%rdx)
; AVX512BW-FCP-NEXT:    vmovq %xmm5, (%rcx)
; AVX512BW-FCP-NEXT:    vmovq %xmm6, (%r8)
; AVX512BW-FCP-NEXT:    vmovq %xmm0, (%r9)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-BW-NEXT:    vmovq %xmm3, (%rsi)
; AVX512DQ-BW-NEXT:    vmovq %xmm4, (%rdx)
; AVX512DQ-BW-NEXT:    vmovq %xmm5, (%rcx)
; AVX512DQ-BW-NEXT:    vmovq %xmm6, (%r8)
; AVX512DQ-BW-NEXT:    vmovq %xmm0, (%r9)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm1[4,9,14],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1],xmm0[2,3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[0,5,10,15],zero,zero,zero,xmm4[3,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = zero,zero,zero,xmm1[0,5,10,15],zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm5 = xmm0[0,1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm1[1,6,11],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm1[2,7,12],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm7 = xmm2[0],xmm0[1,2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,xmm1[u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm3, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm4, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm5, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm6, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <40 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <40 x i8> %wide.vec, <40 x i8> poison, <8 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35>
  %strided.vec1 = shufflevector <40 x i8> %wide.vec, <40 x i8> poison, <8 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36>
  %strided.vec2 = shufflevector <40 x i8> %wide.vec, <40 x i8> poison, <8 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37>
  %strided.vec3 = shufflevector <40 x i8> %wide.vec, <40 x i8> poison, <8 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38>
  %strided.vec4 = shufflevector <40 x i8> %wide.vec, <40 x i8> poison, <8 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39>
  store <8 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <8 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <8 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <8 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i8_stride5_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 64(%rdi), %xmm9
; SSE-NEXT:    movdqa (%rdi), %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm6
; SSE-NEXT:    movdqa 32(%rdi), %xmm10
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    pxor %xmm8, %xmm8
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm8[8],xmm4[9],xmm8[9],xmm4[10],xmm8[10],xmm4[11],xmm8[11],xmm4[12],xmm8[12],xmm4[13],xmm8[13],xmm4[14],xmm8[14],xmm4[15],xmm8[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm4 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    movdqa %xmm4, %xmm5
; SSE-NEXT:    pandn %xmm6, %xmm5
; SSE-NEXT:    movdqa %xmm6, %xmm15
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm13
; SSE-NEXT:    pand %xmm4, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm8[0],xmm5[1],xmm8[1],xmm5[2],xmm8[2],xmm5[3],xmm8[3],xmm5[4],xmm8[4],xmm5[5],xmm8[5],xmm5[6],xmm8[6],xmm5[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm8[8],xmm6[9],xmm8[9],xmm6[10],xmm8[10],xmm6[11],xmm8[11],xmm6[12],xmm8[12],xmm6[13],xmm8[13],xmm6[14],xmm8[14],xmm6[15],xmm8[15]
; SSE-NEXT:    pand %xmm7, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm7
; SSE-NEXT:    por %xmm6, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm7[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm5[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pand %xmm11, %xmm7
; SSE-NEXT:    movdqa %xmm11, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm5, %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    movdqa %xmm9, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm9[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm9[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    pandn %xmm10, %xmm7
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm8[8],xmm12[9],xmm8[9],xmm12[10],xmm8[10],xmm12[11],xmm8[11],xmm12[12],xmm8[12],xmm12[13],xmm8[13],xmm12[14],xmm8[14],xmm12[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3],xmm0[4],xmm8[4],xmm0[5],xmm8[5],xmm0[6],xmm8[6],xmm0[7],xmm8[7]
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm12[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm12[2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm12
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    pandn %xmm13, %xmm12
; SSE-NEXT:    movdqa %xmm15, %xmm13
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    movdqa %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm14, %xmm13
; SSE-NEXT:    por %xmm12, %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm12
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm8[8],xmm12[9],xmm8[9],xmm12[10],xmm8[10],xmm12[11],xmm8[11],xmm12[12],xmm8[12],xmm12[13],xmm8[13],xmm12[14],xmm8[14],xmm12[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm8[0],xmm13[1],xmm8[1],xmm13[2],xmm8[2],xmm13[3],xmm8[3],xmm13[4],xmm8[4],xmm13[5],xmm8[5],xmm13[6],xmm8[6],xmm13[7],xmm8[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    pand %xmm15, %xmm13
; SSE-NEXT:    pandn %xmm12, %xmm15
; SSE-NEXT:    por %xmm13, %xmm15
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm15[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm12 = xmm12[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm12 = xmm12[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm12 = xmm12[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm12, %xmm12
; SSE-NEXT:    pand %xmm11, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm0
; SSE-NEXT:    packuswb %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    pand %xmm6, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm9[3,0]
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm7[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm12, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,0,255,255,255,255,0,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pand %xmm12, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm13, %xmm15
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE-NEXT:    pand %xmm13, %xmm2
; SSE-NEXT:    por %xmm15, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [0,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pandn %xmm0, %xmm15
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pandn %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm11, %xmm7
; SSE-NEXT:    pand %xmm14, %xmm7
; SSE-NEXT:    pandn %xmm10, %xmm14
; SSE-NEXT:    pand %xmm12, %xmm11
; SSE-NEXT:    pandn %xmm10, %xmm12
; SSE-NEXT:    pand %xmm4, %xmm10
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm8[8],xmm0[9],xmm8[9],xmm0[10],xmm8[10],xmm0[11],xmm8[11],xmm0[12],xmm8[12],xmm0[13],xmm8[13],xmm0[14],xmm8[14],xmm0[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm8[0],xmm10[1],xmm8[1],xmm10[2],xmm8[2],xmm10[3],xmm8[3],xmm10[4],xmm8[4],xmm10[5],xmm8[5],xmm10[6],xmm8[6],xmm10[7],xmm8[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm10[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,0],xmm0[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm10[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    por %xmm15, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm2[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm0[0],xmm10[1],xmm0[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm10[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm10
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    por %xmm1, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1],xmm0[2,0]
; SSE-NEXT:    por %xmm7, %xmm14
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm14 = xmm14[8],xmm1[8],xmm14[9],xmm1[9],xmm14[10],xmm1[10],xmm14[11],xmm1[11],xmm14[12],xmm1[12],xmm14[13],xmm1[13],xmm14[14],xmm1[14],xmm14[15],xmm1[15]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[3,1],xmm0[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm14[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm3[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm7, %xmm7
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movaps %xmm9, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm2[3,0]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm7[0,2]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pandn %xmm1, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    por %xmm11, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm8[8],xmm1[9],xmm8[9],xmm1[10],xmm8[10],xmm1[11],xmm8[11],xmm1[12],xmm8[12],xmm1[13],xmm8[13],xmm1[14],xmm8[14],xmm1[15],xmm8[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm12 = xmm12[0],xmm8[0],xmm12[1],xmm8[1],xmm12[2],xmm8[2],xmm12[3],xmm8[3],xmm12[4],xmm8[4],xmm12[5],xmm8[5],xmm12[6],xmm8[6],xmm12[7],xmm8[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm12[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,3],xmm1[1,2]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm8[0],xmm1[1],xmm8[1],xmm1[2],xmm8[2],xmm1[3],xmm8[3],xmm1[4],xmm8[4],xmm1[5],xmm8[5],xmm1[6],xmm8[6],xmm1[7],xmm8[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm8[8],xmm4[9],xmm8[9],xmm4[10],xmm8[10],xmm4[11],xmm8[11],xmm4[12],xmm8[12],xmm4[13],xmm8[13],xmm4[14],xmm8[14],xmm4[15],xmm8[15]
; SSE-NEXT:    pand %xmm13, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm12[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    por %xmm4, %xmm13
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm13[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[3,1,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movdqa %xmm10, (%rcx)
; SSE-NEXT:    movdqa %xmm6, (%r8)
; SSE-NEXT:    movaps %xmm4, (%r9)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm1
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm0[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm3[u,u,u,u,u,u,u],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[u,u,u,u,u,u,u,3,8,13],zero,zero,zero,xmm1[u,u,u]
; AVX-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vmovq {{.*#+}} xmm6 = [255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpblendvb %xmm6, %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm7 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX-NEXT:    vpshufb %xmm7, %xmm4, %xmm5
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[1,6,11]
; AVX-NEXT:    vpor %xmm5, %xmm8, %xmm5
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm0[1,6,11],zero,zero,zero,zero,xmm0[u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm2[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = xmm3[u,u,u,u,u,u,u],zero,zero,zero,xmm3[3,8,13,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm10 = xmm1[u,u,u,u,u,u,u,4,9,14],zero,zero,zero,xmm1[u,u,u]
; AVX-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX-NEXT:    vpblendvb %xmm6, %xmm8, %xmm9, %xmm6
; AVX-NEXT:    vpshufb %xmm7, %xmm6, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[2,7,12]
; AVX-NEXT:    vpor %xmm6, %xmm8, %xmm6
; AVX-NEXT:    vmovdqa {{.*#+}} xmm8 = [128,128,128,1,6,11,128,128,128,128,4,9,14,u,u,u]
; AVX-NEXT:    vpshufb %xmm8, %xmm2, %xmm9
; AVX-NEXT:    vpshufb %xmm8, %xmm3, %xmm8
; AVX-NEXT:    vpblendw {{.*#+}} xmm8 = xmm9[0,1,2],xmm8[3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [2,7,12,128,128,128,0,5,10,15,128,128,128,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm0, %xmm10
; AVX-NEXT:    vpshufb %xmm9, %xmm1, %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0,1,2],xmm9[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm8, %xmm9, %xmm8
; AVX-NEXT:    vpshufb %xmm7, %xmm8, %xmm8
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[3,8,13]
; AVX-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [128,128,128,2,7,12,1,6,11,128,128,128,128,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm2, %xmm10
; AVX-NEXT:    vpshufb %xmm9, %xmm1, %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm9 = xmm10[0,1,2],xmm9[3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm10 = [3,8,13,128,128,128,128,128,128,0,5,10,15,u,u,u]
; AVX-NEXT:    vpshufb %xmm10, %xmm0, %xmm11
; AVX-NEXT:    vpshufb %xmm10, %xmm3, %xmm10
; AVX-NEXT:    vpblendw {{.*#+}} xmm10 = xmm11[0,1,2],xmm10[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm9, %xmm10, %xmm9
; AVX-NEXT:    vpshufb %xmm7, %xmm9, %xmm7
; AVX-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[4,9,14]
; AVX-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [128,128,128,3,8,13,128,128,128,1,6,11,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm3, %xmm3
; AVX-NEXT:    vpshufb %xmm9, %xmm2, %xmm2
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[3,4,5],xmm2[6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,9,14,128,128,128,2,7,12,128,128,128,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3,4,5],xmm0[6,7]
; AVX-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5],xmm1[6,7]
; AVX-NEXT:    vmovdqa %xmm5, (%rsi)
; AVX-NEXT:    vmovdqa %xmm6, (%rdx)
; AVX-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX-NEXT:    vmovdqa %xmm7, (%r8)
; AVX-NEXT:    vmovdqa %xmm0, (%r9)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX2-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm3
; AVX2-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[1,6,11]
; AVX2-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm5 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-NEXT:    vpshufb %xmm4, %xmm5, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[2,7,12]
; AVX2-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm6 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm6
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-NEXT:    vpshufb %xmm4, %xmm6, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[3,8,13]
; AVX2-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX2-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-NEXT:    vpshufb %xmm4, %xmm7, %xmm4
; AVX2-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[4,9,14]
; AVX2-NEXT:    vpor %xmm7, %xmm4, %xmm4
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,12],zero,zero,zero,xmm0[u,u,u,u]
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX2-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX2-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX2-NEXT:    vmovdqa %xmm4, (%r8)
; AVX2-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-FP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX2-FP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm2, %xmm3
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[1,6,11]
; AVX2-FP-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm5 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-FP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[2,7,12]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm6 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm6
; AVX2-FP-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX2-FP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm6, %xmm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[3,8,13]
; AVX2-FP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm7
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX2-FP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm7, %xmm4
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[4,9,14]
; AVX2-FP-NEXT:    vpor %xmm7, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,12],zero,zero,zero,xmm0[u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX2-FP-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %xmm4, (%r8)
; AVX2-FP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm2, %xmm3
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[1,6,11]
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm5 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm1, %ymm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[2,7,12]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm6 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm6
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm6, %xmm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[3,8,13]
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm7
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm7, %xmm4
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[4,9,14]
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[4,9,14],zero,zero,zero,xmm0[2,7,12],zero,zero,zero,xmm0[u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm2[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX2-FCP-NEXT:    vmovdqa %xmm3, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %xmm4, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[u,u,u]
; AVX512-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[1,6,11]
; AVX512-NEXT:    vpor %xmm6, %xmm2, %xmm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-NEXT:    vmovdqa %ymm2, %ymm7
; AVX512-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm7
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13,u,u,u]
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[2,7,12]
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm8
; AVX512-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[1,6,11],zero,zero,zero,zero,xmm9[4,9,14,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,7,12],zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[u,u,u]
; AVX512-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512-NEXT:    vpshufb %xmm3, %xmm8, %xmm8
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[3,8,13]
; AVX512-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[0,5,10,15,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX512-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[4,9,14]
; AVX512-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm2
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[3]
; AVX512-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512-FCP-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm0
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[1,6,11]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm2, %xmm6
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[2,7,12]
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm8
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[1,6,11],zero,zero,zero,zero,xmm9[4,9,14,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,7,12],zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm8, %xmm8
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[3,8,13]
; AVX512-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[0,5,10,15,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX512-FCP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[4,9,14]
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm2
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[3]
; AVX512-FCP-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512-FCP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512DQ-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm0
; AVX512DQ-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[1,6,11]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm2, %xmm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa %ymm2, %ymm7
; AVX512DQ-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[2,7,12]
; AVX512DQ-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm8
; AVX512DQ-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[1,6,11],zero,zero,zero,zero,xmm9[4,9,14,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,7,12],zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm8, %xmm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[3,8,13]
; AVX512DQ-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[0,5,10,15,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX512DQ-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[4,9,14]
; AVX512DQ-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm2
; AVX512DQ-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[3]
; AVX512DQ-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX512DQ-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX512DQ-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX512DQ-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512DQ-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm1 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm4
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm0
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm0, %xmm2
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[1,6,11]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm2, %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, %ymm7
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm4, %ymm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm7, %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[2,7,12]
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm8
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,xmm9[1,6,11],zero,zero,zero,zero,xmm9[4,9,14,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[2,7,12],zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm8, %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[3,8,13]
; AVX512DQ-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[0,5,10,15,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm9, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm0[4,9,14]
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm4, %ymm5, %ymm2
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[3]
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm7, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm8, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm2 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512BW-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[1,6,11]
; AVX512BW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm5 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX512BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[2,7,12]
; AVX512BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm6 {%k3}
; AVX512BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[3,8,13]
; AVX512BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm7 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX512BW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[4,9,14]
; AVX512BW-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX512BW-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[1,6,11,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,9,14],zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX512BW-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512BW-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX512BW-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX512BW-NEXT:    vmovdqa %xmm3, (%r8)
; AVX512BW-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm2 {%k1}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512BW-FCP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[1,6,11]
; AVX512BW-FCP-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm5 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-FCP-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[2,7,12]
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm6 {%k3}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[3,8,13]
; AVX512BW-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm7 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512BW-FCP-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[4,9,14]
; AVX512BW-FCP-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k2}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[1,6,11,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,9,14],zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX512BW-FCP-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm3, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512DQ-BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm2 {%k1}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512DQ-BW-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[1,6,11]
; AVX512DQ-BW-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm5 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[2,7,12]
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm6 {%k3}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512DQ-BW-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[3,8,13]
; AVX512DQ-BW-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm7 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-BW-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[4,9,14]
; AVX512DQ-BW-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k2}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[1,6,11,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,9,14],zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX512DQ-BW-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm3, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,xmm3[4,9,14],zero,zero,zero,xmm3[2,7,12,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[0,5,10,15],zero,zero,zero,xmm2[3,8,13],zero,zero,zero,xmm2[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,128,128,128]
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[1,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm5, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm5 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[2,7,12]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm6 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm6, %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[4,9,14,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[2,7,12],zero,zero,zero,xmm6[0,5,10,15],zero,zero,zero,xmm6[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[3,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm7 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[3,8,13],zero,zero,zero,xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,xmm7[2,7,12],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpshufb %xmm3, %xmm7, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[4,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm7, %xmm3, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm0, %ymm1 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm0[3,8,13],zero,zero,zero,xmm0[1,6,11,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,9,14],zero,zero,zero,xmm1[2,7,12],zero,zero,zero,xmm1[u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm4[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm2, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm6, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm3, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %xmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <80 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <80 x i8> %wide.vec, <80 x i8> poison, <16 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75>
  %strided.vec1 = shufflevector <80 x i8> %wide.vec, <80 x i8> poison, <16 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76>
  %strided.vec2 = shufflevector <80 x i8> %wide.vec, <80 x i8> poison, <16 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77>
  %strided.vec3 = shufflevector <80 x i8> %wide.vec, <80 x i8> poison, <16 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78>
  %strided.vec4 = shufflevector <80 x i8> %wide.vec, <80 x i8> poison, <16 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79>
  store <16 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <16 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <16 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <16 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i8_stride5_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $184, %rsp
; SSE-NEXT:    movdqa (%rdi), %xmm9
; SSE-NEXT:    movdqa 16(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm5
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1],xmm0[2],xmm5[2],xmm0[3],xmm5[3],xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm5[8],xmm1[9],xmm5[9],xmm1[10],xmm5[10],xmm1[11],xmm5[11],xmm1[12],xmm5[12],xmm1[13],xmm5[13],xmm1[14],xmm5[14],xmm1[15],xmm5[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,0,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pandn %xmm9, %xmm11
; SSE-NEXT:    movdqa {{.*#+}} xmm14 = [255,255,0,255,255,255,255,0,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm9
; SSE-NEXT:    por %xmm1, %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3],xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm5[8],xmm9[9],xmm5[9],xmm9[10],xmm5[10],xmm9[11],xmm5[11],xmm9[12],xmm5[12],xmm9[13],xmm5[13],xmm9[14],xmm5[14],xmm9[15],xmm5[15]
; SSE-NEXT:    pand %xmm1, %xmm9
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm9[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm13, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa 64(%rdi), %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pxor %xmm0, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm0[0],xmm3[1],xmm0[1],xmm3[2],xmm0[2],xmm3[3],xmm0[3],xmm3[4],xmm0[4],xmm3[5],xmm0[5],xmm3[6],xmm0[6],xmm3[7],xmm0[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    pand %xmm9, %xmm2
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm10
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm10, %xmm0
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 128(%rdi), %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1],xmm0[2],xmm5[2],xmm0[3],xmm5[3],xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm5[8],xmm2[9],xmm5[9],xmm2[10],xmm5[10],xmm2[11],xmm5[11],xmm2[12],xmm5[12],xmm2[13],xmm5[13],xmm2[14],xmm5[14],xmm2[15],xmm5[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,3]
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa 96(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa 80(%rdi), %xmm6
; SSE-NEXT:    movdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1],xmm0[2],xmm5[2],xmm0[3],xmm5[3],xmm0[4],xmm5[4],xmm0[5],xmm5[5],xmm0[6],xmm5[6],xmm0[7],xmm5[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm5[8],xmm6[9],xmm5[9],xmm6[10],xmm5[10],xmm6[11],xmm5[11],xmm6[12],xmm5[12],xmm6[13],xmm5[13],xmm6[14],xmm5[14],xmm6[15],xmm5[15]
; SSE-NEXT:    pand %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm6, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm1[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movdqa 144(%rdi), %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3],xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm5[8],xmm12[9],xmm5[9],xmm12[10],xmm5[10],xmm12[11],xmm5[11],xmm12[12],xmm5[12],xmm12[13],xmm5[13],xmm12[14],xmm5[14],xmm12[15],xmm5[15]
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm5[8],xmm0[9],xmm5[9],xmm0[10],xmm5[10],xmm0[11],xmm5[11],xmm0[12],xmm5[12],xmm0[13],xmm5[13],xmm0[14],xmm5[14],xmm0[15],xmm5[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3],xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm0[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm1
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm5[8],xmm6[9],xmm5[9],xmm6[10],xmm5[10],xmm6[11],xmm5[11],xmm6[12],xmm5[12],xmm6[13],xmm5[13],xmm6[14],xmm5[14],xmm6[15],xmm5[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm6, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3],xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm6[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm2[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm6[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm15, %xmm2
; SSE-NEXT:    pandn %xmm10, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pand %xmm15, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm5[8],xmm2[9],xmm5[9],xmm2[10],xmm5[10],xmm2[11],xmm5[11],xmm2[12],xmm5[12],xmm2[13],xmm5[13],xmm2[14],xmm5[14],xmm2[15],xmm5[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3],xmm1[4],xmm5[4],xmm1[5],xmm5[5],xmm1[6],xmm5[6],xmm1[7],xmm5[7]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,0],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm6[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm1
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm2
; SSE-NEXT:    movdqa (%rsp), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm8, %xmm6
; SSE-NEXT:    pand %xmm13, %xmm6
; SSE-NEXT:    por %xmm2, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm5[8],xmm2[9],xmm5[9],xmm2[10],xmm5[10],xmm2[11],xmm5[11],xmm2[12],xmm5[12],xmm2[13],xmm5[13],xmm2[14],xmm5[14],xmm2[15],xmm5[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3],xmm6[4],xmm5[4],xmm6[5],xmm5[5],xmm6[6],xmm5[6],xmm6[7],xmm5[7]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm12[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm14, %xmm4
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm5[8],xmm2[9],xmm5[9],xmm2[10],xmm5[10],xmm2[11],xmm5[11],xmm2[12],xmm5[12],xmm2[13],xmm5[13],xmm2[14],xmm5[14],xmm2[15],xmm5[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3],xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    movdqa %xmm13, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pandn %xmm11, %xmm6
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    pandn %xmm11, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm11
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm5[8],xmm0[9],xmm5[9],xmm0[10],xmm5[10],xmm0[11],xmm5[11],xmm0[12],xmm5[12],xmm0[13],xmm5[13],xmm0[14],xmm5[14],xmm0[15],xmm5[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm5[0],xmm11[1],xmm5[1],xmm11[2],xmm5[2],xmm11[3],xmm5[3],xmm11[4],xmm5[4],xmm11[5],xmm5[5],xmm11[6],xmm5[6],xmm11[7],xmm5[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm13 = xmm11[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0],xmm0[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm11[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm13[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm11
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    por %xmm2, %xmm11
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm11, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm15
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm5[8],xmm0[9],xmm5[9],xmm0[10],xmm5[10],xmm0[11],xmm5[11],xmm0[12],xmm5[12],xmm0[13],xmm5[13],xmm0[14],xmm5[14],xmm0[15],xmm5[15]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1],xmm2[2],xmm5[2],xmm2[3],xmm5[3],xmm2[4],xmm5[4],xmm2[5],xmm5[5],xmm2[6],xmm5[6],xmm2[7],xmm5[7]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    por %xmm11, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm13
; SSE-NEXT:    pandn %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pand %xmm12, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pandn %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm14, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm8, %xmm14
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm11
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm1[8],xmm11[9],xmm1[9],xmm11[10],xmm1[10],xmm11[11],xmm1[11],xmm11[12],xmm1[12],xmm11[13],xmm1[13],xmm11[14],xmm1[14],xmm11[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm1[0],xmm8[1],xmm1[1],xmm8[2],xmm1[2],xmm8[3],xmm1[3],xmm8[4],xmm1[4],xmm8[5],xmm1[5],xmm8[6],xmm1[6],xmm8[7],xmm1[7]
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm8[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm11[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm8[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm11[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm8, %xmm1
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm13, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm4[1,1,1,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm11 = xmm11[0],xmm8[0],xmm11[1],xmm8[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm11[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm8, %xmm11
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    por %xmm1, %xmm12
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm13 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    pand %xmm13, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm2[8],xmm11[9],xmm2[9],xmm11[10],xmm2[10],xmm11[11],xmm2[11],xmm11[12],xmm2[12],xmm11[13],xmm2[13],xmm11[14],xmm2[14],xmm11[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1],xmm11[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm6[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm0[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm6[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm0, %xmm6
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm6, %xmm8
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    por %xmm1, %xmm8
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    pand %xmm13, %xmm15
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm15, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm6[8],xmm1[9],xmm6[9],xmm1[10],xmm6[10],xmm1[11],xmm6[11],xmm1[12],xmm6[12],xmm1[13],xmm6[13],xmm1[14],xmm6[14],xmm1[15],xmm6[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por %xmm7, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm6[0],xmm1[1],xmm6[1],xmm1[2],xmm6[2],xmm1[3],xmm6[3],xmm1[4],xmm6[4],xmm1[5],xmm6[5],xmm1[6],xmm6[6],xmm1[7],xmm6[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm6[8],xmm2[9],xmm6[9],xmm2[10],xmm6[10],xmm2[11],xmm6[11],xmm2[12],xmm6[12],xmm2[13],xmm6[13],xmm2[14],xmm6[14],xmm2[15],xmm6[15]
; SSE-NEXT:    pxor %xmm13, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1],xmm1[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm6, %xmm6
; SSE-NEXT:    pandn %xmm6, %xmm2
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm5[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm2[0,2]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm5[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm9
; SSE-NEXT:    por %xmm1, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm13[8],xmm1[9],xmm13[9],xmm1[10],xmm13[10],xmm1[11],xmm13[11],xmm1[12],xmm13[12],xmm1[13],xmm13[13],xmm1[14],xmm13[14],xmm1[15],xmm13[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1],xmm0[2],xmm13[2],xmm0[3],xmm13[3],xmm0[4],xmm13[4],xmm0[5],xmm13[5],xmm0[6],xmm13[6],xmm0[7],xmm13[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm1[1,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm6
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm13[0],xmm0[1],xmm13[1],xmm0[2],xmm13[2],xmm0[3],xmm13[3],xmm0[4],xmm13[4],xmm0[5],xmm13[5],xmm0[6],xmm13[6],xmm0[7],xmm13[7]
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm13[8],xmm2[9],xmm13[9],xmm2[10],xmm13[10],xmm2[11],xmm13[11],xmm2[12],xmm13[12],xmm2[13],xmm13[13],xmm2[14],xmm13[14],xmm2[15],xmm13[15]
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    por %xmm11, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Folded Reload
; SSE-NEXT:    # xmm6 = mem[3,1,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    packuswb %xmm1, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm10[2,1]
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm13[8],xmm1[9],xmm13[9],xmm1[10],xmm13[10],xmm1[11],xmm13[11],xmm1[12],xmm13[12],xmm1[13],xmm13[13],xmm1[14],xmm13[14],xmm1[15],xmm13[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm13[0],xmm14[1],xmm13[1],xmm14[2],xmm13[2],xmm14[3],xmm13[3],xmm14[4],xmm13[4],xmm14[5],xmm13[5],xmm14[6],xmm13[6],xmm14[7],xmm13[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm14[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,3],xmm1[1,2]
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm0, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm13[0],xmm1[1],xmm13[1],xmm1[2],xmm13[2],xmm1[3],xmm13[3],xmm1[4],xmm13[4],xmm1[5],xmm13[5],xmm1[6],xmm13[6],xmm1[7],xmm13[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm13[8],xmm5[9],xmm13[9],xmm5[10],xmm13[10],xmm5[11],xmm13[11],xmm5[12],xmm13[12],xmm5[13],xmm13[13],xmm5[14],xmm13[14],xmm5[15],xmm13[15]
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm3[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm14[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm6[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[3,1,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm15[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; SSE-NEXT:    packuswb %xmm3, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movdqa %xmm12, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movdqa %xmm9, 16(%r8)
; SSE-NEXT:    movdqa %xmm8, (%r8)
; SSE-NEXT:    movaps %xmm1, 16(%r9)
; SSE-NEXT:    movaps %xmm2, (%r9)
; SSE-NEXT:    addq $184, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa 144(%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[1,6,11]
; AVX-NEXT:    vmovdqa 128(%rdi), %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm5
; AVX-NEXT:    vmovdqa 112(%rdi), %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm2[u,u,u,u],zero,zero,zero,xmm2[3,8,13,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa 96(%rdi), %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,4,9,14],zero,zero,zero,xmm3[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm4, %xmm6, %xmm4
; AVX-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm4[2,3,4,5,6,7]
; AVX-NEXT:    vmovdqa 80(%rdi), %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm4[0,5,10,15],zero,zero,zero,zero,zero,zero,xmm4[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm7, %xmm6, %xmm6
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2,3,4],xmm5[5,6,7]
; AVX-NEXT:    vmovdqa (%rdi), %xmm7
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm9
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm8
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm10
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm9[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm11[2],xmm5[2],xmm11[3],xmm5[3]
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[u,u,u,u,u,u,u],zero,zero,zero,xmm10[2,7,12,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,3,8,13],zero,zero,zero,xmm8[u,u,u]
; AVX-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX-NEXT:    vmovq {{.*#+}} xmm13 = [255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpblendvb %xmm13, %xmm5, %xmm11, %xmm5
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX-NEXT:    vandps %ymm5, %ymm12, %ymm11
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11]
; AVX-NEXT:    vandnps %ymm14, %ymm12, %ymm14
; AVX-NEXT:    vorps %ymm14, %ymm11, %ymm11
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm11, %ymm6
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm11 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[2,7,12]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm1[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX-NEXT:    vpor %xmm11, %xmm14, %xmm11
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm9[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm10[u,u,u,u,u,u,u],zero,zero,zero,xmm10[3,8,13,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm6 = xmm8[u,u,u,u,u,u,u,4,9,14],zero,zero,zero,xmm8[u,u,u]
; AVX-NEXT:    vpor %xmm6, %xmm15, %xmm6
; AVX-NEXT:    vpblendvb %xmm13, %xmm14, %xmm6, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[u,u,u],zero,zero,zero,zero,xmm2[4,9,14,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,0,5,10,15],zero,zero,zero,xmm3[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm13, %xmm14, %xmm14
; AVX-NEXT:    vmovdqa {{.*#+}} xmm13 = [128,128,128,3,4,5,6,7,8,9,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm13, %xmm14, %xmm14
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm4[1,6,11],zero,zero,zero,zero,zero,zero,zero,xmm4[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX-NEXT:    vpblendw {{.*#+}} xmm11 = xmm14[0,1,2,3,4],xmm11[5,6,7]
; AVX-NEXT:    vandps %ymm6, %ymm12, %ymm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12]
; AVX-NEXT:    vandnps %ymm14, %ymm12, %ymm14
; AVX-NEXT:    vorps %ymm6, %ymm14, %ymm6
; AVX-NEXT:    vinsertf128 $1, %xmm11, %ymm6, %ymm6
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,1,6,11,128,128,128,128,4,9,14,u,u,u]
; AVX-NEXT:    vpshufb %xmm6, %xmm9, %xmm14
; AVX-NEXT:    vpshufb %xmm6, %xmm10, %xmm6
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm14[0,1,2],xmm6[3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm14 = [2,7,12,128,128,128,0,5,10,15,128,128,128,u,u,u]
; AVX-NEXT:    vpshufb %xmm14, %xmm7, %xmm15
; AVX-NEXT:    vpshufb %xmm14, %xmm8, %xmm14
; AVX-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0,1,2],xmm14[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm6, %xmm14, %xmm6
; AVX-NEXT:    vandps %ymm6, %ymm12, %ymm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13]
; AVX-NEXT:    vandnps %ymm14, %ymm12, %ymm12
; AVX-NEXT:    vorps %ymm6, %ymm12, %ymm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm12 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[3,8,13]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm1[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX-NEXT:    vpor %xmm12, %xmm14, %xmm12
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,1,6,11],zero,zero,zero,zero,xmm3[u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm2[u,u,u],zero,zero,zero,xmm2[0,5,10,15,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX-NEXT:    vpshufb %xmm13, %xmm14, %xmm13
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm4[2,7,12],zero,zero,zero,zero,zero,zero,zero,xmm4[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX-NEXT:    vpblendw {{.*#+}} xmm12 = xmm13[0,1,2,3,4],xmm12[5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm6, %ymm12
; AVX-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,2,7,12,1,6,11,128,128,128,128,u,u,u]
; AVX-NEXT:    vpshufb %xmm6, %xmm9, %xmm13
; AVX-NEXT:    vpshufb %xmm6, %xmm8, %xmm6
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm13[0,1,2],xmm6[3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm13 = [3,8,13,128,128,128,128,128,128,0,5,10,15,u,u,u]
; AVX-NEXT:    vpshufb %xmm13, %xmm7, %xmm14
; AVX-NEXT:    vpshufb %xmm13, %xmm10, %xmm13
; AVX-NEXT:    vpblendw {{.*#+}} xmm13 = xmm14[0,1,2],xmm13[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm6, %xmm13, %xmm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm2[u,u,u],zero,zero,zero,xmm2[1,6,11,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm3[u,u,u,2,7,12],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm13, %xmm14, %xmm14
; AVX-NEXT:    vmovdqa {{.*#+}} xmm13 = [128,128,128,3,4,5,6,7,8,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm13, %xmm14, %xmm14
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm4[3,8,13],zero,zero,zero,zero,zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14]
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm15, %ymm14
; AVX-NEXT:    vmovaps {{.*#+}} ymm15 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255]
; AVX-NEXT:    vandps %ymm6, %ymm15, %ymm6
; AVX-NEXT:    vandnps %ymm14, %ymm15, %ymm14
; AVX-NEXT:    vorps %ymm6, %ymm14, %ymm6
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm0[4,9,14]
; AVX-NEXT:    vpshufb {{.*#+}} xmm15 = xmm1[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX-NEXT:    vpor %xmm14, %xmm15, %xmm14
; AVX-NEXT:    vextractf128 $1, %ymm6, %xmm15
; AVX-NEXT:    vpmovsxwq {{.*#+}} xmm11 = [18446744073709551615,255]
; AVX-NEXT:    vpblendvb %xmm11, %xmm15, %xmm14, %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm6, %ymm6
; AVX-NEXT:    vmovdqa {{.*#+}} xmm14 = [128,128,128,3,8,13,128,128,128,1,6,11,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm14, %xmm10, %xmm10
; AVX-NEXT:    vpshufb %xmm14, %xmm9, %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm9 = xmm9[0,1,2],xmm10[3,4,5],xmm9[6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm10 = [4,9,14,128,128,128,2,7,12,128,128,128,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm10, %xmm8, %xmm8
; AVX-NEXT:    vpshufb %xmm10, %xmm7, %xmm7
; AVX-NEXT:    vpblendw {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3,4,5],xmm7[6,7]
; AVX-NEXT:    vpor %xmm7, %xmm9, %xmm7
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,zero,xmm2[2,7,12,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,3,8,13],zero,zero,zero,xmm3[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpshufb %xmm13, %xmm2, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm4[4,9,14],zero,zero,zero,zero,zero,zero,xmm4[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,1,6,11],zero,zero,zero,zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[0,5,10,15]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpblendvb %xmm11, %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rdx)
; AVX-NEXT:    vmovaps %ymm12, (%rcx)
; AVX-NEXT:    vmovaps %ymm6, (%r8)
; AVX-NEXT:    vmovaps %ymm0, (%r9)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm3, %ymm4, %ymm5
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX2-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm6
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX2-NEXT:    vpmovsxwd {{.*#+}} ymm8 = [4294967295,4294967295,4294967295,255,0,0,0,0]
; AVX2-NEXT:    vmovdqa %xmm8, %xmm7
; AVX2-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm6
; AVX2-NEXT:    vpblendvb %ymm9, %ymm3, %ymm4, %ymm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm10
; AVX2-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm5, %ymm10, %ymm5
; AVX2-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX2-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm10 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm11
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm9, %ymm11, %ymm7
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm11
; AVX2-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-NEXT:    vpblendvb %ymm10, %ymm4, %ymm3, %ymm10
; AVX2-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX2-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX2-NEXT:    vpor %xmm12, %xmm10, %xmm10
; AVX2-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendvb %ymm8, %ymm10, %ymm11, %ymm10
; AVX2-NEXT:    vmovdqa 144(%rdi), %xmm8
; AVX2-NEXT:    vpshufb {{.*#+}} xmm11 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[1,6,11]
; AVX2-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-NEXT:    vmovdqa 128(%rdi), %xmm3
; AVX2-NEXT:    vpshufb {{.*#+}} xmm4 = xmm3[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX2-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vpblendw {{.*#+}} ymm4 = ymm6[0,1,2,3,4],ymm4[5,6,7],ymm6[8,9,10,11,12],ymm4[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm8[4,9,14]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX2-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm10, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm6
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[3,8,13],zero,zero,zero,xmm6[1,6,11,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12],zero,zero,zero,xmm9[u,u,u,u]
; AVX2-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm9
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3,4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} ymm6 = ymm9[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [0,5,0,5,0,5,0,5]
; AVX2-NEXT:    vpermd %ymm6, %ymm9, %ymm6
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm6, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[2,7,12]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX2-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-NEXT:    vpblendw {{.*#+}} ymm2 = ymm5[0,1,2,3,4],ymm2[5,6,7],ymm5[8,9,10,11,12],ymm2[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm5 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[3,8,13]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX2-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm7[0,1,2,3,4],ymm3[5,6,7],ymm7[8,9,10,11,12],ymm3[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm1, (%r8)
; AVX2-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm3, %ymm4, %ymm5
; AVX2-FP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm6
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-FP-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpmovsxwd {{.*#+}} ymm8 = [4294967295,4294967295,4294967295,255,0,0,0,0]
; AVX2-FP-NEXT:    vmovdqa %xmm8, %xmm7
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm6
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm3, %ymm4, %ymm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-FP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-FP-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm10, %ymm5
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-FP-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX2-FP-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm10 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-FP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm9, %ymm11, %ymm7
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm11
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-FP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FP-NEXT:    vpblendvb %ymm10, %ymm4, %ymm3, %ymm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX2-FP-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm12, %xmm10, %xmm10
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendvb %ymm8, %ymm10, %ymm11, %ymm10
; AVX2-FP-NEXT:    vmovdqa 144(%rdi), %xmm8
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[1,6,11]
; AVX2-FP-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %xmm3
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm3[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX2-FP-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm6[0,1,2,3,4],ymm4[5,6,7],ymm6[8,9,10,11,12],ymm4[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-FP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm8[4,9,14]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX2-FP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm10, %ymm1, %ymm1
; AVX2-FP-NEXT:    vextracti128 $1, %ymm9, %xmm6
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[3,8,13],zero,zero,zero,xmm6[1,6,11,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12],zero,zero,zero,xmm9[u,u,u,u]
; AVX2-FP-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm9
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm9[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [0,5,0,5,0,5,0,5]
; AVX2-FP-NEXT:    vpermd %ymm6, %ymm9, %ymm6
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm6, %ymm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[2,7,12]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX2-FP-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm2 = ymm5[0,1,2,3,4],ymm2[5,6,7],ymm5[8,9,10,11,12],ymm2[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[3,8,13]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX2-FP-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-FP-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm3 = ymm7[0,1,2,3,4],ymm3[5,6,7],ymm7[8,9,10,11,12],ymm3[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm1, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm2 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm3, %ymm4, %ymm5
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm0, %ymm1, %ymm6
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-FCP-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm8, %ymm6, %ymm7, %ymm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpmovsxwd {{.*#+}} ymm8 = [4294967295,4294967295,4294967295,255,0,0,0,0]
; AVX2-FCP-NEXT:    vmovdqa %xmm8, %xmm7
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm6
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm3, %ymm4, %ymm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm5[1,6,11],zero,zero,zero,zero,xmm5[4,9,14],zero,zero,zero,xmm5[u,u,u]
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = zero,zero,zero,xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm10
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-FCP-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm5, %ymm10, %ymm5
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm10 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-FCP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm9, %ymm11, %ymm7
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm9 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm1, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-FCP-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm13, %ymm11, %ymm12, %ymm11
; AVX2-FCP-NEXT:    vpblendvb %ymm10, %ymm4, %ymm3, %ymm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm12, %xmm10, %xmm10
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendvb %ymm8, %ymm10, %ymm11, %ymm10
; AVX2-FCP-NEXT:    vmovdqa 144(%rdi), %xmm8
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[1,6,11]
; AVX2-FCP-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm9
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %xmm3
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm3[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %xmm4, %xmm11, %xmm4
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm6[0,1,2,3,4],ymm4[5,6,7],ymm6[8,9,10,11,12],ymm4[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-FCP-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm8[4,9,14]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm3[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vpmovsxwq {{.*#+}} ymm2 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm10, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm9, %xmm6
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[3,8,13],zero,zero,zero,xmm6[1,6,11,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12],zero,zero,zero,xmm9[u,u,u,u]
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm9
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3,4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} ymm6 = ymm9[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm9 = [0,5,0,5,0,5,0,5]
; AVX2-FCP-NEXT:    vpermd %ymm6, %ymm9, %ymm6
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[2,7,12]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm6, %xmm2
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm2 = ymm5[0,1,2,3,4],ymm2[5,6,7],ymm5[8,9,10,11,12],ymm2[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm8[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm8[3,8,13]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm3, %xmm3
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm3 = ymm7[0,1,2,3,4],ymm3[5,6,7],ymm7[8,9,10,11,12],ymm3[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm1, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512-NEXT:    vmovdqa %ymm2, %ymm4
; AVX512-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm8 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm7
; AVX512-NEXT:    vextracti128 $1, %ymm7, %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512-NEXT:    vpor %xmm7, %xmm9, %xmm9
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512-NEXT:    vpternlogq $236, %ymm11, %ymm6, %ymm9
; AVX512-NEXT:    vmovdqa 144(%rdi), %xmm7
; AVX512-NEXT:    vpshufb %xmm8, %xmm7, %xmm6
; AVX512-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6,7],ymm9[8,9,10,11,12],ymm6[13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-NEXT:    vmovdqa %ymm10, %ymm9
; AVX512-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm9
; AVX512-NEXT:    vpermq {{.*#+}} ymm12 = ymm9[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm12
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm9, %ymm12, %ymm12
; AVX512-NEXT:    vmovdqa %ymm2, %ymm13
; AVX512-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14],zero,zero,zero,xmm13[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[0,5,10,15],zero,zero,zero,xmm13[3,8,13,u,u,u]
; AVX512-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512-NEXT:    vpternlogq $236, %ymm11, %ymm12, %ymm13
; AVX512-NEXT:    vpshufb %xmm9, %xmm7, %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512-NEXT:    vpblendw {{.*#+}} ymm9 = ymm13[0,1,2,3,4],ymm9[5,6,7],ymm13[8,9,10,11,12],ymm9[13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX512-NEXT:    vmovdqa %ymm4, %ymm12
; AVX512-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm12
; AVX512-NEXT:    vpermq {{.*#+}} ymm13 = ymm12[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm12, %ymm13, %ymm13
; AVX512-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm10
; AVX512-NEXT:    vextracti128 $1, %ymm10, %xmm14
; AVX512-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15],zero,zero,zero,xmm10[u,u,u]
; AVX512-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX512-NEXT:    vpternlogq $236, %ymm11, %ymm13, %ymm10
; AVX512-NEXT:    vpshufb %xmm12, %xmm7, %xmm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-NEXT:    vpblendw {{.*#+}} ymm11 = ymm10[0,1,2,3,4],ymm11[5,6,7],ymm10[8,9,10,11,12],ymm11[13,14,15]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX512-NEXT:    vmovdqa %ymm2, %ymm11
; AVX512-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm11
; AVX512-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm11, %ymm12
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm11 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb %ymm11, %ymm12, %ymm12
; AVX512-NEXT:    vmovdqa %ymm4, %ymm13
; AVX512-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[3,8,13],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[2,7,12],zero,zero,zero,xmm13[0,5,10,15,u,u,u]
; AVX512-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512-NEXT:    vpmovsxwq {{.*#+}} ymm8 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX512-NEXT:    vpternlogq $184, %ymm13, %ymm8, %ymm7
; AVX512-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm2
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512-NEXT:    vpermq {{.*#+}} ymm0 = ymm4[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm0
; AVX512-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512-NEXT:    vpternlogq $184, %ymm0, %ymm8, %ymm1
; AVX512-NEXT:    vmovdqa %ymm6, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm9, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512-NEXT:    vmovdqa %ymm1, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512-FCP-NEXT:    vmovdqa %ymm2, %ymm4
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm7
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm9, %xmm9
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm6, %ymm9
; AVX512-FCP-NEXT:    vmovdqa 144(%rdi), %xmm7
; AVX512-FCP-NEXT:    vpshufb %xmm8, %xmm7, %xmm6
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6,7],ymm9[8,9,10,11,12],ymm6[13,14,15]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-FCP-NEXT:    vmovdqa %ymm10, %ymm9
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm9
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm9[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm12
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm9, %ymm12, %ymm12
; AVX512-FCP-NEXT:    vmovdqa %ymm2, %ymm13
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14],zero,zero,zero,xmm13[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[0,5,10,15],zero,zero,zero,xmm13[3,8,13,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm12, %ymm13
; AVX512-FCP-NEXT:    vpshufb %xmm9, %xmm7, %xmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} ymm9 = ymm13[0,1,2,3,4],ymm9[5,6,7],ymm13[8,9,10,11,12],ymm9[13,14,15]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm12
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm12
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm12[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm12, %ymm13, %ymm13
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm10
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm10, %xmm14
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15],zero,zero,zero,xmm10[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm13, %ymm10
; AVX512-FCP-NEXT:    vpshufb %xmm12, %xmm7, %xmm11
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} ymm11 = ymm10[0,1,2,3,4],ymm11[5,6,7],ymm10[8,9,10,11,12],ymm11[13,14,15]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa %ymm2, %ymm11
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm11
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm11, %ymm12
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb %ymm11, %ymm12, %ymm12
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm13
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[3,8,13],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[2,7,12],zero,zero,zero,xmm13[0,5,10,15,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512-FCP-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512-FCP-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512-FCP-NEXT:    vpmovsxwq {{.*#+}} ymm8 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX512-FCP-NEXT:    vpternlogq $184, %ymm13, %ymm8, %ymm7
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm2
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm4[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512-FCP-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $184, %ymm0, %ymm8, %ymm1
; AVX512-FCP-NEXT:    vmovdqa %ymm6, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %ymm9, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512-FCP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-NEXT:    vmovdqa %ymm2, %ymm4
; AVX512DQ-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm8 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512DQ-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm7
; AVX512DQ-NEXT:    vextracti128 $1, %ymm7, %xmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm7, %xmm9, %xmm9
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512DQ-NEXT:    vpternlogq $236, %ymm11, %ymm6, %ymm9
; AVX512DQ-NEXT:    vmovdqa 144(%rdi), %xmm7
; AVX512DQ-NEXT:    vpshufb %xmm8, %xmm7, %xmm6
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6,7],ymm9[8,9,10,11,12],ymm6[13,14,15]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-NEXT:    vmovdqa %ymm10, %ymm9
; AVX512DQ-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm9
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm12 = ymm9[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm12
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm9, %ymm12, %ymm12
; AVX512DQ-NEXT:    vmovdqa %ymm2, %ymm13
; AVX512DQ-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm13
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14],zero,zero,zero,xmm13[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[0,5,10,15],zero,zero,zero,xmm13[3,8,13,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512DQ-NEXT:    vpternlogq $236, %ymm11, %ymm12, %ymm13
; AVX512DQ-NEXT:    vpshufb %xmm9, %xmm7, %xmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512DQ-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512DQ-NEXT:    vpblendw {{.*#+}} ymm9 = ymm13[0,1,2,3,4],ymm9[5,6,7],ymm13[8,9,10,11,12],ymm9[13,14,15]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm12
; AVX512DQ-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm12
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm13 = ymm12[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm12, %ymm13, %ymm13
; AVX512DQ-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm10
; AVX512DQ-NEXT:    vextracti128 $1, %ymm10, %xmm14
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15],zero,zero,zero,xmm10[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX512DQ-NEXT:    vpternlogq $236, %ymm11, %ymm13, %ymm10
; AVX512DQ-NEXT:    vpshufb %xmm12, %xmm7, %xmm11
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQ-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-NEXT:    vpblendw {{.*#+}} ymm11 = ymm10[0,1,2,3,4],ymm11[5,6,7],ymm10[8,9,10,11,12],ymm11[13,14,15]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa %ymm2, %ymm11
; AVX512DQ-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm11
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm11, %ymm12
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm11 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb %ymm11, %ymm12, %ymm12
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm13
; AVX512DQ-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm13
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[3,8,13],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[2,7,12],zero,zero,zero,xmm13[0,5,10,15,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512DQ-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512DQ-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512DQ-NEXT:    vpmovsxwq {{.*#+}} ymm8 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX512DQ-NEXT:    vpternlogq $184, %ymm13, %ymm8, %ymm7
; AVX512DQ-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm2
; AVX512DQ-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm0 = ymm4[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512DQ-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpternlogq $184, %ymm0, %ymm8, %ymm1
; AVX512DQ-NEXT:    vmovdqa %ymm6, (%rsi)
; AVX512DQ-NEXT:    vmovdqa %ymm9, (%rdx)
; AVX512DQ-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512DQ-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512DQ-NEXT:    vmovdqa %ymm1, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm2 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-FCP-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, %ymm4
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm8 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm8, %ymm6, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm7
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = zero,zero,zero,zero,xmm9[4,9,14],zero,zero,zero,xmm9[2,7,12,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm9, %xmm9
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm6, %ymm9
; AVX512DQ-FCP-NEXT:    vmovdqa 144(%rdi), %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb %xmm8, %xmm7, %xmm6
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm8[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm10, %xmm6
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} ymm6 = ymm9[0,1,2,3,4],ymm6[5,6,7],ymm9[8,9,10,11,12],ymm6[13,14,15]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm10, %ymm9
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm9
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm9[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm9, %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm9 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm9, %ymm12, %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, %ymm13
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm5, %ymm3, %ymm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14],zero,zero,zero,xmm13[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[0,5,10,15],zero,zero,zero,xmm13[3,8,13,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm12, %ymm13
; AVX512DQ-FCP-NEXT:    vpshufb %xmm9, %xmm7, %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm9, %xmm12, %xmm9
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} ymm9 = ymm13[0,1,2,3,4],ymm9[5,6,7],ymm13[8,9,10,11,12],ymm9[13,14,15]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm12
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm12
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm13 = ymm12[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm12, %ymm13, %ymm13
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm10
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm10, %xmm14
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15],zero,zero,zero,xmm10[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm14, %xmm10, %xmm10
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm11, %ymm13, %ymm10
; AVX512DQ-FCP-NEXT:    vpshufb %xmm12, %xmm7, %xmm11
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm8[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} ymm11 = ymm10[0,1,2,3,4],ymm11[5,6,7],ymm10[8,9,10,11,12],ymm11[13,14,15]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm2, %ymm11
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm0, %ymm1, %ymm11
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm12 = ymm11[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm11, %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm11 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm11, %ymm12, %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm13
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm13[3,8,13],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = zero,zero,zero,xmm13[2,7,12],zero,zero,zero,xmm13[0,5,10,15,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm14, %xmm13, %xmm13
; AVX512DQ-FCP-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm12, %ymm13
; AVX512DQ-FCP-NEXT:    vpshufb %xmm11, %xmm7, %xmm7
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm8[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm7
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512DQ-FCP-NEXT:    vpmovsxwq {{.*#+}} ymm8 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %ymm13, %ymm8, %ymm7
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm3, %ymm5, %ymm2
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm1, %ymm0, %ymm4
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm4[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512DQ-FCP-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %ymm0, %ymm8, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm6, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm9, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm10, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm1, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512BW-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k2}
; AVX512BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm5 {%k3} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512BW-NEXT:    vmovdqa 144(%rdi), %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[1,6,11]
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX512BW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7],ymm5[8,9,10,11,12],ymm4[13,14,15]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-NEXT:    kmovd %eax, %k4
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm5 {%k4}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX512BW-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vmovdqu8 %ymm8, %ymm5 {%k5}
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm8 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[1,6,11],zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[3,8,13,u,u,u]
; AVX512BW-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm8 {%k3} = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[2,7,12]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm7[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm8[0,1,2,3,4],ymm5[5,6,7],ymm8[8,9,10,11,12],ymm5[13,14,15]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm8 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm9 = ymm8[2,3,0,1]
; AVX512BW-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k5}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm9 {%k4}
; AVX512BW-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX512BW-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm9 {%k3} = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[3,8,13]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX512BW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512BW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6,7],ymm9[8,9,10,11,12],ymm8[13,14,15]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm9 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[2,3,0,1]
; AVX512BW-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu8 %ymm10, %ymm9 {%k3}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm10 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX512BW-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512BW-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm10 {%k3} = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm6[4,9,14]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    movl $-33554432, %eax # imm = 0xFE000000
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu8 %ymm6, %ymm10 {%k3}
; AVX512BW-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512BW-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512BW-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k3}
; AVX512BW-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX512BW-NEXT:    vmovdqa %ymm5, (%rdx)
; AVX512BW-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX512BW-NEXT:    vmovdqa %ymm10, (%r8)
; AVX512BW-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k2}
; AVX512BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k2}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512BW-FCP-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 {%k3} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vmovdqa 144(%rdi), %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[1,6,11]
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %xmm7
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7],ymm5[8,9,10,11,12],ymm4[13,14,15]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm5 {%k4}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm8, %ymm5 {%k5}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm8 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[1,6,11],zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[3,8,13,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm8 {%k3} = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[2,7,12]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm7[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} ymm5 = ymm8[0,1,2,3,4],ymm5[5,6,7],ymm8[8,9,10,11,12],ymm5[13,14,15]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm8 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm8[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k5}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm9 {%k4}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm9 {%k3} = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[3,8,13]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6,7],ymm9[8,9,10,11,12],ymm8[13,14,15]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm9 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm10, %ymm9 {%k3}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm10 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512BW-FCP-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 {%k3} = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm6[4,9,14]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-FCP-NEXT:    movl $-33554432, %eax # imm = 0xFE000000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm6, %ymm10 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k1}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512BW-FCP-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k3}
; AVX512BW-FCP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm5, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm10, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k2}
; AVX512DQ-BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k2}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm5 {%k3} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vmovdqa 144(%rdi), %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[1,6,11]
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %xmm7
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7],ymm5[8,9,10,11,12],ymm4[13,14,15]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX512DQ-BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm5 {%k4}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm8, %ymm5 {%k5}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm8 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[1,6,11],zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[3,8,13,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm8 {%k3} = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[2,7,12]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm7[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm8[0,1,2,3,4],ymm5[5,6,7],ymm8[8,9,10,11,12],ymm5[13,14,15]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm8 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm9 = ymm8[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k5}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm9 {%k4}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm9 {%k3} = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm8 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[3,8,13]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6,7],ymm9[8,9,10,11,12],ymm8[13,14,15]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm9 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm10, %ymm9 {%k3}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm10 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512DQ-BW-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm10 {%k3} = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm6[4,9,14]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-BW-NEXT:    movl $-33554432, %eax # imm = 0xFE000000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm6, %ymm10 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k1}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512DQ-BW-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k3}
; AVX512DQ-BW-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm5, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm10, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k2}
; AVX512DQ-BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX512DQ-BW-FCP-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm5 {%k3} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 144(%rdi), %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm4 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[1,6,11]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm7[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm5[0,1,2,3,4],ymm4[5,6,7],ymm5[8,9,10,11,12],ymm4[13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm5 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm8 = ymm5[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm8, %ymm5 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm8[1,6,11],zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[0,5,10,15],zero,zero,zero,xmm8[3,8,13,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm9, %xmm8, %xmm8
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm8 {%k3} = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[2,7,12]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm7[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm5, %xmm9, %xmm5
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} ymm5 = ymm8[0,1,2,3,4],ymm5[5,6,7],ymm8[8,9,10,11,12],ymm5[13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm9 = ymm8[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm9 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm9, %xmm10
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[4,9,14,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm9[2,7,12],zero,zero,zero,xmm9[0,5,10,15],zero,zero,zero,xmm9[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm10, %xmm9, %xmm9
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm9 {%k3} = ymm8[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = xmm6[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm6[3,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = xmm7[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm8, %xmm10, %xmm8
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} ymm8 = ymm9[0,1,2,3,4],ymm8[5,6,7],ymm9[8,9,10,11,12],ymm8[13,14,15]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm10 = ymm9[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm10, %ymm9 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm10 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm10[3,8,13],zero,zero,zero,xmm10[1,6,11],zero,zero,zero,zero,xmm10[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm10[2,7,12],zero,zero,zero,xmm10[0,5,10,15,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm11, %xmm10, %xmm10
; AVX512DQ-BW-FCP-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 {%k3} = ymm9[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm6[4,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-BW-FCP-NEXT:    movl $-33554432, %eax # imm = 0xFE000000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm6, %ymm10 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [0,5,0,5,0,5,0,5]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm5, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm8, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm10, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <160 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <160 x i8> %wide.vec, <160 x i8> poison, <32 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75, i32 80, i32 85, i32 90, i32 95, i32 100, i32 105, i32 110, i32 115, i32 120, i32 125, i32 130, i32 135, i32 140, i32 145, i32 150, i32 155>
  %strided.vec1 = shufflevector <160 x i8> %wide.vec, <160 x i8> poison, <32 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76, i32 81, i32 86, i32 91, i32 96, i32 101, i32 106, i32 111, i32 116, i32 121, i32 126, i32 131, i32 136, i32 141, i32 146, i32 151, i32 156>
  %strided.vec2 = shufflevector <160 x i8> %wide.vec, <160 x i8> poison, <32 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77, i32 82, i32 87, i32 92, i32 97, i32 102, i32 107, i32 112, i32 117, i32 122, i32 127, i32 132, i32 137, i32 142, i32 147, i32 152, i32 157>
  %strided.vec3 = shufflevector <160 x i8> %wide.vec, <160 x i8> poison, <32 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78, i32 83, i32 88, i32 93, i32 98, i32 103, i32 108, i32 113, i32 118, i32 123, i32 128, i32 133, i32 138, i32 143, i32 148, i32 153, i32 158>
  %strided.vec4 = shufflevector <160 x i8> %wide.vec, <160 x i8> poison, <32 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79, i32 84, i32 89, i32 94, i32 99, i32 104, i32 109, i32 114, i32 119, i32 124, i32 129, i32 134, i32 139, i32 144, i32 149, i32 154, i32 159>
  store <32 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <32 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <32 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <32 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}

define void @load_i8_stride5_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4) nounwind {
; SSE-LABEL: load_i8_stride5_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $552, %rsp # imm = 0x228
; SSE-NEXT:    movdqa 160(%rdi), %xmm9
; SSE-NEXT:    movdqa 176(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 208(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 192(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm14
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm12, %xmm12
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3],xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm12[8],xmm1[9],xmm12[9],xmm1[10],xmm12[10],xmm1[11],xmm12[11],xmm1[12],xmm12[12],xmm1[13],xmm12[13],xmm1[14],xmm12[14],xmm1[15],xmm12[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,3]
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,255]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,255,0,255,255,255,255,0,255,255,255,255,0,255,255,255]
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm9
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm12[0],xmm0[1],xmm12[1],xmm0[2],xmm12[2],xmm0[3],xmm12[3],xmm0[4],xmm12[4],xmm0[5],xmm12[5],xmm0[6],xmm12[6],xmm0[7],xmm12[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [0,65535,65535,65535,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm12[8],xmm9[9],xmm12[9],xmm9[10],xmm12[10],xmm9[11],xmm12[11],xmm9[12],xmm12[12],xmm9[13],xmm12[13],xmm9[14],xmm12[14],xmm9[15],xmm12[15]
; SSE-NEXT:    pand %xmm8, %xmm9
; SSE-NEXT:    por %xmm2, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm9[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa 224(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm1[8],xmm3[9],xmm1[9],xmm3[10],xmm1[10],xmm3[11],xmm1[11],xmm3[12],xmm1[12],xmm3[13],xmm1[13],xmm3[14],xmm1[14],xmm3[15],xmm1[15]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pxor %xmm9, %xmm9
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm6, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    movdqa 48(%rdi), %xmm15
; SSE-NEXT:    movdqa %xmm15, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,0,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    movdqa 16(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    movdqa (%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm9[0],xmm2[1],xmm9[1],xmm2[2],xmm9[2],xmm2[3],xmm9[3],xmm2[4],xmm9[4],xmm2[5],xmm9[5],xmm2[6],xmm9[6],xmm2[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm8, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm9[8],xmm3[9],xmm9[9],xmm3[10],xmm9[10],xmm3[11],xmm9[11],xmm3[12],xmm9[12],xmm3[13],xmm9[13],xmm3[14],xmm9[14],xmm3[15],xmm9[15]
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa 64(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm3[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 272(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa 288(%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pand %xmm14, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1],xmm1[2],xmm9[2],xmm1[3],xmm9[3],xmm1[4],xmm9[4],xmm1[5],xmm9[5],xmm1[6],xmm9[6],xmm1[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    packuswb %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa 256(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    movdqa 240(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm8, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm9[8],xmm3[9],xmm9[9],xmm3[10],xmm9[10],xmm3[11],xmm9[11],xmm3[12],xmm9[12],xmm3[13],xmm9[13],xmm3[14],xmm9[14],xmm3[15],xmm9[15]
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa 304(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,0],xmm4[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm4[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm3
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    movdqa 128(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm14, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm9[0],xmm2[1],xmm9[1],xmm2[2],xmm9[2],xmm2[3],xmm9[3],xmm2[4],xmm9[4],xmm2[5],xmm9[5],xmm2[6],xmm9[6],xmm2[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,1,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm9[8],xmm3[9],xmm9[9],xmm3[10],xmm9[10],xmm3[11],xmm9[11],xmm3[12],xmm9[12],xmm3[13],xmm9[13],xmm3[14],xmm9[14],xmm3[15],xmm9[15]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,4,7]
; SSE-NEXT:    punpckhdq {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,2,3]
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa 96(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm4, %xmm2
; SSE-NEXT:    movdqa 80(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm9[0],xmm2[1],xmm9[1],xmm2[2],xmm9[2],xmm2[3],xmm9[3],xmm2[4],xmm9[4],xmm2[5],xmm9[5],xmm2[6],xmm9[6],xmm2[7],xmm9[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm9[8],xmm4[9],xmm9[9],xmm4[10],xmm9[10],xmm4[11],xmm9[11],xmm4[12],xmm9[12],xmm4[13],xmm9[13],xmm4[14],xmm9[14],xmm4[15],xmm9[15]
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm4, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,1,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,5,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm11, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa 144(%rdi), %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm9[8],xmm12[9],xmm9[9],xmm12[10],xmm9[10],xmm12[11],xmm9[11],xmm12[12],xmm9[12],xmm12[13],xmm9[13],xmm12[14],xmm9[14],xmm12[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    movdqa %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm4[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm4[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,4]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm14
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm10, %xmm3
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm2[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm3
; SSE-NEXT:    packuswb %xmm2, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm9[8],xmm7[9],xmm9[9],xmm7[10],xmm9[10],xmm7[11],xmm9[11],xmm7[12],xmm9[12],xmm7[13],xmm9[13],xmm7[14],xmm9[14],xmm7[15],xmm9[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [65535,65535,0,0,65535,65535,65535,0]
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    pandn %xmm7, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pand %xmm11, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm7[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm4[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm7[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm14, %xmm7
; SSE-NEXT:    pandn %xmm4, %xmm7
; SSE-NEXT:    pand %xmm14, %xmm3
; SSE-NEXT:    por %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm10, %xmm3
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pand %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm10, %xmm5
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm9[8],xmm3[9],xmm9[9],xmm3[10],xmm9[10],xmm3[11],xmm9[11],xmm3[12],xmm9[12],xmm3[13],xmm9[13],xmm3[14],xmm9[14],xmm3[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,0],xmm3[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm3[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm7[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm4
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm10, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pand %xmm0, %xmm4
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm9[8],xmm0[9],xmm9[9],xmm0[10],xmm9[10],xmm0[11],xmm9[11],xmm0[12],xmm9[12],xmm0[13],xmm9[13],xmm0[14],xmm9[14],xmm0[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    por %xmm7, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm11, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm4[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm4[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm14, %xmm4
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    pand %xmm14, %xmm0
; SSE-NEXT:    por %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    por %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm9[8],xmm0[9],xmm9[9],xmm0[10],xmm9[10],xmm0[11],xmm9[11],xmm0[12],xmm9[12],xmm0[13],xmm9[13],xmm0[14],xmm9[14],xmm0[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,0],xmm0[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm0[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm3
; SSE-NEXT:    packuswb %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    movdqa (%rsp), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm8, %xmm7
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm5, %xmm8
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm1[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm1[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,7,7,7]
; SSE-NEXT:    psllq $48, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm9[0],xmm3[1],xmm9[1],xmm3[2],xmm9[2],xmm3[3],xmm9[3],xmm3[4],xmm9[4],xmm3[5],xmm9[5],xmm3[6],xmm9[6],xmm3[7],xmm9[7]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,7,4,5,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm12[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,1]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,5,4]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm14, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm11 = [255,255,0,255,255,255,255,0,255,255,255,255,0,255,255,255]
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,0,0,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1],xmm1[2],xmm9[2],xmm1[3],xmm9[3],xmm1[4],xmm9[4],xmm1[5],xmm9[5],xmm1[6],xmm9[6],xmm1[7],xmm9[7]
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [0,0,0,65535,65535,65535,65535,65535]
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm1[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm4[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm7[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm4
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    pand %xmm14, %xmm4
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm11, %xmm10
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm9[0],xmm10[1],xmm9[1],xmm10[2],xmm9[2],xmm10[3],xmm9[3],xmm10[4],xmm9[4],xmm10[5],xmm9[5],xmm10[6],xmm9[6],xmm10[7],xmm9[7]
; SSE-NEXT:    pand %xmm6, %xmm10
; SSE-NEXT:    por %xmm4, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm10[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm1
; SSE-NEXT:    pandn %xmm15, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pandn %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    por %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm4[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm1[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm4[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm7[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm4
; SSE-NEXT:    pand %xmm12, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm2[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    pand %xmm14, %xmm4
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm1 # 16-byte Reload
; SSE-NEXT:    pand %xmm11, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm2, %xmm4
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1],xmm1[2],xmm9[2],xmm1[3],xmm9[3],xmm1[4],xmm9[4],xmm1[5],xmm9[5],xmm1[6],xmm9[6],xmm1[7],xmm9[7]
; SSE-NEXT:    pand %xmm6, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm12, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm4
; SSE-NEXT:    pandn %xmm13, %xmm4
; SSE-NEXT:    movdqa %xmm10, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    pandn %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    movdqa %xmm8, %xmm10
; SSE-NEXT:    por %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm9[8],xmm4[9],xmm9[9],xmm4[10],xmm9[10],xmm4[11],xmm9[11],xmm4[12],xmm9[12],xmm4[13],xmm9[13],xmm4[14],xmm9[14],xmm4[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm9[0],xmm7[1],xmm9[1],xmm7[2],xmm9[2],xmm7[3],xmm9[3],xmm7[4],xmm9[4],xmm7[5],xmm9[5],xmm7[6],xmm9[6],xmm7[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,0],xmm4[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm7[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm8[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm4, %xmm7
; SSE-NEXT:    pand %xmm12, %xmm7
; SSE-NEXT:    por %xmm2, %xmm7
; SSE-NEXT:    pshufd $85, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = mem[1,1,1,1]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm14, %xmm1
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    pand %xmm14, %xmm7
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm11, %xmm8
; SSE-NEXT:    movdqa %xmm11, %xmm2
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    pand %xmm11, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm9[8],xmm2[9],xmm9[9],xmm2[10],xmm9[10],xmm2[11],xmm9[11],xmm2[12],xmm9[12],xmm2[13],xmm9[13],xmm2[14],xmm9[14],xmm2[15],xmm9[15]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm9[0],xmm4[1],xmm9[1],xmm4[2],xmm9[2],xmm4[3],xmm9[3],xmm4[4],xmm9[4],xmm4[5],xmm9[5],xmm4[6],xmm9[6],xmm4[7],xmm9[7]
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    por %xmm7, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movdqa %xmm12, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm10, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pandn %xmm5, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm0, %xmm14
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255]
; SSE-NEXT:    pand %xmm1, %xmm14
; SSE-NEXT:    movdqa %xmm15, %xmm11
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    movdqa %xmm13, %xmm4
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm8, %xmm15
; SSE-NEXT:    pand %xmm8, %xmm13
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    movdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm7, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm9[8],xmm7[9],xmm9[9],xmm7[10],xmm9[10],xmm7[11],xmm9[11],xmm7[12],xmm9[12],xmm7[13],xmm9[13],xmm7[14],xmm9[14],xmm7[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[0,1,2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm7[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm0[0,2]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm7[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,6,6,6]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm12, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,1,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm8[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0]
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    pand %xmm10, %xmm1
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,255]
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm9[8],xmm1[9],xmm9[9],xmm1[10],xmm9[10],xmm1[11],xmm9[11],xmm1[12],xmm9[12],xmm1[13],xmm9[13],xmm1[14],xmm9[14],xmm1[15],xmm9[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm9[0],xmm0[1],xmm9[1],xmm0[2],xmm9[2],xmm0[3],xmm9[3],xmm0[4],xmm9[4],xmm0[5],xmm9[5],xmm0[6],xmm9[6],xmm0[7],xmm9[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm14 = xmm14[8],xmm9[8],xmm14[9],xmm9[9],xmm14[10],xmm9[10],xmm14[11],xmm9[11],xmm14[12],xmm9[12],xmm14[13],xmm9[13],xmm14[14],xmm9[14],xmm14[15],xmm9[15]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[3,1],xmm0[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm14[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm9
; SSE-NEXT:    movdqa %xmm10, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm14
; SSE-NEXT:    pand %xmm10, %xmm0
; SSE-NEXT:    por %xmm0, %xmm14
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm2[8],xmm11[9],xmm2[9],xmm11[10],xmm2[10],xmm11[11],xmm2[11],xmm11[12],xmm2[12],xmm11[13],xmm2[13],xmm11[14],xmm2[14],xmm11[15],xmm2[15]
; SSE-NEXT:    pxor %xmm10, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[3,1],xmm0[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm11[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm11
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm10[8],xmm1[9],xmm10[9],xmm1[10],xmm10[10],xmm1[11],xmm10[11],xmm1[12],xmm10[12],xmm1[13],xmm10[13],xmm1[14],xmm10[14],xmm1[15],xmm10[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1],xmm0[2],xmm10[2],xmm0[3],xmm10[3],xmm0[4],xmm10[4],xmm0[5],xmm10[5],xmm0[6],xmm10[6],xmm0[7],xmm10[7]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1],xmm1[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1],xmm0[2],xmm10[2],xmm0[3],xmm10[3],xmm0[4],xmm10[4],xmm0[5],xmm10[5],xmm0[6],xmm10[6],xmm0[7],xmm10[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm10[8],xmm4[9],xmm10[9],xmm4[10],xmm10[10],xmm4[11],xmm10[11],xmm4[12],xmm10[12],xmm4[13],xmm10[13],xmm4[14],xmm10[14],xmm4[15],xmm10[15]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,1],xmm0[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm4[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm1[0,2]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm2[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm10
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    por %xmm0, %xmm10
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8],xmm1[8],xmm2[9],xmm1[9],xmm2[10],xmm1[10],xmm2[11],xmm1[11],xmm2[12],xmm1[12],xmm2[13],xmm1[13],xmm2[14],xmm1[14],xmm2[15],xmm1[15]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1],xmm0[2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,1,0,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,5,5,5,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,5,6]
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm4[0,1,2,3,4,5,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,0,1,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,7,4,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm12
; SSE-NEXT:    por %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm8[3,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm5[0,2]
; SSE-NEXT:    pand %xmm9, %xmm0
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm3[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,4,7,5]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pandn %xmm2, %xmm9
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm0[1,2]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm3[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm2
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,0,0,0,65535,65535]
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movdqa {{.*#+}} xmm12 = [255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255]
; SSE-NEXT:    pand %xmm12, %xmm8
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm1[8],xmm8[9],xmm1[9],xmm8[10],xmm1[10],xmm8[11],xmm1[11],xmm8[12],xmm1[12],xmm8[13],xmm1[13],xmm8[14],xmm1[14],xmm8[15],xmm1[15]
; SSE-NEXT:    pand %xmm6, %xmm8
; SSE-NEXT:    por %xmm7, %xmm8
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[3,1,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; SSE-NEXT:    packuswb %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm7[2,1]
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm15 = xmm15[0],xmm1[0],xmm15[1],xmm1[1],xmm15[2],xmm1[2],xmm15[3],xmm1[3],xmm15[4],xmm1[4],xmm15[5],xmm1[5],xmm15[6],xmm1[6],xmm15[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm15[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,3],xmm0[1,2]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm15[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm15
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm15, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm15 = xmm15[8],xmm1[8],xmm15[9],xmm1[9],xmm15[10],xmm1[10],xmm15[11],xmm1[11],xmm15[12],xmm1[12],xmm15[13],xmm1[13],xmm15[14],xmm1[14],xmm15[15],xmm1[15]
; SSE-NEXT:    pand %xmm6, %xmm15
; SSE-NEXT:    por %xmm8, %xmm15
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm15[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm8, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    por %xmm7, %xmm8
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[3,1,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; SSE-NEXT:    packuswb %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm7[2,1]
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm13, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm1[0],xmm13[1],xmm1[1],xmm13[2],xmm1[2],xmm13[3],xmm1[3],xmm13[4],xmm1[4],xmm13[5],xmm1[5],xmm13[6],xmm1[6],xmm13[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm13[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,3],xmm0[1,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm13[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm7
; SSE-NEXT:    movdqa (%rsp), %xmm13 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm13
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm13, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3],xmm3[4],xmm1[4],xmm3[5],xmm1[5],xmm3[6],xmm1[6],xmm3[7],xmm1[7]
; SSE-NEXT:    movdqa %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm1[8],xmm13[9],xmm1[9],xmm13[10],xmm1[10],xmm13[11],xmm1[11],xmm13[12],xmm1[12],xmm13[13],xmm1[13],xmm13[14],xmm1[14],xmm13[15],xmm1[15]
; SSE-NEXT:    pand %xmm6, %xmm13
; SSE-NEXT:    por %xmm5, %xmm13
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm13[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[3,1,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    # xmm7 = mem[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; SSE-NEXT:    packuswb %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm7[2,1]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm1[8],xmm0[9],xmm1[9],xmm0[10],xmm1[10],xmm0[11],xmm1[11],xmm0[12],xmm1[12],xmm0[13],xmm1[13],xmm0[14],xmm1[14],xmm0[15],xmm1[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1],xmm7[2],xmm1[2],xmm7[3],xmm1[3],xmm7[4],xmm1[4],xmm7[5],xmm1[5],xmm7[6],xmm1[6],xmm7[7],xmm1[7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,1,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,3],xmm0[1,2]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm12, %xmm0
; SSE-NEXT:    pandn {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Folded Reload
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    punpckhbw {{.*#+}} xmm12 = xmm12[8],xmm1[8],xmm12[9],xmm1[9],xmm12[10],xmm1[10],xmm12[11],xmm1[11],xmm12[12],xmm1[12],xmm12[13],xmm1[13],xmm12[14],xmm1[14],xmm12[15],xmm1[15]
; SSE-NEXT:    pand %xmm6, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm12, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[3,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,5,6,4]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2,3,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[2,1,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,5,4,7]
; SSE-NEXT:    packuswb %xmm6, %xmm3
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    pshufd $231, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = mem[3,1,2,3]
; SSE-NEXT:    pshufd $232, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Folded Reload
; SSE-NEXT:    # xmm4 = mem[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,0,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm4[2,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    movaps %xmm3, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 32(%rcx)
; SSE-NEXT:    movdqa %xmm9, 16(%r8)
; SSE-NEXT:    movdqa %xmm10, 48(%r8)
; SSE-NEXT:    movdqa %xmm11, (%r8)
; SSE-NEXT:    movdqa %xmm14, 32(%r8)
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps %xmm5, 48(%r9)
; SSE-NEXT:    movaps %xmm8, (%r9)
; SSE-NEXT:    movaps %xmm2, 32(%r9)
; SSE-NEXT:    addq $552, %rsp # imm = 0x228
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride5_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $488, %rsp # imm = 0x1E8
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm2 = [4,9,14,0,4,9,14,0,4,9,14,0,4,9,14,0]
; AVX-NEXT:    vmovdqa (%rdi), %xmm4
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm5
; AVX-NEXT:    vpshufb %xmm2, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa %xmm1, %xmm11
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm3 = [0,5,10,15,0,5,10,15,0,5,10,15,0,5,10,15]
; AVX-NEXT:    vpshufb %xmm3, %xmm4, %xmm1
; AVX-NEXT:    vmovdqa %xmm4, %xmm8
; AVX-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm1 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm4 = [128,128,2,7,12,0,0,128,128,128,2,7,12,0,0,128]
; AVX-NEXT:    # xmm4 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm4, %xmm5, %xmm0
; AVX-NEXT:    vmovdqa %xmm5, %xmm9
; AVX-NEXT:    vmovdqa %xmm5, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm5 = [8,13,128,128,128,0,0,3,8,13,128,128,128,0,0,3]
; AVX-NEXT:    # xmm5 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm5, %xmm7, %xmm6
; AVX-NEXT:    vmovdqa %xmm7, %xmm12
; AVX-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpor %xmm0, %xmm6, %xmm6
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = [255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpblendvb %xmm0, %xmm1, %xmm6, %xmm1
; AVX-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 176(%rdi), %xmm1
; AVX-NEXT:    vpshufb %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vmovdqa %xmm1, %xmm14
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 160(%rdi), %xmm1
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX-NEXT:    vmovdqa %xmm1, %xmm13
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpunpckhdq {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm1
; AVX-NEXT:    vpshufb %xmm4, %xmm1, %xmm3
; AVX-NEXT:    vmovdqa %xmm1, %xmm10
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 192(%rdi), %xmm1
; AVX-NEXT:    vpshufb %xmm5, %xmm1, %xmm4
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vpblendvb %xmm0, %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovq {{.*#+}} xmm3 = [1,6,11,128,128,128,128,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm3, %xmm8, %xmm4
; AVX-NEXT:    vmovq {{.*#+}} xmm5 = [128,128,128,0,5,10,15,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm5, %xmm11, %xmm6
; AVX-NEXT:    vpor %xmm4, %xmm6, %xmm4
; AVX-NEXT:    vmovddup {{.*#+}} xmm7 = [128,128,3,8,13,0,0,128,128,128,3,8,13,0,0,128]
; AVX-NEXT:    # xmm7 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm7, %xmm9, %xmm6
; AVX-NEXT:    vmovddup {{.*#+}} xmm8 = [9,14,128,128,128,0,0,4,9,14,128,128,128,0,0,4]
; AVX-NEXT:    # xmm8 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm8, %xmm12, %xmm9
; AVX-NEXT:    vpor %xmm6, %xmm9, %xmm6
; AVX-NEXT:    vpblendvb %xmm0, %xmm4, %xmm6, %xmm2
; AVX-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb %xmm3, %xmm13, %xmm3
; AVX-NEXT:    vpshufb %xmm5, %xmm14, %xmm4
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vmovddup {{.*#+}} xmm11 = [0,0,128,128,128,1,6,11,0,0,128,128,128,1,6,11]
; AVX-NEXT:    # xmm11 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm7, %xmm10, %xmm4
; AVX-NEXT:    vpshufb %xmm8, %xmm1, %xmm5
; AVX-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vmovdqa 144(%rdi), %xmm1
; AVX-NEXT:    vpblendvb %xmm0, %xmm3, %xmm4, %xmm0
; AVX-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb %xmm11, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa %xmm1, %xmm8
; AVX-NEXT:    vmovddup {{.*#+}} xmm7 = [0,0,2,7,12,128,128,128,0,0,2,7,12,128,128,128]
; AVX-NEXT:    # xmm7 = mem[0,0]
; AVX-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX-NEXT:    vpshufb %xmm7, %xmm13, %xmm3
; AVX-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vmovddup {{.*#+}} xmm5 = [8,13,0,0,128,128,128,3,8,13,0,0,128,128,128,3]
; AVX-NEXT:    # xmm5 = mem[0,0]
; AVX-NEXT:    vmovdqa 112(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm5, %xmm1, %xmm3
; AVX-NEXT:    vmovddup {{.*#+}} xmm6 = [128,128,0,0,4,9,14,128,128,128,0,0,4,9,14,128]
; AVX-NEXT:    # xmm6 = mem[0,0]
; AVX-NEXT:    vmovdqa 96(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm6, %xmm1, %xmm12
; AVX-NEXT:    vpor %xmm3, %xmm12, %xmm3
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpblendw {{.*#+}} xmm12 = xmm4[0,1],xmm3[2,3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,5,10,15,128,128,128,128,128,128,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa 80(%rdi), %xmm14
; AVX-NEXT:    vpshufb %xmm3, %xmm14, %xmm15
; AVX-NEXT:    vpor %xmm15, %xmm12, %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm15 = xmm12[0,1,2,3,4],xmm0[5,6,7]
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm2 = [0,1,6,11,0,1,6,11,0,1,6,11,0,1,6,11]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm2, %xmm1, %xmm9
; AVX-NEXT:    vandnps %ymm9, %ymm12, %ymm9
; AVX-NEXT:    vorps %ymm0, %ymm9, %ymm0
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa 304(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm11, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm7, %xmm1, %xmm9
; AVX-NEXT:    vpor %xmm0, %xmm9, %xmm0
; AVX-NEXT:    vmovdqa 272(%rdi), %xmm10
; AVX-NEXT:    vpshufb %xmm5, %xmm10, %xmm5
; AVX-NEXT:    vmovdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 256(%rdi), %xmm9
; AVX-NEXT:    vpshufb %xmm6, %xmm9, %xmm6
; AVX-NEXT:    vpor %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3,4,5,6,7]
; AVX-NEXT:    vmovdqa 240(%rdi), %xmm1
; AVX-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm3
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm3[0,1,2,3,4],xmm0[5,6,7]
; AVX-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm3 # 32-byte Folded Reload
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm5
; AVX-NEXT:    vpshufb %xmm2, %xmm5, %xmm2
; AVX-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vandnps %ymm2, %ymm12, %ymm2
; AVX-NEXT:    vorps %ymm2, %ymm3, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm2 = [0,0,128,128,128,2,7,12,0,0,128,128,128,2,7,12]
; AVX-NEXT:    # xmm2 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm8, %xmm0
; AVX-NEXT:    vmovdqa %xmm8, %xmm11
; AVX-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = [0,0,3,8,13,128,128,128,0,0,3,8,13,128,128,128]
; AVX-NEXT:    # xmm3 = mem[0,0]
; AVX-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb %xmm3, %xmm13, %xmm4
; AVX-NEXT:    vpor %xmm0, %xmm4, %xmm4
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm7[u,u,u],zero,zero,zero,zero,xmm7[4,9,14,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = xmm1[u,u,u,0,5,10,15],zero,zero,zero,xmm1[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm8, %xmm8
; AVX-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,xmm8[3,4,5,6,7,8,9,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa %xmm14, %xmm6
; AVX-NEXT:    vmovdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[1,6,11],zero,zero,zero,zero,zero,zero,zero,xmm14[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm14, %xmm8, %xmm8
; AVX-NEXT:    vpblendw {{.*#+}} xmm4 = xmm8[0,1,2,3,4],xmm4[5,6,7]
; AVX-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm8 # 32-byte Folded Reload
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm14 = [0,2,7,12,0,2,7,12,0,2,7,12,0,2,7,12]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm14, %xmm0, %xmm15
; AVX-NEXT:    vandnps %ymm15, %ymm12, %ymm15
; AVX-NEXT:    vorps %ymm15, %ymm8, %ymm8
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm8, %ymm4
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm2, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm0, %xmm3
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm10[u,u,u],zero,zero,zero,zero,xmm10[4,9,14,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm9[u,u,u,0,5,10,15],zero,zero,zero,xmm9[u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa %xmm9, %xmm8
; AVX-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vmovdqa {{.*#+}} xmm9 = [128,128,128,3,4,5,6,7,8,9,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm9, %xmm3, %xmm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm10[1,6,11],zero,zero,zero,zero,zero,zero,zero,xmm10[u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3,4],xmm2[5,6,7]
; AVX-NEXT:    vandps {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm2 # 32-byte Folded Reload
; AVX-NEXT:    vpshufb %xmm14, %xmm5, %xmm3
; AVX-NEXT:    vandnps %ymm3, %ymm12, %ymm3
; AVX-NEXT:    vorps %ymm3, %ymm2, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm11[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm11[3,8,13]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm13[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm1[u,u,u,1,6,11],zero,zero,zero,zero,xmm1[u,u,u,u,u,u]
; AVX-NEXT:    vmovddup {{.*#+}} xmm4 = [10,15,0,128,128,128,0,5,10,15,0,128,128,128,0,5]
; AVX-NEXT:    # xmm4 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm4, %xmm7, %xmm5
; AVX-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX-NEXT:    vpshufb %xmm9, %xmm3, %xmm3
; AVX-NEXT:    vmovdqa {{.*#+}} xmm11 = [2,7,12,128,128,128,128,128,128,128,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm11, %xmm6, %xmm14
; AVX-NEXT:    vpor %xmm3, %xmm14, %xmm3
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3,4],xmm0[5,6,7]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm6[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = [128,128,4,9,14,0,128,128,128,128,4,9,14,0,128,128]
; AVX-NEXT:    # xmm3 = mem[0,0]
; AVX-NEXT:    vmovdqa (%rsp), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm7, %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm12 = xmm14[0,1,2],xmm12[3,4,5,6,7]
; AVX-NEXT:    vmovq {{.*#+}} xmm14 = [2,7,12,128,128,128,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm14, %xmm15, %xmm0
; AVX-NEXT:    vmovddup {{.*#+}} xmm9 = [10,15,128,128,128,0,0,5,10,15,128,128,128,0,0,5]
; AVX-NEXT:    # xmm9 = mem[0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm9, %xmm5, %xmm13
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm13[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm0, %xmm12, %xmm0
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX-NEXT:    vandps %ymm0, %ymm12, %ymm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13]
; AVX-NEXT:    vandnps %ymm13, %ymm12, %ymm13
; AVX-NEXT:    vorps %ymm0, %ymm13, %ymm0
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm0[3,8,13]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm8[u,u,u,1,6,11],zero,zero,zero,zero,xmm8[u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm4, %xmm13, %xmm4
; AVX-NEXT:    vpor %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,4,5,6,7,8,9,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm11, %xmm10, %xmm4
; AVX-NEXT:    vpor %xmm4, %xmm1, %xmm1
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3,4],xmm0[5,6,7]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm11[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm8, %xmm3
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm3[3,4,5,6,7]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm14, %xmm10, %xmm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm9, %xmm14, %xmm2
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2],xmm2[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vandps %ymm1, %ymm12, %ymm1
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm9[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13]
; AVX-NEXT:    vandnps %ymm2, %ymm12, %ymm2
; AVX-NEXT:    vorps %ymm2, %ymm1, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm6[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm5[u,u,u,u,u,u,1,6,11],zero,zero,zero,zero,xmm5[u,u,u]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[3,4,5,6,7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm15[3,8,13],zero,zero,zero,xmm15[u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm7[u,u,u,u,u,u],zero,zero,zero,xmm7[0,5,10,15,u,u,u]
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,zero,xmm0[1,6,11,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,2,7,12],zero,zero,zero,xmm1[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = zero,zero,zero,xmm0[3,4,5,6,7,8,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [3,8,13,128,128,128,128,128,128,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm2, %xmm15, %xmm1
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm1 = [0,4,9,14,0,4,9,14,0,4,9,14,0,4,9,14]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm1, %xmm4, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm4
; AVX-NEXT:    vmovaps {{.*#+}} ymm12 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255]
; AVX-NEXT:    vandps %ymm3, %ymm12, %ymm3
; AVX-NEXT:    vandnps %ymm4, %ymm12, %ymm4
; AVX-NEXT:    vorps %ymm4, %ymm3, %ymm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm6[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm6[4,9,14]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm4[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX-NEXT:    vextractf128 $1, %ymm3, %xmm7
; AVX-NEXT:    vpmovsxwq {{.*#+}} xmm0 = [18446744073709551615,255]
; AVX-NEXT:    vpblendvb %xmm0, %xmm7, %xmm5, %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm11[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm14[u,u,u,u,u,u,1,6,11],zero,zero,zero,zero,xmm14[u,u,u]
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2],xmm5[3,4,5,6,7]
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm10[3,8,13],zero,zero,zero,xmm10[u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm8[u,u,u,u,u,u],zero,zero,zero,xmm8[0,5,10,15,u,u,u]
; AVX-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1,2],xmm7[3,4,5,6,7]
; AVX-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm5 = xmm13[u,u,u],zero,zero,zero,xmm13[1,6,11,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[u,u,u,2,7,12],zero,zero,zero,xmm11[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm5, %xmm7, %xmm5
; AVX-NEXT:    vmovdqa {{.*#+}} xmm7 = [128,128,128,3,4,5,6,7,8,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm7, %xmm5, %xmm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm2, %xmm14, %xmm2
; AVX-NEXT:    vpor %xmm2, %xmm5, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm9, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vandps %ymm3, %ymm12, %ymm2
; AVX-NEXT:    vandnps %ymm1, %ymm12, %ymm0
; AVX-NEXT:    vorps %ymm0, %ymm2, %ymm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm9[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm9[4,9,14]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm5[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX-NEXT:    vpor %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX-NEXT:    vpmovsxwq {{.*#+}} xmm8 = [18446744073709551615,255]
; AVX-NEXT:    vpblendvb %xmm8, %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = [0,1,6,11,128,128,128,128,0,1,6,11,128,128,128,128]
; AVX-NEXT:    # xmm0 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm0, %xmm4, %xmm2
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = [0,128,128,128,0,5,10,15,0,128,128,128,0,5,10,15]
; AVX-NEXT:    # xmm1 = mem[0,0]
; AVX-NEXT:    vpshufb %xmm1, %xmm6, %xmm3
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = [128,0,0,3,8,13,128,128,128,0,0,3,8,13,128,128]
; AVX-NEXT:    # xmm3 = mem[0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm3, %xmm6, %xmm6
; AVX-NEXT:    vpor %xmm4, %xmm6, %xmm4
; AVX-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX-NEXT:    vpshufb {{.*#+}} xmm7 = xmm15[4,9,14],zero,zero,zero,zero,zero,zero,xmm15[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm7, %xmm4, %xmm4
; AVX-NEXT:    vmovdqa (%rsp), %xmm6 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm10 = xmm6[u,u,u,u,u,u],zero,zero,zero,xmm6[1,6,11,u,u,u,u]
; AVX-NEXT:    vmovq {{.*#+}} xmm7 = [128,128,128,3,8,13,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm12 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm7, %xmm12, %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm10 = xmm12[0,1,2],xmm10[3,4,5],xmm12[6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm12 = [12,128,128,128,0,0,2,7,12,128,128,128,0,0,2,7]
; AVX-NEXT:    # xmm12 = mem[0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm12, %xmm13, %xmm13
; AVX-NEXT:    vmovq {{.*#+}} xmm6 = [4,9,14,128,128,128,0,0,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm6, %xmm15, %xmm15
; AVX-NEXT:    vpblendw {{.*#+}} xmm13 = xmm15[0,1,2],xmm13[3,4,5],xmm15[6,7]
; AVX-NEXT:    vpor %xmm10, %xmm13, %xmm10
; AVX-NEXT:    vpblendvb %xmm8, %xmm4, %xmm2, %xmm2
; AVX-NEXT:    vbroadcastss {{.*#+}} xmm13 = [0,5,10,15,0,5,10,15,0,5,10,15,0,5,10,15]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm13, %xmm15, %xmm15
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm15, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm10[0,1,2],ymm4[3,4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm2
; AVX-NEXT:    vpshufb %xmm0, %xmm5, %xmm0
; AVX-NEXT:    vpshufb %xmm1, %xmm9, %xmm1
; AVX-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,zero,xmm1[2,7,12,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb %xmm3, %xmm11, %xmm3
; AVX-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,4,5,6,7,8,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm14[4,9,14],zero,zero,zero,zero,zero,zero,xmm14[u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vpblendvb %xmm8, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u,u,u],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm7, %xmm4, %xmm4
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2],xmm3[3,4,5],xmm4[6,7]
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm12, %xmm4, %xmm4
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX-NEXT:    vpblendw {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3,4,5],xmm5[6,7]
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX-NEXT:    vpshufb %xmm13, %xmm4, %xmm4
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm4, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3,4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rsi)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%rcx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, (%r8)
; AVX-NEXT:    vmovaps %ymm0, 32(%r9)
; AVX-NEXT:    vmovaps %ymm2, (%r9)
; AVX-NEXT:    addq $488, %rsp # imm = 0x1E8
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride5_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $136, %rsp
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa 224(%rdi), %ymm10
; AVX2-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm12 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm12, %ymm10, %ymm9, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm15
; AVX2-NEXT:    vpblendvb %ymm12, %ymm2, %ymm4, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm7
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm11
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 160(%rdi), %ymm13
; AVX2-NEXT:    vmovdqa 192(%rdi), %ymm14
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm1, %ymm13, %ymm14, %ymm0
; AVX2-NEXT:    vmovdqa %ymm1, %ymm6
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,128,4,9,14,128,128,128,2,7,12,u,u,u]
; AVX2-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,5,10,15,128,128,128,3,8,13,128,128,128,u,u,u]
; AVX2-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11,0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11]
; AVX2-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm3, %ymm15, %ymm15
; AVX2-NEXT:    vpmovsxwd {{.*#+}} xmm2 = [4294967295,4294967295,4294967295,255]
; AVX2-NEXT:    vpblendvb %ymm2, %ymm1, %ymm15, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpshufb %ymm3, %ymm7, %ymm7
; AVX2-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpblendvb %ymm6, %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm8
; AVX2-NEXT:    vpshufb %xmm5, %xmm8, %xmm5
; AVX2-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm7, %ymm15
; AVX2-NEXT:    vpblendvb %ymm12, %ymm13, %ymm14, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,6,11,128,128,128,128,4,9,14,128,128,128,u,u,u]
; AVX2-NEXT:    vpshufb %xmm6, %xmm0, %xmm5
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [128,128,128,0,5,10,15,128,128,128,3,8,13,u,u,u]
; AVX2-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12,1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12]
; AVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm5, %ymm8, %ymm8
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm8, %ymm8
; AVX2-NEXT:    vpshufb %ymm5, %ymm11, %ymm0
; AVX2-NEXT:    vpblendvb %ymm12, %ymm3, %ymm1, %ymm5
; AVX2-NEXT:    vpshufb %xmm6, %xmm5, %xmm6
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm11
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,1,6,11,128,128,128,128,4,9,14,u,u,u]
; AVX2-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = [2,7,12,128,128,128,0,5,10,15,128,128,128,u,u,u]
; AVX2-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13,2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13]
; AVX2-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm4, %ymm12, %ymm12
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm12
; AVX2-NEXT:    vpshufb %xmm5, %xmm12, %xmm5
; AVX2-NEXT:    vpshufb %xmm6, %xmm4, %xmm4
; AVX2-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [3,8,13,128,128,128,1,6,11,128,128,128,128,u,u,u]
; AVX2-NEXT:    vpshufb %xmm4, %xmm0, %xmm5
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,2,7,12,128,128,128,0,5,10,15,u,u,u]
; AVX2-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14,3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14]
; AVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm5, %ymm12, %ymm12
; AVX2-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm5
; AVX2-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX2-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm6
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm4 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm10, %ymm9, %ymm0
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[2,3,0,1]
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm0, %ymm4, %ymm10
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm2[2,3,0,1]
; AVX2-NEXT:    vpblendvb %ymm5, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,1,6,11,0,0,128,128,128,1,6,11]
; AVX2-NEXT:    vpmovsxbw {{.*#+}} ymm0 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-NEXT:    vpblendvb %ymm0, %ymm14, %ymm13, %ymm13
; AVX2-NEXT:    vmovdqa 304(%rdi), %xmm2
; AVX2-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm9
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,2,7,12,128,128,128,0,0,2,7,12,128,128,128]
; AVX2-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX2-NEXT:    vpshufb %xmm12, %xmm1, %xmm3
; AVX2-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovdqu (%rsp), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7],ymm3[8,9,10,11,12],ymm0[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovdqa 144(%rdi), %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX2-NEXT:    vmovdqa 128(%rdi), %xmm5
; AVX2-NEXT:    vpshufb %xmm12, %xmm5, %xmm12
; AVX2-NEXT:    vpor %xmm4, %xmm12, %xmm4
; AVX2-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0,1,2,3,4],ymm4[5,6,7],ymm15[8,9,10,11,12],ymm4[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,128,128,128,2,7,12,0,0,128,128,128,2,7,12]
; AVX2-NEXT:    vpshufb %xmm12, %xmm2, %xmm7
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm14 = [0,0,3,8,13,128,128,128,0,0,3,8,13,128,128,128]
; AVX2-NEXT:    vpshufb %xmm14, %xmm1, %xmm15
; AVX2-NEXT:    vpor %xmm7, %xmm15, %xmm7
; AVX2-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1,2,3,4],ymm7[5,6,7],ymm8[8,9,10,11,12],ymm7[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vpshufb %xmm12, %xmm3, %xmm8
; AVX2-NEXT:    vpshufb %xmm14, %xmm5, %xmm12
; AVX2-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-NEXT:    vpblendw {{.*#+}} ymm8 = ymm11[0,1,2,3,4],ymm8[5,6,7],ymm11[8,9,10,11,12],ymm8[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,128,128,128,128,4,9,14,0,128,128,128,128,4,9,14]
; AVX2-NEXT:    vpshufb %xmm12, %xmm2, %xmm11
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm15 = [0,0,5,10,15,128,128,128,0,0,5,10,15,128,128,128]
; AVX2-NEXT:    vpshufb %xmm15, %xmm1, %xmm14
; AVX2-NEXT:    vpor %xmm11, %xmm14, %xmm11
; AVX2-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-NEXT:    vpmovsxwq {{.*#+}} ymm14 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-NEXT:    vpshufb %xmm12, %xmm3, %xmm12
; AVX2-NEXT:    vpshufb %xmm15, %xmm5, %xmm15
; AVX2-NEXT:    vpor %xmm12, %xmm15, %xmm12
; AVX2-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-NEXT:    vpblendvb %ymm14, %ymm6, %ymm12, %ymm12
; AVX2-NEXT:    vextracti128 $1, %ymm13, %xmm15
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,3,8,13,128,128,128,1,6,11,u,u,u,u]
; AVX2-NEXT:    vpshufb %xmm6, %xmm15, %xmm15
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,9,14,128,128,128,2,7,12,128,128,128,u,u,u,u]
; AVX2-NEXT:    vpshufb %xmm7, %xmm13, %xmm13
; AVX2-NEXT:    vpor %xmm15, %xmm13, %xmm13
; AVX2-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15,4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15]
; AVX2-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX2-NEXT:    vpshufb %ymm15, %ymm10, %ymm10
; AVX2-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm10[3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 288(%rdi), %ymm13
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15]
; AVX2-NEXT:    vpshufb %ymm4, %ymm13, %ymm13
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm0 = [0,5,0,5,0,5,0,5]
; AVX2-NEXT:    vpermd %ymm13, %ymm0, %ymm13
; AVX2-NEXT:    vpblendvb %ymm14, %ymm10, %ymm13, %ymm10
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-NEXT:    vpshufb %ymm15, %ymm13, %ymm13
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm15
; AVX2-NEXT:    vpshufb %xmm6, %xmm15, %xmm6
; AVX2-NEXT:    vpshufb %xmm7, %xmm9, %xmm7
; AVX2-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm13[3,4,5,6,7]
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-NEXT:    vpshufb %ymm4, %ymm7, %ymm4
; AVX2-NEXT:    vpermd %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,3,8,13,0,0,128,128,128,3,8,13]
; AVX2-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm6 = [0,0,4,9,14,128,128,128,0,0,4,9,14,128,128,128]
; AVX2-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6,7],ymm2[8,9,10,11,12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vpshufb %xmm4, %xmm3, %xmm2
; AVX2-NEXT:    vpshufb %xmm6, %xmm5, %xmm3
; AVX2-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2,3,4],ymm2[5,6,7],ymm3[8,9,10,11,12],ymm2[13,14,15]
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovups (%rsp), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm1, 32(%rcx)
; AVX2-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-NEXT:    vmovdqa %ymm11, 32(%r8)
; AVX2-NEXT:    vmovdqa %ymm12, (%r8)
; AVX2-NEXT:    vmovdqa %ymm10, 32(%r9)
; AVX2-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-NEXT:    addq $136, %rsp
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i8_stride5_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $136, %rsp
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %ymm10
; AVX2-FP-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm12 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm9, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm15
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm2, %ymm4, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm7
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm11
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %ymm13
; AVX2-FP-NEXT:    vmovdqa 192(%rdi), %ymm14
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm1, %ymm13, %ymm14, %ymm0
; AVX2-FP-NEXT:    vmovdqa %ymm1, %ymm6
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,128,4,9,14,128,128,128,2,7,12,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,5,10,15,128,128,128,3,8,13,128,128,128,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpor %xmm1, %xmm0, %xmm1
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11,0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11]
; AVX2-FP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm15, %ymm15
; AVX2-FP-NEXT:    vpmovsxwd {{.*#+}} xmm2 = [4294967295,4294967295,4294967295,255]
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm1, %ymm15, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm7, %ymm7
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vpblendvb %ymm6, %ymm3, %ymm1, %ymm0
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm8
; AVX2-FP-NEXT:    vpshufb %xmm5, %xmm8, %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm7, %ymm15
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm13, %ymm14, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,6,11,128,128,128,128,4,9,14,128,128,128,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm0, %xmm5
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm4 = [128,128,128,0,5,10,15,128,128,128,3,8,13,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12,1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12]
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm8, %ymm8
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm8, %ymm8
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm11, %ymm0
; AVX2-FP-NEXT:    vpblendvb %ymm12, %ymm3, %ymm1, %ymm5
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm5, %xmm6
; AVX2-FP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm11
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,1,6,11,128,128,128,128,4,9,14,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [2,7,12,128,128,128,0,5,10,15,128,128,128,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13,2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13]
; AVX2-FP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm12, %ymm12
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm4
; AVX2-FP-NEXT:    vextracti128 $1, %ymm4, %xmm12
; AVX2-FP-NEXT:    vpshufb %xmm5, %xmm12, %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm4 = [3,8,13,128,128,128,1,6,11,128,128,128,128,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm0, %xmm5
; AVX2-FP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,2,7,12,128,128,128,0,5,10,15,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14,3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14]
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm12, %ymm12
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm5
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX2-FP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-FP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm6
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm4 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FP-NEXT:    vpblendvb %ymm4, %ymm10, %ymm9, %ymm0
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[2,3,0,1]
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-FP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm4, %ymm10
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm2[2,3,0,1]
; AVX2-FP-NEXT:    vpblendvb %ymm5, %ymm2, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,1,6,11,0,0,128,128,128,1,6,11]
; AVX2-FP-NEXT:    vpmovsxbw {{.*#+}} ymm0 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm14, %ymm13, %ymm13
; AVX2-FP-NEXT:    vmovdqa 304(%rdi), %xmm2
; AVX2-FP-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm9
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm2, %xmm0
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,2,7,12,128,128,128,0,0,2,7,12,128,128,128]
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm1, %xmm3
; AVX2-FP-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX2-FP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovdqu (%rsp), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7],ymm3[8,9,10,11,12],ymm0[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vmovdqa 144(%rdi), %xmm3
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %xmm5
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm5, %xmm12
; AVX2-FP-NEXT:    vpor %xmm4, %xmm12, %xmm4
; AVX2-FP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0,1,2,3,4],ymm4[5,6,7],ymm15[8,9,10,11,12],ymm4[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,128,128,128,2,7,12,0,0,128,128,128,2,7,12]
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm2, %xmm7
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm14 = [0,0,3,8,13,128,128,128,0,0,3,8,13,128,128,128]
; AVX2-FP-NEXT:    vpshufb %xmm14, %xmm1, %xmm15
; AVX2-FP-NEXT:    vpor %xmm7, %xmm15, %xmm7
; AVX2-FP-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1,2,3,4],ymm7[5,6,7],ymm8[8,9,10,11,12],ymm7[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm3, %xmm8
; AVX2-FP-NEXT:    vpshufb %xmm14, %xmm5, %xmm12
; AVX2-FP-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-FP-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm8 = ymm11[0,1,2,3,4],ymm8[5,6,7],ymm11[8,9,10,11,12],ymm8[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,128,128,128,128,4,9,14,0,128,128,128,128,4,9,14]
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm2, %xmm11
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm15 = [0,0,5,10,15,128,128,128,0,0,5,10,15,128,128,128]
; AVX2-FP-NEXT:    vpshufb %xmm15, %xmm1, %xmm14
; AVX2-FP-NEXT:    vpor %xmm11, %xmm14, %xmm11
; AVX2-FP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-FP-NEXT:    vpmovsxwq {{.*#+}} ymm14 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-FP-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FP-NEXT:    vpshufb %xmm12, %xmm3, %xmm12
; AVX2-FP-NEXT:    vpshufb %xmm15, %xmm5, %xmm15
; AVX2-FP-NEXT:    vpor %xmm12, %xmm15, %xmm12
; AVX2-FP-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm6, %ymm12, %ymm12
; AVX2-FP-NEXT:    vextracti128 $1, %ymm13, %xmm15
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,3,8,13,128,128,128,1,6,11,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm15, %xmm15
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,9,14,128,128,128,2,7,12,128,128,128,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb %xmm7, %xmm13, %xmm13
; AVX2-FP-NEXT:    vpor %xmm15, %xmm13, %xmm13
; AVX2-FP-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15,4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15]
; AVX2-FP-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX2-FP-NEXT:    vpshufb %ymm15, %ymm10, %ymm10
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm10[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 288(%rdi), %ymm13
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15]
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm13, %ymm13
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} ymm0 = [0,5,0,5,0,5,0,5]
; AVX2-FP-NEXT:    vpermd %ymm13, %ymm0, %ymm13
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm10, %ymm13, %ymm10
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FP-NEXT:    vpshufb %ymm15, %ymm13, %ymm13
; AVX2-FP-NEXT:    vextracti128 $1, %ymm9, %xmm15
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm15, %xmm6
; AVX2-FP-NEXT:    vpshufb %xmm7, %xmm9, %xmm7
; AVX2-FP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm13[3,4,5,6,7]
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm7, %ymm4
; AVX2-FP-NEXT:    vpermd %ymm4, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,3,8,13,0,0,128,128,128,3,8,13]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FP-NEXT:    vpbroadcastq {{.*#+}} xmm6 = [0,0,4,9,14,128,128,128,0,0,4,9,14,128,128,128]
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-FP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6,7],ymm2[8,9,10,11,12],ymm1[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vpshufb %xmm4, %xmm3, %xmm2
; AVX2-FP-NEXT:    vpshufb %xmm6, %xmm5, %xmm3
; AVX2-FP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2,3,4],ymm2[5,6,7],ymm3[8,9,10,11,12],ymm2[13,14,15]
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovups (%rsp), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm1, 32(%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-FP-NEXT:    vmovdqa %ymm11, 32(%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm12, (%r8)
; AVX2-FP-NEXT:    vmovdqa %ymm10, 32(%r9)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FP-NEXT:    addq $136, %rsp
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i8_stride5_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $136, %rsp
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %ymm10
; AVX2-FCP-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm12 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm10, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm15
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm2, %ymm4, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm7
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm11
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,255]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm9, %ymm10, %ymm0
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm5
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,0]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm4, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm3, %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %ymm13
; AVX2-FCP-NEXT:    vmovdqa 192(%rdi), %ymm14
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm1 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm1, %ymm13, %ymm14, %ymm0
; AVX2-FCP-NEXT:    vmovdqa %ymm1, %ymm6
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,128,4,9,14,128,128,128,2,7,12,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm5, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [0,5,10,15,128,128,128,3,8,13,128,128,128,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm1
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11,0,5,10,15,4,9,14,3,8,13,0,0,0,1,6,11]
; AVX2-FCP-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm15, %ymm15
; AVX2-FCP-NEXT:    vpmovsxwd {{.*#+}} xmm2 = [4294967295,4294967295,4294967295,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm1, %ymm15, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpblendvb %ymm6, %ymm3, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm8
; AVX2-FCP-NEXT:    vpshufb %xmm5, %xmm8, %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm7, %ymm15
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm13, %ymm14, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,6,11,128,128,128,128,4,9,14,128,128,128,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm0, %xmm5
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [128,128,128,0,5,10,15,128,128,128,3,8,13,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12,1,6,11,0,5,10,15,4,9,14,0,0,0,2,7,12]
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm11, %ymm0
; AVX2-FCP-NEXT:    vpblendvb %ymm12, %ymm3, %ymm1, %ymm5
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm5, %xmm6
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm5 = [128,128,128,1,6,11,128,128,128,128,4,9,14,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm5, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm6 = [2,7,12,128,128,128,0,5,10,15,128,128,128,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13,2,7,12,1,6,11,0,5,10,15,0,0,0,3,8,13]
; AVX2-FCP-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm12, %ymm12
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm4
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm4, %xmm12
; AVX2-FCP-NEXT:    vpshufb %xmm5, %xmm12, %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm4, %xmm4
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm7 = [65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm14, %ymm13, %ymm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm4 = [3,8,13,128,128,128,1,6,11,128,128,128,128,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm0, %xmm5
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,2,7,12,128,128,128,0,5,10,15,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpor %xmm5, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14,3,8,13,2,7,12,1,6,11,0,0,0,0,4,9,14]
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm12, %ymm12
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm0, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm5, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendvb %ymm7, %ymm1, %ymm3, %ymm5
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm5, %xmm4
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX2-FCP-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX2-FCP-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm6
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm4 = [65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0,65535]
; AVX2-FCP-NEXT:    vpblendvb %ymm4, %ymm10, %ymm9, %ymm0
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendvb %ymm4, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm0[2,3,0,1]
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255,255,0,255,0,255,255,0,255,0,255,255,0,255,0,255,255]
; AVX2-FCP-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm0, %ymm4, %ymm10
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm2[2,3,0,1]
; AVX2-FCP-NEXT:    vpblendvb %ymm5, %ymm2, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,1,6,11,0,0,128,128,128,1,6,11]
; AVX2-FCP-NEXT:    vpmovsxbw {{.*#+}} ymm0 = [0,65535,0,65535,0,0,65535,0,65535,0,0,65535,0,65535,0,0]
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm14, %ymm13, %ymm13
; AVX2-FCP-NEXT:    vmovdqa 304(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpblendvb %ymm0, %ymm1, %ymm3, %ymm9
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm2, %xmm0
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,2,7,12,128,128,128,0,0,2,7,12,128,128,128]
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm1, %xmm3
; AVX2-FCP-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovdqu (%rsp), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm0 = ymm3[0,1,2,3,4],ymm0[5,6,7],ymm3[8,9,10,11,12],ymm0[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovdqa 144(%rdi), %xmm3
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm3, %xmm4
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %xmm5
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm5, %xmm12
; AVX2-FCP-NEXT:    vpor %xmm4, %xmm12, %xmm4
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm4 = ymm15[0,1,2,3,4],ymm4[5,6,7],ymm15[8,9,10,11,12],ymm4[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,0,128,128,128,2,7,12,0,0,128,128,128,2,7,12]
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm2, %xmm7
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm14 = [0,0,3,8,13,128,128,128,0,0,3,8,13,128,128,128]
; AVX2-FCP-NEXT:    vpshufb %xmm14, %xmm1, %xmm15
; AVX2-FCP-NEXT:    vpor %xmm7, %xmm15, %xmm7
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm7 = ymm8[0,1,2,3,4],ymm7[5,6,7],ymm8[8,9,10,11,12],ymm7[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm3, %xmm8
; AVX2-FCP-NEXT:    vpshufb %xmm14, %xmm5, %xmm12
; AVX2-FCP-NEXT:    vpor %xmm8, %xmm12, %xmm8
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm8 = ymm11[0,1,2,3,4],ymm8[5,6,7],ymm11[8,9,10,11,12],ymm8[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm12 = [0,128,128,128,128,4,9,14,0,128,128,128,128,4,9,14]
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm2, %xmm11
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm15 = [0,0,5,10,15,128,128,128,0,0,5,10,15,128,128,128]
; AVX2-FCP-NEXT:    vpshufb %xmm15, %xmm1, %xmm14
; AVX2-FCP-NEXT:    vpor %xmm11, %xmm14, %xmm11
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-FCP-NEXT:    vpmovsxwq {{.*#+}} ymm14 = [18446744073709551615,18446744073709551615,18446744073709551615,255]
; AVX2-FCP-NEXT:    vpblendvb %ymm14, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    vpshufb %xmm12, %xmm3, %xmm12
; AVX2-FCP-NEXT:    vpshufb %xmm15, %xmm5, %xmm15
; AVX2-FCP-NEXT:    vpor %xmm12, %xmm15, %xmm12
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm6, %ymm12, %ymm12
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm13, %xmm15
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm6 = [128,128,128,3,8,13,128,128,128,1,6,11,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm15, %xmm15
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,9,14,128,128,128,2,7,12,128,128,128,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb %xmm7, %xmm13, %xmm13
; AVX2-FCP-NEXT:    vpor %xmm15, %xmm13, %xmm13
; AVX2-FCP-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15,4,9,14,3,8,13,2,7,12,0,0,0,0,5,10,15]
; AVX2-FCP-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX2-FCP-NEXT:    vpshufb %ymm15, %ymm10, %ymm10
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm13[0,1,2],ymm10[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 288(%rdi), %ymm13
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15,0,1,6,11,0,5,10,15]
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm13, %ymm13
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm0 = [0,5,0,5,0,5,0,5]
; AVX2-FCP-NEXT:    vpermd %ymm13, %ymm0, %ymm13
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm10, %ymm13, %ymm10
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Reload
; AVX2-FCP-NEXT:    vpshufb %ymm15, %ymm13, %ymm13
; AVX2-FCP-NEXT:    vextracti128 $1, %ymm9, %xmm15
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm15, %xmm6
; AVX2-FCP-NEXT:    vpshufb %xmm7, %xmm9, %xmm7
; AVX2-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2],ymm13[3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm7
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm7, %ymm4
; AVX2-FCP-NEXT:    vpermd %ymm4, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendvb %ymm14, %ymm6, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm4 = [0,0,128,128,128,3,8,13,0,0,128,128,128,3,8,13]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vpbroadcastq {{.*#+}} xmm6 = [0,0,4,9,14,128,128,128,0,0,4,9,14,128,128,128]
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0,1,2,3,4],ymm1[5,6,7],ymm2[8,9,10,11,12],ymm1[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vpshufb %xmm4, %xmm3, %xmm2
; AVX2-FCP-NEXT:    vpshufb %xmm6, %xmm5, %xmm3
; AVX2-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX2-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} ymm2 = ymm3[0,1,2,3,4],ymm2[5,6,7],ymm3[8,9,10,11,12],ymm2[13,14,15]
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups (%rsp), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm8, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm1, 32(%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-FCP-NEXT:    vmovdqa %ymm11, 32(%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm12, (%r8)
; AVX2-FCP-NEXT:    vmovdqa %ymm10, 32(%r9)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%r9)
; AVX2-FCP-NEXT:    addq $136, %rsp
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride5_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm5 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512-NEXT:    vmovdqa64 32(%rdi), %ymm24
; AVX512-NEXT:    vmovdqa64 64(%rdi), %ymm21
; AVX512-NEXT:    vmovdqa64 96(%rdi), %ymm22
; AVX512-NEXT:    vmovdqa %ymm5, %ymm4
; AVX512-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm10, %ymm6, %ymm6
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm7
; AVX512-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[2,7,12,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512-NEXT:    vpor %xmm7, %xmm8, %xmm12
; AVX512-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512-NEXT:    vpternlogq $236, %ymm19, %ymm6, %ymm12
; AVX512-NEXT:    vmovdqa64 192(%rdi), %ymm25
; AVX512-NEXT:    vmovdqa 224(%rdi), %ymm7
; AVX512-NEXT:    vmovdqa %ymm4, %ymm9
; AVX512-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm9
; AVX512-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX512-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512-NEXT:    vpshufb {{.*#+}} ymm13 = zero,zero,zero,zero,zero,zero,zero,ymm9[3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vmovdqa 176(%rdi), %xmm9
; AVX512-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX512-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512-NEXT:    vpternlogq $186, %ymm13, %ymm16, %ymm0
; AVX512-NEXT:    vmovdqa 144(%rdi), %xmm13
; AVX512-NEXT:    vpshufb %xmm10, %xmm13, %xmm10
; AVX512-NEXT:    vmovdqa 128(%rdi), %xmm14
; AVX512-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512-NEXT:    vpor %xmm10, %xmm15, %xmm10
; AVX512-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX512-NEXT:    vpternlogq $184, %zmm12, %zmm20, %zmm10
; AVX512-NEXT:    vmovdqa 256(%rdi), %ymm15
; AVX512-NEXT:    vmovdqa 288(%rdi), %ymm12
; AVX512-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm2
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero
; AVX512-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX512-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm18
; AVX512-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero
; AVX512-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm2
; AVX512-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm2
; AVX512-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,ymm2[4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[1,6,11],zero,zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm9[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm10, %xmm3
; AVX512-NEXT:    vpternlogq $186, %ymm2, %ymm16, %ymm3
; AVX512-NEXT:    vpmovsxdq {{.*#+}} ymm16 = [18446744073709551615,18446744073709551615,16777215,0]
; AVX512-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm3
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14],zero,zero,zero,xmm1[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[0,5,10,15],zero,zero,zero,xmm1[3,8,13,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX512-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm1
; AVX512-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpternlogq $184, %zmm1, %zmm20, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm17
; AVX512-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[u,u,u,1,6,11],zero,zero,zero,zero,xmm0[4,9,14],zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13]
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[2,7,12],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa %ymm10, %ymm3
; AVX512-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[1,6,11],zero,zero,zero,zero,xmm6[4,9,14,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15],zero,zero,zero,xmm3[u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm3
; AVX512-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpternlogq $184, %zmm3, %zmm20, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm19
; AVX512-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,2,7,12],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[3,8,13],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11],zero,zero,zero,zero,xmm3[u,u,u]
; AVX512-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-NEXT:    vpmovsxwq {{.*#+}} zmm2 = [0,0,0,18446744073709551360,18446744073709551615,18446744073709551615,18446744073709551615,18446744073709551615]
; AVX512-NEXT:    vpternlogq $226, %zmm3, %zmm2, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vpternlogq $226, %ymm15, %ymm4, %ymm12
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,3,8,13],zero,zero,zero,xmm12[1,6,11],zero,zero,zero,zero
; AVX512-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm10
; AVX512-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm10
; AVX512-NEXT:    vpshufb {{.*#+}} ymm3 = ymm10[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm9[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[4,9,14],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm3[3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX512-NEXT:    vpternlogq $226, %ymm1, %ymm16, %ymm3
; AVX512-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm5
; AVX512-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[4,9,14],zero,zero,zero,xmm5[2,7,12],zero,zero,zero,xmm5[u,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX512-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm5
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3,4,5,6,7]
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX512-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,5,0,5,0,5,0,5]
; AVX512-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX512-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm4
; AVX512-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm19, (%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i8_stride5_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512-FCP-NEXT:    vmovdqa64 32(%rdi), %ymm24
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm21
; AVX512-FCP-NEXT:    vmovdqa64 96(%rdi), %ymm22
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm4
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm10, %ymm6, %ymm6
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm7
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[2,7,12,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm12
; AVX512-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm6, %ymm12
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %ymm25
; AVX512-FCP-NEXT:    vmovdqa 224(%rdi), %ymm7
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm9
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm9
; AVX512-FCP-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX512-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = zero,zero,zero,zero,zero,zero,zero,ymm9[3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vmovdqa 176(%rdi), %xmm9
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512-FCP-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512-FCP-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512-FCP-NEXT:    vpternlogq $186, %ymm13, %ymm16, %ymm0
; AVX512-FCP-NEXT:    vmovdqa 144(%rdi), %xmm13
; AVX512-FCP-NEXT:    vpshufb %xmm10, %xmm13, %xmm10
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %xmm14
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm10, %xmm15, %xmm10
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX512-FCP-NEXT:    vpternlogq $184, %zmm12, %zmm20, %zmm10
; AVX512-FCP-NEXT:    vmovdqa 256(%rdi), %ymm15
; AVX512-FCP-NEXT:    vmovdqa 288(%rdi), %ymm12
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm2
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm18
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm2
; AVX512-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm2
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,ymm2[4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[1,6,11],zero,zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm9[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm3, %xmm10, %xmm3
; AVX512-FCP-NEXT:    vpternlogq $186, %ymm2, %ymm16, %ymm3
; AVX512-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm16 = [18446744073709551615,18446744073709551615,16777215,0]
; AVX512-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm3
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512-FCP-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14],zero,zero,zero,xmm1[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[0,5,10,15],zero,zero,zero,xmm1[3,8,13,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm1
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $184, %zmm1, %zmm20, %zmm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm17
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[u,u,u,1,6,11],zero,zero,zero,zero,xmm0[4,9,14],zero,zero,zero
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13]
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[2,7,12],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vmovdqa %ymm10, %ymm3
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[1,6,11],zero,zero,zero,zero,xmm6[4,9,14,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15],zero,zero,zero,xmm3[u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm3
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $184, %zmm3, %zmm20, %zmm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm19
; AVX512-FCP-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm0
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,2,7,12],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[3,8,13],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512-FCP-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512-FCP-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11],zero,zero,zero,zero,xmm3[u,u,u]
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512-FCP-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpmovsxwq {{.*#+}} zmm2 = [0,0,0,18446744073709551360,18446744073709551615,18446744073709551615,18446744073709551615,18446744073709551615]
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm3, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpternlogq $226, %ymm15, %ymm4, %ymm12
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,3,8,13],zero,zero,zero,xmm12[1,6,11],zero,zero,zero,zero
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm10
; AVX512-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm10
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm10[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm9[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[4,9,14],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm3[3,4,5,6,7]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX512-FCP-NEXT:    vpternlogq $226, %ymm1, %ymm16, %ymm3
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm5
; AVX512-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[4,9,14],zero,zero,zero,xmm5[2,7,12],zero,zero,zero,xmm5[u,u,u,u]
; AVX512-FCP-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX512-FCP-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm5
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3,4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,5,0,5,0,5,0,5]
; AVX512-FCP-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX512-FCP-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm4
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, (%rcx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i8_stride5_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm5 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512DQ-NEXT:    vmovdqa64 32(%rdi), %ymm24
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %ymm21
; AVX512DQ-NEXT:    vmovdqa64 96(%rdi), %ymm22
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm4
; AVX512DQ-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm10, %ymm6, %ymm6
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512DQ-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm7
; AVX512DQ-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[2,7,12,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm7, %xmm8, %xmm12
; AVX512DQ-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512DQ-NEXT:    vpternlogq $236, %ymm19, %ymm6, %ymm12
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %ymm25
; AVX512DQ-NEXT:    vmovdqa 224(%rdi), %ymm7
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm9
; AVX512DQ-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm9
; AVX512DQ-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX512DQ-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm13 = zero,zero,zero,zero,zero,zero,zero,ymm9[3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vmovdqa 176(%rdi), %xmm9
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512DQ-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512DQ-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512DQ-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-NEXT:    vpternlogq $186, %ymm13, %ymm16, %ymm0
; AVX512DQ-NEXT:    vmovdqa 144(%rdi), %xmm13
; AVX512DQ-NEXT:    vpshufb %xmm10, %xmm13, %xmm10
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %xmm14
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm10, %xmm15, %xmm10
; AVX512DQ-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX512DQ-NEXT:    vpternlogq $184, %zmm12, %zmm20, %zmm10
; AVX512DQ-NEXT:    vmovdqa 256(%rdi), %ymm15
; AVX512DQ-NEXT:    vmovdqa 288(%rdi), %ymm12
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512DQ-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm2
; AVX512DQ-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm18
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512DQ-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512DQ-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm2
; AVX512DQ-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm2
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,ymm2[4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[1,6,11],zero,zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm9[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm3, %xmm10, %xmm3
; AVX512DQ-NEXT:    vpternlogq $186, %ymm2, %ymm16, %ymm3
; AVX512DQ-NEXT:    vpmovsxdq {{.*#+}} ymm16 = [18446744073709551615,18446744073709551615,16777215,0]
; AVX512DQ-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm3
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14],zero,zero,zero,xmm1[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[0,5,10,15],zero,zero,zero,xmm1[3,8,13,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX512DQ-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm1
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpternlogq $184, %zmm1, %zmm20, %zmm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm17
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[u,u,u,1,6,11],zero,zero,zero,zero,xmm0[4,9,14],zero,zero,zero
; AVX512DQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13]
; AVX512DQ-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512DQ-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[2,7,12],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqa %ymm10, %ymm3
; AVX512DQ-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512DQ-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[1,6,11],zero,zero,zero,zero,xmm6[4,9,14,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15],zero,zero,zero,xmm3[u,u,u]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm3
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpternlogq $184, %zmm3, %zmm20, %zmm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm19
; AVX512DQ-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm0
; AVX512DQ-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,2,7,12],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512DQ-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[3,8,13],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512DQ-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512DQ-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512DQ-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11],zero,zero,zero,zero,xmm3[u,u,u]
; AVX512DQ-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512DQ-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovsxwq {{.*#+}} zmm2 = [0,0,0,18446744073709551360,18446744073709551615,18446744073709551615,18446744073709551615,18446744073709551615]
; AVX512DQ-NEXT:    vpternlogq $226, %zmm3, %zmm2, %zmm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpternlogq $226, %ymm15, %ymm4, %ymm12
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,3,8,13],zero,zero,zero,xmm12[1,6,11],zero,zero,zero,zero
; AVX512DQ-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512DQ-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512DQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm10
; AVX512DQ-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm10
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm3 = ymm10[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm9[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[4,9,14],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm3[3,4,5,6,7]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-NEXT:    vpternlogq $226, %ymm1, %ymm16, %ymm3
; AVX512DQ-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm5
; AVX512DQ-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[4,9,14],zero,zero,zero,xmm5[2,7,12],zero,zero,zero,xmm5[u,u,u,u]
; AVX512DQ-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX512DQ-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512DQ-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm5
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm4 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3,4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX512DQ-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,5,0,5,0,5,0,5]
; AVX512DQ-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX512DQ-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm4
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, (%rcx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i8_stride5_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm5 = [65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %ymm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 32(%rdi), %ymm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 96(%rdi), %ymm22
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm4
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [128,128,128,128,128,128,128,128,128,128,128,128,128,1,6,11,16,21,26,31,20,25,30,19,24,29,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm10, %ymm6, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm4 = [65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm7
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm7
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm7, %xmm8
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm8 = zero,zero,zero,zero,xmm8[4,9,14],zero,zero,zero,xmm8[2,7,12,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[0,5,10,15],zero,zero,zero,xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm7, %xmm8, %xmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm19 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm6, %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %ymm25
; AVX512DQ-FCP-NEXT:    vmovdqa 224(%rdi), %ymm7
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm9
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm9
; AVX512DQ-FCP-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX512DQ-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm13 = zero,zero,zero,zero,zero,zero,zero,ymm9[3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vmovdqa 176(%rdi), %xmm9
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm9[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vmovdqa 160(%rdi), %xmm11
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm11[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{.*#+}} ymm16 = [0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512DQ-FCP-NEXT:    vpternlogq $186, %ymm13, %ymm16, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa 144(%rdi), %xmm13
; AVX512DQ-FCP-NEXT:    vpshufb %xmm10, %xmm13, %xmm10
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %xmm14
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm10, %xmm15, %xmm10
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,0,0,0,0,0,0,0,0,0,0,0,0,0,65535,65535,65535,65535,65535,65535]
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %zmm12, %zmm20, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa 256(%rdi), %ymm15
; AVX512DQ-FCP-NEXT:    vmovdqa 288(%rdi), %ymm12
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm2
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u,u],zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm2[5,6,7]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm10, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u],zero,zero,zero,zero,xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,0,5,10,15],zero,zero,zero,xmm0[3,8,13],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm2
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm2
; AVX512DQ-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm2
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = zero,zero,zero,zero,zero,zero,zero,ymm2[4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[1,6,11],zero,zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm10 = zero,zero,zero,xmm9[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm3, %xmm10, %xmm3
; AVX512DQ-FCP-NEXT:    vpternlogq $186, %ymm2, %ymm16, %ymm3
; AVX512DQ-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm16 = [18446744073709551615,18446744073709551615,16777215,0]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm3
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm10 = [65535,0,65535,0,65535,65535,0,65535,0,65535,65535,0,65535,0,65535,65535]
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,2,7,12,17,22,27,16,21,26,31,20,25,30,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm24, %ymm23, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14],zero,zero,zero,xmm1[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[0,5,10,15],zero,zero,zero,xmm1[3,8,13,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm1, %xmm1
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %zmm1, %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm12, %ymm15, %ymm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[u,u,u,1,6,11],zero,zero,zero,zero,xmm0[4,9,14],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero,xmm0[3,8,13]
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[2,7,12],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,3,8,13,18,23,28,17,22,27,16,21,26,31,128,128,128,128,128,128]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm10, %ymm3
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm3, %xmm6
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm6[1,6,11],zero,zero,zero,zero,xmm6[4,9,14,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15],zero,zero,zero,xmm3[u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-FCP-NEXT:    vpternlogq $236, %ymm19, %ymm2, %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $184, %zmm3, %zmm20, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm10, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm15, %ymm12, %ymm0
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u],zero,zero,zero,xmm1[1,6,11],zero,zero,zero,zero,xmm1[4,9,14]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,2,7,12],zero,zero,zero,xmm0[0,5,10,15],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm7, %ymm25, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm9[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm11[3,8,13],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %ymm0, %ymm16, %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm5, %ymm0
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm21, %ymm22, %ymm0
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa {{.*#+}} ymm0 = [128,128,128,128,128,128,128,128,128,128,128,128,128,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb %ymm0, %ymm2, %ymm2
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, %ymm3
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11],zero,zero,zero,zero,xmm3[u,u,u]
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm3, %xmm3
; AVX512DQ-FCP-NEXT:    vpternlogq $236, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm3
; AVX512DQ-FCP-NEXT:    vpshufb %xmm0, %xmm13, %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm14[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-FCP-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpmovsxwq {{.*#+}} zmm2 = [0,0,0,18446744073709551360,18446744073709551615,18446744073709551615,18446744073709551615,18446744073709551615]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm3, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %ymm15, %ymm4, %ymm12
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm12[u,u,u,3,8,13],zero,zero,zero,xmm12[1,6,11],zero,zero,zero,zero
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm12, %xmm3
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm3, %xmm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm25, %ymm7, %ymm10
; AVX512DQ-FCP-NEXT:    vpternlogq $228, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm8, %ymm10
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm3 = ymm10[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,xmm9[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm7 = xmm11[4,9,14],zero,zero,zero,xmm11[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm6, %xmm7, %xmm6
; AVX512DQ-FCP-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1,2],xmm3[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %ymm1, %ymm16, %ymm3
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm23, %ymm24, %ymm5
; AVX512DQ-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm1
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,xmm1[3,8,13],zero,zero,zero,xmm1[1,6,11,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[4,9,14],zero,zero,zero,xmm5[2,7,12],zero,zero,zero,xmm5[u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpor %xmm1, %xmm5, %xmm1
; AVX512DQ-FCP-NEXT:    vpternlogq $202, %ymm22, %ymm21, %ymm4
; AVX512DQ-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-FCP-NEXT:    vpternlogq $216, {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm4, %ymm5
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm5[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [0,5,0,5,0,5,0,5]
; AVX512DQ-FCP-NEXT:    vpermd %ymm4, %ymm5, %ymm4
; AVX512DQ-FCP-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm4
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, (%rcx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%r8)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, (%r9)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i8_stride5_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512BW-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k1}
; AVX512BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k1}
; AVX512BW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-NEXT:    vpor %xmm6, %xmm5, %xmm10
; AVX512BW-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm10 {%k5} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm5
; AVX512BW-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX512BW-NEXT:    vpblendmw %ymm5, %ymm4, %ymm6 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512BW-NEXT:    movl $4228, %eax # imm = 0x1084
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqu8 %ymm7, %ymm6 {%k3}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vmovdqa 176(%rdi), %xmm6
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm6[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512BW-NEXT:    vmovdqa 160(%rdi), %xmm7
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512BW-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm11[2],xmm9[2],xmm11[3],xmm9[3]
; AVX512BW-NEXT:    movl $127, %eax
; AVX512BW-NEXT:    kmovd %eax, %k4
; AVX512BW-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k4}
; AVX512BW-NEXT:    vmovdqa 144(%rdi), %xmm12
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[1,6,11]
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512BW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm9, %zmm8
; AVX512BW-NEXT:    vmovdqu16 %zmm8, %zmm10 {%k5}
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512BW-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512BW-NEXT:    vmovdqa 288(%rdi), %ymm8
; AVX512BW-NEXT:    vpblendmw %ymm9, %ymm8, %ymm14 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,u],zero,zero,zero,xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,4,9,14],zero,zero,zero,xmm14[2,7,12],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm18
; AVX512BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm11 {%k3}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm14 = ymm11[2,3,0,1]
; AVX512BW-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512BW-NEXT:    kmovd %eax, %k6
; AVX512BW-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k6}
; AVX512BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm14 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero,xmm14[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13,u,u,u]
; AVX512BW-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendmw %ymm5, %ymm4, %ymm11 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,3,0,1]
; AVX512BW-NEXT:    movl $8456, %eax # imm = 0x2108
; AVX512BW-NEXT:    kmovd %eax, %k6
; AVX512BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k6}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[2,7,12]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm11
; AVX512BW-NEXT:    vmovdqu16 %zmm11, %zmm14 {%k5}
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm14, %ymm11
; AVX512BW-NEXT:    vpblendmw %ymm8, %ymm9, %ymm15 {%k1}
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u],zero,zero,zero,zero,xmm16[4,9,14],zero,zero,zero,xmm16[2,7,12]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,0,5,10,15],zero,zero,zero,xmm15[3,8,13],zero,zero,zero
; AVX512BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-NEXT:    movl $-524288, %eax # imm = 0xFFF80000
; AVX512BW-NEXT:    kmovd %eax, %k4
; AVX512BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm19
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm14 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm14[2,3,0,1]
; AVX512BW-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512BW-NEXT:    kmovd %eax, %k6
; AVX512BW-NEXT:    vmovdqu8 %ymm15, %ymm14 {%k6}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k3}
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm16[1,6,11],zero,zero,zero,zero,xmm16[4,9,14,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15],zero,zero,zero,xmm15[u,u,u]
; AVX512BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendmw %ymm4, %ymm5, %ymm14 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm16 = ymm14[2,3,0,1]
; AVX512BW-NEXT:    movl $16912, %eax # imm = 0x4210
; AVX512BW-NEXT:    kmovd %eax, %k6
; AVX512BW-NEXT:    vmovdqu8 %ymm16, %ymm14 {%k6}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm14 = ymm14[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[2,7,12],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vporq %xmm16, %xmm17, %xmm10
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2],xmm14[3,4,5,6,7]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[3,8,13]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512BW-NEXT:    vporq %xmm14, %xmm16, %xmm14
; AVX512BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm14, %zmm10
; AVX512BW-NEXT:    vmovdqu16 %zmm10, %zmm15 {%k5}
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm15, %ymm10
; AVX512BW-NEXT:    vpblendmw %ymm8, %ymm9, %ymm14 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero
; AVX512BW-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u],zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13]
; AVX512BW-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-NEXT:    vmovdqu8 %ymm14, %ymm10 {%k4}
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm15, %zmm14
; AVX512BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm10 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm10[2,3,0,1]
; AVX512BW-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vmovdqu8 %ymm15, %ymm10 {%k5}
; AVX512BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11],zero,zero,zero,zero,xmm15[u,u,u]
; AVX512BW-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15,u,u,u]
; AVX512BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendmw %ymm4, %ymm5, %ymm10 {%k2}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm16 = ymm10[2,3,0,1]
; AVX512BW-NEXT:    movl $33825, %eax # imm = 0x8421
; AVX512BW-NEXT:    kmovd %eax, %k5
; AVX512BW-NEXT:    vmovdqu8 %ymm16, %ymm10 {%k5}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vporq %xmm16, %xmm17, %xmm11
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm10[3,4,5,6,7]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm12[4,9,14]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512BW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512BW-NEXT:    movl $33554431, %eax # imm = 0x1FFFFFF
; AVX512BW-NEXT:    kmovq %rax, %k5
; AVX512BW-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k5}
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512BW-NEXT:    vpblendmw %ymm9, %ymm8, %ymm12 {%k3}
; AVX512BW-NEXT:    vextracti128 $1, %ymm12, %xmm13
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,2,7,12],zero,zero,zero,xmm12[0,5,10,15],zero,zero,zero
; AVX512BW-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512BW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512BW-NEXT:    vmovdqu8 %ymm12, %ymm11 {%k4}
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512BW-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k2}
; AVX512BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512BW-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512BW-NEXT:    vmovdqu16 %ymm5, %ymm4 {%k3}
; AVX512BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[2,3,0,1]
; AVX512BW-NEXT:    movl $2114, %eax # imm = 0x842
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu8 %ymm1, %ymm4 {%k2}
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm6[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512BW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,5,0,5,0,5,0,5]
; AVX512BW-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k5}
; AVX512BW-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; AVX512BW-NEXT:    vmovdqu16 %ymm9, %ymm8 {%k1}
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,3,8,13],zero,zero,zero,xmm8[1,6,11],zero,zero,zero,zero
; AVX512BW-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k4}
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i8_stride5_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k1}
; AVX512BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k1}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm10
; AVX512BW-FCP-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 {%k5} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vmovdqa 192(%rdi), %ymm5
; AVX512BW-FCP-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX512BW-FCP-NEXT:    vpblendmw %ymm5, %ymm4, %ymm6 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $4228, %eax # imm = 0x1084
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm7, %ymm6 {%k3}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vmovdqa 176(%rdi), %xmm6
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm6[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vmovdqa 160(%rdi), %xmm7
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm11[2],xmm9[2],xmm11[3],xmm9[3]
; AVX512BW-FCP-NEXT:    movl $127, %eax
; AVX512BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k4}
; AVX512BW-FCP-NEXT:    vmovdqa 144(%rdi), %xmm12
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[1,6,11]
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm8, %zmm9, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu16 %zmm8, %zmm10 {%k5}
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512BW-FCP-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512BW-FCP-NEXT:    vmovdqa 288(%rdi), %ymm8
; AVX512BW-FCP-NEXT:    vpblendmw %ymm9, %ymm8, %ymm14 {%k2}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,u],zero,zero,zero,xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,4,9,14],zero,zero,zero,xmm14[2,7,12],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5,6,7]
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm18
; AVX512BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm11 {%k3}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm11[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k6}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm14 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero,xmm14[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendmw %ymm5, %ymm4, %ymm11 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $8456, %eax # imm = 0x2108
; AVX512BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k6}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[2,7,12]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu16 %zmm11, %zmm14 {%k5}
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm14, %ymm11
; AVX512BW-FCP-NEXT:    vpblendmw %ymm8, %ymm9, %ymm15 {%k1}
; AVX512BW-FCP-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u],zero,zero,zero,zero,xmm16[4,9,14],zero,zero,zero,xmm16[2,7,12]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,0,5,10,15],zero,zero,zero,xmm15[3,8,13],zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-FCP-NEXT:    movl $-524288, %eax # imm = 0xFFF80000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm19
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm14 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm14[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm14 {%k6}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k3}
; AVX512BW-FCP-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm16[1,6,11],zero,zero,zero,zero,xmm16[4,9,14,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15],zero,zero,zero,xmm15[u,u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendmw %ymm4, %ymm5, %ymm14 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm16 = ymm14[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $16912, %eax # imm = 0x4210
; AVX512BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm16, %ymm14 {%k6}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm14[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[2,7,12],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm17, %xmm10
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2],xmm14[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[3,8,13]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512BW-FCP-NEXT:    vporq %xmm14, %xmm16, %xmm14
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm14, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu16 %zmm10, %zmm15 {%k5}
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm15, %ymm10
; AVX512BW-FCP-NEXT:    vpblendmw %ymm8, %ymm9, %ymm14 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u],zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13]
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm14, %ymm10 {%k4}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm15, %zmm14
; AVX512BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm10 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm10[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm10 {%k5}
; AVX512BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11],zero,zero,zero,zero,xmm15[u,u,u]
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15,u,u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512BW-FCP-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendmw %ymm4, %ymm5, %ymm10 {%k2}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm16 = ymm10[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $33825, %eax # imm = 0x8421
; AVX512BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm16, %ymm10 {%k5}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vporq %xmm16, %xmm17, %xmm11
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm10[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm12[4,9,14]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512BW-FCP-NEXT:    movl $33554431, %eax # imm = 0x1FFFFFF
; AVX512BW-FCP-NEXT:    kmovq %rax, %k5
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k5}
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512BW-FCP-NEXT:    vpblendmw %ymm9, %ymm8, %ymm12 {%k3}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm12, %xmm13
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,2,7,12],zero,zero,zero,xmm12[0,5,10,15],zero,zero,zero
; AVX512BW-FCP-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm12, %ymm11 {%k4}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k2}
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm5, %ymm4 {%k3}
; AVX512BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[2,3,0,1]
; AVX512BW-FCP-NEXT:    movl $2114, %eax # imm = 0x842
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm4 {%k2}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm6[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,5,0,5,0,5,0,5]
; AVX512BW-FCP-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k5}
; AVX512BW-FCP-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqu16 %ymm9, %ymm8 {%k1}
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,3,8,13],zero,zero,zero,xmm8[1,6,11],zero,zero,zero,zero
; AVX512BW-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512BW-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-FCP-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k4}
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, (%rcx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i8_stride5_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-BW-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-BW-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k1}
; AVX512DQ-BW-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k1}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm6, %xmm5, %xmm10
; AVX512DQ-BW-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm10 {%k5} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vmovdqa 192(%rdi), %ymm5
; AVX512DQ-BW-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX512DQ-BW-NEXT:    vpblendmw %ymm5, %ymm4, %ymm6 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $4228, %eax # imm = 0x1084
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm7, %ymm6 {%k3}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vmovdqa 176(%rdi), %xmm6
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm6[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vmovdqa 160(%rdi), %xmm7
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm11[2],xmm9[2],xmm11[3],xmm9[3]
; AVX512DQ-BW-NEXT:    movl $127, %eax
; AVX512DQ-BW-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k4}
; AVX512DQ-BW-NEXT:    vmovdqa 144(%rdi), %xmm12
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm9 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[1,6,11]
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm8, %zmm9, %zmm8
; AVX512DQ-BW-NEXT:    vmovdqu16 %zmm8, %zmm10 {%k5}
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512DQ-BW-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512DQ-BW-NEXT:    vmovdqa 288(%rdi), %ymm8
; AVX512DQ-BW-NEXT:    vpblendmw %ymm9, %ymm8, %ymm14 {%k2}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,u],zero,zero,zero,xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,4,9,14],zero,zero,zero,xmm14[2,7,12],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5,6,7]
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm18
; AVX512DQ-BW-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm11 {%k3}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm14 = ymm11[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k6}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm2, %ymm3, %ymm14 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero,xmm14[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendmw %ymm5, %ymm4, %ymm11 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $8456, %eax # imm = 0x2108
; AVX512DQ-BW-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k6}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[2,7,12]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqu16 %zmm11, %zmm14 {%k5}
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm14, %ymm11
; AVX512DQ-BW-NEXT:    vpblendmw %ymm8, %ymm9, %ymm15 {%k1}
; AVX512DQ-BW-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u],zero,zero,zero,zero,xmm16[4,9,14],zero,zero,zero,xmm16[2,7,12]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,0,5,10,15],zero,zero,zero,xmm15[3,8,13],zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-NEXT:    movl $-524288, %eax # imm = 0xFFF80000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm19
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm14 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm14[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm15, %ymm14 {%k6}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k3}
; AVX512DQ-BW-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm16[1,6,11],zero,zero,zero,zero,xmm16[4,9,14,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15],zero,zero,zero,xmm15[u,u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendmw %ymm4, %ymm5, %ymm14 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm16 = ymm14[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $16912, %eax # imm = 0x4210
; AVX512DQ-BW-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm16, %ymm14 {%k6}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm14 = ymm14[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[2,7,12],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm17, %xmm10
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2],xmm14[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[3,8,13]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-BW-NEXT:    vporq %xmm14, %xmm16, %xmm14
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm14, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqu16 %zmm10, %zmm15 {%k5}
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm15, %ymm10
; AVX512DQ-BW-NEXT:    vpblendmw %ymm8, %ymm9, %ymm14 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u],zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13]
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm14, %ymm10 {%k4}
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm15, %zmm14
; AVX512DQ-BW-NEXT:    vpblendmw %ymm0, %ymm1, %ymm10 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm15 = ymm10[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm15, %ymm10 {%k5}
; AVX512DQ-BW-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11],zero,zero,zero,zero,xmm15[u,u,u]
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15,u,u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendmw %ymm4, %ymm5, %ymm10 {%k2}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm16 = ymm10[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $33825, %eax # imm = 0x8421
; AVX512DQ-BW-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm16, %ymm10 {%k5}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vporq %xmm16, %xmm17, %xmm11
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm10[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm12[4,9,14]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512DQ-BW-NEXT:    movl $33554431, %eax # imm = 0x1FFFFFF
; AVX512DQ-BW-NEXT:    kmovq %rax, %k5
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k5}
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512DQ-BW-NEXT:    vpblendmw %ymm9, %ymm8, %ymm12 {%k3}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm12, %xmm13
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,2,7,12],zero,zero,zero,xmm12[0,5,10,15],zero,zero,zero
; AVX512DQ-BW-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm12, %ymm11 {%k4}
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k2}
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm5, %ymm4 {%k3}
; AVX512DQ-BW-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[2,3,0,1]
; AVX512DQ-BW-NEXT:    movl $2114, %eax # imm = 0x842
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm1, %ymm4 {%k2}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm6[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-BW-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,5,0,5,0,5,0,5]
; AVX512DQ-BW-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k5}
; AVX512DQ-BW-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqu16 %ymm9, %ymm8 {%k1}
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,3,8,13],zero,zero,zero,xmm8[1,6,11],zero,zero,zero,zero
; AVX512DQ-BW-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512DQ-BW-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-BW-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k4}
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, (%rcx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i8_stride5_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 32(%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    movw $21140, %ax # imm = 0x5294
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm1, %ymm0, %ymm4 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm5 = ymm4[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $1108344832, %eax # imm = 0x42100000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm5, %ymm4 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movw $19026, %ax # imm = 0x4A52
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm5 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm6 = zero,zero,zero,zero,xmm6[4,9,14],zero,zero,zero,xmm6[2,7,12,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[0,5,10,15],zero,zero,zero,xmm5[3,8,13],zero,zero,zero,xmm5[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm6, %xmm5, %xmm10
; AVX512DQ-BW-FCP-NEXT:    movl $67100672, %eax # imm = 0x3FFE000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 {%k5} = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,1,6,11,16,21,26,31,20,25,30,19,24,29,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 192(%rdi), %ymm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm5, %ymm4, %ymm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $4228, %eax # imm = 0x1084
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm7, %ymm6 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm8 = ymm6[u,u,u,u,u,u,u,3,8,13,2,7,12,1,6,11,16,21,26,31,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 176(%rdi), %xmm6
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm6[u,u,u,u,u,u,u,u,4,9,14,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 160(%rdi), %xmm7
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm7[u,u,u,u,u,u,u,u,0,5,10,15,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpunpckhdq {{.*#+}} xmm9 = xmm11[2],xmm9[2],xmm11[3],xmm9[3]
; AVX512DQ-BW-FCP-NEXT:    movl $127, %eax
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm9, %ymm8 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 144(%rdi), %xmm12
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm9 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[1,6,11]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm13[u,u,u,u,u,u,u,u,u,u,2,7,12],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm9, %xmm11, %xmm9
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm8, %zmm9, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %zmm8, %zmm10 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 256(%rdi), %ymm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 288(%rdi), %ymm8
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm9, %ymm8, %ymm14 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,u],zero,zero,zero,xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u,u,4,9,14],zero,zero,zero,xmm14[2,7,12],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3,4],ymm14[5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm18
; AVX512DQ-BW-FCP-NEXT:    movw $10570, %ax # imm = 0x294A
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k3
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm11 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm14 = ymm11[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $-2078212096, %eax # imm = 0x84210000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm14, %ymm11 {%k6}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm2, %ymm3, %ymm14 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm14[1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero,xmm14[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm15, %xmm14, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm14 {%k5} = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,2,7,12,17,22,27,16,21,26,31,20,25,30,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm5, %ymm4, %ymm11 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm11[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $8456, %eax # imm = 0x2108
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k6}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm11 = ymm11[u,u,u,u,u,u,u,4,9,14,3,8,13,2,7,12,17,22,27,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm7[1,6,11],zero,zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[0,5,10,15,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[2,7,12]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,3,8,13],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm15, %xmm16, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm15, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %zmm11, %zmm14 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm14, %ymm11
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm8, %ymm9, %ymm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm16[u,u,u],zero,zero,zero,zero,xmm16[4,9,14],zero,zero,zero,xmm16[2,7,12]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[u,u,u,0,5,10,15],zero,zero,zero,xmm15[3,8,13],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-FCP-NEXT:    movl $-524288, %eax # imm = 0xFFF80000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k4
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm11 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm14, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm14[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $138543104, %eax # imm = 0x8420000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm14 {%k6}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vextracti32x4 $1, %ymm15, %xmm16
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm16[1,6,11],zero,zero,zero,zero,xmm16[4,9,14,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15],zero,zero,zero,xmm15[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm14[u,u,u,u,u,u,u,u,u,u,u,u,u,3,8,13,18,23,28,17,22,27,16,21,26,31,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm4, %ymm5, %ymm14 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm16 = ymm14[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $16912, %eax # imm = 0x4210
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k6
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm16, %ymm14 {%k6}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm14 = ymm14[u,u,u,u,u,u,0,5,10,15,4,9,14,3,8,13,18,23,28,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[1,6,11,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[2,7,12],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm17, %xmm10
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm10 = xmm10[0,1,2],xmm14[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm12[u,u,u,u,u,u,u,u,u,u],zero,zero,zero,xmm12[3,8,13]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm13[u,u,u,u,u,u,u,u,u,u,4,9,14],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm14, %xmm16, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm14, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %zmm10, %zmm15 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm15, %ymm10
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm8, %ymm9, %ymm14 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm14[u,u,u,1,6,11],zero,zero,zero,zero,xmm14[4,9,14],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm14 = xmm14[u,u,u],zero,zero,zero,xmm14[0,5,10,15],zero,zero,zero,xmm14[3,8,13]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm14, %xmm14
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm14, %ymm10 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm15, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm0, %ymm1, %ymm10 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm15 = ymm10[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $277086208, %eax # imm = 0x10840000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm15, %ymm10 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm3, %ymm2, %ymm15 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = xmm15[3,8,13],zero,zero,zero,xmm15[1,6,11],zero,zero,zero,zero,xmm15[u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm15 = zero,zero,zero,xmm15[2,7,12],zero,zero,zero,xmm15[0,5,10,15,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm15, %xmm15
; AVX512DQ-BW-FCP-NEXT:    movl $33546240, %eax # imm = 0x1FFE000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm15 {%k5} = ymm10[u,u,u,u,u,u,u,u,u,u,u,u,u,4,9,14,19,24,29,18,23,28,17,22,27,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm4, %ymm5, %ymm10 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm16 = ymm10[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $33825, %eax # imm = 0x8421
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm16, %ymm10 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm10 = ymm10[u,u,u,u,u,u,1,6,11,0,5,10,15,4,9,14,19,24,29,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm16 = zero,zero,zero,xmm6[2,7,12,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm17 = xmm7[3,8,13],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vporq %xmm16, %xmm17, %xmm11
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm11 = xmm11[0,1,2],xmm10[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm11 = xmm12[u,u,u,u,u,u,u,u,u],zero,zero,zero,zero,xmm12[4,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm13[u,u,u,u,u,u,u,u,u,0,5,10,15],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm11, %xmm12, %xmm11
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm10, %zmm11, %zmm10
; AVX512DQ-BW-FCP-NEXT:    movl $33554431, %eax # imm = 0x1FFFFFF
; AVX512DQ-BW-FCP-NEXT:    kmovq %rax, %k5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm15, %zmm10 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm10, %ymm11
; AVX512DQ-BW-FCP-NEXT:    vpblendmw %ymm9, %ymm8, %ymm12 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm12, %xmm13
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm13 = xmm13[u,u,u],zero,zero,zero,xmm13[1,6,11],zero,zero,zero,zero,xmm13[4,9,14]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm12 = xmm12[u,u,u,2,7,12],zero,zero,zero,xmm12[0,5,10,15],zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm13, %xmm12, %xmm12
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm12, %ymm11 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm11, %zmm10, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm3, %ymm2 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,xmm3[3,8,13],zero,zero,zero,xmm3[1,6,11,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[4,9,14],zero,zero,zero,xmm2[2,7,12],zero,zero,zero,xmm2[u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm3, %xmm2, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm1, %ymm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $554172416, %eax # imm = 0x21080000
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm0 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[u,u,u,u,u,u,u,u,u,u,u,u,0,5,10,15,20,25,30,19,24,29,18,23,28,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm5, %ymm4 {%k3}
; AVX512DQ-BW-FCP-NEXT:    vpermq {{.*#+}} ymm1 = ymm4[2,3,0,1]
; AVX512DQ-BW-FCP-NEXT:    movl $2114, %eax # imm = 0x842
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm1, %ymm4 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,2,7,12,1,6,11,0,5,10,15,20,25,30,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,xmm6[3,8,13,u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm7[4,9,14],zero,zero,zero,xmm7[u,u,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2],xmm1[3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,1,6,11,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,16,21,26,31,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [0,5,0,5,0,5,0,5]
; AVX512DQ-BW-FCP-NEXT:    vpermd %ymm2, %ymm3, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k5}
; AVX512DQ-BW-FCP-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu16 %ymm9, %ymm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm2 = xmm8[u,u,u,3,8,13],zero,zero,zero,xmm8[1,6,11],zero,zero,zero,zero
; AVX512DQ-BW-FCP-NEXT:    vextracti128 $1, %ymm8, %xmm3
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm3 = xmm3[u,u,u],zero,zero,zero,xmm3[2,7,12],zero,zero,zero,xmm3[0,5,10,15]
; AVX512DQ-BW-FCP-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu8 %ymm2, %ymm0 {%k4}
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, (%rcx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%r9)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <320 x i8>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <320 x i8> %wide.vec, <320 x i8> poison, <64 x i32> <i32 0, i32 5, i32 10, i32 15, i32 20, i32 25, i32 30, i32 35, i32 40, i32 45, i32 50, i32 55, i32 60, i32 65, i32 70, i32 75, i32 80, i32 85, i32 90, i32 95, i32 100, i32 105, i32 110, i32 115, i32 120, i32 125, i32 130, i32 135, i32 140, i32 145, i32 150, i32 155, i32 160, i32 165, i32 170, i32 175, i32 180, i32 185, i32 190, i32 195, i32 200, i32 205, i32 210, i32 215, i32 220, i32 225, i32 230, i32 235, i32 240, i32 245, i32 250, i32 255, i32 260, i32 265, i32 270, i32 275, i32 280, i32 285, i32 290, i32 295, i32 300, i32 305, i32 310, i32 315>
  %strided.vec1 = shufflevector <320 x i8> %wide.vec, <320 x i8> poison, <64 x i32> <i32 1, i32 6, i32 11, i32 16, i32 21, i32 26, i32 31, i32 36, i32 41, i32 46, i32 51, i32 56, i32 61, i32 66, i32 71, i32 76, i32 81, i32 86, i32 91, i32 96, i32 101, i32 106, i32 111, i32 116, i32 121, i32 126, i32 131, i32 136, i32 141, i32 146, i32 151, i32 156, i32 161, i32 166, i32 171, i32 176, i32 181, i32 186, i32 191, i32 196, i32 201, i32 206, i32 211, i32 216, i32 221, i32 226, i32 231, i32 236, i32 241, i32 246, i32 251, i32 256, i32 261, i32 266, i32 271, i32 276, i32 281, i32 286, i32 291, i32 296, i32 301, i32 306, i32 311, i32 316>
  %strided.vec2 = shufflevector <320 x i8> %wide.vec, <320 x i8> poison, <64 x i32> <i32 2, i32 7, i32 12, i32 17, i32 22, i32 27, i32 32, i32 37, i32 42, i32 47, i32 52, i32 57, i32 62, i32 67, i32 72, i32 77, i32 82, i32 87, i32 92, i32 97, i32 102, i32 107, i32 112, i32 117, i32 122, i32 127, i32 132, i32 137, i32 142, i32 147, i32 152, i32 157, i32 162, i32 167, i32 172, i32 177, i32 182, i32 187, i32 192, i32 197, i32 202, i32 207, i32 212, i32 217, i32 222, i32 227, i32 232, i32 237, i32 242, i32 247, i32 252, i32 257, i32 262, i32 267, i32 272, i32 277, i32 282, i32 287, i32 292, i32 297, i32 302, i32 307, i32 312, i32 317>
  %strided.vec3 = shufflevector <320 x i8> %wide.vec, <320 x i8> poison, <64 x i32> <i32 3, i32 8, i32 13, i32 18, i32 23, i32 28, i32 33, i32 38, i32 43, i32 48, i32 53, i32 58, i32 63, i32 68, i32 73, i32 78, i32 83, i32 88, i32 93, i32 98, i32 103, i32 108, i32 113, i32 118, i32 123, i32 128, i32 133, i32 138, i32 143, i32 148, i32 153, i32 158, i32 163, i32 168, i32 173, i32 178, i32 183, i32 188, i32 193, i32 198, i32 203, i32 208, i32 213, i32 218, i32 223, i32 228, i32 233, i32 238, i32 243, i32 248, i32 253, i32 258, i32 263, i32 268, i32 273, i32 278, i32 283, i32 288, i32 293, i32 298, i32 303, i32 308, i32 313, i32 318>
  %strided.vec4 = shufflevector <320 x i8> %wide.vec, <320 x i8> poison, <64 x i32> <i32 4, i32 9, i32 14, i32 19, i32 24, i32 29, i32 34, i32 39, i32 44, i32 49, i32 54, i32 59, i32 64, i32 69, i32 74, i32 79, i32 84, i32 89, i32 94, i32 99, i32 104, i32 109, i32 114, i32 119, i32 124, i32 129, i32 134, i32 139, i32 144, i32 149, i32 154, i32 159, i32 164, i32 169, i32 174, i32 179, i32 184, i32 189, i32 194, i32 199, i32 204, i32 209, i32 214, i32 219, i32 224, i32 229, i32 234, i32 239, i32 244, i32 249, i32 254, i32 259, i32 264, i32 269, i32 274, i32 279, i32 284, i32 289, i32 294, i32 299, i32 304, i32 309, i32 314, i32 319>
  store <64 x i8> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i8> %strided.vec1, ptr %out.vec1, align 64
  store <64 x i8> %strided.vec2, ptr %out.vec2, align 64
  store <64 x i8> %strided.vec3, ptr %out.vec3, align 64
  store <64 x i8> %strided.vec4, ptr %out.vec4, align 64
  ret void
}
