use crate::inc::inc::BigFloatInc;

pub(crate) const SQRT_VALUES: [BigFloatInc; 1090] = [
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -28,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -26,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -24,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6719, 8569, 9807, 2096, 8724, 168, 488, 3095, 6237, 2135, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8052, 6942, 7236, 5058, 6341, 2744, 2935, 8877, 756, 508, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6184, 5440, 7623, 7312, 3668, 917, 6964, 9789, 7749, 679, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9475, 1965, 9139, 7058, 4074, 9728, 981, 3178, 4278, 4897, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2592, 5710, 6042, 6392, 5753, 161, 5905, 4590, 1106, 7513, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3438, 7139, 9615, 4193, 7448, 337, 976, 6190, 2474, 4271, 2828],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5551, 3719, 1853, 4327, 3544, 9889, 3319, 8379, 6016, 2776, 3162],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [885, 3927, 8668, 6706, 2736, 1493, 8491, 5399, 9035, 6247, 3316],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6105, 3885, 4473, 117, 2683, 5489, 5870, 7754, 1513, 1016, 3464],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2966, 6251, 9594, 4704, 1267, 1922, 2931, 3989, 7546, 5512, 3605],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [198, 1756, 4930, 3165, 8732, 8374, 3855, 3941, 8677, 6573, 3741],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9217, 832, 9961, 7823, 5399, 7926, 8851, 7416, 4620, 9833, 3872],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1992, 5147, 7702, 9740, 9855, 2140, 5498, 7660, 2561, 1056, 4123],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [156, 5709, 9423, 6290, 6172, 506, 1464, 9285, 8711, 6406, 4242],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [39, 9137, 1565, 8596, 1983, 3698, 5522, 673, 4354, 8989, 4358],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2367, 881, 5247, 4625, 7337, 1834, 3928, 9579, 5499, 1359, 4472],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4566, 8984, 848, 7280, 7193, 8804, 65, 5840, 9495, 5756, 4582],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2284, 588, 6628, 5444, 113, 6563, 5545, 3429, 5982, 4157, 4690],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7070, 9996, 9391, 1626, 8064, 9743, 5415, 2719, 2331, 8315, 4795],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8950, 3931, 8278, 4117, 8149, 9456, 1963, 6356, 8556, 9794, 4898],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7709, 9563, 8198, 227, 4109, 2822, 8300, 2784, 1359, 195, 5099],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4158, 828, 1710, 5176, 9024, 8233, 8805, 6631, 2270, 1524, 5196],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5184, 1420, 2085, 2785, 1507, 323, 1810, 9181, 2212, 5026, 5291],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1202, 6295, 2955, 5403, 491, 5071, 312, 4504, 713, 1648, 5385],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4469, 9527, 2133, 80, 7828, 6969, 1345, 1661, 7505, 2255, 5477],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3934, 476, 4952, 9185, 1298, 1947, 9221, 21, 6283, 7643, 5567],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6875, 4278, 9231, 8387, 4896, 675, 1952, 2380, 4949, 8542, 5656],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2644, 8220, 2931, 2189, 1468, 5061, 6598, 8028, 4653, 5626, 5744],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3983, 6521, 8307, 5455, 2877, 7415, 4708, 5300, 9484, 9518, 5830],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5012, 8415, 1704, 5616, 8291, 6732, 425, 9616, 8309, 797, 5916],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9701, 2084, 6706, 2020, 4245, 9968, 6889, 8219, 3029, 7625, 6082],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6240, 5235, 4422, 4542, 2381, 5019, 4502, 8976, 296, 4140, 6164],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9600, 1072, 9446, 9397, 3120, 4689, 2058, 8398, 9839, 9979, 6244],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1103, 7439, 3706, 8654, 7088, 9778, 6639, 6758, 2033, 5553, 6324],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4201, 4520, 1326, 6218, 7674, 8821, 6864, 2848, 3743, 1242, 6403],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2043, 7705, 9665, 879, 7436, 6596, 2309, 7860, 9840, 7406, 6480],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9663, 7926, 162, 6360, 9997, 4410, 6523, 2000, 2430, 4385, 6557],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1771, 7854, 7336, 3413, 5473, 2986, 6982, 799, 8071, 2495, 6633],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8551, 6321, 2870, 1938, 1006, 2752, 892, 9369, 3249, 2039, 6708],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7483, 5195, 6910, 6259, 6326, 6455, 1390, 5268, 8312, 3299, 6782],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6435, 460, 4896, 848, 1449, 3587, 1249, 1044, 40, 6546, 6855],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2210, 7771, 8946, 234, 5366, 978, 1741, 5509, 3027, 2032, 6928],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3594, 2848, 9039, 484, 3621, 844, 2440, 5475, 1186, 678, 7071],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1712, 8766, 6527, 3672, 9811, 9939, 9979, 2849, 2854, 4284, 7141],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5931, 2502, 9189, 9409, 2534, 3844, 5862, 7978, 5092, 1025, 7211],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6697, 3777, 3279, 5270, 2491, 9730, 2710, 518, 8928, 1098, 7280],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8424, 5897, 7417, 1176, 2224, 9185, 2945, 9534, 2834, 4692, 7348],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9043, 979, 1306, 8007, 7440, 1139, 9487, 5662, 8709, 1984, 7416],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [396, 3512, 9860, 6330, 7464, 6749, 7711, 7882, 7354, 3147, 7483],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1947, 8222, 1705, 9461, 4806, 3668, 6972, 749, 3527, 8344, 7549],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7056, 5360, 2300, 1583, 1027, 6141, 2856, 3908, 586, 7731, 7615],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4511, 3062, 7247, 7313, 7021, 6968, 1757, 8608, 4786, 1457, 7681],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8434, 1665, 9922, 5647, 799, 5853, 7703, 4833, 9241, 9666, 7745],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3051, 3568, 141, 7591, 2735, 2972, 3941, 6654, 7590, 2496, 7810],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [861, 3681, 786, 8120, 4448, 8503, 196, 1811, 7401, 78, 7874],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7775, 7130, 8127, 9177, 7260, 484, 7715, 3771, 3319, 2539, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3963, 1134, 7113, 3037, 3230, 6661, 6523, 8549, 4829, 2577, 8062],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2041, 8504, 4034, 2660, 3568, 5988, 3604, 5960, 463, 384, 8124],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4868, 8880, 2945, 7339, 3724, 5370, 9699, 2449, 7187, 3527, 8185],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [3984, 294, 5405, 9481, 9711, 4281, 996, 5321, 5123, 2112, 8246],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2142, 232, 9201, 9074, 2744, 8426, 8525, 8074, 6291, 6238, 8306],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1537, 3928, 7489, 8518, 257, 8172, 4797, 755, 6534, 6002, 8366],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [24, 1608, 3603, 2027, 9906, 3413, 6306, 6358, 7317, 1497, 8426],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [312, 1418, 8847, 2581, 2345, 1013, 2928, 8570, 7423, 2813, 8485],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4553, 4594, 643, 2397, 8326, 7164, 1678, 7531, 4531, 37, 8544],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5356, 2027, 1363, 497, 3535, 2947, 7717, 2626, 6704, 3252, 8602],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [263, 4714, 6183, 5293, 1707, 3723, 4676, 4386, 3784, 2540, 8660],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [78, 8274, 3131, 7192, 3967, 7396, 1044, 1347, 8708, 7978, 8717],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8768, 875, 956, 4163, 8307, 638, 604, 2122, 8739, 9643, 8774],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6395, 4174, 5396, 9592, 2726, 6404, 8547, 7846, 6632, 7608, 8831],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4506, 7076, 2781, 4087, 1675, 9144, 8500, 5588, 1731, 1944, 8888],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4734, 1762, 494, 9251, 4674, 3669, 7856, 9158, 999, 2719, 8944],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9000],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1245, 3052, 6641, 9840, 8166, 7380, 6265, 7416, 3813, 3851, 9055],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1392, 99, 6919, 6886, 6104, 4562, 8819, 4298, 7914, 4335, 9110],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9132, 7968, 1697, 4560, 4387, 7609, 131, 1680, 8991, 1513, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [8050, 7246, 9315, 7627, 4281, 227, 3100, 2887, 5729, 5444, 9219],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4689, 6263, 7462, 9901, 6073, 1641, 7525, 5703, 9549, 6184, 9273],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2407, 3276, 5698, 3205, 5542, 5447, 455, 8815, 5308, 3790, 9327],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4567, 1176, 3256, 889, 227, 3126, 1091, 6859, 1964, 8315, 9380],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6226, 6983, 4071, 6226, 377, 2066, 8113, 6603, 3205, 9811, 9433],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [6654, 1158, 5560, 2981, 633, 9668, 9959, 5137, 8050, 8329, 9486],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2342, 2546, 6540, 2322, 5860, 2621, 4915, 9456, 1416, 3920, 9539],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [4141, 9993, 8783, 3253, 6128, 9487, 831, 5439, 4662, 6630, 9591],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [9037, 3906, 6318, 4326, 1047, 6003, 9957, 2954, 6099, 6507, 9643],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1510, 3652, 1339, 8453, 1150, 4888, 281, 2658, 1483, 3597, 9695],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [5839, 9252, 29, 8996, 3199, 3841, 9068, 8963, 4480, 7943, 9746],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7899, 7863, 6556, 8235, 6298, 8913, 3927, 2712, 7113, 9589, 9797],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [1363, 1696, 2448, 9176, 1414, 4621, 7217, 6104, 179, 8578, 9848],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [7031, 9987, 8654, 4678, 1069, 1182, 3416, 1665, 3661, 4949, 9899],
    },
    BigFloatInc {
        sign: 1,
        e: -22,
        n: 44,
        m: [2656, 1781, 6005, 120, 8210, 4479, 5473, 6199, 7106, 8743, 9949],
    },
    BigFloatInc {
        sign: 1,
        e: -21,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
];
