use crate::inc::inc::BigFloatInc;

// hyperbolic arcsine polynomial coefficients
pub(crate) const ASINH_VALUES: [BigFloatInc; 50] = [
    BigFloatInc {
        sign: -1,
        e: -44,
        n: 44,
        m: [6667, 6666, 6666, 6666, 6666, 6666, 6666, 6666, 6666, 6666, 1666],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7500],
    },
    BigFloatInc {
        sign: -1,
        e: -45,
        n: 44,
        m: [2857, 5714, 1428, 2857, 5714, 1428, 2857, 5714, 1428, 2857, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4444, 4444, 4444, 4444, 4444, 4444, 4444, 4444, 4444, 1944, 3038],
    },
    BigFloatInc {
        sign: -1,
        e: -45,
        n: 44,
        m: [909, 909, 909, 909, 909, 909, 909, 909, 909, 2159, 2237],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [3077, 7692, 9230, 3076, 7692, 9230, 3076, 7692, 4230, 2764, 1735],
    },
    BigFloatInc {
        sign: -1,
        e: -45,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 7500, 4843, 1396],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [4118, 3529, 5882, 6470, 4117, 3529, 5882, 3970, 8961, 1800, 1155],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [4210, 7368, 7894, 6315, 1052, 6842, 9473, 4078, 2919, 6095, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [4762, 6190, 9047, 4761, 6190, 9047, 4761, 6815, 961, 3358, 8390],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8696, 8260, 4347, 9130, 2173, 9565, 1086, 8845, 7359, 5258, 7312],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 4375, 9648, 1188, 2103, 6447],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [1852, 5185, 8518, 1851, 5185, 3518, 4664, 1923, 7084, 376, 5740],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [9655, 2068, 7586, 4482, 3103, 5129, 1958, 9904, 8231, 3096, 5153],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8710, 5483, 4193, 9677, 3870, 423, 1599, 5096, 8691, 1434, 4660],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [8182, 8181, 8181, 3181, 1619, 3709, 773, 9363, 9367, 9070, 4240],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [7143, 4285, 8571, 9642, 5691, 1940, 2363, 7669, 5883, 9645, 3880],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [270, 7027, 2702, 3395, 7847, 1386, 5454, 5934, 9382, 2053, 3569],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8462, 6153, 384, 6274, 2579, 9243, 7453, 3484, 347, 595, 3297],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [4390, 3902, 7149, 3251, 947, 5481, 6693, 8030, 4925, 8216, 3057],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [9767, 2906, 4600, 4117, 4785, 7676, 1678, 8942, 110, 1784, 2846],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3333, 9583, 8098, 9021, 3478, 3744, 9335, 7289, 3820, 8706, 2657],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [6383, 6635, 1438, 2067, 9965, 4075, 4946, 6883, 7824, 4486, 2489],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [2436, 101, 4017, 8663, 3827, 3088, 1869, 1975, 9211, 918, 2338],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [7592, 9573, 3048, 8851, 419, 2002, 2054, 138, 7371, 4739, 2201],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [9070, 2808, 1219, 193, 3553, 7847, 4427, 8167, 3251, 6610, 2077],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [1346, 606, 7574, 5559, 3774, 3930, 6184, 7283, 1627, 336, 1965],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [8587, 2848, 6222, 6465, 2104, 7910, 4892, 3127, 640, 2264, 1862],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [7955, 4510, 1030, 8757, 2500, 5219, 2386, 5418, 2051, 811, 1768],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [2183, 4208, 8731, 9858, 8659, 444, 8002, 3106, 9358, 6093, 1681],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8137, 3217, 9060, 4688, 9596, 2983, 357, 1444, 7535, 9632, 1601],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [7650, 1002, 2375, 733, 1288, 9705, 6388, 2567, 9612, 4115, 1528],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [6287, 8341, 4505, 9488, 5687, 6857, 3944, 9115, 9407, 3208, 1460],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1755, 1819, 6783, 4966, 8666, 8930, 4112, 253, 1763, 1399, 1397],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8742, 6275, 7113, 906, 1642, 4032, 3684, 5178, 5127, 3869, 1338],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [3565, 8593, 7130, 5789, 7206, 6142, 5683, 9028, 8762, 6393, 1283],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [1796, 1260, 7263, 917, 1997, 4379, 8001, 16, 9850, 5250, 1232],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1904, 3923, 3319, 3809, 31, 7615, 2516, 2439, 5616, 7152, 1184],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [8695, 9699, 4350, 6104, 1508, 4052, 6811, 2223, 3070, 9183, 1139],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [1737, 1487, 8178, 8576, 6841, 9598, 2212, 1447, 4659, 8750, 1097],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [9472, 5150, 2488, 3068, 5890, 93, 9061, 2242, 2587, 3541, 1058],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [6912, 2521, 5947, 3478, 8956, 7581, 6442, 627, 7971, 1486, 1021],
    },
    BigFloatInc {
        sign: -1,
        e: -47,
        n: 44,
        m: [7681, 2281, 5291, 6555, 9654, 848, 9242, 3312, 6983, 7313, 9860],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [4196, 9563, 8763, 8048, 2537, 5501, 351, 9564, 9742, 6061, 9529],
    },
    BigFloatInc {
        sign: -1,
        e: -47,
        n: 44,
        m: [5222, 8703, 6043, 3580, 8658, 4686, 1541, 6334, 2183, 6069, 9216],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [5497, 4869, 5779, 6090, 5717, 7599, 1400, 7097, 3091, 3742, 8920],
    },
    BigFloatInc {
        sign: -1,
        e: -47,
        n: 44,
        m: [9917, 7516, 7299, 9373, 3511, 2892, 6063, 8675, 2465, 6771, 8639],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [4882, 9642, 9940, 4813, 2746, 5551, 6343, 7120, 1602, 3984, 8373],
    },
    BigFloatInc {
        sign: -1,
        e: -47,
        n: 44,
        m: [8494, 6215, 4401, 300, 7076, 5889, 5098, 6701, 2908, 5221, 8120],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [3802, 1577, 2687, 5119, 5370, 7396, 5938, 2055, 1358, 1225, 7880],
    },
];
