/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePrometheusRules implements PrometheusRuleInterface
type FakePrometheusRules struct {
	Fake *FakeMonitoringV1
	ns   string
}

var prometheusrulesResource = v1.SchemeGroupVersion.WithResource("prometheusrules")

var prometheusrulesKind = v1.SchemeGroupVersion.WithKind("PrometheusRule")

// Get takes name of the prometheusRule, and returns the corresponding prometheusRule object, and an error if there is any.
func (c *FakePrometheusRules) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.PrometheusRule, err error) {
	emptyResult := &v1.PrometheusRule{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(prometheusrulesResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.PrometheusRule), err
}

// List takes label and field selectors, and returns the list of PrometheusRules that match those selectors.
func (c *FakePrometheusRules) List(ctx context.Context, opts metav1.ListOptions) (result *v1.PrometheusRuleList, err error) {
	emptyResult := &v1.PrometheusRuleList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(prometheusrulesResource, prometheusrulesKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.PrometheusRuleList{ListMeta: obj.(*v1.PrometheusRuleList).ListMeta}
	for _, item := range obj.(*v1.PrometheusRuleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested prometheusRules.
func (c *FakePrometheusRules) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(prometheusrulesResource, c.ns, opts))

}

// Create takes the representation of a prometheusRule and creates it.  Returns the server's representation of the prometheusRule, and an error, if there is any.
func (c *FakePrometheusRules) Create(ctx context.Context, prometheusRule *v1.PrometheusRule, opts metav1.CreateOptions) (result *v1.PrometheusRule, err error) {
	emptyResult := &v1.PrometheusRule{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(prometheusrulesResource, c.ns, prometheusRule, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.PrometheusRule), err
}

// Update takes the representation of a prometheusRule and updates it. Returns the server's representation of the prometheusRule, and an error, if there is any.
func (c *FakePrometheusRules) Update(ctx context.Context, prometheusRule *v1.PrometheusRule, opts metav1.UpdateOptions) (result *v1.PrometheusRule, err error) {
	emptyResult := &v1.PrometheusRule{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(prometheusrulesResource, c.ns, prometheusRule, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.PrometheusRule), err
}

// Delete takes name of the prometheusRule and deletes it. Returns an error if one occurs.
func (c *FakePrometheusRules) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(prometheusrulesResource, c.ns, name, opts), &v1.PrometheusRule{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePrometheusRules) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(prometheusrulesResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.PrometheusRuleList{})
	return err
}

// Patch applies the patch and returns the patched prometheusRule.
func (c *FakePrometheusRules) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.PrometheusRule, err error) {
	emptyResult := &v1.PrometheusRule{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(prometheusrulesResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.PrometheusRule), err
}
