RabbitMQ `3.11.26` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).
This release series [goes out of community support on Dec 31, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Broker

#### Bug Fixes

 * When a topic permission was deleted, an [internal event](https://rabbitmq.com/logging.html#internal-events) of type `permission.deleted`
   was emitted in some cases, instead of `topic.permission.deleted`.

   Investigated by @bedia.

   GitHub issue: [#9937](https://github.com/rabbitmq/rabbitmq-server/issues/9937)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Correctly block publishing AMQP 1.0 connections when a [resource alarm](https://rabbitmq.com/alarms.html) is in effect.

   GitHub issue: [#9955](https://github.com/rabbitmq/rabbitmq-server/pull/9955)


### Grafana Dashboard

#### Enhancements

 * [Global counters for producers](https://github.com/rabbitmq/rabbitmq-server/pull/3127) are now available in the dashboard.

   Contributed by @johanrhodin (CloudAMQP)

   GitHub issue: [#9846](https://github.com/rabbitmq/rabbitmq-server/pull/9846)


### CLI Tools

#### Enhancements

 * `rabbitmq-diagnostics list_policies_that_match [queue name]` is a new command
   that simplifies troubleshooting of policy conflicts.

   GitHub issue: [#9916](https://github.com/rabbitmq/rabbitmq-server/pull/9916)


## Dependency Upgrades

 None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.26.tar.xz`
instead of the source tarball produced by GitHub.
