/*
 * Floating-point operations.
 *
 * This file implements the non-inline functions declared in
 * fpr.h, as well as the constants for FFT / iFFT.
 *
 * ==========================(LICENSE BEGIN)============================
 *
 * Copyright (c) 2017-2019  Falcon Project
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * ===========================(LICENSE END)=============================
 *
 * @author   Thomas Pornin <thomas.pornin@nccgroup.com>
 */

#include "inner.h"

const fpr fpr_gm_tab[] = {
    {0}, {0}, /* unused */
    {-0.000000000000000000000000000}, { 1.000000000000000000000000000},
    { 0.707106781186547524400844362}, { 0.707106781186547524400844362},
    {-0.707106781186547524400844362}, { 0.707106781186547524400844362},
    { 0.923879532511286756128183189}, { 0.382683432365089771728459984},
    {-0.382683432365089771728459984}, { 0.923879532511286756128183189},
    { 0.382683432365089771728459984}, { 0.923879532511286756128183189},
    {-0.923879532511286756128183189}, { 0.382683432365089771728459984},
    { 0.980785280403230449126182236}, { 0.195090322016128267848284868},
    {-0.195090322016128267848284868}, { 0.980785280403230449126182236},
    { 0.555570233019602224742830814}, { 0.831469612302545237078788378},
    {-0.831469612302545237078788378}, { 0.555570233019602224742830814},
    { 0.831469612302545237078788378}, { 0.555570233019602224742830814},
    {-0.555570233019602224742830814}, { 0.831469612302545237078788378},
    { 0.195090322016128267848284868}, { 0.980785280403230449126182236},
    {-0.980785280403230449126182236}, { 0.195090322016128267848284868},
    { 0.995184726672196886244836953}, { 0.098017140329560601994195564},
    {-0.098017140329560601994195564}, { 0.995184726672196886244836953},
    { 0.634393284163645498215171613}, { 0.773010453362736960810906610},
    {-0.773010453362736960810906610}, { 0.634393284163645498215171613},
    { 0.881921264348355029712756864}, { 0.471396736825997648556387626},
    {-0.471396736825997648556387626}, { 0.881921264348355029712756864},
    { 0.290284677254462367636192376}, { 0.956940335732208864935797887},
    {-0.956940335732208864935797887}, { 0.290284677254462367636192376},
    { 0.956940335732208864935797887}, { 0.290284677254462367636192376},
    {-0.290284677254462367636192376}, { 0.956940335732208864935797887},
    { 0.471396736825997648556387626}, { 0.881921264348355029712756864},
    {-0.881921264348355029712756864}, { 0.471396736825997648556387626},
    { 0.773010453362736960810906610}, { 0.634393284163645498215171613},
    {-0.634393284163645498215171613}, { 0.773010453362736960810906610},
    { 0.098017140329560601994195564}, { 0.995184726672196886244836953},
    {-0.995184726672196886244836953}, { 0.098017140329560601994195564},
    { 0.998795456205172392714771605}, { 0.049067674327418014254954977},
    {-0.049067674327418014254954977}, { 0.998795456205172392714771605},
    { 0.671558954847018400625376850}, { 0.740951125354959091175616897},
    {-0.740951125354959091175616897}, { 0.671558954847018400625376850},
    { 0.903989293123443331586200297}, { 0.427555093430282094320966857},
    {-0.427555093430282094320966857}, { 0.903989293123443331586200297},
    { 0.336889853392220050689253213}, { 0.941544065183020778412509403},
    {-0.941544065183020778412509403}, { 0.336889853392220050689253213},
    { 0.970031253194543992603984207}, { 0.242980179903263889948274162},
    {-0.242980179903263889948274162}, { 0.970031253194543992603984207},
    { 0.514102744193221726593693839}, { 0.857728610000272069902269984},
    {-0.857728610000272069902269984}, { 0.514102744193221726593693839},
    { 0.803207531480644909806676513}, { 0.595699304492433343467036529},
    {-0.595699304492433343467036529}, { 0.803207531480644909806676513},
    { 0.146730474455361751658850130}, { 0.989176509964780973451673738},
    {-0.989176509964780973451673738}, { 0.146730474455361751658850130},
    { 0.989176509964780973451673738}, { 0.146730474455361751658850130},
    {-0.146730474455361751658850130}, { 0.989176509964780973451673738},
    { 0.595699304492433343467036529}, { 0.803207531480644909806676513},
    {-0.803207531480644909806676513}, { 0.595699304492433343467036529},
    { 0.857728610000272069902269984}, { 0.514102744193221726593693839},
    {-0.514102744193221726593693839}, { 0.857728610000272069902269984},
    { 0.242980179903263889948274162}, { 0.970031253194543992603984207},
    {-0.970031253194543992603984207}, { 0.242980179903263889948274162},
    { 0.941544065183020778412509403}, { 0.336889853392220050689253213},
    {-0.336889853392220050689253213}, { 0.941544065183020778412509403},
    { 0.427555093430282094320966857}, { 0.903989293123443331586200297},
    {-0.903989293123443331586200297}, { 0.427555093430282094320966857},
    { 0.740951125354959091175616897}, { 0.671558954847018400625376850},
    {-0.671558954847018400625376850}, { 0.740951125354959091175616897},
    { 0.049067674327418014254954977}, { 0.998795456205172392714771605},
    {-0.998795456205172392714771605}, { 0.049067674327418014254954977},
    { 0.999698818696204220115765650}, { 0.024541228522912288031734529},
    {-0.024541228522912288031734529}, { 0.999698818696204220115765650},
    { 0.689540544737066924616730630}, { 0.724247082951466920941069243},
    {-0.724247082951466920941069243}, { 0.689540544737066924616730630},
    { 0.914209755703530654635014829}, { 0.405241314004989870908481306},
    {-0.405241314004989870908481306}, { 0.914209755703530654635014829},
    { 0.359895036534988148775104572}, { 0.932992798834738887711660256},
    {-0.932992798834738887711660256}, { 0.359895036534988148775104572},
    { 0.975702130038528544460395766}, { 0.219101240156869797227737547},
    {-0.219101240156869797227737547}, { 0.975702130038528544460395766},
    { 0.534997619887097210663076905}, { 0.844853565249707073259571205},
    {-0.844853565249707073259571205}, { 0.534997619887097210663076905},
    { 0.817584813151583696504920884}, { 0.575808191417845300745972454},
    {-0.575808191417845300745972454}, { 0.817584813151583696504920884},
    { 0.170961888760301226363642357}, { 0.985277642388941244774018433},
    {-0.985277642388941244774018433}, { 0.170961888760301226363642357},
    { 0.992479534598709998156767252}, { 0.122410675199216198498704474},
    {-0.122410675199216198498704474}, { 0.992479534598709998156767252},
    { 0.615231590580626845484913563}, { 0.788346427626606262009164705},
    {-0.788346427626606262009164705}, { 0.615231590580626845484913563},
    { 0.870086991108711418652292404}, { 0.492898192229784036873026689},
    {-0.492898192229784036873026689}, { 0.870086991108711418652292404},
    { 0.266712757474898386325286515}, { 0.963776065795439866686464356},
    {-0.963776065795439866686464356}, { 0.266712757474898386325286515},
    { 0.949528180593036667195936074}, { 0.313681740398891476656478846},
    {-0.313681740398891476656478846}, { 0.949528180593036667195936074},
    { 0.449611329654606600046294579}, { 0.893224301195515320342416447},
    {-0.893224301195515320342416447}, { 0.449611329654606600046294579},
    { 0.757208846506484547575464054}, { 0.653172842953776764084203014},
    {-0.653172842953776764084203014}, { 0.757208846506484547575464054},
    { 0.073564563599667423529465622}, { 0.997290456678690216135597140},
    {-0.997290456678690216135597140}, { 0.073564563599667423529465622},
    { 0.997290456678690216135597140}, { 0.073564563599667423529465622},
    {-0.073564563599667423529465622}, { 0.997290456678690216135597140},
    { 0.653172842953776764084203014}, { 0.757208846506484547575464054},
    {-0.757208846506484547575464054}, { 0.653172842953776764084203014},
    { 0.893224301195515320342416447}, { 0.449611329654606600046294579},
    {-0.449611329654606600046294579}, { 0.893224301195515320342416447},
    { 0.313681740398891476656478846}, { 0.949528180593036667195936074},
    {-0.949528180593036667195936074}, { 0.313681740398891476656478846},
    { 0.963776065795439866686464356}, { 0.266712757474898386325286515},
    {-0.266712757474898386325286515}, { 0.963776065795439866686464356},
    { 0.492898192229784036873026689}, { 0.870086991108711418652292404},
    {-0.870086991108711418652292404}, { 0.492898192229784036873026689},
    { 0.788346427626606262009164705}, { 0.615231590580626845484913563},
    {-0.615231590580626845484913563}, { 0.788346427626606262009164705},
    { 0.122410675199216198498704474}, { 0.992479534598709998156767252},
    {-0.992479534598709998156767252}, { 0.122410675199216198498704474},
    { 0.985277642388941244774018433}, { 0.170961888760301226363642357},
    {-0.170961888760301226363642357}, { 0.985277642388941244774018433},
    { 0.575808191417845300745972454}, { 0.817584813151583696504920884},
    {-0.817584813151583696504920884}, { 0.575808191417845300745972454},
    { 0.844853565249707073259571205}, { 0.534997619887097210663076905},
    {-0.534997619887097210663076905}, { 0.844853565249707073259571205},
    { 0.219101240156869797227737547}, { 0.975702130038528544460395766},
    {-0.975702130038528544460395766}, { 0.219101240156869797227737547},
    { 0.932992798834738887711660256}, { 0.359895036534988148775104572},
    {-0.359895036534988148775104572}, { 0.932992798834738887711660256},
    { 0.405241314004989870908481306}, { 0.914209755703530654635014829},
    {-0.914209755703530654635014829}, { 0.405241314004989870908481306},
    { 0.724247082951466920941069243}, { 0.689540544737066924616730630},
    {-0.689540544737066924616730630}, { 0.724247082951466920941069243},
    { 0.024541228522912288031734529}, { 0.999698818696204220115765650},
    {-0.999698818696204220115765650}, { 0.024541228522912288031734529},
    { 0.999924701839144540921646491}, { 0.012271538285719926079408262},
    {-0.012271538285719926079408262}, { 0.999924701839144540921646491},
    { 0.698376249408972853554813503}, { 0.715730825283818654125532623},
    {-0.715730825283818654125532623}, { 0.698376249408972853554813503},
    { 0.919113851690057743908477789}, { 0.393992040061048108596188661},
    {-0.393992040061048108596188661}, { 0.919113851690057743908477789},
    { 0.371317193951837543411934967}, { 0.928506080473215565937167396},
    {-0.928506080473215565937167396}, { 0.371317193951837543411934967},
    { 0.978317370719627633106240097}, { 0.207111376192218549708116020},
    {-0.207111376192218549708116020}, { 0.978317370719627633106240097},
    { 0.545324988422046422313987347}, { 0.838224705554838043186996856},
    {-0.838224705554838043186996856}, { 0.545324988422046422313987347},
    { 0.824589302785025264474803737}, { 0.565731810783613197389765011},
    {-0.565731810783613197389765011}, { 0.824589302785025264474803737},
    { 0.183039887955140958516532578}, { 0.983105487431216327180301155},
    {-0.983105487431216327180301155}, { 0.183039887955140958516532578},
    { 0.993906970002356041546922813}, { 0.110222207293883058807899140},
    {-0.110222207293883058807899140}, { 0.993906970002356041546922813},
    { 0.624859488142386377084072816}, { 0.780737228572094478301588484},
    {-0.780737228572094478301588484}, { 0.624859488142386377084072816},
    { 0.876070094195406607095844268}, { 0.482183772079122748517344481},
    {-0.482183772079122748517344481}, { 0.876070094195406607095844268},
    { 0.278519689385053105207848526}, { 0.960430519415565811199035138},
    {-0.960430519415565811199035138}, { 0.278519689385053105207848526},
    { 0.953306040354193836916740383}, { 0.302005949319228067003463232},
    {-0.302005949319228067003463232}, { 0.953306040354193836916740383},
    { 0.460538710958240023633181487}, { 0.887639620402853947760181617},
    {-0.887639620402853947760181617}, { 0.460538710958240023633181487},
    { 0.765167265622458925888815999}, { 0.643831542889791465068086063},
    {-0.643831542889791465068086063}, { 0.765167265622458925888815999},
    { 0.085797312344439890461556332}, { 0.996312612182778012627226190},
    {-0.996312612182778012627226190}, { 0.085797312344439890461556332},
    { 0.998118112900149207125155861}, { 0.061320736302208577782614593},
    {-0.061320736302208577782614593}, { 0.998118112900149207125155861},
    { 0.662415777590171761113069817}, { 0.749136394523459325469203257},
    {-0.749136394523459325469203257}, { 0.662415777590171761113069817},
    { 0.898674465693953843041976744}, { 0.438616238538527637647025738},
    {-0.438616238538527637647025738}, { 0.898674465693953843041976744},
    { 0.325310292162262934135954708}, { 0.945607325380521325730945387},
    {-0.945607325380521325730945387}, { 0.325310292162262934135954708},
    { 0.966976471044852109087220226}, { 0.254865659604514571553980779},
    {-0.254865659604514571553980779}, { 0.966976471044852109087220226},
    { 0.503538383725717558691867071}, { 0.863972856121586737918147054},
    {-0.863972856121586737918147054}, { 0.503538383725717558691867071},
    { 0.795836904608883536262791915}, { 0.605511041404325513920626941},
    {-0.605511041404325513920626941}, { 0.795836904608883536262791915},
    { 0.134580708507126186316358409}, { 0.990902635427780025108237011},
    {-0.990902635427780025108237011}, { 0.134580708507126186316358409},
    { 0.987301418157858382399815802}, { 0.158858143333861441684385360},
    {-0.158858143333861441684385360}, { 0.987301418157858382399815802},
    { 0.585797857456438860328080838}, { 0.810457198252594791726703434},
    {-0.810457198252594791726703434}, { 0.585797857456438860328080838},
    { 0.851355193105265142261290312}, { 0.524589682678468906215098464},
    {-0.524589682678468906215098464}, { 0.851355193105265142261290312},
    { 0.231058108280671119643236018}, { 0.972939952205560145467720114},
    {-0.972939952205560145467720114}, { 0.231058108280671119643236018},
    { 0.937339011912574923201899593}, { 0.348418680249434568419308588},
    {-0.348418680249434568419308588}, { 0.937339011912574923201899593},
    { 0.416429560097637182562598911}, { 0.909167983090522376563884788},
    {-0.909167983090522376563884788}, { 0.416429560097637182562598911},
    { 0.732654271672412834615546649}, { 0.680600997795453050594430464},
    {-0.680600997795453050594430464}, { 0.732654271672412834615546649},
    { 0.036807222941358832324332691}, { 0.999322384588349500896221011},
    {-0.999322384588349500896221011}, { 0.036807222941358832324332691},
    { 0.999322384588349500896221011}, { 0.036807222941358832324332691},
    {-0.036807222941358832324332691}, { 0.999322384588349500896221011},
    { 0.680600997795453050594430464}, { 0.732654271672412834615546649},
    {-0.732654271672412834615546649}, { 0.680600997795453050594430464},
    { 0.909167983090522376563884788}, { 0.416429560097637182562598911},
    {-0.416429560097637182562598911}, { 0.909167983090522376563884788},
    { 0.348418680249434568419308588}, { 0.937339011912574923201899593},
    {-0.937339011912574923201899593}, { 0.348418680249434568419308588},
    { 0.972939952205560145467720114}, { 0.231058108280671119643236018},
    {-0.231058108280671119643236018}, { 0.972939952205560145467720114},
    { 0.524589682678468906215098464}, { 0.851355193105265142261290312},
    {-0.851355193105265142261290312}, { 0.524589682678468906215098464},
    { 0.810457198252594791726703434}, { 0.585797857456438860328080838},
    {-0.585797857456438860328080838}, { 0.810457198252594791726703434},
    { 0.158858143333861441684385360}, { 0.987301418157858382399815802},
    {-0.987301418157858382399815802}, { 0.158858143333861441684385360},
    { 0.990902635427780025108237011}, { 0.134580708507126186316358409},
    {-0.134580708507126186316358409}, { 0.990902635427780025108237011},
    { 0.605511041404325513920626941}, { 0.795836904608883536262791915},
    {-0.795836904608883536262791915}, { 0.605511041404325513920626941},
    { 0.863972856121586737918147054}, { 0.503538383725717558691867071},
    {-0.503538383725717558691867071}, { 0.863972856121586737918147054},
    { 0.254865659604514571553980779}, { 0.966976471044852109087220226},
    {-0.966976471044852109087220226}, { 0.254865659604514571553980779},
    { 0.945607325380521325730945387}, { 0.325310292162262934135954708},
    {-0.325310292162262934135954708}, { 0.945607325380521325730945387},
    { 0.438616238538527637647025738}, { 0.898674465693953843041976744},
    {-0.898674465693953843041976744}, { 0.438616238538527637647025738},
    { 0.749136394523459325469203257}, { 0.662415777590171761113069817},
    {-0.662415777590171761113069817}, { 0.749136394523459325469203257},
    { 0.061320736302208577782614593}, { 0.998118112900149207125155861},
    {-0.998118112900149207125155861}, { 0.061320736302208577782614593},
    { 0.996312612182778012627226190}, { 0.085797312344439890461556332},
    {-0.085797312344439890461556332}, { 0.996312612182778012627226190},
    { 0.643831542889791465068086063}, { 0.765167265622458925888815999},
    {-0.765167265622458925888815999}, { 0.643831542889791465068086063},
    { 0.887639620402853947760181617}, { 0.460538710958240023633181487},
    {-0.460538710958240023633181487}, { 0.887639620402853947760181617},
    { 0.302005949319228067003463232}, { 0.953306040354193836916740383},
    {-0.953306040354193836916740383}, { 0.302005949319228067003463232},
    { 0.960430519415565811199035138}, { 0.278519689385053105207848526},
    {-0.278519689385053105207848526}, { 0.960430519415565811199035138},
    { 0.482183772079122748517344481}, { 0.876070094195406607095844268},
    {-0.876070094195406607095844268}, { 0.482183772079122748517344481},
    { 0.780737228572094478301588484}, { 0.624859488142386377084072816},
    {-0.624859488142386377084072816}, { 0.780737228572094478301588484},
    { 0.110222207293883058807899140}, { 0.993906970002356041546922813},
    {-0.993906970002356041546922813}, { 0.110222207293883058807899140},
    { 0.983105487431216327180301155}, { 0.183039887955140958516532578},
    {-0.183039887955140958516532578}, { 0.983105487431216327180301155},
    { 0.565731810783613197389765011}, { 0.824589302785025264474803737},
    {-0.824589302785025264474803737}, { 0.565731810783613197389765011},
    { 0.838224705554838043186996856}, { 0.545324988422046422313987347},
    {-0.545324988422046422313987347}, { 0.838224705554838043186996856},
    { 0.207111376192218549708116020}, { 0.978317370719627633106240097},
    {-0.978317370719627633106240097}, { 0.207111376192218549708116020},
    { 0.928506080473215565937167396}, { 0.371317193951837543411934967},
    {-0.371317193951837543411934967}, { 0.928506080473215565937167396},
    { 0.393992040061048108596188661}, { 0.919113851690057743908477789},
    {-0.919113851690057743908477789}, { 0.393992040061048108596188661},
    { 0.715730825283818654125532623}, { 0.698376249408972853554813503},
    {-0.698376249408972853554813503}, { 0.715730825283818654125532623},
    { 0.012271538285719926079408262}, { 0.999924701839144540921646491},
    {-0.999924701839144540921646491}, { 0.012271538285719926079408262},
    { 0.999981175282601142656990438}, { 0.006135884649154475359640235},
    {-0.006135884649154475359640235}, { 0.999981175282601142656990438},
    { 0.702754744457225302452914421}, { 0.711432195745216441522130290},
    {-0.711432195745216441522130290}, { 0.702754744457225302452914421},
    { 0.921514039342041943465396332}, { 0.388345046698826291624993541},
    {-0.388345046698826291624993541}, { 0.921514039342041943465396332},
    { 0.377007410216418256726567823}, { 0.926210242138311341974793388},
    {-0.926210242138311341974793388}, { 0.377007410216418256726567823},
    { 0.979569765685440534439326110}, { 0.201104634842091911558443546},
    {-0.201104634842091911558443546}, { 0.979569765685440534439326110},
    { 0.550457972936604802977289893}, { 0.834862874986380056304401383},
    {-0.834862874986380056304401383}, { 0.550457972936604802977289893},
    { 0.828045045257755752067527592}, { 0.560661576197336023839710223},
    {-0.560661576197336023839710223}, { 0.828045045257755752067527592},
    { 0.189068664149806212754997837}, { 0.981963869109555264072848154},
    {-0.981963869109555264072848154}, { 0.189068664149806212754997837},
    { 0.994564570734255452119106243}, { 0.104121633872054579120943880},
    {-0.104121633872054579120943880}, { 0.994564570734255452119106243},
    { 0.629638238914927025372981341}, { 0.776888465673232450040827983},
    {-0.776888465673232450040827983}, { 0.629638238914927025372981341},
    { 0.879012226428633477831323711}, { 0.476799230063322133342158117},
    {-0.476799230063322133342158117}, { 0.879012226428633477831323711},
    { 0.284407537211271843618310615}, { 0.958703474895871555374645792},
    {-0.958703474895871555374645792}, { 0.284407537211271843618310615},
    { 0.955141168305770721498157712}, { 0.296150888243623824121786128},
    {-0.296150888243623824121786128}, { 0.955141168305770721498157712},
    { 0.465976495767966177902756065}, { 0.884797098430937780104007041},
    {-0.884797098430937780104007041}, { 0.465976495767966177902756065},
    { 0.769103337645579639346626069}, { 0.639124444863775743801488193},
    {-0.639124444863775743801488193}, { 0.769103337645579639346626069},
    { 0.091908956497132728624990979}, { 0.995767414467659793982495643},
    {-0.995767414467659793982495643}, { 0.091908956497132728624990979},
    { 0.998475580573294752208559038}, { 0.055195244349689939809447526},
    {-0.055195244349689939809447526}, { 0.998475580573294752208559038},
    { 0.666999922303637506650154222}, { 0.745057785441465962407907310},
    {-0.745057785441465962407907310}, { 0.666999922303637506650154222},
    { 0.901348847046022014570746093}, { 0.433093818853151968484222638},
    {-0.433093818853151968484222638}, { 0.901348847046022014570746093},
    { 0.331106305759876401737190737}, { 0.943593458161960361495301445},
    {-0.943593458161960361495301445}, { 0.331106305759876401737190737},
    { 0.968522094274417316221088329}, { 0.248927605745720168110682816},
    {-0.248927605745720168110682816}, { 0.968522094274417316221088329},
    { 0.508830142543107036931749324}, { 0.860866938637767279344583877},
    {-0.860866938637767279344583877}, { 0.508830142543107036931749324},
    { 0.799537269107905033500246232}, { 0.600616479383868926653875896},
    {-0.600616479383868926653875896}, { 0.799537269107905033500246232},
    { 0.140658239332849230714788846}, { 0.990058210262297105505906464},
    {-0.990058210262297105505906464}, { 0.140658239332849230714788846},
    { 0.988257567730749491404792538}, { 0.152797185258443427720336613},
    {-0.152797185258443427720336613}, { 0.988257567730749491404792538},
    { 0.590759701858874228423887908}, { 0.806847553543799272206514313},
    {-0.806847553543799272206514313}, { 0.590759701858874228423887908},
    { 0.854557988365400520767862276}, { 0.519355990165589587361829932},
    {-0.519355990165589587361829932}, { 0.854557988365400520767862276},
    { 0.237023605994367206867735915}, { 0.971503890986251775537099622},
    {-0.971503890986251775537099622}, { 0.237023605994367206867735915},
    { 0.939459223602189911962669246}, { 0.342660717311994397592781983},
    {-0.342660717311994397592781983}, { 0.939459223602189911962669246},
    { 0.422000270799799685941287941}, { 0.906595704514915365332960588},
    {-0.906595704514915365332960588}, { 0.422000270799799685941287941},
    { 0.736816568877369875090132520}, { 0.676092703575315960360419228},
    {-0.676092703575315960360419228}, { 0.736816568877369875090132520},
    { 0.042938256934940823077124540}, { 0.999077727752645382888781997},
    {-0.999077727752645382888781997}, { 0.042938256934940823077124540},
    { 0.999529417501093163079703322}, { 0.030674803176636625934021028},
    {-0.030674803176636625934021028}, { 0.999529417501093163079703322},
    { 0.685083667772700381362052545}, { 0.728464390448225196492035438},
    {-0.728464390448225196492035438}, { 0.685083667772700381362052545},
    { 0.911706032005429851404397325}, { 0.410843171057903942183466675},
    {-0.410843171057903942183466675}, { 0.911706032005429851404397325},
    { 0.354163525420490382357395796}, { 0.935183509938947577642207480},
    {-0.935183509938947577642207480}, { 0.354163525420490382357395796},
    { 0.974339382785575860518721668}, { 0.225083911359792835991642120},
    {-0.225083911359792835991642120}, { 0.974339382785575860518721668},
    { 0.529803624686294668216054671}, { 0.848120344803297251279133563},
    {-0.848120344803297251279133563}, { 0.529803624686294668216054671},
    { 0.814036329705948361654516690}, { 0.580813958095764545075595272},
    {-0.580813958095764545075595272}, { 0.814036329705948361654516690},
    { 0.164913120489969921418189113}, { 0.986308097244598647863297524},
    {-0.986308097244598647863297524}, { 0.164913120489969921418189113},
    { 0.991709753669099522860049931}, { 0.128498110793793172624415589},
    {-0.128498110793793172624415589}, { 0.991709753669099522860049931},
    { 0.610382806276309452716352152}, { 0.792106577300212351782342879},
    {-0.792106577300212351782342879}, { 0.610382806276309452716352152},
    { 0.867046245515692651480195629}, { 0.498227666972781852410983869},
    {-0.498227666972781852410983869}, { 0.867046245515692651480195629},
    { 0.260794117915275518280186509}, { 0.965394441697689374550843858},
    {-0.965394441697689374550843858}, { 0.260794117915275518280186509},
    { 0.947585591017741134653387321}, { 0.319502030816015677901518272},
    {-0.319502030816015677901518272}, { 0.947585591017741134653387321},
    { 0.444122144570429231642069418}, { 0.895966249756185155914560282},
    {-0.895966249756185155914560282}, { 0.444122144570429231642069418},
    { 0.753186799043612482483430486}, { 0.657806693297078656931182264},
    {-0.657806693297078656931182264}, { 0.753186799043612482483430486},
    { 0.067443919563664057897972422}, { 0.997723066644191609848546728},
    {-0.997723066644191609848546728}, { 0.067443919563664057897972422},
    { 0.996820299291165714972629398}, { 0.079682437971430121147120656},
    {-0.079682437971430121147120656}, { 0.996820299291165714972629398},
    { 0.648514401022112445084560551}, { 0.761202385484261814029709836},
    {-0.761202385484261814029709836}, { 0.648514401022112445084560551},
    { 0.890448723244757889952150560}, { 0.455083587126343823535869268},
    {-0.455083587126343823535869268}, { 0.890448723244757889952150560},
    { 0.307849640041534893682063646}, { 0.951435020969008369549175569},
    {-0.951435020969008369549175569}, { 0.307849640041534893682063646},
    { 0.962121404269041595429604316}, { 0.272621355449948984493347477},
    {-0.272621355449948984493347477}, { 0.962121404269041595429604316},
    { 0.487550160148435954641485027}, { 0.873094978418290098636085973},
    {-0.873094978418290098636085973}, { 0.487550160148435954641485027},
    { 0.784556597155575233023892575}, { 0.620057211763289178646268191},
    {-0.620057211763289178646268191}, { 0.784556597155575233023892575},
    { 0.116318630911904767252544319}, { 0.993211949234794533104601012},
    {-0.993211949234794533104601012}, { 0.116318630911904767252544319},
    { 0.984210092386929073193874387}, { 0.177004220412148756196839844},
    {-0.177004220412148756196839844}, { 0.984210092386929073193874387},
    { 0.570780745886967280232652864}, { 0.821102514991104679060430820},
    {-0.821102514991104679060430820}, { 0.570780745886967280232652864},
    { 0.841554977436898409603499520}, { 0.540171472729892881297845480},
    {-0.540171472729892881297845480}, { 0.841554977436898409603499520},
    { 0.213110319916091373967757518}, { 0.977028142657754351485866211},
    {-0.977028142657754351485866211}, { 0.213110319916091373967757518},
    { 0.930766961078983731944872340}, { 0.365612997804773870011745909},
    {-0.365612997804773870011745909}, { 0.930766961078983731944872340},
    { 0.399624199845646828544117031}, { 0.916679059921042663116457013},
    {-0.916679059921042663116457013}, { 0.399624199845646828544117031},
    { 0.720002507961381629076682999}, { 0.693971460889654009003734389},
    {-0.693971460889654009003734389}, { 0.720002507961381629076682999},
    { 0.018406729905804820927366313}, { 0.999830581795823422015722275},
    {-0.999830581795823422015722275}, { 0.018406729905804820927366313},
    { 0.999830581795823422015722275}, { 0.018406729905804820927366313},
    {-0.018406729905804820927366313}, { 0.999830581795823422015722275},
    { 0.693971460889654009003734389}, { 0.720002507961381629076682999},
    {-0.720002507961381629076682999}, { 0.693971460889654009003734389},
    { 0.916679059921042663116457013}, { 0.399624199845646828544117031},
    {-0.399624199845646828544117031}, { 0.916679059921042663116457013},
    { 0.365612997804773870011745909}, { 0.930766961078983731944872340},
    {-0.930766961078983731944872340}, { 0.365612997804773870011745909},
    { 0.977028142657754351485866211}, { 0.213110319916091373967757518},
    {-0.213110319916091373967757518}, { 0.977028142657754351485866211},
    { 0.540171472729892881297845480}, { 0.841554977436898409603499520},
    {-0.841554977436898409603499520}, { 0.540171472729892881297845480},
    { 0.821102514991104679060430820}, { 0.570780745886967280232652864},
    {-0.570780745886967280232652864}, { 0.821102514991104679060430820},
    { 0.177004220412148756196839844}, { 0.984210092386929073193874387},
    {-0.984210092386929073193874387}, { 0.177004220412148756196839844},
    { 0.993211949234794533104601012}, { 0.116318630911904767252544319},
    {-0.116318630911904767252544319}, { 0.993211949234794533104601012},
    { 0.620057211763289178646268191}, { 0.784556597155575233023892575},
    {-0.784556597155575233023892575}, { 0.620057211763289178646268191},
    { 0.873094978418290098636085973}, { 0.487550160148435954641485027},
    {-0.487550160148435954641485027}, { 0.873094978418290098636085973},
    { 0.272621355449948984493347477}, { 0.962121404269041595429604316},
    {-0.962121404269041595429604316}, { 0.272621355449948984493347477},
    { 0.951435020969008369549175569}, { 0.307849640041534893682063646},
    {-0.307849640041534893682063646}, { 0.951435020969008369549175569},
    { 0.455083587126343823535869268}, { 0.890448723244757889952150560},
    {-0.890448723244757889952150560}, { 0.455083587126343823535869268},
    { 0.761202385484261814029709836}, { 0.648514401022112445084560551},
    {-0.648514401022112445084560551}, { 0.761202385484261814029709836},
    { 0.079682437971430121147120656}, { 0.996820299291165714972629398},
    {-0.996820299291165714972629398}, { 0.079682437971430121147120656},
    { 0.997723066644191609848546728}, { 0.067443919563664057897972422},
    {-0.067443919563664057897972422}, { 0.997723066644191609848546728},
    { 0.657806693297078656931182264}, { 0.753186799043612482483430486},
    {-0.753186799043612482483430486}, { 0.657806693297078656931182264},
    { 0.895966249756185155914560282}, { 0.444122144570429231642069418},
    {-0.444122144570429231642069418}, { 0.895966249756185155914560282},
    { 0.319502030816015677901518272}, { 0.947585591017741134653387321},
    {-0.947585591017741134653387321}, { 0.319502030816015677901518272},
    { 0.965394441697689374550843858}, { 0.260794117915275518280186509},
    {-0.260794117915275518280186509}, { 0.965394441697689374550843858},
    { 0.498227666972781852410983869}, { 0.867046245515692651480195629},
    {-0.867046245515692651480195629}, { 0.498227666972781852410983869},
    { 0.792106577300212351782342879}, { 0.610382806276309452716352152},
    {-0.610382806276309452716352152}, { 0.792106577300212351782342879},
    { 0.128498110793793172624415589}, { 0.991709753669099522860049931},
    {-0.991709753669099522860049931}, { 0.128498110793793172624415589},
    { 0.986308097244598647863297524}, { 0.164913120489969921418189113},
    {-0.164913120489969921418189113}, { 0.986308097244598647863297524},
    { 0.580813958095764545075595272}, { 0.814036329705948361654516690},
    {-0.814036329705948361654516690}, { 0.580813958095764545075595272},
    { 0.848120344803297251279133563}, { 0.529803624686294668216054671},
    {-0.529803624686294668216054671}, { 0.848120344803297251279133563},
    { 0.225083911359792835991642120}, { 0.974339382785575860518721668},
    {-0.974339382785575860518721668}, { 0.225083911359792835991642120},
    { 0.935183509938947577642207480}, { 0.354163525420490382357395796},
    {-0.354163525420490382357395796}, { 0.935183509938947577642207480},
    { 0.410843171057903942183466675}, { 0.911706032005429851404397325},
    {-0.911706032005429851404397325}, { 0.410843171057903942183466675},
    { 0.728464390448225196492035438}, { 0.685083667772700381362052545},
    {-0.685083667772700381362052545}, { 0.728464390448225196492035438},
    { 0.030674803176636625934021028}, { 0.999529417501093163079703322},
    {-0.999529417501093163079703322}, { 0.030674803176636625934021028},
    { 0.999077727752645382888781997}, { 0.042938256934940823077124540},
    {-0.042938256934940823077124540}, { 0.999077727752645382888781997},
    { 0.676092703575315960360419228}, { 0.736816568877369875090132520},
    {-0.736816568877369875090132520}, { 0.676092703575315960360419228},
    { 0.906595704514915365332960588}, { 0.422000270799799685941287941},
    {-0.422000270799799685941287941}, { 0.906595704514915365332960588},
    { 0.342660717311994397592781983}, { 0.939459223602189911962669246},
    {-0.939459223602189911962669246}, { 0.342660717311994397592781983},
    { 0.971503890986251775537099622}, { 0.237023605994367206867735915},
    {-0.237023605994367206867735915}, { 0.971503890986251775537099622},
    { 0.519355990165589587361829932}, { 0.854557988365400520767862276},
    {-0.854557988365400520767862276}, { 0.519355990165589587361829932},
    { 0.806847553543799272206514313}, { 0.590759701858874228423887908},
    {-0.590759701858874228423887908}, { 0.806847553543799272206514313},
    { 0.152797185258443427720336613}, { 0.988257567730749491404792538},
    {-0.988257567730749491404792538}, { 0.152797185258443427720336613},
    { 0.990058210262297105505906464}, { 0.140658239332849230714788846},
    {-0.140658239332849230714788846}, { 0.990058210262297105505906464},
    { 0.600616479383868926653875896}, { 0.799537269107905033500246232},
    {-0.799537269107905033500246232}, { 0.600616479383868926653875896},
    { 0.860866938637767279344583877}, { 0.508830142543107036931749324},
    {-0.508830142543107036931749324}, { 0.860866938637767279344583877},
    { 0.248927605745720168110682816}, { 0.968522094274417316221088329},
    {-0.968522094274417316221088329}, { 0.248927605745720168110682816},
    { 0.943593458161960361495301445}, { 0.331106305759876401737190737},
    {-0.331106305759876401737190737}, { 0.943593458161960361495301445},
    { 0.433093818853151968484222638}, { 0.901348847046022014570746093},
    {-0.901348847046022014570746093}, { 0.433093818853151968484222638},
    { 0.745057785441465962407907310}, { 0.666999922303637506650154222},
    {-0.666999922303637506650154222}, { 0.745057785441465962407907310},
    { 0.055195244349689939809447526}, { 0.998475580573294752208559038},
    {-0.998475580573294752208559038}, { 0.055195244349689939809447526},
    { 0.995767414467659793982495643}, { 0.091908956497132728624990979},
    {-0.091908956497132728624990979}, { 0.995767414467659793982495643},
    { 0.639124444863775743801488193}, { 0.769103337645579639346626069},
    {-0.769103337645579639346626069}, { 0.639124444863775743801488193},
    { 0.884797098430937780104007041}, { 0.465976495767966177902756065},
    {-0.465976495767966177902756065}, { 0.884797098430937780104007041},
    { 0.296150888243623824121786128}, { 0.955141168305770721498157712},
    {-0.955141168305770721498157712}, { 0.296150888243623824121786128},
    { 0.958703474895871555374645792}, { 0.284407537211271843618310615},
    {-0.284407537211271843618310615}, { 0.958703474895871555374645792},
    { 0.476799230063322133342158117}, { 0.879012226428633477831323711},
    {-0.879012226428633477831323711}, { 0.476799230063322133342158117},
    { 0.776888465673232450040827983}, { 0.629638238914927025372981341},
    {-0.629638238914927025372981341}, { 0.776888465673232450040827983},
    { 0.104121633872054579120943880}, { 0.994564570734255452119106243},
    {-0.994564570734255452119106243}, { 0.104121633872054579120943880},
    { 0.981963869109555264072848154}, { 0.189068664149806212754997837},
    {-0.189068664149806212754997837}, { 0.981963869109555264072848154},
    { 0.560661576197336023839710223}, { 0.828045045257755752067527592},
    {-0.828045045257755752067527592}, { 0.560661576197336023839710223},
    { 0.834862874986380056304401383}, { 0.550457972936604802977289893},
    {-0.550457972936604802977289893}, { 0.834862874986380056304401383},
    { 0.201104634842091911558443546}, { 0.979569765685440534439326110},
    {-0.979569765685440534439326110}, { 0.201104634842091911558443546},
    { 0.926210242138311341974793388}, { 0.377007410216418256726567823},
    {-0.377007410216418256726567823}, { 0.926210242138311341974793388},
    { 0.388345046698826291624993541}, { 0.921514039342041943465396332},
    {-0.921514039342041943465396332}, { 0.388345046698826291624993541},
    { 0.711432195745216441522130290}, { 0.702754744457225302452914421},
    {-0.702754744457225302452914421}, { 0.711432195745216441522130290},
    { 0.006135884649154475359640235}, { 0.999981175282601142656990438},
    {-0.999981175282601142656990438}, { 0.006135884649154475359640235},
    { 0.999995293809576171511580126}, { 0.003067956762965976270145365},
    {-0.003067956762965976270145365}, { 0.999995293809576171511580126},
    { 0.704934080375904908852523758}, { 0.709272826438865651316533772},
    {-0.709272826438865651316533772}, { 0.704934080375904908852523758},
    { 0.922701128333878570437264227}, { 0.385516053843918864075607949},
    {-0.385516053843918864075607949}, { 0.922701128333878570437264227},
    { 0.379847208924051170576281147}, { 0.925049240782677590302371869},
    {-0.925049240782677590302371869}, { 0.379847208924051170576281147},
    { 0.980182135968117392690210009}, { 0.198098410717953586179324918},
    {-0.198098410717953586179324918}, { 0.980182135968117392690210009},
    { 0.553016705580027531764226988}, { 0.833170164701913186439915922},
    {-0.833170164701913186439915922}, { 0.553016705580027531764226988},
    { 0.829761233794523042469023765}, { 0.558118531220556115693702964},
    {-0.558118531220556115693702964}, { 0.829761233794523042469023765},
    { 0.192080397049892441679288205}, { 0.981379193313754574318224190},
    {-0.981379193313754574318224190}, { 0.192080397049892441679288205},
    { 0.994879330794805620591166107}, { 0.101069862754827824987887585},
    {-0.101069862754827824987887585}, { 0.994879330794805620591166107},
    { 0.632018735939809021909403706}, { 0.774953106594873878359129282},
    {-0.774953106594873878359129282}, { 0.632018735939809021909403706},
    { 0.880470889052160770806542929}, { 0.474100214650550014398580015},
    {-0.474100214650550014398580015}, { 0.880470889052160770806542929},
    { 0.287347459544729526477331841}, { 0.957826413027532890321037029},
    {-0.957826413027532890321037029}, { 0.287347459544729526477331841},
    { 0.956045251349996443270479823}, { 0.293219162694258650606608599},
    {-0.293219162694258650606608599}, { 0.956045251349996443270479823},
    { 0.468688822035827933697617870}, { 0.883363338665731594736308015},
    {-0.883363338665731594736308015}, { 0.468688822035827933697617870},
    { 0.771060524261813773200605759}, { 0.636761861236284230413943435},
    {-0.636761861236284230413943435}, { 0.771060524261813773200605759},
    { 0.094963495329638998938034312}, { 0.995480755491926941769171600},
    {-0.995480755491926941769171600}, { 0.094963495329638998938034312},
    { 0.998640218180265222418199049}, { 0.052131704680283321236358216},
    {-0.052131704680283321236358216}, { 0.998640218180265222418199049},
    { 0.669282588346636065720696366}, { 0.743007952135121693517362293},
    {-0.743007952135121693517362293}, { 0.669282588346636065720696366},
    { 0.902673318237258806751502391}, { 0.430326481340082633908199031},
    {-0.430326481340082633908199031}, { 0.902673318237258806751502391},
    { 0.333999651442009404650865481}, { 0.942573197601446879280758735},
    {-0.942573197601446879280758735}, { 0.333999651442009404650865481},
    { 0.969281235356548486048290738}, { 0.245955050335794611599924709},
    {-0.245955050335794611599924709}, { 0.969281235356548486048290738},
    { 0.511468850437970399504391001}, { 0.859301818357008404783582139},
    {-0.859301818357008404783582139}, { 0.511468850437970399504391001},
    { 0.801376171723140219430247777}, { 0.598160706996342311724958652},
    {-0.598160706996342311724958652}, { 0.801376171723140219430247777},
    { 0.143695033150294454819773349}, { 0.989622017463200834623694454},
    {-0.989622017463200834623694454}, { 0.143695033150294454819773349},
    { 0.988721691960323767604516485}, { 0.149764534677321517229695737},
    {-0.149764534677321517229695737}, { 0.988721691960323767604516485},
    { 0.593232295039799808047809426}, { 0.805031331142963597922659282},
    {-0.805031331142963597922659282}, { 0.593232295039799808047809426},
    { 0.856147328375194481019630732}, { 0.516731799017649881508753876},
    {-0.516731799017649881508753876}, { 0.856147328375194481019630732},
    { 0.240003022448741486568922365}, { 0.970772140728950302138169611},
    {-0.970772140728950302138169611}, { 0.240003022448741486568922365},
    { 0.940506070593268323787291309}, { 0.339776884406826857828825803},
    {-0.339776884406826857828825803}, { 0.940506070593268323787291309},
    { 0.424779681209108833357226189}, { 0.905296759318118774354048329},
    {-0.905296759318118774354048329}, { 0.424779681209108833357226189},
    { 0.738887324460615147933116508}, { 0.673829000378756060917568372},
    {-0.673829000378756060917568372}, { 0.738887324460615147933116508},
    { 0.046003182130914628814301788}, { 0.998941293186856850633930266},
    {-0.998941293186856850633930266}, { 0.046003182130914628814301788},
    { 0.999618822495178597116830637}, { 0.027608145778965741612354872},
    {-0.027608145778965741612354872}, { 0.999618822495178597116830637},
    { 0.687315340891759108199186948}, { 0.726359155084345976817494315},
    {-0.726359155084345976817494315}, { 0.687315340891759108199186948},
    { 0.912962190428398164628018233}, { 0.408044162864978680820747499},
    {-0.408044162864978680820747499}, { 0.912962190428398164628018233},
    { 0.357030961233430032614954036}, { 0.934092550404258914729877883},
    {-0.934092550404258914729877883}, { 0.357030961233430032614954036},
    { 0.975025345066994146844913468}, { 0.222093620973203534094094721},
    {-0.222093620973203534094094721}, { 0.975025345066994146844913468},
    { 0.532403127877197971442805218}, { 0.846490938774052078300544488},
    {-0.846490938774052078300544488}, { 0.532403127877197971442805218},
    { 0.815814410806733789010772660}, { 0.578313796411655563342245019},
    {-0.578313796411655563342245019}, { 0.815814410806733789010772660},
    { 0.167938294974731178054745536}, { 0.985797509167567424700995000},
    {-0.985797509167567424700995000}, { 0.167938294974731178054745536},
    { 0.992099313142191757112085445}, { 0.125454983411546238542336453},
    {-0.125454983411546238542336453}, { 0.992099313142191757112085445},
    { 0.612810082429409703935211936}, { 0.790230221437310055030217152},
    {-0.790230221437310055030217152}, { 0.612810082429409703935211936},
    { 0.868570705971340895340449876}, { 0.495565261825772531150266670},
    {-0.495565261825772531150266670}, { 0.868570705971340895340449876},
    { 0.263754678974831383611349322}, { 0.964589793289812723836432159},
    {-0.964589793289812723836432159}, { 0.263754678974831383611349322},
    { 0.948561349915730288158494826}, { 0.316593375556165867243047035},
    {-0.316593375556165867243047035}, { 0.948561349915730288158494826},
    { 0.446868840162374195353044389}, { 0.894599485631382678433072126},
    {-0.894599485631382678433072126}, { 0.446868840162374195353044389},
    { 0.755201376896536527598710756}, { 0.655492852999615385312679701},
    {-0.655492852999615385312679701}, { 0.755201376896536527598710756},
    { 0.070504573389613863027351471}, { 0.997511456140303459699448390},
    {-0.997511456140303459699448390}, { 0.070504573389613863027351471},
    { 0.997060070339482978987989949}, { 0.076623861392031492278332463},
    {-0.076623861392031492278332463}, { 0.997060070339482978987989949},
    { 0.650846684996380915068975573}, { 0.759209188978388033485525443},
    {-0.759209188978388033485525443}, { 0.650846684996380915068975573},
    { 0.891840709392342727796478697}, { 0.452349587233770874133026703},
    {-0.452349587233770874133026703}, { 0.891840709392342727796478697},
    { 0.310767152749611495835997250}, { 0.950486073949481721759926101},
    {-0.950486073949481721759926101}, { 0.310767152749611495835997250},
    { 0.962953266873683886347921481}, { 0.269668325572915106525464462},
    {-0.269668325572915106525464462}, { 0.962953266873683886347921481},
    { 0.490226483288291154229598449}, { 0.871595086655951034842481435},
    {-0.871595086655951034842481435}, { 0.490226483288291154229598449},
    { 0.786455213599085757522319464}, { 0.617647307937803932403979402},
    {-0.617647307937803932403979402}, { 0.786455213599085757522319464},
    { 0.119365214810991364593637790}, { 0.992850414459865090793563344},
    {-0.992850414459865090793563344}, { 0.119365214810991364593637790},
    { 0.984748501801904218556553176}, { 0.173983873387463827950700807},
    {-0.173983873387463827950700807}, { 0.984748501801904218556553176},
    { 0.573297166698042212820171239}, { 0.819347520076796960824689637},
    {-0.819347520076796960824689637}, { 0.573297166698042212820171239},
    { 0.843208239641845437161743865}, { 0.537587076295645482502214932},
    {-0.537587076295645482502214932}, { 0.843208239641845437161743865},
    { 0.216106797076219509948385131}, { 0.976369731330021149312732194},
    {-0.976369731330021149312732194}, { 0.216106797076219509948385131},
    { 0.931884265581668106718557199}, { 0.362755724367397216204854462},
    {-0.362755724367397216204854462}, { 0.931884265581668106718557199},
    { 0.402434650859418441082533934}, { 0.915448716088267819566431292},
    {-0.915448716088267819566431292}, { 0.402434650859418441082533934},
    { 0.722128193929215321243607198}, { 0.691759258364157774906734132},
    {-0.691759258364157774906734132}, { 0.722128193929215321243607198},
    { 0.021474080275469507418374898}, { 0.999769405351215321657617036},
    {-0.999769405351215321657617036}, { 0.021474080275469507418374898},
    { 0.999882347454212525633049627}, { 0.015339206284988101044151868},
    {-0.015339206284988101044151868}, { 0.999882347454212525633049627},
    { 0.696177131491462944788582591}, { 0.717870045055731736211325329},
    {-0.717870045055731736211325329}, { 0.696177131491462944788582591},
    { 0.917900775621390457642276297}, { 0.396809987416710328595290911},
    {-0.396809987416710328595290911}, { 0.917900775621390457642276297},
    { 0.368466829953372331712746222}, { 0.929640895843181265457918066},
    {-0.929640895843181265457918066}, { 0.368466829953372331712746222},
    { 0.977677357824509979943404762}, { 0.210111836880469621717489972},
    {-0.210111836880469621717489972}, { 0.977677357824509979943404762},
    { 0.542750784864515906586768661}, { 0.839893794195999504583383987},
    {-0.839893794195999504583383987}, { 0.542750784864515906586768661},
    { 0.822849781375826332046780034}, { 0.568258952670131549790548489},
    {-0.568258952670131549790548489}, { 0.822849781375826332046780034},
    { 0.180022901405699522679906590}, { 0.983662419211730274396237776},
    {-0.983662419211730274396237776}, { 0.180022901405699522679906590},
    { 0.993564135520595333782021697}, { 0.113270952177564349018228733},
    {-0.113270952177564349018228733}, { 0.993564135520595333782021697},
    { 0.622461279374149972519166721}, { 0.782650596166575738458949301},
    {-0.782650596166575738458949301}, { 0.622461279374149972519166721},
    { 0.874586652278176112634431897}, { 0.484869248000791101822951699},
    {-0.484869248000791101822951699}, { 0.874586652278176112634431897},
    { 0.275571819310958163076425168}, { 0.961280485811320641748659653},
    {-0.961280485811320641748659653}, { 0.275571819310958163076425168},
    { 0.952375012719765858529893608}, { 0.304929229735402406490728633},
    {-0.304929229735402406490728633}, { 0.952375012719765858529893608},
    { 0.457813303598877221904961155}, { 0.889048355854664562540777729},
    {-0.889048355854664562540777729}, { 0.457813303598877221904961155},
    { 0.763188417263381271704838297}, { 0.646176012983316364832802220},
    {-0.646176012983316364832802220}, { 0.763188417263381271704838297},
    { 0.082740264549375693111987083}, { 0.996571145790554847093566910},
    {-0.996571145790554847093566910}, { 0.082740264549375693111987083},
    { 0.997925286198596012623025462}, { 0.064382630929857460819324537},
    {-0.064382630929857460819324537}, { 0.997925286198596012623025462},
    { 0.660114342067420478559490747}, { 0.751165131909686411205819422},
    {-0.751165131909686411205819422}, { 0.660114342067420478559490747},
    { 0.897324580705418281231391836}, { 0.441371268731716692879988968},
    {-0.441371268731716692879988968}, { 0.897324580705418281231391836},
    { 0.322407678801069848384807478}, { 0.946600913083283570044599823},
    {-0.946600913083283570044599823}, { 0.322407678801069848384807478},
    { 0.966190003445412555433832961}, { 0.257831102162159005614471295},
    {-0.257831102162159005614471295}, { 0.966190003445412555433832961},
    { 0.500885382611240786241285004}, { 0.865513624090569082825488358},
    {-0.865513624090569082825488358}, { 0.500885382611240786241285004},
    { 0.793975477554337164895083757}, { 0.607949784967773667243642671},
    {-0.607949784967773667243642671}, { 0.793975477554337164895083757},
    { 0.131540028702883111103387493}, { 0.991310859846115418957349799},
    {-0.991310859846115418957349799}, { 0.131540028702883111103387493},
    { 0.986809401814185476970235952}, { 0.161886393780111837641387995},
    {-0.161886393780111837641387995}, { 0.986809401814185476970235952},
    { 0.583308652937698294392830961}, { 0.812250586585203913049744181},
    {-0.812250586585203913049744181}, { 0.583308652937698294392830961},
    { 0.849741768000852489471268395}, { 0.527199134781901348464274575},
    {-0.527199134781901348464274575}, { 0.849741768000852489471268395},
    { 0.228072083170885739254457379}, { 0.973644249650811925318383912},
    {-0.973644249650811925318383912}, { 0.228072083170885739254457379},
    { 0.936265667170278246576310996}, { 0.351292756085567125601307623},
    {-0.351292756085567125601307623}, { 0.936265667170278246576310996},
    { 0.413638312238434547471944324}, { 0.910441292258067196934095369},
    {-0.910441292258067196934095369}, { 0.413638312238434547471944324},
    { 0.730562769227827561177758850}, { 0.682845546385248068164596123},
    {-0.682845546385248068164596123}, { 0.730562769227827561177758850},
    { 0.033741171851377584833716112}, { 0.999430604555461772019008327},
    {-0.999430604555461772019008327}, { 0.033741171851377584833716112},
    { 0.999204758618363895492950001}, { 0.039872927587739811128578738},
    {-0.039872927587739811128578738}, { 0.999204758618363895492950001},
    { 0.678350043129861486873655042}, { 0.734738878095963464563223604},
    {-0.734738878095963464563223604}, { 0.678350043129861486873655042},
    { 0.907886116487666212038681480}, { 0.419216888363223956433010020},
    {-0.419216888363223956433010020}, { 0.907886116487666212038681480},
    { 0.345541324963989065539191723}, { 0.938403534063108112192420774},
    {-0.938403534063108112192420774}, { 0.345541324963989065539191723},
    { 0.972226497078936305708321144}, { 0.234041958583543423191242045},
    {-0.234041958583543423191242045}, { 0.972226497078936305708321144},
    { 0.521975292937154342694258318}, { 0.852960604930363657746588082},
    {-0.852960604930363657746588082}, { 0.521975292937154342694258318},
    { 0.808656181588174991946968128}, { 0.588281548222645304786439813},
    {-0.588281548222645304786439813}, { 0.808656181588174991946968128},
    { 0.155828397654265235743101486}, { 0.987784141644572154230969032},
    {-0.987784141644572154230969032}, { 0.155828397654265235743101486},
    { 0.990485084256457037998682243}, { 0.137620121586486044948441663},
    {-0.137620121586486044948441663}, { 0.990485084256457037998682243},
    { 0.603066598540348201693430617}, { 0.797690840943391108362662755},
    {-0.797690840943391108362662755}, { 0.603066598540348201693430617},
    { 0.862423956111040538690933878}, { 0.506186645345155291048942344},
    {-0.506186645345155291048942344}, { 0.862423956111040538690933878},
    { 0.251897818154216950498106628}, { 0.967753837093475465243391912},
    {-0.967753837093475465243391912}, { 0.251897818154216950498106628},
    { 0.944604837261480265659265493}, { 0.328209843579092526107916817},
    {-0.328209843579092526107916817}, { 0.944604837261480265659265493},
    { 0.435857079922255491032544080}, { 0.900015892016160228714535267},
    {-0.900015892016160228714535267}, { 0.435857079922255491032544080},
    { 0.747100605980180144323078847}, { 0.664710978203344868130324985},
    {-0.664710978203344868130324985}, { 0.747100605980180144323078847},
    { 0.058258264500435759613979782}, { 0.998301544933892840738782163},
    {-0.998301544933892840738782163}, { 0.058258264500435759613979782},
    { 0.996044700901251989887944810}, { 0.088853552582524596561586535},
    {-0.088853552582524596561586535}, { 0.996044700901251989887944810},
    { 0.641481012808583151988739898}, { 0.767138911935820381181694573},
    {-0.767138911935820381181694573}, { 0.641481012808583151988739898},
    { 0.886222530148880631647990821}, { 0.463259783551860197390719637},
    {-0.463259783551860197390719637}, { 0.886222530148880631647990821},
    { 0.299079826308040476750336973}, { 0.954228095109105629780430732},
    {-0.954228095109105629780430732}, { 0.299079826308040476750336973},
    { 0.959571513081984528335528181}, { 0.281464937925757984095231007},
    {-0.281464937925757984095231007}, { 0.959571513081984528335528181},
    { 0.479493757660153026679839798}, { 0.877545290207261291668470750},
    {-0.877545290207261291668470750}, { 0.479493757660153026679839798},
    { 0.778816512381475953374724325}, { 0.627251815495144113509622565},
    {-0.627251815495144113509622565}, { 0.778816512381475953374724325},
    { 0.107172424956808849175529148}, { 0.994240449453187946358413442},
    {-0.994240449453187946358413442}, { 0.107172424956808849175529148},
    { 0.982539302287441255907040396}, { 0.186055151663446648105438304},
    {-0.186055151663446648105438304}, { 0.982539302287441255907040396},
    { 0.563199344013834115007363772}, { 0.826321062845663480311195452},
    {-0.826321062845663480311195452}, { 0.563199344013834115007363772},
    { 0.836547727223511984524285790}, { 0.547894059173100165608820571},
    {-0.547894059173100165608820571}, { 0.836547727223511984524285790},
    { 0.204108966092816874181696950}, { 0.978948175319062194715480124},
    {-0.978948175319062194715480124}, { 0.204108966092816874181696950},
    { 0.927362525650401087274536959}, { 0.374164062971457997104393020},
    {-0.374164062971457997104393020}, { 0.927362525650401087274536959},
    { 0.391170384302253888687512949}, { 0.920318276709110566440076541},
    {-0.920318276709110566440076541}, { 0.391170384302253888687512949},
    { 0.713584868780793592903125099}, { 0.700568793943248366792866380},
    {-0.700568793943248366792866380}, { 0.713584868780793592903125099},
    { 0.009203754782059819315102378}, { 0.999957644551963866333120920},
    {-0.999957644551963866333120920}, { 0.009203754782059819315102378},
    { 0.999957644551963866333120920}, { 0.009203754782059819315102378},
    {-0.009203754782059819315102378}, { 0.999957644551963866333120920},
    { 0.700568793943248366792866380}, { 0.713584868780793592903125099},
    {-0.713584868780793592903125099}, { 0.700568793943248366792866380},
    { 0.920318276709110566440076541}, { 0.391170384302253888687512949},
    {-0.391170384302253888687512949}, { 0.920318276709110566440076541},
    { 0.374164062971457997104393020}, { 0.927362525650401087274536959},
    {-0.927362525650401087274536959}, { 0.374164062971457997104393020},
    { 0.978948175319062194715480124}, { 0.204108966092816874181696950},
    {-0.204108966092816874181696950}, { 0.978948175319062194715480124},
    { 0.547894059173100165608820571}, { 0.836547727223511984524285790},
    {-0.836547727223511984524285790}, { 0.547894059173100165608820571},
    { 0.826321062845663480311195452}, { 0.563199344013834115007363772},
    {-0.563199344013834115007363772}, { 0.826321062845663480311195452},
    { 0.186055151663446648105438304}, { 0.982539302287441255907040396},
    {-0.982539302287441255907040396}, { 0.186055151663446648105438304},
    { 0.994240449453187946358413442}, { 0.107172424956808849175529148},
    {-0.107172424956808849175529148}, { 0.994240449453187946358413442},
    { 0.627251815495144113509622565}, { 0.778816512381475953374724325},
    {-0.778816512381475953374724325}, { 0.627251815495144113509622565},
    { 0.877545290207261291668470750}, { 0.479493757660153026679839798},
    {-0.479493757660153026679839798}, { 0.877545290207261291668470750},
    { 0.281464937925757984095231007}, { 0.959571513081984528335528181},
    {-0.959571513081984528335528181}, { 0.281464937925757984095231007},
    { 0.954228095109105629780430732}, { 0.299079826308040476750336973},
    {-0.299079826308040476750336973}, { 0.954228095109105629780430732},
    { 0.463259783551860197390719637}, { 0.886222530148880631647990821},
    {-0.886222530148880631647990821}, { 0.463259783551860197390719637},
    { 0.767138911935820381181694573}, { 0.641481012808583151988739898},
    {-0.641481012808583151988739898}, { 0.767138911935820381181694573},
    { 0.088853552582524596561586535}, { 0.996044700901251989887944810},
    {-0.996044700901251989887944810}, { 0.088853552582524596561586535},
    { 0.998301544933892840738782163}, { 0.058258264500435759613979782},
    {-0.058258264500435759613979782}, { 0.998301544933892840738782163},
    { 0.664710978203344868130324985}, { 0.747100605980180144323078847},
    {-0.747100605980180144323078847}, { 0.664710978203344868130324985},
    { 0.900015892016160228714535267}, { 0.435857079922255491032544080},
    {-0.435857079922255491032544080}, { 0.900015892016160228714535267},
    { 0.328209843579092526107916817}, { 0.944604837261480265659265493},
    {-0.944604837261480265659265493}, { 0.328209843579092526107916817},
    { 0.967753837093475465243391912}, { 0.251897818154216950498106628},
    {-0.251897818154216950498106628}, { 0.967753837093475465243391912},
    { 0.506186645345155291048942344}, { 0.862423956111040538690933878},
    {-0.862423956111040538690933878}, { 0.506186645345155291048942344},
    { 0.797690840943391108362662755}, { 0.603066598540348201693430617},
    {-0.603066598540348201693430617}, { 0.797690840943391108362662755},
    { 0.137620121586486044948441663}, { 0.990485084256457037998682243},
    {-0.990485084256457037998682243}, { 0.137620121586486044948441663},
    { 0.987784141644572154230969032}, { 0.155828397654265235743101486},
    {-0.155828397654265235743101486}, { 0.987784141644572154230969032},
    { 0.588281548222645304786439813}, { 0.808656181588174991946968128},
    {-0.808656181588174991946968128}, { 0.588281548222645304786439813},
    { 0.852960604930363657746588082}, { 0.521975292937154342694258318},
    {-0.521975292937154342694258318}, { 0.852960604930363657746588082},
    { 0.234041958583543423191242045}, { 0.972226497078936305708321144},
    {-0.972226497078936305708321144}, { 0.234041958583543423191242045},
    { 0.938403534063108112192420774}, { 0.345541324963989065539191723},
    {-0.345541324963989065539191723}, { 0.938403534063108112192420774},
    { 0.419216888363223956433010020}, { 0.907886116487666212038681480},
    {-0.907886116487666212038681480}, { 0.419216888363223956433010020},
    { 0.734738878095963464563223604}, { 0.678350043129861486873655042},
    {-0.678350043129861486873655042}, { 0.734738878095963464563223604},
    { 0.039872927587739811128578738}, { 0.999204758618363895492950001},
    {-0.999204758618363895492950001}, { 0.039872927587739811128578738},
    { 0.999430604555461772019008327}, { 0.033741171851377584833716112},
    {-0.033741171851377584833716112}, { 0.999430604555461772019008327},
    { 0.682845546385248068164596123}, { 0.730562769227827561177758850},
    {-0.730562769227827561177758850}, { 0.682845546385248068164596123},
    { 0.910441292258067196934095369}, { 0.413638312238434547471944324},
    {-0.413638312238434547471944324}, { 0.910441292258067196934095369},
    { 0.351292756085567125601307623}, { 0.936265667170278246576310996},
    {-0.936265667170278246576310996}, { 0.351292756085567125601307623},
    { 0.973644249650811925318383912}, { 0.228072083170885739254457379},
    {-0.228072083170885739254457379}, { 0.973644249650811925318383912},
    { 0.527199134781901348464274575}, { 0.849741768000852489471268395},
    {-0.849741768000852489471268395}, { 0.527199134781901348464274575},
    { 0.812250586585203913049744181}, { 0.583308652937698294392830961},
    {-0.583308652937698294392830961}, { 0.812250586585203913049744181},
    { 0.161886393780111837641387995}, { 0.986809401814185476970235952},
    {-0.986809401814185476970235952}, { 0.161886393780111837641387995},
    { 0.991310859846115418957349799}, { 0.131540028702883111103387493},
    {-0.131540028702883111103387493}, { 0.991310859846115418957349799},
    { 0.607949784967773667243642671}, { 0.793975477554337164895083757},
    {-0.793975477554337164895083757}, { 0.607949784967773667243642671},
    { 0.865513624090569082825488358}, { 0.500885382611240786241285004},
    {-0.500885382611240786241285004}, { 0.865513624090569082825488358},
    { 0.257831102162159005614471295}, { 0.966190003445412555433832961},
    {-0.966190003445412555433832961}, { 0.257831102162159005614471295},
    { 0.946600913083283570044599823}, { 0.322407678801069848384807478},
    {-0.322407678801069848384807478}, { 0.946600913083283570044599823},
    { 0.441371268731716692879988968}, { 0.897324580705418281231391836},
    {-0.897324580705418281231391836}, { 0.441371268731716692879988968},
    { 0.751165131909686411205819422}, { 0.660114342067420478559490747},
    {-0.660114342067420478559490747}, { 0.751165131909686411205819422},
    { 0.064382630929857460819324537}, { 0.997925286198596012623025462},
    {-0.997925286198596012623025462}, { 0.064382630929857460819324537},
    { 0.996571145790554847093566910}, { 0.082740264549375693111987083},
    {-0.082740264549375693111987083}, { 0.996571145790554847093566910},
    { 0.646176012983316364832802220}, { 0.763188417263381271704838297},
    {-0.763188417263381271704838297}, { 0.646176012983316364832802220},
    { 0.889048355854664562540777729}, { 0.457813303598877221904961155},
    {-0.457813303598877221904961155}, { 0.889048355854664562540777729},
    { 0.304929229735402406490728633}, { 0.952375012719765858529893608},
    {-0.952375012719765858529893608}, { 0.304929229735402406490728633},
    { 0.961280485811320641748659653}, { 0.275571819310958163076425168},
    {-0.275571819310958163076425168}, { 0.961280485811320641748659653},
    { 0.484869248000791101822951699}, { 0.874586652278176112634431897},
    {-0.874586652278176112634431897}, { 0.484869248000791101822951699},
    { 0.782650596166575738458949301}, { 0.622461279374149972519166721},
    {-0.622461279374149972519166721}, { 0.782650596166575738458949301},
    { 0.113270952177564349018228733}, { 0.993564135520595333782021697},
    {-0.993564135520595333782021697}, { 0.113270952177564349018228733},
    { 0.983662419211730274396237776}, { 0.180022901405699522679906590},
    {-0.180022901405699522679906590}, { 0.983662419211730274396237776},
    { 0.568258952670131549790548489}, { 0.822849781375826332046780034},
    {-0.822849781375826332046780034}, { 0.568258952670131549790548489},
    { 0.839893794195999504583383987}, { 0.542750784864515906586768661},
    {-0.542750784864515906586768661}, { 0.839893794195999504583383987},
    { 0.210111836880469621717489972}, { 0.977677357824509979943404762},
    {-0.977677357824509979943404762}, { 0.210111836880469621717489972},
    { 0.929640895843181265457918066}, { 0.368466829953372331712746222},
    {-0.368466829953372331712746222}, { 0.929640895843181265457918066},
    { 0.396809987416710328595290911}, { 0.917900775621390457642276297},
    {-0.917900775621390457642276297}, { 0.396809987416710328595290911},
    { 0.717870045055731736211325329}, { 0.696177131491462944788582591},
    {-0.696177131491462944788582591}, { 0.717870045055731736211325329},
    { 0.015339206284988101044151868}, { 0.999882347454212525633049627},
    {-0.999882347454212525633049627}, { 0.015339206284988101044151868},
    { 0.999769405351215321657617036}, { 0.021474080275469507418374898},
    {-0.021474080275469507418374898}, { 0.999769405351215321657617036},
    { 0.691759258364157774906734132}, { 0.722128193929215321243607198},
    {-0.722128193929215321243607198}, { 0.691759258364157774906734132},
    { 0.915448716088267819566431292}, { 0.402434650859418441082533934},
    {-0.402434650859418441082533934}, { 0.915448716088267819566431292},
    { 0.362755724367397216204854462}, { 0.931884265581668106718557199},
    {-0.931884265581668106718557199}, { 0.362755724367397216204854462},
    { 0.976369731330021149312732194}, { 0.216106797076219509948385131},
    {-0.216106797076219509948385131}, { 0.976369731330021149312732194},
    { 0.537587076295645482502214932}, { 0.843208239641845437161743865},
    {-0.843208239641845437161743865}, { 0.537587076295645482502214932},
    { 0.819347520076796960824689637}, { 0.573297166698042212820171239},
    {-0.573297166698042212820171239}, { 0.819347520076796960824689637},
    { 0.173983873387463827950700807}, { 0.984748501801904218556553176},
    {-0.984748501801904218556553176}, { 0.173983873387463827950700807},
    { 0.992850414459865090793563344}, { 0.119365214810991364593637790},
    {-0.119365214810991364593637790}, { 0.992850414459865090793563344},
    { 0.617647307937803932403979402}, { 0.786455213599085757522319464},
    {-0.786455213599085757522319464}, { 0.617647307937803932403979402},
    { 0.871595086655951034842481435}, { 0.490226483288291154229598449},
    {-0.490226483288291154229598449}, { 0.871595086655951034842481435},
    { 0.269668325572915106525464462}, { 0.962953266873683886347921481},
    {-0.962953266873683886347921481}, { 0.269668325572915106525464462},
    { 0.950486073949481721759926101}, { 0.310767152749611495835997250},
    {-0.310767152749611495835997250}, { 0.950486073949481721759926101},
    { 0.452349587233770874133026703}, { 0.891840709392342727796478697},
    {-0.891840709392342727796478697}, { 0.452349587233770874133026703},
    { 0.759209188978388033485525443}, { 0.650846684996380915068975573},
    {-0.650846684996380915068975573}, { 0.759209188978388033485525443},
    { 0.076623861392031492278332463}, { 0.997060070339482978987989949},
    {-0.997060070339482978987989949}, { 0.076623861392031492278332463},
    { 0.997511456140303459699448390}, { 0.070504573389613863027351471},
    {-0.070504573389613863027351471}, { 0.997511456140303459699448390},
    { 0.655492852999615385312679701}, { 0.755201376896536527598710756},
    {-0.755201376896536527598710756}, { 0.655492852999615385312679701},
    { 0.894599485631382678433072126}, { 0.446868840162374195353044389},
    {-0.446868840162374195353044389}, { 0.894599485631382678433072126},
    { 0.316593375556165867243047035}, { 0.948561349915730288158494826},
    {-0.948561349915730288158494826}, { 0.316593375556165867243047035},
    { 0.964589793289812723836432159}, { 0.263754678974831383611349322},
    {-0.263754678974831383611349322}, { 0.964589793289812723836432159},
    { 0.495565261825772531150266670}, { 0.868570705971340895340449876},
    {-0.868570705971340895340449876}, { 0.495565261825772531150266670},
    { 0.790230221437310055030217152}, { 0.612810082429409703935211936},
    {-0.612810082429409703935211936}, { 0.790230221437310055030217152},
    { 0.125454983411546238542336453}, { 0.992099313142191757112085445},
    {-0.992099313142191757112085445}, { 0.125454983411546238542336453},
    { 0.985797509167567424700995000}, { 0.167938294974731178054745536},
    {-0.167938294974731178054745536}, { 0.985797509167567424700995000},
    { 0.578313796411655563342245019}, { 0.815814410806733789010772660},
    {-0.815814410806733789010772660}, { 0.578313796411655563342245019},
    { 0.846490938774052078300544488}, { 0.532403127877197971442805218},
    {-0.532403127877197971442805218}, { 0.846490938774052078300544488},
    { 0.222093620973203534094094721}, { 0.975025345066994146844913468},
    {-0.975025345066994146844913468}, { 0.222093620973203534094094721},
    { 0.934092550404258914729877883}, { 0.357030961233430032614954036},
    {-0.357030961233430032614954036}, { 0.934092550404258914729877883},
    { 0.408044162864978680820747499}, { 0.912962190428398164628018233},
    {-0.912962190428398164628018233}, { 0.408044162864978680820747499},
    { 0.726359155084345976817494315}, { 0.687315340891759108199186948},
    {-0.687315340891759108199186948}, { 0.726359155084345976817494315},
    { 0.027608145778965741612354872}, { 0.999618822495178597116830637},
    {-0.999618822495178597116830637}, { 0.027608145778965741612354872},
    { 0.998941293186856850633930266}, { 0.046003182130914628814301788},
    {-0.046003182130914628814301788}, { 0.998941293186856850633930266},
    { 0.673829000378756060917568372}, { 0.738887324460615147933116508},
    {-0.738887324460615147933116508}, { 0.673829000378756060917568372},
    { 0.905296759318118774354048329}, { 0.424779681209108833357226189},
    {-0.424779681209108833357226189}, { 0.905296759318118774354048329},
    { 0.339776884406826857828825803}, { 0.940506070593268323787291309},
    {-0.940506070593268323787291309}, { 0.339776884406826857828825803},
    { 0.970772140728950302138169611}, { 0.240003022448741486568922365},
    {-0.240003022448741486568922365}, { 0.970772140728950302138169611},
    { 0.516731799017649881508753876}, { 0.856147328375194481019630732},
    {-0.856147328375194481019630732}, { 0.516731799017649881508753876},
    { 0.805031331142963597922659282}, { 0.593232295039799808047809426},
    {-0.593232295039799808047809426}, { 0.805031331142963597922659282},
    { 0.149764534677321517229695737}, { 0.988721691960323767604516485},
    {-0.988721691960323767604516485}, { 0.149764534677321517229695737},
    { 0.989622017463200834623694454}, { 0.143695033150294454819773349},
    {-0.143695033150294454819773349}, { 0.989622017463200834623694454},
    { 0.598160706996342311724958652}, { 0.801376171723140219430247777},
    {-0.801376171723140219430247777}, { 0.598160706996342311724958652},
    { 0.859301818357008404783582139}, { 0.511468850437970399504391001},
    {-0.511468850437970399504391001}, { 0.859301818357008404783582139},
    { 0.245955050335794611599924709}, { 0.969281235356548486048290738},
    {-0.969281235356548486048290738}, { 0.245955050335794611599924709},
    { 0.942573197601446879280758735}, { 0.333999651442009404650865481},
    {-0.333999651442009404650865481}, { 0.942573197601446879280758735},
    { 0.430326481340082633908199031}, { 0.902673318237258806751502391},
    {-0.902673318237258806751502391}, { 0.430326481340082633908199031},
    { 0.743007952135121693517362293}, { 0.669282588346636065720696366},
    {-0.669282588346636065720696366}, { 0.743007952135121693517362293},
    { 0.052131704680283321236358216}, { 0.998640218180265222418199049},
    {-0.998640218180265222418199049}, { 0.052131704680283321236358216},
    { 0.995480755491926941769171600}, { 0.094963495329638998938034312},
    {-0.094963495329638998938034312}, { 0.995480755491926941769171600},
    { 0.636761861236284230413943435}, { 0.771060524261813773200605759},
    {-0.771060524261813773200605759}, { 0.636761861236284230413943435},
    { 0.883363338665731594736308015}, { 0.468688822035827933697617870},
    {-0.468688822035827933697617870}, { 0.883363338665731594736308015},
    { 0.293219162694258650606608599}, { 0.956045251349996443270479823},
    {-0.956045251349996443270479823}, { 0.293219162694258650606608599},
    { 0.957826413027532890321037029}, { 0.287347459544729526477331841},
    {-0.287347459544729526477331841}, { 0.957826413027532890321037029},
    { 0.474100214650550014398580015}, { 0.880470889052160770806542929},
    {-0.880470889052160770806542929}, { 0.474100214650550014398580015},
    { 0.774953106594873878359129282}, { 0.632018735939809021909403706},
    {-0.632018735939809021909403706}, { 0.774953106594873878359129282},
    { 0.101069862754827824987887585}, { 0.994879330794805620591166107},
    {-0.994879330794805620591166107}, { 0.101069862754827824987887585},
    { 0.981379193313754574318224190}, { 0.192080397049892441679288205},
    {-0.192080397049892441679288205}, { 0.981379193313754574318224190},
    { 0.558118531220556115693702964}, { 0.829761233794523042469023765},
    {-0.829761233794523042469023765}, { 0.558118531220556115693702964},
    { 0.833170164701913186439915922}, { 0.553016705580027531764226988},
    {-0.553016705580027531764226988}, { 0.833170164701913186439915922},
    { 0.198098410717953586179324918}, { 0.980182135968117392690210009},
    {-0.980182135968117392690210009}, { 0.198098410717953586179324918},
    { 0.925049240782677590302371869}, { 0.379847208924051170576281147},
    {-0.379847208924051170576281147}, { 0.925049240782677590302371869},
    { 0.385516053843918864075607949}, { 0.922701128333878570437264227},
    {-0.922701128333878570437264227}, { 0.385516053843918864075607949},
    { 0.709272826438865651316533772}, { 0.704934080375904908852523758},
    {-0.704934080375904908852523758}, { 0.709272826438865651316533772},
    { 0.003067956762965976270145365}, { 0.999995293809576171511580126},
    {-0.999995293809576171511580126}, { 0.003067956762965976270145365}
};

const fpr fpr_p2_tab[] = {
    { 2.00000000000 },
    { 1.00000000000 },
    { 0.50000000000 },
    { 0.25000000000 },
    { 0.12500000000 },
    { 0.06250000000 },
    { 0.03125000000 },
    { 0.01562500000 },
    { 0.00781250000 },
    { 0.00390625000 },
    { 0.00195312500 }
};
