/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

public class Select {
    private String selectClause;
    private String fromClause;
    private String outerJoinsAfterFrom;
    private String whereClause;
    private String outerJoinsAfterWhere;
    private String orderByClause;

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.selectClause.length() + this.fromClause.length() + this.outerJoinsAfterFrom.length() + this.whereClause.length() + this.outerJoinsAfterWhere.length() + 20);
        buf.append("select ").append(this.selectClause).append(" from ").append(this.fromClause).append(this.outerJoinsAfterFrom).append(" where ").append(this.whereClause).append(this.outerJoinsAfterWhere);
        if (this.orderByClause != null && this.orderByClause.trim().length() > 0) {
            buf.append(" order by ").append(this.orderByClause);
        }
        return buf.toString();
    }

    public Select setFromClause(String fromClause) {
        this.fromClause = fromClause;
        return this;
    }

    public Select setFromClause(String tableName, String alias) {
        this.fromClause = tableName + ' ' + alias;
        return this;
    }

    public Select setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public Select setOuterJoins(String outerJoinsAfterFrom, String outerJoinsAfterWhere) {
        this.outerJoinsAfterFrom = outerJoinsAfterFrom;
        this.outerJoinsAfterWhere = outerJoinsAfterWhere;
        return this;
    }

    public Select setSelectClause(String selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public Select setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }
}

