/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.HashSet;
import java.util.Iterator;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.QueryJoinFragment;

public class QuerySelect {
    private JoinFragment joins;
    private StringBuffer select = new StringBuffer();
    private StringBuffer where = new StringBuffer();
    private StringBuffer groupBy = new StringBuffer();
    private StringBuffer orderBy = new StringBuffer();
    private StringBuffer having = new StringBuffer();
    private boolean distinct = false;
    private static final HashSet DONT_SPACE_TOKENS = new HashSet();

    public QuerySelect(Dialect dialect) {
        this.joins = new QueryJoinFragment(dialect);
    }

    public JoinFragment getJoinFragment() {
        return this.joins;
    }

    public void addSelectFragmentString(String fragment) {
        if (fragment.length() > 0 && fragment.charAt(0) == ',') {
            fragment = fragment.substring(1);
        }
        if ((fragment = fragment.trim()).length() > 0) {
            if (this.select.length() > 0) {
                this.select.append(", ");
            }
            this.select.append(fragment);
        }
    }

    public void addSelectColumn(String columnName, String alias) {
        this.addSelectFragmentString(columnName + ' ' + alias);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setWhereTokens(Iterator tokens) {
        this.appendTokens(this.where, tokens);
    }

    public void setGroupByTokens(Iterator tokens) {
        this.appendTokens(this.groupBy, tokens);
    }

    public void setOrderByTokens(Iterator tokens) {
        this.appendTokens(this.orderBy, tokens);
    }

    public void setHavingTokens(Iterator tokens) {
        this.appendTokens(this.having, tokens);
    }

    public void addOrderBy(String orderByString) {
        if (this.orderBy.length() > 0) {
            this.orderBy.append(", ");
        }
        this.orderBy.append(orderByString);
    }

    public String toQueryString() {
        boolean hasPart2;
        StringBuffer buf = new StringBuffer(50).append("select ");
        if (this.distinct) {
            buf.append("distinct ");
        }
        buf.append(this.select.toString()).append(" from").append(this.joins.toFromFragmentString().substring(1));
        String part1 = this.joins.toWhereFragmentString().trim();
        String part2 = this.where.toString().trim();
        boolean hasPart1 = part1.length() > 0;
        boolean bl = hasPart2 = part2.length() > 0;
        if (hasPart1 || hasPart2) {
            buf.append(" where ");
        }
        if (hasPart1) {
            buf.append(part1.substring(4));
        }
        if (hasPart2) {
            if (hasPart1) {
                buf.append(" and (");
            }
            buf.append(part2);
            if (hasPart1) {
                buf.append(")");
            }
        }
        if (this.groupBy.length() > 0) {
            buf.append(" group by ").append(this.groupBy.toString());
        }
        if (this.having.length() > 0) {
            buf.append(" having ").append(this.having.toString());
        }
        if (this.orderBy.length() > 0) {
            buf.append(" order by ").append(this.orderBy.toString());
        }
        return buf.toString();
    }

    private void appendTokens(StringBuffer buf, Iterator iter) {
        boolean lastSpaceable = true;
        boolean lastQuoted = false;
        while (iter.hasNext()) {
            String token = (String)iter.next();
            boolean spaceable = !DONT_SPACE_TOKENS.contains(token);
            boolean quoted = token.startsWith("'");
            if (spaceable && lastSpaceable && (!quoted || !lastQuoted)) {
                buf.append(' ');
            }
            lastSpaceable = spaceable;
            buf.append(token);
            lastQuoted = token.endsWith("'");
        }
    }

    static {
        DONT_SPACE_TOKENS.add(".");
        DONT_SPACE_TOKENS.add("+");
        DONT_SPACE_TOKENS.add("-");
        DONT_SPACE_TOKENS.add("/");
        DONT_SPACE_TOKENS.add("*");
        DONT_SPACE_TOKENS.add("<");
        DONT_SPACE_TOKENS.add(">");
        DONT_SPACE_TOKENS.add("=");
        DONT_SPACE_TOKENS.add("#");
        DONT_SPACE_TOKENS.add("~");
        DONT_SPACE_TOKENS.add("|");
        DONT_SPACE_TOKENS.add("&");
        DONT_SPACE_TOKENS.add("<=");
        DONT_SPACE_TOKENS.add(">=");
        DONT_SPACE_TOKENS.add("=>");
        DONT_SPACE_TOKENS.add("=<");
        DONT_SPACE_TOKENS.add("!=");
        DONT_SPACE_TOKENS.add("<>");
        DONT_SPACE_TOKENS.add("!#");
        DONT_SPACE_TOKENS.add("!~");
        DONT_SPACE_TOKENS.add("!<");
        DONT_SPACE_TOKENS.add("!>");
        DONT_SPACE_TOKENS.add("(");
        DONT_SPACE_TOKENS.add(")");
    }
}

