/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.Nestable;

public class ExceptionUtils {
    protected static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException"};
    protected static final Object[] CAUSE_METHOD_PARAMS = new Object[0];
    static /* synthetic */ Class class$java$lang$Throwable;

    protected ExceptionUtils() {
    }

    public static Throwable getCause(Throwable t) {
        return ExceptionUtils.getCause(t, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable t, String[] methodNames) {
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(t);
        if (cause == null) {
            int i = 0;
            while (i < methodNames.length) {
                cause = ExceptionUtils.getCauseUsingMethodName(t, methodNames[i]);
                if (cause != null) break;
                ++i;
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(t, "detail");
            }
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable cause = ExceptionUtils.getCause(t);
        if (cause != null) {
            t = cause;
            while ((t = ExceptionUtils.getCause(t)) != null) {
                cause = t;
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable t) {
        if (t instanceof Nestable) {
            return ((Nestable)((Object)t)).getCause();
        }
        if (t instanceof SQLException) {
            return ((SQLException)t).getNextException();
        }
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable t, String methodName) {
        Method method = null;
        try {
            method = t.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)t, CAUSE_METHOD_PARAMS);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable t, String fieldName) {
        Field field = null;
        try {
            field = t.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(t);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThrowableCount(Throwable t) {
        int count = 0;
        while (t != null) {
            ++count;
            t = ExceptionUtils.getCause(t);
        }
        return count;
    }

    public static Throwable[] getThrowables(Throwable t) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (t != null) {
            list.add(t);
            t = ExceptionUtils.getCause(t);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static int indexOfThrowable(Throwable t, Class type) {
        return ExceptionUtils.indexOfThrowable(t, type, 0);
    }

    public static int indexOfThrowable(Throwable t, Class type, int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + fromIndex);
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(t);
        if (fromIndex >= throwables.length) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + fromIndex);
        }
        int i = fromIndex;
        while (i < throwables.length) {
            if (throwables[i].getClass().equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable t) {
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(t));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = SystemUtils.LINE_SEPARATOR;
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

