## Use this for Azure AD authentication
from msrestazure.azure_active_directory import AADTokenCredentials

## Required for Data Lake Storage Gen1 account management
from azure.mgmt.datalake.store import DataLakeStoreAccountManagementClient
from azure.mgmt.datalake.store.models import DataLakeStoreAccount

## Required for Data Lake Storage Gen1 filesystem management
from azure.datalake.store import core, lib, multithread

# Common Azure imports
import adal
from azure.mgmt.resource.resources import ResourceManagementClient
from azure.mgmt.resource.resources.models import ResourceGroup

## Use these as needed for your application
import logging, getpass, pprint, uuid, time

tenant = 'xxxxxxxxxxxxxxxxxxxxx'  ## your Tenant ID
RESOURCE = 'https://datalake.azure.net/'
client_id = 'xxxxxxxxxxxx'  ## your SPN Client ID
client_secret = 'xxxxxxxxxxxxxxxxxxxxxxx'  ## SPN Secret Key

adlCreds = lib.auth(tenant_id=tenant, client_secret=client_secret, client_id=client_id, resource=RESOURCE)

adls_name = 'xxxxxxxxxxxxx'  ## Store name

adls_client = core.AzureDLFileSystem(adlCreds, store_name=adls_name)

myfolder = 'the folder name'

adls_client.listdir(myfolder)
file_list = []
for folder in adls_client.listdir(myfolder):
    print(folder)
    file = adls_client.listdir(folder)
    core._fetch_range(adls_client.azure.azure, folder, 0, 0)
    with adls_client.open(folder) as f:
        f.read()
    file_list.extend(file)
print(file_list)
