/*
 *	Routines for VLAN interface handling
 *
 *	Copyright (C) 2009, 2010  Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_VLAN_H
#define __NETCONTROL_VLAN_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <ntypes.h>
#include <handle.h>

struct nc_vlan {
	unsigned int		tag;
	char *			interface_name;
	unsigned int		interface_link;
};

int			nc_vlan_bind(nc_interface_t *ifp, nc_handle_t *nh, nc_var_array_t *);

nc_vlan_t *		nc_vlan_new(const char *ifname, unsigned int tag);
nc_vlan_t *		nc_vlan_clone(nc_vlan_t *vlan);
void			nc_vlan_free(nc_vlan_t *vlan);

int			nc_vlan_get_settings(const char *vlan, char **real, unsigned int *tag);
int			nc_vlan_get_vlan_ifaces(const char *real, nc_string_array_t *vlans);

#endif /* __NETCONTROL_VLAN_H */
