/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.ErrorItem;
import org.xml.sax.Attributes;

public class AppenderRefAction
extends Action {
    boolean inError = false;

    public void begin(ExecutionContext ec, String tagName, Attributes attributes) {
        this.inError = false;
        Object o = ec.peekObject();
        if (!(o instanceof AppenderAttachable)) {
            String errMsg = "Could not find an AppenderAttachable at the top of execution stack. Near <" + tagName + "> line " + this.getLineNumber(ec);
            this.getLogger().warn(errMsg);
            this.inError = true;
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        AppenderAttachable appenderAttachable = (AppenderAttachable)o;
        String appenderName = attributes.getValue("ref");
        if (Option.isEmpty(appenderName)) {
            String errMsg = "Missing appender ref attribute in <appender-ref> tag.";
            this.getLogger().warn(errMsg);
            this.inError = true;
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        HashMap appenderBag = (HashMap)ec.getObjectMap().get("APPENDER_BAG");
        Appender appender = (Appender)appenderBag.get(appenderName);
        if (appender == null) {
            String msg = "Could not find an appender named [" + appenderName + "]. Did you define it below in the config file?";
            this.getLogger().warn(msg);
            this.getLogger().warn((Object)"See {}#appender_order for more details.", "http://logging.apache.org/log4j/docs/codes.html");
            this.inError = true;
            ec.addError(new ErrorItem(msg));
            return;
        }
        if (appenderAttachable instanceof Logger) {
            this.getLogger().debug("Attaching appender named [{}] to logger named [{}].", appenderName, ((Logger)appenderAttachable).getName());
        } else {
            this.getLogger().debug("Attaching appender named [{}] to {}.", appenderName, appenderAttachable);
        }
        appenderAttachable.addAppender(appender);
    }

    public void end(ExecutionContext ec, String n) {
    }

    public void finish(ExecutionContext ec) {
    }
}

