/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

class NodeFiles {
    NodeFiles() {
    }

    static String path() {
        String d = Options.S("OUTPUT_DIRECTORY");
        if (d.equals("")) {
            return "";
        }
        return d + System.getProperty("file.separator");
    }

    static void ensure(IO io, String nodeType) {
        String fileName = NodeFiles.path() + nodeType + ".java";
        if (!nodeType.equals("Node")) {
            if (nodeType.equals("SimpleNode")) {
                NodeFiles.ensure(io, "Node");
            } else {
                NodeFiles.ensure(io, "SimpleNode");
            }
        }
        if (!nodeType.equals("Node") && !Options.B("BUILD_NODE_FILES")) {
            return;
        }
        if (new File(fileName).exists()) {
            return;
        }
        io.getMsg().println("File \"" + fileName + "\" does not exist.  Will create one.");
        try {
            PrintWriter ostr = new PrintWriter(new BufferedWriter(new FileWriter(fileName), 8096));
            if (nodeType.equals("Node")) {
                NodeFiles.generateNode_java(ostr);
            } else if (nodeType.equals("SimpleNode")) {
                NodeFiles.generateSimpleNode_java(ostr);
            } else {
                NodeFiles.generateMULTINode_java(ostr, nodeType);
            }
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static void generatePrologue(PrintWriter ostr, String fileName) {
        ostr.println("/* " + JavaCCGlobals.getIdString(JJTreeGlobals.toolList, fileName) + " */");
        ostr.println();
        if (!JJTreeGlobals.packageName.equals("")) {
            ostr.println("package " + JJTreeGlobals.packageName + ";");
            ostr.println();
        }
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants_java() {
        String name = NodeFiles.nodeConstants();
        String fileName = NodeFiles.path() + name + ".java";
        try {
            PrintWriter ostr = new PrintWriter(new BufferedWriter(new FileWriter(fileName), 8096));
            Vector nodeIds = ASTNodeDescriptor.getNodeIds();
            Vector nodeNames = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(ostr, fileName);
            ostr.println("public interface " + name);
            ostr.println("{");
            int i = 0;
            while (i < nodeIds.size()) {
                String n = (String)nodeIds.elementAt(i);
                ostr.println("  public int " + n + " = " + i + ";");
                ++i;
            }
            ostr.println();
            ostr.println();
            ostr.println("  public String[] jjtNodeName = {");
            int i2 = 0;
            while (i2 < nodeNames.size()) {
                String n = (String)nodeNames.elementAt(i2);
                ostr.println("    \"" + n + "\",");
                ++i2;
            }
            ostr.println("  };");
            ostr.println("}");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    static void generateVisitor_java() {
        if (!Options.B("VISITOR")) {
            return;
        }
        String name = NodeFiles.visitorClass();
        String fileName = NodeFiles.path() + name + ".java";
        try {
            PrintWriter ostr = new PrintWriter(new BufferedWriter(new FileWriter(fileName), 8096));
            Vector nodeNames = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(ostr, fileName);
            ostr.println("public interface " + name);
            ostr.println("{");
            String ve = Options.S("VISITOR_EXCEPTION");
            if (!ve.equals("")) {
                ve = " throws " + ve;
            }
            ostr.println("  public Object visit(SimpleNode node, Object data)" + ve + ";");
            if (Options.B("MULTI")) {
                int i = 0;
                while (i < nodeNames.size()) {
                    String n = (String)nodeNames.elementAt(i);
                    if (!n.equals("void")) {
                        String nodeType = Options.S("NODE_PREFIX") + n;
                        ostr.println("  public Object visit(" + nodeType + " node, Object data)" + ve + ";");
                    }
                    ++i;
                }
            }
            ostr.println("}");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    private static void generateNode_java(PrintWriter ostr) {
        NodeFiles.generatePrologue(ostr, "Node.java");
        ostr.println("/* All AST nodes must implement this interface.  It provides basic");
        ostr.println("   machinery for constructing the parent and child relationships");
        ostr.println("   between nodes. */");
        ostr.println("");
        ostr.println("public interface Node {");
        ostr.println("");
        ostr.println("  /** This method is called after the node has been made the current");
        ostr.println("    node.  It indicates that child nodes can now be added to it. */");
        ostr.println("  public void jjtOpen();");
        ostr.println("");
        ostr.println("  /** This method is called after all the child nodes have been");
        ostr.println("    added. */");
        ostr.println("  public void jjtClose();");
        ostr.println("");
        ostr.println("  /** This pair of methods are used to inform the node of its");
        ostr.println("    parent. */");
        ostr.println("  public void jjtSetParent(Node n);");
        ostr.println("  public Node jjtGetParent();");
        ostr.println("");
        ostr.println("  /** This method tells the node to add its argument to the node's");
        ostr.println("    list of children.  */");
        ostr.println("  public void jjtAddChild(Node n, int i);");
        ostr.println("");
        ostr.println("  /** This method returns a child node.  The children are numbered");
        ostr.println("     from zero, left to right. */");
        ostr.println("  public Node jjtGetChild(int i);");
        ostr.println("");
        ostr.println("  /** Return the number of children the node has. */");
        ostr.println("  public int jjtGetNumChildren();");
        if (Options.B("VISITOR")) {
            String ve = Options.S("VISITOR_EXCEPTION");
            if (!ve.equals("")) {
                ve = " throws " + ve;
            }
            ostr.println("");
            ostr.println("  /** Accept the visitor. **/");
            ostr.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + ve + ";");
        }
        ostr.println("}");
        ostr.close();
    }

    private static void generateSimpleNode_java(PrintWriter ostr) {
        NodeFiles.generatePrologue(ostr, "SimpleNode.java");
        ostr.println("public class SimpleNode implements Node {");
        ostr.println("  protected Node parent;");
        ostr.println("  protected Node[] children;");
        ostr.println("  protected int id;");
        ostr.println("  protected " + JJTreeGlobals.parserName + " parser;");
        ostr.println("");
        ostr.println("  public SimpleNode(int i) {");
        ostr.println("    id = i;");
        ostr.println("  }");
        ostr.println("");
        ostr.println("  public SimpleNode(" + JJTreeGlobals.parserName + " p, int i) {");
        ostr.println("    this(i);");
        ostr.println("    parser = p;");
        ostr.println("  }");
        ostr.println("");
        if (Options.B("NODE_FACTORY")) {
            ostr.println("  public static Node jjtCreate(int id) {");
            ostr.println("    return new SimpleNode(id);");
            ostr.println("  }");
            ostr.println("");
            ostr.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            ostr.println("    return new SimpleNode(p, id);");
            ostr.println("  }");
            ostr.println("");
        }
        ostr.println("  public void jjtOpen() {");
        ostr.println("  }");
        ostr.println("");
        ostr.println("  public void jjtClose() {");
        ostr.println("  }");
        ostr.println("  ");
        ostr.println("  public void jjtSetParent(Node n) { parent = n; }");
        ostr.println("  public Node jjtGetParent() { return parent; }");
        ostr.println("");
        ostr.println("  public void jjtAddChild(Node n, int i) {");
        ostr.println("    if (children == null) {");
        ostr.println("      children = new Node[i + 1];");
        ostr.println("    } else if (i >= children.length) {");
        ostr.println("      Node c[] = new Node[i + 1];");
        ostr.println("      System.arraycopy(children, 0, c, 0, children.length);");
        ostr.println("      children = c;");
        ostr.println("    }");
        ostr.println("    children[i] = n;");
        ostr.println("  }");
        ostr.println("");
        ostr.println("  public Node jjtGetChild(int i) {");
        ostr.println("    return children[i];");
        ostr.println("  }");
        ostr.println("");
        ostr.println("  public int jjtGetNumChildren() {");
        ostr.println("    return (children == null) ? 0 : children.length;");
        ostr.println("  }");
        ostr.println("");
        if (Options.B("VISITOR")) {
            String ve = Options.S("VISITOR_EXCEPTION");
            if (!ve.equals("")) {
                ve = " throws " + ve;
            }
            ostr.println("  /** Accept the visitor. **/");
            ostr.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + ve + " {");
            ostr.println("    return visitor.visit(this, data);");
            ostr.println("  }");
            ostr.println("");
            ostr.println("  /** Accept the visitor. **/");
            ostr.println("  public Object childrenAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + ve + " {");
            ostr.println("    if (children != null) {");
            ostr.println("      for (int i = 0; i < children.length; ++i) {");
            ostr.println("        children[i].jjtAccept(visitor, data);");
            ostr.println("      }");
            ostr.println("    }");
            ostr.println("    return data;");
            ostr.println("  }");
            ostr.println("");
        }
        ostr.println("  /* You can override these two methods in subclasses of SimpleNode to");
        ostr.println("     customize the way the node appears when the tree is dumped.  If");
        ostr.println("     your output uses more than one line you should override");
        ostr.println("     toString(String), otherwise overriding toString() is probably all");
        ostr.println("     you need to do. */");
        ostr.println("");
        ostr.println("  public String toString() { return " + NodeFiles.nodeConstants() + ".jjtNodeName[id]; }");
        ostr.println("  public String toString(String prefix) { return prefix + toString(); }");
        ostr.println("");
        ostr.println("  /* Override this method if you want to customize how the node dumps");
        ostr.println("     out its children. */");
        ostr.println("");
        ostr.println("  public void dump(String prefix) {");
        ostr.println("    System.out.println(toString(prefix));");
        ostr.println("    if (children != null) {");
        ostr.println("      for (int i = 0; i < children.length; ++i) {");
        ostr.println("\tSimpleNode n = (SimpleNode)children[i];");
        ostr.println("\tif (n != null) {");
        ostr.println("\t  n.dump(prefix + \" \");");
        ostr.println("\t}");
        ostr.println("      }");
        ostr.println("    }");
        ostr.println("  }");
        ostr.println("}");
        ostr.println("");
    }

    private static void generateMULTINode_java(PrintWriter ostr, String nodeType) {
        NodeFiles.generatePrologue(ostr, nodeType + ".java");
        ostr.println("public class " + nodeType + " extends SimpleNode {");
        ostr.println("  public " + nodeType + "(int id) {");
        ostr.println("    super(id);");
        ostr.println("  }");
        ostr.println();
        ostr.println("  public " + nodeType + "(" + JJTreeGlobals.parserName + " p, int id) {");
        ostr.println("    super(p, id);");
        ostr.println("  }");
        ostr.println();
        if (Options.B("NODE_FACTORY")) {
            ostr.println("  public static Node jjtCreate(int id) {");
            ostr.println("      return new " + nodeType + "(id);");
            ostr.println("  }");
            ostr.println();
            ostr.println("  public static Node jjtCreate(" + JJTreeGlobals.parserName + " p, int id) {");
            ostr.println("      return new " + nodeType + "(p, id);");
            ostr.println("  }");
        }
        if (Options.B("VISITOR")) {
            String ve = Options.S("VISITOR_EXCEPTION");
            if (!ve.equals("")) {
                ve = " throws " + ve;
            }
            ostr.println("");
            ostr.println("  /** Accept the visitor. **/");
            ostr.println("  public Object jjtAccept(" + NodeFiles.visitorClass() + " visitor, Object data)" + ve + " {");
            ostr.println("    return visitor.visit(this, data);");
            ostr.println("  }");
        }
        ostr.println("}");
        ostr.close();
    }
}

