; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -simplifycfg-require-and-preserve-domtree=1 < %s -frame-pointer=all -verify-machineinstrs | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128-n8:16:32-S128"
target triple = "i386-apple-macosx10.7"

; This test case has a landing pad with two predecessors, and a variable that
; is undef on the first edge while carrying the first function return value on
; the second edge.
;
; Live range splitting tries to isolate the block containing the first function
; call, and it is important that the last split point is after the function call
; so the return value can spill.
;
; <rdar://problem/10664933>

@Exception = external unnamed_addr constant { ptr, ptr }

declare void @llvm.memset.p0.i32(ptr nocapture, i8, i32, i1) nounwind

define void @f(ptr nocapture %arg, ptr nocapture %arg1, ptr nocapture %arg2, ptr nocapture %arg3, i32 %arg4, i32 %arg5) optsize ssp personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: f:
; CHECK:       ## %bb.0: ## %bb
; CHECK-NEXT:    pushl %ebp
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    .cfi_offset %ebp, -8
; CHECK-NEXT:    movl %esp, %ebp
; CHECK-NEXT:    .cfi_def_cfa_register %ebp
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    pushl %edi
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    subl $28, %esp
; CHECK-NEXT:    .cfi_offset %esi, -20
; CHECK-NEXT:    .cfi_offset %edi, -16
; CHECK-NEXT:    .cfi_offset %ebx, -12
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    xorl %edi, %edi
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:  Ltmp0:
; CHECK-NEXT:    ## implicit-def: $ebx
; CHECK-NEXT:    calll __Znam
; CHECK-NEXT:  Ltmp1:
; CHECK-NEXT:  ## %bb.1: ## %bb11
; CHECK-NEXT:    movl %eax, %esi
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne LBB0_2
; CHECK-NEXT:  ## %bb.7: ## %bb31
; CHECK-NEXT:    ## implicit-def: $eax
; CHECK-NEXT:    ## kill: killed $eax
; CHECK-NEXT:  LBB0_8: ## %bb38
; CHECK-NEXT:    ## =>This Loop Header: Depth=1
; CHECK-NEXT:    ## Child Loop BB0_13 Depth 2
; CHECK-NEXT:    ## Child Loop BB0_16 Depth 3
; CHECK-NEXT:    ## Child Loop BB0_21 Depth 2
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne LBB0_9
; CHECK-NEXT:  ## %bb.10: ## %bb41
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:  Ltmp2:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %esi, (%esp)
; CHECK-NEXT:    calll _Pjii
; CHECK-NEXT:  Ltmp3:
; CHECK-NEXT:  ## %bb.11: ## %bb42
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    decl %eax
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    jne LBB0_18
; CHECK-NEXT:  ## %bb.12: ## %bb45.preheader
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:    movl $255, %eax
; CHECK-NEXT:  LBB0_13: ## %bb45
; CHECK-NEXT:    ## Parent Loop BB0_8 Depth=1
; CHECK-NEXT:    ## => This Loop Header: Depth=2
; CHECK-NEXT:    ## Child Loop BB0_16 Depth 3
; CHECK-NEXT:    movb $1, %cl
; CHECK-NEXT:    testb %cl, %cl
; CHECK-NEXT:    jne LBB0_19
; CHECK-NEXT:  ## %bb.14: ## %bb48
; CHECK-NEXT:    ## in Loop: Header=BB0_13 Depth=2
; CHECK-NEXT:    jne LBB0_17
; CHECK-NEXT:  ## %bb.15: ## %bb49.preheader
; CHECK-NEXT:    ## in Loop: Header=BB0_13 Depth=2
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    movl %esi, %edx
; CHECK-NEXT:    movl %edi, %ebx
; CHECK-NEXT:  LBB0_16: ## %bb49
; CHECK-NEXT:    ## Parent Loop BB0_8 Depth=1
; CHECK-NEXT:    ## Parent Loop BB0_13 Depth=2
; CHECK-NEXT:    ## => This Inner Loop Header: Depth=3
; CHECK-NEXT:    incl %ecx
; CHECK-NEXT:    addl $4, %edx
; CHECK-NEXT:    decl %ebx
; CHECK-NEXT:    jne LBB0_16
; CHECK-NEXT:  LBB0_17: ## %bb57
; CHECK-NEXT:    ## in Loop: Header=BB0_13 Depth=2
; CHECK-NEXT:    decl %eax
; CHECK-NEXT:    jmp LBB0_13
; CHECK-NEXT:  LBB0_19: ## %bb59
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:    movl $-4, %eax
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl $0, (%esp)
; CHECK-NEXT:    calll ___bzero
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne LBB0_22
; CHECK-NEXT:  ## %bb.20: ## %bb61.preheader
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    movl %edi, %ecx
; CHECK-NEXT:  LBB0_21: ## %bb61
; CHECK-NEXT:    ## Parent Loop BB0_8 Depth=1
; CHECK-NEXT:    ## => This Inner Loop Header: Depth=2
; CHECK-NEXT:    movl $0, (%eax)
; CHECK-NEXT:    addl $4, %eax
; CHECK-NEXT:    decl %ecx
; CHECK-NEXT:    jne LBB0_21
; CHECK-NEXT:  LBB0_22: ## %bb67
; CHECK-NEXT:    ## in Loop: Header=BB0_8 Depth=1
; CHECK-NEXT:    decl {{[-0-9]+}}(%e{{[sb]}}p) ## 4-byte Folded Spill
; CHECK-NEXT:    jmp LBB0_8
; CHECK-NEXT:  LBB0_18: ## %bb43
; CHECK-NEXT:  Ltmp5:
; CHECK-NEXT:    movl %esi, %ebx
; CHECK-NEXT:    calll _OnOverFlow
; CHECK-NEXT:  Ltmp6:
; CHECK-NEXT:    jmp LBB0_3
; CHECK-NEXT:  LBB0_2: ## %bb29
; CHECK-NEXT:  Ltmp7:
; CHECK-NEXT:    movl %esi, %ebx
; CHECK-NEXT:    calll _OnOverFlow
; CHECK-NEXT:  Ltmp8:
; CHECK-NEXT:  LBB0_3: ## %bb30
; CHECK-NEXT:    ud2
; CHECK-NEXT:  LBB0_4: ## %bb20.loopexit
; CHECK-NEXT:  Ltmp4:
; CHECK-NEXT:  LBB0_9:
; CHECK-NEXT:    movl %esi, %ebx
; CHECK-NEXT:  LBB0_6: ## %bb23
; CHECK-NEXT:    testl %ebx, %ebx
; CHECK-NEXT:    addl $28, %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    popl %edi
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    popl %ebp
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB0_5: ## %bb20.loopexit.split-lp
; CHECK-NEXT:  Ltmp9:
; CHECK-NEXT:    jmp LBB0_6
; CHECK-NEXT:  Lfunc_end0:
bb:
  br i1 undef, label %bb6, label %bb7

bb6:                                              ; preds = %bb
  %tmp = select i1 false, i32 0, i32 undef
  br label %bb7

bb7:                                              ; preds = %bb6, %bb
  %tmp8 = phi i32 [ %tmp, %bb6 ], [ 0, %bb ]
  %tmp9 = shl i32 %tmp8, 2
  %tmp10 = invoke noalias ptr @_Znam(i32 undef) optsize
          to label %bb11 unwind label %bb20

bb11:                                             ; preds = %bb7
  %tmp12 = ptrtoint ptr %tmp10 to i32
  %tmp14 = shl i32 %tmp8, 2
  %tmp15 = getelementptr i32, ptr %tmp10, i32 undef
  %tmp16 = getelementptr i32, ptr %tmp10, i32 undef
  %tmp17 = zext i32 %tmp9 to i64
  %tmp18 = add i64 %tmp17, -1
  %tmp19 = icmp ugt i64 %tmp18, 4294967295
  br i1 %tmp19, label %bb29, label %bb31

bb20:                                             ; preds = %bb43, %bb41, %bb29, %bb7
  %tmp21 = phi i32 [ undef, %bb7 ], [ %tmp12, %bb43 ], [ %tmp12, %bb29 ], [ %tmp12, %bb41 ]
  %tmp22 = landingpad { ptr, i32 }
          catch ptr @Exception
  br i1 undef, label %bb23, label %bb69

bb23:                                             ; preds = %bb38, %bb20
  %tmp24 = phi i32 [ %tmp12, %bb38 ], [ %tmp21, %bb20 ]
  %tmp25 = icmp eq i32 %tmp24, 0
  br i1 %tmp25, label %bb28, label %bb26

bb26:                                             ; preds = %bb23
  %tmp27 = inttoptr i32 %tmp24 to ptr
  br label %bb28

bb28:                                             ; preds = %bb26, %bb23
  ret void

bb29:                                             ; preds = %bb11
  invoke void @OnOverFlow() optsize
          to label %bb30 unwind label %bb20

bb30:                                             ; preds = %bb29
  unreachable

bb31:                                             ; preds = %bb11
  %tmp33 = zext i32 %tmp8 to i64
  %tmp34 = add i64 %tmp33, -1
  %tmp35 = icmp ugt i64 %tmp34, 4294967295
  %tmp36 = icmp sgt i32 %tmp8, 0
  %tmp37 = add i32 %tmp9, -4
  br label %bb38

bb38:                                             ; preds = %bb67, %bb31
  %tmp39 = phi i32 [ %tmp68, %bb67 ], [ undef, %bb31 ]
  %tmp40 = icmp sgt i32 %tmp39, undef
  br i1 %tmp40, label %bb41, label %bb23

bb41:                                             ; preds = %bb38
  invoke void @Pjii(ptr %tmp16, i32 0, i32 %tmp8) optsize
          to label %bb42 unwind label %bb20

bb42:                                             ; preds = %bb41
  tail call void @llvm.memset.p0.i32(ptr %tmp15, i8 0, i32 %tmp9, i1 false) nounwind
  br i1 %tmp35, label %bb43, label %bb45

bb43:                                             ; preds = %bb42
  invoke void @OnOverFlow() optsize
          to label %bb44 unwind label %bb20

bb44:                                             ; preds = %bb43
  unreachable

bb45:                                             ; preds = %bb57, %bb42
  %tmp46 = phi i32 [ %tmp58, %bb57 ], [ 255, %bb42 ]
  %tmp47 = icmp slt i32 undef, 0
  br i1 %tmp47, label %bb48, label %bb59

bb48:                                             ; preds = %bb45
  tail call void @llvm.memset.p0.i32(ptr %tmp15, i8 0, i32 %tmp9, i1 false) nounwind
  br i1 %tmp36, label %bb49, label %bb57

bb49:                                             ; preds = %bb49, %bb48
  %tmp50 = phi i32 [ %tmp55, %bb49 ], [ 0, %bb48 ]
  %tmp51 = add i32 %tmp50, undef
  %tmp52 = add i32 %tmp50, undef
  %tmp53 = getelementptr i32, ptr %tmp10, i32 %tmp52
  %tmp54 = load i32, ptr %tmp53, align 4
  %tmp55 = add i32 %tmp50, 1
  %tmp56 = icmp eq i32 %tmp55, %tmp8
  br i1 %tmp56, label %bb57, label %bb49

bb57:                                             ; preds = %bb49, %bb48
  %tmp58 = add i32 %tmp46, -1
  br label %bb45

bb59:                                             ; preds = %bb45
  %tmp60 = ashr i32 %tmp46, 31
  tail call void @llvm.memset.p0.i32(ptr null, i8 0, i32 %tmp37, i1 false) nounwind
  br i1 %tmp36, label %bb61, label %bb67

bb61:                                             ; preds = %bb61, %bb59
  %tmp62 = phi i32 [ %tmp65, %bb61 ], [ 0, %bb59 ]
  %tmp63 = add i32 %tmp62, %tmp14
  %tmp64 = getelementptr i32, ptr %tmp10, i32 %tmp63
  store i32 0, ptr %tmp64, align 4
  %tmp65 = add i32 %tmp62, 1
  %tmp66 = icmp eq i32 %tmp65, %tmp8
  br i1 %tmp66, label %bb67, label %bb61

bb67:                                             ; preds = %bb61, %bb59
  %tmp68 = add i32 %tmp39, -1
  br label %bb38

bb69:                                             ; preds = %bb20
  resume { ptr, i32 } %tmp22
}

declare i32 @__gxx_personality_v0(...)

declare noalias ptr @_Znam(i32) optsize

declare void @Pjii(ptr, i32, i32) optsize

declare i32 @llvm.eh.typeid.for(ptr) nounwind readnone

declare void @OnOverFlow() noreturn optsize ssp align 2
