; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+zfh,+zvfhmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+zfh,+zvfhmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN

declare <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @fcmp_oeq_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v9, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oeq_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oeq_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v8, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v8, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v9, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v9, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v9, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v10, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v9, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v9, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v9, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v9, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v10, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vv v8, v8, v9, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v9, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v8, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v8, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v9, v10, v0.t
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v9, v8, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v8, v9, v0.t
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vv_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v9, v9, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vv_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vf_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v9, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v9, v9, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vf_swap_nxv1f16(<vscale x 1 x half> %va, half %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_swap_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; ZVFH-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v9, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_swap_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v9, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v9, v9, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v9, v9, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 1 x half> %elt.head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f16(<vscale x 1 x half> %vb, <vscale x 1 x half> %va, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 3 x i1> @llvm.vp.fcmp.nxv3f16(<vscale x 3 x half>, <vscale x 3 x half>, metadata, <vscale x 3 x i1>, i32)

define <vscale x 3 x i1> @fcmp_oeq_vv_nxv3f16(<vscale x 3 x half> %va, <vscale x 3 x half> %vb, <vscale x 3 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_nxv3f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv3f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 3 x i1> @llvm.vp.fcmp.nxv3f16(<vscale x 3 x half> %va, <vscale x 3 x half> %vb, metadata !"oeq", <vscale x 3 x i1> %m, i32 %evl)
  ret <vscale x 3 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oeq_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v10, v8, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v10, v8, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmflt.vv v13, v10, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v13, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v12, v10, v10, v0.t
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v10, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v12, v10, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v12, v10, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v12, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmflt.vv v13, v10, v8, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v13, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v10, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v10, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v12, v8, v10, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v16, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v10, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v16, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v12, v10, v10, v0.t
; ZVFH-NEXT:    vmfne.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v10, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v12, v10, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vf_swap_nxv8f16(<vscale x 8 x half> %va, half %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_swap_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v12, v10, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v10, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v12, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_swap_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v10, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12, v0.t
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v12, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %vb = shufflevector <vscale x 8 x half> %elt.head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f16(<vscale x 8 x half> %vb, <vscale x 8 x half> %va, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 64 x i1> @llvm.vp.fcmp.nxv64f16(<vscale x 64 x half>, <vscale x 64 x half>, metadata, <vscale x 64 x i1>, i32)

define <vscale x 64 x i1> @fcmp_oeq_vv_nxv64f16(<vscale x 64 x half> %va, <vscale x 64 x half> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_nxv64f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    addi sp, sp, -16
; ZVFH-NEXT:    .cfi_def_cfa_offset 16
; ZVFH-NEXT:    csrr a1, vlenb
; ZVFH-NEXT:    slli a1, a1, 4
; ZVFH-NEXT:    sub sp, sp, a1
; ZVFH-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; ZVFH-NEXT:    vmv1r.v v24, v0
; ZVFH-NEXT:    csrr a1, vlenb
; ZVFH-NEXT:    slli a1, a1, 3
; ZVFH-NEXT:    add a1, sp, a1
; ZVFH-NEXT:    addi a1, a1, 16
; ZVFH-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; ZVFH-NEXT:    csrr a3, vlenb
; ZVFH-NEXT:    srli a1, a3, 1
; ZVFH-NEXT:    slli a4, a3, 3
; ZVFH-NEXT:    add a4, a0, a4
; ZVFH-NEXT:    vl8re16.v v8, (a4)
; ZVFH-NEXT:    slli a3, a3, 2
; ZVFH-NEXT:    sub a4, a2, a3
; ZVFH-NEXT:    sltu a5, a2, a4
; ZVFH-NEXT:    addi a5, a5, -1
; ZVFH-NEXT:    vl8re16.v v0, (a0)
; ZVFH-NEXT:    addi a0, sp, 16
; ZVFH-NEXT:    vs8r.v v0, (a0) # Unknown-size Folded Spill
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vslidedown.vx v0, v24, a1
; ZVFH-NEXT:    and a4, a5, a4
; ZVFH-NEXT:    vsetvli zero, a4, e16, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v7, v16, v8, v0.t
; ZVFH-NEXT:    bltu a2, a3, .LBB85_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    mv a2, a3
; ZVFH-NEXT:  .LBB85_2:
; ZVFH-NEXT:    vmv1r.v v0, v24
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 3
; ZVFH-NEXT:    add a0, sp, a0
; ZVFH-NEXT:    addi a0, a0, 16
; ZVFH-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; ZVFH-NEXT:    addi a0, sp, 16
; ZVFH-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; ZVFH-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v16, v8, v24, v0.t
; ZVFH-NEXT:    add a0, a1, a1
; ZVFH-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; ZVFH-NEXT:    vslideup.vx v16, v7, a1
; ZVFH-NEXT:    vmv.v.v v0, v16
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add sp, sp, a0
; ZVFH-NEXT:    addi sp, sp, 16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv64f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    addi sp, sp, -16
; ZVFHMIN-NEXT:    .cfi_def_cfa_offset 16
; ZVFHMIN-NEXT:    csrr a1, vlenb
; ZVFHMIN-NEXT:    li a3, 34
; ZVFHMIN-NEXT:    mul a1, a1, a3
; ZVFHMIN-NEXT:    sub sp, sp, a1
; ZVFHMIN-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x22, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 34 * vlenb
; ZVFHMIN-NEXT:    vmv8r.v v24, v16
; ZVFHMIN-NEXT:    csrr a1, vlenb
; ZVFHMIN-NEXT:    li a3, 18
; ZVFHMIN-NEXT:    mul a1, a1, a3
; ZVFHMIN-NEXT:    add a1, sp, a1
; ZVFHMIN-NEXT:    addi a1, a1, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    csrr a3, vlenb
; ZVFHMIN-NEXT:    slli a1, a3, 3
; ZVFHMIN-NEXT:    add a1, a0, a1
; ZVFHMIN-NEXT:    vl8re16.v v16, (a1)
; ZVFHMIN-NEXT:    slli a5, a3, 2
; ZVFHMIN-NEXT:    sub a1, a2, a5
; ZVFHMIN-NEXT:    sltu a4, a2, a1
; ZVFHMIN-NEXT:    addi a4, a4, -1
; ZVFHMIN-NEXT:    and a6, a4, a1
; ZVFHMIN-NEXT:    slli a4, a3, 1
; ZVFHMIN-NEXT:    sub a1, a6, a4
; ZVFHMIN-NEXT:    sltu a7, a6, a1
; ZVFHMIN-NEXT:    addi a7, a7, -1
; ZVFHMIN-NEXT:    and a7, a7, a1
; ZVFHMIN-NEXT:    srli a1, a3, 1
; ZVFHMIN-NEXT:    csrr t0, vlenb
; ZVFHMIN-NEXT:    add t0, sp, t0
; ZVFHMIN-NEXT:    addi t0, t0, 16
; ZVFHMIN-NEXT:    vs1r.v v0, (t0) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vsetvli t0, zero, e8, m1, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v8, v0, a1
; ZVFHMIN-NEXT:    srli a3, a3, 2
; ZVFHMIN-NEXT:    addi t0, sp, 16
; ZVFHMIN-NEXT:    vs1r.v v8, (t0) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vsetvli t0, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v0, v8, a3
; ZVFHMIN-NEXT:    vl8re16.v v8, (a0)
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li t0, 26
; ZVFHMIN-NEXT:    mul a0, a0, t0
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 1
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v20
; ZVFHMIN-NEXT:    vmv4r.v v16, v24
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li t0, 10
; ZVFHMIN-NEXT:    mul a0, a0, t0
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v28
; ZVFHMIN-NEXT:    vsetvli zero, a7, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v26, v16, v8, v0.t
; ZVFHMIN-NEXT:    bltu a6, a4, .LBB85_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    mv a6, a4
; ZVFHMIN-NEXT:  .LBB85_2:
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    slli a0, a0, 1
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v16
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a7, 10
; ZVFHMIN-NEXT:    mul a0, a0, a7
; ZVFHMIN-NEXT:    add a0, sp, a0
; ZVFHMIN-NEXT:    addi a0, a0, 16
; ZVFHMIN-NEXT:    vl8r.v v0, (a0) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v0
; ZVFHMIN-NEXT:    addi a0, sp, 16
; ZVFHMIN-NEXT:    vl1r.v v0, (a0) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, a6, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v6, v16, v8, v0.t
; ZVFHMIN-NEXT:    add a0, a3, a3
; ZVFHMIN-NEXT:    bltu a2, a5, .LBB85_4
; ZVFHMIN-NEXT:  # %bb.3:
; ZVFHMIN-NEXT:    mv a2, a5
; ZVFHMIN-NEXT:  .LBB85_4:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslideup.vx v6, v26, a3
; ZVFHMIN-NEXT:    sub a5, a2, a4
; ZVFHMIN-NEXT:    sltu a6, a2, a5
; ZVFHMIN-NEXT:    addi a6, a6, -1
; ZVFHMIN-NEXT:    and a5, a6, a5
; ZVFHMIN-NEXT:    csrr a6, vlenb
; ZVFHMIN-NEXT:    add a6, sp, a6
; ZVFHMIN-NEXT:    addi a6, a6, 16
; ZVFHMIN-NEXT:    vl1r.v v8, (a6) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vmv1r.v v7, v8
; ZVFHMIN-NEXT:    vsetvli a6, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v0, v8, a3
; ZVFHMIN-NEXT:    csrr a6, vlenb
; ZVFHMIN-NEXT:    li a7, 18
; ZVFHMIN-NEXT:    mul a6, a6, a7
; ZVFHMIN-NEXT:    add a6, sp, a6
; ZVFHMIN-NEXT:    addi a6, a6, 16
; ZVFHMIN-NEXT:    vl8r.v v24, (a6) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vsetvli a6, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v28
; ZVFHMIN-NEXT:    csrr a6, vlenb
; ZVFHMIN-NEXT:    li a7, 10
; ZVFHMIN-NEXT:    mul a6, a6, a7
; ZVFHMIN-NEXT:    add a6, sp, a6
; ZVFHMIN-NEXT:    addi a6, a6, 16
; ZVFHMIN-NEXT:    vs8r.v v8, (a6) # Unknown-size Folded Spill
; ZVFHMIN-NEXT:    csrr a6, vlenb
; ZVFHMIN-NEXT:    li a7, 26
; ZVFHMIN-NEXT:    mul a6, a6, a7
; ZVFHMIN-NEXT:    add a6, sp, a6
; ZVFHMIN-NEXT:    addi a6, a6, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a6) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v8, v20
; ZVFHMIN-NEXT:    csrr a6, vlenb
; ZVFHMIN-NEXT:    li a7, 10
; ZVFHMIN-NEXT:    mul a6, a6, a7
; ZVFHMIN-NEXT:    add a6, sp, a6
; ZVFHMIN-NEXT:    addi a6, a6, 16
; ZVFHMIN-NEXT:    vl8r.v v16, (a6) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vsetvli zero, a5, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v5, v16, v8, v0.t
; ZVFHMIN-NEXT:    bltu a2, a4, .LBB85_6
; ZVFHMIN-NEXT:  # %bb.5:
; ZVFHMIN-NEXT:    mv a2, a4
; ZVFHMIN-NEXT:  .LBB85_6:
; ZVFHMIN-NEXT:    vsetvli a4, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v24
; ZVFHMIN-NEXT:    csrr a4, vlenb
; ZVFHMIN-NEXT:    li a5, 26
; ZVFHMIN-NEXT:    mul a4, a4, a5
; ZVFHMIN-NEXT:    add a4, sp, a4
; ZVFHMIN-NEXT:    addi a4, a4, 16
; ZVFHMIN-NEXT:    vl8r.v v8, (a4) # Unknown-size Folded Reload
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v8
; ZVFHMIN-NEXT:    vmv1r.v v0, v7
; ZVFHMIN-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v16, v24, v0.t
; ZVFHMIN-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslideup.vx v8, v5, a3
; ZVFHMIN-NEXT:    add a0, a1, a1
; ZVFHMIN-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; ZVFHMIN-NEXT:    vslideup.vx v8, v6, a1
; ZVFHMIN-NEXT:    vmv.v.v v0, v8
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    li a1, 34
; ZVFHMIN-NEXT:    mul a0, a0, a1
; ZVFHMIN-NEXT:    add sp, sp, a0
; ZVFHMIN-NEXT:    addi sp, sp, 16
; ZVFHMIN-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.fcmp.nxv64f16(<vscale x 64 x half> %va, <vscale x 64 x half> %vb, metadata !"oeq", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

declare <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @fcmp_oeq_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oeq_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oeq_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"oeq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ogt_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ogt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_oge_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"oge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_olt_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"olt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ole_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ole", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_one_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"one", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ord_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ord", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ueq_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ueq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ugt_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uge_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ult_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_ule_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_une_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"une", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9, v0.t
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vf_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 1 x i1> @fcmp_uno_vf_swap_nxv1f64(<vscale x 1 x double> %va, double %b, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_swap_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v8, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 1 x double> %elt.head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i1> @llvm.vp.fcmp.nxv1f64(<vscale x 1 x double> %vb, <vscale x 1 x double> %va, metadata !"uno", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 3 x i1> @llvm.vp.fcmp.nxv3f64(<vscale x 3 x double>, <vscale x 3 x double>, metadata, <vscale x 3 x i1>, i32)

define <vscale x 3 x i1> @fcmp_oeq_vv_nxv3f64(<vscale x 3 x double> %va, <vscale x 3 x double> %vb, <vscale x 3 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_nxv3f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <vscale x 3 x i1> @llvm.vp.fcmp.nxv3f64(<vscale x 3 x double> %va, <vscale x 3 x double> %vb, metadata !"oeq", <vscale x 3 x i1> %m, i32 %evl)
  ret <vscale x 3 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oeq_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"oeq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ogt_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ogt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_oge_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"oge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_olt_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"olt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ole_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ole", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmflt.vv v25, v16, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_one_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v17, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"one", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v24, v16, v16, v0.t
; CHECK-NEXT:    vmfeq.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v24, v16, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ord_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v24, v16, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v24, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ord", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmflt.vv v25, v16, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ueq_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v17, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ueq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ugt_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uge_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ult_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_ule_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v24, v8, v16, v0.t
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_une_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v16, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"une", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v24, v16, v16, v0.t
; CHECK-NEXT:    vmfne.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v24, v16, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 8 x i1> @fcmp_uno_vf_swap_nxv8f64(<vscale x 8 x double> %va, double %b, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_swap_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v24, v16, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v16, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v24, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %vb = shufflevector <vscale x 8 x double> %elt.head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i1> @llvm.vp.fcmp.nxv8f64(<vscale x 8 x double> %vb, <vscale x 8 x double> %va, metadata !"uno", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 32 x i1> @llvm.vp.fcmp.nxv32f64(<vscale x 32 x double>, <vscale x 32 x double>, metadata, <vscale x 32 x i1>, i32)

define <vscale x 32 x i1> @fcmp_oeq_vv_nxv32f64(<vscale x 32 x double> %va, <vscale x 32 x double> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_nxv32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    li a3, 48
; CHECK-NEXT:    mul a1, a1, a3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x30, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 48 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 5
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    li a3, 40
; CHECK-NEXT:    mul a1, a1, a3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a4, vlenb
; CHECK-NEXT:    slli t0, a4, 3
; CHECK-NEXT:    slli a1, a4, 5
; CHECK-NEXT:    sub t1, a1, t0
; CHECK-NEXT:    srli a1, a4, 2
; CHECK-NEXT:    vsetvli a3, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v7, v0, a1
; CHECK-NEXT:    srli a3, a4, 3
; CHECK-NEXT:    add a5, a2, t0
; CHECK-NEXT:    vl8re64.v v8, (a5)
; CHECK-NEXT:    slli t3, a4, 4
; CHECK-NEXT:    slli a5, a4, 1
; CHECK-NEXT:    vsetvli a7, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a3
; CHECK-NEXT:    mv a7, a6
; CHECK-NEXT:    bltu a6, a5, .LBB171_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a7, a5
; CHECK-NEXT:  .LBB171_2:
; CHECK-NEXT:    add t2, a0, t0
; CHECK-NEXT:    add t1, a2, t1
; CHECK-NEXT:    add t0, a2, t3
; CHECK-NEXT:    vl8re64.v v16, (a2)
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 4
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vs8r.v v16, (a2) # Unknown-size Folded Spill
; CHECK-NEXT:    sub a2, a7, a4
; CHECK-NEXT:    sltu t3, a7, a2
; CHECK-NEXT:    addi t3, t3, -1
; CHECK-NEXT:    and a2, t3, a2
; CHECK-NEXT:    csrr t3, vlenb
; CHECK-NEXT:    slli t3, t3, 5
; CHECK-NEXT:    add t3, sp, t3
; CHECK-NEXT:    addi t3, t3, 16
; CHECK-NEXT:    vl8r.v v16, (t3) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v6, v16, v8, v0.t
; CHECK-NEXT:    bltu a7, a4, .LBB171_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    mv a7, a4
; CHECK-NEXT:  .LBB171_4:
; CHECK-NEXT:    vl8re64.v v8, (t2)
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 5
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; CHECK-NEXT:    vl8re64.v v8, (t1)
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    li t1, 24
; CHECK-NEXT:    mul a2, a2, t1
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; CHECK-NEXT:    vsetvli a2, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v18, v7, a3
; CHECK-NEXT:    vl8re64.v v8, (t0)
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 3
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; CHECK-NEXT:    vl8re64.v v8, (a0)
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    li a2, 40
; CHECK-NEXT:    mul a0, a0, a2
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a7, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v17, v24, v8, v0.t
; CHECK-NEXT:    add a2, a3, a3
; CHECK-NEXT:    sub a0, a6, a5
; CHECK-NEXT:    sltu a5, a6, a0
; CHECK-NEXT:    addi a5, a5, -1
; CHECK-NEXT:    and a0, a5, a0
; CHECK-NEXT:    vsetvli zero, a2, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v17, v6, a3
; CHECK-NEXT:    mv a2, a0
; CHECK-NEXT:    bltu a0, a4, .LBB171_6
; CHECK-NEXT:  # %bb.5:
; CHECK-NEXT:    mv a2, a4
; CHECK-NEXT:  .LBB171_6:
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    csrr a5, vlenb
; CHECK-NEXT:    slli a5, a5, 3
; CHECK-NEXT:    add a5, sp, a5
; CHECK-NEXT:    addi a5, a5, 16
; CHECK-NEXT:    vl8r.v v8, (a5) # Unknown-size Folded Reload
; CHECK-NEXT:    addi a5, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v24, v8, v0.t
; CHECK-NEXT:    sub a2, a0, a4
; CHECK-NEXT:    sltu a0, a0, a2
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    and a0, a0, a2
; CHECK-NEXT:    vmv1r.v v0, v18
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 5
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vl8r.v v24, (a2) # Unknown-size Folded Reload
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    li a4, 24
; CHECK-NEXT:    mul a2, a2, a4
; CHECK-NEXT:    add a2, sp, a2
; CHECK-NEXT:    addi a2, a2, 16
; CHECK-NEXT:    vl8r.v v8, (a2) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v18, v24, v8, v0.t
; CHECK-NEXT:    add a0, a1, a3
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    vslideup.vx v17, v16, a1
; CHECK-NEXT:    slli a0, a3, 1
; CHECK-NEXT:    add a0, a0, a3
; CHECK-NEXT:    add a3, a0, a3
; CHECK-NEXT:    vsetvli zero, a3, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v17, v18, a0
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    li a1, 48
; CHECK-NEXT:    mul a0, a0, a1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.fcmp.nxv32f64(<vscale x 32 x double> %va, <vscale x 32 x double> %vb, metadata !"oeq", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}
