/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.BooleanLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.CommaDelimitedStringListLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.DNLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.FilterLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.FloatingPointLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.IntegerLogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.StringLogFieldSyntax;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedAccessLogFields {
    private static final int DEFAULT_MAX_CHARACTERS_PER_STRING = 2000;
    @NotNull
    private static final Map<String, LogField> DEFINED_FIELDS = new ConcurrentHashMap<String, LogField>();
    @NotNull
    private static final AtomicReference<Map<String, LogField>> READ_ONLY_DEFINED_FIELDS_REF = new AtomicReference();
    @NotNull
    private static final BooleanLogFieldSyntax BOOLEAN_SYNTAX = BooleanLogFieldSyntax.getInstance();
    @NotNull
    private static final CommaDelimitedStringListLogFieldSyntax COMMA_DELIMITED_STRING_LIST_SYNTAX = new CommaDelimitedStringListLogFieldSyntax(2000);
    @NotNull
    private static final DNLogFieldSyntax DN_SYNTAX = new DNLogFieldSyntax(2000, null, null, null);
    @NotNull
    private static final FilterLogFieldSyntax FILTER_SYNTAX = new FilterLogFieldSyntax(2000, null, null, null);
    @NotNull
    private static final FloatingPointLogFieldSyntax FLOATING_POINT_SYNTAX = FloatingPointLogFieldSyntax.getInstance();
    @NotNull
    private static final IntegerLogFieldSyntax INTEGER_SYNTAX = IntegerLogFieldSyntax.getInstance();
    @NotNull
    private static final StringLogFieldSyntax STRING_SYNTAX = new StringLogFieldSyntax(2000);
    @NotNull
    public static final LogField ABANDON_MESSAGE_ID = TextFormattedAccessLogFields.createField("ABANDON_MESSAGE_ID", "idToAbandon", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ADD_ATTRIBUTES = TextFormattedAccessLogFields.createField("ADD_ATTRIBUTES", "attrs", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField ADD_ENTRY_DN = TextFormattedAccessLogFields.createField("ADD_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField ADD_UNDELETE_FROM_DN = TextFormattedAccessLogFields.createField("ADD_UNDELETE_FROM_DN", "undeleteFromDN", DN_SYNTAX);
    @NotNull
    public static final LogField ADDITIONAL_INFO = TextFormattedAccessLogFields.createField("ADDITIONAL_INFO", "additionalInfo", STRING_SYNTAX);
    @NotNull
    public static final LogField ADMINISTRATIVE_OPERATION = TextFormattedAccessLogFields.createField("ADMINISTRATIVE_OPERATION", "administrativeOperation", STRING_SYNTAX);
    @NotNull
    public static final LogField ASSURANCE_TIMEOUT_MILLIS = TextFormattedAccessLogFields.createField("ASSURANCE_TIMEOUT_MILLIS", "assuranceTimeoutMillis", INTEGER_SYNTAX);
    @NotNull
    public static final LogField AUTHORIZATION_DN = TextFormattedAccessLogFields.createField("AUTHORIZATION_DN", "authzDN", DN_SYNTAX);
    @NotNull
    public static final LogField AUTO_AUTHENTICATED_AS = TextFormattedAccessLogFields.createField("AUTO_AUTHENTICATED_AS", "autoAuthenticatedAs", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_DN = TextFormattedAccessLogFields.createField("BIND_AUTHENTICATION_DN", "authDN", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_ID = TextFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_ID", "authFailureID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_NAME = TextFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_NAME", "authFailureName", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_FAILURE_REASON = TextFormattedAccessLogFields.createField("BIND_AUTHENTICATION_FAILURE_REASON", "authFailureReason", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHENTICATION_TYPE = TextFormattedAccessLogFields.createField("BIND_AUTHENTICATION_TYPE", "authType", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_AUTHORIZATION_DN = TextFormattedAccessLogFields.createField("BIND_AUTHORIZATION_DN", "authzDN", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_DN = TextFormattedAccessLogFields.createField("BIND_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField BIND_PROTOCOL_VERSION = TextFormattedAccessLogFields.createField("BIND_PROTOCOL_VERSION", "version", STRING_SYNTAX);
    @NotNull
    public static final LogField BIND_RETIRED_PASSWORD_USED = TextFormattedAccessLogFields.createField("BIND_RETIRED_PASSWORD_USED", "retiredPasswordUsed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField BIND_SASL_MECHANISM = TextFormattedAccessLogFields.createField("BIND_SASL_MECHANISM", "saslMechanism", STRING_SYNTAX);
    @NotNull
    public static final LogField CHANGE_TO_SOFT_DELETED_ENTRY = TextFormattedAccessLogFields.createField("CHANGE_TO_SOFT_DELETED_ENTRY", "changeToSoftDeletedEntry", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField CIPHER = TextFormattedAccessLogFields.createField("CIPHER", "cipher", STRING_SYNTAX);
    @NotNull
    public static final LogField CLIENT_CONNECTION_POLICY = TextFormattedAccessLogFields.createField("CLIENT_CONNECTION_POLICY", "clientConnectionPolicy", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ASSERTION_VALUE = TextFormattedAccessLogFields.createField("COMPARE_ASSERTION_VALUE", "assertionValue", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ATTRIBUTE_NAME = TextFormattedAccessLogFields.createField("COMPARE_ATTRIBUTE_NAME", "attr", STRING_SYNTAX);
    @NotNull
    public static final LogField COMPARE_ENTRY_DN = TextFormattedAccessLogFields.createField("COMPARE_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField CONNECT_FROM_ADDRESS = TextFormattedAccessLogFields.createField("CONNECT_FROM_ADDRESS", "from", STRING_SYNTAX);
    @NotNull
    public static final LogField CONNECT_FROM_PORT = TextFormattedAccessLogFields.createField("CONNECT_FROM_PORT", "fromPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField CONNECT_TO_ADDRESS = TextFormattedAccessLogFields.createField("CONNECT_TO_ADDRESS", "to", STRING_SYNTAX);
    @NotNull
    public static final LogField CONNECT_TO_PORT = TextFormattedAccessLogFields.createField("CONNECT_TO_PORT", "toPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField CONNECTION_ID = TextFormattedAccessLogFields.createField("CONNECTION_ID", "conn", INTEGER_SYNTAX);
    @NotNull
    public static final LogField DELETE_ENTRY_DN = TextFormattedAccessLogFields.createField("DELETE_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField DELETE_SOFT_DELETED_ENTRY_DN = TextFormattedAccessLogFields.createField("DELETE_SOFT_DELETED_ENTRY_DN", "softDeleteEntryDN", DN_SYNTAX);
    @NotNull
    public static final LogField DIAGNOSTIC_MESSAGE = TextFormattedAccessLogFields.createField("DIAGNOSTIC_MESSAGE", "message", STRING_SYNTAX);
    @NotNull
    public static final LogField DISCONNECT_MESSAGE = TextFormattedAccessLogFields.createField("DISCONNECT_MESSAGE", "msg", STRING_SYNTAX);
    @NotNull
    public static final LogField DISCONNECT_REASON = TextFormattedAccessLogFields.createField("DISCONNECT_REASON", "reason", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ADMIN_ACTION_MESSAGE = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_ADMIN_ACTION_MESSAGE", "adminActionRequired", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_BASE_DN = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_BASE_DN", "baseDN", DN_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_ADDED_TO_TARGET = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_ADDED_TO_TARGET", "entriesAddedToTarget", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_DELETED_FROM_SOURCE = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_DELETED_FROM_SOURCE", "entriesDeletedFromSource", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ENTRIES_READ_FROM_SOURCE = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_ENTRIES_READ_FROM_SOURCE", "entriesReadFromSource", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_ERROR_MESSAGE = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_ERROR_MESSAGE", "errorMessage", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_OPERATION_ID = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_OPERATION_ID", "rebalancingOp", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SIZE_LIMIT = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_SIZE_LIMIT", "sizeLimit", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_BACKEND_SET = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_BACKEND_SET", "sourceBackendSet", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER", "sourceServer", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_SOURCE_SERVER_ALTERED = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_SOURCE_SERVER_ALTERED", "sourceAltered", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_BACKEND_SET = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_BACKEND_SET", "targetBackendSet", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER", "targetServer", STRING_SYNTAX);
    @NotNull
    public static final LogField ENTRY_REBALANCING_TARGET_SERVER_ALTERED = TextFormattedAccessLogFields.createField("ENTRY_REBALANCING_TARGET_SERVER_ALTERED", "targetAltered", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_REQUEST_OID = TextFormattedAccessLogFields.createField("EXTENDED_REQUEST_OID", "requestOID", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_REQUEST_TYPE = TextFormattedAccessLogFields.createField("EXTENDED_REQUEST_TYPE", "requestType", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_RESPONSE_OID = TextFormattedAccessLogFields.createField("EXTENDED_RESPONSE_OID", "responseOID", STRING_SYNTAX);
    @NotNull
    public static final LogField EXTENDED_RESPONSE_TYPE = TextFormattedAccessLogFields.createField("EXTENDED_RESPONSE_TYPE", "responseType", STRING_SYNTAX);
    @NotNull
    public static final LogField INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT = TextFormattedAccessLogFields.createField("INDEXES_WITH_KEYS_ACCESSED_EXCEEDING_ENTRY_LIMIT", "indexesWithKeysAccessedExceedingEntryLimit", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT = TextFormattedAccessLogFields.createField("INDEXES_WITH_KEYS_ACCESSED_NEAR_ENTRY_LIMIT", "indexesWithKeysAccessedNearEntryLimit", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField INSTANCE_NAME = TextFormattedAccessLogFields.createField("INSTANCE_NAME", "instanceName", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_COMPONENT = TextFormattedAccessLogFields.createField("INTER_SERVER_COMPONENT", "interServerComponent", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_PROPERTIES = TextFormattedAccessLogFields.createField("INTER_SERVER_PROPERTIES", "interServerProperties", STRING_SYNTAX);
    @NotNull
    public static final LogField INTER_SERVER_OPERATION_PURPOSE = TextFormattedAccessLogFields.createField("INTER_SERVER_OPERATION_PURPOSE", "interServerOperationPurpose", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_REQUEST = TextFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_REQUEST", "via", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_CLIENT_RESULT = TextFormattedAccessLogFields.createField("INTERMEDIATE_CLIENT_RESULT", "from", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_NAME = TextFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_NAME", "name", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_OID = TextFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_OID", "oid", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSE_VALUE = TextFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSE_VALUE", "value", STRING_SYNTAX);
    @NotNull
    public static final LogField INTERMEDIATE_RESPONSES_RETURNED = TextFormattedAccessLogFields.createField("INTERMEDIATE_RESPONSES_RETURNED", "intermediateResponsesReturned", INTEGER_SYNTAX);
    @NotNull
    public static final LogField ISSUER_CERTIFICATE_SUBJECT_DN = TextFormattedAccessLogFields.createField("ISSUER_CERTIFICATE_SUBJECT_DN", "issuerSubject", DN_SYNTAX);
    @NotNull
    public static final LogField LOCAL_ASSURANCE_LEVEL = TextFormattedAccessLogFields.createField("LOCAL_ASSURANCE_LEVEL", "localAssuranceLevel", STRING_SYNTAX);
    @NotNull
    public static final LogField LOCAL_ASSURANCE_SATISFIED = TextFormattedAccessLogFields.createField("LOCAL_ASSURANCE_SATISFIED", "localAssuranceSatisfied", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField MATCHED_DN = TextFormattedAccessLogFields.createField("MATCHED_DN", "matchedDN", DN_SYNTAX);
    @NotNull
    public static final LogField MESSAGE_ID = TextFormattedAccessLogFields.createField("MESSAGE_ID", "msgID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField MISSING_PRIVILEGES = TextFormattedAccessLogFields.createField("MISSING_PRIVILEGES", "missingPrivileges", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField MODDN_DELETE_OLD_RDN = TextFormattedAccessLogFields.createField("MODDN_DELETE_OLD_RDN", "deleteOldRDN", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField MODDN_ENTRY_DN = TextFormattedAccessLogFields.createField("MODDN_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField MODDN_NEW_RDN = TextFormattedAccessLogFields.createField("MODDN_NEW_RDN", "newRDN", DN_SYNTAX);
    @NotNull
    public static final LogField MODDN_NEW_SUPERIOR_DN = TextFormattedAccessLogFields.createField("MODDN_NEW_SUPERIOR_DN", "newSuperior", DN_SYNTAX);
    @NotNull
    public static final LogField MODIFY_ATTRIBUTES = TextFormattedAccessLogFields.createField("MODIFY_ATTRIBUTES", "attrs", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField MODIFY_ENTRY_DN = TextFormattedAccessLogFields.createField("MODIFY_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField OPERATION_ID = TextFormattedAccessLogFields.createField("OPERATION_ID", "op", INTEGER_SYNTAX);
    @NotNull
    public static final LogField OPERATION_PURPOSE = TextFormattedAccessLogFields.createField("OPERATION_PURPOSE", "opPurpose", STRING_SYNTAX);
    @NotNull
    public static final LogField ORIGIN = TextFormattedAccessLogFields.createField("ORIGIN", "origin", STRING_SYNTAX);
    @NotNull
    public static final LogField PEER_CERTIFICATE_SUBJECT_DN = TextFormattedAccessLogFields.createField("PEER_CERTIFICATE_SUBJECT_DN", "peerSubject", DN_SYNTAX);
    @NotNull
    public static final LogField PRE_AUTHORIZATION_USED_PRIVILEGES = TextFormattedAccessLogFields.createField("PRE_AUTHORIZATION_USED_PRIVILEGES", "preAuthZUsedPrivileges", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField PROCESSING_TIME_MILLIS = TextFormattedAccessLogFields.createField("PROCESSING_TIME_MILLIS", "etime", FLOATING_POINT_SYNTAX);
    @NotNull
    public static final LogField PRODUCT_NAME = TextFormattedAccessLogFields.createField("PRODUCT_NAME", "product", STRING_SYNTAX);
    @NotNull
    public static final LogField PROTOCOL = TextFormattedAccessLogFields.createField("PROTOCOL", "protocol", STRING_SYNTAX);
    @NotNull
    public static final LogField REFERRAL_URLS = TextFormattedAccessLogFields.createField("REFERRAL_URLS", "referralURLs", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField REMOTE_ASSURANCE_LEVEL = TextFormattedAccessLogFields.createField("REMOTE_ASSURANCE_LEVEL", "remoteAssuranceLevel", STRING_SYNTAX);
    @NotNull
    public static final LogField REMOTE_ASSURANCE_SATISFIED = TextFormattedAccessLogFields.createField("REMOTE_ASSURANCE_SATISFIED", "remoteAssuranceSatisfied", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField REPLICATION_CHANGE_ID = TextFormattedAccessLogFields.createField("REPLICATION_CHANGE_ID", "replicationChangeID", STRING_SYNTAX);
    @NotNull
    public static final LogField REQUEST_CONTROL_OIDS = TextFormattedAccessLogFields.createField("REQUEST_CONTROL_OIDS", "requestControls", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField REQUESTER_DN = TextFormattedAccessLogFields.createField("REQUESTER_DN", "requesterDN", DN_SYNTAX);
    @NotNull
    public static final LogField REQUESTER_IP_ADDRESS = TextFormattedAccessLogFields.createField("REQUESTER_IP_ADDRESS", "requesterIP", STRING_SYNTAX);
    @NotNull
    public static final LogField RESPONSE_CONTROL_OIDS = TextFormattedAccessLogFields.createField("RESPONSE_CONTROL_OIDS", "responseControls", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField RESPONSE_DELAYED_BY_ASSURANCE = TextFormattedAccessLogFields.createField("RESPONSE_DELAYED_BY_ASSURANCE", "responseDelayedByAssurance", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField RESULT_CODE_NAME = TextFormattedAccessLogFields.createField("RESULT_CODE_NAME", "resultCodeName", STRING_SYNTAX);
    @NotNull
    public static final LogField RESULT_CODE_VALUE = TextFormattedAccessLogFields.createField("RESULT_CODE_VALUE", "resultCode", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_BASE_DN = TextFormattedAccessLogFields.createField("SEARCH_BASE_DN", "base", DN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_DEREF_POLICY = TextFormattedAccessLogFields.createField("SEARCH_DEREF_POLICY", "deref", STRING_SYNTAX);
    @NotNull
    public static final LogField SEARCH_ENTRIES_RETURNED = TextFormattedAccessLogFields.createField("SEARCH_ENTRIES_RETURNED", "entriesReturned", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_FILTER = TextFormattedAccessLogFields.createField("SEARCH_FILTER", "filter", FILTER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_REQUESTED_ATTRIBUTES = TextFormattedAccessLogFields.createField("SEARCH_REQUESTED_ATTRIBUTES", "attrs", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField SEARCH_RESULT_ENTRY_DN = TextFormattedAccessLogFields.createField("SEARCH_RESULT_ENTRY_DN", "dn", DN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_RESULT_ENTRY_ATTRIBUTES = TextFormattedAccessLogFields.createField("SEARCH_RESULT_ENTRY_ATTRIBUTES", "attrsReturned", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField SEARCH_SCOPE_VALUE = TextFormattedAccessLogFields.createField("SEARCH_SCOPE_VALUE", "scope", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_SIZE_LIMIT = TextFormattedAccessLogFields.createField("SEARCH_SIZE_LIMIT", "sizeLimit", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_TIME_LIMIT_SECONDS = TextFormattedAccessLogFields.createField("SEARCH_TIME_LIMIT_SECONDS", "timeLimit", INTEGER_SYNTAX);
    @NotNull
    public static final LogField SEARCH_TYPES_ONLY = TextFormattedAccessLogFields.createField("SEARCH_TYPES_ONLY", "typesOnly", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField SEARCH_UNINDEXED = TextFormattedAccessLogFields.createField("SEARCH_UNINDEXED", "unindexed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField SERVER_ASSURANCE_RESULTS = TextFormattedAccessLogFields.createField("SERVER_ASSURANCE_RESULTS", "serverAssuranceResults", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField SERVERS_ACCESSED = TextFormattedAccessLogFields.createField("SERVERS_ACCESSED", "serversAccessed", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField STARTUP_ID = TextFormattedAccessLogFields.createField("STARTUP_ID", "startupID", STRING_SYNTAX);
    @NotNull
    public static final LogField TARGET_HOST = TextFormattedAccessLogFields.createField("TARGET_HOST", "targetHost", STRING_SYNTAX);
    @NotNull
    public static final LogField TARGET_PORT = TextFormattedAccessLogFields.createField("TARGET_PORT", "targetPort", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TARGET_PROTOCOL = TextFormattedAccessLogFields.createField("TARGET_PROTOCOL", "targetProtocol", STRING_SYNTAX);
    @NotNull
    public static final LogField THREAD_ID = TextFormattedAccessLogFields.createField("THREAD_ID", "threadID", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TRIGGERED_BY_CONNECTION_ID = TextFormattedAccessLogFields.createField("TRIGGERED_BY_CONNECTION_ID", "triggeredByConn", INTEGER_SYNTAX);
    @NotNull
    public static final LogField TRIGGERED_BY_OPERATION_ID = TextFormattedAccessLogFields.createField("TRIGGERED_BY_OPERATION_ID", "triggeredByOp", INTEGER_SYNTAX);
    @NotNull
    public static final LogField UNCACHED_DATA_ACCESSED = TextFormattedAccessLogFields.createField("UNCACHED_DATA_ACCESSED", "uncachedDataAccessed", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField USED_PRIVILEGES = TextFormattedAccessLogFields.createField("USED_PRIVILEGES", "usedPrivileges", COMMA_DELIMITED_STRING_LIST_SYNTAX);
    @NotNull
    public static final LogField USING_ADMIN_SESSION_WORKER_THREAD = TextFormattedAccessLogFields.createField("USING_ADMIN_SESSION_WORKER_THREAD", "usingAdminSessionWorkerThread", BOOLEAN_SYNTAX);
    @NotNull
    public static final LogField WORK_QUEUE_WAIT_TIME_MILLIS = TextFormattedAccessLogFields.createField("WORK_QUEUE_WAIT_TIME_MILLIS", "qtime", INTEGER_SYNTAX);

    private TextFormattedAccessLogFields() {
    }

    @NotNull
    private static LogField createField(@NotNull String constantName, @NotNull String fieldName, @NotNull LogFieldSyntax<?> fieldSyntax) {
        LogField field = new LogField(fieldName, constantName, fieldSyntax);
        DEFINED_FIELDS.put(constantName, field);
        return field;
    }

    @NotNull
    public static Map<String, LogField> getDefinedFields() {
        Map<String, LogField> m = READ_ONLY_DEFINED_FIELDS_REF.get();
        if (m != null) {
            return m;
        }
        m = Collections.unmodifiableMap(new TreeMap<String, LogField>(DEFINED_FIELDS));
        if (READ_ONLY_DEFINED_FIELDS_REF.compareAndSet(null, m)) {
            return m;
        }
        return READ_ONLY_DEFINED_FIELDS_REF.get();
    }

    @Nullable
    public static LogField getFieldForConstantName(@NotNull String constantName) {
        String convertedName = StaticUtils.toUpperCase(constantName).replace('-', '_');
        return DEFINED_FIELDS.get(convertedName);
    }
}

