/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(Reader reader) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, true);
    }

    public static Xpp3Dom build(InputStream is, String encoding) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(is, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(InputStream is, String encoding, boolean trim) throws XmlPullParserException, IOException {
        MXParser parser = new MXParser();
        parser.setInput(is, encoding);
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim);
            return xpp3Dom;
        }
        finally {
            IOUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(Reader reader, boolean trim) throws XmlPullParserException, IOException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim);
            return xpp3Dom;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    public static Xpp3Dom build(XmlPullParser parser) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, true);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim) throws XmlPullParserException, IOException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String rawName = parser.getName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                values.add(new StringBuffer());
                int attributesSize = parser.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = parser.getText();
                if (trim) {
                    text = text.trim();
                }
                valueBuffer.append(text);
            } else if (eventType == 3) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                String accumulatedValue = values.remove(depth).toString();
                if (finishedConfiguration.getChildCount() == 0) {
                    finishedConfiguration.setValue(accumulatedValue);
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }
}

