searchData={"items":[{"type":"module","title":"IEx","doc":"Elixir's interactive shell.\n\nSome of the functionalities described here will not be available\ndepending on your terminal. In particular, if you get a message\nsaying that the smart terminal could not be run, some of the\nfeatures described here won't work.","ref":"IEx.html"},{"type":"module","title":"Helpers - IEx","doc":"IEx provides a bunch of helpers. They can be accessed by typing\n`h()` into the shell or as a documentation for the `IEx.Helpers` module.","ref":"IEx.html#module-helpers"},{"type":"module","title":"Autocomplete - IEx","doc":"To discover a module's public functions or other modules, type the module name\nfollowed by a dot, then press tab to trigger autocomplete. For example:\n\n    Enum.\n\nA module may export functions that are not meant to be used directly:\nthese functions won't be autocompleted by IEx. IEx will not autocomplete\nfunctions annotated with `@doc false`, `@impl true`, or functions that\naren't explicitly documented and where the function name is in the form\nof `__foo__`.\n\nAutocomplete is available by default on Windows shells from Erlang/OTP 26.\nIn earlier versions, you may need to pass the `--werl` option when starting\nIEx, such as `iex --werl` (or `iex.bat --werl` if using PowerShell).\n`--werl` may be permanently enabled by setting the `IEX_WITH_WERL`\nenvironment variable to `1`.","ref":"IEx.html#module-autocomplete"},{"type":"module","title":"Encoding and coloring - IEx","doc":"IEx expects inputs and outputs to be in UTF-8 encoding. This is the\ndefault for most Unix terminals but it may not be the case on Windows.\nIf you are running on Windows and you see incorrect values printed,\nyou may need change the encoding of your current session by running\n`chcp 65001` before calling `iex` (or before calling `iex.bat` if using\nPowerShell).\n\nSimilarly, ANSI coloring is enabled by default on most Unix terminals.\nThey are also available on Windows consoles from Windows 10 and on\nErlang/OTP 26 or later. For earlier Erlang/OTP versions, you can\nexplicitly enable it for the current user in the registry by running\nthe following command:\n\n    $ reg add HKCU\\Console /v VirtualTerminalLevel /t REG_DWORD /d 1\n\nAfter running the command above, you must restart your current console.","ref":"IEx.html#module-encoding-and-coloring"},{"type":"module","title":"Shell history - IEx","doc":"It is possible to get shell history by passing some options that enable it\nin the VM. This can be done on a per-need basis when starting IEx:\n\n    $ iex --erl \"-kernel shell_history enabled\"\n\nIf you would rather enable it on your system as a whole, you can use\nthe `ERL_AFLAGS` environment variable and make sure that it is set\naccordingly on your terminal/shell configuration.\n\nOn Unix-like / Bash:\n\n    $ export ERL_AFLAGS=\"-kernel shell_history enabled\"\n\nOn Windows:\n\n    $ set ERL_AFLAGS \"-kernel shell_history enabled\"\n\nOn Windows 10 / PowerShell:\n\n    $ $env:ERL_AFLAGS = \"-kernel shell_history enabled\"","ref":"IEx.html#module-shell-history"},{"type":"module","title":"Expressions in IEx - IEx","doc":"As an interactive shell, IEx evaluates expressions. This has some\ninteresting consequences that are worth discussing.\n\nThe first one is that the code is truly evaluated and not compiled.\nThis means that any benchmarking done in the shell is going to have\nskewed results. So never run any profiling nor benchmarks in the shell.\n\nSecond, IEx allows you to break an expression into many lines,\nsince this is common in Elixir. For example:\n\n    iex(1)> \"ab\n    ...(1)> c\"\n    \"ab\\nc\"\n\nIn the example above, the shell will be expecting more input until it\nfinds the closing quote. Sometimes it is not obvious which character\nthe shell is expecting, and the user may find themselves trapped in\nthe state of incomplete expression with no ability to terminate it other\nthan by exiting the shell.\n\nFor such cases, there is a special break-trigger (`#iex:break`) that when\nencountered on a line by itself will force the shell to break out of any\npending expression and return to its normal state:\n\n    iex(1)> [\"ab\n    ...(1)> c\"\n    ...(1)> \"\n    ...(1)> ]\n    ...(1)> #iex:break\n    ** (TokenMissingError) iex:1: incomplete expression","ref":"IEx.html#module-expressions-in-iex"},{"type":"module","title":"Pasting multiline expressions into IEx - IEx","doc":"IEx evaluates its input line by line in an eager fashion. If at the end of a\nline the code seen so far is a complete expression, IEx will evaluate it at\nthat point.\n\n    iex(1)> [1, [2], 3]\n    [1, [2], 3]\n\nTo prevent this behaviour breaking valid code where the subsequent line\nbegins with a binary operator, such as `|>/2` or `++/2` , IEx automatically\ntreats such lines as if they were prepended with `IEx.Helpers.v/0`, which\nreturns the value of the previous expression, if available.\n\n    iex(1)> [1, [2], 3]\n    [1, [2], 3]\n    iex(2)> |> List.flatten()\n    [1, 2, 3]\n\nThe above is equivalent to:\n\n    iex(1)> [1, [2], 3]\n    [1, [2], 3]\n    iex(2)> v() |> List.flatten()\n    [1, 2, 3]\n\nIf there are no previous expressions in the history, the pipe operator will\nfail:\n\n    iex(1)> |> List.flatten()\n    ** (RuntimeError) v(-1) is out of bounds\n\nIf the previous expression was a match operation, the pipe operator will also\nfail, to prevent an unsolicited break of the match:\n\n    iex(1)> x = 42\n    iex(2)> |> IO.puts()\n    ** (SyntaxError) iex:2:1: pipe shorthand is not allowed immediately after a match expression in IEx. To make it work, surround the whole pipeline with parentheses ('|>')\n        |\n      2 | |> IO.puts()\n        | ^\n\nNote, however, the above does not work for `+/2` and `-/2`, as they\nare ambiguous with the unary `+/1` and `-/1`:\n\n    iex(1)> 1\n    1\n    iex(2)> + 2\n    2","ref":"IEx.html#module-pasting-multiline-expressions-into-iex"},{"type":"module","title":"The BREAK menu - IEx","doc":"Inside IEx, hitting `Ctrl+C` will open up the `BREAK` menu. In this\nmenu you can quit the shell, see process and ETS tables information\nand much more.","ref":"IEx.html#module-the-break-menu"},{"type":"module","title":"Exiting the shell - IEx","doc":"There are a few ways to quit the IEx shell:\n\n  * via the `BREAK` menu (available via `Ctrl+C`) by typing `q`, pressing enter\n  * by hitting `Ctrl+C`, `Ctrl+C`\n  * by hitting `Ctrl+\\ `\n\nIf you are connected to remote shell, it remains alive after disconnection.\n\n## `dbg` and breakpoints\n\nIEx integrates with `Kernel.dbg/2` and introduces a backend that\ncan pause code execution. To enable it, you must pass `--dbg pry`:\n\n    $ iex --dbg pry\n\nFor example, take the following function:\n\n    def my_fun(arg1, arg2) do\n      dbg(arg1 + arg2)\n      ... implementation ...\n    end\n\nWhen the code is executed with `iex` (most often by calling\n`iex --dbg pry -S mix`), it will ask you permission to use \"pry\".\nIf you agree, it will start an IEx shell in the context of the function\nabove, with access to its variables, imports, and aliases. However,\nyou can only access existing values, it is not possible to access\nprivate functions nor change the execution itself (hence the name\n\"pry\").\n\nWhen using `|> dbg()` at the end of a pipeline, you can pry each\nstep of the pipeline. You can type `n` whenever you want to jump\ninto the next pipe. Type `continue` when you want to execute all\nof the steps but stay within the pried process. Type `respawn` when\nyou want to leave the pried process and start a new shell.\n\nAlternatively, you can start a pry session directly, without `dbg/2`\nby calling `IEx.pry/0`.\n\nIEx also allows you to set breakpoints to start pry sessions\non a given module, function, and arity you have no control of\nvia `IEx.break!/4`. Similar to pipelines in `dbg()`, `IEx.break!/4`\nallows you to debug a function line by line and access its variables.\nHowever, breakpoints do not contain information about imports and\naliases from the source code.\n\nWhen using `dbg` or breakpoints with tests, remember to pass the\n`--trace` to `mix test` to avoid running into timeouts:\n\n    $ iex -S mix test --trace\n    $ iex -S mix test path/to/file:line --trace","ref":"IEx.html#module-exiting-the-shell"},{"type":"module","title":"The User switch command - IEx","doc":"Besides the `BREAK` menu, one can type `Ctrl+G` to get to the\n`User switch command` menu. When reached, you can type `h` to\nget more information.\n\nIn this menu, developers are able to start new shells and\nalternate between them. Let's give it a try:\n\n    User switch command\n     --> s 'Elixir.IEx'\n     --> c\n\nThe command above will start a new shell and connect to it.\nCreate a new variable called `hello` and assign some value to it:\n\n    hello = :world\n\nNow, let's roll back to the first shell:\n\n    User switch command\n     --> c 1\n\nNow, try to access the `hello` variable again:\n\n    hello\n    ** (UndefinedFunctionError) undefined function hello/0\n\nThe command above fails because we have switched shells.\nSince shells are isolated from each other, you can't access the\nvariables defined in one shell from the other one.\n\nThe `User switch command` can also be used to terminate an existing\nsession, for example when the evaluator gets stuck in an infinite\nloop or when you are stuck typing an expression:\n\n    User switch command\n     --> i\n     --> c\n\nThe `User switch command` menu also allows developers to connect to\nremote shells using the `r` command. A topic which we will discuss next.","ref":"IEx.html#module-the-user-switch-command"},{"type":"module","title":"Remote shells - IEx","doc":"IEx allows you to connect to another node in two fashions.\nFirst of all, we can only connect to a shell if we give names\nboth to the current shell and the shell we want to connect to.\n\nLet's give it a try. First, start a new shell:\n\n    $ iex --sname foo\n    iex(foo@HOST)1>\n\nThe string between the parentheses in the prompt is the name\nof your node. We can retrieve it by calling the `node/0`\nfunction:\n\n    iex(foo@HOST)1> node()\n    :\"foo@HOST\"\n    iex(foo@HOST)2> Node.alive?()\n    true\n\nFor fun, let's define a simple module in this shell too:\n\n    iex(foo@HOST)3> defmodule Hello do\n    ...(foo@HOST)3>   def world, do: \"it works!\"\n    ...(foo@HOST)3> end\n\nNow, let's start another shell, giving it a name as well:\n\n    $ iex --sname bar\n    iex(bar@HOST)1>\n\nIf we try to dispatch to `Hello.world/0`, it won't be available\nas it was defined only in the other shell:\n\n    iex(bar@HOST)1> Hello.world()\n    ** (UndefinedFunctionError) undefined function Hello.world/0\n\nHowever, we can connect to the other shell remotely. Open up\nthe `User switch command` prompt (Ctrl+G) and type:\n\n    User switch command\n     --> r 'foo@HOST' 'Elixir.IEx'\n     --> c\n\nNow we are connected into the remote node, as the prompt shows us,\nand we can access the information and modules defined over there:\n\n    iex(foo@HOST)1> Hello.world()\n    \"it works!\"\n\nIn fact, connecting to remote shells is so common that we provide\na shortcut via the command line as well:\n\n    $ iex --sname baz --remsh foo@HOST\n\nWhere \"remsh\" means \"remote shell\". In general, Elixir supports:\n\n  * remsh from an Elixir node to an Elixir node\n  * remsh from a plain Erlang node to an Elixir node (through the ^G menu)\n  * remsh from an Elixir node to a plain Erlang node (and get an `erl` shell there)\n\nConnecting an Elixir shell to a remote node without Elixir is\n**not** supported.","ref":"IEx.html#module-remote-shells"},{"type":"module","title":"The .iex.exs file - IEx","doc":"When starting, IEx looks for a local `.iex.exs` file (located in the current\nworking directory), then for a global `.iex.exs` file located inside the\ndirectory pointed by the `IEX_HOME` environment variable (which defaults\nto `~`) and loads the first one it finds (if any).\n\nThe code in the chosen `.iex.exs` file is evaluated line by line in the shell's\ncontext, as if each line were being typed in the shell. For instance, any modules\nthat are loaded or variables that are bound in the `.iex.exs` file will be available\nin the shell after it has booted.\n\nTake the following `.iex.exs` file:\n\n    # Load another \".iex.exs\" file\n    import_file(\"~/.iex.exs\")\n\n    # Import some module from lib that may not yet have been defined\n    import_if_available(MyApp.Mod)\n\n    # Print something before the shell starts\n    IO.puts(\"hello world\")\n\n    # Bind a variable that'll be accessible in the shell\n    value = 13\n\nRunning IEx in the directory where the above `.iex.exs` file is located\nresults in:\n\n    $ iex\n    Erlang/OTP 24 [...]\n\n    hello world\n    Interactive Elixir - press Ctrl+C to exit (type h() ENTER for help)\n    iex(1)> value\n    13\n\nIt is possible to load another file by supplying the `--dot-iex` option\nto IEx. See `iex --help`.\n\nIn case of remote nodes, the location of the `.iex.exs` files are taken\nrelative to the user that started the application, not to the user that\nis connecting to the node in case of remote IEx connections.","ref":"IEx.html#module-the-iex-exs-file"},{"type":"module","title":"Configuring the shell - IEx","doc":"There are a number of customization options provided by IEx. Take a look\nat the docs for the `IEx.configure/1` function by typing `h IEx.configure/1`.\n\nThose options can be configured in your project configuration file or globally\nby calling `IEx.configure/1` from your `~/.iex.exs` file. For example:\n\n    # .iex.exs\n    IEx.configure(inspect: [limit: 3])\n\nNow run the shell:\n\n    $ iex\n    Erlang/OTP 24 [...]\n\n    Interactive Elixir - press Ctrl+C to exit (type h() ENTER for help)\n    iex(1)> [1, 2, 3, 4, 5]\n    [1, 2, 3, ...]","ref":"IEx.html#module-configuring-the-shell"},{"type":"macro","title":"IEx.break!/2","doc":"Macro-based shortcut for `IEx.break!/4`.","ref":"IEx.html#break!/2"},{"type":"function","title":"IEx.break!/4","doc":"Sets up a breakpoint in `module`, `function` and `arity` with\nthe given number of `stops`.\n\nThis function will instrument the given module and load a new\nversion in memory with line by line breakpoints at the given\nfunction and arity. If the module is recompiled, all breakpoints\nare lost.\n\nWhen a breakpoint is reached, IEx will ask if you want to `pry`\nthe given function and arity. In other words, this works similar\nto `IEx.pry/0` as the running process becomes the evaluator of\nIEx commands and is temporarily changed to have a custom group\nleader. However, differently from `IEx.pry/0`, aliases and imports\nfrom the source code won't be available in the shell.\n\nIEx helpers includes many conveniences related to breakpoints.\nBelow they are listed with the full module, such as `IEx.Helpers.breaks/0`,\nbut remember it can be called directly as `breaks()` inside IEx.\nThey are:\n\n  * `IEx.Helpers.break!/2` - sets up a breakpoint for a given `Mod.fun/arity`\n  * `IEx.Helpers.break!/4` - sets up a breakpoint for the given module, function, arity\n  * `IEx.Helpers.breaks/0` - prints all breakpoints and their IDs\n  * `IEx.Helpers.continue/0` - continues until the next breakpoint in the same shell\n  * `IEx.Helpers.n/0` - goes to the next line of the current breakpoint\n  * `IEx.Helpers.next/0` - same as above\n  * `IEx.Helpers.open/0` - opens editor on the current breakpoint\n  * `IEx.Helpers.remove_breaks/0` - removes all breakpoints in all modules\n  * `IEx.Helpers.remove_breaks/1` - removes all breakpoints in a given module\n  * `IEx.Helpers.reset_break/1` - sets the number of stops on the given ID to zero\n  * `IEx.Helpers.reset_break/3` - sets the number of stops on the given module, function, arity to zero\n  * `IEx.Helpers.respawn/0` - starts a new shell (breakpoints will ask for permission once more)\n  * `IEx.Helpers.whereami/1` - shows the current location\n\nBy default, the number of stops in a breakpoint is 1. Any follow-up\ncall won't stop the code execution unless another breakpoint is set.\n\nAlternatively, the number of stops can be increased by passing the `stops`\nargument. `IEx.Helpers.reset_break/1` and `IEx.Helpers.reset_break/3`\ncan be used to reset the number back to zero. Note the module remains\n\"instrumented\" even after all stops on all breakpoints are consumed.\nYou can remove the instrumentation in a given module by calling\n`IEx.Helpers.remove_breaks/1` and on all modules by calling\n`IEx.Helpers.remove_breaks/0`.\n\nWithin a breakpoint, you can call `n` to jump to the next line.\nTo exit a breakpoint, you can either invoke `continue`, which will\nblock the shell until the next breakpoint is found or the process\nterminates, or invoke `respawn`, which starts a new IEx shell,\nfreeing up the pried one.","ref":"IEx.html#break!/4"},{"type":"function","title":"Examples - IEx.break!/4","doc":"The examples below will use `break!`, assuming that you are setting\na breakpoint directly from your IEx shell. But you can set up a break\nfrom anywhere by using the fully qualified name `IEx.break!`.\n\nThe following sets up a breakpoint on `URI.parse/1`:\n\n    break! URI, :parse, 1\n\nThis call will setup a breakpoint that stops once.\nTo set a breakpoint that will stop 10 times:\n\n    break! URI, :parse, 1, 10\n\n`IEx.break!/2` is a convenience macro that allows breakpoints\nto be given in the `Mod.fun/arity` format:\n\n    break! URI.parse/1\n\nOr to set a breakpoint that will stop 10 times:\n\n    break! URI.parse/1, 10\n\nThis function returns the breakpoint ID and will raise if there\nis an error setting up the breakpoint.","ref":"IEx.html#break!/4-examples"},{"type":"function","title":"Patterns and guards - IEx.break!/4","doc":"`IEx.break!/2` allows patterns to be given, triggering the\nbreakpoint only in some occasions. For example, to trigger\nthe breakpoint only when the first argument starts with the\n\"https\" string:\n\n    break! URI.parse(\"https\"   _, _)\n\nOnly a single break point can be set per function. So if you call\n`IEx.break!` multiple times with different patterns, only the last\npattern is kept.","ref":"IEx.html#break!/4-patterns-and-guards"},{"type":"function","title":"Macros - IEx.break!/4","doc":"While it is possible to set breakpoint in macros, remember that macros\nare generally expanded at compilation time, and therefore they may never\nbe invoked during runtime. Similarly, while patterns may be given to\nmacros, macros receive ASTs as arguments, and not values. For example,\nif you try to break on a macro with the following pattern:\n\n    break! MyModule.some_macro(pid) when pid == self()\n\nThis breakpoint will never be reached, because a macro never receives\na PID. Even if you call the macro as `MyModule.some_macro(self())`,\nthe macro will receive the AST representing the `self()` call, and not\nthe PID itself.","ref":"IEx.html#break!/4-macros"},{"type":"function","title":"Breaks and `mix test` - IEx.break!/4","doc":"To use `IEx.break!/4` during tests, you need to run `mix` inside\nthe `iex` command and pass the `--trace` to `mix test` to avoid running\ninto timeouts:\n\n    $ iex -S mix test --trace\n    $ iex -S mix test path/to/file:line --trace","ref":"IEx.html#break!/4-breaks-and-mix-test"},{"type":"function","title":"IEx.color/2","doc":"Returns `string` escaped using the specified `color`.\n\nANSI escapes in `string` are not processed in any way.","ref":"IEx.html#color/2"},{"type":"function","title":"IEx.configuration/0","doc":"Returns IEx configuration.","ref":"IEx.html#configuration/0"},{"type":"function","title":"IEx.configure/1","doc":"Configures IEx.\n\nThe supported options are:\n\n  * `:colors`\n  * `:inspect`\n  * `:width`\n  * `:history_size`\n  * `:default_prompt`\n  * `:continuation_prompt`\n  * `:alive_prompt`\n  * `:alive_continuation_prompt`\n  * `:parser`\n\nThey are discussed individually in the sections below.","ref":"IEx.html#configure/1"},{"type":"function","title":"Colors - IEx.configure/1","doc":"A keyword list that encapsulates all color settings used by the\nshell. See documentation for the `IO.ANSI` module for the list of\nsupported colors and attributes.\n\nList of supported keys in the keyword list:\n\n  * `:enabled` - boolean value that allows for switching the coloring on and off\n  * `:eval_result` - color for an expression's resulting value\n  * `:eval_info` - ... various informational messages\n  * `:eval_error` - ... error messages\n  * `:eval_interrupt` - ... interrupt messages\n  * `:stack_info` - ... the stacktrace color\n  * `:blame_diff` - ... when blaming source with no match\n  * `:ls_directory` - ... for directory entries (ls helper)\n  * `:ls_device` - ... device entries (ls helper)\n\nWhen printing documentation, IEx will convert the Markdown\ndocumentation to ANSI as well. Colors for this can be configured\nvia:\n\n  * `:doc_code`        - the attributes for code blocks (cyan, bright)\n  * `:doc_inline_code` - inline code (cyan)\n  * `:doc_headings`    - h1 and h2 (yellow, bright)\n  * `:doc_title`       - the overall heading for the output (reverse, yellow, bright)\n  * `:doc_bold`        - (bright)\n  * `:doc_underline`   - (underline)\n\nIEx will also color inspected expressions using the `:syntax_colors`\noption. Such can be disabled with:\n\n    IEx.configure(colors: [syntax_colors: false])\n\nYou can also configure the syntax colors, however, as desired.\nThe below will format atoms in red and remove the coloring for\nall other data types:\n\n    IEx.configure(colors: [syntax_colors: [atom: :red]])\n\nThe default values can be found in `IO.ANSI.syntax_colors/0`.","ref":"IEx.html#configure/1-colors"},{"type":"function","title":"Inspect - IEx.configure/1","doc":"A keyword list containing inspect options used by the shell\nwhen printing results of expression evaluation. Defaults to\npretty formatting with a limit of 50 entries.\n\nTo show all entries, configure the limit to `:infinity`:\n\n    IEx.configure(inspect: [limit: :infinity])\n\nSee `Inspect.Opts` for the full list of options.","ref":"IEx.html#configure/1-inspect"},{"type":"function","title":"Width - IEx.configure/1","doc":"An integer indicating the maximum number of columns to use in output.\nThe default value is 80 columns. The actual output width is the minimum\nof this number and result of `:io.columns`. This way you can configure IEx\nto be your largest screen size and it should always take up the full width\nof your current terminal screen.","ref":"IEx.html#configure/1-width"},{"type":"function","title":"History size - IEx.configure/1","doc":"Number of expressions and their results to keep in the history.\nThe value is an integer. When it is negative, the history is unlimited.","ref":"IEx.html#configure/1-history-size"},{"type":"function","title":"Prompt - IEx.configure/1","doc":"This is an option determining the prompt displayed to the user\nwhen awaiting input.\n\nThe value is a keyword list with two possible keys representing prompt types:\n\n  * `:default_prompt` - used when `Node.alive?/0` returns `false`\n\n  * `:continuation_prompt` - used when `Node.alive?/0` returns `false`\n    and more input is expected\n\n  * `:alive_prompt` - used when `Node.alive?/0` returns `true`\n\n  * `:alive_continuation_prompt` - used when `Node.alive?/0` returns\n    `true` and more input is expected\n\nThe following values in the prompt string will be replaced appropriately:\n\n  * `%counter` - the index of the history\n  * `%prefix`  - a prefix given by `IEx.Server`\n  * `%node`    - the name of the local node","ref":"IEx.html#configure/1-prompt"},{"type":"function","title":"Parser - IEx.configure/1","doc":"This is an option determining the parser to use for IEx.\n\nThe parser is a \"mfargs\", which is a tuple with three elements:\nthe module name, the function name, and extra arguments to\nbe appended. The parser receives at least three arguments, the\ncurrent input as a string, the parsing options as a keyword list,\nand the buffer as a string. It must return `{:ok, expr, buffer}`\nor `{:incomplete, buffer}`.\n\nIf the parser raises, the buffer is reset to an empty string.","ref":"IEx.html#configure/1-parser"},{"type":"function","title":"IEx.inspect_opts/0","doc":"Returns the options used for inspecting.","ref":"IEx.html#inspect_opts/0"},{"type":"macro","title":"IEx.pry/0","doc":"Pries into the process environment.\n\nThis function is useful for debugging a particular chunk of code\nwhen executed by a particular process. The process becomes\nthe evaluator of IEx commands and is temporarily changed to\nhave a custom group leader. Those values are reverted by\ncalling `IEx.Helpers.respawn/0`, which starts a new IEx shell,\nfreeing up the pried one.\n\nWhen a process is pried, all code runs inside IEx and has\naccess to all imports and aliases from the original code.\nHowever, you cannot change the execution of the code nor\naccess private functions of the module being pried. Module\nfunctions still need to be accessed via `Mod.fun(args)`.\n\nSee also `break!/4` for others ways to pry.\n\n> #### `dbg/0` integration\n>\n> By calling `iex --dbg pry`, `iex` will set this function\n> as the default backend for `dbg/0` calls.","ref":"IEx.html#pry/0"},{"type":"macro","title":"Examples - IEx.pry/0","doc":"Let's suppose you want to investigate what is happening\nwith some particular function. By invoking `IEx.pry/0` from\nthe function, IEx will allow you to access its binding\n(variables), verify its lexical information and access\nthe process information. Let's see an example:\n\n    import Enum, only: [map: 2]\n\n    defmodule Adder do\n      def add(a, b) do\n        c = a + b\n        require IEx; IEx.pry()\n      end\n    end\n\nWhen invoking `Adder.add(1, 2)`, you will receive a message in\nyour shell to pry the given environment. By allowing it,\nthe shell will be reset and you gain access to all variables\nand the lexical scope from above:\n\n    iex(1)> map([a, b, c], &IO.inspect(&1))\n    1\n    2\n    3\n\nKeep in mind that `IEx.pry/0` runs in the caller process,\nblocking the caller during the evaluation cycle. The caller\nprocess can be freed by calling [`respawn/0`](`IEx.Helpers.respawn/0`), which starts a\nnew IEx evaluation cycle, letting this one go:\n\n    iex(2)> respawn()\n    true\n\n    Interactive Elixir - press Ctrl+C to exit (type h() ENTER for help)\n\nSetting variables or importing modules in IEx does not\naffect the caller's environment. However, sending and\nreceiving messages will change the process state.","ref":"IEx.html#pry/0-examples"},{"type":"macro","title":"Pry and macros - IEx.pry/0","doc":"When setting up Pry inside a code defined by macros, such as:\n\n    defmacro __using__(_) do\n      quote do\n        def add(a, b) do\n          c = a + b\n          require IEx; IEx.pry()\n        end\n      end\n    end\n\nThe variables defined inside `quote` won't be available during\nprying due to the hygiene mechanism in quoted expressions. The\nhygiene mechanism changes the variable names in quoted expressions\nso they don't collide with variables defined by the users of the\nmacros. Therefore the original names are not available.","ref":"IEx.html#pry/0-pry-and-macros"},{"type":"macro","title":"Pry and `mix test` - IEx.pry/0","doc":"To use `IEx.pry/0` during tests, you need to run `mix` inside\nthe `iex` command and pass the `--trace` to `mix test` to avoid running\ninto timeouts:\n\n    $ iex -S mix test --trace\n    $ iex -S mix test path/to/file:line --trace","ref":"IEx.html#pry/0-pry-and-mix-test"},{"type":"function","title":"IEx.started?/0","doc":"Returns `true` if IEx was started, `false` otherwise.\n\nThis means the IEx application was started, but not\nthat its CLI interface is running.","ref":"IEx.html#started?/0"},{"type":"function","title":"IEx.width/0","doc":"Returns the IEx width for printing.\n\nUsed by helpers and it has a default maximum cap of 80 chars.","ref":"IEx.html#width/0"},{"type":"module","title":"IEx.Helpers","doc":"Welcome to Interactive Elixir. You are currently\nseeing the documentation for the module `IEx.Helpers`\nwhich provides many helpers to make Elixir's shell\nmore joyful to work with.\n\nThis message was triggered by invoking the helper `h()`,\nusually referred to as `h/0` (since it expects 0 arguments).\n\nYou can use the `h/1` function to invoke the documentation\nfor any Elixir module or function:\n\n    iex> h(Enum)\n    iex> h(Enum.map)\n    iex> h(Enum.reverse/1)\n\nYou can also use the `i/1` function to introspect any value\nyou have in the shell:\n\n    iex> i(\"hello\")\n\nThere are many other helpers available, here are some examples:\n\n  * `b/1`            - prints callbacks info and docs for a given module\n  * `c/1`            - compiles a file\n  * `c/2`            - compiles a file and writes bytecode to the given path\n  * `cd/1`           - changes the current directory\n  * `clear/0`        - clears the screen\n  * `exports/1`      - shows all exports (functions + macros) in a module\n  * `flush/0`        - flushes all messages sent to the shell\n  * `h/0`            - prints this help message\n  * `h/1`            - prints help for the given module, function or macro\n  * `i/0`            - prints information about the last value\n  * `i/1`            - prints information about the given term\n  * `ls/0`           - lists the contents of the current directory\n  * `ls/1`           - lists the contents of the specified directory\n  * `open/1`         - opens the source for the given module or function in your editor\n  * `pid/1`          - creates a PID from a string\n  * `pid/3`          - creates a PID with the 3 integer arguments passed\n  * `port/1`         - creates a port from a string\n  * `port/2`         - creates a port with the 2 non-negative integers passed\n  * `pwd/0`          - prints the current working directory\n  * `r/1`            - recompiles the given module's source file\n  * `recompile/0`    - recompiles the current project\n  * `ref/1`          - creates a reference from a string\n  * `ref/4`          - creates a reference with the 4 integer arguments passed\n  * `runtime_info/0` - prints runtime info (versions, memory usage, stats)\n  * `t/1`            - prints the types for the given module or function\n  * `v/0`            - retrieves the last value from the history\n  * `v/1`            - retrieves the nth value from the history\n\nHelp for all of those functions can be consulted directly from\nthe command line using the `h/1` helper itself. Try:\n\n    iex> h(v/0)\n\nTo list all IEx helpers available, which is effectively all\nexports (functions and macros) in the `IEx.Helpers` module:\n\n    iex> exports(IEx.Helpers)\n\nThis module also includes helpers for debugging purposes, see\n`IEx.break!/4` for more information.\n\nTo learn more about IEx as a whole, type `h(IEx)`.","ref":"IEx.Helpers.html"},{"type":"macro","title":"IEx.Helpers.b/1","doc":"Prints the documentation for the given callback function.\n\nIt also accepts single module argument to list\nall available behaviour callbacks.","ref":"IEx.Helpers.html#b/1"},{"type":"macro","title":"Examples - IEx.Helpers.b/1","doc":"iex> b(Mix.Task.run/1)\n    iex> b(Mix.Task.run)\n    iex> b(GenServer)","ref":"IEx.Helpers.html#b/1-examples"},{"type":"macro","title":"IEx.Helpers.break!/2","doc":"Sets up a breakpoint in the AST of shape `Module.function/arity`\nwith the given number of `stops`.\n\nSee `IEx.break!/4` for a complete description of breakpoints\nin IEx.","ref":"IEx.Helpers.html#break!/2"},{"type":"macro","title":"Examples - IEx.Helpers.break!/2","doc":"break! URI.decode_query/2","ref":"IEx.Helpers.html#break!/2-examples"},{"type":"function","title":"IEx.Helpers.break!/4","doc":"Sets up a breakpoint in `module`, `function` and `arity`\nwith the given number of `stops`.\n\nSee `IEx.break!/4` for a complete description of breakpoints\nin IEx.","ref":"IEx.Helpers.html#break!/4"},{"type":"function","title":"Examples - IEx.Helpers.break!/4","doc":"break! URI, :decode_query, 2","ref":"IEx.Helpers.html#break!/4-examples"},{"type":"function","title":"IEx.Helpers.breaks/0","doc":"Prints all breakpoints to the terminal.","ref":"IEx.Helpers.html#breaks/0"},{"type":"function","title":"IEx.Helpers.c/2","doc":"Compiles the given files.\n\nIt expects a list of files to compile and an optional path to write\nthe compiled code to. By default files are in-memory compiled.\nTo write compiled files to the current directory, an empty string\ncan be given.\n\nIt returns the names of the compiled modules.\n\nIf you want to recompile an existing module, check `r/1` instead.","ref":"IEx.Helpers.html#c/2"},{"type":"function","title":"Examples - IEx.Helpers.c/2","doc":"In the example below, we pass a directory to where the `c/2` function will\nwrite the compiled `.beam` files to. This directory is typically named \"ebin\"\nin Erlang/Elixir systems:\n\n    iex> c([\"foo.ex\", \"bar.ex\"], \"ebin\")\n    [Foo, Bar]\n\nWhen compiling one file, there is no need to wrap it in a list:\n\n    iex> c(\"baz.ex\")\n    [Baz]","ref":"IEx.Helpers.html#c/2-examples"},{"type":"function","title":"IEx.Helpers.cd/1","doc":"Changes the current working directory to the given path.","ref":"IEx.Helpers.html#cd/1"},{"type":"function","title":"IEx.Helpers.clear/0","doc":"Clears the console screen.\n\nThis function only works if ANSI escape codes are enabled\non the shell, which means this function is by default\nunavailable on Windows machines.","ref":"IEx.Helpers.html#clear/0"},{"type":"function","title":"IEx.Helpers.continue/0","doc":"Continues execution of the current process.\n\nThis is usually called by sessions started with `IEx.pry/0`\nor `IEx.break!/4`. This allows the current process to execute\nuntil the next breakpoint, which will automatically yield control\nback to IEx without requesting permission to pry.\n\nIf you simply want to move to the next line of the current breakpoint,\nuse `n/0` or `next/0` instead.\n\nIf the running process terminates, a new IEx session is\nstarted.\n\nWhile the process executes, the user will no longer have\ncontrol of the shell. If you would rather start a new shell,\nuse `respawn/0` instead.","ref":"IEx.Helpers.html#continue/0"},{"type":"function","title":"IEx.Helpers.exports/1","doc":"Prints a list of all the functions and macros exported by the given module.","ref":"IEx.Helpers.html#exports/1"},{"type":"function","title":"IEx.Helpers.flush/0","doc":"Clears out all messages sent to the shell's inbox and prints them out.","ref":"IEx.Helpers.html#flush/0"},{"type":"function","title":"IEx.Helpers.h/0","doc":"Prints the documentation for `IEx.Helpers`.","ref":"IEx.Helpers.html#h/0"},{"type":"macro","title":"IEx.Helpers.h/1","doc":"Prints the documentation for the given module\nor for the given `function/arity` pair.","ref":"IEx.Helpers.html#h/1"},{"type":"macro","title":"Examples - IEx.Helpers.h/1","doc":"iex> h(Enum)\n\nIt also accepts functions in the format `function/arity`\nand `module.function/arity`, for example:\n\n    iex> h(receive/1)\n    iex> h(Enum.all?/2)\n    iex> h(Enum.all?)","ref":"IEx.Helpers.html#h/1-examples"},{"type":"function","title":"IEx.Helpers.i/1","doc":"Prints information about the data type of any given term.\n\nIf no argument is given, the value of the previous expression\nis used.","ref":"IEx.Helpers.html#i/1"},{"type":"function","title":"Examples - IEx.Helpers.i/1","doc":"iex> i(1..5)\n\nWill print:\n\n    Term\n      1..5\n    Data type\n      Range\n    Description\n      This is a struct. Structs are maps with a __struct__ key.\n    Reference modules\n      Range, Map","ref":"IEx.Helpers.html#i/1-examples"},{"type":"macro","title":"IEx.Helpers.import_file/1","doc":"Injects the contents of the file at `path`.\n\nThis would be the equivalent of getting all of the file contents and\npasting it all at once in IEx and executing it.\n\nBy default, the contents of a `.iex.exs` file in the same directory\nas you are starting IEx are automatically imported. See the section\nfor \".iex.exs\" in the `IEx` module docs for more information.\n\n`path` has to be a literal string and is automatically expanded via\n`Path.expand/1`.","ref":"IEx.Helpers.html#import_file/1"},{"type":"macro","title":"Examples - IEx.Helpers.import_file/1","doc":"# ~/file.exs\n    value = 13\n\n    # in the shell\n    iex(1)> import_file(\"~/file.exs\")\n    13\n    iex(2)> value\n    13","ref":"IEx.Helpers.html#import_file/1-examples"},{"type":"macro","title":"IEx.Helpers.import_file_if_available/1","doc":"Similar to `import_file` but only imports the file if it is available.\n\nBy default, `import_file/1` fails when the given file does not exist.\nHowever, since `import_file/1` is expanded at compile-time, it's not\npossible to conditionally import a file since the macro is always\nexpanded:\n\n    # This raises a File.Error if ~/.iex.exs doesn't exist.\n    if \"~/.iex.exs\" |> Path.expand() |> File.exists?() do\n      import_file(\"~/.iex.exs\")\n    end\n\nThis macro addresses this issue by checking if the file exists or not\nin behalf of the user.","ref":"IEx.Helpers.html#import_file_if_available/1"},{"type":"macro","title":"IEx.Helpers.import_if_available/2","doc":"Calls `import/2` with the given arguments, but only if the module is available.\n\nThis lets you put imports in `.iex.exs` files (including `~/.iex.exs`) without\ngetting compile errors if you open a console where the module is not available.","ref":"IEx.Helpers.html#import_if_available/2"},{"type":"macro","title":"Example - IEx.Helpers.import_if_available/2","doc":"# In ~/.iex.exs\n    import_if_available(Ecto.Query)","ref":"IEx.Helpers.html#import_if_available/2-example"},{"type":"function","title":"IEx.Helpers.l/1","doc":"Loads the given module's BEAM code (and ensures any previous\nold version was properly purged before).\n\nThis function is useful when you know the bytecode for module\nhas been updated in the file system and you want to tell the VM\nto load it.","ref":"IEx.Helpers.html#l/1"},{"type":"function","title":"IEx.Helpers.ls/1","doc":"Prints a list of the given directory's contents.\n\nIf `path` points to a file, prints its full path.","ref":"IEx.Helpers.html#ls/1"},{"type":"function","title":"IEx.Helpers.n/0","doc":"A shortcut for `next/0`.","ref":"IEx.Helpers.html#n/0"},{"type":"function","title":"IEx.Helpers.next/0","doc":"Goes to the next line of the current breakpoint.\n\nThis is usually called by sessions started with `IEx.break!/4`.\nIf instead of the next line you want to move to the next breakpoint,\ncall `continue/0` instead.\n\nWhile the process executes, the user will no longer have\ncontrol of the shell. If you would rather start a new shell,\nuse `respawn/0` instead.","ref":"IEx.Helpers.html#next/0"},{"type":"function","title":"IEx.Helpers.nl/2","doc":"Deploys a given module's BEAM code to a list of nodes.\n\nThis function is useful for development and debugging when you have code that\nhas been compiled or updated locally that you want to run on other nodes.\n\nThe node list defaults to a list of all connected nodes.\n\nReturns `{:error, :nofile}` if the object code (i.e. \".beam\" file) for the module\ncould not be found locally.","ref":"IEx.Helpers.html#nl/2"},{"type":"function","title":"Examples - IEx.Helpers.nl/2","doc":"iex> nl(HelloWorld)\n    {:ok,\n     [\n       {:node1@easthost, :loaded, HelloWorld},\n       {:node1@westhost, :loaded, HelloWorld}\n     ]}\n\n    iex> nl(NoSuchModuleExists)\n    {:error, :nofile}","ref":"IEx.Helpers.html#nl/2-examples"},{"type":"function","title":"IEx.Helpers.open/0","doc":"Opens the current prying location.\n\nThis command only works inside a pry session started manually\nvia `IEx.pry/0` or a breakpoint set via `IEx.break!/4`. Calling\nthis function during a regular `IEx` session will print an error.\n\nKeep in mind the `open/0` location may not exist when prying\nprecompiled source code, such as Elixir itself.\n\nFor more information and to open any module or function, see\n`open/1`.","ref":"IEx.Helpers.html#open/0"},{"type":"macro","title":"IEx.Helpers.open/1","doc":"Opens the given `module`, `module.function/arity`, or `{file, line}`.\n\nThis function uses the `ELIXIR_EDITOR` environment variable\nand falls back to `EDITOR` if the former is not available.\n\nBy default, it attempts to open the file and line using the\n`file:line` notation. For example, for Sublime Text you can\nset it as:\n\n    ELIXIR_EDITOR=\"subl\"\n\nWhich will then try to open it as:\n\n    subl path/to/file:line\n\nFor Visual Studio Code, once enabled on the command line,\nyou can set it to:\n\n    ELIXIR_EDITOR=\"code --goto\"\n\nIt is important that you choose an editor command that does\nnot block nor that attempts to run an editor directly in the\nterminal. Command-line based editors likely need extra\nconfiguration so they open up the given file and line in a\nseparate window.\n\nFor more complex use cases, you can use the `__FILE__` and\n`__LINE__` notations to explicitly interpolate the file and\nline into the command:\n\n    ELIXIR_EDITOR=\"my_editor +__LINE__ __FILE__\"\n\nSince this function prints the result returned by the editor,\n`ELIXIR_EDITOR` can be set \"echo\" if you prefer to display the\nlocation rather than opening it.\n\nKeep in mind the location may not exist when opening precompiled\nsource code.","ref":"IEx.Helpers.html#open/1"},{"type":"macro","title":"Examples - IEx.Helpers.open/1","doc":"iex> open(MyApp)\n    iex> open(MyApp.fun/2)\n    iex> open({\"path/to/file\", 1})","ref":"IEx.Helpers.html#open/1-examples"},{"type":"function","title":"IEx.Helpers.pid/1","doc":"Creates a PID from `string` or `atom`.","ref":"IEx.Helpers.html#pid/1"},{"type":"function","title":"Examples - IEx.Helpers.pid/1","doc":"iex> pid(\"0.21.32\")\n    #PID \n\n    iex> pid(\"#PID \")\n    #PID \n\n    iex> pid(:init)\n    #PID","ref":"IEx.Helpers.html#pid/1-examples"},{"type":"function","title":"IEx.Helpers.pid/3","doc":"Creates a PID with 3 non-negative integers passed as arguments\nto the function.","ref":"IEx.Helpers.html#pid/3"},{"type":"function","title":"Examples - IEx.Helpers.pid/3","doc":"iex> pid(0, 21, 32)\n    #PID \n    iex> pid(0, 64, 2048)\n    #PID","ref":"IEx.Helpers.html#pid/3-examples"},{"type":"function","title":"IEx.Helpers.port/1","doc":"Creates a Port from `string`.","ref":"IEx.Helpers.html#port/1"},{"type":"function","title":"Examples - IEx.Helpers.port/1","doc":"iex> port(\"0.4\")\n    #Port","ref":"IEx.Helpers.html#port/1-examples"},{"type":"function","title":"IEx.Helpers.port/2","doc":"Creates a Port from two non-negative integers.","ref":"IEx.Helpers.html#port/2"},{"type":"function","title":"Examples - IEx.Helpers.port/2","doc":"iex> port(0, 8080)\n    #Port \n    iex> port(0, 443)\n    #Port","ref":"IEx.Helpers.html#port/2-examples"},{"type":"function","title":"IEx.Helpers.pwd/0","doc":"Prints the current working directory.","ref":"IEx.Helpers.html#pwd/0"},{"type":"function","title":"IEx.Helpers.r/1","doc":"Recompiles and reloads the given `module` or `modules`.\n\nPlease note that all the modules defined in the same file as\n`modules` are recompiled and reloaded. If you want to reload\nmultiple modules, it is best to reload them at the same time,\nsuch as in `r [Foo, Bar]`. This is important to avoid false\nwarnings, since the module is only reloaded in memory and its\nlatest information is not persisted to disk. See the \"In-memory\nreloading\" section below.\n\nThis function is meant to be used for development and\ndebugging purposes. Do not depend on it in production code.","ref":"IEx.Helpers.html#r/1"},{"type":"function","title":"In-memory reloading - IEx.Helpers.r/1","doc":"When we reload the module in IEx, we recompile the module source\ncode, updating its contents in memory. The original `.beam` file\nin disk, probably the one where the first definition of the module\ncame from, does not change at all.\n\nSince docs, typespecs, and exports information are loaded from the\n.beam file, they are not reloaded when you invoke this function.","ref":"IEx.Helpers.html#r/1-in-memory-reloading"},{"type":"function","title":"IEx.Helpers.recompile/1","doc":"Recompiles the current Mix project.\n\nThis helper only works when IEx is started with a Mix\nproject, for example, `iex -S mix`. Note this function\nsimply recompiles Elixir modules, without reloading\nconfiguration, recompiling dependencies, or restarting\napplications.\n\nTherefore, any long running process may crash on recompilation,\nas changed modules will be temporarily removed and recompiled,\nwithout going through the proper code change callback.\n\nIf you want to reload a single module, consider using\n`r(ModuleName)` instead.\n\nThis function is meant to be used for development and\ndebugging purposes. Do not depend on it in production code.","ref":"IEx.Helpers.html#recompile/1"},{"type":"function","title":"Options - IEx.Helpers.recompile/1","doc":"* `:force` - when `true`, forces the application to recompile","ref":"IEx.Helpers.html#recompile/1-options"},{"type":"function","title":"IEx.Helpers.ref/1","doc":"Creates a Reference from `string`.","ref":"IEx.Helpers.html#ref/1"},{"type":"function","title":"Examples - IEx.Helpers.ref/1","doc":"iex> ref(\"0.1.2.3\")\n    #Reference","ref":"IEx.Helpers.html#ref/1-examples"},{"type":"function","title":"IEx.Helpers.ref/4","doc":"Creates a Reference from its 4 non-negative integers components.","ref":"IEx.Helpers.html#ref/4"},{"type":"function","title":"Examples - IEx.Helpers.ref/4","doc":"iex> ref(0, 1, 2, 3)\n    #Reference","ref":"IEx.Helpers.html#ref/4-examples"},{"type":"function","title":"IEx.Helpers.remove_breaks/0","doc":"Removes all breakpoints and instrumentation from all modules.","ref":"IEx.Helpers.html#remove_breaks/0"},{"type":"function","title":"IEx.Helpers.remove_breaks/1","doc":"Removes all breakpoints and instrumentation from `module`.","ref":"IEx.Helpers.html#remove_breaks/1"},{"type":"function","title":"IEx.Helpers.reset_break/1","doc":"Sets the number of pending stops in the breakpoint\nwith the given `id` to zero.\n\nReturns `:ok` if there is such breakpoint ID. `:not_found`\notherwise.\n\nNote the module remains \"instrumented\" on reset. If you would\nlike to effectively remove all breakpoints and instrumentation\ncode from a module, use `remove_breaks/1` instead.","ref":"IEx.Helpers.html#reset_break/1"},{"type":"function","title":"IEx.Helpers.reset_break/3","doc":"Sets the number of pending stops in the given module,\nfunction and arity to zero.\n\nIf the module is not instrumented or if the given function\ndoes not have a breakpoint, it is a no-op and it returns\n`:not_found`. Otherwise it returns `:ok`.\n\nNote the module remains \"instrumented\" on reset. If you would\nlike to effectively remove all breakpoints and instrumentation\ncode from a module, use `remove_breaks/1` instead.","ref":"IEx.Helpers.html#reset_break/3"},{"type":"function","title":"IEx.Helpers.respawn/0","doc":"Respawns the current shell by starting a new shell process.","ref":"IEx.Helpers.html#respawn/0"},{"type":"function","title":"IEx.Helpers.runtime_info/0","doc":"Prints VM/runtime information such as versions, memory usage and statistics.\n\nAdditional topics are available via `runtime_info/1`.\n\nFor more metrics, info, and debugging facilities, see the\n[Recon](https://github.com/ferd/recon) project.","ref":"IEx.Helpers.html#runtime_info/0"},{"type":"function","title":"IEx.Helpers.runtime_info/1","doc":"Just like `runtime_info/0`, except accepts topic or a list of topics.\n\nFor example, topic `:applications` will list the applications loaded.","ref":"IEx.Helpers.html#runtime_info/1"},{"type":"macro","title":"IEx.Helpers.t/1","doc":"Prints the types for the given module or for the given function/arity pair.","ref":"IEx.Helpers.html#t/1"},{"type":"macro","title":"Examples - IEx.Helpers.t/1","doc":"iex> t(Enum)\n    @type t() :: Enumerable.t()\n    @type acc() :: any()\n    @type element() :: any()\n    @type index() :: integer()\n    @type default() :: any()\n\n    iex> t(Enum.t/0)\n    @type t() :: Enumerable.t()\n\n    iex> t(Enum.t)\n    @type t() :: Enumerable.t()","ref":"IEx.Helpers.html#t/1-examples"},{"type":"macro","title":"IEx.Helpers.use_if_available/2","doc":"Calls `use/2` with the given arguments, but only if the module is available.\n\nThis lets you use the module in `.iex.exs` files (including `~/.iex.exs`) without\ngetting compile errors if you open a console where the module is not available.","ref":"IEx.Helpers.html#use_if_available/2"},{"type":"macro","title":"Example - IEx.Helpers.use_if_available/2","doc":"# In ~/.iex.exs\n    use_if_available(Phoenix.HTML)","ref":"IEx.Helpers.html#use_if_available/2-example"},{"type":"function","title":"IEx.Helpers.v/1","doc":"Returns the value of the `n`th expression in the history.\n\n`n` can be a negative value: if it is, the corresponding expression value\nrelative to the current one is returned. For example, `v(-2)` returns the\nvalue of the expression evaluated before the last evaluated expression. In\nparticular, `v(-1)` returns the result of the last evaluated expression and\n`v()` does the same.","ref":"IEx.Helpers.html#v/1"},{"type":"function","title":"Examples - IEx.Helpers.v/1","doc":"iex(1)> \"hello\"   \" world\"\n    \"hello world\"\n    iex(2)> 40 + 2\n    42\n    iex(3)> v(-2)\n    \"hello world\"\n    iex(4)> v(2)\n    42\n    iex(5)> v()\n    42","ref":"IEx.Helpers.html#v/1-examples"},{"type":"function","title":"IEx.Helpers.whereami/1","doc":"Prints the current location and stacktrace in a pry session.\n\nIt expects a `radius` which chooses how many lines before and after\nthe current line we should print. By default the `radius` is of two\nlines:\n\n    Location: lib/iex/lib/iex/helpers.ex:79\n\n    77:\n    78:   def recompile do\n    79:     require IEx; IEx.pry()\n    80:     if mix_started?() do\n    81:       config = Mix.Project.config\n\n    (IEx.Helpers) lib/iex/lib/iex/helpers.ex:78: IEx.Helpers.recompile/0\n\nThis command only works inside a pry session started manually\nvia `IEx.pry/0` or a breakpoint set via `IEx.break!/4`. Calling\nthis function during a regular `IEx` session will print an error.\n\nKeep in mind the `whereami/1` location may not exist when prying\nprecompiled source code, such as Elixir itself.","ref":"IEx.Helpers.html#whereami/1"},{"type":"protocol","title":"IEx.Info","doc":"A protocol to print information in IEx about the given datastructure.\n\n`IEx.Helpers.i/1` uses this protocol to display a term-specific list\nof of information.\n\nBy default, an `Any` implementation will be used which returns\nthe `\"Data type\"`, `\"Description\"` and `\"Reference modules\"` sections.","ref":"IEx.Info.html"},{"type":"function","title":"IEx.Info.info/1","doc":"Returns information for the given term.\n\nInformation should be returned as a list of `info_name`-`info` tuples,\nwhere `info_name` is a string-like value, such as an atom or a string\nitself, and `info` is a string. `info_name` should be short. `info` can\nbe arbitrarily long and contain newlines.\n\n`IEx.Helpers.i/1` will generate (and always display)\nthe 'Implemented protocols' and 'Term' sections in the result.\n\nAll other sections of information are added (and can be overridden)\nby customized implementations of this function.\n\nIt is recommended to at least include the following sections for a\ncustom implementation:\n\n  * `\"Data type\"`: Name of the data type. Usually the name of the module\n     defining the data type.\n  * `\"Description\"`: One or a few sentences describing what the data type represents.\n  * `\"Reference modules`: One or a few comma-separated module names that focus\n    on working with this datatype.\n\nOther recommended sections are:\n\n  * `\"Raw representation`: showing another way of writing the passed `term`.\n    This is mostly relevant for data-structures whose `String.Chars`-implementations\n    make use of sigils or other syntactic sugar.","ref":"IEx.Info.html#info/1"},{"type":"type","title":"IEx.Info.t/0","doc":"All the types that implement this protocol.","ref":"IEx.Info.html#t:t/0"},{"type":"module","title":"IEx.Pry","doc":"The low-level API for prying sessions and setting up breakpoints.","ref":"IEx.Pry.html"},{"type":"function","title":"IEx.Pry.break/4","doc":"Sets up a breakpoint on the given module/function/arity.","ref":"IEx.Pry.html#break/4"},{"type":"function","title":"IEx.Pry.break/6","doc":"Sets up a breakpoint on the given module/function/args with the given `guard`.\n\nIt requires an `env` to be given to make the expansion of the guards.","ref":"IEx.Pry.html#break/6"},{"type":"function","title":"IEx.Pry.break!/4","doc":"Raising variant of `break/4`.","ref":"IEx.Pry.html#break!/4"},{"type":"function","title":"IEx.Pry.break!/6","doc":"Raising variant of `break/6`.","ref":"IEx.Pry.html#break!/6"},{"type":"function","title":"IEx.Pry.breaks/0","doc":"Returns all breakpoints.","ref":"IEx.Pry.html#breaks/0"},{"type":"function","title":"IEx.Pry.pry/2","doc":"Callback for `IEx.pry/0`.\n\nYou can invoke this function directly when you are not able to invoke\n`IEx.pry/0` as a macro. This function expects the binding (from\n`binding/0`) and the environment (from `__ENV__/0`).","ref":"IEx.Pry.html#pry/2"},{"type":"function","title":"IEx.Pry.remove_breaks/0","doc":"Removes all breakpoints on all modules.\n\nThis effectively loads the non-instrumented version of\ncurrently instrumented modules into memory.","ref":"IEx.Pry.html#remove_breaks/0"},{"type":"function","title":"IEx.Pry.remove_breaks/1","doc":"Removes breakpoints in the given module.\n\nThis effectively loads the non-instrumented version of\nthe module into memory.","ref":"IEx.Pry.html#remove_breaks/1"},{"type":"function","title":"IEx.Pry.reset_break/1","doc":"Resets the breaks on a given breakpoint ID.","ref":"IEx.Pry.html#reset_break/1"},{"type":"function","title":"IEx.Pry.reset_break/3","doc":"Resets the breaks for the given `module`, `function` and `arity`.\n\nIf the `module` is not instrumented or if the given `function`\ndoes not have a breakpoint, it is a no-op and it returns\n`:not_found`. Otherwise it returns `:ok`.","ref":"IEx.Pry.html#reset_break/3"},{"type":"function","title":"IEx.Pry.whereami/3","doc":"Formats the location for `whereami/3` prying.\n\nIt receives the `file`, `line` and the snippet `radius` and\nreturns `{:ok, lines}`, where lines is a list of chardata\ncontaining each formatted line, or `:error`.\n\nThe actual line is especially formatted in bold.","ref":"IEx.Pry.html#whereami/3"},{"type":"type","title":"IEx.Pry.break/0","doc":"","ref":"IEx.Pry.html#t:break/0"},{"type":"type","title":"IEx.Pry.break_error/0","doc":"","ref":"IEx.Pry.html#t:break_error/0"},{"type":"type","title":"IEx.Pry.id/0","doc":"","ref":"IEx.Pry.html#t:id/0"},{"type":"module","title":"IEx.Server","doc":"The IEx.Server.\n\nThe server responsibilities include:\n\n  * reading input from the group leader and writing to the group leader\n  * sending messages to the evaluator\n  * taking over the evaluator process when using `IEx.pry/0` or setting up breakpoints","ref":"IEx.Server.html"},{"type":"function","title":"IEx.Server.run/1","doc":"Starts a new IEx server session.\n\nThe accepted options are:\n\n  * `:prefix` - the IEx prefix\n  * `:env` - the `Macro.Env` used for the evaluator\n  * `:binding` - an initial set of variables for the evaluator\n  * `:on_eof` - if it should `:stop_evaluator` (default) or `:halt` the system\n  * `:register` - if this shell should be registered in the broker (default is `true`)","ref":"IEx.Server.html#run/1"}],"content_type":"text/markdown"}