# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActiveDirectoryObject(_serialization.Model):
    """The Active Directory Object that will be used for authenticating the token of a container
    registry.

    :ivar object_id: The user/group/application object ID for Active Directory Object that will be
     used for authenticating the token of a container registry.
    :vartype object_id: str
    :ivar tenant_id: The tenant ID of user/group/application object Active Directory Object that
     will be used for authenticating the token of a container registry.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "object_id": {"key": "objectId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, object_id: Optional[str] = None, tenant_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword object_id: The user/group/application object ID for Active Directory Object that will
         be used for authenticating the token of a container registry.
        :paramtype object_id: str
        :keyword tenant_id: The tenant ID of user/group/application object Active Directory Object that
         will be used for authenticating the token of a container registry.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class Actor(_serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization
    context of the request.

    :ivar name: The subject or username associated with the request context that generated the
     event.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The subject or username associated with the request context that generated the
         event.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class AuthCredential(_serialization.Model):
    """Authentication credential stored for an upstream.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential. "Credential1"
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.CredentialName
    :ivar username_secret_identifier: KeyVault Secret URI for accessing the username.
    :vartype username_secret_identifier: str
    :ivar password_secret_identifier: KeyVault Secret URI for accessing the password.
    :vartype password_secret_identifier: str
    :ivar credential_health: This provides data pertaining to the health of the auth credential.
    :vartype credential_health: ~azure.mgmt.containerregistry.v2023_07_01.models.CredentialHealth
    """

    _validation = {
        "credential_health": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "username_secret_identifier": {"key": "usernameSecretIdentifier", "type": "str"},
        "password_secret_identifier": {"key": "passwordSecretIdentifier", "type": "str"},
        "credential_health": {"key": "credentialHealth", "type": "CredentialHealth"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.CredentialName"]] = None,
        username_secret_identifier: Optional[str] = None,
        password_secret_identifier: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the credential. "Credential1"
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.CredentialName
        :keyword username_secret_identifier: KeyVault Secret URI for accessing the username.
        :paramtype username_secret_identifier: str
        :keyword password_secret_identifier: KeyVault Secret URI for accessing the password.
        :paramtype password_secret_identifier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.username_secret_identifier = username_secret_identifier
        self.password_secret_identifier = password_secret_identifier
        self.credential_health = None


class ProxyResource(_serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class CacheRule(ProxyResource):
    """An object that represents a cache rule for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar credential_set_resource_id: The ARM resource ID of the credential store which is
     associated with the cache rule.
    :vartype credential_set_resource_id: str
    :ivar source_repository: Source repository pulled from upstream.
    :vartype source_repository: str
    :ivar target_repository: Target repository specified in docker pull command.
     Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
    :vartype target_repository: str
    :ivar creation_date: The creation date of the cache rule.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "credential_set_resource_id": {"key": "properties.credentialSetResourceId", "type": "str"},
        "source_repository": {"key": "properties.sourceRepository", "type": "str"},
        "target_repository": {"key": "properties.targetRepository", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        credential_set_resource_id: Optional[str] = None,
        source_repository: Optional[str] = None,
        target_repository: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword credential_set_resource_id: The ARM resource ID of the credential store which is
         associated with the cache rule.
        :paramtype credential_set_resource_id: str
        :keyword source_repository: Source repository pulled from upstream.
        :paramtype source_repository: str
        :keyword target_repository: Target repository specified in docker pull command.
         Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}.
        :paramtype target_repository: str
        """
        super().__init__(**kwargs)
        self.credential_set_resource_id = credential_set_resource_id
        self.source_repository = source_repository
        self.target_repository = target_repository
        self.creation_date = None
        self.provisioning_state = None


class CacheRulesListResult(_serialization.Model):
    """The result of a request to list cache rules for a container registry.

    :ivar value: The list of cache rules.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.CacheRule]
    :ivar next_link: If provided, client must use NextLink URI to request next list of cache rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CacheRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CacheRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of cache rules.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.CacheRule]
        :keyword next_link: If provided, client must use NextLink URI to request next list of cache
         rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CacheRuleUpdateParameters(_serialization.Model):
    """The parameters for updating a cache rule.

    :ivar credential_set_resource_id: The ARM resource ID of the credential store which is
     associated with the Cache rule.
    :vartype credential_set_resource_id: str
    """

    _attribute_map = {
        "credential_set_resource_id": {"key": "properties.credentialSetResourceId", "type": "str"},
    }

    def __init__(self, *, credential_set_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword credential_set_resource_id: The ARM resource ID of the credential store which is
         associated with the Cache rule.
        :paramtype credential_set_resource_id: str
        """
        super().__init__(**kwargs)
        self.credential_set_resource_id = credential_set_resource_id


class CallbackConfig(_serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :ivar service_uri: The service URI for the webhook to post notifications. Required.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    """

    _validation = {
        "service_uri": {"required": True},
    }

    _attribute_map = {
        "service_uri": {"key": "serviceUri", "type": "str"},
        "custom_headers": {"key": "customHeaders", "type": "{str}"},
    }

    def __init__(self, *, service_uri: str, custom_headers: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword service_uri: The service URI for the webhook to post notifications. Required.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        """
        super().__init__(**kwargs)
        self.service_uri = service_uri
        self.custom_headers = custom_headers


class CredentialHealth(_serialization.Model):
    """The health of the auth credential.

    :ivar status: The health status of credential. Known values are: "Healthy" and "Unhealthy".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.CredentialHealthStatus
    :ivar error_code: Error code representing the health check error.
    :vartype error_code: str
    :ivar error_message: Descriptive message representing the health check error.
    :vartype error_message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.CredentialHealthStatus"]] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The health status of credential. Known values are: "Healthy" and "Unhealthy".
        :paramtype status: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.CredentialHealthStatus
        :keyword error_code: Error code representing the health check error.
        :paramtype error_code: str
        :keyword error_message: Descriptive message representing the health check error.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.error_code = error_code
        self.error_message = error_message


class CredentialSet(ProxyResource):
    """An object that represents a credential set resource for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar identity: Identities associated with the resource. This is used to access the KeyVault
     secrets.
    :vartype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
    :ivar login_server: The credentials are stored for this upstream or login server.
    :vartype login_server: str
    :ivar auth_credentials: List of authentication credentials stored for an upstream.
     Usually consists of a primary and an optional secondary credential.
    :vartype auth_credentials:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.AuthCredential]
    :ivar creation_date: The creation date of credential store resource.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "login_server": {"key": "properties.loginServer", "type": "str"},
        "auth_credentials": {"key": "properties.authCredentials", "type": "[AuthCredential]"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        login_server: Optional[str] = None,
        auth_credentials: Optional[List["_models.AuthCredential"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identities associated with the resource. This is used to access the KeyVault
         secrets.
        :paramtype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
        :keyword login_server: The credentials are stored for this upstream or login server.
        :paramtype login_server: str
        :keyword auth_credentials: List of authentication credentials stored for an upstream.
         Usually consists of a primary and an optional secondary credential.
        :paramtype auth_credentials:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.AuthCredential]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.login_server = login_server
        self.auth_credentials = auth_credentials
        self.creation_date = None
        self.provisioning_state = None


class CredentialSetListResult(_serialization.Model):
    """The result of a request to list credential sets for a container registry.

    :ivar value: The list of credential sets. Since this list may be incomplete, the nextLink field
     should be used to request the next list of credential sets.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.CredentialSet]
    :ivar next_link: The URI that can be used to request the next list of credential sets.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CredentialSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CredentialSet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of credential sets. Since this list may be incomplete, the nextLink
         field should be used to request the next list of credential sets.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.CredentialSet]
        :keyword next_link: The URI that can be used to request the next list of credential sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CredentialSetUpdateParameters(_serialization.Model):
    """The parameters for updating a credential set.

    :ivar identity: Identities associated with the resource. This is used to access the KeyVault
     secrets.
    :vartype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
    :ivar auth_credentials: List of authentication credentials stored for an upstream.
     Usually consists of a primary and an optional secondary credential.
    :vartype auth_credentials:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.AuthCredential]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "auth_credentials": {"key": "properties.authCredentials", "type": "[AuthCredential]"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        auth_credentials: Optional[List["_models.AuthCredential"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identities associated with the resource. This is used to access the KeyVault
         secrets.
        :paramtype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
        :keyword auth_credentials: List of authentication credentials stored for an upstream.
         Usually consists of a primary and an optional secondary credential.
        :paramtype auth_credentials:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.AuthCredential]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.auth_credentials = auth_credentials


class EncryptionProperty(_serialization.Model):
    """EncryptionProperty.

    :ivar status: Indicates whether or not the encryption is enabled for container registry. Known
     values are: "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionStatus
    :ivar key_vault_properties: Key vault properties.
    :vartype key_vault_properties:
     ~azure.mgmt.containerregistry.v2023_07_01.models.KeyVaultProperties
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.EncryptionStatus"]] = None,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether or not the encryption is enabled for container registry.
         Known values are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionStatus
        :keyword key_vault_properties: Key vault properties.
        :paramtype key_vault_properties:
         ~azure.mgmt.containerregistry.v2023_07_01.models.KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.status = status
        self.key_vault_properties = key_vault_properties


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerregistry.v2023_07_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerregistry.v2023_07_01.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.containerregistry.v2023_07_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventInfo(_serialization.Model):
    """The basic information of an event.

    :ivar id: The event ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The event ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Event(EventInfo):
    """The event for a webhook.

    :ivar id: The event ID.
    :vartype id: str
    :ivar event_request_message: The event request message sent to the service URI.
    :vartype event_request_message:
     ~azure.mgmt.containerregistry.v2023_07_01.models.EventRequestMessage
    :ivar event_response_message: The event response message received from the service URI.
    :vartype event_response_message:
     ~azure.mgmt.containerregistry.v2023_07_01.models.EventResponseMessage
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "event_request_message": {"key": "eventRequestMessage", "type": "EventRequestMessage"},
        "event_response_message": {"key": "eventResponseMessage", "type": "EventResponseMessage"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        event_request_message: Optional["_models.EventRequestMessage"] = None,
        event_response_message: Optional["_models.EventResponseMessage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword event_request_message: The event request message sent to the service URI.
        :paramtype event_request_message:
         ~azure.mgmt.containerregistry.v2023_07_01.models.EventRequestMessage
        :keyword event_response_message: The event response message received from the service URI.
        :paramtype event_response_message:
         ~azure.mgmt.containerregistry.v2023_07_01.models.EventResponseMessage
        """
        super().__init__(id=id, **kwargs)
        self.event_request_message = event_request_message
        self.event_response_message = event_response_message


class EventContent(_serialization.Model):
    """The content of the event request message.

    :ivar id: The event ID.
    :vartype id: str
    :ivar timestamp: The time at which the event occurred.
    :vartype timestamp: ~datetime.datetime
    :ivar action: The action that encompasses the provided event.
    :vartype action: str
    :ivar target: The target of the event.
    :vartype target: ~azure.mgmt.containerregistry.v2023_07_01.models.Target
    :ivar request: The request that generated the event.
    :vartype request: ~azure.mgmt.containerregistry.v2023_07_01.models.Request
    :ivar actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :vartype actor: ~azure.mgmt.containerregistry.v2023_07_01.models.Actor
    :ivar source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :vartype source: ~azure.mgmt.containerregistry.v2023_07_01.models.Source
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "action": {"key": "action", "type": "str"},
        "target": {"key": "target", "type": "Target"},
        "request": {"key": "request", "type": "Request"},
        "actor": {"key": "actor", "type": "Actor"},
        "source": {"key": "source", "type": "Source"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["_models.Target"] = None,
        request: Optional["_models.Request"] = None,
        actor: Optional["_models.Actor"] = None,
        source: Optional["_models.Source"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword timestamp: The time at which the event occurred.
        :paramtype timestamp: ~datetime.datetime
        :keyword action: The action that encompasses the provided event.
        :paramtype action: str
        :keyword target: The target of the event.
        :paramtype target: ~azure.mgmt.containerregistry.v2023_07_01.models.Target
        :keyword request: The request that generated the event.
        :paramtype request: ~azure.mgmt.containerregistry.v2023_07_01.models.Request
        :keyword actor: The agent that initiated the event. For most situations, this could be from the
         authorization context of the request.
        :paramtype actor: ~azure.mgmt.containerregistry.v2023_07_01.models.Actor
        :keyword source: The registry node that generated the event. Put differently, while the actor
         initiates the event, the source generates it.
        :paramtype source: ~azure.mgmt.containerregistry.v2023_07_01.models.Source
        """
        super().__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class EventListResult(_serialization.Model):
    """The result of a request to list events for a webhook.

    :ivar value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Event]
    :ivar next_link: The URI that can be used to request the next list of events.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Event]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Event"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of events. Since this list may be incomplete, the nextLink field
         should be used to request the next list of events.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Event]
        :keyword next_link: The URI that can be used to request the next list of events.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventRequestMessage(_serialization.Model):
    """The event request message sent to the service URI.

    :ivar content: The content of the event request message.
    :vartype content: ~azure.mgmt.containerregistry.v2023_07_01.models.EventContent
    :ivar headers: The headers of the event request message.
    :vartype headers: dict[str, str]
    :ivar method: The HTTP method used to send the event request message.
    :vartype method: str
    :ivar request_uri: The URI used to send the event request message.
    :vartype request_uri: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "EventContent"},
        "headers": {"key": "headers", "type": "{str}"},
        "method": {"key": "method", "type": "str"},
        "request_uri": {"key": "requestUri", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional["_models.EventContent"] = None,
        headers: Optional[Dict[str, str]] = None,
        method: Optional[str] = None,
        request_uri: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the event request message.
        :paramtype content: ~azure.mgmt.containerregistry.v2023_07_01.models.EventContent
        :keyword headers: The headers of the event request message.
        :paramtype headers: dict[str, str]
        :keyword method: The HTTP method used to send the event request message.
        :paramtype method: str
        :keyword request_uri: The URI used to send the event request message.
        :paramtype request_uri: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.method = method
        self.request_uri = request_uri
        self.version = version


class EventResponseMessage(_serialization.Model):
    """The event response message received from the service URI.

    :ivar content: The content of the event response message.
    :vartype content: str
    :ivar headers: The headers of the event response message.
    :vartype headers: dict[str, str]
    :ivar reason_phrase: The reason phrase of the event response message.
    :vartype reason_phrase: str
    :ivar status_code: The status code of the event response message.
    :vartype status_code: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "headers": {"key": "headers", "type": "{str}"},
        "reason_phrase": {"key": "reasonPhrase", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        reason_phrase: Optional[str] = None,
        status_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the event response message.
        :paramtype content: str
        :keyword headers: The headers of the event response message.
        :paramtype headers: dict[str, str]
        :keyword reason_phrase: The reason phrase of the event response message.
        :paramtype reason_phrase: str
        :keyword status_code: The status code of the event response message.
        :paramtype status_code: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.reason_phrase = reason_phrase
        self.status_code = status_code
        self.version = version


class ExportPolicy(_serialization.Model):
    """The export policy for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ExportPolicyStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Union[str, "_models.ExportPolicyStatus"] = "enabled", **kwargs: Any) -> None:
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ExportPolicyStatus
        """
        super().__init__(**kwargs)
        self.status = status


class GenerateCredentialsParameters(_serialization.Model):
    """The parameters used to generate credentials for a specified token or user of a container
    registry.

    :ivar token_id: The resource ID of the token for which credentials have to be generated.
    :vartype token_id: str
    :ivar expiry: The expiry date of the generated credentials after which the credentials become
     invalid.
    :vartype expiry: ~datetime.datetime
    :ivar name: Specifies name of the password which should be regenerated if any -- password1 or
     password2. Known values are: "password1" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenPasswordName
    """

    _attribute_map = {
        "token_id": {"key": "tokenId", "type": "str"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        token_id: Optional[str] = None,
        expiry: Optional[datetime.datetime] = None,
        name: Optional[Union[str, "_models.TokenPasswordName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword token_id: The resource ID of the token for which credentials have to be generated.
        :paramtype token_id: str
        :keyword expiry: The expiry date of the generated credentials after which the credentials
         become invalid.
        :paramtype expiry: ~datetime.datetime
        :keyword name: Specifies name of the password which should be regenerated if any -- password1
         or password2. Known values are: "password1" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenPasswordName
        """
        super().__init__(**kwargs)
        self.token_id = token_id
        self.expiry = expiry
        self.name = name


class GenerateCredentialsResult(_serialization.Model):
    """The response from the GenerateCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenPassword]
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[TokenPassword]"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["_models.TokenPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenPassword]
        """
        super().__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class IdentityProperties(_serialization.Model):
    """Managed identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerregistry.v2023_07_01.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity
         dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
             providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerregistry.v2023_07_01.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ImportImageParameters(_serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar source: The source of the image. Required.
    :vartype source: ~azure.mgmt.containerregistry.v2023_07_01.models.ImportSource
    :ivar target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :vartype target_tags: list[str]
    :ivar untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :vartype untagged_target_repositories: list[str]
    :ivar mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Known values are:
     "NoForce" and "Force".
    :vartype mode: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ImportMode
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "ImportSource"},
        "target_tags": {"key": "targetTags", "type": "[str]"},
        "untagged_target_repositories": {"key": "untaggedTargetRepositories", "type": "[str]"},
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: "_models.ImportSource",
        target_tags: Optional[List[str]] = None,
        untagged_target_repositories: Optional[List[str]] = None,
        mode: Union[str, "_models.ImportMode"] = "NoForce",
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the image. Required.
        :paramtype source: ~azure.mgmt.containerregistry.v2023_07_01.models.ImportSource
        :keyword target_tags: List of strings of the form repo[:tag]. When tag is omitted the source
         will be used (or 'latest' if source tag is also omitted).
        :paramtype target_tags: list[str]
        :keyword untagged_target_repositories: List of strings of repository names to do a manifest
         only copy. No tag will be created.
        :paramtype untagged_target_repositories: list[str]
        :keyword mode: When Force, any existing target tags will be overwritten. When NoForce, any
         existing target tags will fail the operation before any copying begins. Known values are:
         "NoForce" and "Force".
        :paramtype mode: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ImportMode
        """
        super().__init__(**kwargs)
        self.source = source
        self.target_tags = target_tags
        self.untagged_target_repositories = untagged_target_repositories
        self.mode = mode


class ImportSource(_serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The resource identifier of the source Azure Container Registry.
    :vartype resource_id: str
    :ivar registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :vartype registry_uri: str
    :ivar credentials: Credentials used when importing from a registry uri.
    :vartype credentials: ~azure.mgmt.containerregistry.v2023_07_01.models.ImportSourceCredentials
    :ivar source_image: Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123'). Required.
    :vartype source_image: str
    """

    _validation = {
        "source_image": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "registry_uri": {"key": "registryUri", "type": "str"},
        "credentials": {"key": "credentials", "type": "ImportSourceCredentials"},
        "source_image": {"key": "sourceImage", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_image: str,
        resource_id: Optional[str] = None,
        registry_uri: Optional[str] = None,
        credentials: Optional["_models.ImportSourceCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource identifier of the source Azure Container Registry.
        :paramtype resource_id: str
        :keyword registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
        :paramtype registry_uri: str
        :keyword credentials: Credentials used when importing from a registry uri.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2023_07_01.models.ImportSourceCredentials
        :keyword source_image: Repository name of the source image.
         Specify an image by repository ('hello-world'). This will use the 'latest' tag.
         Specify an image by tag ('hello-world:latest').
         Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123'). Required.
        :paramtype source_image: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.registry_uri = registry_uri
        self.credentials = credentials
        self.source_image = source_image


class ImportSourceCredentials(_serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar username: The username to authenticate with the source registry.
    :vartype username: str
    :ivar password: The password used to authenticate with the source registry. Required.
    :vartype password: str
    """

    _validation = {
        "password": {"required": True},
    }

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(self, *, password: str, username: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The username to authenticate with the source registry.
        :paramtype username: str
        :keyword password: The password used to authenticate with the source registry. Required.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class IPRule(_serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar action: The action of IP ACL rule. "Allow"
    :vartype action: str or ~azure.mgmt.containerregistry.v2023_07_01.models.Action
    :ivar ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
     allowed. Required.
    :vartype ip_address_or_range: str
    """

    _validation = {
        "ip_address_or_range": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "ip_address_or_range": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, ip_address_or_range: str, action: Union[str, "_models.Action"] = "Allow", **kwargs: Any
    ) -> None:
        """
        :keyword action: The action of IP ACL rule. "Allow"
        :paramtype action: str or ~azure.mgmt.containerregistry.v2023_07_01.models.Action
        :keyword ip_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is
         allowed. Required.
        :paramtype ip_address_or_range: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.ip_address_or_range = ip_address_or_range


class KeyVaultProperties(_serialization.Model):
    """KeyVaultProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_identifier: Key vault uri to access the encryption key.
    :vartype key_identifier: str
    :ivar versioned_key_identifier: The fully qualified key identifier that includes the version of
     the key that is actually used for encryption.
    :vartype versioned_key_identifier: str
    :ivar identity: The client id of the identity which will be used to access key vault.
    :vartype identity: str
    :ivar key_rotation_enabled: Auto key rotation status for a CMK enabled registry.
    :vartype key_rotation_enabled: bool
    :ivar last_key_rotation_timestamp: Timestamp of the last successful key rotation.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        "versioned_key_identifier": {"readonly": True},
        "key_rotation_enabled": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "versioned_key_identifier": {"key": "versionedKeyIdentifier", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
        "key_rotation_enabled": {"key": "keyRotationEnabled", "type": "bool"},
        "last_key_rotation_timestamp": {"key": "lastKeyRotationTimestamp", "type": "iso-8601"},
    }

    def __init__(self, *, key_identifier: Optional[str] = None, identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_identifier: Key vault uri to access the encryption key.
        :paramtype key_identifier: str
        :keyword identity: The client id of the identity which will be used to access key vault.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.key_identifier = key_identifier
        self.versioned_key_identifier = None
        self.identity = identity
        self.key_rotation_enabled = None
        self.last_key_rotation_timestamp = None


class NetworkRuleSet(_serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :ivar default_action: The default action of allow or deny when no other rules match. Known
     values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.containerregistry.v2023_07_01.models.DefaultAction
    :ivar ip_rules: The IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.containerregistry.v2023_07_01.models.IPRule]
    """

    _validation = {
        "default_action": {"required": True},
    }

    _attribute_map = {
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[IPRule]"},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "_models.DefaultAction"] = "Allow",
        ip_rules: Optional[List["_models.IPRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_action: The default action of allow or deny when no other rules match. Known
         values are: "Allow" and "Deny".
        :paramtype default_action: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.DefaultAction
        :keyword ip_rules: The IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.containerregistry.v2023_07_01.models.IPRule]
        """
        super().__init__(**kwargs)
        self.default_action = default_action
        self.ip_rules = ip_rules


class OperationDefinition(_serialization.Model):
    """The definition of a container registry operation.

    :ivar origin: The origin information of the container registry operation.
    :vartype origin: str
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The display information for the container registry operation.
    :vartype display: ~azure.mgmt.containerregistry.v2023_07_01.models.OperationDisplayDefinition
    :ivar is_data_action: This property indicates if the operation is an action or a data action
     ref:
     https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations.
    :vartype is_data_action: bool
    :ivar service_specification: The definition of Azure Monitoring service.
    :vartype service_specification:
     ~azure.mgmt.containerregistry.v2023_07_01.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayDefinition"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "OperationServiceSpecificationDefinition",
        },
    }

    def __init__(
        self,
        *,
        origin: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplayDefinition"] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["_models.OperationServiceSpecificationDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword origin: The origin information of the container registry operation.
        :paramtype origin: str
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The display information for the container registry operation.
        :paramtype display: ~azure.mgmt.containerregistry.v2023_07_01.models.OperationDisplayDefinition
        :keyword is_data_action: This property indicates if the operation is an action or a data action
         ref:
         https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#management-and-data-operations.
        :paramtype is_data_action: bool
        :keyword service_specification: The definition of Azure Monitoring service.
        :paramtype service_specification:
         ~azure.mgmt.containerregistry.v2023_07_01.models.OperationServiceSpecificationDefinition
        """
        super().__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplayDefinition(_serialization.Model):
    """The display information for a container registry operation.

    :ivar provider: The resource provider name: Microsoft.ContainerRegistry.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The resource provider name: Microsoft.ContainerRegistry.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """The result of a request to list container registry operations.

    :ivar value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationDefinition]
    :ivar next_link: The URI that can be used to request the next list of container registry
     operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OperationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registry operations. Since this list may be incomplete,
         the nextLink field should be used to request the next list of operations.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationDefinition]
        :keyword next_link: The URI that can be used to request the next list of container registry
         operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationLogSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring log.

    :ivar name: Log name.
    :vartype name: str
    :ivar display_name: Log display name.
    :vartype display_name: str
    :ivar blob_duration: Log blob duration.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Log name.
        :paramtype name: str
        :keyword display_name: Log display name.
        :paramtype display_name: str
        :keyword blob_duration: Log blob duration.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class OperationMetricSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring metric.

    :ivar name: Metric name.
    :vartype name: str
    :ivar display_name: Metric display name.
    :vartype display_name: str
    :ivar display_description: Metric description.
    :vartype display_description: str
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar aggregation_type: Metric aggregation type.
    :vartype aggregation_type: str
    :ivar internal_metric_name: Internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metric name.
        :paramtype name: str
        :keyword display_name: Metric display name.
        :paramtype display_name: str
        :keyword display_description: Metric description.
        :paramtype display_description: str
        :keyword unit: Metric unit.
        :paramtype unit: str
        :keyword aggregation_type: Metric aggregation type.
        :paramtype aggregation_type: str
        :keyword internal_metric_name: Internal metric name.
        :paramtype internal_metric_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name


class OperationServiceSpecificationDefinition(_serialization.Model):
    """The definition of Azure Monitoring list.

    :ivar metric_specifications: A list of Azure Monitoring metrics definition.
    :vartype metric_specifications:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationMetricSpecificationDefinition]
    :ivar log_specifications: A list of Azure Monitoring log definitions.
    :vartype log_specifications:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationLogSpecificationDefinition]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[OperationMetricSpecificationDefinition]"},
        "log_specifications": {"key": "logSpecifications", "type": "[OperationLogSpecificationDefinition]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.OperationMetricSpecificationDefinition"]] = None,
        log_specifications: Optional[List["_models.OperationLogSpecificationDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: A list of Azure Monitoring metrics definition.
        :paramtype metric_specifications:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationMetricSpecificationDefinition]
        :keyword log_specifications: A list of Azure Monitoring log definitions.
        :paramtype log_specifications:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.OperationLogSpecificationDefinition]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class PackageType(_serialization.Model):
    """The properties of a package type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the package type.
    :vartype name: str
    :ivar endpoint: The endpoint of the package type.
    :vartype endpoint: str
    """

    _validation = {
        "endpoint": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the package type.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.endpoint = None


class Policies(_serialization.Model):
    """The policies for a container registry.

    :ivar quarantine_policy: The quarantine policy for a container registry.
    :vartype quarantine_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.QuarantinePolicy
    :ivar trust_policy: The content trust policy for a container registry.
    :vartype trust_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.TrustPolicy
    :ivar retention_policy: The retention policy for a container registry.
    :vartype retention_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.RetentionPolicy
    :ivar export_policy: The export policy for a container registry.
    :vartype export_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.ExportPolicy
    """

    _attribute_map = {
        "quarantine_policy": {"key": "quarantinePolicy", "type": "QuarantinePolicy"},
        "trust_policy": {"key": "trustPolicy", "type": "TrustPolicy"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
        "export_policy": {"key": "exportPolicy", "type": "ExportPolicy"},
    }

    def __init__(
        self,
        *,
        quarantine_policy: Optional["_models.QuarantinePolicy"] = None,
        trust_policy: Optional["_models.TrustPolicy"] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        export_policy: Optional["_models.ExportPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword quarantine_policy: The quarantine policy for a container registry.
        :paramtype quarantine_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.QuarantinePolicy
        :keyword trust_policy: The content trust policy for a container registry.
        :paramtype trust_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.TrustPolicy
        :keyword retention_policy: The retention policy for a container registry.
        :paramtype retention_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.RetentionPolicy
        :keyword export_policy: The export policy for a container registry.
        :paramtype export_policy: ~azure.mgmt.containerregistry.v2023_07_01.models.ExportPolicy
        """
        super().__init__(**kwargs)
        self.quarantine_policy = quarantine_policy
        self.trust_policy = trust_policy
        self.retention_policy = retention_policy
        self.export_policy = export_policy


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    :ivar id: This is private endpoint resource created with Microsoft.Network resource provider.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: This is private endpoint resource created with Microsoft.Network resource
         provider.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(ProxyResource):
    """An object that represents a private endpoint connection for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.containerregistry.v2023_07_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.containerregistry.v2023_07_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of private endpoint connection resource. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.containerregistry.v2023_07_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.containerregistry.v2023_07_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """The result of a request to list private endpoint connections for a container registry.

    :ivar value: The list of private endpoint connections. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private endpoint connections.
    :vartype value:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.PrivateEndpointConnection]
    :ivar next_link: The URI that can be used to request the next list of private endpoint
     connections.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of private endpoint connections. Since this list may be incomplete,
         the nextLink field should be used to request the next list of private endpoint connections.
        :paramtype value:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.PrivateEndpointConnection]
        :keyword next_link: The URI that can be used to request the next list of private endpoint
         connections.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """A resource that supports private link capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The resource type is private link resource.
    :vartype type: str
    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The resource ID.
        :paramtype id: str
        :keyword name: The name of the resource.
        :paramtype name: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword required_members: The private link resource required member names.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.type = None
        self.id = id
        self.name = name
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """The result of a request to list private link resources for a container registry.

    :ivar value: The list of private link resources. Since this list may be incomplete, the
     nextLink field should be used to request the next list of private link resources.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.PrivateLinkResource]
    :ivar next_link: The URI that can be used to request the next list of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of private link resources. Since this list may be incomplete, the
         nextLink field should be used to request the next list of private link resources.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.PrivateLinkResource]
        :keyword next_link: The URI that can be used to request the next list of private link
         resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The state of a private link service connection.

    :ivar status: The private link service connection status. Known values are: "Approved",
     "Pending", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ConnectionStatus
    :ivar description: The description for connection status. For example if connection is rejected
     it can indicate reason for rejection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. Known values are: "None" and "Recreate".
    :vartype actions_required: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ActionsRequired
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "_models.ActionsRequired"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Known values are: "Approved",
         "Pending", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.ConnectionStatus
        :keyword description: The description for connection status. For example if connection is
         rejected it can indicate reason for rejection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer. Known values are: "None" and "Recreate".
        :paramtype actions_required: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.ActionsRequired
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class QuarantinePolicy(_serialization.Model):
    """The quarantine policy for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.PolicyStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.status = status


class RegenerateCredentialParameters(_serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Specifies name of the password which should be regenerated -- password or
     password2. Required. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PasswordName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.PasswordName"], **kwargs: Any) -> None:
        """
        :keyword name: Specifies name of the password which should be regenerated -- password or
         password2. Required. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PasswordName
        """
        super().__init__(**kwargs)
        self.name = name


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None


class Registry(Resource):  # pylint: disable=too-many-instance-attributes
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar sku: The SKU of the container registry. Required.
    :vartype sku: ~azure.mgmt.containerregistry.v2023_07_01.models.Sku
    :ivar identity: The identity of the container registry.
    :vartype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Known values are: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2023_07_01.models.Status
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set: ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2023_07_01.models.Policies
    :ivar encryption: The encryption settings of container registry.
    :vartype encryption: ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionProperty
    :ivar data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :vartype data_endpoint_enabled: bool
    :ivar data_endpoint_host_names: List of host names that will serve data when
     dataEndpointEnabled is true.
    :vartype data_endpoint_host_names: list[str]
    :ivar private_endpoint_connections: List of private endpoint connections for a container
     registry.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.containerregistry.v2023_07_01.models.PrivateEndpointConnection]
    :ivar public_network_access: Whether or not public network access is allowed for the container
     registry. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.PublicNetworkAccess
    :ivar network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Known values are: "AzureServices" and "None".
    :vartype network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleBypassOptions
    :ivar zone_redundancy: Whether or not zone redundancy is enabled for this container registry.
     Known values are: "Enabled" and "Disabled".
    :vartype zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ZoneRedundancy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "login_server": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "data_endpoint_host_names": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "login_server": {"key": "properties.loginServer", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "Status"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "policies": {"key": "properties.policies", "type": "Policies"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperty"},
        "data_endpoint_enabled": {"key": "properties.dataEndpointEnabled", "type": "bool"},
        "data_endpoint_host_names": {"key": "properties.dataEndpointHostNames", "type": "[str]"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "network_rule_bypass_options": {"key": "properties.networkRuleBypassOptions", "type": "str"},
        "zone_redundancy": {"key": "properties.zoneRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        admin_user_enabled: bool = False,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        policies: Optional["_models.Policies"] = None,
        encryption: Optional["_models.EncryptionProperty"] = None,
        data_endpoint_enabled: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        network_rule_bypass_options: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry. Required.
        :paramtype sku: ~azure.mgmt.containerregistry.v2023_07_01.models.Sku
        :keyword identity: The identity of the container registry.
        :paramtype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set: ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2023_07_01.models.Policies
        :keyword encryption: The encryption settings of container registry.
        :paramtype encryption: ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionProperty
        :keyword data_endpoint_enabled: Enable a single data endpoint per region for serving data.
        :paramtype data_endpoint_enabled: bool
        :keyword public_network_access: Whether or not public network access is allowed for the
         container registry. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.PublicNetworkAccess
        :keyword network_rule_bypass_options: Whether to allow trusted Azure services to access a
         network restricted registry. Known values are: "AzureServices" and "None".
        :paramtype network_rule_bypass_options: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleBypassOptions
        :keyword zone_redundancy: Whether or not zone redundancy is enabled for this container
         registry. Known values are: "Enabled" and "Disabled".
        :paramtype zone_redundancy: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.ZoneRedundancy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies
        self.encryption = encryption
        self.data_endpoint_enabled = data_endpoint_enabled
        self.data_endpoint_host_names = None
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.network_rule_bypass_options = network_rule_bypass_options
        self.zone_redundancy = zone_redundancy


class RegistryListCredentialsResult(_serialization.Model):
    """The response from the ListCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.RegistryPassword]
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[RegistryPassword]"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["_models.RegistryPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.RegistryPassword]
        """
        super().__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryListResult(_serialization.Model):
    """The result of a request to list container registries.

    :ivar value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Registry]
    :ivar next_link: The URI that can be used to request the next list of container registries.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Registry]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Registry"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registries. Since this list may be incomplete, the
         nextLink field should be used to request the next list of container registries.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Registry]
        :keyword next_link: The URI that can be used to request the next list of container registries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegistryNameCheckRequest(_serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the container registry. Required.
    :vartype name: str
    :ivar type: The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Required. Default value is
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True, "max_length": 50, "min_length": 5, "pattern": r"^[a-zA-Z0-9]*$"},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the container registry. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class RegistryNameStatus(_serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :ivar name_available: The value that indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: The value that indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: If any, the reason that the name is not available.
        :paramtype reason: str
        :keyword message: If any, the error message that provides more detail for the reason that the
         name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(_serialization.Model):
    """The login password for the container registry.

    :ivar name: The password name. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.PasswordName"]] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The password name. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PasswordName
        :keyword value: The password value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryUpdateParameters(_serialization.Model):
    """The parameters for updating a container registry.

    :ivar identity: The identity of the container registry.
    :vartype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
    :ivar tags: The tags for the container registry.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU of the container registry.
    :vartype sku: ~azure.mgmt.containerregistry.v2023_07_01.models.Sku
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set: ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2023_07_01.models.Policies
    :ivar encryption: The encryption settings of container registry.
    :vartype encryption: ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionProperty
    :ivar data_endpoint_enabled: Enable a single data endpoint per region for serving data.
    :vartype data_endpoint_enabled: bool
    :ivar public_network_access: Whether or not public network access is allowed for the container
     registry. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.PublicNetworkAccess
    :ivar network_rule_bypass_options: Whether to allow trusted Azure services to access a network
     restricted registry. Known values are: "AzureServices" and "None".
    :vartype network_rule_bypass_options: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleBypassOptions
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "network_rule_set": {"key": "properties.networkRuleSet", "type": "NetworkRuleSet"},
        "policies": {"key": "properties.policies", "type": "Policies"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperty"},
        "data_endpoint_enabled": {"key": "properties.dataEndpointEnabled", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "network_rule_bypass_options": {"key": "properties.networkRuleBypassOptions", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        admin_user_enabled: Optional[bool] = None,
        network_rule_set: Optional["_models.NetworkRuleSet"] = None,
        policies: Optional["_models.Policies"] = None,
        encryption: Optional["_models.EncryptionProperty"] = None,
        data_endpoint_enabled: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        network_rule_bypass_options: Optional[Union[str, "_models.NetworkRuleBypassOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the container registry.
        :paramtype identity: ~azure.mgmt.containerregistry.v2023_07_01.models.IdentityProperties
        :keyword tags: The tags for the container registry.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry.
        :paramtype sku: ~azure.mgmt.containerregistry.v2023_07_01.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set: ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2023_07_01.models.Policies
        :keyword encryption: The encryption settings of container registry.
        :paramtype encryption: ~azure.mgmt.containerregistry.v2023_07_01.models.EncryptionProperty
        :keyword data_endpoint_enabled: Enable a single data endpoint per region for serving data.
        :paramtype data_endpoint_enabled: bool
        :keyword public_network_access: Whether or not public network access is allowed for the
         container registry. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.PublicNetworkAccess
        :keyword network_rule_bypass_options: Whether to allow trusted Azure services to access a
         network restricted registry. Known values are: "AzureServices" and "None".
        :paramtype network_rule_bypass_options: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.NetworkRuleBypassOptions
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies
        self.encryption = encryption
        self.data_endpoint_enabled = data_endpoint_enabled
        self.public_network_access = public_network_access
        self.network_rule_bypass_options = network_rule_bypass_options


class RegistryUsage(_serialization.Model):
    """The quota usage for a container registry.

    :ivar name: The name of the usage.
    :vartype name: str
    :ivar limit: The limit of the usage.
    :vartype limit: int
    :ivar current_value: The current value of the usage.
    :vartype current_value: int
    :ivar unit: The unit of measurement. Known values are: "Count" and "Bytes".
    :vartype unit: str or ~azure.mgmt.containerregistry.v2023_07_01.models.RegistryUsageUnit
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "current_value": {"key": "currentValue", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        limit: Optional[int] = None,
        current_value: Optional[int] = None,
        unit: Optional[Union[str, "_models.RegistryUsageUnit"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the usage.
        :paramtype name: str
        :keyword limit: The limit of the usage.
        :paramtype limit: int
        :keyword current_value: The current value of the usage.
        :paramtype current_value: int
        :keyword unit: The unit of measurement. Known values are: "Count" and "Bytes".
        :paramtype unit: str or ~azure.mgmt.containerregistry.v2023_07_01.models.RegistryUsageUnit
        """
        super().__init__(**kwargs)
        self.name = name
        self.limit = limit
        self.current_value = current_value
        self.unit = unit


class RegistryUsageListResult(_serialization.Model):
    """The result of a request to get container registry quota usages.

    :ivar value: The list of container registry quota usages.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.RegistryUsage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RegistryUsage]"},
    }

    def __init__(self, *, value: Optional[List["_models.RegistryUsage"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of container registry quota usages.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.RegistryUsage]
        """
        super().__init__(**kwargs)
        self.value = value


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2023_07_01.models.Status
    :ivar region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :vartype region_endpoint_enabled: bool
    :ivar zone_redundancy: Whether or not zone redundancy is enabled for this container registry
     replication. Known values are: "Enabled" and "Disabled".
    :vartype zone_redundancy: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ZoneRedundancy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "Status"},
        "region_endpoint_enabled": {"key": "properties.regionEndpointEnabled", "type": "bool"},
        "zone_redundancy": {"key": "properties.zoneRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        region_endpoint_enabled: bool = True,
        zone_redundancy: Optional[Union[str, "_models.ZoneRedundancy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword region_endpoint_enabled: Specifies whether the replication's regional endpoint is
         enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
         however its data will continue to be synced with other replications.
        :paramtype region_endpoint_enabled: bool
        :keyword zone_redundancy: Whether or not zone redundancy is enabled for this container registry
         replication. Known values are: "Enabled" and "Disabled".
        :paramtype zone_redundancy: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.ZoneRedundancy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.region_endpoint_enabled = region_endpoint_enabled
        self.zone_redundancy = zone_redundancy


class ReplicationListResult(_serialization.Model):
    """The result of a request to list replications for a container registry.

    :ivar value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Replication]
    :ivar next_link: The URI that can be used to request the next list of replications.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Replication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Replication"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of replications. Since this list may be incomplete, the nextLink field
         should be used to request the next list of replications.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Replication]
        :keyword next_link: The URI that can be used to request the next list of replications.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationUpdateParameters(_serialization.Model):
    """The parameters for updating a replication.

    :ivar tags: The tags for the replication.
    :vartype tags: dict[str, str]
    :ivar region_endpoint_enabled: Specifies whether the replication's regional endpoint is
     enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
     however its data will continue to be synced with other replications.
    :vartype region_endpoint_enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "region_endpoint_enabled": {"key": "properties.regionEndpointEnabled", "type": "bool"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, region_endpoint_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the replication.
        :paramtype tags: dict[str, str]
        :keyword region_endpoint_enabled: Specifies whether the replication's regional endpoint is
         enabled. Requests will not be routed to a replication whose regional endpoint is disabled,
         however its data will continue to be synced with other replications.
        :paramtype region_endpoint_enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.region_endpoint_enabled = region_endpoint_enabled


class Request(_serialization.Model):
    """The request that generated the event.

    :ivar id: The ID of the request that initiated the event.
    :vartype id: str
    :ivar addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :vartype addr: str
    :ivar host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :vartype host: str
    :ivar method: The request method that generated the event.
    :vartype method: str
    :ivar useragent: The user agent header of the request.
    :vartype useragent: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "addr": {"key": "addr", "type": "str"},
        "host": {"key": "host", "type": "str"},
        "method": {"key": "method", "type": "str"},
        "useragent": {"key": "useragent", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        addr: Optional[str] = None,
        host: Optional[str] = None,
        method: Optional[str] = None,
        useragent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the request that initiated the event.
        :paramtype id: str
        :keyword addr: The IP or hostname and possibly port of the client connection that initiated the
         event. This is the RemoteAddr from the standard http request.
        :paramtype addr: str
        :keyword host: The externally accessible hostname of the registry instance, as specified by the
         http host header on incoming requests.
        :paramtype host: str
        :keyword method: The request method that generated the event.
        :paramtype method: str
        :keyword useragent: The user agent header of the request.
        :paramtype useragent: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class RetentionPolicy(_serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar days: The number of days to retain an untagged manifest after which it gets purged.
    :vartype days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
    """

    _validation = {
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "days": {"key": "days", "type": "int"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self, *, days: int = 7, status: Optional[Union[str, "_models.PolicyStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword days: The number of days to retain an untagged manifest after which it gets purged.
        :paramtype days: int
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.days = days
        self.last_updated_time = None
        self.status = status


class ScopeMap(ProxyResource):
    """An object that represents a scope map for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar description: The user friendly description of the scope map.
    :vartype description: str
    :ivar type_properties_type: The type of the scope map. E.g. BuildIn scope map.
    :vartype type_properties_type: str
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    :ivar actions: The list of scoped permissions for registry artifacts.
     E.g. repositories/repository-name/content/read,
     repositories/repository-name/metadata/write.
    :vartype actions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "type_properties_type": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self, *, description: Optional[str] = None, actions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: The user friendly description of the scope map.
        :paramtype description: str
        :keyword actions: The list of scoped permissions for registry artifacts.
         E.g. repositories/repository-name/content/read,
         repositories/repository-name/metadata/write.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.type_properties_type = None
        self.creation_date = None
        self.provisioning_state = None
        self.actions = actions


class ScopeMapListResult(_serialization.Model):
    """The result of a request to list scope maps for a container registry.

    :ivar value: The list of scope maps. Since this list may be incomplete, the nextLink field
     should be used to request the next list of scope maps.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.ScopeMap]
    :ivar next_link: The URI that can be used to request the next list of scope maps.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ScopeMap]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ScopeMap"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of scope maps. Since this list may be incomplete, the nextLink field
         should be used to request the next list of scope maps.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.ScopeMap]
        :keyword next_link: The URI that can be used to request the next list of scope maps.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScopeMapUpdateParameters(_serialization.Model):
    """The properties for updating the scope map.

    :ivar description: The user friendly description of the scope map.
    :vartype description: str
    :ivar actions: The list of scope permissions for registry artifacts.
     E.g. repositories/repository-name/pull,
     repositories/repository-name/delete.
    :vartype actions: list[str]
    """

    _attribute_map = {
        "description": {"key": "properties.description", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self, *, description: Optional[str] = None, actions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: The user friendly description of the scope map.
        :paramtype description: str
        :keyword actions: The list of scope permissions for registry artifacts.
         E.g. repositories/repository-name/pull,
         repositories/repository-name/delete.
        :paramtype actions: list[str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.actions = actions


class Sku(_serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name of the container registry. Required for registry creation. Required.
     Known values are: "Classic", "Basic", "Standard", and "Premium".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Known values are: "Classic", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2023_07_01.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.SkuName"], **kwargs: Any) -> None:
        """
        :keyword name: The SKU name of the container registry. Required for registry creation.
         Required. Known values are: "Classic", "Basic", "Standard", and "Premium".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None


class Source(_serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the
    event, the source generates it.

    :ivar addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :vartype addr: str
    :ivar instance_id: The running instance of an application. Changes after each restart.
    :vartype instance_id: str
    """

    _attribute_map = {
        "addr": {"key": "addr", "type": "str"},
        "instance_id": {"key": "instanceID", "type": "str"},
    }

    def __init__(self, *, addr: Optional[str] = None, instance_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword addr: The IP or hostname and the port of the registry node that generated the event.
         Generally, this will be resolved by os.Hostname() along with the running port.
        :paramtype addr: str
        :keyword instance_id: The running instance of an application. Changes after each restart.
        :paramtype instance_id: str
        """
        super().__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class Status(_serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "display_status": {"readonly": True},
        "message": {"readonly": True},
        "timestamp": {"readonly": True},
    }

    _attribute_map = {
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(_serialization.Model):
    """The properties of a storage account for a container registry. Only applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID of the storage account. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource ID of the storage account. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerregistry.v2023_07_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.LastModifiedByType
    :ivar last_modified_at: The timestamp of resource modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.LastModifiedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerregistry.v2023_07_01.models.LastModifiedByType
        :keyword last_modified_at: The timestamp of resource modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Target(_serialization.Model):
    """The target of the event.

    :ivar media_type: The MIME type of the referenced object.
    :vartype media_type: str
    :ivar size: The number of bytes of the content. Same as Length field.
    :vartype size: int
    :ivar digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :vartype digest: str
    :ivar length: The number of bytes of the content. Same as Size field.
    :vartype length: int
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar url: The direct URL to the content.
    :vartype url: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar name: The name of the artifact.
    :vartype name: str
    :ivar version: The version of the artifact.
    :vartype version: str
    """

    _attribute_map = {
        "media_type": {"key": "mediaType", "type": "str"},
        "size": {"key": "size", "type": "int"},
        "digest": {"key": "digest", "type": "str"},
        "length": {"key": "length", "type": "int"},
        "repository": {"key": "repository", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        length: Optional[int] = None,
        repository: Optional[str] = None,
        url: Optional[str] = None,
        tag: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword media_type: The MIME type of the referenced object.
        :paramtype media_type: str
        :keyword size: The number of bytes of the content. Same as Length field.
        :paramtype size: int
        :keyword digest: The digest of the content, as defined by the Registry V2 HTTP API
         Specification.
        :paramtype digest: str
        :keyword length: The number of bytes of the content. Same as Size field.
        :paramtype length: int
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword url: The direct URL to the content.
        :paramtype url: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword name: The name of the artifact.
        :paramtype name: str
        :keyword version: The version of the artifact.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag
        self.name = name
        self.version = version


class Token(ProxyResource):
    """An object that represents a token for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar creation_date: The creation date of scope map.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    :ivar scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :vartype scope_map_id: str
    :ivar credentials: The credentials that can be used for authenticating the token.
    :vartype credentials:
     ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCredentialsProperties
    :ivar status: The status of the token example enabled or disabled. Known values are: "enabled"
     and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "scope_map_id": {"key": "properties.scopeMapId", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "TokenCredentialsProperties"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        scope_map_id: Optional[str] = None,
        credentials: Optional["_models.TokenCredentialsProperties"] = None,
        status: Optional[Union[str, "_models.TokenStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope_map_id: The resource ID of the scope map to which the token will be associated
         with.
        :paramtype scope_map_id: str
        :keyword credentials: The credentials that can be used for authenticating the token.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCredentialsProperties
        :keyword status: The status of the token example enabled or disabled. Known values are:
         "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenStatus
        """
        super().__init__(**kwargs)
        self.creation_date = None
        self.provisioning_state = None
        self.scope_map_id = scope_map_id
        self.credentials = credentials
        self.status = status


class TokenCertificate(_serialization.Model):
    """The properties of a certificate used for authenticating a token.

    :ivar name: Known values are: "certificate1" and "certificate2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCertificateName
    :ivar expiry: The expiry datetime of the certificate.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The thumbprint of the certificate.
    :vartype thumbprint: str
    :ivar encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format
     that will be used for authenticating the token.
    :vartype encoded_pem_certificate: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "encoded_pem_certificate": {"key": "encodedPemCertificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.TokenCertificateName"]] = None,
        expiry: Optional[datetime.datetime] = None,
        thumbprint: Optional[str] = None,
        encoded_pem_certificate: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Known values are: "certificate1" and "certificate2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCertificateName
        :keyword expiry: The expiry datetime of the certificate.
        :paramtype expiry: ~datetime.datetime
        :keyword thumbprint: The thumbprint of the certificate.
        :paramtype thumbprint: str
        :keyword encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM
         format that will be used for authenticating the token.
        :paramtype encoded_pem_certificate: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.encoded_pem_certificate = encoded_pem_certificate


class TokenCredentialsProperties(_serialization.Model):
    """The properties of the credentials that can be used for authenticating the token.

    :ivar certificates:
    :vartype certificates: list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenCertificate]
    :ivar passwords:
    :vartype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenPassword]
    """

    _attribute_map = {
        "certificates": {"key": "certificates", "type": "[TokenCertificate]"},
        "passwords": {"key": "passwords", "type": "[TokenPassword]"},
    }

    def __init__(
        self,
        *,
        certificates: Optional[List["_models.TokenCertificate"]] = None,
        passwords: Optional[List["_models.TokenPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificates:
        :paramtype certificates:
         list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenCertificate]
        :keyword passwords:
        :paramtype passwords: list[~azure.mgmt.containerregistry.v2023_07_01.models.TokenPassword]
        """
        super().__init__(**kwargs)
        self.certificates = certificates
        self.passwords = passwords


class TokenListResult(_serialization.Model):
    """The result of a request to list tokens for a container registry.

    :ivar value: The list of tokens. Since this list may be incomplete, the nextLink field should
     be used to request the next list of tokens.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Token]
    :ivar next_link: The URI that can be used to request the next list of tokens.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Token]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Token"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of tokens. Since this list may be incomplete, the nextLink field
         should be used to request the next list of tokens.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Token]
        :keyword next_link: The URI that can be used to request the next list of tokens.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TokenPassword(_serialization.Model):
    """The password that will be used for authenticating the token of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar creation_time: The creation datetime of the password.
    :vartype creation_time: ~datetime.datetime
    :ivar expiry: The expiry datetime of the password.
    :vartype expiry: ~datetime.datetime
    :ivar name: The password name "password1" or "password2". Known values are: "password1" and
     "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenPasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "creation_time": {"key": "creationTime", "type": "iso-8601"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        creation_time: Optional[datetime.datetime] = None,
        expiry: Optional[datetime.datetime] = None,
        name: Optional[Union[str, "_models.TokenPasswordName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword creation_time: The creation datetime of the password.
        :paramtype creation_time: ~datetime.datetime
        :keyword expiry: The expiry datetime of the password.
        :paramtype expiry: ~datetime.datetime
        :keyword name: The password name "password1" or "password2". Known values are: "password1" and
         "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenPasswordName
        """
        super().__init__(**kwargs)
        self.creation_time = creation_time
        self.expiry = expiry
        self.name = name
        self.value = None


class TokenUpdateParameters(_serialization.Model):
    """The parameters for updating a token.

    :ivar scope_map_id: The resource ID of the scope map to which the token will be associated
     with.
    :vartype scope_map_id: str
    :ivar status: The status of the token example enabled or disabled. Known values are: "enabled"
     and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenStatus
    :ivar credentials: The credentials that can be used for authenticating the token.
    :vartype credentials:
     ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCredentialsProperties
    """

    _attribute_map = {
        "scope_map_id": {"key": "properties.scopeMapId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "credentials": {"key": "properties.credentials", "type": "TokenCredentialsProperties"},
    }

    def __init__(
        self,
        *,
        scope_map_id: Optional[str] = None,
        status: Optional[Union[str, "_models.TokenStatus"]] = None,
        credentials: Optional["_models.TokenCredentialsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scope_map_id: The resource ID of the scope map to which the token will be associated
         with.
        :paramtype scope_map_id: str
        :keyword status: The status of the token example enabled or disabled. Known values are:
         "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TokenStatus
        :keyword credentials: The credentials that can be used for authenticating the token.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2023_07_01.models.TokenCredentialsProperties
        """
        super().__init__(**kwargs)
        self.scope_map_id = scope_map_id
        self.status = status
        self.credentials = credentials


class TrustPolicy(_serialization.Model):
    """The content trust policy for a container registry.

    :ivar type: The type of trust policy. "Notary"
    :vartype type: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TrustPolicyType
    :ivar status: The value that indicates whether the policy is enabled or not. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.TrustPolicyType"] = "Notary",
        status: Optional[Union[str, "_models.PolicyStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of trust policy. "Notary"
        :paramtype type: str or ~azure.mgmt.containerregistry.v2023_07_01.models.TrustPolicyType
        :keyword status: The value that indicates whether the policy is enabled or not. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.PolicyStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.status = status


class UserIdentityProperties(_serialization.Model):
    """UserIdentityProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.containerregistry.v2023_07_01.models.SystemData
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Known values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2023_07_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.scope = scope
        self.actions = actions
        self.provisioning_state = None


class WebhookCreateParameters(_serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :ivar tags: The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar location: The location of the webhook. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
    """

    _validation = {
        "location": {"required": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "service_uri": {"key": "properties.serviceUri", "type": "str"},
        "custom_headers": {"key": "properties.customHeaders", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword location: The location of the webhook. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions


class WebhookListResult(_serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :ivar value: The list of webhooks. Since this list may be incomplete, the nextLink field should
     be used to request the next list of webhooks.
    :vartype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Webhook]
    :ivar next_link: The URI that can be used to request the next list of webhooks.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Webhook]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Webhook"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of webhooks. Since this list may be incomplete, the nextLink field
         should be used to request the next list of webhooks.
        :paramtype value: list[~azure.mgmt.containerregistry.v2023_07_01.models.Webhook]
        :keyword next_link: The URI that can be used to request the next list of webhooks.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebhookUpdateParameters(_serialization.Model):
    """The parameters for updating a webhook.

    :ivar tags: The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Known values are:
     "enabled" and "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "service_uri": {"key": "properties.serviceUri", "type": "str"},
        "custom_headers": {"key": "properties.customHeaders", "type": "{str}"},
        "status": {"key": "properties.status", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "actions": {"key": "properties.actions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "_models.WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "_models.WebhookAction"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Known values
         are: "enabled" and "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2023_07_01.models.WebhookAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions
