# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccessInvitedUserDetails(_serialization.Model):
    """Details of the user being invited.

    :ivar invited_email: UPN/Email of the user who is being invited.
    :vartype invited_email: str
    :ivar auth_type: Auth type of the user.
    :vartype auth_type: str
    """

    _attribute_map = {
        "invited_email": {"key": "invitedEmail", "type": "str"},
        "auth_type": {"key": "auth_type", "type": "str"},
    }

    def __init__(self, *, invited_email: Optional[str] = None, auth_type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword invited_email: UPN/Email of the user who is being invited.
        :paramtype invited_email: str
        :keyword auth_type: Auth type of the user.
        :paramtype auth_type: str
        """
        super().__init__(**kwargs)
        self.invited_email = invited_email
        self.auth_type = auth_type


class AccessInviteUserAccountModel(_serialization.Model):
    """Invite User Account model.

    :ivar organization_id: Id of the organization.
    :vartype organization_id: str
    :ivar email: Email of the logged in user.
    :vartype email: str
    :ivar upn: Upn of the logged in user.
    :vartype upn: str
    :ivar invited_user_details: Details of the user who is being invited.
    :vartype invited_user_details: ~azure.mgmt.confluent.models.AccessInvitedUserDetails
    """

    _attribute_map = {
        "organization_id": {"key": "organizationId", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "invited_user_details": {"key": "invitedUserDetails", "type": "AccessInvitedUserDetails"},
    }

    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        email: Optional[str] = None,
        upn: Optional[str] = None,
        invited_user_details: Optional["_models.AccessInvitedUserDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: Id of the organization.
        :paramtype organization_id: str
        :keyword email: Email of the logged in user.
        :paramtype email: str
        :keyword upn: Upn of the logged in user.
        :paramtype upn: str
        :keyword invited_user_details: Details of the user who is being invited.
        :paramtype invited_user_details: ~azure.mgmt.confluent.models.AccessInvitedUserDetails
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.email = email
        self.upn = upn
        self.invited_user_details = invited_user_details


class AccessListClusterSuccessResponse(_serialization.Model):
    """List cluster success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the environments list.
    :vartype data: list[~azure.mgmt.confluent.models.ClusterRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[ClusterRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.ClusterRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the environments list.
        :paramtype data: list[~azure.mgmt.confluent.models.ClusterRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class AccessListEnvironmentsSuccessResponse(_serialization.Model):
    """List environments success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the environments list.
    :vartype data: list[~azure.mgmt.confluent.models.EnvironmentRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[EnvironmentRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.EnvironmentRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the environments list.
        :paramtype data: list[~azure.mgmt.confluent.models.EnvironmentRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class AccessListInvitationsSuccessResponse(_serialization.Model):
    """List invitations success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the invitations list.
    :vartype data: list[~azure.mgmt.confluent.models.InvitationRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[InvitationRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.InvitationRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the invitations list.
        :paramtype data: list[~azure.mgmt.confluent.models.InvitationRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class AccessListRoleBindingsSuccessResponse(_serialization.Model):
    """List cluster success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the environments list.
    :vartype data: list[~azure.mgmt.confluent.models.RoleBindingRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[RoleBindingRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.RoleBindingRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the environments list.
        :paramtype data: list[~azure.mgmt.confluent.models.RoleBindingRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class AccessListServiceAccountsSuccessResponse(_serialization.Model):
    """List service accounts success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the service accounts list.
    :vartype data: list[~azure.mgmt.confluent.models.ServiceAccountRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[ServiceAccountRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.ServiceAccountRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the service accounts list.
        :paramtype data: list[~azure.mgmt.confluent.models.ServiceAccountRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class AccessListUsersSuccessResponse(_serialization.Model):
    """List users success response.

    :ivar kind: Type of response.
    :vartype kind: str
    :ivar metadata: Metadata of the list.
    :vartype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
    :ivar data: Data of the users list.
    :vartype data: list[~azure.mgmt.confluent.models.UserRecord]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "metadata": {"key": "metadata", "type": "ConfluentListMetadata"},
        "data": {"key": "data", "type": "[UserRecord]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.ConfluentListMetadata"] = None,
        data: Optional[List["_models.UserRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of response.
        :paramtype kind: str
        :keyword metadata: Metadata of the list.
        :paramtype metadata: ~azure.mgmt.confluent.models.ConfluentListMetadata
        :keyword data: Data of the users list.
        :paramtype data: list[~azure.mgmt.confluent.models.UserRecord]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.metadata = metadata
        self.data = data


class ClusterByokEntity(_serialization.Model):
    """The network associated with this object.

    :ivar id: ID of the referred resource.
    :vartype id: str
    :ivar related: API URL for accessing or modifying the referred object.
    :vartype related: str
    :ivar resource_name: CRN reference to the referred resource.
    :vartype resource_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "related": {"key": "related", "type": "str"},
        "resource_name": {"key": "resource_name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        related: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the referred resource.
        :paramtype id: str
        :keyword related: API URL for accessing or modifying the referred object.
        :paramtype related: str
        :keyword resource_name: CRN reference to the referred resource.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.related = related
        self.resource_name = resource_name


class ClusterConfigEntity(_serialization.Model):
    """The configuration of the Kafka cluster.

    :ivar kind: The lifecycle phase of the cluster.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: The lifecycle phase of the cluster.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class ClusterEnvironmentEntity(_serialization.Model):
    """The environment to which cluster belongs.

    :ivar id: ID of the referred resource.
    :vartype id: str
    :ivar environment: Environment of the referred resource.
    :vartype environment: str
    :ivar related: API URL for accessing or modifying the referred object.
    :vartype related: str
    :ivar resource_name: CRN reference to the referred resource.
    :vartype resource_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "related": {"key": "related", "type": "str"},
        "resource_name": {"key": "resource_name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        environment: Optional[str] = None,
        related: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the referred resource.
        :paramtype id: str
        :keyword environment: Environment of the referred resource.
        :paramtype environment: str
        :keyword related: API URL for accessing or modifying the referred object.
        :paramtype related: str
        :keyword resource_name: CRN reference to the referred resource.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.environment = environment
        self.related = related
        self.resource_name = resource_name


class ClusterNetworkEntity(_serialization.Model):
    """The network associated with this object.

    :ivar id: ID of the referred resource.
    :vartype id: str
    :ivar environment: Environment of the referred resource.
    :vartype environment: str
    :ivar related: API URL for accessing or modifying the referred object.
    :vartype related: str
    :ivar resource_name: CRN reference to the referred resource.
    :vartype resource_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "related": {"key": "related", "type": "str"},
        "resource_name": {"key": "resource_name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        environment: Optional[str] = None,
        related: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the referred resource.
        :paramtype id: str
        :keyword environment: Environment of the referred resource.
        :paramtype environment: str
        :keyword related: API URL for accessing or modifying the referred object.
        :paramtype related: str
        :keyword resource_name: CRN reference to the referred resource.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.environment = environment
        self.related = related
        self.resource_name = resource_name


class ClusterRecord(_serialization.Model):
    """Record of the environment.

    :ivar kind: Type of environment.
    :vartype kind: str
    :ivar id: Id of the environment.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar display_name: Display name of the user.
    :vartype display_name: str
    :ivar spec: Specification of the cluster.
    :vartype spec: ~azure.mgmt.confluent.models.ClusterSpecEntity
    :ivar status: Specification of the cluster.
    :vartype status: ~azure.mgmt.confluent.models.ClusterStatusEntity
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "display_name": {"key": "display_name", "type": "str"},
        "spec": {"key": "spec", "type": "ClusterSpecEntity"},
        "status": {"key": "status", "type": "ClusterStatusEntity"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        display_name: Optional[str] = None,
        spec: Optional["_models.ClusterSpecEntity"] = None,
        status: Optional["_models.ClusterStatusEntity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of environment.
        :paramtype kind: str
        :keyword id: Id of the environment.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword display_name: Display name of the user.
        :paramtype display_name: str
        :keyword spec: Specification of the cluster.
        :paramtype spec: ~azure.mgmt.confluent.models.ClusterSpecEntity
        :keyword status: Specification of the cluster.
        :paramtype status: ~azure.mgmt.confluent.models.ClusterStatusEntity
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.display_name = display_name
        self.spec = spec
        self.status = status


class ClusterSpecEntity(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Spec of the cluster record.

    :ivar display_name: The name of the cluster.
    :vartype display_name: str
    :ivar availability: The availability zone configuration of the cluster.
    :vartype availability: str
    :ivar cloud: The cloud service provider.
    :vartype cloud: str
    :ivar zone: type of zone availability.
    :vartype zone: str
    :ivar region: The cloud service provider region.
    :vartype region: str
    :ivar kafka_bootstrap_endpoint: The bootstrap endpoint used by Kafka clients to connect to the
     cluster.
    :vartype kafka_bootstrap_endpoint: str
    :ivar http_endpoint: The cluster HTTP request URL.
    :vartype http_endpoint: str
    :ivar api_endpoint: The Kafka API cluster endpoint.
    :vartype api_endpoint: str
    :ivar config: Specification of the cluster.
    :vartype config: ~azure.mgmt.confluent.models.ClusterConfigEntity
    :ivar environment: Specification of the cluster.
    :vartype environment: ~azure.mgmt.confluent.models.ClusterEnvironmentEntity
    :ivar network: Specification of the cluster.
    :vartype network: ~azure.mgmt.confluent.models.ClusterNetworkEntity
    :ivar byok: Specification of the cluster.
    :vartype byok: ~azure.mgmt.confluent.models.ClusterByokEntity
    """

    _attribute_map = {
        "display_name": {"key": "display_name", "type": "str"},
        "availability": {"key": "availability", "type": "str"},
        "cloud": {"key": "cloud", "type": "str"},
        "zone": {"key": "zone", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "kafka_bootstrap_endpoint": {"key": "kafka_bootstrap_endpoint", "type": "str"},
        "http_endpoint": {"key": "http_endpoint", "type": "str"},
        "api_endpoint": {"key": "api_endpoint", "type": "str"},
        "config": {"key": "config", "type": "ClusterConfigEntity"},
        "environment": {"key": "environment", "type": "ClusterEnvironmentEntity"},
        "network": {"key": "network", "type": "ClusterNetworkEntity"},
        "byok": {"key": "byok", "type": "ClusterByokEntity"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        availability: Optional[str] = None,
        cloud: Optional[str] = None,
        zone: Optional[str] = None,
        region: Optional[str] = None,
        kafka_bootstrap_endpoint: Optional[str] = None,
        http_endpoint: Optional[str] = None,
        api_endpoint: Optional[str] = None,
        config: Optional["_models.ClusterConfigEntity"] = None,
        environment: Optional["_models.ClusterEnvironmentEntity"] = None,
        network: Optional["_models.ClusterNetworkEntity"] = None,
        byok: Optional["_models.ClusterByokEntity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The name of the cluster.
        :paramtype display_name: str
        :keyword availability: The availability zone configuration of the cluster.
        :paramtype availability: str
        :keyword cloud: The cloud service provider.
        :paramtype cloud: str
        :keyword zone: type of zone availability.
        :paramtype zone: str
        :keyword region: The cloud service provider region.
        :paramtype region: str
        :keyword kafka_bootstrap_endpoint: The bootstrap endpoint used by Kafka clients to connect to
         the cluster.
        :paramtype kafka_bootstrap_endpoint: str
        :keyword http_endpoint: The cluster HTTP request URL.
        :paramtype http_endpoint: str
        :keyword api_endpoint: The Kafka API cluster endpoint.
        :paramtype api_endpoint: str
        :keyword config: Specification of the cluster.
        :paramtype config: ~azure.mgmt.confluent.models.ClusterConfigEntity
        :keyword environment: Specification of the cluster.
        :paramtype environment: ~azure.mgmt.confluent.models.ClusterEnvironmentEntity
        :keyword network: Specification of the cluster.
        :paramtype network: ~azure.mgmt.confluent.models.ClusterNetworkEntity
        :keyword byok: Specification of the cluster.
        :paramtype byok: ~azure.mgmt.confluent.models.ClusterByokEntity
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.availability = availability
        self.cloud = cloud
        self.zone = zone
        self.region = region
        self.kafka_bootstrap_endpoint = kafka_bootstrap_endpoint
        self.http_endpoint = http_endpoint
        self.api_endpoint = api_endpoint
        self.config = config
        self.environment = environment
        self.network = network
        self.byok = byok


class ClusterStatusEntity(_serialization.Model):
    """Status of the cluster record.

    :ivar phase: The lifecycle phase of the cluster.
    :vartype phase: str
    :ivar cku: The number of Confluent Kafka Units.
    :vartype cku: int
    """

    _attribute_map = {
        "phase": {"key": "phase", "type": "str"},
        "cku": {"key": "cku", "type": "int"},
    }

    def __init__(self, *, phase: Optional[str] = None, cku: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword phase: The lifecycle phase of the cluster.
        :paramtype phase: str
        :keyword cku: The number of Confluent Kafka Units.
        :paramtype cku: int
        """
        super().__init__(**kwargs)
        self.phase = phase
        self.cku = cku


class ConfluentAgreementResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Agreement Terms definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar name: The name of the agreement.
    :vartype name: str
    :ivar type: The type of the agreement.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confluent.models.SystemData
    :ivar publisher: Publisher identifier string.
    :vartype publisher: str
    :ivar product: Product identifier string.
    :vartype product: str
    :ivar plan: Plan identifier string.
    :vartype plan: str
    :ivar license_text_link: Link to HTML with Microsoft and Publisher terms.
    :vartype license_text_link: str
    :ivar privacy_policy_link: Link to the privacy policy of the publisher.
    :vartype privacy_policy_link: str
    :ivar retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty if
     Accepted is false.
    :vartype retrieve_datetime: ~datetime.datetime
    :ivar signature: Terms signature.
    :vartype signature: str
    :ivar accepted: If any version of the terms have been accepted, otherwise false.
    :vartype accepted: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "plan": {"key": "properties.plan", "type": "str"},
        "license_text_link": {"key": "properties.licenseTextLink", "type": "str"},
        "privacy_policy_link": {"key": "properties.privacyPolicyLink", "type": "str"},
        "retrieve_datetime": {"key": "properties.retrieveDatetime", "type": "iso-8601"},
        "signature": {"key": "properties.signature", "type": "str"},
        "accepted": {"key": "properties.accepted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        plan: Optional[str] = None,
        license_text_link: Optional[str] = None,
        privacy_policy_link: Optional[str] = None,
        retrieve_datetime: Optional[datetime.datetime] = None,
        signature: Optional[str] = None,
        accepted: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: Publisher identifier string.
        :paramtype publisher: str
        :keyword product: Product identifier string.
        :paramtype product: str
        :keyword plan: Plan identifier string.
        :paramtype plan: str
        :keyword license_text_link: Link to HTML with Microsoft and Publisher terms.
        :paramtype license_text_link: str
        :keyword privacy_policy_link: Link to the privacy policy of the publisher.
        :paramtype privacy_policy_link: str
        :keyword retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty
         if Accepted is false.
        :paramtype retrieve_datetime: ~datetime.datetime
        :keyword signature: Terms signature.
        :paramtype signature: str
        :keyword accepted: If any version of the terms have been accepted, otherwise false.
        :paramtype accepted: bool
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.publisher = publisher
        self.product = product
        self.plan = plan
        self.license_text_link = license_text_link
        self.privacy_policy_link = privacy_policy_link
        self.retrieve_datetime = retrieve_datetime
        self.signature = signature
        self.accepted = accepted


class ConfluentAgreementResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.confluent.models.ConfluentAgreementResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfluentAgreementResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfluentAgreementResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.confluent.models.ConfluentAgreementResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConfluentListMetadata(_serialization.Model):
    """Metadata of the list.

    :ivar first: First page of the list.
    :vartype first: str
    :ivar last: Last page of the list.
    :vartype last: str
    :ivar prev: Previous page of the list.
    :vartype prev: str
    :ivar next: Next page of the list.
    :vartype next: str
    :ivar total_size: Total size of the list.
    :vartype total_size: int
    """

    _attribute_map = {
        "first": {"key": "first", "type": "str"},
        "last": {"key": "last", "type": "str"},
        "prev": {"key": "prev", "type": "str"},
        "next": {"key": "next", "type": "str"},
        "total_size": {"key": "total_size", "type": "int"},
    }

    def __init__(
        self,
        *,
        first: Optional[str] = None,
        last: Optional[str] = None,
        prev: Optional[str] = None,
        next: Optional[str] = None,
        total_size: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first: First page of the list.
        :paramtype first: str
        :keyword last: Last page of the list.
        :paramtype last: str
        :keyword prev: Previous page of the list.
        :paramtype prev: str
        :keyword next: Next page of the list.
        :paramtype next: str
        :keyword total_size: Total size of the list.
        :paramtype total_size: int
        """
        super().__init__(**kwargs)
        self.first = first
        self.last = last
        self.prev = prev
        self.next = next
        self.total_size = total_size


class EnvironmentRecord(_serialization.Model):
    """Record of the environment.

    :ivar kind: Type of environment.
    :vartype kind: str
    :ivar id: Id of the environment.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar display_name: Display name of the user.
    :vartype display_name: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "display_name": {"key": "display_name", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of environment.
        :paramtype kind: str
        :keyword id: Id of the environment.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword display_name: Display name of the user.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.display_name = display_name


class ErrorResponseBody(_serialization.Model):
    """Response body of Error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error detail.
    :vartype details: list[~azure.mgmt.confluent.models.ErrorResponseBody]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBody]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None


class InvitationRecord(_serialization.Model):
    """Record of the invitation.

    :ivar kind: Type of account.
    :vartype kind: str
    :ivar id: Id of the invitation.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar email: Email of the user.
    :vartype email: str
    :ivar auth_type: Auth type of the user.
    :vartype auth_type: str
    :ivar status: Status of the invitation.
    :vartype status: str
    :ivar accepted_at: Accepted date time of the invitation.
    :vartype accepted_at: str
    :ivar expires_at: Expiration date time of the invitation.
    :vartype expires_at: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "email": {"key": "email", "type": "str"},
        "auth_type": {"key": "auth_type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "accepted_at": {"key": "accepted_at", "type": "str"},
        "expires_at": {"key": "expires_at", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        email: Optional[str] = None,
        auth_type: Optional[str] = None,
        status: Optional[str] = None,
        accepted_at: Optional[str] = None,
        expires_at: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of account.
        :paramtype kind: str
        :keyword id: Id of the invitation.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword email: Email of the user.
        :paramtype email: str
        :keyword auth_type: Auth type of the user.
        :paramtype auth_type: str
        :keyword status: Status of the invitation.
        :paramtype status: str
        :keyword accepted_at: Accepted date time of the invitation.
        :paramtype accepted_at: str
        :keyword expires_at: Expiration date time of the invitation.
        :paramtype expires_at: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.email = email
        self.auth_type = auth_type
        self.status = status
        self.accepted_at = accepted_at
        self.expires_at = expires_at


class LinkOrganization(_serialization.Model):
    """Link an existing Confluent organization.

    All required parameters must be populated in order to send to Azure.

    :ivar token: User auth token. Required.
    :vartype token: str
    """

    _validation = {
        "token": {"required": True},
    }

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
    }

    def __init__(self, *, token: str, **kwargs: Any) -> None:
        """
        :keyword token: User auth token. Required.
        :paramtype token: str
        """
        super().__init__(**kwargs)
        self.token = token


class ListAccessRequestModel(_serialization.Model):
    """List Access Request Model.

    :ivar search_filters: Search filters for the request.
    :vartype search_filters: dict[str, str]
    """

    _attribute_map = {
        "search_filters": {"key": "searchFilters", "type": "{str}"},
    }

    def __init__(self, *, search_filters: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword search_filters: Search filters for the request.
        :paramtype search_filters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.search_filters = search_filters


class MetadataEntity(_serialization.Model):
    """Metadata of the data record.

    :ivar self_property: Self lookup url.
    :vartype self_property: str
    :ivar resource_name: Resource name of the record.
    :vartype resource_name: str
    :ivar created_at: Created Date Time.
    :vartype created_at: str
    :ivar updated_at: Updated Date time.
    :vartype updated_at: str
    :ivar deleted_at: Deleted Date time.
    :vartype deleted_at: str
    """

    _attribute_map = {
        "self_property": {"key": "self", "type": "str"},
        "resource_name": {"key": "resource_name", "type": "str"},
        "created_at": {"key": "created_at", "type": "str"},
        "updated_at": {"key": "updated_at", "type": "str"},
        "deleted_at": {"key": "deleted_at", "type": "str"},
    }

    def __init__(
        self,
        *,
        self_property: Optional[str] = None,
        resource_name: Optional[str] = None,
        created_at: Optional[str] = None,
        updated_at: Optional[str] = None,
        deleted_at: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword self_property: Self lookup url.
        :paramtype self_property: str
        :keyword resource_name: Resource name of the record.
        :paramtype resource_name: str
        :keyword created_at: Created Date Time.
        :paramtype created_at: str
        :keyword updated_at: Updated Date time.
        :paramtype updated_at: str
        :keyword deleted_at: Deleted Date time.
        :paramtype deleted_at: str
        """
        super().__init__(**kwargs)
        self.self_property = self_property
        self.resource_name = resource_name
        self.created_at = created_at
        self.updated_at = updated_at
        self.deleted_at = deleted_at


class OfferDetail(_serialization.Model):
    """Confluent Offer detail.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher_id: Publisher Id. Required.
    :vartype publisher_id: str
    :ivar id: Offer Id. Required.
    :vartype id: str
    :ivar plan_id: Offer Plan Id. Required.
    :vartype plan_id: str
    :ivar plan_name: Offer Plan Name. Required.
    :vartype plan_name: str
    :ivar term_unit: Offer Plan Term unit. Required.
    :vartype term_unit: str
    :ivar term_id: Offer Plan Term Id.
    :vartype term_id: str
    :ivar private_offer_id: Private Offer Id.
    :vartype private_offer_id: str
    :ivar private_offer_ids: Array of Private Offer Ids.
    :vartype private_offer_ids: list[str]
    :ivar status: SaaS Offer Status. Known values are: "Started", "PendingFulfillmentStart",
     "InProgress", "Subscribed", "Suspended", "Reinstated", "Succeeded", "Failed", "Unsubscribed",
     and "Updating".
    :vartype status: str or ~azure.mgmt.confluent.models.SaaSOfferStatus
    """

    _validation = {
        "publisher_id": {"required": True, "max_length": 50},
        "id": {"required": True, "max_length": 50},
        "plan_id": {"required": True, "max_length": 200},
        "plan_name": {"required": True, "max_length": 200},
        "term_unit": {"required": True, "max_length": 25},
        "term_id": {"max_length": 50},
        "private_offer_id": {"max_length": 255},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "term_id": {"key": "termId", "type": "str"},
        "private_offer_id": {"key": "privateOfferId", "type": "str"},
        "private_offer_ids": {"key": "privateOfferIds", "type": "[str]"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: str,
        id: str,  # pylint: disable=redefined-builtin
        plan_id: str,
        plan_name: str,
        term_unit: str,
        term_id: Optional[str] = None,
        private_offer_id: Optional[str] = None,
        private_offer_ids: Optional[List[str]] = None,
        status: Optional[Union[str, "_models.SaaSOfferStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_id: Publisher Id. Required.
        :paramtype publisher_id: str
        :keyword id: Offer Id. Required.
        :paramtype id: str
        :keyword plan_id: Offer Plan Id. Required.
        :paramtype plan_id: str
        :keyword plan_name: Offer Plan Name. Required.
        :paramtype plan_name: str
        :keyword term_unit: Offer Plan Term unit. Required.
        :paramtype term_unit: str
        :keyword term_id: Offer Plan Term Id.
        :paramtype term_id: str
        :keyword private_offer_id: Private Offer Id.
        :paramtype private_offer_id: str
        :keyword private_offer_ids: Array of Private Offer Ids.
        :paramtype private_offer_ids: list[str]
        :keyword status: SaaS Offer Status. Known values are: "Started", "PendingFulfillmentStart",
         "InProgress", "Subscribed", "Suspended", "Reinstated", "Succeeded", "Failed", "Unsubscribed",
         and "Updating".
        :paramtype status: str or ~azure.mgmt.confluent.models.SaaSOfferStatus
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.id = id
        self.plan_id = plan_id
        self.plan_name = plan_name
        self.term_unit = term_unit
        self.term_id = term_id
        self.private_offer_id = private_offer_id
        self.private_offer_ids = private_offer_ids
        self.status = status


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Confluent.
    :vartype provider: str
    :ivar resource: Type on which the operation is performed, e.g., 'clusters'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Write confluent'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Confluent.
        :paramtype provider: str
        :keyword resource: Type on which the operation is performed, e.g., 'clusters'.
        :paramtype resource: str
        :keyword operation: Operation type, e.g., read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation, e.g., 'Write confluent'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of GET request to list Confluent operations.

    :ivar value: List of Confluent operations supported by the Microsoft.Confluent provider.
    :vartype value: list[~azure.mgmt.confluent.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Confluent operations supported by the Microsoft.Confluent provider.
        :paramtype value: list[~azure.mgmt.confluent.models.OperationResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResult(_serialization.Model):
    """An Confluent REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.confluent.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.confluent.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action


class OrganizationResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.confluent.models.SystemData
    :ivar tags: Organization resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Location of Organization resource.
    :vartype location: str
    :ivar created_time: The creation time of the resource.
    :vartype created_time: ~datetime.datetime
    :ivar provisioning_state: Provision states for confluent RP. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.confluent.models.ProvisionState
    :ivar organization_id: Id of the Confluent organization.
    :vartype organization_id: str
    :ivar sso_url: SSO url for the Confluent organization.
    :vartype sso_url: str
    :ivar offer_detail: Confluent offer detail. Required.
    :vartype offer_detail: ~azure.mgmt.confluent.models.OfferDetail
    :ivar user_detail: Subscriber detail. Required.
    :vartype user_detail: ~azure.mgmt.confluent.models.UserDetail
    :ivar link_organization: Link an existing Confluent organization.
    :vartype link_organization: ~azure.mgmt.confluent.models.LinkOrganization
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "organization_id": {"readonly": True},
        "sso_url": {"readonly": True},
        "offer_detail": {"required": True},
        "user_detail": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "organization_id": {"key": "properties.organizationId", "type": "str"},
        "sso_url": {"key": "properties.ssoUrl", "type": "str"},
        "offer_detail": {"key": "properties.offerDetail", "type": "OfferDetail"},
        "user_detail": {"key": "properties.userDetail", "type": "UserDetail"},
        "link_organization": {"key": "properties.linkOrganization", "type": "LinkOrganization"},
    }

    def __init__(
        self,
        *,
        offer_detail: "_models.OfferDetail",
        user_detail: "_models.UserDetail",
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        link_organization: Optional["_models.LinkOrganization"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Organization resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Location of Organization resource.
        :paramtype location: str
        :keyword offer_detail: Confluent offer detail. Required.
        :paramtype offer_detail: ~azure.mgmt.confluent.models.OfferDetail
        :keyword user_detail: Subscriber detail. Required.
        :paramtype user_detail: ~azure.mgmt.confluent.models.UserDetail
        :keyword link_organization: Link an existing Confluent organization.
        :paramtype link_organization: ~azure.mgmt.confluent.models.LinkOrganization
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None
        self.tags = tags
        self.location = location
        self.created_time = None
        self.provisioning_state = None
        self.organization_id = None
        self.sso_url = None
        self.offer_detail = offer_detail
        self.user_detail = user_detail
        self.link_organization = link_organization


class OrganizationResourceListResult(_serialization.Model):
    """The response of a list operation.

    :ivar value: Result of a list operation.
    :vartype value: list[~azure.mgmt.confluent.models.OrganizationResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OrganizationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OrganizationResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of a list operation.
        :paramtype value: list[~azure.mgmt.confluent.models.OrganizationResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OrganizationResourceUpdate(_serialization.Model):
    """Organization Resource update.

    :ivar tags: ARM resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: ARM resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ResourceProviderDefaultErrorResponse(_serialization.Model):
    """Default error response for resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Response body of Error.
    :vartype error: ~azure.mgmt.confluent.models.ErrorResponseBody
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class RoleBindingRecord(_serialization.Model):
    """Record of the environment.

    :ivar kind: The type of the resource.
    :vartype kind: str
    :ivar id: Id of the role.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar principal: The principal User or Group to bind the role to.
    :vartype principal: str
    :ivar role_name: The name of the role to bind to the principal.
    :vartype role_name: str
    :ivar crn_pattern: A CRN that specifies the scope and resource patterns necessary for the role
     to bind.
    :vartype crn_pattern: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "principal": {"key": "principal", "type": "str"},
        "role_name": {"key": "role_name", "type": "str"},
        "crn_pattern": {"key": "crn_pattern", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        principal: Optional[str] = None,
        role_name: Optional[str] = None,
        crn_pattern: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The type of the resource.
        :paramtype kind: str
        :keyword id: Id of the role.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword principal: The principal User or Group to bind the role to.
        :paramtype principal: str
        :keyword role_name: The name of the role to bind to the principal.
        :paramtype role_name: str
        :keyword crn_pattern: A CRN that specifies the scope and resource patterns necessary for the
         role to bind.
        :paramtype crn_pattern: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.principal = principal
        self.role_name = role_name
        self.crn_pattern = crn_pattern


class ServiceAccountRecord(_serialization.Model):
    """Record of the service account.

    :ivar kind: Type of account.
    :vartype kind: str
    :ivar id: Id of the service account.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar display_name: Name of the service account.
    :vartype display_name: str
    :ivar description: Description of the service account.
    :vartype description: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "display_name": {"key": "display_name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of account.
        :paramtype kind: str
        :keyword id: Id of the service account.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword display_name: Name of the service account.
        :paramtype display_name: str
        :keyword description: Description of the service account.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.display_name = display_name
        self.description = description


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.confluent.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserDetail(_serialization.Model):
    """Subscriber detail.

    All required parameters must be populated in order to send to Azure.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: Email address. Required.
    :vartype email_address: str
    :ivar user_principal_name: User principal name.
    :vartype user_principal_name: str
    :ivar aad_email: AAD email address.
    :vartype aad_email: str
    """

    _validation = {
        "first_name": {"max_length": 50},
        "last_name": {"max_length": 50},
        "email_address": {"required": True, "pattern": r"^\S+@\S+\.\S+$"},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "user_principal_name": {"key": "userPrincipalName", "type": "str"},
        "aad_email": {"key": "aadEmail", "type": "str"},
    }

    def __init__(
        self,
        *,
        email_address: str,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        aad_email: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email_address: Email address. Required.
        :paramtype email_address: str
        :keyword user_principal_name: User principal name.
        :paramtype user_principal_name: str
        :keyword aad_email: AAD email address.
        :paramtype aad_email: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.user_principal_name = user_principal_name
        self.aad_email = aad_email


class UserRecord(_serialization.Model):
    """Record of the user.

    :ivar kind: Type of account.
    :vartype kind: str
    :ivar id: Id of the user.
    :vartype id: str
    :ivar metadata: Metadata of the record.
    :vartype metadata: ~azure.mgmt.confluent.models.MetadataEntity
    :ivar email: Email of the user.
    :vartype email: str
    :ivar full_name: Name of the user.
    :vartype full_name: str
    :ivar auth_type: Auth type of the user.
    :vartype auth_type: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metadata": {"key": "metadata", "type": "MetadataEntity"},
        "email": {"key": "email", "type": "str"},
        "full_name": {"key": "full_name", "type": "str"},
        "auth_type": {"key": "auth_type", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        metadata: Optional["_models.MetadataEntity"] = None,
        email: Optional[str] = None,
        full_name: Optional[str] = None,
        auth_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Type of account.
        :paramtype kind: str
        :keyword id: Id of the user.
        :paramtype id: str
        :keyword metadata: Metadata of the record.
        :paramtype metadata: ~azure.mgmt.confluent.models.MetadataEntity
        :keyword email: Email of the user.
        :paramtype email: str
        :keyword full_name: Name of the user.
        :paramtype full_name: str
        :keyword auth_type: Auth type of the user.
        :paramtype auth_type: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.id = id
        self.metadata = metadata
        self.email = email
        self.full_name = full_name
        self.auth_type = auth_type


class ValidationResponse(_serialization.Model):
    """Validation response from the provider.

    :ivar info: Info from the response.
    :vartype info: dict[str, str]
    """

    _attribute_map = {
        "info": {"key": "info", "type": "{str}"},
    }

    def __init__(self, *, info: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword info: Info from the response.
        :paramtype info: dict[str, str]
        """
        super().__init__(**kwargs)
        self.info = info
