# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ManagementGroupProxyOnlyResource(msrest.serialization.Model):
    """A proxy only azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        """
        super(ManagementGroupProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location


class ManagementGroupDiagnosticSettingsResource(ManagementGroupProxyOnlyResource):
    """The management group diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :vartype event_hub_name: str
    :ivar logs: The list of logs settings.
    :vartype logs:
     list[~$(python-base-namespace).v2020_01_01_preview.models.ManagementGroupLogSettings]
    :ivar workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'logs': {'key': 'properties.logs', 'type': '[ManagementGroupLogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        logs: Optional[List["ManagementGroupLogSettings"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here
         to maintain backwards compatibility.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword event_hub_name: The name of the event hub. If none is specified, the default event hub
         will be selected.
        :paramtype event_hub_name: str
        :keyword logs: The list of logs settings.
        :paramtype logs:
         list[~$(python-base-namespace).v2020_01_01_preview.models.ManagementGroupLogSettings]
        :keyword workspace_id: The full ARM resource ID of the Log Analytics workspace to which you
         would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super(ManagementGroupDiagnosticSettingsResource, self).__init__(location=location, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.event_hub_name = event_hub_name
        self.logs = logs
        self.workspace_id = workspace_id


class ManagementGroupDiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of management group diagnostic settings resources.

    :ivar value: The collection of management group diagnostic settings resources.
    :vartype value:
     list[~$(python-base-namespace).v2020_01_01_preview.models.ManagementGroupDiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementGroupDiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagementGroupDiagnosticSettingsResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of management group diagnostic settings resources.
        :paramtype value:
         list[~$(python-base-namespace).v2020_01_01_preview.models.ManagementGroupDiagnosticSettingsResource]
        """
        super(ManagementGroupDiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = value


class ManagementGroupLogSettings(msrest.serialization.Model):
    """Part of Management Group diagnostic setting. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Required. Name of a Management Group Diagnostic Log category for a resource
     type this setting is applied to.
    :vartype category: str
    :ivar enabled: Required. a value indicating whether this log is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'category': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        category: str,
        enabled: bool,
        **kwargs
    ):
        """
        :keyword category: Required. Name of a Management Group Diagnostic Log category for a resource
         type this setting is applied to.
        :paramtype category: str
        :keyword enabled: Required. a value indicating whether this log is enabled.
        :paramtype enabled: bool
        """
        super(ManagementGroupLogSettings, self).__init__(**kwargs)
        self.category = category
        self.enabled = enabled
