/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    private boolean locationInfo = false;

    public XMLLayout() {
        this.ignoresThrowable = false;
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        Set propertySet;
        String[] s;
        StringBuffer buf = new StringBuffer();
        buf.append("<log4j:event logger=\"");
        buf.append(event.getLoggerName());
        buf.append("\" timestamp=\"");
        buf.append(Long.toString(event.getTimeStamp()));
        buf.append("\" sequenceNumber=\"");
        buf.append(Long.toString(event.getSequenceNumber()));
        buf.append("\" level=\"");
        buf.append(event.getLevel().toString());
        buf.append("\" thread=\"");
        buf.append(event.getThreadName());
        buf.append("\">\r\n");
        buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(buf, event.getRenderedMessage());
        buf.append("]]></log4j:message>\r\n");
        String ndc = event.getNDC();
        if (ndc != null) {
            buf.append("<log4j:NDC><![CDATA[");
            buf.append(ndc);
            buf.append("]]></log4j:NDC>\r\n");
        }
        if (!this.ignoresThrowable && (s = event.getThrowableStrRep()) != null) {
            buf.append("<log4j:throwable><![CDATA[");
            int i = 0;
            while (i < s.length) {
                buf.append(s[i]);
                buf.append("\r\n");
                ++i;
            }
            buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = event.getLocationInformation();
            buf.append("<log4j:locationInfo class=\"");
            buf.append(Transform.escapeTags(locationInfo.getClassName()));
            buf.append("\" method=\"");
            buf.append(Transform.escapeTags(locationInfo.getMethodName()));
            buf.append("\" file=\"");
            buf.append(locationInfo.getFileName());
            buf.append("\" line=\"");
            buf.append(locationInfo.getLineNumber());
            buf.append("\"/>\r\n");
        }
        if ((propertySet = event.getPropertyKeySet()) != null && propertySet.size() > 0) {
            buf.append("<log4j:properties>\r\n");
            Iterator propIter = propertySet.iterator();
            while (propIter.hasNext()) {
                String propName = propIter.next().toString();
                buf.append("    <log4j:data name=\"" + propName);
                String propValue = event.getProperty(propName).toString();
                buf.append("\" value=\"" + propValue);
                buf.append("\"/>\r\n");
            }
            buf.append("</log4j:properties>\r\n");
        }
        buf.append("</log4j:event>\r\n\r\n");
        return buf.toString();
    }
}

