# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkpts.endpoint import endpoint_data

class RemoveInstanceFromGroupRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'PTS', '2019-08-10', 'RemoveInstanceFromGroup','1.0.0')
		self.set_method('POST')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_Ver(self):
		return self.get_query_params().get('Ver')

	def set_Ver(self,Ver):
		self.add_query_param('Ver',Ver)

	def get_GroupId(self):
		return self.get_query_params().get('GroupId')

	def set_GroupId(self,GroupId):
		self.add_query_param('GroupId',GroupId)

	def get_InstanceIdAndPorts(self):
		return self.get_query_params().get('InstanceIdAndPorts')

	def set_InstanceIdAndPorts(self,InstanceIdAndPorts):
		self.add_query_param('InstanceIdAndPorts',InstanceIdAndPorts)