/**********************************************************************
 * $set_mipd_delays example -- PLI application using VPI routines
 *
 * C source to write Module Input Port Delays onto input ports.
 *
 * Usage:
 *  $mipd_delays(module_input_port, rise_delay, fall_delay, toZ_delay);
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include <stdlib.h>    /* ANSI C standard library */
#include <stdio.h>     /* ANSI C standard input/output library */
#include "vpi_user.h"  /* IEEE 1364 PLI VPI routine library  */
#include "veriuser.h"  /* IEEE 1364 PLI TF routine library    
                          (using TF routines for simulation control) */

/* prototypes of routines in this PLI application */
int PLIbook_SetMipd_calltf(), PLIbook_SetMipd_compiletf();

/**********************************************************************
 * VPI Registration Data
 *********************************************************************/
void PLIbook_SetMipd_register()
{
  s_vpi_systf_data tf_data;   /* allocate register data structure */
  tf_data.type      = vpiSysTask;
  tf_data.tfname    = "$set_mipd_delays";
  tf_data.calltf    = PLIbook_SetMipd_calltf;
  tf_data.compiletf = PLIbook_SetMipd_compiletf;
  tf_data.sizetf    = NULL;
  vpi_register_systf(&tf_data);
}
/*********************************************************************/

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_SetMipd_calltf(char *user_data) {
  vpiHandle tfarg_itr, tfarg_h, port_itr, port_h;
  int i; 
  s_vpi_delay delay_struct;    /* structure to delay setup */ 
  s_vpi_time  delay_array[3];  /* structure to hold delays */ 
  s_vpi_value tfarg_value;     /* structure to hold tfarg values */ 

  delay_struct.da           = delay_array;
  delay_struct.no_of_delays = 3;
  delay_struct.time_type    = vpiScaledRealTime;
  delay_struct.mtm_flag     = 0;
  delay_struct.append_flag  = 0;
  delay_struct.pulsere_flag = 0;
  tfarg_value.format        = vpiRealVal;

  /* obtain handle to system task arguments;
     compiletf has already verified only 4 args with correct types */
  tfarg_itr = vpi_iterate(vpiArgument, vpi_handle(vpiSysTfCall, NULL));
  tfarg_h = vpi_scan(tfarg_itr); /* read 1st tfarg */
  port_itr = vpi_iterate(vpiPort, tfarg_h);
  port_h = vpi_scan(port_itr);
  vpi_free_object(port_itr); /* free iterator--did not scan to null */
  for (i=0; i<=2; i++) {
    vpi_get_value(vpi_scan(tfarg_itr), &tfarg_value); /* read tfargs */
    delay_array[i].real = tfarg_value.value.real;
  }
  vpi_free_object(tfarg_itr); /* free iterator--did not scan to null */

  vpi_put_delays(port_h, &delay_struct);
}

/**********************************************************************
 * compiletf routine
 *********************************************************************/
int PLIbook_SetMipd_compiletf(char *user_data)
{
  vpiHandle   systf_h, tfarg_itr, tfarg_h, port_itr, port_h;
  int i;
  
  systf_h = vpi_handle(vpiSysTfCall, NULL);
  tfarg_itr = vpi_iterate(vpiArgument, systf_h);
  if (tfarg_itr == NULL) {
    vpi_printf("ERROR: $mipd_delays requires 4 arguments\n");
    tf_dofinish();
    return(0);
  }

  tfarg_h = vpi_scan(tfarg_itr);
  if (vpi_get(vpiType, tfarg_h) != vpiNet) {
    vpi_printf("ERROR: $mipd_delays arg1 must be module input\n");
    tf_dofinish();
    return(0);
  }

  port_itr = vpi_iterate(vpiPort, tfarg_h);
  if (port_itr == NULL) {
    vpi_printf("$mipd_delays arg1 not connected to module port\n");
    tf_dofinish();
    return(0);
  }
  port_h = vpi_scan(port_itr);
  vpi_free_object(port_itr); /* free iterator--did not scan to null */
  if (vpi_get(vpiType, port_h) != vpiPort) {
    vpi_printf("$mipd_delays arg1 not connected to an input port\n");
    tf_dofinish();
    return(0);
  }

  for (i=2; i<=4; i++) {
    tfarg_h = vpi_scan(tfarg_itr);
    if (vpi_get(vpiType, tfarg_h) != vpiConstant) {
      vpi_printf("$mipd_delays arg %d must be a number\n", i);
      tf_dofinish();
      return(0);
    }
  }
  if (vpi_scan(tfarg_itr) != NULL) {
    vpi_printf("ERROR: $mipd_delays requires only 4 arguments\n");
    vpi_free_object(tfarg_itr); /* free iterator--did not scan to null*/
    tf_dofinish();
    return(0);
  }

  return(0);
}

/*********************************************************************/

