# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BaseImageDependencyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the base image dependency."""

    BUILD_TIME = "BuildTime"
    RUN_TIME = "RunTime"


class BaseImageTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the auto trigger for base image dependency updates."""

    ALL = "All"
    RUNTIME = "Runtime"
    NONE = "None"


class BuildArgumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the argument."""

    DOCKER_BUILD_ARGUMENT = "DockerBuildArgument"


class BuildStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the build."""

    QUEUED = "Queued"
    STARTED = "Started"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ERROR = "Error"
    TIMEOUT = "Timeout"


class BuildStepType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the step."""

    DOCKER = "Docker"


class BuildTaskStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of build task."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class BuildType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of build."""

    AUTO_BUILD = "AutoBuild"
    QUICK_BUILD = "QuickBuild"


class OsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operating system type required for the build."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a build."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class SourceControlType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of source control service."""

    GITHUB = "Github"
    VISUAL_STUDIO_TEAM_SERVICE = "VisualStudioTeamService"


class TokenType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Auth token."""

    PAT = "PAT"
    O_AUTH = "OAuth"
