# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, List, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class PhoneNumberAdministrationOperations(object):
    """PhoneNumberAdministrationOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.communication.administration.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get_all_phone_numbers(
        self,
        locale="en-US",  # type: Optional[str]
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.AcquiredPhoneNumbers"]
        """Gets the list of the acquired phone numbers.

        Gets the list of the acquired phone numbers.

        :param locale: A language-locale pairing which will be used to localize the names of countries.
        :type locale: str
        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AcquiredPhoneNumbers or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.AcquiredPhoneNumbers]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.AcquiredPhoneNumbers"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_all_phone_numbers.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if locale is not None:
                    query_parameters['locale'] = self._serialize.query("locale", locale, 'str')
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('AcquiredPhoneNumbers', pipeline_response)
            list_of_elem = deserialized.phone_numbers
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_all_phone_numbers.metadata = {'url': '/administration/phonenumbers/phonenumbers'}  # type: ignore

    def get_all_area_codes(
        self,
        location_type,  # type: str
        country_code,  # type: str
        phone_plan_id,  # type: str
        location_options=None,  # type: Optional[List["models.LocationOptionsQuery"]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.AreaCodes"
        """Gets a list of the supported area codes.

        Gets a list of the supported area codes.

        :param location_type: The type of location information required by the plan.
        :type location_type: str
        :param country_code: The ISO 3166-2 country code.
        :type country_code: str
        :param phone_plan_id: The plan id from which to search area codes.
        :type phone_plan_id: str
        :param location_options: Represents the underlying list of countries.
        :type location_options: list[~azure.communication.administration.models.LocationOptionsQuery]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AreaCodes, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.AreaCodes
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.AreaCodes"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.LocationOptionsQueries(location_options=location_options)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.get_all_area_codes.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'countryCode': self._serialize.url("country_code", country_code, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['locationType'] = self._serialize.query("location_type", location_type, 'str')
        query_parameters['phonePlanId'] = self._serialize.query("phone_plan_id", phone_plan_id, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'LocationOptionsQueries')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('AreaCodes', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_all_area_codes.metadata = {'url': '/administration/phonenumbers/countries/{countryCode}/areacodes'}  # type: ignore

    def get_capabilities_update(
        self,
        capabilities_update_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.UpdatePhoneNumberCapabilitiesResponse"
        """Get capabilities by capabilities update id.

        Get capabilities by capabilities update id.

        :param capabilities_update_id:
        :type capabilities_update_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: UpdatePhoneNumberCapabilitiesResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.UpdatePhoneNumberCapabilitiesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.UpdatePhoneNumberCapabilitiesResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.get_capabilities_update.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'capabilitiesUpdateId': self._serialize.url("capabilities_update_id", capabilities_update_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('UpdatePhoneNumberCapabilitiesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_capabilities_update.metadata = {'url': '/administration/phonenumbers/capabilities/{capabilitiesUpdateId}'}  # type: ignore

    def update_capabilities(
        self,
        phone_number_capabilities_update,  # type: Dict[str, "models.NumberUpdateCapabilities"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.UpdateNumberCapabilitiesResponse"
        """Adds or removes phone number capabilities.

        Adds or removes phone number capabilities.

        :param phone_number_capabilities_update: The map of phone numbers to the capabilities update
         applied to the phone number.
        :type phone_number_capabilities_update: dict[str, ~azure.communication.administration.models.NumberUpdateCapabilities]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: UpdateNumberCapabilitiesResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.UpdateNumberCapabilitiesResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.UpdateNumberCapabilitiesResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.UpdateNumberCapabilitiesRequest(phone_number_capabilities_update=phone_number_capabilities_update)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.update_capabilities.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'UpdateNumberCapabilitiesRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('UpdateNumberCapabilitiesResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_capabilities.metadata = {'url': '/administration/phonenumbers/capabilities'}  # type: ignore

    def get_all_supported_countries(
        self,
        locale="en-US",  # type: Optional[str]
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PhoneNumberCountries"]
        """Gets a list of supported countries.

        Gets a list of supported countries.

        :param locale: A language-locale pairing which will be used to localize the names of countries.
        :type locale: str
        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PhoneNumberCountries or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.PhoneNumberCountries]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhoneNumberCountries"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_all_supported_countries.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if locale is not None:
                    query_parameters['locale'] = self._serialize.query("locale", locale, 'str')
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PhoneNumberCountries', pipeline_response)
            list_of_elem = deserialized.countries
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_all_supported_countries.metadata = {'url': '/administration/phonenumbers/countries'}  # type: ignore

    def get_number_configuration(
        self,
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.NumberConfigurationResponse"
        """Endpoint for getting number configurations.

        Endpoint for getting number configurations.

        :param phone_number: The phone number in the E.164 format.
        :type phone_number: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: NumberConfigurationResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.NumberConfigurationResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.NumberConfigurationResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.NumberConfigurationPhoneNumber(phone_number=phone_number)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.get_number_configuration.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'NumberConfigurationPhoneNumber')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('NumberConfigurationResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_number_configuration.metadata = {'url': '/administration/phonenumbers/numberconfiguration'}  # type: ignore

    def configure_number(
        self,
        pstn_configuration,  # type: "models.PstnConfiguration"
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Endpoint for configuring a pstn number.

        Endpoint for configuring a pstn number.

        :param pstn_configuration: Definition for pstn number configuration.
        :type pstn_configuration: ~azure.communication.administration.models.PstnConfiguration
        :param phone_number: The phone number to configure.
        :type phone_number: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.NumberConfiguration(pstn_configuration=pstn_configuration, phone_number=phone_number)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.configure_number.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'NumberConfiguration')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    configure_number.metadata = {'url': '/administration/phonenumbers/numberconfiguration/configure'}  # type: ignore

    def unconfigure_number(
        self,
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Endpoint for unconfiguring a pstn number by removing the configuration.

        Endpoint for unconfiguring a pstn number by removing the configuration.

        :param phone_number: The phone number in the E.164 format.
        :type phone_number: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.NumberConfigurationPhoneNumber(phone_number=phone_number)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.unconfigure_number.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'NumberConfigurationPhoneNumber')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    unconfigure_number.metadata = {'url': '/administration/phonenumbers/numberconfiguration/unconfigure'}  # type: ignore

    def get_phone_plan_groups(
        self,
        country_code,  # type: str
        locale="en-US",  # type: Optional[str]
        include_rate_information=False,  # type: Optional[bool]
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PhonePlanGroups"]
        """Gets a list of phone plan groups for the given country.

        Gets a list of phone plan groups for the given country.

        :param country_code: The ISO 3166-2 country code.
        :type country_code: str
        :param locale: A language-locale pairing which will be used to localize the names of countries.
        :type locale: str
        :param include_rate_information:
        :type include_rate_information: bool
        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PhonePlanGroups or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.PhonePlanGroups]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhonePlanGroups"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_phone_plan_groups.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'countryCode': self._serialize.url("country_code", country_code, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if locale is not None:
                    query_parameters['locale'] = self._serialize.query("locale", locale, 'str')
                if include_rate_information is not None:
                    query_parameters['includeRateInformation'] = self._serialize.query("include_rate_information", include_rate_information, 'bool')
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'countryCode': self._serialize.url("country_code", country_code, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PhonePlanGroups', pipeline_response)
            list_of_elem = deserialized.phone_plan_groups
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_phone_plan_groups.metadata = {'url': '/administration/phonenumbers/countries/{countryCode}/phoneplangroups'}  # type: ignore

    def get_phone_plans(
        self,
        country_code,  # type: str
        phone_plan_group_id,  # type: str
        locale="en-US",  # type: Optional[str]
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PhonePlansResponse"]
        """Gets a list of phone plans for a phone plan group.

        Gets a list of phone plans for a phone plan group.

        :param country_code: The ISO 3166-2 country code.
        :type country_code: str
        :param phone_plan_group_id:
        :type phone_plan_group_id: str
        :param locale: A language-locale pairing which will be used to localize the names of countries.
        :type locale: str
        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PhonePlansResponse or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.PhonePlansResponse]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhonePlansResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_phone_plans.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'countryCode': self._serialize.url("country_code", country_code, 'str'),
                    'phonePlanGroupId': self._serialize.url("phone_plan_group_id", phone_plan_group_id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if locale is not None:
                    query_parameters['locale'] = self._serialize.query("locale", locale, 'str')
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'countryCode': self._serialize.url("country_code", country_code, 'str'),
                    'phonePlanGroupId': self._serialize.url("phone_plan_group_id", phone_plan_group_id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PhonePlansResponse', pipeline_response)
            list_of_elem = deserialized.phone_plans
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_phone_plans.metadata = {'url': '/administration/phonenumbers/countries/{countryCode}/phoneplangroups/{phonePlanGroupId}/phoneplans'}  # type: ignore

    def get_phone_plan_location_options(
        self,
        country_code,  # type: str
        phone_plan_group_id,  # type: str
        phone_plan_id,  # type: str
        locale="en-US",  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.LocationOptionsResponse"
        """Gets a list of location options for a phone plan.

        Gets a list of location options for a phone plan.

        :param country_code: The ISO 3166-2 country code.
        :type country_code: str
        :param phone_plan_group_id:
        :type phone_plan_group_id: str
        :param phone_plan_id:
        :type phone_plan_id: str
        :param locale: A language-locale pairing which will be used to localize the names of countries.
        :type locale: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LocationOptionsResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.LocationOptionsResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.LocationOptionsResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.get_phone_plan_location_options.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'countryCode': self._serialize.url("country_code", country_code, 'str'),
            'phonePlanGroupId': self._serialize.url("phone_plan_group_id", phone_plan_group_id, 'str'),
            'phonePlanId': self._serialize.url("phone_plan_id", phone_plan_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if locale is not None:
            query_parameters['locale'] = self._serialize.query("locale", locale, 'str')
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LocationOptionsResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_phone_plan_location_options.metadata = {'url': '/administration/phonenumbers/countries/{countryCode}/phoneplangroups/{phonePlanGroupId}/phoneplans/{phonePlanId}/locationoptions'}  # type: ignore

    def get_release_by_id(
        self,
        release_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.PhoneNumberRelease"
        """Gets a release by a release id.

        Gets a release by a release id.

        :param release_id: Represents the release id.
        :type release_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PhoneNumberRelease, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.PhoneNumberRelease
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhoneNumberRelease"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.get_release_by_id.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'releaseId': self._serialize.url("release_id", release_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PhoneNumberRelease', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_release_by_id.metadata = {'url': '/administration/phonenumbers/releases/{releaseId}'}  # type: ignore

    def release_phone_numbers(
        self,
        phone_numbers,  # type: List[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.ReleaseResponse"
        """Creates a release for the given phone numbers.

        Creates a release for the given phone numbers.

        :param phone_numbers: The list of phone numbers in the release request.
        :type phone_numbers: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReleaseResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.ReleaseResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.ReleaseResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))

        _body = models.ReleaseRequest(phone_numbers=phone_numbers)
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.release_phone_numbers.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        if _body is not None:
            body_content = self._serialize.body(_body, 'ReleaseRequest')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ReleaseResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    release_phone_numbers.metadata = {'url': '/administration/phonenumbers/releases'}  # type: ignore

    def get_all_releases(
        self,
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PhoneNumberEntities"]
        """Gets a list of all releases.

        Gets a list of all releases.

        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PhoneNumberEntities or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.PhoneNumberEntities]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhoneNumberEntities"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_all_releases.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PhoneNumberEntities', pipeline_response)
            list_of_elem = deserialized.entities
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_all_releases.metadata = {'url': '/administration/phonenumbers/releases'}  # type: ignore

    def get_search_by_id(
        self,
        search_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.PhoneNumberReservation"
        """Get search by search id.

        Get search by search id.

        :param search_id: The search id to be searched for.
        :type search_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PhoneNumberReservation, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.PhoneNumberReservation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhoneNumberReservation"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.get_search_by_id.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'searchId': self._serialize.url("search_id", search_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PhoneNumberReservation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_search_by_id.metadata = {'url': '/administration/phonenumbers/searches/{searchId}'}  # type: ignore

    def create_search(
        self,
        body=None,  # type: Optional["models.CreateSearchOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.CreateSearchResponse"
        """Creates a phone number search.

        Creates a phone number search.

        :param body: Defines the search options.
        :type body: ~azure.communication.administration.models.CreateSearchOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CreateSearchResponse, or the result of cls(response)
        :rtype: ~azure.communication.administration.models.CreateSearchResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.CreateSearchResponse"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.create_search.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        if body is not None:
            body_content = self._serialize.body(body, 'CreateSearchOptions')
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CreateSearchResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_search.metadata = {'url': '/administration/phonenumbers/searches'}  # type: ignore

    def get_all_searches(
        self,
        skip=0,  # type: Optional[int]
        take=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.PhoneNumberEntities"]
        """Gets a list of all searches.

        Gets a list of all searches.

        :param skip: An optional parameter for how many entries to skip, for pagination purposes.
        :type skip: int
        :param take: An optional parameter for how many entries to return, for pagination purposes.
        :type take: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PhoneNumberEntities or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.communication.administration.models.PhoneNumberEntities]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.PhoneNumberEntities"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_all_searches.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if skip is not None:
                    query_parameters['skip'] = self._serialize.query("skip", skip, 'int')
                if take is not None:
                    query_parameters['take'] = self._serialize.query("take", take, 'int')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('PhoneNumberEntities', pipeline_response)
            list_of_elem = deserialized.entities
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_all_searches.metadata = {'url': '/administration/phonenumbers/searches'}  # type: ignore

    def cancel_search(
        self,
        search_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Cancels the search. This means existing numbers in the search will be made available.

        Cancels the search. This means existing numbers in the search will be made available.

        :param search_id: The search id to be canceled.
        :type search_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.cancel_search.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'searchId': self._serialize.url("search_id", search_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_search.metadata = {'url': '/administration/phonenumbers/searches/{searchId}/cancel'}  # type: ignore

    def purchase_search(
        self,
        search_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Purchases the phone number search.

        Purchases the phone number search.

        :param search_id: The search id to be purchased.
        :type search_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-20-preview1"

        # Construct URL
        url = self.purchase_search.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'searchId': self._serialize.url("search_id", search_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purchase_search.metadata = {'url': '/administration/phonenumbers/searches/{searchId}/purchase'}  # type: ignore
