# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class DatastoreCredentials(_serialization.Model):
    """Base definition for datastore credentials.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccountKeyDatastoreCredentials, CertificateDatastoreCredentials, NoneDatastoreCredentials,
    SasDatastoreCredentials, ServicePrincipalDatastoreCredentials

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "AccountKey", "Certificate", "None", "Sas", and "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        "credentials_type": {"required": True},
    }

    _attribute_map = {
        "credentials_type": {"key": "credentialsType", "type": "str"},
    }

    _subtype_map = {
        "credentials_type": {
            "AccountKey": "AccountKeyDatastoreCredentials",
            "Certificate": "CertificateDatastoreCredentials",
            "None": "NoneDatastoreCredentials",
            "Sas": "SasDatastoreCredentials",
            "ServicePrincipal": "ServicePrincipalDatastoreCredentials",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.credentials_type: Optional[str] = None


class AccountKeyDatastoreCredentials(DatastoreCredentials):
    """Account key datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "AccountKey", "Certificate", "None", "Sas", and "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: [Required] Storage account secrets. Required.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
    """

    _validation = {
        "credentials_type": {"required": True},
        "secrets": {"required": True},
    }

    _attribute_map = {
        "credentials_type": {"key": "credentialsType", "type": "str"},
        "secrets": {"key": "secrets", "type": "AccountKeyDatastoreSecrets"},
    }

    def __init__(self, *, secrets: "_models.AccountKeyDatastoreSecrets", **kwargs: Any) -> None:
        """
        :keyword secrets: [Required] Storage account secrets. Required.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
        """
        super().__init__(**kwargs)
        self.credentials_type: str = "AccountKey"
        self.secrets = secrets


class DatastoreSecrets(_serialization.Model):
    """Base definition for datastore secrets.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccountKeyDatastoreSecrets, CertificateDatastoreSecrets, SasDatastoreSecrets,
    ServicePrincipalDatastoreSecrets

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: [Required] Credential type used to authentication with storage. Required.
     Known values are: "AccountKey", "Certificate", "Sas", and "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    """

    _validation = {
        "secrets_type": {"required": True},
    }

    _attribute_map = {
        "secrets_type": {"key": "secretsType", "type": "str"},
    }

    _subtype_map = {
        "secrets_type": {
            "AccountKey": "AccountKeyDatastoreSecrets",
            "Certificate": "CertificateDatastoreSecrets",
            "Sas": "SasDatastoreSecrets",
            "ServicePrincipal": "ServicePrincipalDatastoreSecrets",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.secrets_type: Optional[str] = None


class AccountKeyDatastoreSecrets(DatastoreSecrets):
    """Datastore account key secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: [Required] Credential type used to authentication with storage. Required.
     Known values are: "AccountKey", "Certificate", "Sas", and "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar key: Storage account key.
    :vartype key: str
    """

    _validation = {
        "secrets_type": {"required": True},
    }

    _attribute_map = {
        "secrets_type": {"key": "secretsType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Storage account key.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.secrets_type: str = "AccountKey"
        self.key = key


class AcrDetails(_serialization.Model):
    """Details of ACR account to be used for the Registry.

    :ivar system_created_acr_account: Details of system created ACR account to be used for the
     Registry.
    :vartype system_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
    :ivar user_created_acr_account: Details of user created ACR account to be used for the
     Registry.
    :vartype user_created_acr_account:
     ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
    """

    _attribute_map = {
        "system_created_acr_account": {"key": "systemCreatedAcrAccount", "type": "SystemCreatedAcrAccount"},
        "user_created_acr_account": {"key": "userCreatedAcrAccount", "type": "UserCreatedAcrAccount"},
    }

    def __init__(
        self,
        *,
        system_created_acr_account: Optional["_models.SystemCreatedAcrAccount"] = None,
        user_created_acr_account: Optional["_models.UserCreatedAcrAccount"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword system_created_acr_account: Details of system created ACR account to be used for the
         Registry.
        :paramtype system_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.SystemCreatedAcrAccount
        :keyword user_created_acr_account: Details of user created ACR account to be used for the
         Registry.
        :paramtype user_created_acr_account:
         ~azure.mgmt.machinelearningservices.models.UserCreatedAcrAccount
        """
        super().__init__(**kwargs)
        self.system_created_acr_account = system_created_acr_account
        self.user_created_acr_account = user_created_acr_account


class AKSSchema(_serialization.Model):
    """AKSSchema.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AKSSchemaProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AKSSchemaProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class Compute(_serialization.Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AKS, AmlCompute, ComputeInstance, DataFactory, DataLakeAnalytics, Databricks, HDInsight,
    Kubernetes, SynapseSpark, VirtualMachine

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    _subtype_map = {
        "compute_type": {
            "AKS": "AKS",
            "AmlCompute": "AmlCompute",
            "ComputeInstance": "ComputeInstance",
            "DataFactory": "DataFactory",
            "DataLakeAnalytics": "DataLakeAnalytics",
            "Databricks": "Databricks",
            "HDInsight": "HDInsight",
            "Kubernetes": "Kubernetes",
            "SynapseSpark": "SynapseSpark",
            "VirtualMachine": "VirtualMachine",
        }
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(**kwargs)
        self.compute_type: Optional[str] = None
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AKS(Compute, AKSSchema):  # pylint: disable=too-many-instance-attributes
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "AKSSchemaProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.AKSSchemaProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSSchemaProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "AKS"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AksComputeSecretsProperties(_serialization.Model):
    """Properties of AksComputeSecrets.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    """

    _attribute_map = {
        "user_kube_config": {"key": "userKubeConfig", "type": "str"},
        "admin_kube_config": {"key": "adminKubeConfig", "type": "str"},
        "image_pull_secret_name": {"key": "imagePullSecretName", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super().__init__(**kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name


class ComputeSecrets(_serialization.Model):
    """Secrets related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AksComputeSecrets, DatabricksComputeSecrets, VirtualMachineSecrets

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        "compute_type": {"required": True},
    }

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
    }

    _subtype_map = {
        "compute_type": {
            "AKS": "AksComputeSecrets",
            "Databricks": "DatabricksComputeSecrets",
            "VirtualMachine": "VirtualMachineSecrets",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.compute_type: Optional[str] = None


class AksComputeSecrets(ComputeSecrets, AksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        "compute_type": {"required": True},
    }

    _attribute_map = {
        "user_kube_config": {"key": "userKubeConfig", "type": "str"},
        "admin_kube_config": {"key": "adminKubeConfig", "type": "str"},
        "image_pull_secret_name": {"key": "imagePullSecretName", "type": "str"},
        "compute_type": {"key": "computeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super().__init__(
            user_kube_config=user_kube_config,
            admin_kube_config=admin_kube_config,
            image_pull_secret_name=image_pull_secret_name,
            **kwargs
        )
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name
        self.compute_type: str = "AKS"


class AksNetworkingConfiguration(_serialization.Model):
    """Advance configuration for AKS networking.

    :ivar subnet_id: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet_id: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    """

    _validation = {
        "service_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "dns_service_ip": {
            "pattern": r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"
        },
        "docker_bridge_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "dns_service_ip": {"key": "dnsServiceIP", "type": "str"},
        "docker_bridge_cidr": {"key": "dockerBridgeCidr", "type": "str"},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet_id: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr


class AKSSchemaProperties(_serialization.Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_fqdn: Cluster full qualified domain name.
    :vartype cluster_fqdn: str
    :ivar system_services: System services.
    :vartype system_services: list[~azure.mgmt.machinelearningservices.models.SystemService]
    :ivar agent_count: Number of agents.
    :vartype agent_count: int
    :ivar agent_vm_size: Agent virtual machine size.
    :vartype agent_vm_size: str
    :ivar cluster_purpose: Intended usage of the cluster. Known values are: "FastProd",
     "DenseProd", and "DevTest".
    :vartype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
    :ivar ssl_configuration: SSL configuration.
    :vartype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :ivar aks_networking_configuration: AKS networking configuration for vnet.
    :vartype aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    :ivar load_balancer_type: Load Balancer Type. Known values are: "PublicIp" and
     "InternalLoadBalancer".
    :vartype load_balancer_type: str or ~azure.mgmt.machinelearningservices.models.LoadBalancerType
    :ivar load_balancer_subnet: Load Balancer Subnet.
    :vartype load_balancer_subnet: str
    """

    _validation = {
        "system_services": {"readonly": True},
        "agent_count": {"minimum": 0},
    }

    _attribute_map = {
        "cluster_fqdn": {"key": "clusterFqdn", "type": "str"},
        "system_services": {"key": "systemServices", "type": "[SystemService]"},
        "agent_count": {"key": "agentCount", "type": "int"},
        "agent_vm_size": {"key": "agentVmSize", "type": "str"},
        "cluster_purpose": {"key": "clusterPurpose", "type": "str"},
        "ssl_configuration": {"key": "sslConfiguration", "type": "SslConfiguration"},
        "aks_networking_configuration": {"key": "aksNetworkingConfiguration", "type": "AksNetworkingConfiguration"},
        "load_balancer_type": {"key": "loadBalancerType", "type": "str"},
        "load_balancer_subnet": {"key": "loadBalancerSubnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        cluster_fqdn: Optional[str] = None,
        agent_count: Optional[int] = None,
        agent_vm_size: Optional[str] = None,
        cluster_purpose: Union[str, "_models.ClusterPurpose"] = "FastProd",
        ssl_configuration: Optional["_models.SslConfiguration"] = None,
        aks_networking_configuration: Optional["_models.AksNetworkingConfiguration"] = None,
        load_balancer_type: Union[str, "_models.LoadBalancerType"] = "PublicIp",
        load_balancer_subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_fqdn: Cluster full qualified domain name.
        :paramtype cluster_fqdn: str
        :keyword agent_count: Number of agents.
        :paramtype agent_count: int
        :keyword agent_vm_size: Agent virtual machine size.
        :paramtype agent_vm_size: str
        :keyword cluster_purpose: Intended usage of the cluster. Known values are: "FastProd",
         "DenseProd", and "DevTest".
        :paramtype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
        :keyword ssl_configuration: SSL configuration.
        :paramtype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
        :keyword aks_networking_configuration: AKS networking configuration for vnet.
        :paramtype aks_networking_configuration:
         ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
        :keyword load_balancer_type: Load Balancer Type. Known values are: "PublicIp" and
         "InternalLoadBalancer".
        :paramtype load_balancer_type: str or
         ~azure.mgmt.machinelearningservices.models.LoadBalancerType
        :keyword load_balancer_subnet: Load Balancer Subnet.
        :paramtype load_balancer_subnet: str
        """
        super().__init__(**kwargs)
        self.cluster_fqdn = cluster_fqdn
        self.system_services = None
        self.agent_count = agent_count
        self.agent_vm_size = agent_vm_size
        self.cluster_purpose = cluster_purpose
        self.ssl_configuration = ssl_configuration
        self.aks_networking_configuration = aks_networking_configuration
        self.load_balancer_type = load_balancer_type
        self.load_balancer_subnet = load_balancer_subnet


class MonitoringFeatureFilterBase(_serialization.Model):
    """MonitoringFeatureFilterBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AllFeatures, FeatureSubset, TopNFeaturesByAttribution

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: [Required] Specifies the feature filter to leverage when selecting features
     to calculate metrics over. Required. Known values are: "AllFeatures", "TopNByAttribution", and
     "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    """

    _validation = {
        "filter_type": {"required": True},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
    }

    _subtype_map = {
        "filter_type": {
            "AllFeatures": "AllFeatures",
            "FeatureSubset": "FeatureSubset",
            "TopNByAttribution": "TopNFeaturesByAttribution",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.filter_type: Optional[str] = None


class AllFeatures(MonitoringFeatureFilterBase):
    """AllFeatures.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: [Required] Specifies the feature filter to leverage when selecting features
     to calculate metrics over. Required. Known values are: "AllFeatures", "TopNByAttribution", and
     "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    """

    _validation = {
        "filter_type": {"required": True},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.filter_type: str = "AllFeatures"


class Nodes(_serialization.Model):
    """Abstract Nodes definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AllNodes

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: [Required] Type of the Nodes value. Required. "All"
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        "nodes_value_type": {"required": True},
    }

    _attribute_map = {
        "nodes_value_type": {"key": "nodesValueType", "type": "str"},
    }

    _subtype_map = {"nodes_value_type": {"All": "AllNodes"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nodes_value_type: Optional[str] = None


class AllNodes(Nodes):
    """All nodes means the service will be running on all of the nodes of the job.

    All required parameters must be populated in order to send to Azure.

    :ivar nodes_value_type: [Required] Type of the Nodes value. Required. "All"
    :vartype nodes_value_type: str or ~azure.mgmt.machinelearningservices.models.NodesValueType
    """

    _validation = {
        "nodes_value_type": {"required": True},
    }

    _attribute_map = {
        "nodes_value_type": {"key": "nodesValueType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nodes_value_type: str = "All"


class AmlComputeSchema(_serialization.Model):
    """Properties(top level) of AmlCompute.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AmlComputeProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AmlComputeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AmlCompute(Compute, AmlComputeSchema):  # pylint: disable=too-many-instance-attributes
    """An Azure Machine Learning compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "AmlComputeProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.AmlComputeProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "AmlCompute"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AmlComputeNodeInformation(_serialization.Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar node_id: ID of the compute node.
    :vartype node_id: str
    :ivar private_ip_address: Private IP address of the compute node.
    :vartype private_ip_address: str
    :ivar public_ip_address: Public IP address of the compute node.
    :vartype public_ip_address: str
    :ivar port: SSH port number of the node.
    :vartype port: int
    :ivar node_state: State of the compute node. Values are idle, running, preparing, unusable,
     leaving and preempted. Known values are: "idle", "running", "preparing", "unusable", "leaving",
     and "preempted".
    :vartype node_state: str or ~azure.mgmt.machinelearningservices.models.NodeState
    :ivar run_id: ID of the Experiment running on the node, if any else null.
    :vartype run_id: str
    """

    _validation = {
        "node_id": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "public_ip_address": {"readonly": True},
        "port": {"readonly": True},
        "node_state": {"readonly": True},
        "run_id": {"readonly": True},
    }

    _attribute_map = {
        "node_id": {"key": "nodeId", "type": "str"},
        "private_ip_address": {"key": "privateIpAddress", "type": "str"},
        "public_ip_address": {"key": "publicIpAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "node_state": {"key": "nodeState", "type": "str"},
        "run_id": {"key": "runId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.node_id = None
        self.private_ip_address = None
        self.public_ip_address = None
        self.port = None
        self.node_state = None
        self.run_id = None


class AmlComputeNodesInformation(_serialization.Model):
    """Result of AmlCompute Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes: list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        "nodes": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "nodes": {"key": "nodes", "type": "[AmlComputeNodeInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nodes = None
        self.next_link = None


class AmlComputeProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: Compute OS Type. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar vm_priority: Virtual Machine priority. Known values are: "Dedicated" and "LowPriority".
    :vartype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
    :ivar virtual_machine_image: Virtual Machine image for AML Compute - windows only.
    :vartype virtual_machine_image: ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
    :ivar isolated_network: Network is isolated or not.
    :vartype isolated_network: bool
    :ivar scale_settings: Scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :ivar user_account_credentials: Credentials for an administrator user account that will be
     created on each compute node.
    :vartype user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar remote_login_port_public_access: State of the public SSH port. Possible values are:
     Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
     Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
     Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
     else is open all public nodes. It can be default only during cluster creation time, after
     creation it will be either enabled or disabled. Known values are: "Enabled", "Disabled", and
     "NotSpecified".
    :vartype remote_login_port_public_access: str or
     ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
    :ivar allocation_state: Allocation state of the compute. Possible values are: steady -
     Indicates that the compute is not resizing. There are no changes to the number of compute nodes
     in the compute in progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of compute nodes. resizing -
     Indicates that the compute is resizing; that is, compute nodes are being added to or removed
     from the compute. Known values are: "Steady" and "Resizing".
    :vartype allocation_state: str or ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the compute entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar errors: Collection of errors encountered by various compute nodes during node setup.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar current_node_count: The number of compute nodes currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: The target number of compute nodes for the compute. If the
     allocationState is resizing, this property denotes the target node count for the ongoing resize
     operation. If the allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Counts of various node states on the compute.
    :vartype node_state_counts: ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar property_bag: A property bag containing additional properties.
    :vartype property_bag: JSON
    """

    _validation = {
        "allocation_state": {"readonly": True},
        "allocation_state_transition_time": {"readonly": True},
        "errors": {"readonly": True},
        "current_node_count": {"readonly": True},
        "target_node_count": {"readonly": True},
        "node_state_counts": {"readonly": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "vm_priority": {"key": "vmPriority", "type": "str"},
        "virtual_machine_image": {"key": "virtualMachineImage", "type": "VirtualMachineImage"},
        "isolated_network": {"key": "isolatedNetwork", "type": "bool"},
        "scale_settings": {"key": "scaleSettings", "type": "ScaleSettings"},
        "user_account_credentials": {"key": "userAccountCredentials", "type": "UserAccountCredentials"},
        "subnet": {"key": "subnet", "type": "ResourceId"},
        "remote_login_port_public_access": {"key": "remoteLoginPortPublicAccess", "type": "str"},
        "allocation_state": {"key": "allocationState", "type": "str"},
        "allocation_state_transition_time": {"key": "allocationStateTransitionTime", "type": "iso-8601"},
        "errors": {"key": "errors", "type": "[ErrorResponse]"},
        "current_node_count": {"key": "currentNodeCount", "type": "int"},
        "target_node_count": {"key": "targetNodeCount", "type": "int"},
        "node_state_counts": {"key": "nodeStateCounts", "type": "NodeStateCounts"},
        "enable_node_public_ip": {"key": "enableNodePublicIp", "type": "bool"},
        "property_bag": {"key": "propertyBag", "type": "object"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OsType"] = "Linux",
        vm_size: Optional[str] = None,
        vm_priority: Optional[Union[str, "_models.VmPriority"]] = None,
        virtual_machine_image: Optional["_models.VirtualMachineImage"] = None,
        isolated_network: Optional[bool] = None,
        scale_settings: Optional["_models.ScaleSettings"] = None,
        user_account_credentials: Optional["_models.UserAccountCredentials"] = None,
        subnet: Optional["_models.ResourceId"] = None,
        remote_login_port_public_access: Union[str, "_models.RemoteLoginPortPublicAccess"] = "NotSpecified",
        enable_node_public_ip: bool = True,
        property_bag: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: Compute OS Type. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword vm_priority: Virtual Machine priority. Known values are: "Dedicated" and
         "LowPriority".
        :paramtype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
        :keyword virtual_machine_image: Virtual Machine image for AML Compute - windows only.
        :paramtype virtual_machine_image:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
        :keyword isolated_network: Network is isolated or not.
        :paramtype isolated_network: bool
        :keyword scale_settings: Scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        :keyword user_account_credentials: Credentials for an administrator user account that will be
         created on each compute node.
        :paramtype user_account_credentials:
         ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword remote_login_port_public_access: State of the public SSH port. Possible values are:
         Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
         Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
         Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
         else is open all public nodes. It can be default only during cluster creation time, after
         creation it will be either enabled or disabled. Known values are: "Enabled", "Disabled", and
         "NotSpecified".
        :paramtype remote_login_port_public_access: str or
         ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        :keyword property_bag: A property bag containing additional properties.
        :paramtype property_bag: JSON
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.vm_size = vm_size
        self.vm_priority = vm_priority
        self.virtual_machine_image = virtual_machine_image
        self.isolated_network = isolated_network
        self.scale_settings = scale_settings
        self.user_account_credentials = user_account_credentials
        self.subnet = subnet
        self.remote_login_port_public_access = remote_login_port_public_access
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None
        self.enable_node_public_ip = enable_node_public_ip
        self.property_bag = property_bag


class IdentityConfiguration(_serialization.Model):
    """Base definition for identity configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmlToken, ManagedIdentity, UserIdentity

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: [Required] Specifies the type of identity framework. Required. Known
     values are: "Managed", "AMLToken", and "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        "identity_type": {"required": True},
    }

    _attribute_map = {
        "identity_type": {"key": "identityType", "type": "str"},
    }

    _subtype_map = {
        "identity_type": {"AMLToken": "AmlToken", "Managed": "ManagedIdentity", "UserIdentity": "UserIdentity"}
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.identity_type: Optional[str] = None


class AmlToken(IdentityConfiguration):
    """AML Token identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: [Required] Specifies the type of identity framework. Required. Known
     values are: "Managed", "AMLToken", and "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        "identity_type": {"required": True},
    }

    _attribute_map = {
        "identity_type": {"key": "identityType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.identity_type: str = "AMLToken"


class MonitorComputeIdentityBase(_serialization.Model):
    """Monitor compute identity base definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmlTokenComputeIdentity, ManagedComputeIdentity

    All required parameters must be populated in order to send to Azure.

    :ivar compute_identity_type: [Required] Specifies the type of identity to use within the
     monitoring jobs. Required. Known values are: "AmlToken" and "ManagedIdentity".
    :vartype compute_identity_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityType
    """

    _validation = {
        "compute_identity_type": {"required": True},
    }

    _attribute_map = {
        "compute_identity_type": {"key": "computeIdentityType", "type": "str"},
    }

    _subtype_map = {
        "compute_identity_type": {"AmlToken": "AmlTokenComputeIdentity", "ManagedIdentity": "ManagedComputeIdentity"}
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.compute_identity_type: Optional[str] = None


class AmlTokenComputeIdentity(MonitorComputeIdentityBase):
    """AML token compute identity definition.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_identity_type: [Required] Specifies the type of identity to use within the
     monitoring jobs. Required. Known values are: "AmlToken" and "ManagedIdentity".
    :vartype compute_identity_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityType
    """

    _validation = {
        "compute_identity_type": {"required": True},
    }

    _attribute_map = {
        "compute_identity_type": {"key": "computeIdentityType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.compute_identity_type: str = "AmlToken"


class AmlUserFeature(_serialization.Model):
    """Features enabled for a workspace.

    :ivar id: Specifies the feature ID.
    :vartype id: str
    :ivar display_name: Specifies the feature name.
    :vartype display_name: str
    :ivar description: Describes the feature for user experience.
    :vartype description: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Specifies the feature ID.
        :paramtype id: str
        :keyword display_name: Specifies the feature name.
        :paramtype display_name: str
        :keyword description: Describes the feature for user experience.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description


class DataReferenceCredential(_serialization.Model):
    """DataReferenceCredential base class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DockerCredential, ManagedIdentityCredential, AnonymousAccessCredential, SASCredential

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "SAS", "DockerCredentials", "ManagedIdentity", and "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    """

    _validation = {
        "credential_type": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "credentialType", "type": "str"},
    }

    _subtype_map = {
        "credential_type": {
            "DockerCredentials": "DockerCredential",
            "ManagedIdentity": "ManagedIdentityCredential",
            "NoCredentials": "AnonymousAccessCredential",
            "SAS": "SASCredential",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.credential_type: Optional[str] = None


class AnonymousAccessCredential(DataReferenceCredential):
    """Access credential with no credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "SAS", "DockerCredentials", "ManagedIdentity", and "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    """

    _validation = {
        "credential_type": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "credentialType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.credential_type: str = "NoCredentials"


class ArmResourceId(_serialization.Model):
    """ARM ResourceId of a resource.

    :ivar resource_id: Arm ResourceId is in the format
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
     or
     "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: Arm ResourceId is in the format
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
         or
         "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}".
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class ResourceBase(_serialization.Model):
    """ResourceBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.description = description
        self.properties = properties
        self.tags = tags


class AssetBase(ResourceBase):
    """AssetBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.is_anonymous = is_anonymous
        self.is_archived = is_archived


class AssetContainer(ResourceBase):
    """AssetContainer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.is_archived = is_archived
        self.latest_version = None
        self.next_version = None


class AssetJobInput(_serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
     "Download", "Direct", "EvalMount", and "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self, *, uri: str, mode: Optional[Union[str, "_models.InputDeliveryMode"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
         "Download", "Direct", "EvalMount", and "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class AssetJobOutput(_serialization.Model):
    """Asset output type.

    :ivar mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class AssetReferenceBase(_serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataPathAssetReference, IdAssetReference, OutputPathAssetReference

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: [Required] Specifies the type of asset reference. Required. Known values
     are: "Id", "DataPath", and "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        "reference_type": {"required": True},
    }

    _attribute_map = {
        "reference_type": {"key": "referenceType", "type": "str"},
    }

    _subtype_map = {
        "reference_type": {
            "DataPath": "DataPathAssetReference",
            "Id": "IdAssetReference",
            "OutputPath": "OutputPathAssetReference",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.reference_type: Optional[str] = None


class AssignedUser(_serialization.Model):
    """A user that can be assigned to a compute instance.

    All required parameters must be populated in order to send to Azure.

    :ivar object_id: User’s AAD Object Id. Required.
    :vartype object_id: str
    :ivar tenant_id: User’s AAD Tenant Id. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "object_id": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "object_id": {"key": "objectId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, object_id: str, tenant_id: str, **kwargs: Any) -> None:
        """
        :keyword object_id: User’s AAD Object Id. Required.
        :paramtype object_id: str
        :keyword tenant_id: User’s AAD Tenant Id. Required.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class ForecastHorizon(_serialization.Model):
    """The desired maximum forecast horizon in units of time-series frequency.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoForecastHorizon, CustomForecastHorizon

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set forecast horizon value selection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    _subtype_map = {"mode": {"Auto": "AutoForecastHorizon", "Custom": "CustomForecastHorizon"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: Optional[str] = None


class AutoForecastHorizon(ForecastHorizon):
    """Forecast horizon determined automatically by system.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set forecast horizon value selection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: str = "Auto"


class JobBaseProperties(ResourceBase):  # pylint: disable=too-many-instance-attributes
    """Base definition for a job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoMLJob, CommandJob, PipelineJob, SweepJob

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: [Required] Specifies the type of job. Required. Known values are: "AutoML",
     "Command", "Sweep", and "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Known values are: "NotStarted", "Starting", "Provisioning",
     "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed", "Failed",
     "Canceled", "NotResponding", "Paused", and "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    """

    _validation = {
        "job_type": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "component_id": {"key": "componentId", "type": "str"},
        "compute_id": {"key": "computeId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "experiment_name": {"key": "experimentName", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityConfiguration"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "job_type": {"key": "jobType", "type": "str"},
        "services": {"key": "services", "type": "{JobService}"},
        "status": {"key": "status", "type": "str"},
    }

    _subtype_map = {
        "job_type": {"AutoML": "AutoMLJob", "Command": "CommandJob", "Pipeline": "PipelineJob", "Sweep": "SweepJob"}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: str = "Default",
        identity: Optional["_models.IdentityConfiguration"] = None,
        is_archived: bool = False,
        services: Optional[Dict[str, "_models.JobService"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        """
        super().__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.component_id = component_id
        self.compute_id = compute_id
        self.display_name = display_name
        self.experiment_name = experiment_name
        self.identity = identity
        self.is_archived = is_archived
        self.job_type: Optional[str] = None
        self.services = services
        self.status = None


class AutoMLJob(JobBaseProperties):  # pylint: disable=too-many-instance-attributes
    """AutoMLJob class.
    Use this class for executing AutoML tasks like Classification/Regression etc.
    See TaskType enum for all the tasks supported.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: [Required] Specifies the type of job. Required. Known values are: "AutoML",
     "Command", "Sweep", and "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Known values are: "NotStarted", "Starting", "Provisioning",
     "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed", "Failed",
     "Canceled", "NotResponding", "Paused", and "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar environment_id: The ARM resource ID of the Environment specification for the job.
     This is optional value to provide, if not provided, AutoML will default this to Production
     AutoML curated environment version when running the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar queue_settings: Queue settings for the job.
    :vartype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    :ivar task_details: [Required] This represents scenario which can be one of Tables/NLP/Image.
     Required.
    :vartype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
    """

    _validation = {
        "job_type": {"required": True},
        "status": {"readonly": True},
        "task_details": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "component_id": {"key": "componentId", "type": "str"},
        "compute_id": {"key": "computeId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "experiment_name": {"key": "experimentName", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityConfiguration"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "job_type": {"key": "jobType", "type": "str"},
        "services": {"key": "services", "type": "{JobService}"},
        "status": {"key": "status", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "outputs": {"key": "outputs", "type": "{JobOutput}"},
        "queue_settings": {"key": "queueSettings", "type": "QueueSettings"},
        "resources": {"key": "resources", "type": "JobResourceConfiguration"},
        "task_details": {"key": "taskDetails", "type": "AutoMLVertical"},
    }

    def __init__(
        self,
        *,
        task_details: "_models.AutoMLVertical",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: str = "Default",
        identity: Optional["_models.IdentityConfiguration"] = None,
        is_archived: bool = False,
        services: Optional[Dict[str, "_models.JobService"]] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        outputs: Optional[Dict[str, "_models.JobOutput"]] = None,
        queue_settings: Optional["_models.QueueSettings"] = None,
        resources: Optional["_models.JobResourceConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword environment_id: The ARM resource ID of the Environment specification for the job.
         This is optional value to provide, if not provided, AutoML will default this to Production
         AutoML curated environment version when running the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword queue_settings: Queue settings for the job.
        :paramtype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        :keyword task_details: [Required] This represents scenario which can be one of
         Tables/NLP/Image. Required.
        :paramtype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            component_id=component_id,
            compute_id=compute_id,
            display_name=display_name,
            experiment_name=experiment_name,
            identity=identity,
            is_archived=is_archived,
            services=services,
            **kwargs
        )
        self.job_type: str = "AutoML"
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.outputs = outputs
        self.queue_settings = queue_settings
        self.resources = resources
        self.task_details = task_details


class AutoMLVertical(_serialization.Model):
    """AutoML vertical class.
    Base class for AutoML verticals - TableVertical/ImageVertical/NLPVertical.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Classification, Forecasting, ImageClassification, ImageClassificationMultilabel,
    ImageInstanceSegmentation, ImageObjectDetection, Regression, TextClassification,
    TextClassificationMultilabel, TextNer

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
    }

    _subtype_map = {
        "task_type": {
            "Classification": "Classification",
            "Forecasting": "Forecasting",
            "ImageClassification": "ImageClassification",
            "ImageClassificationMultilabel": "ImageClassificationMultilabel",
            "ImageInstanceSegmentation": "ImageInstanceSegmentation",
            "ImageObjectDetection": "ImageObjectDetection",
            "Regression": "Regression",
            "TextClassification": "TextClassification",
            "TextClassificationMultilabel": "TextClassificationMultilabel",
            "TextNER": "TextNer",
        }
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super().__init__(**kwargs)
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: Optional[str] = None
        self.training_data = training_data


class NCrossValidations(_serialization.Model):
    """N-Cross validations value.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoNCrossValidations, CustomNCrossValidations

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Mode for determining N-Cross validations. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    _subtype_map = {"mode": {"Auto": "AutoNCrossValidations", "Custom": "CustomNCrossValidations"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: Optional[str] = None


class AutoNCrossValidations(NCrossValidations):
    """N-Cross validations determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Mode for determining N-Cross validations. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: str = "Auto"


class AutoPauseProperties(_serialization.Model):
    """Auto pause properties.

    :ivar delay_in_minutes:
    :vartype delay_in_minutes: int
    :ivar enabled:
    :vartype enabled: bool
    """

    _attribute_map = {
        "delay_in_minutes": {"key": "delayInMinutes", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self, *, delay_in_minutes: Optional[int] = None, enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword delay_in_minutes:
        :paramtype delay_in_minutes: int
        :keyword enabled:
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.delay_in_minutes = delay_in_minutes
        self.enabled = enabled


class AutoScaleProperties(_serialization.Model):
    """Auto scale properties.

    :ivar min_node_count:
    :vartype min_node_count: int
    :ivar enabled:
    :vartype enabled: bool
    :ivar max_node_count:
    :vartype max_node_count: int
    """

    _attribute_map = {
        "min_node_count": {"key": "minNodeCount", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
        "max_node_count": {"key": "maxNodeCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        min_node_count: Optional[int] = None,
        enabled: Optional[bool] = None,
        max_node_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_node_count:
        :paramtype min_node_count: int
        :keyword enabled:
        :paramtype enabled: bool
        :keyword max_node_count:
        :paramtype max_node_count: int
        """
        super().__init__(**kwargs)
        self.min_node_count = min_node_count
        self.enabled = enabled
        self.max_node_count = max_node_count


class Seasonality(_serialization.Model):
    """Forecasting seasonality.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoSeasonality, CustomSeasonality

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Seasonality mode. Required. Known values are: "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    _subtype_map = {"mode": {"Auto": "AutoSeasonality", "Custom": "CustomSeasonality"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: Optional[str] = None


class AutoSeasonality(Seasonality):
    """AutoSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Seasonality mode. Required. Known values are: "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: str = "Auto"


class TargetLags(_serialization.Model):
    """The number of past periods to lag from the target column.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoTargetLags, CustomTargetLags

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set target lags mode - Auto/Custom. Required. Known values are: "Auto"
     and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    _subtype_map = {"mode": {"Auto": "AutoTargetLags", "Custom": "CustomTargetLags"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: Optional[str] = None


class AutoTargetLags(TargetLags):
    """AutoTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set target lags mode - Auto/Custom. Required. Known values are: "Auto"
     and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: str = "Auto"


class TargetRollingWindowSize(_serialization.Model):
    """Forecasting target rolling window size.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutoTargetRollingWindowSize, CustomTargetRollingWindowSize

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] TargetRollingWindowSiz detection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    _subtype_map = {"mode": {"Auto": "AutoTargetRollingWindowSize", "Custom": "CustomTargetRollingWindowSize"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: Optional[str] = None


class AutoTargetRollingWindowSize(TargetRollingWindowSize):
    """Target lags rolling window determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] TargetRollingWindowSiz detection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mode: str = "Auto"


class DatastoreProperties(ResourceBase):
    """Base definition for datastore contents configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBlobDatastore, AzureDataLakeGen1Datastore, AzureDataLakeGen2Datastore, AzureFileDatastore

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: [Required] Account credentials. Required.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: [Required] Storage type backing the datastore. Required. Known values
     are: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2", and "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    """

    _validation = {
        "credentials": {"required": True},
        "datastore_type": {"required": True},
        "is_default": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "credentials": {"key": "credentials", "type": "DatastoreCredentials"},
        "datastore_type": {"key": "datastoreType", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
    }

    _subtype_map = {
        "datastore_type": {
            "AzureBlob": "AzureBlobDatastore",
            "AzureDataLakeGen1": "AzureDataLakeGen1Datastore",
            "AzureDataLakeGen2": "AzureDataLakeGen2Datastore",
            "AzureFile": "AzureFileDatastore",
        }
    }

    def __init__(
        self,
        *,
        credentials: "_models.DatastoreCredentials",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: [Required] Account credentials. Required.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        """
        super().__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.credentials = credentials
        self.datastore_type: Optional[str] = None
        self.is_default = None


class AzureDatastore(_serialization.Model):
    """Base definition for Azure datastore contents configuration.

    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    """

    _attribute_map = {
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self, *, resource_group: Optional[str] = None, subscription_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class AzureBlobDatastore(AzureDatastore, DatastoreProperties):  # pylint: disable=too-many-instance-attributes
    """Azure Blob datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: [Required] Account credentials. Required.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: [Required] Storage type backing the datastore. Required. Known values
     are: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2", and "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar account_name: Storage account name.
    :vartype account_name: str
    :ivar container_name: Storage account container name.
    :vartype container_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Known values are: "None",
     "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        "credentials": {"required": True},
        "datastore_type": {"required": True},
        "is_default": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "credentials": {"key": "credentials", "type": "DatastoreCredentials"},
        "datastore_type": {"key": "datastoreType", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "service_data_access_auth_identity": {"key": "serviceDataAccessAuthIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: "_models.DatastoreCredentials",
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        account_name: Optional[str] = None,
        container_name: Optional[str] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "_models.ServiceDataAccessAuthIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: [Required] Account credentials. Required.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        :keyword container_name: Storage account container name.
        :paramtype container_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Known values are: "None",
         "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super().__init__(
            resource_group=resource_group,
            subscription_id=subscription_id,
            description=description,
            properties=properties,
            tags=tags,
            credentials=credentials,
            **kwargs
        )
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.datastore_type: str = "AzureBlob"
        self.is_default = None
        self.account_name = account_name
        self.container_name = container_name
        self.endpoint = endpoint
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class AzureDataLakeGen1Datastore(AzureDatastore, DatastoreProperties):
    """Azure Data Lake Gen1 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: [Required] Account credentials. Required.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: [Required] Storage type backing the datastore. Required. Known values
     are: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2", and "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Known values are: "None",
     "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    :ivar store_name: [Required] Azure Data Lake store name. Required.
    :vartype store_name: str
    """

    _validation = {
        "credentials": {"required": True},
        "datastore_type": {"required": True},
        "is_default": {"readonly": True},
        "store_name": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "credentials": {"key": "credentials", "type": "DatastoreCredentials"},
        "datastore_type": {"key": "datastoreType", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "service_data_access_auth_identity": {"key": "serviceDataAccessAuthIdentity", "type": "str"},
        "store_name": {"key": "storeName", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: "_models.DatastoreCredentials",
        store_name: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "_models.ServiceDataAccessAuthIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: [Required] Account credentials. Required.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Known values are: "None",
         "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        :keyword store_name: [Required] Azure Data Lake store name. Required.
        :paramtype store_name: str
        """
        super().__init__(
            resource_group=resource_group,
            subscription_id=subscription_id,
            description=description,
            properties=properties,
            tags=tags,
            credentials=credentials,
            **kwargs
        )
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.datastore_type: str = "AzureDataLakeGen1"
        self.is_default = None
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.store_name = store_name
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class AzureDataLakeGen2Datastore(AzureDatastore, DatastoreProperties):  # pylint: disable=too-many-instance-attributes
    """Azure Data Lake Gen2 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: [Required] Account credentials. Required.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: [Required] Storage type backing the datastore. Required. Known values
     are: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2", and "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar account_name: [Required] Storage account name. Required.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar filesystem: [Required] The name of the Data Lake Gen2 filesystem. Required.
    :vartype filesystem: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Known values are: "None",
     "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        "credentials": {"required": True},
        "datastore_type": {"required": True},
        "is_default": {"readonly": True},
        "account_name": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "filesystem": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "credentials": {"key": "credentials", "type": "DatastoreCredentials"},
        "datastore_type": {"key": "datastoreType", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "filesystem": {"key": "filesystem", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "service_data_access_auth_identity": {"key": "serviceDataAccessAuthIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: "_models.DatastoreCredentials",
        account_name: str,
        filesystem: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "_models.ServiceDataAccessAuthIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: [Required] Account credentials. Required.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword account_name: [Required] Storage account name. Required.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword filesystem: [Required] The name of the Data Lake Gen2 filesystem. Required.
        :paramtype filesystem: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Known values are: "None",
         "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super().__init__(
            resource_group=resource_group,
            subscription_id=subscription_id,
            description=description,
            properties=properties,
            tags=tags,
            credentials=credentials,
            **kwargs
        )
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.datastore_type: str = "AzureDataLakeGen2"
        self.is_default = None
        self.account_name = account_name
        self.endpoint = endpoint
        self.filesystem = filesystem
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class Webhook(_serialization.Model):
    """Webhook base.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDevOpsWebhook

    All required parameters must be populated in order to send to Azure.

    :ivar event_type: Send callback on a specified notification event.
    :vartype event_type: str
    :ivar webhook_type: [Required] Specifies the type of service to send a callback. Required.
     "AzureDevOps"
    :vartype webhook_type: str or ~azure.mgmt.machinelearningservices.models.WebhookType
    """

    _validation = {
        "webhook_type": {"required": True},
    }

    _attribute_map = {
        "event_type": {"key": "eventType", "type": "str"},
        "webhook_type": {"key": "webhookType", "type": "str"},
    }

    _subtype_map = {"webhook_type": {"AzureDevOps": "AzureDevOpsWebhook"}}

    def __init__(self, *, event_type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword event_type: Send callback on a specified notification event.
        :paramtype event_type: str
        """
        super().__init__(**kwargs)
        self.event_type = event_type
        self.webhook_type: Optional[str] = None


class AzureDevOpsWebhook(Webhook):
    """Webhook details specific for Azure DevOps.

    All required parameters must be populated in order to send to Azure.

    :ivar event_type: Send callback on a specified notification event.
    :vartype event_type: str
    :ivar webhook_type: [Required] Specifies the type of service to send a callback. Required.
     "AzureDevOps"
    :vartype webhook_type: str or ~azure.mgmt.machinelearningservices.models.WebhookType
    """

    _validation = {
        "webhook_type": {"required": True},
    }

    _attribute_map = {
        "event_type": {"key": "eventType", "type": "str"},
        "webhook_type": {"key": "webhookType", "type": "str"},
    }

    def __init__(self, *, event_type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword event_type: Send callback on a specified notification event.
        :paramtype event_type: str
        """
        super().__init__(event_type=event_type, **kwargs)
        self.webhook_type: str = "AzureDevOps"


class AzureFileDatastore(AzureDatastore, DatastoreProperties):  # pylint: disable=too-many-instance-attributes
    """Azure File datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: [Required] Account credentials. Required.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: [Required] Storage type backing the datastore. Required. Known values
     are: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2", and "AzureFile".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar resource_group: Azure Resource Group name.
    :vartype resource_group: str
    :ivar subscription_id: Azure Subscription Id.
    :vartype subscription_id: str
    :ivar account_name: [Required] Storage account name. Required.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar file_share_name: [Required] The name of the Azure file share that the datastore points
     to. Required.
    :vartype file_share_name: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Known values are: "None",
     "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        "credentials": {"required": True},
        "datastore_type": {"required": True},
        "is_default": {"readonly": True},
        "account_name": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "file_share_name": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "credentials": {"key": "credentials", "type": "DatastoreCredentials"},
        "datastore_type": {"key": "datastoreType", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "file_share_name": {"key": "fileShareName", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "service_data_access_auth_identity": {"key": "serviceDataAccessAuthIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        credentials: "_models.DatastoreCredentials",
        account_name: str,
        file_share_name: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        resource_group: Optional[str] = None,
        subscription_id: Optional[str] = None,
        endpoint: Optional[str] = None,
        protocol: Optional[str] = None,
        service_data_access_auth_identity: Optional[Union[str, "_models.ServiceDataAccessAuthIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: [Required] Account credentials. Required.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword resource_group: Azure Resource Group name.
        :paramtype resource_group: str
        :keyword subscription_id: Azure Subscription Id.
        :paramtype subscription_id: str
        :keyword account_name: [Required] Storage account name. Required.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword file_share_name: [Required] The name of the Azure file share that the datastore points
         to. Required.
        :paramtype file_share_name: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Known values are: "None",
         "WorkspaceSystemAssignedIdentity", and "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super().__init__(
            resource_group=resource_group,
            subscription_id=subscription_id,
            description=description,
            properties=properties,
            tags=tags,
            credentials=credentials,
            **kwargs
        )
        self.description = description
        self.properties = properties
        self.tags = tags
        self.credentials = credentials
        self.datastore_type: str = "AzureFile"
        self.is_default = None
        self.account_name = account_name
        self.endpoint = endpoint
        self.file_share_name = file_share_name
        self.protocol = protocol
        self.service_data_access_auth_identity = service_data_access_auth_identity
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class EarlyTerminationPolicy(_serialization.Model):
    """Early termination policies enable canceling poor-performing runs before they complete.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BanditPolicy, MedianStoppingPolicy, TruncationSelectionPolicy

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: [Required] Name of policy configuration. Required. Known values are:
     "Bandit", "MedianStopping", and "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        "policy_type": {"required": True},
    }

    _attribute_map = {
        "delay_evaluation": {"key": "delayEvaluation", "type": "int"},
        "evaluation_interval": {"key": "evaluationInterval", "type": "int"},
        "policy_type": {"key": "policyType", "type": "str"},
    }

    _subtype_map = {
        "policy_type": {
            "Bandit": "BanditPolicy",
            "MedianStopping": "MedianStoppingPolicy",
            "TruncationSelection": "TruncationSelectionPolicy",
        }
    }

    def __init__(self, *, delay_evaluation: int = 0, evaluation_interval: int = 0, **kwargs: Any) -> None:
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super().__init__(**kwargs)
        self.delay_evaluation = delay_evaluation
        self.evaluation_interval = evaluation_interval
        self.policy_type: Optional[str] = None


class BanditPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on slack criteria, and a frequency and delay interval
    for evaluation.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: [Required] Name of policy configuration. Required. Known values are:
     "Bandit", "MedianStopping", and "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar slack_amount: Absolute distance allowed from the best performing run.
    :vartype slack_amount: float
    :ivar slack_factor: Ratio of the allowed distance from the best performing run.
    :vartype slack_factor: float
    """

    _validation = {
        "policy_type": {"required": True},
    }

    _attribute_map = {
        "delay_evaluation": {"key": "delayEvaluation", "type": "int"},
        "evaluation_interval": {"key": "evaluationInterval", "type": "int"},
        "policy_type": {"key": "policyType", "type": "str"},
        "slack_amount": {"key": "slackAmount", "type": "float"},
        "slack_factor": {"key": "slackFactor", "type": "float"},
    }

    def __init__(
        self,
        *,
        delay_evaluation: int = 0,
        evaluation_interval: int = 0,
        slack_amount: float = 0,
        slack_factor: float = 0,
        **kwargs: Any
    ) -> None:
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword slack_amount: Absolute distance allowed from the best performing run.
        :paramtype slack_amount: float
        :keyword slack_factor: Ratio of the allowed distance from the best performing run.
        :paramtype slack_factor: float
        """
        super().__init__(delay_evaluation=delay_evaluation, evaluation_interval=evaluation_interval, **kwargs)
        self.policy_type: str = "Bandit"
        self.slack_amount = slack_amount
        self.slack_factor = slack_factor


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class BatchDeployment(TrackedResource):
    """BatchDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "BatchDeploymentProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.BatchDeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class EndpointDeploymentPropertiesBase(_serialization.Model):
    """Base definition for endpoint deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID or AssetId of the environment specification for the
     endpoint deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "CodeConfiguration"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID or AssetId of the environment specification for the
         endpoint deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.code_configuration = code_configuration
        self.description = description
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.properties = properties


class BatchDeploymentProperties(EndpointDeploymentPropertiesBase):  # pylint: disable=too-many-instance-attributes
    """Batch inference settings per deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID or AssetId of the environment specification for the
     endpoint deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar compute: Compute target for batch inference operation.
    :vartype compute: str
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Known values are: "Info",
     "Warning", and "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: int
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Known values are:
     "SummaryOnly" and "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Known values are:
     "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar resources: Indicates compute configuration for the job.
     If not provided, will default to the defaults defined in ResourceConfiguration.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
    :ivar retry_settings: Retry Settings for the batch inference operation.
     If not provided, will default to the defaults defined in BatchRetrySettings.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "CodeConfiguration"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "properties": {"key": "properties", "type": "{str}"},
        "compute": {"key": "compute", "type": "str"},
        "error_threshold": {"key": "errorThreshold", "type": "int"},
        "logging_level": {"key": "loggingLevel", "type": "str"},
        "max_concurrency_per_instance": {"key": "maxConcurrencyPerInstance", "type": "int"},
        "mini_batch_size": {"key": "miniBatchSize", "type": "int"},
        "model": {"key": "model", "type": "AssetReferenceBase"},
        "output_action": {"key": "outputAction", "type": "str"},
        "output_file_name": {"key": "outputFileName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "resources": {"key": "resources", "type": "DeploymentResourceConfiguration"},
        "retry_settings": {"key": "retrySettings", "type": "BatchRetrySettings"},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        compute: Optional[str] = None,
        error_threshold: int = -1,
        logging_level: Optional[Union[str, "_models.BatchLoggingLevel"]] = None,
        max_concurrency_per_instance: int = 1,
        mini_batch_size: int = 10,
        model: Optional["_models.AssetReferenceBase"] = None,
        output_action: Optional[Union[str, "_models.BatchOutputAction"]] = None,
        output_file_name: str = "predictions.csv",
        resources: Optional["_models.DeploymentResourceConfiguration"] = None,
        retry_settings: Optional["_models.BatchRetrySettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID or AssetId of the environment specification for the
         endpoint deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: Compute target for batch inference operation.
        :paramtype compute: str
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Known values are: "Info",
         "Warning", and "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: int
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Known values are:
         "SummaryOnly" and "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword resources: Indicates compute configuration for the job.
         If not provided, will default to the defaults defined in ResourceConfiguration.
        :paramtype resources:
         ~azure.mgmt.machinelearningservices.models.DeploymentResourceConfiguration
        :keyword retry_settings: Retry Settings for the batch inference operation.
         If not provided, will default to the defaults defined in BatchRetrySettings.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        """
        super().__init__(
            code_configuration=code_configuration,
            description=description,
            environment_id=environment_id,
            environment_variables=environment_variables,
            properties=properties,
            **kwargs
        )
        self.compute = compute
        self.error_threshold = error_threshold
        self.logging_level = logging_level
        self.max_concurrency_per_instance = max_concurrency_per_instance
        self.mini_batch_size = mini_batch_size
        self.model = model
        self.output_action = output_action
        self.output_file_name = output_file_name
        self.provisioning_state = None
        self.resources = resources
        self.retry_settings = retry_settings


class BatchDeploymentTrackedResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of BatchDeployment entities.

    :ivar next_link: The link to the next page of BatchDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BatchDeployment]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.BatchDeployment"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of BatchDeployment objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchDeployment]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchEndpoint(TrackedResource):
    """BatchEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "BatchEndpointProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.BatchEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class BatchEndpointDefaults(_serialization.Model):
    """Batch endpoint default values.

    :ivar deployment_name: Name of the deployment that will be default for the endpoint.
     This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
    :vartype deployment_name: str
    """

    _attribute_map = {
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(self, *, deployment_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword deployment_name: Name of the deployment that will be default for the endpoint.
         This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.deployment_name = deployment_name


class EndpointPropertiesBase(_serialization.Model):
    """Inference Endpoint base definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
     Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Required. Known values are: "AMLToken", "Key", and "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    """

    _validation = {
        "auth_mode": {"required": True},
        "scoring_uri": {"readonly": True},
        "swagger_uri": {"readonly": True},
    }

    _attribute_map = {
        "auth_mode": {"key": "authMode", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "keys": {"key": "keys", "type": "EndpointAuthKeys"},
        "properties": {"key": "properties", "type": "{str}"},
        "scoring_uri": {"key": "scoringUri", "type": "str"},
        "swagger_uri": {"key": "swaggerUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "_models.EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["_models.EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
         Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
         Required. Known values are: "AMLToken", "Key", and "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.auth_mode = auth_mode
        self.description = description
        self.keys = keys
        self.properties = properties
        self.scoring_uri = None
        self.swagger_uri = None


class BatchEndpointProperties(EndpointPropertiesBase):
    """Batch endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
     Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Required. Known values are: "AMLToken", "Key", and "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    :ivar provisioning_state: Provisioning state for the endpoint. Known values are: "Creating",
     "Deleting", "Succeeded", "Failed", "Updating", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    """

    _validation = {
        "auth_mode": {"required": True},
        "scoring_uri": {"readonly": True},
        "swagger_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "auth_mode": {"key": "authMode", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "keys": {"key": "keys", "type": "EndpointAuthKeys"},
        "properties": {"key": "properties", "type": "{str}"},
        "scoring_uri": {"key": "scoringUri", "type": "str"},
        "swagger_uri": {"key": "swaggerUri", "type": "str"},
        "defaults": {"key": "defaults", "type": "BatchEndpointDefaults"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "_models.EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["_models.EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        defaults: Optional["_models.BatchEndpointDefaults"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
         Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
         Required. Known values are: "AMLToken", "Key", and "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super().__init__(auth_mode=auth_mode, description=description, keys=keys, properties=properties, **kwargs)
        self.defaults = defaults
        self.provisioning_state = None


class BatchEndpointTrackedResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of BatchEndpoint entities.

    :ivar next_link: The link to the next page of BatchEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BatchEndpoint]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.BatchEndpoint"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of BatchEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpoint]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchRetrySettings(_serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        "max_retries": {"key": "maxRetries", "type": "int"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    def __init__(self, *, max_retries: int = 3, timeout: datetime.timedelta = "PT30S", **kwargs: Any) -> None:
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.max_retries = max_retries
        self.timeout = timeout


class SamplingAlgorithm(_serialization.Model):
    """The Sampling Algorithm used to generate hyperparameter values, along with properties to
    configure the algorithm.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BayesianSamplingAlgorithm, GridSamplingAlgorithm, RandomSamplingAlgorithm

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: [Required] The algorithm used for generating hyperparameter
     values, along with configuration properties. Required. Known values are: "Grid", "Random", and
     "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        "sampling_algorithm_type": {"required": True},
    }

    _attribute_map = {
        "sampling_algorithm_type": {"key": "samplingAlgorithmType", "type": "str"},
    }

    _subtype_map = {
        "sampling_algorithm_type": {
            "Bayesian": "BayesianSamplingAlgorithm",
            "Grid": "GridSamplingAlgorithm",
            "Random": "RandomSamplingAlgorithm",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sampling_algorithm_type: Optional[str] = None


class BayesianSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values based on previous values.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: [Required] The algorithm used for generating hyperparameter
     values, along with configuration properties. Required. Known values are: "Grid", "Random", and
     "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        "sampling_algorithm_type": {"required": True},
    }

    _attribute_map = {
        "sampling_algorithm_type": {"key": "samplingAlgorithmType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sampling_algorithm_type: str = "Bayesian"


class BindOptions(_serialization.Model):
    """Describes the bind options for the container.

    :ivar propagation: Type of Bind Option.
    :vartype propagation: str
    :ivar create_host_path: Indicate whether to create host path.
    :vartype create_host_path: bool
    :ivar selinux: Mention the selinux options.
    :vartype selinux: str
    """

    _attribute_map = {
        "propagation": {"key": "propagation", "type": "str"},
        "create_host_path": {"key": "createHostPath", "type": "bool"},
        "selinux": {"key": "selinux", "type": "str"},
    }

    def __init__(
        self,
        *,
        propagation: Optional[str] = None,
        create_host_path: Optional[bool] = None,
        selinux: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword propagation: Type of Bind Option.
        :paramtype propagation: str
        :keyword create_host_path: Indicate whether to create host path.
        :paramtype create_host_path: bool
        :keyword selinux: Mention the selinux options.
        :paramtype selinux: str
        """
        super().__init__(**kwargs)
        self.propagation = propagation
        self.create_host_path = create_host_path
        self.selinux = selinux


class BlobReferenceForConsumptionDto(_serialization.Model):
    """BlobReferenceForConsumptionDto.

    :ivar blob_uri: Blob URI path for client to upload data.
     Example: https://blob.windows.core.net/Container/Path.
    :vartype blob_uri: str
    :ivar credential: Credential info to access storage account.
    :vartype credential: ~azure.mgmt.machinelearningservices.models.PendingUploadCredentialDto
    :ivar storage_account_arm_id: Arm ID of the storage account to use.
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        "blob_uri": {"key": "blobUri", "type": "str"},
        "credential": {"key": "credential", "type": "PendingUploadCredentialDto"},
        "storage_account_arm_id": {"key": "storageAccountArmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        credential: Optional["_models.PendingUploadCredentialDto"] = None,
        storage_account_arm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_uri: Blob URI path for client to upload data.
         Example: https://blob.windows.core.net/Container/Path.
        :paramtype blob_uri: str
        :keyword credential: Credential info to access storage account.
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.PendingUploadCredentialDto
        :keyword storage_account_arm_id: Arm ID of the storage account to use.
        :paramtype storage_account_arm_id: str
        """
        super().__init__(**kwargs)
        self.blob_uri = blob_uri
        self.credential = credential
        self.storage_account_arm_id = storage_account_arm_id


class BuildContext(_serialization.Model):
    """Configuration settings for Docker build context.

    All required parameters must be populated in order to send to Azure.

    :ivar context_uri: [Required] URI of the Docker build context used to build the image. Supports
     blob URIs on environment creation and may return blob or Git URIs.


     .. raw:: html

        <seealso
     href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
     Required.
    :vartype context_uri: str
    :ivar dockerfile_path: Path to the Dockerfile in the build context.


     .. raw:: html

        <seealso href="https://docs.docker.com/engine/reference/builder/" />.
    :vartype dockerfile_path: str
    """

    _validation = {
        "context_uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "context_uri": {"key": "contextUri", "type": "str"},
        "dockerfile_path": {"key": "dockerfilePath", "type": "str"},
    }

    def __init__(self, *, context_uri: str, dockerfile_path: str = "Dockerfile", **kwargs: Any) -> None:
        """
        :keyword context_uri: [Required] URI of the Docker build context used to build the image.
         Supports blob URIs on environment creation and may return blob or Git URIs.


         .. raw:: html

            <seealso
         href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
         Required.
        :paramtype context_uri: str
        :keyword dockerfile_path: Path to the Dockerfile in the build context.


         .. raw:: html

            <seealso href="https://docs.docker.com/engine/reference/builder/" />.
        :paramtype dockerfile_path: str
        """
        super().__init__(**kwargs)
        self.context_uri = context_uri
        self.dockerfile_path = dockerfile_path


class DataDriftMetricThresholdBase(_serialization.Model):
    """DataDriftMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CategoricalDataDriftMetricThreshold, NumericalDataDriftMetricThreshold

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        "data_type": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
    }

    _subtype_map = {
        "data_type": {
            "Categorical": "CategoricalDataDriftMetricThreshold",
            "Numerical": "NumericalDataDriftMetricThreshold",
        }
    }

    def __init__(self, *, threshold: Optional["_models.MonitoringThreshold"] = None, **kwargs: Any) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super().__init__(**kwargs)
        self.data_type: Optional[str] = None
        self.threshold = threshold


class CategoricalDataDriftMetricThreshold(DataDriftMetricThresholdBase):
    """CategoricalDataDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The categorical data drift metric to calculate. Required. Known values
     are: "JensenShannonDistance", "PopulationStabilityIndex", and "PearsonsChiSquaredTest".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataDriftMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.CategoricalDataDriftMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The categorical data drift metric to calculate. Required. Known
         values are: "JensenShannonDistance", "PopulationStabilityIndex", and "PearsonsChiSquaredTest".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataDriftMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Categorical"
        self.metric = metric


class DataQualityMetricThresholdBase(_serialization.Model):
    """DataQualityMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CategoricalDataQualityMetricThreshold, NumericalDataQualityMetricThreshold

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        "data_type": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
    }

    _subtype_map = {
        "data_type": {
            "Categorical": "CategoricalDataQualityMetricThreshold",
            "Numerical": "NumericalDataQualityMetricThreshold",
        }
    }

    def __init__(self, *, threshold: Optional["_models.MonitoringThreshold"] = None, **kwargs: Any) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super().__init__(**kwargs)
        self.data_type: Optional[str] = None
        self.threshold = threshold


class CategoricalDataQualityMetricThreshold(DataQualityMetricThresholdBase):
    """CategoricalDataQualityMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The categorical data quality metric to calculate. Required. Known
     values are: "NullValueRate", "DataTypeErrorRate", and "OutOfBoundsRate".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.CategoricalDataQualityMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.CategoricalDataQualityMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The categorical data quality metric to calculate. Required. Known
         values are: "NullValueRate", "DataTypeErrorRate", and "OutOfBoundsRate".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.CategoricalDataQualityMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Categorical"
        self.metric = metric


class PredictionDriftMetricThresholdBase(_serialization.Model):
    """PredictionDriftMetricThresholdBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CategoricalPredictionDriftMetricThreshold, NumericalPredictionDriftMetricThreshold

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        "data_type": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
    }

    _subtype_map = {
        "data_type": {
            "Categorical": "CategoricalPredictionDriftMetricThreshold",
            "Numerical": "NumericalPredictionDriftMetricThreshold",
        }
    }

    def __init__(self, *, threshold: Optional["_models.MonitoringThreshold"] = None, **kwargs: Any) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super().__init__(**kwargs)
        self.data_type: Optional[str] = None
        self.threshold = threshold


class CategoricalPredictionDriftMetricThreshold(PredictionDriftMetricThresholdBase):
    """CategoricalPredictionDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The categorical prediction drift metric to calculate. Required. Known
     values are: "JensenShannonDistance", "PopulationStabilityIndex", and "PearsonsChiSquaredTest".
    :vartype metric: str or
     ~azure.mgmt.machinelearningservices.models.CategoricalPredictionDriftMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.CategoricalPredictionDriftMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The categorical prediction drift metric to calculate. Required.
         Known values are: "JensenShannonDistance", "PopulationStabilityIndex", and
         "PearsonsChiSquaredTest".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.CategoricalPredictionDriftMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Categorical"
        self.metric = metric


class CertificateDatastoreCredentials(DatastoreCredentials):
    """Certificate datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "AccountKey", "Certificate", "None", "Sas", and "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: [Required] Service principal client ID. Required.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: [Required] Service principal secrets. Required.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
    :ivar tenant_id: [Required] ID of the tenant to which the service principal belongs. Required.
    :vartype tenant_id: str
    :ivar thumbprint: [Required] Thumbprint of the certificate used for authentication. Required.
    :vartype thumbprint: str
    """

    _validation = {
        "credentials_type": {"required": True},
        "client_id": {"required": True},
        "secrets": {"required": True},
        "tenant_id": {"required": True},
        "thumbprint": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "credentials_type": {"key": "credentialsType", "type": "str"},
        "authority_url": {"key": "authorityUrl", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "resource_url": {"key": "resourceUrl", "type": "str"},
        "secrets": {"key": "secrets", "type": "CertificateDatastoreSecrets"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secrets: "_models.CertificateDatastoreSecrets",
        tenant_id: str,
        thumbprint: str,
        authority_url: Optional[str] = None,
        resource_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: [Required] Service principal client ID. Required.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: [Required] Service principal secrets. Required.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
        :keyword tenant_id: [Required] ID of the tenant to which the service principal belongs.
         Required.
        :paramtype tenant_id: str
        :keyword thumbprint: [Required] Thumbprint of the certificate used for authentication.
         Required.
        :paramtype thumbprint: str
        """
        super().__init__(**kwargs)
        self.credentials_type: str = "Certificate"
        self.authority_url = authority_url
        self.client_id = client_id
        self.resource_url = resource_url
        self.secrets = secrets
        self.tenant_id = tenant_id
        self.thumbprint = thumbprint


class CertificateDatastoreSecrets(DatastoreSecrets):
    """Datastore certificate secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: [Required] Credential type used to authentication with storage. Required.
     Known values are: "AccountKey", "Certificate", "Sas", and "ServicePrincipal".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar certificate: Service principal certificate.
    :vartype certificate: str
    """

    _validation = {
        "secrets_type": {"required": True},
    }

    _attribute_map = {
        "secrets_type": {"key": "secretsType", "type": "str"},
        "certificate": {"key": "certificate", "type": "str"},
    }

    def __init__(self, *, certificate: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword certificate: Service principal certificate.
        :paramtype certificate: str
        """
        super().__init__(**kwargs)
        self.secrets_type: str = "Certificate"
        self.certificate = certificate


class TableVertical(_serialization.Model):
    """Abstract class for AutoML tasks that use table dataset as input - such as
    Classification/Regression/Forecasting.

    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    """

    _attribute_map = {
        "cv_split_column_names": {"key": "cvSplitColumnNames", "type": "[str]"},
        "featurization_settings": {"key": "featurizationSettings", "type": "TableVerticalFeaturizationSettings"},
        "limit_settings": {"key": "limitSettings", "type": "TableVerticalLimitSettings"},
        "n_cross_validations": {"key": "nCrossValidations", "type": "NCrossValidations"},
        "test_data": {"key": "testData", "type": "MLTableJobInput"},
        "test_data_size": {"key": "testDataSize", "type": "float"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "weight_column_name": {"key": "weightColumnName", "type": "str"},
    }

    def __init__(
        self,
        *,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["_models.TableVerticalFeaturizationSettings"] = None,
        limit_settings: Optional["_models.TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["_models.NCrossValidations"] = None,
        test_data: Optional["_models.MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        """
        super().__init__(**kwargs)
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class Classification(TableVertical, AutoMLVertical):  # pylint: disable=too-many-instance-attributes
    """Classification task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar positive_label: Positive label for binary metrics calculation.
    :vartype positive_label: str
    :ivar primary_metric: Primary metric for the task. Known values are: "AUCWeighted", "Accuracy",
     "NormMacroRecall", "AveragePrecisionScoreWeighted", and "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "cv_split_column_names": {"key": "cvSplitColumnNames", "type": "[str]"},
        "featurization_settings": {"key": "featurizationSettings", "type": "TableVerticalFeaturizationSettings"},
        "limit_settings": {"key": "limitSettings", "type": "TableVerticalLimitSettings"},
        "n_cross_validations": {"key": "nCrossValidations", "type": "NCrossValidations"},
        "test_data": {"key": "testData", "type": "MLTableJobInput"},
        "test_data_size": {"key": "testDataSize", "type": "float"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "weight_column_name": {"key": "weightColumnName", "type": "str"},
        "positive_label": {"key": "positiveLabel", "type": "str"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
        "training_settings": {"key": "trainingSettings", "type": "ClassificationTrainingSettings"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["_models.TableVerticalFeaturizationSettings"] = None,
        limit_settings: Optional["_models.TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["_models.NCrossValidations"] = None,
        test_data: Optional["_models.MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        positive_label: Optional[str] = None,
        primary_metric: Optional[Union[str, "_models.ClassificationPrimaryMetrics"]] = None,
        training_settings: Optional["_models.ClassificationTrainingSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword positive_label: Positive label for binary metrics calculation.
        :paramtype positive_label: str
        :keyword primary_metric: Primary metric for the task. Known values are: "AUCWeighted",
         "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", and "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ClassificationTrainingSettings
        """
        super().__init__(
            cv_split_column_names=cv_split_column_names,
            featurization_settings=featurization_settings,
            limit_settings=limit_settings,
            n_cross_validations=n_cross_validations,
            test_data=test_data,
            test_data_size=test_data_size,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            weight_column_name=weight_column_name,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "Classification"
        self.training_data = training_data
        self.positive_label = positive_label
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class TrainingSettings(_serialization.Model):
    """Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    """

    _attribute_map = {
        "enable_dnn_training": {"key": "enableDnnTraining", "type": "bool"},
        "enable_model_explainability": {"key": "enableModelExplainability", "type": "bool"},
        "enable_onnx_compatible_models": {"key": "enableOnnxCompatibleModels", "type": "bool"},
        "enable_stack_ensemble": {"key": "enableStackEnsemble", "type": "bool"},
        "enable_vote_ensemble": {"key": "enableVoteEnsemble", "type": "bool"},
        "ensemble_model_download_timeout": {"key": "ensembleModelDownloadTimeout", "type": "duration"},
        "stack_ensemble_settings": {"key": "stackEnsembleSettings", "type": "StackEnsembleSettings"},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: bool = False,
        enable_model_explainability: bool = True,
        enable_onnx_compatible_models: bool = False,
        enable_stack_ensemble: bool = True,
        enable_vote_ensemble: bool = True,
        ensemble_model_download_timeout: datetime.timedelta = "PT5M",
        stack_ensemble_settings: Optional["_models.StackEnsembleSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        """
        super().__init__(**kwargs)
        self.enable_dnn_training = enable_dnn_training
        self.enable_model_explainability = enable_model_explainability
        self.enable_onnx_compatible_models = enable_onnx_compatible_models
        self.enable_stack_ensemble = enable_stack_ensemble
        self.enable_vote_ensemble = enable_vote_ensemble
        self.ensemble_model_download_timeout = ensemble_model_download_timeout
        self.stack_ensemble_settings = stack_ensemble_settings


class ClassificationTrainingSettings(TrainingSettings):
    """Classification Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for classification task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    :ivar blocked_training_algorithms: Blocked models for classification task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    """

    _attribute_map = {
        "enable_dnn_training": {"key": "enableDnnTraining", "type": "bool"},
        "enable_model_explainability": {"key": "enableModelExplainability", "type": "bool"},
        "enable_onnx_compatible_models": {"key": "enableOnnxCompatibleModels", "type": "bool"},
        "enable_stack_ensemble": {"key": "enableStackEnsemble", "type": "bool"},
        "enable_vote_ensemble": {"key": "enableVoteEnsemble", "type": "bool"},
        "ensemble_model_download_timeout": {"key": "ensembleModelDownloadTimeout", "type": "duration"},
        "stack_ensemble_settings": {"key": "stackEnsembleSettings", "type": "StackEnsembleSettings"},
        "allowed_training_algorithms": {"key": "allowedTrainingAlgorithms", "type": "[str]"},
        "blocked_training_algorithms": {"key": "blockedTrainingAlgorithms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: bool = False,
        enable_model_explainability: bool = True,
        enable_onnx_compatible_models: bool = False,
        enable_stack_ensemble: bool = True,
        enable_vote_ensemble: bool = True,
        ensemble_model_download_timeout: datetime.timedelta = "PT5M",
        stack_ensemble_settings: Optional["_models.StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "_models.ClassificationModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "_models.ClassificationModels"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword allowed_training_algorithms: Allowed models for classification task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        :keyword blocked_training_algorithms: Blocked models for classification task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        """
        super().__init__(
            enable_dnn_training=enable_dnn_training,
            enable_model_explainability=enable_model_explainability,
            enable_onnx_compatible_models=enable_onnx_compatible_models,
            enable_stack_ensemble=enable_stack_ensemble,
            enable_vote_ensemble=enable_vote_ensemble,
            ensemble_model_download_timeout=ensemble_model_download_timeout,
            stack_ensemble_settings=stack_ensemble_settings,
            **kwargs
        )
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class ClusterUpdateParameters(_serialization.Model):
    """AmlCompute update parameters.

    :ivar properties: Properties of ClusterUpdate.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
    """

    _attribute_map = {
        "properties": {"key": "properties.properties", "type": "ScaleSettingsInformation"},
    }

    def __init__(self, *, properties: Optional["_models.ScaleSettingsInformation"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of ClusterUpdate.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
        """
        super().__init__(**kwargs)
        self.properties = properties


class CodeConfiguration(_serialization.Model):
    """Configuration for a scoring code asset.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: [Required] The script to execute on startup. eg. "score.py". Required.
    :vartype scoring_script: str
    """

    _validation = {
        "scoring_script": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "code_id": {"key": "codeId", "type": "str"},
        "scoring_script": {"key": "scoringScript", "type": "str"},
    }

    def __init__(self, *, scoring_script: str, code_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: [Required] The script to execute on startup. eg. "score.py". Required.
        :paramtype scoring_script: str
        """
        super().__init__(**kwargs)
        self.code_id = code_id
        self.scoring_script = scoring_script


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class CodeContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CodeContainerProperties"},
    }

    def __init__(self, *, properties: "_models.CodeContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CodeContainerProperties(AssetContainer):
    """Container for code asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the code container. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class CodeContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of CodeContainer entities.

    :ivar next_link: The link to the next page of CodeContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CodeContainer]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.CodeContainer"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of CodeContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CodeVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CodeVersionProperties"},
    }

    def __init__(self, *, properties: "_models.CodeVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CodeVersionProperties(AssetBase):
    """Code asset version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar code_uri: Uri where code is located.
    :vartype code_uri: str
    :ivar provisioning_state: Provisioning state for the code version. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "code_uri": {"key": "codeUri", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        code_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword code_uri: Uri where code is located.
        :paramtype code_uri: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.code_uri = code_uri
        self.provisioning_state = None


class CodeVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of CodeVersion entities.

    :ivar next_link: The link to the next page of CodeVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CodeVersion]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.CodeVersion"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of CodeVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ColumnTransformer(_serialization.Model):
    """Column transformer parameters.

    :ivar fields: Fields to apply transformer logic on.
    :vartype fields: list[str]
    :ivar parameters: Different properties to be passed to transformer.
     Input expected is dictionary of key,value pairs in JSON format.
    :vartype parameters: JSON
    """

    _attribute_map = {
        "fields": {"key": "fields", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "object"},
    }

    def __init__(self, *, fields: Optional[List[str]] = None, parameters: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword fields: Fields to apply transformer logic on.
        :paramtype fields: list[str]
        :keyword parameters: Different properties to be passed to transformer.
         Input expected is dictionary of key,value pairs in JSON format.
        :paramtype parameters: JSON
        """
        super().__init__(**kwargs)
        self.fields = fields
        self.parameters = parameters


class CommandJob(JobBaseProperties):  # pylint: disable=too-many-instance-attributes
    """Command job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: [Required] Specifies the type of job. Required. Known values are: "AutoML",
     "Command", "Sweep", and "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Known values are: "NotStarted", "Starting", "Provisioning",
     "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed", "Failed",
     "Canceled", "NotResponding", "Paused", and "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: [Required] The command to execute on startup of the job. eg. "python train.py".
     Required.
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: [Required] The ARM resource ID of the Environment specification for the
     job. Required.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Command Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar parameters: Input parameters.
    :vartype parameters: JSON
    :ivar queue_settings: Queue settings for the job.
    :vartype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
    """

    _validation = {
        "job_type": {"required": True},
        "status": {"readonly": True},
        "command": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "environment_id": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "parameters": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "component_id": {"key": "componentId", "type": "str"},
        "compute_id": {"key": "computeId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "experiment_name": {"key": "experimentName", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityConfiguration"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "job_type": {"key": "jobType", "type": "str"},
        "services": {"key": "services", "type": "{JobService}"},
        "status": {"key": "status", "type": "str"},
        "code_id": {"key": "codeId", "type": "str"},
        "command": {"key": "command", "type": "str"},
        "distribution": {"key": "distribution", "type": "DistributionConfiguration"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "inputs": {"key": "inputs", "type": "{JobInput}"},
        "limits": {"key": "limits", "type": "CommandJobLimits"},
        "outputs": {"key": "outputs", "type": "{JobOutput}"},
        "parameters": {"key": "parameters", "type": "object"},
        "queue_settings": {"key": "queueSettings", "type": "QueueSettings"},
        "resources": {"key": "resources", "type": "JobResourceConfiguration"},
    }

    def __init__(
        self,
        *,
        command: str,
        environment_id: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: str = "Default",
        identity: Optional["_models.IdentityConfiguration"] = None,
        is_archived: bool = False,
        services: Optional[Dict[str, "_models.JobService"]] = None,
        code_id: Optional[str] = None,
        distribution: Optional["_models.DistributionConfiguration"] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        inputs: Optional[Dict[str, "_models.JobInput"]] = None,
        limits: Optional["_models.CommandJobLimits"] = None,
        outputs: Optional[Dict[str, "_models.JobOutput"]] = None,
        queue_settings: Optional["_models.QueueSettings"] = None,
        resources: Optional["_models.JobResourceConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: [Required] The command to execute on startup of the job. eg. "python
         train.py". Required.
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: [Required] The ARM resource ID of the Environment specification for
         the job. Required.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Command Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword queue_settings: Queue settings for the job.
        :paramtype queue_settings: ~azure.mgmt.machinelearningservices.models.QueueSettings
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.JobResourceConfiguration
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            component_id=component_id,
            compute_id=compute_id,
            display_name=display_name,
            experiment_name=experiment_name,
            identity=identity,
            is_archived=is_archived,
            services=services,
            **kwargs
        )
        self.job_type: str = "Command"
        self.code_id = code_id
        self.command = command
        self.distribution = distribution
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.inputs = inputs
        self.limits = limits
        self.outputs = outputs
        self.parameters = None
        self.queue_settings = queue_settings
        self.resources = resources


class JobLimits(_serialization.Model):
    """JobLimits.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CommandJobLimits, SweepJobLimits

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: [Required] JobLimit type. Required. Known values are: "Command" and
     "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        "job_limits_type": {"required": True},
    }

    _attribute_map = {
        "job_limits_type": {"key": "jobLimitsType", "type": "str"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    _subtype_map = {"job_limits_type": {"Command": "CommandJobLimits", "Sweep": "SweepJobLimits"}}

    def __init__(self, *, timeout: Optional[datetime.timedelta] = None, **kwargs: Any) -> None:
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.job_limits_type: Optional[str] = None
        self.timeout = timeout


class CommandJobLimits(JobLimits):
    """Command Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: [Required] JobLimit type. Required. Known values are: "Command" and
     "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        "job_limits_type": {"required": True},
    }

    _attribute_map = {
        "job_limits_type": {"key": "jobLimitsType", "type": "str"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    def __init__(self, *, timeout: Optional[datetime.timedelta] = None, **kwargs: Any) -> None:
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(timeout=timeout, **kwargs)
        self.job_limits_type: str = "Command"


class ComponentContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ComponentContainerProperties"},
    }

    def __init__(self, *, properties: "_models.ComponentContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ComponentContainerProperties(AssetContainer):
    """Component container definition.


    .. raw:: html

       <see
    href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
    />.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the component container. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class ComponentContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of ComponentContainer entities.

    :ivar next_link: The link to the next page of ComponentContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ComponentContainer]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ComponentContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of ComponentContainer objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComponentVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ComponentVersionProperties"},
    }

    def __init__(self, *, properties: "_models.ComponentVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ComponentVersionProperties(AssetBase):
    """Definition of a component version: defines resources that span component types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar component_spec: Defines Component definition details.


     .. raw:: html

        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
     />.
    :vartype component_spec: JSON
    :ivar provisioning_state: Provisioning state for the component version. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "component_spec": {"key": "componentSpec", "type": "object"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        component_spec: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword component_spec: Defines Component definition details.


         .. raw:: html

            <see
         href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
         />.
        :paramtype component_spec: JSON
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.component_spec = component_spec
        self.provisioning_state = None


class ComponentVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of ComponentVersion entities.

    :ivar next_link: The link to the next page of ComponentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ComponentVersion]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ComponentVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of ComponentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ComputeInstanceSchema(_serialization.Model):
    """Properties(top level) of ComputeInstance.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ComputeInstanceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ComputeInstanceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ComputeInstance(Compute, ComputeInstanceSchema):  # pylint: disable=too-many-instance-attributes
    """An Azure Machine Learning compute instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ComputeInstanceProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ComputeInstanceProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "ComputeInstance"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class ComputeInstanceApplication(_serialization.Model):
    """Defines an Aml Instance application and its connectivity endpoint URI.

    :ivar display_name: Name of the ComputeInstance application.
    :vartype display_name: str
    :ivar endpoint_uri: Application' endpoint URI.
    :vartype endpoint_uri: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "endpoint_uri": {"key": "endpointUri", "type": "str"},
    }

    def __init__(
        self, *, display_name: Optional[str] = None, endpoint_uri: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Name of the ComputeInstance application.
        :paramtype display_name: str
        :keyword endpoint_uri: Application' endpoint URI.
        :paramtype endpoint_uri: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.endpoint_uri = endpoint_uri


class ComputeInstanceConnectivityEndpoints(_serialization.Model):
    """Defines all connectivity endpoints and properties for an ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_ip_address: Public IP Address of this ComputeInstance.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in
     which the compute instance is deployed).
    :vartype private_ip_address: str
    """

    _validation = {
        "public_ip_address": {"readonly": True},
        "private_ip_address": {"readonly": True},
    }

    _attribute_map = {
        "public_ip_address": {"key": "publicIpAddress", "type": "str"},
        "private_ip_address": {"key": "privateIpAddress", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.public_ip_address = None
        self.private_ip_address = None


class ComputeInstanceContainer(_serialization.Model):
    """Defines an Aml Instance container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the ComputeInstance container.
    :vartype name: str
    :ivar autosave: Auto save settings. Known values are: "None", "Local", and "Remote".
    :vartype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
    :ivar gpu: Information of GPU.
    :vartype gpu: str
    :ivar network: network of this container. Known values are: "Bridge" and "Host".
    :vartype network: str or ~azure.mgmt.machinelearningservices.models.Network
    :ivar environment: Environment information of this container.
    :vartype environment: ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
    :ivar services: services of this containers.
    :vartype services: list[JSON]
    """

    _validation = {
        "services": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "autosave": {"key": "autosave", "type": "str"},
        "gpu": {"key": "gpu", "type": "str"},
        "network": {"key": "network", "type": "str"},
        "environment": {"key": "environment", "type": "ComputeInstanceEnvironmentInfo"},
        "services": {"key": "services", "type": "[object]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        autosave: Optional[Union[str, "_models.Autosave"]] = None,
        gpu: Optional[str] = None,
        network: Optional[Union[str, "_models.Network"]] = None,
        environment: Optional["_models.ComputeInstanceEnvironmentInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the ComputeInstance container.
        :paramtype name: str
        :keyword autosave: Auto save settings. Known values are: "None", "Local", and "Remote".
        :paramtype autosave: str or ~azure.mgmt.machinelearningservices.models.Autosave
        :keyword gpu: Information of GPU.
        :paramtype gpu: str
        :keyword network: network of this container. Known values are: "Bridge" and "Host".
        :paramtype network: str or ~azure.mgmt.machinelearningservices.models.Network
        :keyword environment: Environment information of this container.
        :paramtype environment:
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceEnvironmentInfo
        """
        super().__init__(**kwargs)
        self.name = name
        self.autosave = autosave
        self.gpu = gpu
        self.network = network
        self.environment = environment
        self.services = None


class ComputeInstanceCreatedBy(_serialization.Model):
    """Describes information on user who created this ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_name: Name of the user.
    :vartype user_name: str
    :ivar user_org_id: Uniquely identifies user' Azure Active Directory organization.
    :vartype user_org_id: str
    :ivar user_id: Uniquely identifies the user within his/her organization.
    :vartype user_id: str
    """

    _validation = {
        "user_name": {"readonly": True},
        "user_org_id": {"readonly": True},
        "user_id": {"readonly": True},
    }

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "user_org_id": {"key": "userOrgId", "type": "str"},
        "user_id": {"key": "userId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.user_name = None
        self.user_org_id = None
        self.user_id = None


class ComputeInstanceDataDisk(_serialization.Model):
    """Defines an Aml Instance DataDisk.

    :ivar caching: Caching type of Data Disk. Known values are: "None", "ReadOnly", and
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
    :ivar disk_size_gb: The initial disk size in gigabytes.
    :vartype disk_size_gb: int
    :ivar lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
     each should have a distinct lun.
    :vartype lun: int
    :ivar storage_account_type: type of this storage account. Known values are: "Standard_LRS" and
     "Premium_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.machinelearningservices.models.StorageAccountType
    """

    _attribute_map = {
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "lun": {"key": "lun", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "_models.Caching"]] = None,
        disk_size_gb: Optional[int] = None,
        lun: Optional[int] = None,
        storage_account_type: Union[str, "_models.StorageAccountType"] = "Standard_LRS",
        **kwargs: Any
    ) -> None:
        """
        :keyword caching: Caching type of Data Disk. Known values are: "None", "ReadOnly", and
         "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.machinelearningservices.models.Caching
        :keyword disk_size_gb: The initial disk size in gigabytes.
        :paramtype disk_size_gb: int
        :keyword lun: The lun is used to uniquely identify each data disk. If attaching multiple disks,
         each should have a distinct lun.
        :paramtype lun: int
        :keyword storage_account_type: type of this storage account. Known values are: "Standard_LRS"
         and "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.machinelearningservices.models.StorageAccountType
        """
        super().__init__(**kwargs)
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.lun = lun
        self.storage_account_type = storage_account_type


class ComputeInstanceDataMount(_serialization.Model):
    """Defines an Aml Instance DataMount.

    :ivar source: Source of the ComputeInstance data mount.
    :vartype source: str
    :ivar source_type: Data source type. Known values are: "Dataset", "Datastore", and "URI".
    :vartype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
    :ivar mount_name: name of the ComputeInstance data mount.
    :vartype mount_name: str
    :ivar mount_action: Mount Action. Known values are: "Mount" and "Unmount".
    :vartype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
    :ivar created_by: who this data mount created by.
    :vartype created_by: str
    :ivar mount_path: Path of this data mount.
    :vartype mount_path: str
    :ivar mount_state: Mount state. Known values are: "MountRequested", "Mounted", "MountFailed",
     "UnmountRequested", "UnmountFailed", and "Unmounted".
    :vartype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
    :ivar mounted_on: The time when the disk mounted.
    :vartype mounted_on: ~datetime.datetime
    :ivar error: Error of this data mount.
    :vartype error: str
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "source_type": {"key": "sourceType", "type": "str"},
        "mount_name": {"key": "mountName", "type": "str"},
        "mount_action": {"key": "mountAction", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "mount_state": {"key": "mountState", "type": "str"},
        "mounted_on": {"key": "mountedOn", "type": "iso-8601"},
        "error": {"key": "error", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        source_type: Optional[Union[str, "_models.SourceType"]] = None,
        mount_name: Optional[str] = None,
        mount_action: Optional[Union[str, "_models.MountAction"]] = None,
        created_by: Optional[str] = None,
        mount_path: Optional[str] = None,
        mount_state: Optional[Union[str, "_models.MountState"]] = None,
        mounted_on: Optional[datetime.datetime] = None,
        error: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Source of the ComputeInstance data mount.
        :paramtype source: str
        :keyword source_type: Data source type. Known values are: "Dataset", "Datastore", and "URI".
        :paramtype source_type: str or ~azure.mgmt.machinelearningservices.models.SourceType
        :keyword mount_name: name of the ComputeInstance data mount.
        :paramtype mount_name: str
        :keyword mount_action: Mount Action. Known values are: "Mount" and "Unmount".
        :paramtype mount_action: str or ~azure.mgmt.machinelearningservices.models.MountAction
        :keyword created_by: who this data mount created by.
        :paramtype created_by: str
        :keyword mount_path: Path of this data mount.
        :paramtype mount_path: str
        :keyword mount_state: Mount state. Known values are: "MountRequested", "Mounted",
         "MountFailed", "UnmountRequested", "UnmountFailed", and "Unmounted".
        :paramtype mount_state: str or ~azure.mgmt.machinelearningservices.models.MountState
        :keyword mounted_on: The time when the disk mounted.
        :paramtype mounted_on: ~datetime.datetime
        :keyword error: Error of this data mount.
        :paramtype error: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.source_type = source_type
        self.mount_name = mount_name
        self.mount_action = mount_action
        self.created_by = created_by
        self.mount_path = mount_path
        self.mount_state = mount_state
        self.mounted_on = mounted_on
        self.error = error


class ComputeInstanceEnvironmentInfo(_serialization.Model):
    """Environment information.

    :ivar name: name of environment.
    :vartype name: str
    :ivar version: version of environment.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: name of environment.
        :paramtype name: str
        :keyword version: version of environment.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.version = version


class ComputeInstanceLastOperation(_serialization.Model):
    """The last operation on ComputeInstance.

    :ivar operation_name: Name of the last operation. Known values are: "Create", "Start", "Stop",
     "Restart", "Reimage", and "Delete".
    :vartype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
    :ivar operation_time: Time of the last operation.
    :vartype operation_time: ~datetime.datetime
    :ivar operation_status: Operation status. Known values are: "InProgress", "Succeeded",
     "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed", and
     "DeleteFailed".
    :vartype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
    :ivar operation_trigger: Trigger of operation. Known values are: "User", "Schedule", and
     "IdleShutdown".
    :vartype operation_trigger: str or ~azure.mgmt.machinelearningservices.models.OperationTrigger
    """

    _attribute_map = {
        "operation_name": {"key": "operationName", "type": "str"},
        "operation_time": {"key": "operationTime", "type": "iso-8601"},
        "operation_status": {"key": "operationStatus", "type": "str"},
        "operation_trigger": {"key": "operationTrigger", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation_name: Optional[Union[str, "_models.OperationName"]] = None,
        operation_time: Optional[datetime.datetime] = None,
        operation_status: Optional[Union[str, "_models.OperationStatus"]] = None,
        operation_trigger: Optional[Union[str, "_models.OperationTrigger"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_name: Name of the last operation. Known values are: "Create", "Start",
         "Stop", "Restart", "Reimage", and "Delete".
        :paramtype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
        :keyword operation_time: Time of the last operation.
        :paramtype operation_time: ~datetime.datetime
        :keyword operation_status: Operation status. Known values are: "InProgress", "Succeeded",
         "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed", and
         "DeleteFailed".
        :paramtype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
        :keyword operation_trigger: Trigger of operation. Known values are: "User", "Schedule", and
         "IdleShutdown".
        :paramtype operation_trigger: str or
         ~azure.mgmt.machinelearningservices.models.OperationTrigger
        """
        super().__init__(**kwargs)
        self.operation_name = operation_name
        self.operation_time = operation_time
        self.operation_status = operation_status
        self.operation_trigger = operation_trigger


class ComputeInstanceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Compute Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar application_sharing_policy: Policy for sharing applications on this compute instance
     among users of parent workspace. If Personal, only the creator can access applications on this
     compute instance. When Shared, any workspace user can access applications on this instance
     depending on his/her assigned role. Known values are: "Personal" and "Shared".
    :vartype application_sharing_policy: str or
     ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
    :ivar ssh_settings: Specifies policy and settings for SSH access.
    :vartype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
    :ivar custom_services: List of Custom Services added to the compute.
    :vartype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
    :ivar os_image_metadata: Returns metadata about the operating system image for this compute
     instance.
    :vartype os_image_metadata: ~azure.mgmt.machinelearningservices.models.ImageMetadata
    :ivar connectivity_endpoints: Describes all connectivity endpoints available for this
     ComputeInstance.
    :vartype connectivity_endpoints:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceConnectivityEndpoints
    :ivar applications: Describes available applications and their endpoints on this
     ComputeInstance.
    :vartype applications:
     list[~azure.mgmt.machinelearningservices.models.ComputeInstanceApplication]
    :ivar created_by: Describes information on user who created this ComputeInstance.
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.ComputeInstanceCreatedBy
    :ivar errors: Collection of errors encountered on this ComputeInstance.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar state: The current state of this ComputeInstance. Known values are: "Creating",
     "CreateFailed", "Deleting", "Running", "Restarting", "JobRunning", "SettingUp", "SetupFailed",
     "Starting", "Stopped", "Stopping", "UserSettingUp", "UserSetupFailed", "Unknown", and
     "Unusable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.ComputeInstanceState
    :ivar compute_instance_authorization_type: The Compute Instance Authorization type. Available
     values are personal (default). "personal"
    :vartype compute_instance_authorization_type: str or
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
    :ivar personal_compute_instance_settings: Settings for a personal compute instance.
    :vartype personal_compute_instance_settings:
     ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
    :ivar setup_scripts: Details of customized scripts to execute for setting up the cluster.
    :vartype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
    :ivar last_operation: The last operation on ComputeInstance.
    :vartype last_operation:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceLastOperation
    :ivar schedules: The list of schedules to be applied on the computes.
    :vartype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    :ivar containers: Describes informations of containers on this ComputeInstance.
    :vartype containers: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceContainer]
    :ivar data_disks: Describes informations of dataDisks on this ComputeInstance.
    :vartype data_disks: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataDisk]
    :ivar data_mounts: Describes informations of dataMounts on this ComputeInstance.
    :vartype data_mounts: list[~azure.mgmt.machinelearningservices.models.ComputeInstanceDataMount]
    :ivar versions: ComputeInstance version.
    :vartype versions: ~azure.mgmt.machinelearningservices.models.ComputeInstanceVersion
    """

    _validation = {
        "os_image_metadata": {"readonly": True},
        "connectivity_endpoints": {"readonly": True},
        "applications": {"readonly": True},
        "created_by": {"readonly": True},
        "errors": {"readonly": True},
        "state": {"readonly": True},
        "last_operation": {"readonly": True},
        "containers": {"readonly": True},
        "data_disks": {"readonly": True},
        "data_mounts": {"readonly": True},
        "versions": {"readonly": True},
    }

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "subnet": {"key": "subnet", "type": "ResourceId"},
        "application_sharing_policy": {"key": "applicationSharingPolicy", "type": "str"},
        "ssh_settings": {"key": "sshSettings", "type": "ComputeInstanceSshSettings"},
        "custom_services": {"key": "customServices", "type": "[CustomService]"},
        "os_image_metadata": {"key": "osImageMetadata", "type": "ImageMetadata"},
        "connectivity_endpoints": {"key": "connectivityEndpoints", "type": "ComputeInstanceConnectivityEndpoints"},
        "applications": {"key": "applications", "type": "[ComputeInstanceApplication]"},
        "created_by": {"key": "createdBy", "type": "ComputeInstanceCreatedBy"},
        "errors": {"key": "errors", "type": "[ErrorResponse]"},
        "state": {"key": "state", "type": "str"},
        "compute_instance_authorization_type": {"key": "computeInstanceAuthorizationType", "type": "str"},
        "personal_compute_instance_settings": {
            "key": "personalComputeInstanceSettings",
            "type": "PersonalComputeInstanceSettings",
        },
        "setup_scripts": {"key": "setupScripts", "type": "SetupScripts"},
        "last_operation": {"key": "lastOperation", "type": "ComputeInstanceLastOperation"},
        "schedules": {"key": "schedules", "type": "ComputeSchedules"},
        "enable_node_public_ip": {"key": "enableNodePublicIp", "type": "bool"},
        "containers": {"key": "containers", "type": "[ComputeInstanceContainer]"},
        "data_disks": {"key": "dataDisks", "type": "[ComputeInstanceDataDisk]"},
        "data_mounts": {"key": "dataMounts", "type": "[ComputeInstanceDataMount]"},
        "versions": {"key": "versions", "type": "ComputeInstanceVersion"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        subnet: Optional["_models.ResourceId"] = None,
        application_sharing_policy: Union[str, "_models.ApplicationSharingPolicy"] = "Shared",
        ssh_settings: Optional["_models.ComputeInstanceSshSettings"] = None,
        custom_services: Optional[List["_models.CustomService"]] = None,
        compute_instance_authorization_type: Union[str, "_models.ComputeInstanceAuthorizationType"] = "personal",
        personal_compute_instance_settings: Optional["_models.PersonalComputeInstanceSettings"] = None,
        setup_scripts: Optional["_models.SetupScripts"] = None,
        schedules: Optional["_models.ComputeSchedules"] = None,
        enable_node_public_ip: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword application_sharing_policy: Policy for sharing applications on this compute instance
         among users of parent workspace. If Personal, only the creator can access applications on this
         compute instance. When Shared, any workspace user can access applications on this instance
         depending on his/her assigned role. Known values are: "Personal" and "Shared".
        :paramtype application_sharing_policy: str or
         ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
        :keyword ssh_settings: Specifies policy and settings for SSH access.
        :paramtype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
        :keyword custom_services: List of Custom Services added to the compute.
        :paramtype custom_services: list[~azure.mgmt.machinelearningservices.models.CustomService]
        :keyword compute_instance_authorization_type: The Compute Instance Authorization type.
         Available values are personal (default). "personal"
        :paramtype compute_instance_authorization_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
        :keyword personal_compute_instance_settings: Settings for a personal compute instance.
        :paramtype personal_compute_instance_settings:
         ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
        :keyword setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :paramtype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
        :keyword schedules: The list of schedules to be applied on the computes.
        :paramtype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.subnet = subnet
        self.application_sharing_policy = application_sharing_policy
        self.ssh_settings = ssh_settings
        self.custom_services = custom_services
        self.os_image_metadata = None
        self.connectivity_endpoints = None
        self.applications = None
        self.created_by = None
        self.errors = None
        self.state = None
        self.compute_instance_authorization_type = compute_instance_authorization_type
        self.personal_compute_instance_settings = personal_compute_instance_settings
        self.setup_scripts = setup_scripts
        self.last_operation = None
        self.schedules = schedules
        self.enable_node_public_ip = enable_node_public_ip
        self.containers = None
        self.data_disks = None
        self.data_mounts = None
        self.versions = None


class ComputeInstanceSshSettings(_serialization.Model):
    """Specifies policy and settings for SSH access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_public_access: State of the public SSH port. Possible values are: Disabled -
     Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
     public ssh port is open and accessible according to the VNet/subnet policy if applicable. Known
     values are: "Enabled" and "Disabled".
    :vartype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
    :ivar admin_user_name: Describes the admin user name.
    :vartype admin_user_name: str
    :ivar ssh_port: Describes the port for connecting through SSH.
    :vartype ssh_port: int
    :ivar admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t
     rsa -b 2048" to generate your SSH key pairs.
    :vartype admin_public_key: str
    """

    _validation = {
        "admin_user_name": {"readonly": True},
        "ssh_port": {"readonly": True},
    }

    _attribute_map = {
        "ssh_public_access": {"key": "sshPublicAccess", "type": "str"},
        "admin_user_name": {"key": "adminUserName", "type": "str"},
        "ssh_port": {"key": "sshPort", "type": "int"},
        "admin_public_key": {"key": "adminPublicKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        ssh_public_access: Union[str, "_models.SshPublicAccess"] = "Disabled",
        admin_public_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ssh_public_access: State of the public SSH port. Possible values are: Disabled -
         Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
         public ssh port is open and accessible according to the VNet/subnet policy if applicable. Known
         values are: "Enabled" and "Disabled".
        :paramtype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
        :keyword admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen
         -t rsa -b 2048" to generate your SSH key pairs.
        :paramtype admin_public_key: str
        """
        super().__init__(**kwargs)
        self.ssh_public_access = ssh_public_access
        self.admin_user_name = None
        self.ssh_port = None
        self.admin_public_key = admin_public_key


class ComputeInstanceVersion(_serialization.Model):
    """Version of computeInstance.

    :ivar runtime: Runtime of compute instance.
    :vartype runtime: str
    """

    _attribute_map = {
        "runtime": {"key": "runtime", "type": "str"},
    }

    def __init__(self, *, runtime: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword runtime: Runtime of compute instance.
        :paramtype runtime: str
        """
        super().__init__(**kwargs)
        self.runtime = runtime


class ComputeRecurrenceSchedule(_serialization.Model):
    """ComputeRecurrenceSchedule.

    All required parameters must be populated in order to send to Azure.

    :ivar hours: [Required] List of hours for the schedule. Required.
    :vartype hours: list[int]
    :ivar minutes: [Required] List of minutes for the schedule. Required.
    :vartype minutes: list[int]
    :ivar month_days: List of month days for the schedule.
    :vartype month_days: list[int]
    :ivar week_days: List of days for the schedule.
    :vartype week_days: list[str or ~azure.mgmt.machinelearningservices.models.ComputeWeekDay]
    """

    _validation = {
        "hours": {"required": True},
        "minutes": {"required": True},
    }

    _attribute_map = {
        "hours": {"key": "hours", "type": "[int]"},
        "minutes": {"key": "minutes", "type": "[int]"},
        "month_days": {"key": "monthDays", "type": "[int]"},
        "week_days": {"key": "weekDays", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        hours: List[int],
        minutes: List[int],
        month_days: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "_models.ComputeWeekDay"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hours: [Required] List of hours for the schedule. Required.
        :paramtype hours: list[int]
        :keyword minutes: [Required] List of minutes for the schedule. Required.
        :paramtype minutes: list[int]
        :keyword month_days: List of month days for the schedule.
        :paramtype month_days: list[int]
        :keyword week_days: List of days for the schedule.
        :paramtype week_days: list[str or ~azure.mgmt.machinelearningservices.models.ComputeWeekDay]
        """
        super().__init__(**kwargs)
        self.hours = hours
        self.minutes = minutes
        self.month_days = month_days
        self.week_days = week_days


class ComputeResourceSchema(_serialization.Model):
    """ComputeResourceSchema.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "Compute"},
    }

    def __init__(self, *, properties: Optional["_models.Compute"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        """
        super().__init__(**kwargs)
        self.properties = properties


class ComputeResource(Resource, ComputeResourceSchema):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "Compute"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.Compute"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super().__init__(properties=properties, **kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ComputeSchedules(_serialization.Model):
    """The list of schedules to be applied on the computes.

    :ivar compute_start_stop: The list of compute start stop schedules to be applied.
    :vartype compute_start_stop:
     list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
    """

    _attribute_map = {
        "compute_start_stop": {"key": "computeStartStop", "type": "[ComputeStartStopSchedule]"},
    }

    def __init__(
        self, *, compute_start_stop: Optional[List["_models.ComputeStartStopSchedule"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword compute_start_stop: The list of compute start stop schedules to be applied.
        :paramtype compute_start_stop:
         list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
        """
        super().__init__(**kwargs)
        self.compute_start_stop = compute_start_stop


class ComputeStartStopSchedule(_serialization.Model):
    """Compute start stop schedule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: A system assigned id for the schedule.
    :vartype id: str
    :ivar provisioning_status: The current deployment state of schedule. Known values are:
     "Completed", "Provisioning", and "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningStatus
    :ivar status: Is the schedule enabled or disabled?. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar action: [Required] The compute power action. Known values are: "Start" and "Stop".
    :vartype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
    :ivar trigger_type: [Required] The schedule trigger type. Known values are: "Recurrence" and
     "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.ComputeTriggerType
    :ivar recurrence: Required if triggerType is Recurrence.
    :vartype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
    :ivar cron: Required if triggerType is Cron.
    :vartype cron: ~azure.mgmt.machinelearningservices.models.Cron
    :ivar schedule: [Deprecated] Not used any more.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    """

    _validation = {
        "id": {"readonly": True},
        "provisioning_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provisioning_status": {"key": "provisioningStatus", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "recurrence": {"key": "recurrence", "type": "Recurrence"},
        "cron": {"key": "cron", "type": "Cron"},
        "schedule": {"key": "schedule", "type": "ScheduleBase"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ScheduleStatus"]] = None,
        action: Optional[Union[str, "_models.ComputePowerAction"]] = None,
        trigger_type: Optional[Union[str, "_models.ComputeTriggerType"]] = None,
        recurrence: Optional["_models.Recurrence"] = None,
        cron: Optional["_models.Cron"] = None,
        schedule: Optional["_models.ScheduleBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Is the schedule enabled or disabled?. Known values are: "Enabled" and
         "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword action: [Required] The compute power action. Known values are: "Start" and "Stop".
        :paramtype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
        :keyword trigger_type: [Required] The schedule trigger type. Known values are: "Recurrence" and
         "Cron".
        :paramtype trigger_type: str or ~azure.mgmt.machinelearningservices.models.ComputeTriggerType
        :keyword recurrence: Required if triggerType is Recurrence.
        :paramtype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
        :keyword cron: Required if triggerType is Cron.
        :paramtype cron: ~azure.mgmt.machinelearningservices.models.Cron
        :keyword schedule: [Deprecated] Not used any more.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        """
        super().__init__(**kwargs)
        self.id = None
        self.provisioning_status = None
        self.status = status
        self.action = action
        self.trigger_type = trigger_type
        self.recurrence = recurrence
        self.cron = cron
        self.schedule = schedule


class ContainerResourceRequirements(_serialization.Model):
    """Resource requirements for each container instance within an online deployment.

    :ivar container_resource_limits: Container resource limit info:.
    :vartype container_resource_limits:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    :ivar container_resource_requests: Container resource request info:.
    :vartype container_resource_requests:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    """

    _attribute_map = {
        "container_resource_limits": {"key": "containerResourceLimits", "type": "ContainerResourceSettings"},
        "container_resource_requests": {"key": "containerResourceRequests", "type": "ContainerResourceSettings"},
    }

    def __init__(
        self,
        *,
        container_resource_limits: Optional["_models.ContainerResourceSettings"] = None,
        container_resource_requests: Optional["_models.ContainerResourceSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_resource_limits: Container resource limit info:.
        :paramtype container_resource_limits:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        :keyword container_resource_requests: Container resource request info:.
        :paramtype container_resource_requests:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        """
        super().__init__(**kwargs)
        self.container_resource_limits = container_resource_limits
        self.container_resource_requests = container_resource_requests


class ContainerResourceSettings(_serialization.Model):
    """ContainerResourceSettings.

    :ivar cpu: Number of vCPUs request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: str
    :ivar gpu: Number of Nvidia GPU cards request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype gpu: str
    :ivar memory: Memory size request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "str"},
        "gpu": {"key": "gpu", "type": "str"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(
        self, *, cpu: Optional[str] = None, gpu: Optional[str] = None, memory: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword cpu: Number of vCPUs request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: str
        :keyword gpu: Number of Nvidia GPU cards request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype gpu: str
        :keyword memory: Memory size request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.gpu = gpu
        self.memory = memory


class CosmosDbSettings(_serialization.Model):
    """CosmosDbSettings.

    :ivar collections_throughput: The throughput of the collections in cosmosdb database.
    :vartype collections_throughput: int
    """

    _attribute_map = {
        "collections_throughput": {"key": "collectionsThroughput", "type": "int"},
    }

    def __init__(self, *, collections_throughput: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword collections_throughput: The throughput of the collections in cosmosdb database.
        :paramtype collections_throughput: int
        """
        super().__init__(**kwargs)
        self.collections_throughput = collections_throughput


class ScheduleActionBase(_serialization.Model):
    """ScheduleActionBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobScheduleAction, CreateMonitorAction, EndpointScheduleAction

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: [Required] Specifies the action type of the schedule. Required. Known values
     are: "CreateJob", "InvokeBatchEndpoint", and "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
    }

    _subtype_map = {
        "action_type": {
            "CreateJob": "JobScheduleAction",
            "CreateMonitor": "CreateMonitorAction",
            "InvokeBatchEndpoint": "EndpointScheduleAction",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_type: Optional[str] = None


class CreateMonitorAction(ScheduleActionBase):
    """CreateMonitorAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: [Required] Specifies the action type of the schedule. Required. Known values
     are: "CreateJob", "InvokeBatchEndpoint", and "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar monitor_definition: [Required] Defines the monitor. Required.
    :vartype monitor_definition: ~azure.mgmt.machinelearningservices.models.MonitorDefinition
    """

    _validation = {
        "action_type": {"required": True},
        "monitor_definition": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "monitor_definition": {"key": "monitorDefinition", "type": "MonitorDefinition"},
    }

    def __init__(self, *, monitor_definition: "_models.MonitorDefinition", **kwargs: Any) -> None:
        """
        :keyword monitor_definition: [Required] Defines the monitor. Required.
        :paramtype monitor_definition: ~azure.mgmt.machinelearningservices.models.MonitorDefinition
        """
        super().__init__(**kwargs)
        self.action_type: str = "CreateMonitor"
        self.monitor_definition = monitor_definition


class Cron(_serialization.Model):
    """The workflow trigger cron for ComputeStartStop schedule type.

    :ivar start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar expression: [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        time_zone: str = "UTC",
        expression: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.time_zone = time_zone
        self.expression = expression


class TriggerBase(_serialization.Model):
    """TriggerBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CronTrigger, RecurrenceTrigger

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: [Required]. Required. Known values are: "Recurrence" and "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    """

    _validation = {
        "trigger_type": {"required": True},
    }

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
    }

    _subtype_map = {"trigger_type": {"Cron": "CronTrigger", "Recurrence": "RecurrenceTrigger"}}

    def __init__(
        self, *, end_time: Optional[str] = None, start_time: Optional[str] = None, time_zone: str = "UTC", **kwargs: Any
    ) -> None:
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        """
        super().__init__(**kwargs)
        self.end_time = end_time
        self.start_time = start_time
        self.time_zone = time_zone
        self.trigger_type: Optional[str] = None


class CronTrigger(TriggerBase):
    """CronTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: [Required]. Required. Known values are: "Recurrence" and "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar expression: [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format. Required.
    :vartype expression: str
    """

    _validation = {
        "trigger_type": {"required": True},
        "expression": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
    }

    def __init__(
        self,
        *,
        expression: str,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: str = "UTC",
        **kwargs: Any
    ) -> None:
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword expression: [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format. Required.
        :paramtype expression: str
        """
        super().__init__(end_time=end_time, start_time=start_time, time_zone=time_zone, **kwargs)
        self.trigger_type: str = "Cron"
        self.expression = expression


class CustomForecastHorizon(ForecastHorizon):
    """The desired maximum forecast horizon in units of time-series frequency.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set forecast horizon value selection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    :ivar value: [Required] Forecast horizon value. Required.
    :vartype value: int
    """

    _validation = {
        "mode": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: [Required] Forecast horizon value. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.mode: str = "Custom"
        self.value = value


class CustomMetricThreshold(_serialization.Model):
    """CustomMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: [Required] The user-defined metric to calculate. Required.
    :vartype metric: str
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        "metric": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
    }

    def __init__(
        self, *, metric: str, threshold: Optional["_models.MonitoringThreshold"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metric: [Required] The user-defined metric to calculate. Required.
        :paramtype metric: str
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class JobInput(_serialization.Model):
    """Command job definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput,
    TritonModelJobInput, UriFileJobInput, UriFolderJobInput

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        "job_input_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
    }

    _subtype_map = {
        "job_input_type": {
            "custom_model": "CustomModelJobInput",
            "literal": "LiteralJobInput",
            "mlflow_model": "MLFlowModelJobInput",
            "mltable": "MLTableJobInput",
            "triton_model": "TritonModelJobInput",
            "uri_file": "UriFileJobInput",
            "uri_folder": "UriFolderJobInput",
        }
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.job_input_type: Optional[str] = None


class CustomModelJobInput(AssetJobInput, JobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
     "Download", "Direct", "EvalMount", and "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "job_input_type": {"required": True},
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: str,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.InputDeliveryMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
         "Download", "Direct", "EvalMount", and "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_input_type: str = "custom_model"
        self.mode = mode
        self.uri = uri


class JobOutput(_serialization.Model):
    """Job output definition container information on where to find job output/logs.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput,
    UriFileJobOutput, UriFolderJobOutput

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: [Required] Specifies the type of job. Required. Known values are:
     "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        "job_output_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_output_type": {"key": "jobOutputType", "type": "str"},
    }

    _subtype_map = {
        "job_output_type": {
            "custom_model": "CustomModelJobOutput",
            "mlflow_model": "MLFlowModelJobOutput",
            "mltable": "MLTableJobOutput",
            "triton_model": "TritonModelJobOutput",
            "uri_file": "UriFileJobOutput",
            "uri_folder": "UriFolderJobOutput",
        }
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.job_output_type: Optional[str] = None


class CustomModelJobOutput(AssetJobOutput, JobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: [Required] Specifies the type of job. Required. Known values are:
     "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    :ivar mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _validation = {
        "job_output_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_output_type": {"key": "jobOutputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the output.
        :paramtype description: str
        :keyword mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_output_type: str = "custom_model"
        self.mode = mode
        self.uri = uri


class MonitoringSignalBase(_serialization.Model):
    """MonitoringSignalBase.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CustomMonitoringSignal, DataDriftMonitoringSignal, DataQualityMonitoringSignal,
    FeatureAttributionDriftMonitoringSignal, PredictionDriftMonitoringSignal

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    """

    _validation = {
        "signal_type": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
    }

    _subtype_map = {
        "signal_type": {
            "Custom": "CustomMonitoringSignal",
            "DataDrift": "DataDriftMonitoringSignal",
            "DataQuality": "DataQualityMonitoringSignal",
            "FeatureAttributionDrift": "FeatureAttributionDriftMonitoringSignal",
            "PredictionDrift": "PredictionDriftMonitoringSignal",
        }
    }

    def __init__(
        self,
        *,
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.notification_types = notification_types
        self.properties = properties
        self.signal_type: Optional[str] = None


class CustomMonitoringSignal(MonitoringSignalBase):
    """CustomMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar component_id: [Required] Reference to the component asset used to calculate the custom
     metrics. Required.
    :vartype component_id: str
    :ivar input_assets: Monitoring assets to take as input. Key is the component input port name,
     value is the data asset.
    :vartype input_assets: dict[str,
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar inputs: Extra component parameters to take as input. Key is the component literal input
     port name, value is the parameter value.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar metric_thresholds: [Required] A list of metrics to calculate and their associated
     thresholds. Required.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.CustomMetricThreshold]
    """

    _validation = {
        "signal_type": {"required": True},
        "component_id": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "metric_thresholds": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
        "component_id": {"key": "componentId", "type": "str"},
        "input_assets": {"key": "inputAssets", "type": "{MonitoringInputDataBase}"},
        "inputs": {"key": "inputs", "type": "{JobInput}"},
        "metric_thresholds": {"key": "metricThresholds", "type": "[CustomMetricThreshold]"},
    }

    def __init__(
        self,
        *,
        component_id: str,
        metric_thresholds: List["_models.CustomMetricThreshold"],
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        input_assets: Optional[Dict[str, "_models.MonitoringInputDataBase"]] = None,
        inputs: Optional[Dict[str, "_models.JobInput"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword component_id: [Required] Reference to the component asset used to calculate the custom
         metrics. Required.
        :paramtype component_id: str
        :keyword input_assets: Monitoring assets to take as input. Key is the component input port
         name, value is the data asset.
        :paramtype input_assets: dict[str,
         ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword inputs: Extra component parameters to take as input. Key is the component literal
         input port name, value is the parameter value.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword metric_thresholds: [Required] A list of metrics to calculate and their associated
         thresholds. Required.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.CustomMetricThreshold]
        """
        super().__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type: str = "Custom"
        self.component_id = component_id
        self.input_assets = input_assets
        self.inputs = inputs
        self.metric_thresholds = metric_thresholds


class CustomNCrossValidations(NCrossValidations):
    """N-Cross validations are specified by user.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Mode for determining N-Cross validations. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    :ivar value: [Required] N-Cross validations value. Required.
    :vartype value: int
    """

    _validation = {
        "mode": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: [Required] N-Cross validations value. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.mode: str = "Custom"
        self.value = value


class CustomSeasonality(Seasonality):
    """CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Seasonality mode. Required. Known values are: "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    :ivar value: [Required] Seasonality value. Required.
    :vartype value: int
    """

    _validation = {
        "mode": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: [Required] Seasonality value. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.mode: str = "Custom"
        self.value = value


class CustomService(_serialization.Model):
    """Specifies the custom service configuration.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Name of the Custom Service.
    :vartype name: str
    :ivar image: Describes the Image Specifications.
    :vartype image: ~azure.mgmt.machinelearningservices.models.Image
    :ivar environment_variables: Environment Variable for the container.
    :vartype environment_variables: dict[str,
     ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
    :ivar docker: Describes the docker settings for the image.
    :vartype docker: ~azure.mgmt.machinelearningservices.models.Docker
    :ivar endpoints: Configuring the endpoints for the container.
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
    :ivar volumes: Configuring the volumes for the container.
    :vartype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "image": {"key": "image", "type": "Image"},
        "environment_variables": {"key": "environmentVariables", "type": "{EnvironmentVariable}"},
        "docker": {"key": "docker", "type": "Docker"},
        "endpoints": {"key": "endpoints", "type": "[Endpoint]"},
        "volumes": {"key": "volumes", "type": "[VolumeDefinition]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        name: Optional[str] = None,
        image: Optional["_models.Image"] = None,
        environment_variables: Optional[Dict[str, "_models.EnvironmentVariable"]] = None,
        docker: Optional["_models.Docker"] = None,
        endpoints: Optional[List["_models.Endpoint"]] = None,
        volumes: Optional[List["_models.VolumeDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword name: Name of the Custom Service.
        :paramtype name: str
        :keyword image: Describes the Image Specifications.
        :paramtype image: ~azure.mgmt.machinelearningservices.models.Image
        :keyword environment_variables: Environment Variable for the container.
        :paramtype environment_variables: dict[str,
         ~azure.mgmt.machinelearningservices.models.EnvironmentVariable]
        :keyword docker: Describes the docker settings for the image.
        :paramtype docker: ~azure.mgmt.machinelearningservices.models.Docker
        :keyword endpoints: Configuring the endpoints for the container.
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.Endpoint]
        :keyword volumes: Configuring the volumes for the container.
        :paramtype volumes: list[~azure.mgmt.machinelearningservices.models.VolumeDefinition]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.image = image
        self.environment_variables = environment_variables
        self.docker = docker
        self.endpoints = endpoints
        self.volumes = volumes


class CustomTargetLags(TargetLags):
    """CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] Set target lags mode - Auto/Custom. Required. Known values are: "Auto"
     and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    :ivar values: [Required] Set target lags values. Required.
    :vartype values: list[int]
    """

    _validation = {
        "mode": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "values": {"key": "values", "type": "[int]"},
    }

    def __init__(self, *, values: List[int], **kwargs: Any) -> None:
        """
        :keyword values: [Required] Set target lags values. Required.
        :paramtype values: list[int]
        """
        super().__init__(**kwargs)
        self.mode: str = "Custom"
        self.values = values


class CustomTargetRollingWindowSize(TargetRollingWindowSize):
    """CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: [Required] TargetRollingWindowSiz detection mode. Required. Known values are:
     "Auto" and "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    :ivar value: [Required] TargetRollingWindowSize value. Required.
    :vartype value: int
    """

    _validation = {
        "mode": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, value: int, **kwargs: Any) -> None:
        """
        :keyword value: [Required] TargetRollingWindowSize value. Required.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.mode: str = "Custom"
        self.value = value


class DatabricksSchema(_serialization.Model):
    """DatabricksSchema.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "DatabricksProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DatabricksProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class Databricks(Compute, DatabricksSchema):  # pylint: disable=too-many-instance-attributes
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "DatabricksProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.DatabricksProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "Databricks"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class DatabricksComputeSecretsProperties(_serialization.Model):
    """Properties of Databricks Compute Secrets.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    """

    _attribute_map = {
        "databricks_access_token": {"key": "databricksAccessToken", "type": "str"},
    }

    def __init__(self, *, databricks_access_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super().__init__(**kwargs)
        self.databricks_access_token = databricks_access_token


class DatabricksComputeSecrets(ComputeSecrets, DatabricksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        "compute_type": {"required": True},
    }

    _attribute_map = {
        "databricks_access_token": {"key": "databricksAccessToken", "type": "str"},
        "compute_type": {"key": "computeType", "type": "str"},
    }

    def __init__(self, *, databricks_access_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super().__init__(databricks_access_token=databricks_access_token, **kwargs)
        self.databricks_access_token = databricks_access_token
        self.compute_type: str = "Databricks"


class DatabricksProperties(_serialization.Model):
    """Properties of Databricks.

    :ivar databricks_access_token: Databricks access token.
    :vartype databricks_access_token: str
    :ivar workspace_url: Workspace Url.
    :vartype workspace_url: str
    """

    _attribute_map = {
        "databricks_access_token": {"key": "databricksAccessToken", "type": "str"},
        "workspace_url": {"key": "workspaceUrl", "type": "str"},
    }

    def __init__(
        self, *, databricks_access_token: Optional[str] = None, workspace_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword databricks_access_token: Databricks access token.
        :paramtype databricks_access_token: str
        :keyword workspace_url: Workspace Url.
        :paramtype workspace_url: str
        """
        super().__init__(**kwargs)
        self.databricks_access_token = databricks_access_token
        self.workspace_url = workspace_url


class DataContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DataContainerProperties"},
    }

    def __init__(self, *, properties: "_models.DataContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataContainerProperties(AssetContainer):
    """Container for data asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar data_type: [Required] Specifies the type of data. Required. Known values are: "uri_file",
     "uri_folder", and "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "data_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_type: Union[str, "_models.DataType"],
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_type: [Required] Specifies the type of data. Required. Known values are:
         "uri_file", "uri_folder", and "mltable".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.data_type = data_type


class DataContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of DataContainer entities.

    :ivar next_link: The link to the next page of DataContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataContainer]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.DataContainer"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of DataContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataDriftMonitoringSignal(MonitoringSignalBase):
    """DataDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: The settings for computing feature importance.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar features: The feature filter which identifies which feature to calculate drift over.
    :vartype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
    :ivar metric_thresholds: [Required] A list of metrics to calculate and their associated
     thresholds. Required.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.DataDriftMetricThresholdBase]
    :ivar production_data: [Required] The data which drift will be calculated for. Required.
    :vartype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    :ivar reference_data: [Required] The data to calculate drift against. Required.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        "signal_type": {"required": True},
        "metric_thresholds": {"required": True},
        "production_data": {"required": True},
        "reference_data": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
        "feature_data_type_override": {"key": "featureDataTypeOverride", "type": "{str}"},
        "feature_importance_settings": {"key": "featureImportanceSettings", "type": "FeatureImportanceSettings"},
        "features": {"key": "features", "type": "MonitoringFeatureFilterBase"},
        "metric_thresholds": {"key": "metricThresholds", "type": "[DataDriftMetricThresholdBase]"},
        "production_data": {"key": "productionData", "type": "MonitoringInputDataBase"},
        "reference_data": {"key": "referenceData", "type": "MonitoringInputDataBase"},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["_models.DataDriftMetricThresholdBase"],
        production_data: "_models.MonitoringInputDataBase",
        reference_data: "_models.MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "_models.MonitoringFeatureDataType"]]] = None,
        feature_importance_settings: Optional["_models.FeatureImportanceSettings"] = None,
        features: Optional["_models.MonitoringFeatureFilterBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: The settings for computing feature importance.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword features: The feature filter which identifies which feature to calculate drift over.
        :paramtype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
        :keyword metric_thresholds: [Required] A list of metrics to calculate and their associated
         thresholds. Required.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.DataDriftMetricThresholdBase]
        :keyword production_data: [Required] The data which drift will be calculated for. Required.
        :paramtype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        :keyword reference_data: [Required] The data to calculate drift against. Required.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super().__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type: str = "DataDrift"
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.features = features
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.reference_data = reference_data


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            **kwargs
        )
        self.compute_type: str = "DataFactory"


class DataLakeAnalyticsSchema(_serialization.Model):
    """DataLakeAnalyticsSchema.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "DataLakeAnalyticsSchemaProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.DataLakeAnalyticsSchemaProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataLakeAnalytics(Compute, DataLakeAnalyticsSchema):  # pylint: disable=too-many-instance-attributes
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties:
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "DataLakeAnalyticsSchemaProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.DataLakeAnalyticsSchemaProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsSchemaProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "DataLakeAnalytics"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class DataLakeAnalyticsSchemaProperties(_serialization.Model):
    """DataLakeAnalyticsSchemaProperties.

    :ivar data_lake_store_account_name: DataLake Store Account Name.
    :vartype data_lake_store_account_name: str
    """

    _attribute_map = {
        "data_lake_store_account_name": {"key": "dataLakeStoreAccountName", "type": "str"},
    }

    def __init__(self, *, data_lake_store_account_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword data_lake_store_account_name: DataLake Store Account Name.
        :paramtype data_lake_store_account_name: str
        """
        super().__init__(**kwargs)
        self.data_lake_store_account_name = data_lake_store_account_name


class DataPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: [Required] Specifies the type of asset reference. Required. Known values
     are: "Id", "DataPath", and "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        "reference_type": {"required": True},
    }

    _attribute_map = {
        "reference_type": {"key": "referenceType", "type": "str"},
        "datastore_id": {"key": "datastoreId", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, datastore_id: Optional[str] = None, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.reference_type: str = "DataPath"
        self.datastore_id = datastore_id
        self.path = path


class DataQualityMonitoringSignal(MonitoringSignalBase):
    """DataQualityMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: The settings for computing feature importance.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar features: The features to calculate drift over.
    :vartype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
    :ivar metric_thresholds: [Required] A list of metrics to calculate and their associated
     thresholds. Required.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.DataQualityMetricThresholdBase]
    :ivar production_data: [Required] The data produced by the production service which drift will
     be calculated for. Required.
    :vartype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    :ivar reference_data: [Required] The data to calculate drift against. Required.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        "signal_type": {"required": True},
        "metric_thresholds": {"required": True},
        "production_data": {"required": True},
        "reference_data": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
        "feature_data_type_override": {"key": "featureDataTypeOverride", "type": "{str}"},
        "feature_importance_settings": {"key": "featureImportanceSettings", "type": "FeatureImportanceSettings"},
        "features": {"key": "features", "type": "MonitoringFeatureFilterBase"},
        "metric_thresholds": {"key": "metricThresholds", "type": "[DataQualityMetricThresholdBase]"},
        "production_data": {"key": "productionData", "type": "MonitoringInputDataBase"},
        "reference_data": {"key": "referenceData", "type": "MonitoringInputDataBase"},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["_models.DataQualityMetricThresholdBase"],
        production_data: "_models.MonitoringInputDataBase",
        reference_data: "_models.MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "_models.MonitoringFeatureDataType"]]] = None,
        feature_importance_settings: Optional["_models.FeatureImportanceSettings"] = None,
        features: Optional["_models.MonitoringFeatureFilterBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: The settings for computing feature importance.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword features: The features to calculate drift over.
        :paramtype features: ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterBase
        :keyword metric_thresholds: [Required] A list of metrics to calculate and their associated
         thresholds. Required.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.DataQualityMetricThresholdBase]
        :keyword production_data: [Required] The data produced by the production service which drift
         will be calculated for. Required.
        :paramtype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        :keyword reference_data: [Required] The data to calculate drift against. Required.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super().__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type: str = "DataQuality"
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.features = features
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.reference_data = reference_data


class Datastore(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DatastoreProperties"},
    }

    def __init__(self, *, properties: "_models.DatastoreProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatastoreProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DatastoreResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of Datastore entities.

    :ivar next_link: The link to the next page of Datastore objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Datastore.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Datastore]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Datastore"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of Datastore objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Datastore.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Datastore]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataVersionBase(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DataVersionBaseProperties"},
    }

    def __init__(self, *, properties: "_models.DataVersionBaseProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataVersionBaseProperties(AssetBase):
    """Data version base definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MLTableData, UriFileDataVersion, UriFolderDataVersion

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: [Required] Specifies the type of data. Required. Known values are: "uri_file",
     "uri_folder", and "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: [Required] Uri of the data. Example:
     https://go.microsoft.com/fwlink/?linkid=2202330. Required.
    :vartype data_uri: str
    """

    _validation = {
        "data_type": {"required": True},
        "data_uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "data_type": {"key": "dataType", "type": "str"},
        "data_uri": {"key": "dataUri", "type": "str"},
    }

    _subtype_map = {
        "data_type": {"mltable": "MLTableData", "uri_file": "UriFileDataVersion", "uri_folder": "UriFolderDataVersion"}
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: [Required] Uri of the data. Example:
         https://go.microsoft.com/fwlink/?linkid=2202330. Required.
        :paramtype data_uri: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.data_type: Optional[str] = None
        self.data_uri = data_uri


class DataVersionBaseResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of DataVersionBase entities.

    :ivar next_link: The link to the next page of DataVersionBase objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataVersionBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataVersionBase]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.DataVersionBase"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of DataVersionBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataVersionBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBase]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineScaleSettings(_serialization.Model):
    """Online deployment scaling configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DefaultScaleSettings, TargetUtilizationScaleSettings

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: [Required] Type of deployment scaling algorithm. Required. Known values are:
     "Default" and "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        "scale_type": {"required": True},
    }

    _attribute_map = {
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    _subtype_map = {
        "scale_type": {"Default": "DefaultScaleSettings", "TargetUtilization": "TargetUtilizationScaleSettings"}
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.scale_type: Optional[str] = None


class DefaultScaleSettings(OnlineScaleSettings):
    """DefaultScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: [Required] Type of deployment scaling algorithm. Required. Known values are:
     "Default" and "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        "scale_type": {"required": True},
    }

    _attribute_map = {
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.scale_type: str = "Default"


class DeploymentLogs(_serialization.Model):
    """DeploymentLogs.

    :ivar content: The retrieved online deployment logs.
    :vartype content: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
    }

    def __init__(self, *, content: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content: The retrieved online deployment logs.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.content = content


class DeploymentLogsRequest(_serialization.Model):
    """DeploymentLogsRequest.

    :ivar container_type: The type of container to retrieve logs from. Known values are:
     "StorageInitializer" and "InferenceServer".
    :vartype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
    :ivar tail: The maximum number of lines to tail.
    :vartype tail: int
    """

    _attribute_map = {
        "container_type": {"key": "containerType", "type": "str"},
        "tail": {"key": "tail", "type": "int"},
    }

    def __init__(
        self,
        *,
        container_type: Optional[Union[str, "_models.ContainerType"]] = None,
        tail: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_type: The type of container to retrieve logs from. Known values are:
         "StorageInitializer" and "InferenceServer".
        :paramtype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
        :keyword tail: The maximum number of lines to tail.
        :paramtype tail: int
        """
        super().__init__(**kwargs)
        self.container_type = container_type
        self.tail = tail


class ResourceConfiguration(_serialization.Model):
    """ResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, JSON]
    """

    _attribute_map = {
        "instance_count": {"key": "instanceCount", "type": "int"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        instance_count: int = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.instance_count = instance_count
        self.instance_type = instance_type
        self.properties = properties


class DeploymentResourceConfiguration(ResourceConfiguration):
    """DeploymentResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, JSON]
    """

    _attribute_map = {
        "instance_count": {"key": "instanceCount", "type": "int"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        instance_count: int = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, JSON]
        """
        super().__init__(instance_count=instance_count, instance_type=instance_type, properties=properties, **kwargs)


class DestinationAsset(_serialization.Model):
    """Publishing destination registry asset information.

    :ivar destination_name: Destination asset name.
    :vartype destination_name: str
    :ivar destination_version: Destination asset version.
    :vartype destination_version: str
    :ivar registry_name: Destination registry name.
    :vartype registry_name: str
    """

    _attribute_map = {
        "destination_name": {"key": "destinationName", "type": "str"},
        "destination_version": {"key": "destinationVersion", "type": "str"},
        "registry_name": {"key": "registryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        destination_name: Optional[str] = None,
        destination_version: Optional[str] = None,
        registry_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination_name: Destination asset name.
        :paramtype destination_name: str
        :keyword destination_version: Destination asset version.
        :paramtype destination_version: str
        :keyword registry_name: Destination registry name.
        :paramtype registry_name: str
        """
        super().__init__(**kwargs)
        self.destination_name = destination_name
        self.destination_version = destination_version
        self.registry_name = registry_name


class DiagnoseRequestProperties(_serialization.Model):
    """DiagnoseRequestProperties.

    :ivar udr: Setting for diagnosing user defined routing.
    :vartype udr: dict[str, JSON]
    :ivar nsg: Setting for diagnosing network security group.
    :vartype nsg: dict[str, JSON]
    :ivar resource_lock: Setting for diagnosing resource lock.
    :vartype resource_lock: dict[str, JSON]
    :ivar dns_resolution: Setting for diagnosing dns resolution.
    :vartype dns_resolution: dict[str, JSON]
    :ivar storage_account: Setting for diagnosing dependent storage account.
    :vartype storage_account: dict[str, JSON]
    :ivar key_vault: Setting for diagnosing dependent key vault.
    :vartype key_vault: dict[str, JSON]
    :ivar container_registry: Setting for diagnosing dependent container registry.
    :vartype container_registry: dict[str, JSON]
    :ivar application_insights: Setting for diagnosing dependent application insights.
    :vartype application_insights: dict[str, JSON]
    :ivar others: Setting for diagnosing unclassified category of problems.
    :vartype others: dict[str, JSON]
    """

    _attribute_map = {
        "udr": {"key": "udr", "type": "{object}"},
        "nsg": {"key": "nsg", "type": "{object}"},
        "resource_lock": {"key": "resourceLock", "type": "{object}"},
        "dns_resolution": {"key": "dnsResolution", "type": "{object}"},
        "storage_account": {"key": "storageAccount", "type": "{object}"},
        "key_vault": {"key": "keyVault", "type": "{object}"},
        "container_registry": {"key": "containerRegistry", "type": "{object}"},
        "application_insights": {"key": "applicationInsights", "type": "{object}"},
        "others": {"key": "others", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        udr: Optional[Dict[str, JSON]] = None,
        nsg: Optional[Dict[str, JSON]] = None,
        resource_lock: Optional[Dict[str, JSON]] = None,
        dns_resolution: Optional[Dict[str, JSON]] = None,
        storage_account: Optional[Dict[str, JSON]] = None,
        key_vault: Optional[Dict[str, JSON]] = None,
        container_registry: Optional[Dict[str, JSON]] = None,
        application_insights: Optional[Dict[str, JSON]] = None,
        others: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword udr: Setting for diagnosing user defined routing.
        :paramtype udr: dict[str, JSON]
        :keyword nsg: Setting for diagnosing network security group.
        :paramtype nsg: dict[str, JSON]
        :keyword resource_lock: Setting for diagnosing resource lock.
        :paramtype resource_lock: dict[str, JSON]
        :keyword dns_resolution: Setting for diagnosing dns resolution.
        :paramtype dns_resolution: dict[str, JSON]
        :keyword storage_account: Setting for diagnosing dependent storage account.
        :paramtype storage_account: dict[str, JSON]
        :keyword key_vault: Setting for diagnosing dependent key vault.
        :paramtype key_vault: dict[str, JSON]
        :keyword container_registry: Setting for diagnosing dependent container registry.
        :paramtype container_registry: dict[str, JSON]
        :keyword application_insights: Setting for diagnosing dependent application insights.
        :paramtype application_insights: dict[str, JSON]
        :keyword others: Setting for diagnosing unclassified category of problems.
        :paramtype others: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.udr = udr
        self.nsg = nsg
        self.resource_lock = resource_lock
        self.dns_resolution = dns_resolution
        self.storage_account = storage_account
        self.key_vault = key_vault
        self.container_registry = container_registry
        self.application_insights = application_insights
        self.others = others


class DiagnoseResponseResult(_serialization.Model):
    """DiagnoseResponseResult.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
    """

    _attribute_map = {
        "value": {"key": "value", "type": "DiagnoseResponseResultValue"},
    }

    def __init__(self, *, value: Optional["_models.DiagnoseResponseResultValue"] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
        """
        super().__init__(**kwargs)
        self.value = value


class DiagnoseResponseResultValue(_serialization.Model):
    """DiagnoseResponseResultValue.

    :ivar user_defined_route_results:
    :vartype user_defined_route_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar network_security_rule_results:
    :vartype network_security_rule_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar resource_lock_results:
    :vartype resource_lock_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar dns_resolution_results:
    :vartype dns_resolution_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar storage_account_results:
    :vartype storage_account_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar key_vault_results:
    :vartype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar container_registry_results:
    :vartype container_registry_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar application_insights_results:
    :vartype application_insights_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar other_results:
    :vartype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    """

    _attribute_map = {
        "user_defined_route_results": {"key": "userDefinedRouteResults", "type": "[DiagnoseResult]"},
        "network_security_rule_results": {"key": "networkSecurityRuleResults", "type": "[DiagnoseResult]"},
        "resource_lock_results": {"key": "resourceLockResults", "type": "[DiagnoseResult]"},
        "dns_resolution_results": {"key": "dnsResolutionResults", "type": "[DiagnoseResult]"},
        "storage_account_results": {"key": "storageAccountResults", "type": "[DiagnoseResult]"},
        "key_vault_results": {"key": "keyVaultResults", "type": "[DiagnoseResult]"},
        "container_registry_results": {"key": "containerRegistryResults", "type": "[DiagnoseResult]"},
        "application_insights_results": {"key": "applicationInsightsResults", "type": "[DiagnoseResult]"},
        "other_results": {"key": "otherResults", "type": "[DiagnoseResult]"},
    }

    def __init__(
        self,
        *,
        user_defined_route_results: Optional[List["_models.DiagnoseResult"]] = None,
        network_security_rule_results: Optional[List["_models.DiagnoseResult"]] = None,
        resource_lock_results: Optional[List["_models.DiagnoseResult"]] = None,
        dns_resolution_results: Optional[List["_models.DiagnoseResult"]] = None,
        storage_account_results: Optional[List["_models.DiagnoseResult"]] = None,
        key_vault_results: Optional[List["_models.DiagnoseResult"]] = None,
        container_registry_results: Optional[List["_models.DiagnoseResult"]] = None,
        application_insights_results: Optional[List["_models.DiagnoseResult"]] = None,
        other_results: Optional[List["_models.DiagnoseResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_defined_route_results:
        :paramtype user_defined_route_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword network_security_rule_results:
        :paramtype network_security_rule_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword resource_lock_results:
        :paramtype resource_lock_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword dns_resolution_results:
        :paramtype dns_resolution_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword storage_account_results:
        :paramtype storage_account_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword key_vault_results:
        :paramtype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword container_registry_results:
        :paramtype container_registry_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword application_insights_results:
        :paramtype application_insights_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword other_results:
        :paramtype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        """
        super().__init__(**kwargs)
        self.user_defined_route_results = user_defined_route_results
        self.network_security_rule_results = network_security_rule_results
        self.resource_lock_results = resource_lock_results
        self.dns_resolution_results = dns_resolution_results
        self.storage_account_results = storage_account_results
        self.key_vault_results = key_vault_results
        self.container_registry_results = container_registry_results
        self.application_insights_results = application_insights_results
        self.other_results = other_results


class DiagnoseResult(_serialization.Model):
    """Result of Diagnose.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code for workspace setup error.
    :vartype code: str
    :ivar level: Level of workspace setup error. Known values are: "Warning", "Error", and
     "Information".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.DiagnoseResultLevel
    :ivar message: Message of workspace setup error.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "level": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.level = None
        self.message = None


class DiagnoseWorkspaceParameters(_serialization.Model):
    """Parameters to diagnose a workspace.

    :ivar value: Value of Parameters.
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
    """

    _attribute_map = {
        "value": {"key": "value", "type": "DiagnoseRequestProperties"},
    }

    def __init__(self, *, value: Optional["_models.DiagnoseRequestProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword value: Value of Parameters.
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
        """
        super().__init__(**kwargs)
        self.value = value


class DistributionConfiguration(_serialization.Model):
    """Base definition for job distribution configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Mpi, PyTorch, TensorFlow

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: [Required] Specifies the type of distribution framework. Required.
     Known values are: "PyTorch", "TensorFlow", and "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    """

    _validation = {
        "distribution_type": {"required": True},
    }

    _attribute_map = {
        "distribution_type": {"key": "distributionType", "type": "str"},
    }

    _subtype_map = {"distribution_type": {"Mpi": "Mpi", "PyTorch": "PyTorch", "TensorFlow": "TensorFlow"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.distribution_type: Optional[str] = None


class Docker(_serialization.Model):
    """Docker container configuration.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar privileged: Indicate whether container shall run in privileged or non-privileged mode.
    :vartype privileged: bool
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "privileged": {"key": "privileged", "type": "bool"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        privileged: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword privileged: Indicate whether container shall run in privileged or non-privileged mode.
        :paramtype privileged: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.privileged = privileged


class DockerCredential(DataReferenceCredential):
    """Credential for docker with username and password.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "SAS", "DockerCredentials", "ManagedIdentity", and "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    :ivar password: DockerCredential user password.
    :vartype password: str
    :ivar user_name: DockerCredential user name.
    :vartype user_name: str
    """

    _validation = {
        "credential_type": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "credentialType", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
    }

    def __init__(self, *, password: Optional[str] = None, user_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword password: DockerCredential user password.
        :paramtype password: str
        :keyword user_name: DockerCredential user name.
        :paramtype user_name: str
        """
        super().__init__(**kwargs)
        self.credential_type: str = "DockerCredentials"
        self.password = password
        self.user_name = user_name


class EncryptionKeyVaultProperties(_serialization.Model):
    """EncryptionKeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is
     present. Required.
    :vartype key_vault_arm_id: str
    :ivar key_identifier: Key vault uri to access the encryption key. Required.
    :vartype key_identifier: str
    :ivar identity_client_id: For future use - The client id of the identity which will be used to
     access key vault.
    :vartype identity_client_id: str
    """

    _validation = {
        "key_vault_arm_id": {"required": True},
        "key_identifier": {"required": True},
    }

    _attribute_map = {
        "key_vault_arm_id": {"key": "keyVaultArmId", "type": "str"},
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "identity_client_id": {"key": "identityClientId", "type": "str"},
    }

    def __init__(
        self, *, key_vault_arm_id: str, key_identifier: str, identity_client_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is
         present. Required.
        :paramtype key_vault_arm_id: str
        :keyword key_identifier: Key vault uri to access the encryption key. Required.
        :paramtype key_identifier: str
        :keyword identity_client_id: For future use - The client id of the identity which will be used
         to access key vault.
        :paramtype identity_client_id: str
        """
        super().__init__(**kwargs)
        self.key_vault_arm_id = key_vault_arm_id
        self.key_identifier = key_identifier
        self.identity_client_id = identity_client_id


class EncryptionProperty(_serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Indicates whether or not the encryption is enabled for the workspace. Required.
     Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :ivar identity: The identity that will be used to access the key vault for encryption at rest.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
    :ivar key_vault_properties: Customer Key vault properties. Required.
    :vartype key_vault_properties:
     ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultProperties
    """

    _validation = {
        "status": {"required": True},
        "key_vault_properties": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityForCmk"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "EncryptionKeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.EncryptionStatus"],
        key_vault_properties: "_models.EncryptionKeyVaultProperties",
        identity: Optional["_models.IdentityForCmk"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether or not the encryption is enabled for the workspace.
         Required. Known values are: "Enabled" and "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
        :keyword identity: The identity that will be used to access the key vault for encryption at
         rest.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
        :keyword key_vault_properties: Customer Key vault properties. Required.
        :paramtype key_vault_properties:
         ~azure.mgmt.machinelearningservices.models.EncryptionKeyVaultProperties
        """
        super().__init__(**kwargs)
        self.status = status
        self.identity = identity
        self.key_vault_properties = key_vault_properties


class Endpoint(_serialization.Model):
    """Describes the endpoint configuration for the container.

    :ivar protocol: Protocol over which communication will happen over this endpoint. Known values
     are: "tcp", "udp", and "http".
    :vartype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
    :ivar name: Name of the Endpoint.
    :vartype name: str
    :ivar target: Application port inside the container.
    :vartype target: int
    :ivar published: Port over which the application is exposed from container.
    :vartype published: int
    :ivar host_ip: Host IP over which the application is exposed from the container.
    :vartype host_ip: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "target": {"key": "target", "type": "int"},
        "published": {"key": "published", "type": "int"},
        "host_ip": {"key": "hostIp", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Union[str, "_models.Protocol"] = "tcp",
        name: Optional[str] = None,
        target: Optional[int] = None,
        published: Optional[int] = None,
        host_ip: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: Protocol over which communication will happen over this endpoint. Known
         values are: "tcp", "udp", and "http".
        :paramtype protocol: str or ~azure.mgmt.machinelearningservices.models.Protocol
        :keyword name: Name of the Endpoint.
        :paramtype name: str
        :keyword target: Application port inside the container.
        :paramtype target: int
        :keyword published: Port over which the application is exposed from container.
        :paramtype published: int
        :keyword host_ip: Host IP over which the application is exposed from the container.
        :paramtype host_ip: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.name = name
        self.target = target
        self.published = published
        self.host_ip = host_ip


class EndpointAuthKeys(_serialization.Model):
    """Keys for endpoint authentication.

    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    """

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
    }

    def __init__(
        self, *, primary_key: Optional[str] = None, secondary_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        """
        super().__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class EndpointAuthToken(_serialization.Model):
    """Service Token.

    :ivar access_token: Access token for endpoint authentication.
    :vartype access_token: str
    :ivar expiry_time_utc: Access token expiry time (UTC).
    :vartype expiry_time_utc: int
    :ivar refresh_after_time_utc: Refresh access token after time (UTC).
    :vartype refresh_after_time_utc: int
    :ivar token_type: Access token type.
    :vartype token_type: str
    """

    _attribute_map = {
        "access_token": {"key": "accessToken", "type": "str"},
        "expiry_time_utc": {"key": "expiryTimeUtc", "type": "int"},
        "refresh_after_time_utc": {"key": "refreshAfterTimeUtc", "type": "int"},
        "token_type": {"key": "tokenType", "type": "str"},
    }

    def __init__(
        self,
        *,
        access_token: Optional[str] = None,
        expiry_time_utc: int = 0,
        refresh_after_time_utc: int = 0,
        token_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_token: Access token for endpoint authentication.
        :paramtype access_token: str
        :keyword expiry_time_utc: Access token expiry time (UTC).
        :paramtype expiry_time_utc: int
        :keyword refresh_after_time_utc: Refresh access token after time (UTC).
        :paramtype refresh_after_time_utc: int
        :keyword token_type: Access token type.
        :paramtype token_type: str
        """
        super().__init__(**kwargs)
        self.access_token = access_token
        self.expiry_time_utc = expiry_time_utc
        self.refresh_after_time_utc = refresh_after_time_utc
        self.token_type = token_type


class EndpointScheduleAction(ScheduleActionBase):
    """EndpointScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: [Required] Specifies the action type of the schedule. Required. Known values
     are: "CreateJob", "InvokeBatchEndpoint", and "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar endpoint_invocation_definition: [Required] Defines Schedule action definition details.


     .. raw:: html

        <see href="TBD" />. Required.
    :vartype endpoint_invocation_definition: JSON
    """

    _validation = {
        "action_type": {"required": True},
        "endpoint_invocation_definition": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "endpoint_invocation_definition": {"key": "endpointInvocationDefinition", "type": "object"},
    }

    def __init__(self, *, endpoint_invocation_definition: JSON, **kwargs: Any) -> None:
        """
        :keyword endpoint_invocation_definition: [Required] Defines Schedule action definition details.


         .. raw:: html

            <see href="TBD" />. Required.
        :paramtype endpoint_invocation_definition: JSON
        """
        super().__init__(**kwargs)
        self.action_type: str = "InvokeBatchEndpoint"
        self.endpoint_invocation_definition = endpoint_invocation_definition


class EnvironmentContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "EnvironmentContainerProperties"},
    }

    def __init__(self, *, properties: "_models.EnvironmentContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.EnvironmentContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EnvironmentContainerProperties(AssetContainer):
    """Container for environment specification versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the environment container. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class EnvironmentContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of EnvironmentContainer entities.

    :ivar next_link: The link to the next page of EnvironmentContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[EnvironmentContainer]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.EnvironmentContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of EnvironmentContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class EnvironmentVariable(_serialization.Model):
    """Environment Variables for the container.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the Environment Variable. Possible values are: local - For local variable.
     "local"
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
    :ivar value: Value of the Environment variable.
    :vartype value: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Union[str, "_models.EnvironmentVariableType"] = "local",
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the Environment Variable. Possible values are: local - For local
         variable. "local"
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentVariableType
        :keyword value: Value of the Environment variable.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.value = value


class EnvironmentVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "EnvironmentVersionProperties"},
    }

    def __init__(self, *, properties: "_models.EnvironmentVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class EnvironmentVersionProperties(AssetBase):  # pylint: disable=too-many-instance-attributes
    """Environment version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar auto_rebuild: Defines if image needs to be rebuilt based on base image changes. Known
     values are: "Disabled" and "OnBaseImageUpdate".
    :vartype auto_rebuild: str or ~azure.mgmt.machinelearningservices.models.AutoRebuildSetting
    :ivar build: Configuration settings for Docker build context.
    :vartype build: ~azure.mgmt.machinelearningservices.models.BuildContext
    :ivar conda_file: Standard configuration file used by Conda that lets you install any kind of
     package, including Python, R, and C/C++ packages.


     .. raw:: html

        <see
     href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
     />.
    :vartype conda_file: str
    :ivar environment_type: Environment type is either user managed or curated by the Azure ML
     service


     .. raw:: html

        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments"
     />. Known values are: "Curated" and "UserCreated".
    :vartype environment_type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentType
    :ivar image: Name of the image that will be used for the environment.


     .. raw:: html

        <seealso
     href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
     />.
    :vartype image: str
    :ivar inference_config: Defines configuration specific to inference.
    :vartype inference_config:
     ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
    :ivar os_type: The OS type of the environment. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
    :ivar provisioning_state: Provisioning state for the environment version. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Stage in the environment lifecycle assigned to this environment.
    :vartype stage: str
    """

    _validation = {
        "environment_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "auto_rebuild": {"key": "autoRebuild", "type": "str"},
        "build": {"key": "build", "type": "BuildContext"},
        "conda_file": {"key": "condaFile", "type": "str"},
        "environment_type": {"key": "environmentType", "type": "str"},
        "image": {"key": "image", "type": "str"},
        "inference_config": {"key": "inferenceConfig", "type": "InferenceContainerProperties"},
        "os_type": {"key": "osType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        auto_rebuild: Optional[Union[str, "_models.AutoRebuildSetting"]] = None,
        build: Optional["_models.BuildContext"] = None,
        conda_file: Optional[str] = None,
        image: Optional[str] = None,
        inference_config: Optional["_models.InferenceContainerProperties"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemType"]] = None,
        stage: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword auto_rebuild: Defines if image needs to be rebuilt based on base image changes. Known
         values are: "Disabled" and "OnBaseImageUpdate".
        :paramtype auto_rebuild: str or ~azure.mgmt.machinelearningservices.models.AutoRebuildSetting
        :keyword build: Configuration settings for Docker build context.
        :paramtype build: ~azure.mgmt.machinelearningservices.models.BuildContext
        :keyword conda_file: Standard configuration file used by Conda that lets you install any kind
         of package, including Python, R, and C/C++ packages.


         .. raw:: html

            <see
         href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
         />.
        :paramtype conda_file: str
        :keyword image: Name of the image that will be used for the environment.


         .. raw:: html

            <seealso
         href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
         />.
        :paramtype image: str
        :keyword inference_config: Defines configuration specific to inference.
        :paramtype inference_config:
         ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
        :keyword os_type: The OS type of the environment. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
        :keyword stage: Stage in the environment lifecycle assigned to this environment.
        :paramtype stage: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.auto_rebuild = auto_rebuild
        self.build = build
        self.conda_file = conda_file
        self.environment_type = None
        self.image = image
        self.inference_config = inference_config
        self.os_type = os_type
        self.provisioning_state = None
        self.stage = stage


class EnvironmentVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of EnvironmentVersion entities.

    :ivar next_link: The link to the next page of EnvironmentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[EnvironmentVersion]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.EnvironmentVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of EnvironmentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EstimatedVMPrice(_serialization.Model):
    """The estimated price info for using a VM of a particular OS type, tier, etc.

    All required parameters must be populated in order to send to Azure.

    :ivar retail_price: The price charged for using the VM. Required.
    :vartype retail_price: float
    :ivar os_type: Operating system type used by the VM. Required. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
    :ivar vm_tier: The type of the VM. Required. Known values are: "Standard", "LowPriority", and
     "Spot".
    :vartype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
    """

    _validation = {
        "retail_price": {"required": True},
        "os_type": {"required": True},
        "vm_tier": {"required": True},
    }

    _attribute_map = {
        "retail_price": {"key": "retailPrice", "type": "float"},
        "os_type": {"key": "osType", "type": "str"},
        "vm_tier": {"key": "vmTier", "type": "str"},
    }

    def __init__(
        self,
        *,
        retail_price: float,
        os_type: Union[str, "_models.VMPriceOSType"],
        vm_tier: Union[str, "_models.VMTier"],
        **kwargs: Any
    ) -> None:
        """
        :keyword retail_price: The price charged for using the VM. Required.
        :paramtype retail_price: float
        :keyword os_type: Operating system type used by the VM. Required. Known values are: "Linux" and
         "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
        :keyword vm_tier: The type of the VM. Required. Known values are: "Standard", "LowPriority",
         and "Spot".
        :paramtype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
        """
        super().__init__(**kwargs)
        self.retail_price = retail_price
        self.os_type = os_type
        self.vm_tier = vm_tier


class EstimatedVMPrices(_serialization.Model):
    """The estimated price info for using a VM.

    All required parameters must be populated in order to send to Azure.

    :ivar billing_currency: Three lettered code specifying the currency of the VM price. Example:
     USD. Required. "USD"
    :vartype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
    :ivar unit_of_measure: The unit of time measurement for the specified VM price. Example:
     OneHour. Required. "OneHour"
    :vartype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
    :ivar values: The list of estimated prices for using a VM of a particular OS type, tier, etc.
     Required.
    :vartype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
    """

    _validation = {
        "billing_currency": {"required": True},
        "unit_of_measure": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "billing_currency": {"key": "billingCurrency", "type": "str"},
        "unit_of_measure": {"key": "unitOfMeasure", "type": "str"},
        "values": {"key": "values", "type": "[EstimatedVMPrice]"},
    }

    def __init__(
        self,
        *,
        billing_currency: Union[str, "_models.BillingCurrency"],
        unit_of_measure: Union[str, "_models.UnitOfMeasure"],
        values: List["_models.EstimatedVMPrice"],
        **kwargs: Any
    ) -> None:
        """
        :keyword billing_currency: Three lettered code specifying the currency of the VM price.
         Example: USD. Required. "USD"
        :paramtype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
        :keyword unit_of_measure: The unit of time measurement for the specified VM price. Example:
         OneHour. Required. "OneHour"
        :paramtype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
        :keyword values: The list of estimated prices for using a VM of a particular OS type, tier,
         etc. Required.
        :paramtype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
        """
        super().__init__(**kwargs)
        self.billing_currency = billing_currency
        self.unit_of_measure = unit_of_measure
        self.values = values


class ExternalFQDNResponse(_serialization.Model):
    """ExternalFQDNResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FQDNEndpoints]"},
    }

    def __init__(self, *, value: Optional[List["_models.FQDNEndpoints"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
        """
        super().__init__(**kwargs)
        self.value = value


class Feature(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeatureProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FeatureProperties"},
    }

    def __init__(self, *, properties: "_models.FeatureProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeatureProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FeatureAttributionDriftMonitoringSignal(MonitoringSignalBase):
    """FeatureAttributionDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar feature_importance_settings: [Required] The settings for computing feature importance.
     Required.
    :vartype feature_importance_settings:
     ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
    :ivar metric_threshold: [Required] A list of metrics to calculate and their associated
     thresholds. Required.
    :vartype metric_threshold:
     ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetricThreshold
    :ivar production_data: [Required] The data which drift will be calculated for. Required.
    :vartype production_data:
     list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
    :ivar reference_data: [Required] The data to calculate drift against. Required.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        "signal_type": {"required": True},
        "feature_importance_settings": {"required": True},
        "metric_threshold": {"required": True},
        "production_data": {"required": True},
        "reference_data": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
        "feature_data_type_override": {"key": "featureDataTypeOverride", "type": "{str}"},
        "feature_importance_settings": {"key": "featureImportanceSettings", "type": "FeatureImportanceSettings"},
        "metric_threshold": {"key": "metricThreshold", "type": "FeatureAttributionMetricThreshold"},
        "production_data": {"key": "productionData", "type": "[MonitoringInputDataBase]"},
        "reference_data": {"key": "referenceData", "type": "MonitoringInputDataBase"},
    }

    def __init__(
        self,
        *,
        feature_importance_settings: "_models.FeatureImportanceSettings",
        metric_threshold: "_models.FeatureAttributionMetricThreshold",
        production_data: List["_models.MonitoringInputDataBase"],
        reference_data: "_models.MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "_models.MonitoringFeatureDataType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword feature_importance_settings: [Required] The settings for computing feature importance.
         Required.
        :paramtype feature_importance_settings:
         ~azure.mgmt.machinelearningservices.models.FeatureImportanceSettings
        :keyword metric_threshold: [Required] A list of metrics to calculate and their associated
         thresholds. Required.
        :paramtype metric_threshold:
         ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetricThreshold
        :keyword production_data: [Required] The data which drift will be calculated for. Required.
        :paramtype production_data:
         list[~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase]
        :keyword reference_data: [Required] The data to calculate drift against. Required.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super().__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type: str = "FeatureAttributionDrift"
        self.feature_data_type_override = feature_data_type_override
        self.feature_importance_settings = feature_importance_settings
        self.metric_threshold = metric_threshold
        self.production_data = production_data
        self.reference_data = reference_data


class FeatureAttributionMetricThreshold(_serialization.Model):
    """FeatureAttributionMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar metric: [Required] The feature attribution metric to calculate. Required.
     "NormalizedDiscountedCumulativeGain"
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetric
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    """

    _validation = {
        "metric": {"required": True},
    }

    _attribute_map = {
        "metric": {"key": "metric", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.FeatureAttributionMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric: [Required] The feature attribution metric to calculate. Required.
         "NormalizedDiscountedCumulativeGain"
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.FeatureAttributionMetric
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        """
        super().__init__(**kwargs)
        self.metric = metric
        self.threshold = threshold


class FeatureImportanceSettings(_serialization.Model):
    """FeatureImportanceSettings.

    :ivar mode: The mode of operation for computing feature importance. Known values are:
     "Disabled" and "Enabled".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.FeatureImportanceMode
    :ivar target_column: The name of the target column within the input data asset.
    :vartype target_column: str
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "target_column": {"key": "targetColumn", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.FeatureImportanceMode"]] = None,
        target_column: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: The mode of operation for computing feature importance. Known values are:
         "Disabled" and "Enabled".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.FeatureImportanceMode
        :keyword target_column: The name of the target column within the input data asset.
        :paramtype target_column: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.target_column = target_column


class FeatureProperties(ResourceBase):
    """DTO object representing feature.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar data_type: Specifies type. Known values are: "String", "Integer", "Long", "Float",
     "Double", "Binary", "Datetime", and "Boolean".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
    :ivar feature_name: Specifies name.
    :vartype feature_name: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "data_type": {"key": "dataType", "type": "str"},
        "feature_name": {"key": "featureName", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        data_type: Optional[Union[str, "_models.FeatureDataType"]] = None,
        feature_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword data_type: Specifies type. Known values are: "String", "Integer", "Long", "Float",
         "Double", "Binary", "Datetime", and "Boolean".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
        :keyword feature_name: Specifies name.
        :paramtype feature_name: str
        """
        super().__init__(description=description, properties=properties, tags=tags, **kwargs)
        self.data_type = data_type
        self.feature_name = feature_name


class FeatureResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of Feature entities.

    :ivar next_link: The link to the next page of Feature objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Feature.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Feature]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Feature]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Feature"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of Feature objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Feature.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Feature]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturesetContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FeaturesetContainerProperties"},
    }

    def __init__(self, *, properties: "_models.FeaturesetContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FeaturesetContainerProperties(AssetContainer):
    """DTO object representing feature set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the featureset container. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class FeaturesetContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of FeaturesetContainer entities.

    :ivar next_link: The link to the next page of FeaturesetContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturesetContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[FeaturesetContainer]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.FeaturesetContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of FeaturesetContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturesetContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturesetSpecification(_serialization.Model):
    """DTO object representing specification.

    :ivar path: Specifies the spec path.
    :vartype path: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the spec path.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.path = path


class FeaturesetVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FeaturesetVersionProperties"},
    }

    def __init__(self, *, properties: "_models.FeaturesetVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FeaturesetVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FeaturesetVersionBackfillRequest(_serialization.Model):
    """Request payload for creating a backfill request for a given feature set version.

    :ivar data_availability_status: Specified the data availability status that you want to
     backfill.
    :vartype data_availability_status: list[str or
     ~azure.mgmt.machinelearningservices.models.DataAvailabilityStatus]
    :ivar description: Specifies description.
    :vartype description: str
    :ivar display_name: Specifies description.
    :vartype display_name: str
    :ivar feature_window: Specifies the backfill feature window to be materialized.
    :vartype feature_window: ~azure.mgmt.machinelearningservices.models.FeatureWindow
    :ivar job_id: Specify the jobId to retry the failed materialization.
    :vartype job_id: str
    :ivar properties: Specifies the properties.
    :vartype properties: dict[str, str]
    :ivar resource: Specifies the compute resource settings.
    :vartype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
    :ivar spark_configuration: Specifies the spark compute settings.
    :vartype spark_configuration: dict[str, str]
    :ivar tags: Specifies the tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "data_availability_status": {"key": "dataAvailabilityStatus", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "feature_window": {"key": "featureWindow", "type": "FeatureWindow"},
        "job_id": {"key": "jobId", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "resource": {"key": "resource", "type": "MaterializationComputeResource"},
        "spark_configuration": {"key": "sparkConfiguration", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        data_availability_status: Optional[List[Union[str, "_models.DataAvailabilityStatus"]]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        feature_window: Optional["_models.FeatureWindow"] = None,
        job_id: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        resource: Optional["_models.MaterializationComputeResource"] = None,
        spark_configuration: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_availability_status: Specified the data availability status that you want to
         backfill.
        :paramtype data_availability_status: list[str or
         ~azure.mgmt.machinelearningservices.models.DataAvailabilityStatus]
        :keyword description: Specifies description.
        :paramtype description: str
        :keyword display_name: Specifies description.
        :paramtype display_name: str
        :keyword feature_window: Specifies the backfill feature window to be materialized.
        :paramtype feature_window: ~azure.mgmt.machinelearningservices.models.FeatureWindow
        :keyword job_id: Specify the jobId to retry the failed materialization.
        :paramtype job_id: str
        :keyword properties: Specifies the properties.
        :paramtype properties: dict[str, str]
        :keyword resource: Specifies the compute resource settings.
        :paramtype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
        :keyword spark_configuration: Specifies the spark compute settings.
        :paramtype spark_configuration: dict[str, str]
        :keyword tags: Specifies the tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.data_availability_status = data_availability_status
        self.description = description
        self.display_name = display_name
        self.feature_window = feature_window
        self.job_id = job_id
        self.properties = properties
        self.resource = resource
        self.spark_configuration = spark_configuration
        self.tags = tags


class FeaturesetVersionBackfillResponse(_serialization.Model):
    """Response payload for creating a backfill request for a given feature set version.

    :ivar job_ids: List of jobs submitted as part of the backfill request.
    :vartype job_ids: list[str]
    """

    _attribute_map = {
        "job_ids": {"key": "jobIds", "type": "[str]"},
    }

    def __init__(self, *, job_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword job_ids: List of jobs submitted as part of the backfill request.
        :paramtype job_ids: list[str]
        """
        super().__init__(**kwargs)
        self.job_ids = job_ids


class FeaturesetVersionProperties(AssetBase):
    """DTO object representing feature set version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar entities: Specifies list of entities.
    :vartype entities: list[str]
    :ivar materialization_settings: Specifies the materialization settings.
    :vartype materialization_settings:
     ~azure.mgmt.machinelearningservices.models.MaterializationSettings
    :ivar provisioning_state: Provisioning state for the featureset version container. Known values
     are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar specification: Specifies the feature spec details.
    :vartype specification: ~azure.mgmt.machinelearningservices.models.FeaturesetSpecification
    :ivar stage: Specifies the asset stage.
    :vartype stage: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "entities": {"key": "entities", "type": "[str]"},
        "materialization_settings": {"key": "materializationSettings", "type": "MaterializationSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "specification": {"key": "specification", "type": "FeaturesetSpecification"},
        "stage": {"key": "stage", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        entities: Optional[List[str]] = None,
        materialization_settings: Optional["_models.MaterializationSettings"] = None,
        specification: Optional["_models.FeaturesetSpecification"] = None,
        stage: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword entities: Specifies list of entities.
        :paramtype entities: list[str]
        :keyword materialization_settings: Specifies the materialization settings.
        :paramtype materialization_settings:
         ~azure.mgmt.machinelearningservices.models.MaterializationSettings
        :keyword specification: Specifies the feature spec details.
        :paramtype specification: ~azure.mgmt.machinelearningservices.models.FeaturesetSpecification
        :keyword stage: Specifies the asset stage.
        :paramtype stage: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.entities = entities
        self.materialization_settings = materialization_settings
        self.provisioning_state = None
        self.specification = specification
        self.stage = stage


class FeaturesetVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of FeaturesetVersion entities.

    :ivar next_link: The link to the next page of FeaturesetVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturesetVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[FeaturesetVersion]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.FeaturesetVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of FeaturesetVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturesetVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturesetVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturestoreEntityContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FeaturestoreEntityContainerProperties"},
    }

    def __init__(self, *, properties: "_models.FeaturestoreEntityContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FeaturestoreEntityContainerProperties(AssetContainer):
    """DTO object representing feature entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the featurestore entity container. Known
     values are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class FeaturestoreEntityContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of FeaturestoreEntityContainer entities.

    :ivar next_link: The link to the next page of FeaturestoreEntityContainer objects. If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturestoreEntityContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[FeaturestoreEntityContainer]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.FeaturestoreEntityContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of FeaturestoreEntityContainer objects. If null,
         there are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturestoreEntityContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeaturestoreEntityVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties:
     ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FeaturestoreEntityVersionProperties"},
    }

    def __init__(self, *, properties: "_models.FeaturestoreEntityVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FeaturestoreEntityVersionProperties(AssetBase):
    """DTO object representing feature entity version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar index_columns: Specifies index columns.
    :vartype index_columns: list[~azure.mgmt.machinelearningservices.models.IndexColumn]
    :ivar provisioning_state: Provisioning state for the featurestore entity version. Known values
     are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Specifies the asset stage.
    :vartype stage: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "index_columns": {"key": "indexColumns", "type": "[IndexColumn]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        index_columns: Optional[List["_models.IndexColumn"]] = None,
        stage: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword index_columns: Specifies index columns.
        :paramtype index_columns: list[~azure.mgmt.machinelearningservices.models.IndexColumn]
        :keyword stage: Specifies the asset stage.
        :paramtype stage: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.index_columns = index_columns
        self.provisioning_state = None
        self.stage = stage


class FeaturestoreEntityVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of FeaturestoreEntityVersion entities.

    :ivar next_link: The link to the next page of FeaturestoreEntityVersion objects. If null, there
     are no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type FeaturestoreEntityVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[FeaturestoreEntityVersion]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.FeaturestoreEntityVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of FeaturestoreEntityVersion objects. If null,
         there are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type FeaturestoreEntityVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FeaturestoreEntityVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class FeatureSubset(MonitoringFeatureFilterBase):
    """FeatureSubset.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_type: [Required] Specifies the feature filter to leverage when selecting features
     to calculate metrics over. Required. Known values are: "AllFeatures", "TopNByAttribution", and
     "FeatureSubset".
    :vartype filter_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureFilterType
    :ivar features: [Required] The list of features to include. Required.
    :vartype features: list[str]
    """

    _validation = {
        "filter_type": {"required": True},
        "features": {"required": True},
    }

    _attribute_map = {
        "filter_type": {"key": "filterType", "type": "str"},
        "features": {"key": "features", "type": "[str]"},
    }

    def __init__(self, *, features: List[str], **kwargs: Any) -> None:
        """
        :keyword features: [Required] The list of features to include. Required.
        :paramtype features: list[str]
        """
        super().__init__(**kwargs)
        self.filter_type: str = "FeatureSubset"
        self.features = features


class FeatureWindow(_serialization.Model):
    """Specifies the feature window.

    :ivar feature_window_end: Specifies the feature window end time.
    :vartype feature_window_end: ~datetime.datetime
    :ivar feature_window_start: Specifies the feature window start time.
    :vartype feature_window_start: ~datetime.datetime
    """

    _attribute_map = {
        "feature_window_end": {"key": "featureWindowEnd", "type": "iso-8601"},
        "feature_window_start": {"key": "featureWindowStart", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        feature_window_end: Optional[datetime.datetime] = None,
        feature_window_start: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword feature_window_end: Specifies the feature window end time.
        :paramtype feature_window_end: ~datetime.datetime
        :keyword feature_window_start: Specifies the feature window start time.
        :paramtype feature_window_start: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.feature_window_end = feature_window_end
        self.feature_window_start = feature_window_start


class FeaturizationSettings(_serialization.Model):
    """Featurization Configuration.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        "dataset_language": {"key": "datasetLanguage", "type": "str"},
    }

    def __init__(self, *, dataset_language: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super().__init__(**kwargs)
        self.dataset_language = dataset_language


class MonitoringInputDataBase(_serialization.Model):
    """Monitoring input data base definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FixedInputData, RollingInputData, StaticInputData

    All required parameters must be populated in order to send to Azure.

    :ivar columns: Mapping of column names to special uses.
    :vartype columns: dict[str, str]
    :ivar data_context: The context metadata of the data source.
    :vartype data_context: str
    :ivar input_data_type: [Required] Specifies the type of signal to monitor. Required. Known
     values are: "Static", "Rolling", and "Fixed".
    :vartype input_data_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataType
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "input_data_type": {"required": True},
        "job_input_type": {"required": True},
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "columns": {"key": "columns", "type": "{str}"},
        "data_context": {"key": "dataContext", "type": "str"},
        "input_data_type": {"key": "inputDataType", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    _subtype_map = {
        "input_data_type": {"Fixed": "FixedInputData", "Rolling": "RollingInputData", "Static": "StaticInputData"}
    }

    def __init__(
        self,
        *,
        job_input_type: Union[str, "_models.JobInputType"],
        uri: str,
        columns: Optional[Dict[str, str]] = None,
        data_context: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword columns: Mapping of column names to special uses.
        :paramtype columns: dict[str, str]
        :keyword data_context: The context metadata of the data source.
        :paramtype data_context: str
        :keyword job_input_type: [Required] Specifies the type of job. Required. Known values are:
         "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
         "triton_model".
        :paramtype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.columns = columns
        self.data_context = data_context
        self.input_data_type: Optional[str] = None
        self.job_input_type = job_input_type
        self.uri = uri


class FixedInputData(MonitoringInputDataBase):
    """Fixed input data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar columns: Mapping of column names to special uses.
    :vartype columns: dict[str, str]
    :ivar data_context: The context metadata of the data source.
    :vartype data_context: str
    :ivar input_data_type: [Required] Specifies the type of signal to monitor. Required. Known
     values are: "Static", "Rolling", and "Fixed".
    :vartype input_data_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitoringInputDataType
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "input_data_type": {"required": True},
        "job_input_type": {"required": True},
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "columns": {"key": "columns", "type": "{str}"},
        "data_context": {"key": "dataContext", "type": "str"},
        "input_data_type": {"key": "inputDataType", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_input_type: Union[str, "_models.JobInputType"],
        uri: str,
        columns: Optional[Dict[str, str]] = None,
        data_context: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword columns: Mapping of column names to special uses.
        :paramtype columns: dict[str, str]
        :keyword data_context: The context metadata of the data source.
        :paramtype data_context: str
        :keyword job_input_type: [Required] Specifies the type of job. Required. Known values are:
         "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
         "triton_model".
        :paramtype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(columns=columns, data_context=data_context, job_input_type=job_input_type, uri=uri, **kwargs)
        self.input_data_type: str = "Fixed"


class FlavorData(_serialization.Model):
    """FlavorData.

    :ivar data: Model flavor-specific data.
    :vartype data: dict[str, str]
    """

    _attribute_map = {
        "data": {"key": "data", "type": "{str}"},
    }

    def __init__(self, *, data: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword data: Model flavor-specific data.
        :paramtype data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.data = data


class Forecasting(TableVertical, AutoMLVertical):  # pylint: disable=too-many-instance-attributes
    """Forecasting task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar forecasting_settings: Forecasting task specific inputs.
    :vartype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
    :ivar primary_metric: Primary metric for forecasting task. Known values are:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score", and
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "cv_split_column_names": {"key": "cvSplitColumnNames", "type": "[str]"},
        "featurization_settings": {"key": "featurizationSettings", "type": "TableVerticalFeaturizationSettings"},
        "limit_settings": {"key": "limitSettings", "type": "TableVerticalLimitSettings"},
        "n_cross_validations": {"key": "nCrossValidations", "type": "NCrossValidations"},
        "test_data": {"key": "testData", "type": "MLTableJobInput"},
        "test_data_size": {"key": "testDataSize", "type": "float"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "weight_column_name": {"key": "weightColumnName", "type": "str"},
        "forecasting_settings": {"key": "forecastingSettings", "type": "ForecastingSettings"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
        "training_settings": {"key": "trainingSettings", "type": "ForecastingTrainingSettings"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["_models.TableVerticalFeaturizationSettings"] = None,
        limit_settings: Optional["_models.TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["_models.NCrossValidations"] = None,
        test_data: Optional["_models.MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        forecasting_settings: Optional["_models.ForecastingSettings"] = None,
        primary_metric: Optional[Union[str, "_models.ForecastingPrimaryMetrics"]] = None,
        training_settings: Optional["_models.ForecastingTrainingSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword forecasting_settings: Forecasting task specific inputs.
        :paramtype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
        :keyword primary_metric: Primary metric for forecasting task. Known values are:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score", and
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.ForecastingTrainingSettings
        """
        super().__init__(
            cv_split_column_names=cv_split_column_names,
            featurization_settings=featurization_settings,
            limit_settings=limit_settings,
            n_cross_validations=n_cross_validations,
            test_data=test_data,
            test_data_size=test_data_size,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            weight_column_name=weight_column_name,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "Forecasting"
        self.training_data = training_data
        self.forecasting_settings = forecasting_settings
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class ForecastingSettings(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Forecasting specific parameters.

    :ivar country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
     These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
    :vartype country_or_region_for_holidays: str
    :ivar cv_step_size: Number of periods between the origin time of one CV fold and the next fold.
     For
     example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
     three days apart.
    :vartype cv_step_size: int
    :ivar feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
     Known values are: "None" and "Auto".
    :vartype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
    :ivar forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
    :vartype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
    :ivar frequency: When forecasting, this parameter represents the period with which the forecast
     is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency
     by default.
    :vartype frequency: str
    :ivar seasonality: Set time series seasonality as an integer multiple of the series frequency.
     If seasonality is set to 'auto', it will be inferred.
    :vartype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
    :ivar short_series_handling_config: The parameter defining how if AutoML should handle short
     time series. Known values are: "None", "Auto", "Pad", and "Drop".
    :vartype short_series_handling_config: str or
     ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
    :ivar target_aggregate_function: The function to be used to aggregate the time series target
     column to conform to a user specified frequency.
     If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
     error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     Known values are: "None", "Sum", "Max", "Min", and "Mean".
    :vartype target_aggregate_function: str or
     ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
    :ivar target_lags: The number of past periods to lag from the target column.
    :vartype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
    :ivar target_rolling_window_size: The number of past periods used to create a rolling window
     average of the target column.
    :vartype target_rolling_window_size:
     ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
    :ivar time_column_name: The name of the time column. This parameter is required when
     forecasting to specify the datetime column in the input data used for building the time series
     and inferring its frequency.
    :vartype time_column_name: str
    :ivar time_series_id_column_names: The names of columns used to group a timeseries. It can be
     used to create multiple series.
     If grain is not defined, the data set is assumed to be one time-series. This parameter is used
     with task type forecasting.
    :vartype time_series_id_column_names: list[str]
    :ivar use_stl: Configure STL Decomposition of the time-series target column. Known values are:
     "None", "Season", and "SeasonTrend".
    :vartype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
    """

    _attribute_map = {
        "country_or_region_for_holidays": {"key": "countryOrRegionForHolidays", "type": "str"},
        "cv_step_size": {"key": "cvStepSize", "type": "int"},
        "feature_lags": {"key": "featureLags", "type": "str"},
        "forecast_horizon": {"key": "forecastHorizon", "type": "ForecastHorizon"},
        "frequency": {"key": "frequency", "type": "str"},
        "seasonality": {"key": "seasonality", "type": "Seasonality"},
        "short_series_handling_config": {"key": "shortSeriesHandlingConfig", "type": "str"},
        "target_aggregate_function": {"key": "targetAggregateFunction", "type": "str"},
        "target_lags": {"key": "targetLags", "type": "TargetLags"},
        "target_rolling_window_size": {"key": "targetRollingWindowSize", "type": "TargetRollingWindowSize"},
        "time_column_name": {"key": "timeColumnName", "type": "str"},
        "time_series_id_column_names": {"key": "timeSeriesIdColumnNames", "type": "[str]"},
        "use_stl": {"key": "useStl", "type": "str"},
    }

    def __init__(
        self,
        *,
        country_or_region_for_holidays: Optional[str] = None,
        cv_step_size: Optional[int] = None,
        feature_lags: Optional[Union[str, "_models.FeatureLags"]] = None,
        forecast_horizon: Optional["_models.ForecastHorizon"] = None,
        frequency: Optional[str] = None,
        seasonality: Optional["_models.Seasonality"] = None,
        short_series_handling_config: Optional[Union[str, "_models.ShortSeriesHandlingConfiguration"]] = None,
        target_aggregate_function: Optional[Union[str, "_models.TargetAggregationFunction"]] = None,
        target_lags: Optional["_models.TargetLags"] = None,
        target_rolling_window_size: Optional["_models.TargetRollingWindowSize"] = None,
        time_column_name: Optional[str] = None,
        time_series_id_column_names: Optional[List[str]] = None,
        use_stl: Optional[Union[str, "_models.UseStl"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
         These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :paramtype country_or_region_for_holidays: str
        :keyword cv_step_size: Number of periods between the origin time of one CV fold and the next
         fold. For
         example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
         three days apart.
        :paramtype cv_step_size: int
        :keyword feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
         Known values are: "None" and "Auto".
        :paramtype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
        :keyword forecast_horizon: The desired maximum forecast horizon in units of time-series
         frequency.
        :paramtype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
        :keyword frequency: When forecasting, this parameter represents the period with which the
         forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset
         frequency by default.
        :paramtype frequency: str
        :keyword seasonality: Set time series seasonality as an integer multiple of the series
         frequency.
         If seasonality is set to 'auto', it will be inferred.
        :paramtype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
        :keyword short_series_handling_config: The parameter defining how if AutoML should handle short
         time series. Known values are: "None", "Auto", "Pad", and "Drop".
        :paramtype short_series_handling_config: str or
         ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
        :keyword target_aggregate_function: The function to be used to aggregate the time series target
         column to conform to a user specified frequency.
         If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
         error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
         Known values are: "None", "Sum", "Max", "Min", and "Mean".
        :paramtype target_aggregate_function: str or
         ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
        :keyword target_lags: The number of past periods to lag from the target column.
        :paramtype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
        :keyword target_rolling_window_size: The number of past periods used to create a rolling window
         average of the target column.
        :paramtype target_rolling_window_size:
         ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
        :keyword time_column_name: The name of the time column. This parameter is required when
         forecasting to specify the datetime column in the input data used for building the time series
         and inferring its frequency.
        :paramtype time_column_name: str
        :keyword time_series_id_column_names: The names of columns used to group a timeseries. It can
         be used to create multiple series.
         If grain is not defined, the data set is assumed to be one time-series. This parameter is used
         with task type forecasting.
        :paramtype time_series_id_column_names: list[str]
        :keyword use_stl: Configure STL Decomposition of the time-series target column. Known values
         are: "None", "Season", and "SeasonTrend".
        :paramtype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
        """
        super().__init__(**kwargs)
        self.country_or_region_for_holidays = country_or_region_for_holidays
        self.cv_step_size = cv_step_size
        self.feature_lags = feature_lags
        self.forecast_horizon = forecast_horizon
        self.frequency = frequency
        self.seasonality = seasonality
        self.short_series_handling_config = short_series_handling_config
        self.target_aggregate_function = target_aggregate_function
        self.target_lags = target_lags
        self.target_rolling_window_size = target_rolling_window_size
        self.time_column_name = time_column_name
        self.time_series_id_column_names = time_series_id_column_names
        self.use_stl = use_stl


class ForecastingTrainingSettings(TrainingSettings):
    """Forecasting Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for forecasting task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    :ivar blocked_training_algorithms: Blocked models for forecasting task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    """

    _attribute_map = {
        "enable_dnn_training": {"key": "enableDnnTraining", "type": "bool"},
        "enable_model_explainability": {"key": "enableModelExplainability", "type": "bool"},
        "enable_onnx_compatible_models": {"key": "enableOnnxCompatibleModels", "type": "bool"},
        "enable_stack_ensemble": {"key": "enableStackEnsemble", "type": "bool"},
        "enable_vote_ensemble": {"key": "enableVoteEnsemble", "type": "bool"},
        "ensemble_model_download_timeout": {"key": "ensembleModelDownloadTimeout", "type": "duration"},
        "stack_ensemble_settings": {"key": "stackEnsembleSettings", "type": "StackEnsembleSettings"},
        "allowed_training_algorithms": {"key": "allowedTrainingAlgorithms", "type": "[str]"},
        "blocked_training_algorithms": {"key": "blockedTrainingAlgorithms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: bool = False,
        enable_model_explainability: bool = True,
        enable_onnx_compatible_models: bool = False,
        enable_stack_ensemble: bool = True,
        enable_vote_ensemble: bool = True,
        ensemble_model_download_timeout: datetime.timedelta = "PT5M",
        stack_ensemble_settings: Optional["_models.StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "_models.ForecastingModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "_models.ForecastingModels"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        :keyword allowed_training_algorithms: Allowed models for forecasting task.
        :paramtype allowed_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        :keyword blocked_training_algorithms: Blocked models for forecasting task.
        :paramtype blocked_training_algorithms: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        """
        super().__init__(
            enable_dnn_training=enable_dnn_training,
            enable_model_explainability=enable_model_explainability,
            enable_onnx_compatible_models=enable_onnx_compatible_models,
            enable_stack_ensemble=enable_stack_ensemble,
            enable_vote_ensemble=enable_vote_ensemble,
            ensemble_model_download_timeout=ensemble_model_download_timeout,
            stack_ensemble_settings=stack_ensemble_settings,
            **kwargs
        )
        self.allowed_training_algorithms = allowed_training_algorithms
        self.blocked_training_algorithms = blocked_training_algorithms


class FQDNEndpoint(_serialization.Model):
    """FQDNEndpoint.

    :ivar domain_name:
    :vartype domain_name: str
    :ivar endpoint_details:
    :vartype endpoint_details: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[FQDNEndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.FQDNEndpointDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name:
        :paramtype domain_name: str
        :keyword endpoint_details:
        :paramtype endpoint_details:
         list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class FQDNEndpointDetail(_serialization.Model):
    """FQDNEndpointDetail.

    :ivar port:
    :vartype port: int
    """

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword port:
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.port = port


class FQDNEndpoints(_serialization.Model):
    """FQDNEndpoints.

    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "FQDNEndpointsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.FQDNEndpointsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FQDNEndpointsProperties(_serialization.Model):
    """FQDNEndpointsProperties.

    :ivar category:
    :vartype category: str
    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[FQDNEndpoint]"},
    }

    def __init__(
        self, *, category: Optional[str] = None, endpoints: Optional[List["_models.FQDNEndpoint"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword category:
        :paramtype category: str
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundRule(_serialization.Model):
    """Outbound Rule for the managed network of a machine learning workspace.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FqdnOutboundRule, PrivateEndpointOutboundRule, ServiceTagOutboundRule

    All required parameters must be populated in order to send to Azure.

    :ivar category: Category of a managed network Outbound Rule of a machine learning workspace.
     Known values are: "Required", "Recommended", and "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Type of a managed network Outbound Rule of a machine learning workspace. Known
     values are: "Inactive" and "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Type of a managed network Outbound Rule of a machine learning workspace. Required.
     Known values are: "FQDN", "PrivateEndpoint", and "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "FQDN": "FqdnOutboundRule",
            "PrivateEndpoint": "PrivateEndpointOutboundRule",
            "ServiceTag": "ServiceTagOutboundRule",
        }
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.RuleCategory"]] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of a managed network Outbound Rule of a machine learning workspace.
         Known values are: "Required", "Recommended", and "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Type of a managed network Outbound Rule of a machine learning workspace. Known
         values are: "Inactive" and "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        """
        super().__init__(**kwargs)
        self.category = category
        self.status = status
        self.type: Optional[str] = None


class FqdnOutboundRule(OutboundRule):
    """FQDN Outbound Rule for the managed network of a machine learning workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Category of a managed network Outbound Rule of a machine learning workspace.
     Known values are: "Required", "Recommended", and "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Type of a managed network Outbound Rule of a machine learning workspace. Known
     values are: "Inactive" and "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Type of a managed network Outbound Rule of a machine learning workspace. Required.
     Known values are: "FQDN", "PrivateEndpoint", and "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination:
    :vartype destination: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "destination": {"key": "destination", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.RuleCategory"]] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        destination: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of a managed network Outbound Rule of a machine learning workspace.
         Known values are: "Required", "Recommended", and "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Type of a managed network Outbound Rule of a machine learning workspace. Known
         values are: "Inactive" and "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination:
        :paramtype destination: str
        """
        super().__init__(category=category, status=status, **kwargs)
        self.type: str = "FQDN"
        self.destination = destination


class GetBlobReferenceForConsumptionDto(_serialization.Model):
    """GetBlobReferenceForConsumptionDto.

    :ivar blob_uri: Blob uri, example: https://blob.windows.core.net/Container/Path.
    :vartype blob_uri: str
    :ivar credential: Credential info to access storage account.
    :vartype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredential
    :ivar storage_account_arm_id: The ARM id of the storage account.
    :vartype storage_account_arm_id: str
    """

    _attribute_map = {
        "blob_uri": {"key": "blobUri", "type": "str"},
        "credential": {"key": "credential", "type": "DataReferenceCredential"},
        "storage_account_arm_id": {"key": "storageAccountArmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_uri: Optional[str] = None,
        credential: Optional["_models.DataReferenceCredential"] = None,
        storage_account_arm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_uri: Blob uri, example: https://blob.windows.core.net/Container/Path.
        :paramtype blob_uri: str
        :keyword credential: Credential info to access storage account.
        :paramtype credential: ~azure.mgmt.machinelearningservices.models.DataReferenceCredential
        :keyword storage_account_arm_id: The ARM id of the storage account.
        :paramtype storage_account_arm_id: str
        """
        super().__init__(**kwargs)
        self.blob_uri = blob_uri
        self.credential = credential
        self.storage_account_arm_id = storage_account_arm_id


class GetBlobReferenceSASRequestDto(_serialization.Model):
    """BlobReferenceSASRequest for getBlobReferenceSAS API.

    :ivar asset_id: Id of the asset to be accessed.
    :vartype asset_id: str
    :ivar blob_uri: Blob uri of the asset to be accessed.
    :vartype blob_uri: str
    """

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "blob_uri": {"key": "blobUri", "type": "str"},
    }

    def __init__(self, *, asset_id: Optional[str] = None, blob_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword asset_id: Id of the asset to be accessed.
        :paramtype asset_id: str
        :keyword blob_uri: Blob uri of the asset to be accessed.
        :paramtype blob_uri: str
        """
        super().__init__(**kwargs)
        self.asset_id = asset_id
        self.blob_uri = blob_uri


class GetBlobReferenceSASResponseDto(_serialization.Model):
    """BlobReferenceSASResponse for getBlobReferenceSAS API.

    :ivar blob_reference_for_consumption: Blob reference for consumption details.
    :vartype blob_reference_for_consumption:
     ~azure.mgmt.machinelearningservices.models.GetBlobReferenceForConsumptionDto
    """

    _attribute_map = {
        "blob_reference_for_consumption": {
            "key": "blobReferenceForConsumption",
            "type": "GetBlobReferenceForConsumptionDto",
        },
    }

    def __init__(
        self,
        *,
        blob_reference_for_consumption: Optional["_models.GetBlobReferenceForConsumptionDto"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_reference_for_consumption: Blob reference for consumption details.
        :paramtype blob_reference_for_consumption:
         ~azure.mgmt.machinelearningservices.models.GetBlobReferenceForConsumptionDto
        """
        super().__init__(**kwargs)
        self.blob_reference_for_consumption = blob_reference_for_consumption


class GridSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that exhaustively generates every value combination in the space.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: [Required] The algorithm used for generating hyperparameter
     values, along with configuration properties. Required. Known values are: "Grid", "Random", and
     "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        "sampling_algorithm_type": {"required": True},
    }

    _attribute_map = {
        "sampling_algorithm_type": {"key": "samplingAlgorithmType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sampling_algorithm_type: str = "Grid"


class HDInsightSchema(_serialization.Model):
    """HDInsightSchema.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "HDInsightProperties"},
    }

    def __init__(self, *, properties: Optional["_models.HDInsightProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class HDInsight(Compute, HDInsightSchema):  # pylint: disable=too-many-instance-attributes
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "HDInsightProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.HDInsightProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "HDInsight"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class HDInsightProperties(_serialization.Model):
    """HDInsight compute properties.

    :ivar ssh_port: Port open for ssh connections on the master node of the cluster.
    :vartype ssh_port: int
    :ivar address: Public IP address of the master node of the cluster.
    :vartype address: str
    :ivar administrator_account: Admin credentials for master node of the cluster.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        "ssh_port": {"key": "sshPort", "type": "int"},
        "address": {"key": "address", "type": "str"},
        "administrator_account": {"key": "administratorAccount", "type": "VirtualMachineSshCredentials"},
    }

    def __init__(
        self,
        *,
        ssh_port: Optional[int] = None,
        address: Optional[str] = None,
        administrator_account: Optional["_models.VirtualMachineSshCredentials"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ssh_port: Port open for ssh connections on the master node of the cluster.
        :paramtype ssh_port: int
        :keyword address: Public IP address of the master node of the cluster.
        :paramtype address: str
        :keyword administrator_account: Admin credentials for master node of the cluster.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        """
        super().__init__(**kwargs)
        self.ssh_port = ssh_port
        self.address = address
        self.administrator_account = administrator_account


class IdAssetReference(AssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: [Required] Specifies the type of asset reference. Required. Known values
     are: "Id", "DataPath", and "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: [Required] ARM resource ID of the asset. Required.
    :vartype asset_id: str
    """

    _validation = {
        "reference_type": {"required": True},
        "asset_id": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "reference_type": {"key": "referenceType", "type": "str"},
        "asset_id": {"key": "assetId", "type": "str"},
    }

    def __init__(self, *, asset_id: str, **kwargs: Any) -> None:
        """
        :keyword asset_id: [Required] ARM resource ID of the asset. Required.
        :paramtype asset_id: str
        """
        super().__init__(**kwargs)
        self.reference_type: str = "Id"
        self.asset_id = asset_id


class IdentityForCmk(_serialization.Model):
    """Identity that will be used to access key vault for encryption at rest.

    :ivar user_assigned_identity: The ArmId of the user assigned identity that will be used to
     access the customer managed key vault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(self, *, user_assigned_identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_assigned_identity: The ArmId of the user assigned identity that will be used to
         access the customer managed key vault.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class IdleShutdownSetting(_serialization.Model):
    """Stops compute instance after user defined period of inactivity.

    :ivar idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min, maximum
     is 3 days.
    :vartype idle_time_before_shutdown: str
    """

    _attribute_map = {
        "idle_time_before_shutdown": {"key": "idleTimeBeforeShutdown", "type": "str"},
    }

    def __init__(self, *, idle_time_before_shutdown: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword idle_time_before_shutdown: Time is defined in ISO8601 format. Minimum is 15 min,
         maximum is 3 days.
        :paramtype idle_time_before_shutdown: str
        """
        super().__init__(**kwargs)
        self.idle_time_before_shutdown = idle_time_before_shutdown


class Image(_serialization.Model):
    """Describes the Image Specifications.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar type: Type of the image. Possible values are: docker - For docker images. azureml - For
     AzureML images. Known values are: "docker" and "azureml".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
    :ivar reference: Image reference.
    :vartype reference: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "reference": {"key": "reference", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        type: Union[str, "_models.ImageType"] = "docker",
        reference: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword type: Type of the image. Possible values are: docker - For docker images. azureml -
         For AzureML images. Known values are: "docker" and "azureml".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ImageType
        :keyword reference: Image reference.
        :paramtype reference: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.reference = reference


class ImageVertical(_serialization.Model):
    """Abstract class for AutoML tasks that train image (computer vision) models -
    such as Image Classification / Image Classification Multilabel / Image Object Detection / Image
    Instance Segmentation.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _validation = {
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
    }

    def __init__(
        self,
        *,
        limit_settings: "_models.ImageLimitSettings",
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super().__init__(**kwargs)
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size


class ImageClassificationBase(ImageVertical):
    """ImageClassificationBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    """

    _validation = {
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsClassification"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsClassification]"},
    }

    def __init__(
        self,
        *,
        limit_settings: "_models.ImageLimitSettings",
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsClassification"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsClassification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            **kwargs
        )
        self.model_settings = model_settings
        self.search_space = search_space


class ImageClassification(ImageClassificationBase, AutoMLVertical):  # pylint: disable=too-many-instance-attributes
    """Image Classification. Multi-class image classification is used when an image is classified with
    only a single label
    from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog'
    or a 'duck'.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar primary_metric: Primary metric to optimize for this task. Known values are:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", and
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsClassification"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsClassification]"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        limit_settings: "_models.ImageLimitSettings",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsClassification"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsClassification"]] = None,
        primary_metric: Optional[Union[str, "_models.ClassificationPrimaryMetrics"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword primary_metric: Primary metric to optimize for this task. Known values are:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", and
         "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            model_settings=model_settings,
            search_space=search_space,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "ImageClassification"
        self.training_data = training_data
        self.primary_metric = primary_metric
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space


class ImageClassificationMultilabel(
    ImageClassificationBase, AutoMLVertical
):  # pylint: disable=too-many-instance-attributes
    """Image Classification Multilabel. Multi-label image classification is used when an image could
    have one or more labels
    from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar primary_metric: Primary metric to optimize for this task. Known values are:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted", and "IOU".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsClassification"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsClassification]"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        limit_settings: "_models.ImageLimitSettings",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsClassification"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsClassification"]] = None,
        primary_metric: Optional[Union[str, "_models.ClassificationMultilabelPrimaryMetrics"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword primary_metric: Primary metric to optimize for this task. Known values are:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted", and "IOU".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            model_settings=model_settings,
            search_space=search_space,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "ImageClassificationMultilabel"
        self.training_data = training_data
        self.primary_metric = primary_metric
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space


class ImageObjectDetectionBase(ImageVertical):
    """ImageObjectDetectionBase.

    All required parameters must be populated in order to send to Azure.

    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    """

    _validation = {
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsObjectDetection"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsObjectDetection]"},
    }

    def __init__(
        self,
        *,
        limit_settings: "_models.ImageLimitSettings",
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsObjectDetection"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            **kwargs
        )
        self.model_settings = model_settings
        self.search_space = search_space


class ImageInstanceSegmentation(
    ImageObjectDetectionBase, AutoMLVertical
):  # pylint: disable=too-many-instance-attributes
    """Image Instance Segmentation. Instance segmentation is used to identify objects in an image at
    the pixel level,
    drawing a polygon around each object in the image.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar primary_metric: Primary metric to optimize for this task. "MeanAveragePrecision"
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsObjectDetection"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsObjectDetection]"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        limit_settings: "_models.ImageLimitSettings",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsObjectDetection"]] = None,
        primary_metric: Optional[Union[str, "_models.InstanceSegmentationPrimaryMetrics"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword primary_metric: Primary metric to optimize for this task. "MeanAveragePrecision"
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            model_settings=model_settings,
            search_space=search_space,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "ImageInstanceSegmentation"
        self.training_data = training_data
        self.primary_metric = primary_metric
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space


class ImageLimitSettings(_serialization.Model):
    """Limit settings for the AutoML job.

    :ivar max_concurrent_trials: Maximum number of concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Maximum number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        "max_concurrent_trials": {"key": "maxConcurrentTrials", "type": "int"},
        "max_trials": {"key": "maxTrials", "type": "int"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    def __init__(
        self, *, max_concurrent_trials: int = 1, max_trials: int = 1, timeout: datetime.timedelta = "P7D", **kwargs: Any
    ) -> None:
        """
        :keyword max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Maximum number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.max_concurrent_trials = max_concurrent_trials
        self.max_trials = max_trials
        self.timeout = timeout


class ImageMetadata(_serialization.Model):
    """Returns metadata about the operating system image for this compute instance.

    :ivar current_image_version: Specifies the current operating system image version this compute
     instance is running on.
    :vartype current_image_version: str
    :ivar latest_image_version: Specifies the latest available operating system image version.
    :vartype latest_image_version: str
    :ivar is_latest_os_image_version: Specifies whether this compute instance is running on the
     latest operating system image.
    :vartype is_latest_os_image_version: bool
    """

    _attribute_map = {
        "current_image_version": {"key": "currentImageVersion", "type": "str"},
        "latest_image_version": {"key": "latestImageVersion", "type": "str"},
        "is_latest_os_image_version": {"key": "isLatestOsImageVersion", "type": "bool"},
    }

    def __init__(
        self,
        *,
        current_image_version: Optional[str] = None,
        latest_image_version: Optional[str] = None,
        is_latest_os_image_version: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_image_version: Specifies the current operating system image version this
         compute instance is running on.
        :paramtype current_image_version: str
        :keyword latest_image_version: Specifies the latest available operating system image version.
        :paramtype latest_image_version: str
        :keyword is_latest_os_image_version: Specifies whether this compute instance is running on the
         latest operating system image.
        :paramtype is_latest_os_image_version: bool
        """
        super().__init__(**kwargs)
        self.current_image_version = current_image_version
        self.latest_image_version = latest_image_version
        self.is_latest_os_image_version = is_latest_os_image_version


class ImageModelDistributionSettings(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Distribution expressions to sweep over values of model settings.

    :code:`<example>
    Some examples are:
    ```
    ModelName = "choice('seresnext', 'resnest50')";
    LearningRate = "uniform(0.001, 0.01)";
    LayersToFreeze = "choice(0, 2)";
    ```</example>`
    All distributions can be specified as distribution_name(min, max) or choice(val1, val2, ...,
    valn)
    where distribution name can be: uniform, quniform, loguniform, etc
    For more details on how to compose distribution expressions please check the documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    """

    _attribute_map = {
        "ams_gradient": {"key": "amsGradient", "type": "str"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "str"},
        "beta2": {"key": "beta2", "type": "str"},
        "distributed": {"key": "distributed", "type": "str"},
        "early_stopping": {"key": "earlyStopping", "type": "str"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "str"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "str"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "str"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "str"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "str"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "str"},
        "learning_rate": {"key": "learningRate", "type": "str"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "str"},
        "nesterov": {"key": "nesterov", "type": "str"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "str"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "str"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "str"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "str"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "str"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "str"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "str"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "str"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "str"},
        "weight_decay": {"key": "weightDecay", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        """
        super().__init__(**kwargs)
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelDistributionSettingsClassification(
    ImageModelDistributionSettings
):  # pylint: disable=too-many-instance-attributes
    """Distribution expressions to sweep over values of model settings.

    :code:`<example>
    Some examples are:
    ```
    ModelName = "choice('seresnext', 'resnest50')";
    LearningRate = "uniform(0.001, 0.01)";
    LayersToFreeze = "choice(0, 2)";
    ```</example>`
    For more details on how to compose distribution expressions please check the documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: str
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: str
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: str
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: str
    """

    _attribute_map = {
        "ams_gradient": {"key": "amsGradient", "type": "str"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "str"},
        "beta2": {"key": "beta2", "type": "str"},
        "distributed": {"key": "distributed", "type": "str"},
        "early_stopping": {"key": "earlyStopping", "type": "str"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "str"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "str"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "str"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "str"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "str"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "str"},
        "learning_rate": {"key": "learningRate", "type": "str"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "str"},
        "nesterov": {"key": "nesterov", "type": "str"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "str"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "str"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "str"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "str"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "str"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "str"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "str"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "str"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "str"},
        "weight_decay": {"key": "weightDecay", "type": "str"},
        "training_crop_size": {"key": "trainingCropSize", "type": "str"},
        "validation_crop_size": {"key": "validationCropSize", "type": "str"},
        "validation_resize_size": {"key": "validationResizeSize", "type": "str"},
        "weighted_loss": {"key": "weightedLoss", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        training_crop_size: Optional[str] = None,
        validation_crop_size: Optional[str] = None,
        validation_resize_size: Optional[str] = None,
        weighted_loss: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: str
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: str
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: str
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: str
        """
        super().__init__(
            ams_gradient=ams_gradient,
            augmentations=augmentations,
            beta1=beta1,
            beta2=beta2,
            distributed=distributed,
            early_stopping=early_stopping,
            early_stopping_delay=early_stopping_delay,
            early_stopping_patience=early_stopping_patience,
            enable_onnx_normalization=enable_onnx_normalization,
            evaluation_frequency=evaluation_frequency,
            gradient_accumulation_step=gradient_accumulation_step,
            layers_to_freeze=layers_to_freeze,
            learning_rate=learning_rate,
            learning_rate_scheduler=learning_rate_scheduler,
            model_name=model_name,
            momentum=momentum,
            nesterov=nesterov,
            number_of_epochs=number_of_epochs,
            number_of_workers=number_of_workers,
            optimizer=optimizer,
            random_seed=random_seed,
            step_lr_gamma=step_lr_gamma,
            step_lr_step_size=step_lr_step_size,
            training_batch_size=training_batch_size,
            validation_batch_size=validation_batch_size,
            warmup_cosine_lr_cycles=warmup_cosine_lr_cycles,
            warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs,
            weight_decay=weight_decay,
            **kwargs
        )
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelDistributionSettingsObjectDetection(
    ImageModelDistributionSettings
):  # pylint: disable=too-many-instance-attributes
    """Distribution expressions to sweep over values of model settings.

    :code:`<example>
    Some examples are:
    ```
    ModelName = "choice('seresnext', 'resnest50')";
    LearningRate = "uniform(0.001, 0.01)";
    LayersToFreeze = "choice(0, 2)";
    ```</example>`
    For more details on how to compose distribution expressions please check the documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: str
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: str
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: str
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: str
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: str
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype model_size: str
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: str
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
     float in the range [0, 1].
    :vartype nms_iou_threshold: str
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: str
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
     NMS: Non-maximum suppression.
    :vartype tile_predictions_nms_threshold: str
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: str
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Must be
     'none', 'coco', 'voc', or 'coco_voc'.
    :vartype validation_metric_type: str
    """

    _attribute_map = {
        "ams_gradient": {"key": "amsGradient", "type": "str"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "str"},
        "beta2": {"key": "beta2", "type": "str"},
        "distributed": {"key": "distributed", "type": "str"},
        "early_stopping": {"key": "earlyStopping", "type": "str"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "str"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "str"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "str"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "str"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "str"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "str"},
        "learning_rate": {"key": "learningRate", "type": "str"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "str"},
        "nesterov": {"key": "nesterov", "type": "str"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "str"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "str"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "str"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "str"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "str"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "str"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "str"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "str"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "str"},
        "weight_decay": {"key": "weightDecay", "type": "str"},
        "box_detections_per_image": {"key": "boxDetectionsPerImage", "type": "str"},
        "box_score_threshold": {"key": "boxScoreThreshold", "type": "str"},
        "image_size": {"key": "imageSize", "type": "str"},
        "max_size": {"key": "maxSize", "type": "str"},
        "min_size": {"key": "minSize", "type": "str"},
        "model_size": {"key": "modelSize", "type": "str"},
        "multi_scale": {"key": "multiScale", "type": "str"},
        "nms_iou_threshold": {"key": "nmsIouThreshold", "type": "str"},
        "tile_grid_size": {"key": "tileGridSize", "type": "str"},
        "tile_overlap_ratio": {"key": "tileOverlapRatio", "type": "str"},
        "tile_predictions_nms_threshold": {"key": "tilePredictionsNmsThreshold", "type": "str"},
        "validation_iou_threshold": {"key": "validationIouThreshold", "type": "str"},
        "validation_metric_type": {"key": "validationMetricType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        ams_gradient: Optional[str] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[str] = None,
        beta2: Optional[str] = None,
        distributed: Optional[str] = None,
        early_stopping: Optional[str] = None,
        early_stopping_delay: Optional[str] = None,
        early_stopping_patience: Optional[str] = None,
        enable_onnx_normalization: Optional[str] = None,
        evaluation_frequency: Optional[str] = None,
        gradient_accumulation_step: Optional[str] = None,
        layers_to_freeze: Optional[str] = None,
        learning_rate: Optional[str] = None,
        learning_rate_scheduler: Optional[str] = None,
        model_name: Optional[str] = None,
        momentum: Optional[str] = None,
        nesterov: Optional[str] = None,
        number_of_epochs: Optional[str] = None,
        number_of_workers: Optional[str] = None,
        optimizer: Optional[str] = None,
        random_seed: Optional[str] = None,
        step_lr_gamma: Optional[str] = None,
        step_lr_step_size: Optional[str] = None,
        training_batch_size: Optional[str] = None,
        validation_batch_size: Optional[str] = None,
        warmup_cosine_lr_cycles: Optional[str] = None,
        warmup_cosine_lr_warmup_epochs: Optional[str] = None,
        weight_decay: Optional[str] = None,
        box_detections_per_image: Optional[str] = None,
        box_score_threshold: Optional[str] = None,
        image_size: Optional[str] = None,
        max_size: Optional[str] = None,
        min_size: Optional[str] = None,
        model_size: Optional[str] = None,
        multi_scale: Optional[str] = None,
        nms_iou_threshold: Optional[str] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[str] = None,
        tile_predictions_nms_threshold: Optional[str] = None,
        validation_iou_threshold: Optional[str] = None,
        validation_metric_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: str
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: str
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: str
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: str
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: str
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype model_size: str
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: str
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         float in the range [0, 1].
        :paramtype nms_iou_threshold: str
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: str
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
         NMS: Non-maximum suppression.
        :paramtype tile_predictions_nms_threshold: str
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: str
        :keyword validation_metric_type: Metric computation method to use for validation metrics. Must
         be 'none', 'coco', 'voc', or 'coco_voc'.
        :paramtype validation_metric_type: str
        """
        super().__init__(
            ams_gradient=ams_gradient,
            augmentations=augmentations,
            beta1=beta1,
            beta2=beta2,
            distributed=distributed,
            early_stopping=early_stopping,
            early_stopping_delay=early_stopping_delay,
            early_stopping_patience=early_stopping_patience,
            enable_onnx_normalization=enable_onnx_normalization,
            evaluation_frequency=evaluation_frequency,
            gradient_accumulation_step=gradient_accumulation_step,
            layers_to_freeze=layers_to_freeze,
            learning_rate=learning_rate,
            learning_rate_scheduler=learning_rate_scheduler,
            model_name=model_name,
            momentum=momentum,
            nesterov=nesterov,
            number_of_epochs=number_of_epochs,
            number_of_workers=number_of_workers,
            optimizer=optimizer,
            random_seed=random_seed,
            step_lr_gamma=step_lr_gamma,
            step_lr_step_size=step_lr_step_size,
            training_batch_size=training_batch_size,
            validation_batch_size=validation_batch_size,
            warmup_cosine_lr_cycles=warmup_cosine_lr_cycles,
            warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs,
            weight_decay=weight_decay,
            **kwargs
        )
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageModelSettings(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Settings used for training the model.
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Known values are: "None", "WarmupCosine", and "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    """

    _attribute_map = {
        "advanced_settings": {"key": "advancedSettings", "type": "str"},
        "ams_gradient": {"key": "amsGradient", "type": "bool"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "float"},
        "beta2": {"key": "beta2", "type": "float"},
        "checkpoint_frequency": {"key": "checkpointFrequency", "type": "int"},
        "checkpoint_model": {"key": "checkpointModel", "type": "MLFlowModelJobInput"},
        "checkpoint_run_id": {"key": "checkpointRunId", "type": "str"},
        "distributed": {"key": "distributed", "type": "bool"},
        "early_stopping": {"key": "earlyStopping", "type": "bool"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "int"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "int"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "bool"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "int"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "int"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "int"},
        "learning_rate": {"key": "learningRate", "type": "float"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "float"},
        "nesterov": {"key": "nesterov", "type": "bool"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "int"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "int"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "float"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "int"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "int"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "int"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "float"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "int"},
        "weight_decay": {"key": "weightDecay", "type": "float"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["_models.MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "_models.LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "_models.StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Known values are: "None", "WarmupCosine", and "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        """
        super().__init__(**kwargs)
        self.advanced_settings = advanced_settings
        self.ams_gradient = ams_gradient
        self.augmentations = augmentations
        self.beta1 = beta1
        self.beta2 = beta2
        self.checkpoint_frequency = checkpoint_frequency
        self.checkpoint_model = checkpoint_model
        self.checkpoint_run_id = checkpoint_run_id
        self.distributed = distributed
        self.early_stopping = early_stopping
        self.early_stopping_delay = early_stopping_delay
        self.early_stopping_patience = early_stopping_patience
        self.enable_onnx_normalization = enable_onnx_normalization
        self.evaluation_frequency = evaluation_frequency
        self.gradient_accumulation_step = gradient_accumulation_step
        self.layers_to_freeze = layers_to_freeze
        self.learning_rate = learning_rate
        self.learning_rate_scheduler = learning_rate_scheduler
        self.model_name = model_name
        self.momentum = momentum
        self.nesterov = nesterov
        self.number_of_epochs = number_of_epochs
        self.number_of_workers = number_of_workers
        self.optimizer = optimizer
        self.random_seed = random_seed
        self.step_lr_gamma = step_lr_gamma
        self.step_lr_step_size = step_lr_step_size
        self.training_batch_size = training_batch_size
        self.validation_batch_size = validation_batch_size
        self.warmup_cosine_lr_cycles = warmup_cosine_lr_cycles
        self.warmup_cosine_lr_warmup_epochs = warmup_cosine_lr_warmup_epochs
        self.weight_decay = weight_decay


class ImageModelSettingsClassification(ImageModelSettings):  # pylint: disable=too-many-instance-attributes
    """Settings used for training the model.
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Known values are: "None", "WarmupCosine", and "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: int
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: int
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: int
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: int
    """

    _attribute_map = {
        "advanced_settings": {"key": "advancedSettings", "type": "str"},
        "ams_gradient": {"key": "amsGradient", "type": "bool"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "float"},
        "beta2": {"key": "beta2", "type": "float"},
        "checkpoint_frequency": {"key": "checkpointFrequency", "type": "int"},
        "checkpoint_model": {"key": "checkpointModel", "type": "MLFlowModelJobInput"},
        "checkpoint_run_id": {"key": "checkpointRunId", "type": "str"},
        "distributed": {"key": "distributed", "type": "bool"},
        "early_stopping": {"key": "earlyStopping", "type": "bool"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "int"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "int"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "bool"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "int"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "int"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "int"},
        "learning_rate": {"key": "learningRate", "type": "float"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "float"},
        "nesterov": {"key": "nesterov", "type": "bool"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "int"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "int"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "float"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "int"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "int"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "int"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "float"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "int"},
        "weight_decay": {"key": "weightDecay", "type": "float"},
        "training_crop_size": {"key": "trainingCropSize", "type": "int"},
        "validation_crop_size": {"key": "validationCropSize", "type": "int"},
        "validation_resize_size": {"key": "validationResizeSize", "type": "int"},
        "weighted_loss": {"key": "weightedLoss", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["_models.MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "_models.LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "_models.StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        training_crop_size: Optional[int] = None,
        validation_crop_size: Optional[int] = None,
        validation_resize_size: Optional[int] = None,
        weighted_loss: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Known values are: "None", "WarmupCosine", and "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: int
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: int
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: int
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: int
        """
        super().__init__(
            advanced_settings=advanced_settings,
            ams_gradient=ams_gradient,
            augmentations=augmentations,
            beta1=beta1,
            beta2=beta2,
            checkpoint_frequency=checkpoint_frequency,
            checkpoint_model=checkpoint_model,
            checkpoint_run_id=checkpoint_run_id,
            distributed=distributed,
            early_stopping=early_stopping,
            early_stopping_delay=early_stopping_delay,
            early_stopping_patience=early_stopping_patience,
            enable_onnx_normalization=enable_onnx_normalization,
            evaluation_frequency=evaluation_frequency,
            gradient_accumulation_step=gradient_accumulation_step,
            layers_to_freeze=layers_to_freeze,
            learning_rate=learning_rate,
            learning_rate_scheduler=learning_rate_scheduler,
            model_name=model_name,
            momentum=momentum,
            nesterov=nesterov,
            number_of_epochs=number_of_epochs,
            number_of_workers=number_of_workers,
            optimizer=optimizer,
            random_seed=random_seed,
            step_lr_gamma=step_lr_gamma,
            step_lr_step_size=step_lr_step_size,
            training_batch_size=training_batch_size,
            validation_batch_size=validation_batch_size,
            warmup_cosine_lr_cycles=warmup_cosine_lr_cycles,
            warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs,
            weight_decay=weight_decay,
            **kwargs
        )
        self.training_crop_size = training_crop_size
        self.validation_crop_size = validation_crop_size
        self.validation_resize_size = validation_resize_size
        self.weighted_loss = weighted_loss


class ImageModelSettingsObjectDetection(ImageModelSettings):  # pylint: disable=too-many-instance-attributes
    """Settings used for training the model.
    For more information on the available settings please visit the official documentation:
    https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_model: The pretrained checkpoint model for incremental training.
    :vartype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Known values are: "None", "WarmupCosine", and "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: int
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: float
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: int
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: int
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: int
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm. Known values are: "None",
     "Small", "Medium", "Large", and "ExtraLarge".
    :vartype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: bool
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a
     float in the range [0, 1].
    :vartype nms_iou_threshold: float
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: float
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_predictions_nms_threshold: float
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: float
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Known
     values are: "None", "Coco", "Voc", and "CocoVoc".
    :vartype validation_metric_type: str or
     ~azure.mgmt.machinelearningservices.models.ValidationMetricType
    """

    _attribute_map = {
        "advanced_settings": {"key": "advancedSettings", "type": "str"},
        "ams_gradient": {"key": "amsGradient", "type": "bool"},
        "augmentations": {"key": "augmentations", "type": "str"},
        "beta1": {"key": "beta1", "type": "float"},
        "beta2": {"key": "beta2", "type": "float"},
        "checkpoint_frequency": {"key": "checkpointFrequency", "type": "int"},
        "checkpoint_model": {"key": "checkpointModel", "type": "MLFlowModelJobInput"},
        "checkpoint_run_id": {"key": "checkpointRunId", "type": "str"},
        "distributed": {"key": "distributed", "type": "bool"},
        "early_stopping": {"key": "earlyStopping", "type": "bool"},
        "early_stopping_delay": {"key": "earlyStoppingDelay", "type": "int"},
        "early_stopping_patience": {"key": "earlyStoppingPatience", "type": "int"},
        "enable_onnx_normalization": {"key": "enableOnnxNormalization", "type": "bool"},
        "evaluation_frequency": {"key": "evaluationFrequency", "type": "int"},
        "gradient_accumulation_step": {"key": "gradientAccumulationStep", "type": "int"},
        "layers_to_freeze": {"key": "layersToFreeze", "type": "int"},
        "learning_rate": {"key": "learningRate", "type": "float"},
        "learning_rate_scheduler": {"key": "learningRateScheduler", "type": "str"},
        "model_name": {"key": "modelName", "type": "str"},
        "momentum": {"key": "momentum", "type": "float"},
        "nesterov": {"key": "nesterov", "type": "bool"},
        "number_of_epochs": {"key": "numberOfEpochs", "type": "int"},
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "optimizer": {"key": "optimizer", "type": "str"},
        "random_seed": {"key": "randomSeed", "type": "int"},
        "step_lr_gamma": {"key": "stepLRGamma", "type": "float"},
        "step_lr_step_size": {"key": "stepLRStepSize", "type": "int"},
        "training_batch_size": {"key": "trainingBatchSize", "type": "int"},
        "validation_batch_size": {"key": "validationBatchSize", "type": "int"},
        "warmup_cosine_lr_cycles": {"key": "warmupCosineLRCycles", "type": "float"},
        "warmup_cosine_lr_warmup_epochs": {"key": "warmupCosineLRWarmupEpochs", "type": "int"},
        "weight_decay": {"key": "weightDecay", "type": "float"},
        "box_detections_per_image": {"key": "boxDetectionsPerImage", "type": "int"},
        "box_score_threshold": {"key": "boxScoreThreshold", "type": "float"},
        "image_size": {"key": "imageSize", "type": "int"},
        "max_size": {"key": "maxSize", "type": "int"},
        "min_size": {"key": "minSize", "type": "int"},
        "model_size": {"key": "modelSize", "type": "str"},
        "multi_scale": {"key": "multiScale", "type": "bool"},
        "nms_iou_threshold": {"key": "nmsIouThreshold", "type": "float"},
        "tile_grid_size": {"key": "tileGridSize", "type": "str"},
        "tile_overlap_ratio": {"key": "tileOverlapRatio", "type": "float"},
        "tile_predictions_nms_threshold": {"key": "tilePredictionsNmsThreshold", "type": "float"},
        "validation_iou_threshold": {"key": "validationIouThreshold", "type": "float"},
        "validation_metric_type": {"key": "validationMetricType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        advanced_settings: Optional[str] = None,
        ams_gradient: Optional[bool] = None,
        augmentations: Optional[str] = None,
        beta1: Optional[float] = None,
        beta2: Optional[float] = None,
        checkpoint_frequency: Optional[int] = None,
        checkpoint_model: Optional["_models.MLFlowModelJobInput"] = None,
        checkpoint_run_id: Optional[str] = None,
        distributed: Optional[bool] = None,
        early_stopping: Optional[bool] = None,
        early_stopping_delay: Optional[int] = None,
        early_stopping_patience: Optional[int] = None,
        enable_onnx_normalization: Optional[bool] = None,
        evaluation_frequency: Optional[int] = None,
        gradient_accumulation_step: Optional[int] = None,
        layers_to_freeze: Optional[int] = None,
        learning_rate: Optional[float] = None,
        learning_rate_scheduler: Optional[Union[str, "_models.LearningRateScheduler"]] = None,
        model_name: Optional[str] = None,
        momentum: Optional[float] = None,
        nesterov: Optional[bool] = None,
        number_of_epochs: Optional[int] = None,
        number_of_workers: Optional[int] = None,
        optimizer: Optional[Union[str, "_models.StochasticOptimizer"]] = None,
        random_seed: Optional[int] = None,
        step_lr_gamma: Optional[float] = None,
        step_lr_step_size: Optional[int] = None,
        training_batch_size: Optional[int] = None,
        validation_batch_size: Optional[int] = None,
        warmup_cosine_lr_cycles: Optional[float] = None,
        warmup_cosine_lr_warmup_epochs: Optional[int] = None,
        weight_decay: Optional[float] = None,
        box_detections_per_image: Optional[int] = None,
        box_score_threshold: Optional[float] = None,
        image_size: Optional[int] = None,
        max_size: Optional[int] = None,
        min_size: Optional[int] = None,
        model_size: Optional[Union[str, "_models.ModelSize"]] = None,
        multi_scale: Optional[bool] = None,
        nms_iou_threshold: Optional[float] = None,
        tile_grid_size: Optional[str] = None,
        tile_overlap_ratio: Optional[float] = None,
        tile_predictions_nms_threshold: Optional[float] = None,
        validation_iou_threshold: Optional[float] = None,
        validation_metric_type: Optional[Union[str, "_models.ValidationMetricType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_model: The pretrained checkpoint model for incremental training.
        :paramtype checkpoint_model: ~azure.mgmt.machinelearningservices.models.MLFlowModelJobInput
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Known values are: "None", "WarmupCosine", and "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Known values are: "None", "Sgd", "Adam", and "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: int
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: float
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: int
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: int
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: int
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm. Known values are: "None",
         "Small", "Medium", "Large", and "ExtraLarge".
        :paramtype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: bool
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         a float in the range [0, 1].
        :paramtype nms_iou_threshold: float
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: float
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_predictions_nms_threshold: float
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: float
        :keyword validation_metric_type: Metric computation method to use for validation metrics. Known
         values are: "None", "Coco", "Voc", and "CocoVoc".
        :paramtype validation_metric_type: str or
         ~azure.mgmt.machinelearningservices.models.ValidationMetricType
        """
        super().__init__(
            advanced_settings=advanced_settings,
            ams_gradient=ams_gradient,
            augmentations=augmentations,
            beta1=beta1,
            beta2=beta2,
            checkpoint_frequency=checkpoint_frequency,
            checkpoint_model=checkpoint_model,
            checkpoint_run_id=checkpoint_run_id,
            distributed=distributed,
            early_stopping=early_stopping,
            early_stopping_delay=early_stopping_delay,
            early_stopping_patience=early_stopping_patience,
            enable_onnx_normalization=enable_onnx_normalization,
            evaluation_frequency=evaluation_frequency,
            gradient_accumulation_step=gradient_accumulation_step,
            layers_to_freeze=layers_to_freeze,
            learning_rate=learning_rate,
            learning_rate_scheduler=learning_rate_scheduler,
            model_name=model_name,
            momentum=momentum,
            nesterov=nesterov,
            number_of_epochs=number_of_epochs,
            number_of_workers=number_of_workers,
            optimizer=optimizer,
            random_seed=random_seed,
            step_lr_gamma=step_lr_gamma,
            step_lr_step_size=step_lr_step_size,
            training_batch_size=training_batch_size,
            validation_batch_size=validation_batch_size,
            warmup_cosine_lr_cycles=warmup_cosine_lr_cycles,
            warmup_cosine_lr_warmup_epochs=warmup_cosine_lr_warmup_epochs,
            weight_decay=weight_decay,
            **kwargs
        )
        self.box_detections_per_image = box_detections_per_image
        self.box_score_threshold = box_score_threshold
        self.image_size = image_size
        self.max_size = max_size
        self.min_size = min_size
        self.model_size = model_size
        self.multi_scale = multi_scale
        self.nms_iou_threshold = nms_iou_threshold
        self.tile_grid_size = tile_grid_size
        self.tile_overlap_ratio = tile_overlap_ratio
        self.tile_predictions_nms_threshold = tile_predictions_nms_threshold
        self.validation_iou_threshold = validation_iou_threshold
        self.validation_metric_type = validation_metric_type


class ImageObjectDetection(ImageObjectDetectionBase, AutoMLVertical):  # pylint: disable=too-many-instance-attributes
    """Image Object Detection. Object detection is used to identify objects in an image and locate
    each object with a
    bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar limit_settings: [Required] Limit settings for the AutoML job. Required.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar primary_metric: Primary metric to optimize for this task. "MeanAveragePrecision"
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
        "limit_settings": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "limit_settings": {"key": "limitSettings", "type": "ImageLimitSettings"},
        "sweep_settings": {"key": "sweepSettings", "type": "ImageSweepSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "model_settings": {"key": "modelSettings", "type": "ImageModelSettingsObjectDetection"},
        "search_space": {"key": "searchSpace", "type": "[ImageModelDistributionSettingsObjectDetection]"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        limit_settings: "_models.ImageLimitSettings",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        sweep_settings: Optional["_models.ImageSweepSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        model_settings: Optional["_models.ImageModelSettingsObjectDetection"] = None,
        search_space: Optional[List["_models.ImageModelDistributionSettingsObjectDetection"]] = None,
        primary_metric: Optional[Union[str, "_models.ObjectDetectionPrimaryMetrics"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword limit_settings: [Required] Limit settings for the AutoML job. Required.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword primary_metric: Primary metric to optimize for this task. "MeanAveragePrecision"
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
        """
        super().__init__(
            limit_settings=limit_settings,
            sweep_settings=sweep_settings,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            model_settings=model_settings,
            search_space=search_space,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "ImageObjectDetection"
        self.training_data = training_data
        self.primary_metric = primary_metric
        self.limit_settings = limit_settings
        self.sweep_settings = sweep_settings
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.model_settings = model_settings
        self.search_space = search_space


class ImageSweepSettings(_serialization.Model):
    """Model sweeping and hyperparameter sweeping related settings.

    All required parameters must be populated in order to send to Azure.

    :ivar early_termination: Type of early termination policy.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar sampling_algorithm: [Required] Type of the hyperparameter sampling algorithms. Required.
     Known values are: "Grid", "Random", and "Bayesian".
    :vartype sampling_algorithm: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        "sampling_algorithm": {"required": True},
    }

    _attribute_map = {
        "early_termination": {"key": "earlyTermination", "type": "EarlyTerminationPolicy"},
        "sampling_algorithm": {"key": "samplingAlgorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        sampling_algorithm: Union[str, "_models.SamplingAlgorithmType"],
        early_termination: Optional["_models.EarlyTerminationPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword early_termination: Type of early termination policy.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword sampling_algorithm: [Required] Type of the hyperparameter sampling algorithms.
         Required. Known values are: "Grid", "Random", and "Bayesian".
        :paramtype sampling_algorithm: str or
         ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
        """
        super().__init__(**kwargs)
        self.early_termination = early_termination
        self.sampling_algorithm = sampling_algorithm


class IndexColumn(_serialization.Model):
    """DTO object representing index column.

    :ivar column_name: Specifies the column name.
    :vartype column_name: str
    :ivar data_type: Specifies the data type. Known values are: "String", "Integer", "Long",
     "Float", "Double", "Binary", "Datetime", and "Boolean".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[Union[str, "_models.FeatureDataType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Specifies the column name.
        :paramtype column_name: str
        :keyword data_type: Specifies the data type. Known values are: "String", "Integer", "Long",
         "Float", "Double", "Binary", "Datetime", and "Boolean".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.FeatureDataType
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type


class InferenceContainerProperties(_serialization.Model):
    """InferenceContainerProperties.

    :ivar liveness_route: The route to check the liveness of the inference server container.
    :vartype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar readiness_route: The route to check the readiness of the inference server container.
    :vartype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar scoring_route: The port to send the scoring requests to, within the inference server
     container.
    :vartype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
    """

    _attribute_map = {
        "liveness_route": {"key": "livenessRoute", "type": "Route"},
        "readiness_route": {"key": "readinessRoute", "type": "Route"},
        "scoring_route": {"key": "scoringRoute", "type": "Route"},
    }

    def __init__(
        self,
        *,
        liveness_route: Optional["_models.Route"] = None,
        readiness_route: Optional["_models.Route"] = None,
        scoring_route: Optional["_models.Route"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword liveness_route: The route to check the liveness of the inference server container.
        :paramtype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword readiness_route: The route to check the readiness of the inference server container.
        :paramtype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword scoring_route: The port to send the scoring requests to, within the inference server
         container.
        :paramtype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
        """
        super().__init__(**kwargs)
        self.liveness_route = liveness_route
        self.readiness_route = readiness_route
        self.scoring_route = scoring_route


class InstanceTypeSchema(_serialization.Model):
    """Instance type schema.

    :ivar node_selector: Node Selector.
    :vartype node_selector: dict[str, str]
    :ivar resources: Resource requests/limits for this instance type.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
    """

    _attribute_map = {
        "node_selector": {"key": "nodeSelector", "type": "{str}"},
        "resources": {"key": "resources", "type": "InstanceTypeSchemaResources"},
    }

    def __init__(
        self,
        *,
        node_selector: Optional[Dict[str, str]] = None,
        resources: Optional["_models.InstanceTypeSchemaResources"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword node_selector: Node Selector.
        :paramtype node_selector: dict[str, str]
        :keyword resources: Resource requests/limits for this instance type.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
        """
        super().__init__(**kwargs)
        self.node_selector = node_selector
        self.resources = resources


class InstanceTypeSchemaResources(_serialization.Model):
    """Resource requests/limits for this instance type.

    :ivar requests: Resource requests for this instance type.
    :vartype requests: dict[str, str]
    :ivar limits: Resource limits for this instance type.
    :vartype limits: dict[str, str]
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "{str}"},
        "limits": {"key": "limits", "type": "{str}"},
    }

    def __init__(
        self, *, requests: Optional[Dict[str, str]] = None, limits: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword requests: Resource requests for this instance type.
        :paramtype requests: dict[str, str]
        :keyword limits: Resource limits for this instance type.
        :paramtype limits: dict[str, str]
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.limits = limits


class JobBase(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "JobBaseProperties"},
    }

    def __init__(self, *, properties: "_models.JobBaseProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class JobBaseResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of JobBase entities.

    :ivar next_link: The link to the next page of JobBase objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type JobBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[JobBase]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.JobBase"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of JobBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type JobBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.JobBase]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class JobResourceConfiguration(ResourceConfiguration):
    """JobResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, JSON]
    :ivar docker_args: Extra arguments to pass to the Docker run command. This would override any
     parameters that have already been set by the system, or in this section. This parameter is only
     supported for Azure ML compute types.
    :vartype docker_args: str
    :ivar shm_size: Size of the docker container's shared memory block. This should be in the
     format of (number)(unit) where number as to be greater than 0 and the unit can be one of
     b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
    :vartype shm_size: str
    """

    _validation = {
        "shm_size": {"pattern": r"\d+[bBkKmMgG]"},
    }

    _attribute_map = {
        "instance_count": {"key": "instanceCount", "type": "int"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
        "docker_args": {"key": "dockerArgs", "type": "str"},
        "shm_size": {"key": "shmSize", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_count: int = 1,
        instance_type: Optional[str] = None,
        properties: Optional[Dict[str, JSON]] = None,
        docker_args: Optional[str] = None,
        shm_size: str = "2g",
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, JSON]
        :keyword docker_args: Extra arguments to pass to the Docker run command. This would override
         any parameters that have already been set by the system, or in this section. This parameter is
         only supported for Azure ML compute types.
        :paramtype docker_args: str
        :keyword shm_size: Size of the docker container's shared memory block. This should be in the
         format of (number)(unit) where number as to be greater than 0 and the unit can be one of
         b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        :paramtype shm_size: str
        """
        super().__init__(instance_count=instance_count, instance_type=instance_type, properties=properties, **kwargs)
        self.docker_args = docker_args
        self.shm_size = shm_size


class JobScheduleAction(ScheduleActionBase):
    """JobScheduleAction.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: [Required] Specifies the action type of the schedule. Required. Known values
     are: "CreateJob", "InvokeBatchEndpoint", and "CreateMonitor".
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleActionType
    :ivar job_definition: [Required] Defines Schedule action definition details. Required.
    :vartype job_definition: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
    """

    _validation = {
        "action_type": {"required": True},
        "job_definition": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "job_definition": {"key": "jobDefinition", "type": "JobBaseProperties"},
    }

    def __init__(self, *, job_definition: "_models.JobBaseProperties", **kwargs: Any) -> None:
        """
        :keyword job_definition: [Required] Defines Schedule action definition details. Required.
        :paramtype job_definition: ~azure.mgmt.machinelearningservices.models.JobBaseProperties
        """
        super().__init__(**kwargs)
        self.action_type: str = "CreateJob"
        self.job_definition = job_definition


class JobService(_serialization.Model):
    """Job endpoint definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: Url for endpoint.
    :vartype endpoint: str
    :ivar error_message: Any error in the service.
    :vartype error_message: str
    :ivar job_service_type: Endpoint type.
    :vartype job_service_type: str
    :ivar nodes: Nodes that user would like to start the service on.
     If Nodes is not set or set to null, the service will only be started on leader node.
    :vartype nodes: ~azure.mgmt.machinelearningservices.models.Nodes
    :ivar port: Port for endpoint.
    :vartype port: int
    :ivar properties: Additional properties to set on the endpoint.
    :vartype properties: dict[str, str]
    :ivar status: Status of endpoint.
    :vartype status: str
    """

    _validation = {
        "error_message": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "endpoint": {"key": "endpoint", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "job_service_type": {"key": "jobServiceType", "type": "str"},
        "nodes": {"key": "nodes", "type": "Nodes"},
        "port": {"key": "port", "type": "int"},
        "properties": {"key": "properties", "type": "{str}"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        job_service_type: Optional[str] = None,
        nodes: Optional["_models.Nodes"] = None,
        port: Optional[int] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword endpoint: Url for endpoint.
        :paramtype endpoint: str
        :keyword job_service_type: Endpoint type.
        :paramtype job_service_type: str
        :keyword nodes: Nodes that user would like to start the service on.
         If Nodes is not set or set to null, the service will only be started on leader node.
        :paramtype nodes: ~azure.mgmt.machinelearningservices.models.Nodes
        :keyword port: Port for endpoint.
        :paramtype port: int
        :keyword properties: Additional properties to set on the endpoint.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.endpoint = endpoint
        self.error_message = None
        self.job_service_type = job_service_type
        self.nodes = nodes
        self.port = port
        self.properties = properties
        self.status = None


class KubernetesSchema(_serialization.Model):
    """Kubernetes Compute Schema.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "KubernetesProperties"},
    }

    def __init__(self, *, properties: Optional["_models.KubernetesProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class Kubernetes(Compute, KubernetesSchema):  # pylint: disable=too-many-instance-attributes
    """A Machine Learning compute based on Kubernetes Compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    :ivar compute_type: The type of compute. Required. Known values are: "AKS", "Kubernetes",
     "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight", "Databricks",
     "DataLakeAnalytics", and "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Known values are: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        "compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "modified_on": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "is_attached_compute": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "KubernetesProperties"},
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_location": {"key": "computeLocation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "modified_on": {"key": "modifiedOn", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[ErrorResponse]"},
        "is_attached_compute": {"key": "isAttachedCompute", "type": "bool"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.KubernetesProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super().__init__(
            compute_location=compute_location,
            description=description,
            resource_id=resource_id,
            disable_local_auth=disable_local_auth,
            properties=properties,
            **kwargs
        )
        self.properties = properties
        self.compute_type: str = "Kubernetes"
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class OnlineDeploymentProperties(EndpointDeploymentPropertiesBase):  # pylint: disable=too-many-instance-attributes
    """OnlineDeploymentProperties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KubernetesOnlineDeployment, ManagedOnlineDeployment

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID or AssetId of the environment specification for the
     endpoint deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: [Required] The compute type of the endpoint. Required. Known
     values are: "Managed", "Kubernetes", and "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Known values are:
     "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        "endpoint_compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "CodeConfiguration"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "properties": {"key": "properties", "type": "{str}"},
        "app_insights_enabled": {"key": "appInsightsEnabled", "type": "bool"},
        "egress_public_network_access": {"key": "egressPublicNetworkAccess", "type": "str"},
        "endpoint_compute_type": {"key": "endpointComputeType", "type": "str"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "liveness_probe": {"key": "livenessProbe", "type": "ProbeSettings"},
        "model": {"key": "model", "type": "str"},
        "model_mount_path": {"key": "modelMountPath", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "readiness_probe": {"key": "readinessProbe", "type": "ProbeSettings"},
        "request_settings": {"key": "requestSettings", "type": "OnlineRequestSettings"},
        "scale_settings": {"key": "scaleSettings", "type": "OnlineScaleSettings"},
    }

    _subtype_map = {
        "endpoint_compute_type": {"Kubernetes": "KubernetesOnlineDeployment", "Managed": "ManagedOnlineDeployment"}
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: bool = False,
        egress_public_network_access: Optional[Union[str, "_models.EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["_models.ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["_models.ProbeSettings"] = None,
        request_settings: Optional["_models.OnlineRequestSettings"] = None,
        scale_settings: Optional["_models.OnlineScaleSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID or AssetId of the environment specification for the
         endpoint deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super().__init__(
            code_configuration=code_configuration,
            description=description,
            environment_id=environment_id,
            environment_variables=environment_variables,
            properties=properties,
            **kwargs
        )
        self.app_insights_enabled = app_insights_enabled
        self.egress_public_network_access = egress_public_network_access
        self.endpoint_compute_type: Optional[str] = None
        self.instance_type = instance_type
        self.liveness_probe = liveness_probe
        self.model = model
        self.model_mount_path = model_mount_path
        self.provisioning_state = None
        self.readiness_probe = readiness_probe
        self.request_settings = request_settings
        self.scale_settings = scale_settings


class KubernetesOnlineDeployment(OnlineDeploymentProperties):  # pylint: disable=too-many-instance-attributes
    """Properties specific to a KubernetesOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID or AssetId of the environment specification for the
     endpoint deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: [Required] The compute type of the endpoint. Required. Known
     values are: "Managed", "Kubernetes", and "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Known values are:
     "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    :ivar container_resource_requirements: The resource requirements for the container (cpu and
     memory).
    :vartype container_resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    """

    _validation = {
        "endpoint_compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "CodeConfiguration"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "properties": {"key": "properties", "type": "{str}"},
        "app_insights_enabled": {"key": "appInsightsEnabled", "type": "bool"},
        "egress_public_network_access": {"key": "egressPublicNetworkAccess", "type": "str"},
        "endpoint_compute_type": {"key": "endpointComputeType", "type": "str"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "liveness_probe": {"key": "livenessProbe", "type": "ProbeSettings"},
        "model": {"key": "model", "type": "str"},
        "model_mount_path": {"key": "modelMountPath", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "readiness_probe": {"key": "readinessProbe", "type": "ProbeSettings"},
        "request_settings": {"key": "requestSettings", "type": "OnlineRequestSettings"},
        "scale_settings": {"key": "scaleSettings", "type": "OnlineScaleSettings"},
        "container_resource_requirements": {
            "key": "containerResourceRequirements",
            "type": "ContainerResourceRequirements",
        },
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: bool = False,
        egress_public_network_access: Optional[Union[str, "_models.EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["_models.ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["_models.ProbeSettings"] = None,
        request_settings: Optional["_models.OnlineRequestSettings"] = None,
        scale_settings: Optional["_models.OnlineScaleSettings"] = None,
        container_resource_requirements: Optional["_models.ContainerResourceRequirements"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID or AssetId of the environment specification for the
         endpoint deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        :keyword container_resource_requirements: The resource requirements for the container (cpu and
         memory).
        :paramtype container_resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        """
        super().__init__(
            code_configuration=code_configuration,
            description=description,
            environment_id=environment_id,
            environment_variables=environment_variables,
            properties=properties,
            app_insights_enabled=app_insights_enabled,
            egress_public_network_access=egress_public_network_access,
            instance_type=instance_type,
            liveness_probe=liveness_probe,
            model=model,
            model_mount_path=model_mount_path,
            readiness_probe=readiness_probe,
            request_settings=request_settings,
            scale_settings=scale_settings,
            **kwargs
        )
        self.endpoint_compute_type: str = "Kubernetes"
        self.container_resource_requirements = container_resource_requirements


class KubernetesProperties(_serialization.Model):
    """Kubernetes properties.

    :ivar relay_connection_string: Relay connection string.
    :vartype relay_connection_string: str
    :ivar service_bus_connection_string: ServiceBus connection string.
    :vartype service_bus_connection_string: str
    :ivar extension_principal_id: Extension principal-id.
    :vartype extension_principal_id: str
    :ivar extension_instance_release_train: Extension instance release train.
    :vartype extension_instance_release_train: str
    :ivar vc_name: VC name.
    :vartype vc_name: str
    :ivar namespace: Compute namespace.
    :vartype namespace: str
    :ivar default_instance_type: Default instance type.
    :vartype default_instance_type: str
    :ivar instance_types: Instance Type Schema.
    :vartype instance_types: dict[str,
     ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
    """

    _attribute_map = {
        "relay_connection_string": {"key": "relayConnectionString", "type": "str"},
        "service_bus_connection_string": {"key": "serviceBusConnectionString", "type": "str"},
        "extension_principal_id": {"key": "extensionPrincipalId", "type": "str"},
        "extension_instance_release_train": {"key": "extensionInstanceReleaseTrain", "type": "str"},
        "vc_name": {"key": "vcName", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "default_instance_type": {"key": "defaultInstanceType", "type": "str"},
        "instance_types": {"key": "instanceTypes", "type": "{InstanceTypeSchema}"},
    }

    def __init__(
        self,
        *,
        relay_connection_string: Optional[str] = None,
        service_bus_connection_string: Optional[str] = None,
        extension_principal_id: Optional[str] = None,
        extension_instance_release_train: Optional[str] = None,
        vc_name: Optional[str] = None,
        namespace: str = "default",
        default_instance_type: Optional[str] = None,
        instance_types: Optional[Dict[str, "_models.InstanceTypeSchema"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword relay_connection_string: Relay connection string.
        :paramtype relay_connection_string: str
        :keyword service_bus_connection_string: ServiceBus connection string.
        :paramtype service_bus_connection_string: str
        :keyword extension_principal_id: Extension principal-id.
        :paramtype extension_principal_id: str
        :keyword extension_instance_release_train: Extension instance release train.
        :paramtype extension_instance_release_train: str
        :keyword vc_name: VC name.
        :paramtype vc_name: str
        :keyword namespace: Compute namespace.
        :paramtype namespace: str
        :keyword default_instance_type: Default instance type.
        :paramtype default_instance_type: str
        :keyword instance_types: Instance Type Schema.
        :paramtype instance_types: dict[str,
         ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
        """
        super().__init__(**kwargs)
        self.relay_connection_string = relay_connection_string
        self.service_bus_connection_string = service_bus_connection_string
        self.extension_principal_id = extension_principal_id
        self.extension_instance_release_train = extension_instance_release_train
        self.vc_name = vc_name
        self.namespace = namespace
        self.default_instance_type = default_instance_type
        self.instance_types = instance_types


class ListAmlUserFeatureResult(_serialization.Model):
    """The List Aml user feature operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML user facing features.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlUserFeature]
    :ivar next_link: The URI to fetch the next page of AML user features information. Call
     ListNext() with this to fetch the next page of AML user features information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AmlUserFeature]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListNotebookKeysResult(_serialization.Model):
    """ListNotebookKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_access_key:
    :vartype primary_access_key: str
    :ivar secondary_access_key:
    :vartype secondary_access_key: str
    """

    _validation = {
        "primary_access_key": {"readonly": True},
        "secondary_access_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_access_key": {"key": "primaryAccessKey", "type": "str"},
        "secondary_access_key": {"key": "secondaryAccessKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_access_key = None
        self.secondary_access_key = None


class ListStorageAccountKeysResult(_serialization.Model):
    """ListStorageAccountKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    """

    _validation = {
        "user_storage_key": {"readonly": True},
    }

    _attribute_map = {
        "user_storage_key": {"key": "userStorageKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.user_storage_key = None


class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML resource usages.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Usage]
    :ivar next_link: The URI to fetch the next page of AML resource usage information. Call
     ListNext() with this to fetch the next page of AML resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListWorkspaceKeysResult(_serialization.Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    :ivar user_storage_resource_id:
    :vartype user_storage_resource_id: str
    :ivar app_insights_instrumentation_key:
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    :ivar notebook_access_keys:
    :vartype notebook_access_keys:
     ~azure.mgmt.machinelearningservices.models.ListNotebookKeysResult
    """

    _validation = {
        "user_storage_key": {"readonly": True},
        "user_storage_resource_id": {"readonly": True},
        "app_insights_instrumentation_key": {"readonly": True},
        "container_registry_credentials": {"readonly": True},
        "notebook_access_keys": {"readonly": True},
    }

    _attribute_map = {
        "user_storage_key": {"key": "userStorageKey", "type": "str"},
        "user_storage_resource_id": {"key": "userStorageResourceId", "type": "str"},
        "app_insights_instrumentation_key": {"key": "appInsightsInstrumentationKey", "type": "str"},
        "container_registry_credentials": {
            "key": "containerRegistryCredentials",
            "type": "RegistryListCredentialsResult",
        },
        "notebook_access_keys": {"key": "notebookAccessKeys", "type": "ListNotebookKeysResult"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.user_storage_key = None
        self.user_storage_resource_id = None
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = None
        self.notebook_access_keys = None


class ListWorkspaceQuotas(_serialization.Model):
    """The List WorkspaceQuotasByVMFamily operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Workspace Quotas by VM Family.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ResourceQuota]
    :ivar next_link: The URI to fetch the next page of workspace quota information by VM Family.
     Call ListNext() with this to fetch the next page of Workspace Quota information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class LiteralJobInput(JobInput):
    """Literal input type.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar value: [Required] Literal value for the input. Required.
    :vartype value: str
    """

    _validation = {
        "job_input_type": {"required": True},
        "value": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword value: [Required] Literal value for the input. Required.
        :paramtype value: str
        """
        super().__init__(description=description, **kwargs)
        self.job_input_type: str = "literal"
        self.value = value


class ManagedComputeIdentity(MonitorComputeIdentityBase):
    """Managed compute identity definition.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_identity_type: [Required] Specifies the type of identity to use within the
     monitoring jobs. Required. Known values are: "AmlToken" and "ManagedIdentity".
    :vartype compute_identity_type: str or
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityType
    :ivar identity: The identity which will be leveraged by the monitoring jobs.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    """

    _validation = {
        "compute_identity_type": {"required": True},
    }

    _attribute_map = {
        "compute_identity_type": {"key": "computeIdentityType", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(self, *, identity: Optional["_models.ManagedServiceIdentity"] = None, **kwargs: Any) -> None:
        """
        :keyword identity: The identity which will be leveraged by the monitoring jobs.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        """
        super().__init__(**kwargs)
        self.compute_identity_type: str = "ManagedIdentity"
        self.identity = identity


class ManagedIdentity(IdentityConfiguration):
    """Managed identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: [Required] Specifies the type of identity framework. Required. Known
     values are: "Managed", "AMLToken", and "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    :ivar client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not
     set this field.
    :vartype client_id: str
    :ivar object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not
     set this field.
    :vartype object_id: str
    :ivar resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned,
     do not set this field.
    :vartype resource_id: str
    """

    _validation = {
        "identity_type": {"required": True},
    }

    _attribute_map = {
        "identity_type": {"key": "identityType", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: Specifies a user-assigned identity by client ID. For system-assigned, do
         not set this field.
        :paramtype client_id: str
        :keyword object_id: Specifies a user-assigned identity by object ID. For system-assigned, do
         not set this field.
        :paramtype object_id: str
        :keyword resource_id: Specifies a user-assigned identity by ARM resource ID. For
         system-assigned, do not set this field.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.identity_type: str = "Managed"
        self.client_id = client_id
        self.object_id = object_id
        self.resource_id = resource_id


class WorkspaceConnectionPropertiesV2(_serialization.Model):
    """WorkspaceConnectionPropertiesV2.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ManagedIdentityAuthTypeWorkspaceConnectionProperties,
    NoneAuthTypeWorkspaceConnectionProperties, PATAuthTypeWorkspaceConnectionProperties,
    SASAuthTypeWorkspaceConnectionProperties, UsernamePasswordAuthTypeWorkspaceConnectionProperties

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Authentication type of the connection target. Required. Known values are:
     "PAT", "ManagedIdentity", "UsernamePassword", "None", and "SAS".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Known values are: "PythonFeed",
     "ContainerRegistry", and "Git".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. "JSON"
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "value_format": {"key": "valueFormat", "type": "str"},
    }

    _subtype_map = {
        "auth_type": {
            "ManagedIdentity": "ManagedIdentityAuthTypeWorkspaceConnectionProperties",
            "None": "NoneAuthTypeWorkspaceConnectionProperties",
            "PAT": "PATAuthTypeWorkspaceConnectionProperties",
            "SAS": "SASAuthTypeWorkspaceConnectionProperties",
            "UsernamePassword": "UsernamePasswordAuthTypeWorkspaceConnectionProperties",
        }
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "_models.ValueFormat"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of the connection. Known values are: "PythonFeed",
         "ContainerRegistry", and "Git".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. "JSON"
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        """
        super().__init__(**kwargs)
        self.auth_type: Optional[str] = None
        self.category = category
        self.target = target
        self.value = value
        self.value_format = value_format


class ManagedIdentityAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ManagedIdentityAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Authentication type of the connection target. Required. Known values are:
     "PAT", "ManagedIdentity", "UsernamePassword", "None", and "SAS".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Known values are: "PythonFeed",
     "ContainerRegistry", and "Git".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. "JSON"
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "value_format": {"key": "valueFormat", "type": "str"},
        "credentials": {"key": "credentials", "type": "WorkspaceConnectionManagedIdentity"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "_models.ValueFormat"]] = None,
        credentials: Optional["_models.WorkspaceConnectionManagedIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of the connection. Known values are: "PythonFeed",
         "ContainerRegistry", and "Git".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. "JSON"
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionManagedIdentity
        """
        super().__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type: str = "ManagedIdentity"
        self.credentials = credentials


class ManagedIdentityCredential(DataReferenceCredential):
    """Credential for user managed identity.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "SAS", "DockerCredentials", "ManagedIdentity", and "NoCredentials".
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.DataReferenceCredentialType
    :ivar managed_identity_type: ManagedIdentityCredential identity type.
    :vartype managed_identity_type: str
    :ivar user_managed_identity_client_id: ClientId for the UAMI. For ManagedIdentityType =
     SystemManaged, this field is null.
    :vartype user_managed_identity_client_id: str
    :ivar user_managed_identity_principal_id: PrincipalId for the UAMI. For ManagedIdentityType =
     SystemManaged, this field is null.
    :vartype user_managed_identity_principal_id: str
    :ivar user_managed_identity_resource_id: Full arm scope for the Id. For ManagedIdentityType =
     SystemManaged, this field is null.
    :vartype user_managed_identity_resource_id: str
    :ivar user_managed_identity_tenant_id: TenantId for the UAMI. For ManagedIdentityType =
     SystemManaged, this field is null.
    :vartype user_managed_identity_tenant_id: str
    """

    _validation = {
        "credential_type": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "credentialType", "type": "str"},
        "managed_identity_type": {"key": "managedIdentityType", "type": "str"},
        "user_managed_identity_client_id": {"key": "userManagedIdentityClientId", "type": "str"},
        "user_managed_identity_principal_id": {"key": "userManagedIdentityPrincipalId", "type": "str"},
        "user_managed_identity_resource_id": {"key": "userManagedIdentityResourceId", "type": "str"},
        "user_managed_identity_tenant_id": {"key": "userManagedIdentityTenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_identity_type: Optional[str] = None,
        user_managed_identity_client_id: Optional[str] = None,
        user_managed_identity_principal_id: Optional[str] = None,
        user_managed_identity_resource_id: Optional[str] = None,
        user_managed_identity_tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_identity_type: ManagedIdentityCredential identity type.
        :paramtype managed_identity_type: str
        :keyword user_managed_identity_client_id: ClientId for the UAMI. For ManagedIdentityType =
         SystemManaged, this field is null.
        :paramtype user_managed_identity_client_id: str
        :keyword user_managed_identity_principal_id: PrincipalId for the UAMI. For ManagedIdentityType
         = SystemManaged, this field is null.
        :paramtype user_managed_identity_principal_id: str
        :keyword user_managed_identity_resource_id: Full arm scope for the Id. For ManagedIdentityType
         = SystemManaged, this field is null.
        :paramtype user_managed_identity_resource_id: str
        :keyword user_managed_identity_tenant_id: TenantId for the UAMI. For ManagedIdentityType =
         SystemManaged, this field is null.
        :paramtype user_managed_identity_tenant_id: str
        """
        super().__init__(**kwargs)
        self.credential_type: str = "ManagedIdentity"
        self.managed_identity_type = managed_identity_type
        self.user_managed_identity_client_id = user_managed_identity_client_id
        self.user_managed_identity_principal_id = user_managed_identity_principal_id
        self.user_managed_identity_resource_id = user_managed_identity_resource_id
        self.user_managed_identity_tenant_id = user_managed_identity_tenant_id


class ManagedNetworkProvisionOptions(_serialization.Model):
    """Managed Network Provisioning options for managed network of a machine learning workspace.

    :ivar include_spark:
    :vartype include_spark: bool
    """

    _attribute_map = {
        "include_spark": {"key": "includeSpark", "type": "bool"},
    }

    def __init__(self, *, include_spark: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword include_spark:
        :paramtype include_spark: bool
        """
        super().__init__(**kwargs)
        self.include_spark = include_spark


class ManagedNetworkProvisionStatus(_serialization.Model):
    """Status of the Provisioning for the managed network of a machine learning workspace.

    :ivar spark_ready:
    :vartype spark_ready: bool
    :ivar status: Status for the managed network of a machine learning workspace. Known values are:
     "Inactive" and "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ManagedNetworkStatus
    """

    _attribute_map = {
        "spark_ready": {"key": "sparkReady", "type": "bool"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        spark_ready: Optional[bool] = None,
        status: Optional[Union[str, "_models.ManagedNetworkStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword spark_ready:
        :paramtype spark_ready: bool
        :keyword status: Status for the managed network of a machine learning workspace. Known values
         are: "Inactive" and "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ManagedNetworkStatus
        """
        super().__init__(**kwargs)
        self.spark_ready = spark_ready
        self.status = status


class ManagedNetworkSettings(_serialization.Model):
    """Managed Network settings for a machine learning workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar isolation_mode: Isolation mode for the managed network of a machine learning workspace.
     Known values are: "Disabled", "AllowInternetOutbound", and "AllowOnlyApprovedOutbound".
    :vartype isolation_mode: str or ~azure.mgmt.machinelearningservices.models.IsolationMode
    :ivar network_id:
    :vartype network_id: str
    :ivar outbound_rules: Dictionary of :code:`<OutboundRule>`.
    :vartype outbound_rules: dict[str, ~azure.mgmt.machinelearningservices.models.OutboundRule]
    :ivar status: Status of the Provisioning for the managed network of a machine learning
     workspace.
    :vartype status: ~azure.mgmt.machinelearningservices.models.ManagedNetworkProvisionStatus
    """

    _validation = {
        "network_id": {"readonly": True},
    }

    _attribute_map = {
        "isolation_mode": {"key": "isolationMode", "type": "str"},
        "network_id": {"key": "networkId", "type": "str"},
        "outbound_rules": {"key": "outboundRules", "type": "{OutboundRule}"},
        "status": {"key": "status", "type": "ManagedNetworkProvisionStatus"},
    }

    def __init__(
        self,
        *,
        isolation_mode: Optional[Union[str, "_models.IsolationMode"]] = None,
        outbound_rules: Optional[Dict[str, "_models.OutboundRule"]] = None,
        status: Optional["_models.ManagedNetworkProvisionStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword isolation_mode: Isolation mode for the managed network of a machine learning
         workspace. Known values are: "Disabled", "AllowInternetOutbound", and
         "AllowOnlyApprovedOutbound".
        :paramtype isolation_mode: str or ~azure.mgmt.machinelearningservices.models.IsolationMode
        :keyword outbound_rules: Dictionary of :code:`<OutboundRule>`.
        :paramtype outbound_rules: dict[str, ~azure.mgmt.machinelearningservices.models.OutboundRule]
        :keyword status: Status of the Provisioning for the managed network of a machine learning
         workspace.
        :paramtype status: ~azure.mgmt.machinelearningservices.models.ManagedNetworkProvisionStatus
        """
        super().__init__(**kwargs)
        self.isolation_mode = isolation_mode
        self.network_id = None
        self.outbound_rules = outbound_rules
        self.status = status


class ManagedOnlineDeployment(OnlineDeploymentProperties):  # pylint: disable=too-many-instance-attributes
    """Properties specific to a ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID or AssetId of the environment specification for the
     endpoint deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: [Required] The compute type of the endpoint. Required. Known
     values are: "Managed", "Kubernetes", and "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Known values are:
     "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        "endpoint_compute_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "code_configuration": {"key": "codeConfiguration", "type": "CodeConfiguration"},
        "description": {"key": "description", "type": "str"},
        "environment_id": {"key": "environmentId", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "properties": {"key": "properties", "type": "{str}"},
        "app_insights_enabled": {"key": "appInsightsEnabled", "type": "bool"},
        "egress_public_network_access": {"key": "egressPublicNetworkAccess", "type": "str"},
        "endpoint_compute_type": {"key": "endpointComputeType", "type": "str"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "liveness_probe": {"key": "livenessProbe", "type": "ProbeSettings"},
        "model": {"key": "model", "type": "str"},
        "model_mount_path": {"key": "modelMountPath", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "readiness_probe": {"key": "readinessProbe", "type": "ProbeSettings"},
        "request_settings": {"key": "requestSettings", "type": "OnlineRequestSettings"},
        "scale_settings": {"key": "scaleSettings", "type": "OnlineScaleSettings"},
    }

    def __init__(
        self,
        *,
        code_configuration: Optional["_models.CodeConfiguration"] = None,
        description: Optional[str] = None,
        environment_id: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        app_insights_enabled: bool = False,
        egress_public_network_access: Optional[Union[str, "_models.EgressPublicNetworkAccessType"]] = None,
        instance_type: Optional[str] = None,
        liveness_probe: Optional["_models.ProbeSettings"] = None,
        model: Optional[str] = None,
        model_mount_path: Optional[str] = None,
        readiness_probe: Optional["_models.ProbeSettings"] = None,
        request_settings: Optional["_models.OnlineRequestSettings"] = None,
        scale_settings: Optional["_models.OnlineScaleSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID or AssetId of the environment specification for the
         endpoint deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Known values are: "Enabled" and
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super().__init__(
            code_configuration=code_configuration,
            description=description,
            environment_id=environment_id,
            environment_variables=environment_variables,
            properties=properties,
            app_insights_enabled=app_insights_enabled,
            egress_public_network_access=egress_public_network_access,
            instance_type=instance_type,
            liveness_probe=liveness_probe,
            model=model,
            model_mount_path=model_mount_path,
            readiness_probe=readiness_probe,
            request_settings=request_settings,
            scale_settings=scale_settings,
            **kwargs
        )
        self.endpoint_compute_type: str = "Managed"


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MaterializationComputeResource(_serialization.Model):
    """DTO object representing compute resource.

    :ivar instance_type: Specifies the instance type.
    :vartype instance_type: str
    """

    _attribute_map = {
        "instance_type": {"key": "instanceType", "type": "str"},
    }

    def __init__(self, *, instance_type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword instance_type: Specifies the instance type.
        :paramtype instance_type: str
        """
        super().__init__(**kwargs)
        self.instance_type = instance_type


class MaterializationSettings(_serialization.Model):
    """MaterializationSettings.

    :ivar notification: Specifies the notification details.
    :vartype notification: ~azure.mgmt.machinelearningservices.models.NotificationSetting
    :ivar resource: Specifies the compute resource settings.
    :vartype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
    :ivar schedule: Specifies the schedule details.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceTrigger
    :ivar spark_configuration: Specifies the spark compute settings.
    :vartype spark_configuration: dict[str, str]
    :ivar store_type: Specifies the stores to which materialization should happen. Known values
     are: "None", "Online", "Offline", and "OnlineAndOffline".
    :vartype store_type: str or ~azure.mgmt.machinelearningservices.models.MaterializationStoreType
    """

    _attribute_map = {
        "notification": {"key": "notification", "type": "NotificationSetting"},
        "resource": {"key": "resource", "type": "MaterializationComputeResource"},
        "schedule": {"key": "schedule", "type": "RecurrenceTrigger"},
        "spark_configuration": {"key": "sparkConfiguration", "type": "{str}"},
        "store_type": {"key": "storeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        notification: Optional["_models.NotificationSetting"] = None,
        resource: Optional["_models.MaterializationComputeResource"] = None,
        schedule: Optional["_models.RecurrenceTrigger"] = None,
        spark_configuration: Optional[Dict[str, str]] = None,
        store_type: Optional[Union[str, "_models.MaterializationStoreType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification: Specifies the notification details.
        :paramtype notification: ~azure.mgmt.machinelearningservices.models.NotificationSetting
        :keyword resource: Specifies the compute resource settings.
        :paramtype resource: ~azure.mgmt.machinelearningservices.models.MaterializationComputeResource
        :keyword schedule: Specifies the schedule details.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceTrigger
        :keyword spark_configuration: Specifies the spark compute settings.
        :paramtype spark_configuration: dict[str, str]
        :keyword store_type: Specifies the stores to which materialization should happen. Known values
         are: "None", "Online", "Offline", and "OnlineAndOffline".
        :paramtype store_type: str or
         ~azure.mgmt.machinelearningservices.models.MaterializationStoreType
        """
        super().__init__(**kwargs)
        self.notification = notification
        self.resource = resource
        self.schedule = schedule
        self.spark_configuration = spark_configuration
        self.store_type = store_type


class MedianStoppingPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on running averages of the primary metric of all
    runs.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: [Required] Name of policy configuration. Required. Known values are:
     "Bandit", "MedianStopping", and "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        "policy_type": {"required": True},
    }

    _attribute_map = {
        "delay_evaluation": {"key": "delayEvaluation", "type": "int"},
        "evaluation_interval": {"key": "evaluationInterval", "type": "int"},
        "policy_type": {"key": "policyType", "type": "str"},
    }

    def __init__(self, *, delay_evaluation: int = 0, evaluation_interval: int = 0, **kwargs: Any) -> None:
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super().__init__(delay_evaluation=delay_evaluation, evaluation_interval=evaluation_interval, **kwargs)
        self.policy_type: str = "MedianStopping"


class MLFlowModelJobInput(AssetJobInput, JobInput):
    """MLFlowModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
     "Download", "Direct", "EvalMount", and "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "job_input_type": {"required": True},
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: str,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.InputDeliveryMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
         "Download", "Direct", "EvalMount", and "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_input_type: str = "mlflow_model"
        self.mode = mode
        self.uri = uri


class MLFlowModelJobOutput(AssetJobOutput, JobOutput):
    """MLFlowModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: [Required] Specifies the type of job. Required. Known values are:
     "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    :ivar mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _validation = {
        "job_output_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_output_type": {"key": "jobOutputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the output.
        :paramtype description: str
        :keyword mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_output_type: str = "mlflow_model"
        self.mode = mode
        self.uri = uri


class MLTableData(DataVersionBaseProperties):
    """MLTable data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: [Required] Specifies the type of data. Required. Known values are: "uri_file",
     "uri_folder", and "mltable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: [Required] Uri of the data. Example:
     https://go.microsoft.com/fwlink/?linkid=2202330. Required.
    :vartype data_uri: str
    :ivar referenced_uris: Uris referenced in the MLTable definition (required for lineage).
    :vartype referenced_uris: list[str]
    """

    _validation = {
        "data_type": {"required": True},
        "data_uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "data_type": {"key": "dataType", "type": "str"},
        "data_uri": {"key": "dataUri", "type": "str"},
        "referenced_uris": {"key": "referencedUris", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        data_uri: str,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        referenced_uris: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: [Required] Uri of the data. Example:
         https://go.microsoft.com/fwlink/?linkid=2202330. Required.
        :paramtype data_uri: str
        :keyword referenced_uris: Uris referenced in the MLTable definition (required for lineage).
        :paramtype referenced_uris: list[str]
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            data_uri=data_uri,
            **kwargs
        )
        self.data_type: str = "mltable"
        self.referenced_uris = referenced_uris


class MLTableJobInput(AssetJobInput, JobInput):
    """MLTableJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: [Required] Specifies the type of job. Required. Known values are:
     "literal", "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and
     "triton_model".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
     "Download", "Direct", "EvalMount", and "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: [Required] Input Asset URI. Required.
    :vartype uri: str
    """

    _validation = {
        "job_input_type": {"required": True},
        "uri": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_input_type": {"key": "jobInputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: str,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.InputDeliveryMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword mode: Input Asset Delivery Mode. Known values are: "ReadOnlyMount", "ReadWriteMount",
         "Download", "Direct", "EvalMount", and "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: [Required] Input Asset URI. Required.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_input_type: str = "mltable"
        self.mode = mode
        self.uri = uri


class MLTableJobOutput(AssetJobOutput, JobOutput):
    """MLTableJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: [Required] Specifies the type of job. Required. Known values are:
     "uri_file", "uri_folder", "mltable", "custom_model", "mlflow_model", and "triton_model".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    :ivar mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _validation = {
        "job_output_type": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "job_output_type": {"key": "jobOutputType", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        mode: Optional[Union[str, "_models.OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the output.
        :paramtype description: str
        :keyword mode: Output Asset Delivery Mode. Known values are: "ReadWriteMount" and "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super().__init__(mode=mode, uri=uri, description=description, **kwargs)
        self.description = description
        self.job_output_type: str = "mltable"
        self.mode = mode
        self.uri = uri


class ModelContainer(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ModelContainerProperties"},
    }

    def __init__(self, *, properties: "_models.ModelContainerProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ModelContainerProperties(AssetContainer):
    """ModelContainerProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar provisioning_state: Provisioning state for the model container. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    """

    _validation = {
        "latest_version": {"readonly": True},
        "next_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "latest_version": {"key": "latestVersion", "type": "str"},
        "next_version": {"key": "nextVersion", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_archived: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super().__init__(description=description, properties=properties, tags=tags, is_archived=is_archived, **kwargs)
        self.provisioning_state = None


class ModelContainerResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of ModelContainer entities.

    :ivar next_link: The link to the next page of ModelContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelContainer]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ModelContainer]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.ModelContainer"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of ModelContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelContainer]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ModelVersion(ProxyResource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ModelVersionProperties"},
    }

    def __init__(self, *, properties: "_models.ModelVersionProperties", **kwargs: Any) -> None:
        """
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ModelVersionProperties(AssetBase):  # pylint: disable=too-many-instance-attributes
    """Model asset version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar flavors: Mapping of model flavors to their properties.
    :vartype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
    :ivar job_name: Name of the training job which produced this model.
    :vartype job_name: str
    :ivar model_type: The storage format for this entity. Used for NCD.
    :vartype model_type: str
    :ivar model_uri: The URI path to the model contents.
    :vartype model_uri: str
    :ivar provisioning_state: Provisioning state for the model version. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.AssetProvisioningState
    :ivar stage: Stage in the model lifecycle assigned to this model.
    :vartype stage: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "is_anonymous": {"key": "isAnonymous", "type": "bool"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "flavors": {"key": "flavors", "type": "{FlavorData}"},
        "job_name": {"key": "jobName", "type": "str"},
        "model_type": {"key": "modelType", "type": "str"},
        "model_uri": {"key": "modelUri", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        is_anonymous: bool = False,
        is_archived: bool = False,
        flavors: Optional[Dict[str, "_models.FlavorData"]] = None,
        job_name: Optional[str] = None,
        model_type: Optional[str] = None,
        model_uri: Optional[str] = None,
        stage: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword flavors: Mapping of model flavors to their properties.
        :paramtype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
        :keyword job_name: Name of the training job which produced this model.
        :paramtype job_name: str
        :keyword model_type: The storage format for this entity. Used for NCD.
        :paramtype model_type: str
        :keyword model_uri: The URI path to the model contents.
        :paramtype model_uri: str
        :keyword stage: Stage in the model lifecycle assigned to this model.
        :paramtype stage: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            is_anonymous=is_anonymous,
            is_archived=is_archived,
            **kwargs
        )
        self.flavors = flavors
        self.job_name = job_name
        self.model_type = model_type
        self.model_uri = model_uri
        self.provisioning_state = None
        self.stage = stage


class ModelVersionResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of ModelVersion entities.

    :ivar next_link: The link to the next page of ModelVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelVersion]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ModelVersion]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.ModelVersion"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of ModelVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelVersion]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class MonitorComputeConfigurationBase(_serialization.Model):
    """Monitor compute configuration base definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MonitorServerlessSparkCompute

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: [Required] Specifies the type of signal to monitor. Required.
     "ServerlessSpark"
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.MonitorComputeType
    """

    _validation = {
        "compute_type": {"required": True},
    }

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
    }

    _subtype_map = {"compute_type": {"ServerlessSpark": "MonitorServerlessSparkCompute"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.compute_type: Optional[str] = None


class MonitorDefinition(_serialization.Model):
    """MonitorDefinition.

    All required parameters must be populated in order to send to Azure.

    :ivar alert_notification_settings: The monitor's notification settings.
    :vartype alert_notification_settings:
     ~azure.mgmt.machinelearningservices.models.MonitorNotificationSettings
    :ivar compute_configuration: [Required] The ARM resource ID of the compute resource to run the
     monitoring job on. Required.
    :vartype compute_configuration:
     ~azure.mgmt.machinelearningservices.models.MonitorComputeConfigurationBase
    :ivar monitoring_target: The entities targeted by the monitor.
    :vartype monitoring_target: ~azure.mgmt.machinelearningservices.models.MonitoringTarget
    :ivar signals: [Required] The signals to monitor. Required.
    :vartype signals: dict[str, ~azure.mgmt.machinelearningservices.models.MonitoringSignalBase]
    """

    _validation = {
        "compute_configuration": {"required": True},
        "signals": {"required": True},
    }

    _attribute_map = {
        "alert_notification_settings": {"key": "alertNotificationSettings", "type": "MonitorNotificationSettings"},
        "compute_configuration": {"key": "computeConfiguration", "type": "MonitorComputeConfigurationBase"},
        "monitoring_target": {"key": "monitoringTarget", "type": "MonitoringTarget"},
        "signals": {"key": "signals", "type": "{MonitoringSignalBase}"},
    }

    def __init__(
        self,
        *,
        compute_configuration: "_models.MonitorComputeConfigurationBase",
        signals: Dict[str, "_models.MonitoringSignalBase"],
        alert_notification_settings: Optional["_models.MonitorNotificationSettings"] = None,
        monitoring_target: Optional["_models.MonitoringTarget"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alert_notification_settings: The monitor's notification settings.
        :paramtype alert_notification_settings:
         ~azure.mgmt.machinelearningservices.models.MonitorNotificationSettings
        :keyword compute_configuration: [Required] The ARM resource ID of the compute resource to run
         the monitoring job on. Required.
        :paramtype compute_configuration:
         ~azure.mgmt.machinelearningservices.models.MonitorComputeConfigurationBase
        :keyword monitoring_target: The entities targeted by the monitor.
        :paramtype monitoring_target: ~azure.mgmt.machinelearningservices.models.MonitoringTarget
        :keyword signals: [Required] The signals to monitor. Required.
        :paramtype signals: dict[str, ~azure.mgmt.machinelearningservices.models.MonitoringSignalBase]
        """
        super().__init__(**kwargs)
        self.alert_notification_settings = alert_notification_settings
        self.compute_configuration = compute_configuration
        self.monitoring_target = monitoring_target
        self.signals = signals


class MonitorEmailNotificationSettings(_serialization.Model):
    """MonitorEmailNotificationSettings.

    :ivar emails: The email recipient list which has a limitation of 499 characters in total.
    :vartype emails: list[str]
    """

    _attribute_map = {
        "emails": {"key": "emails", "type": "[str]"},
    }

    def __init__(self, *, emails: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword emails: The email recipient list which has a limitation of 499 characters in total.
        :paramtype emails: list[str]
        """
        super().__init__(**kwargs)
        self.emails = emails


class MonitoringTarget(_serialization.Model):
    """Monitoring target definition.

    All required parameters must be populated in order to send to Azure.

    :ivar deployment_id: Reference to the deployment asset targeted by this monitor.
    :vartype deployment_id: str
    :ivar model_id: Reference to the model asset targeted by this monitor.
    :vartype model_id: str
    :ivar task_type: [Required] The machine learning task type of the monitored model. Required.
     Known values are: "Classification" and "Regression".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.ModelTaskType
    """

    _validation = {
        "task_type": {"required": True},
    }

    _attribute_map = {
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "model_id": {"key": "modelId", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_type: Union[str, "_models.ModelTaskType"],
        deployment_id: Optional[str] = None,
        model_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment_id: Reference to the deployment asset targeted by this monitor.
        :paramtype deployment_id: str
        :keyword model_id: Reference to the model asset targeted by this monitor.
        :paramtype model_id: str
        :keyword task_type: [Required] The machine learning task type of the monitored model. Required.
         Known values are: "Classification" and "Regression".
        :paramtype task_type: str or ~azure.mgmt.machinelearningservices.models.ModelTaskType
        """
        super().__init__(**kwargs)
        self.deployment_id = deployment_id
        self.model_id = model_id
        self.task_type = task_type


class MonitoringThreshold(_serialization.Model):
    """MonitoringThreshold.

    :ivar value: The threshold value. If null, the set default is dependent on the metric type.
    :vartype value: float
    """

    _attribute_map = {
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, value: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword value: The threshold value. If null, the set default is dependent on the metric type.
        :paramtype value: float
        """
        super().__init__(**kwargs)
        self.value = value


class MonitorNotificationSettings(_serialization.Model):
    """MonitorNotificationSettings.

    :ivar email_notification_settings: The AML notification email settings.
    :vartype email_notification_settings:
     ~azure.mgmt.machinelearningservices.models.MonitorEmailNotificationSettings
    """

    _attribute_map = {
        "email_notification_settings": {"key": "emailNotificationSettings", "type": "MonitorEmailNotificationSettings"},
    }

    def __init__(
        self, *, email_notification_settings: Optional["_models.MonitorEmailNotificationSettings"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword email_notification_settings: The AML notification email settings.
        :paramtype email_notification_settings:
         ~azure.mgmt.machinelearningservices.models.MonitorEmailNotificationSettings
        """
        super().__init__(**kwargs)
        self.email_notification_settings = email_notification_settings


class MonitorServerlessSparkCompute(MonitorComputeConfigurationBase):
    """Monitor serverless spark compute definition.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: [Required] Specifies the type of signal to monitor. Required.
     "ServerlessSpark"
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.MonitorComputeType
    :ivar compute_identity: [Required] The identity scheme leveraged to by the spark jobs running
     on serverless Spark. Required.
    :vartype compute_identity:
     ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityBase
    :ivar instance_type: [Required] The instance type running the Spark job. Required.
    :vartype instance_type: str
    :ivar runtime_version: [Required] The Spark runtime version. Required.
    :vartype runtime_version: str
    """

    _validation = {
        "compute_type": {"required": True},
        "compute_identity": {"required": True},
        "instance_type": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
        "runtime_version": {"required": True, "min_length": 1, "pattern": r"^[0-9]+\.[0-9]+$"},
    }

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
        "compute_identity": {"key": "computeIdentity", "type": "MonitorComputeIdentityBase"},
        "instance_type": {"key": "instanceType", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        compute_identity: "_models.MonitorComputeIdentityBase",
        instance_type: str,
        runtime_version: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_identity: [Required] The identity scheme leveraged to by the spark jobs
         running on serverless Spark. Required.
        :paramtype compute_identity:
         ~azure.mgmt.machinelearningservices.models.MonitorComputeIdentityBase
        :keyword instance_type: [Required] The instance type running the Spark job. Required.
        :paramtype instance_type: str
        :keyword runtime_version: [Required] The Spark runtime version. Required.
        :paramtype runtime_version: str
        """
        super().__init__(**kwargs)
        self.compute_type: str = "ServerlessSpark"
        self.compute_identity = compute_identity
        self.instance_type = instance_type
        self.runtime_version = runtime_version


class Mpi(DistributionConfiguration):
    """MPI distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: [Required] Specifies the type of distribution framework. Required.
     Known values are: "PyTorch", "TensorFlow", and "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per MPI node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        "distribution_type": {"required": True},
    }

    _attribute_map = {
        "distribution_type": {"key": "distributionType", "type": "str"},
        "process_count_per_instance": {"key": "processCountPerInstance", "type": "int"},
    }

    def __init__(self, *, process_count_per_instance: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword process_count_per_instance: Number of processes per MPI node.
        :paramtype process_count_per_instance: int
        """
        super().__init__(**kwargs)
        self.distribution_type: str = "Mpi"
        self.process_count_per_instance = process_count_per_instance


class NlpVertical(_serialization.Model):
    """Abstract class for NLP related AutoML tasks.
    NLP - Natural Language Processing.

    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _attribute_map = {
        "featurization_settings": {"key": "featurizationSettings", "type": "NlpVerticalFeaturizationSettings"},
        "limit_settings": {"key": "limitSettings", "type": "NlpVerticalLimitSettings"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
    }

    def __init__(
        self,
        *,
        featurization_settings: Optional["_models.NlpVerticalFeaturizationSettings"] = None,
        limit_settings: Optional["_models.NlpVerticalLimitSettings"] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super().__init__(**kwargs)
        self.featurization_settings = featurization_settings
        self.limit_settings = limit_settings
        self.validation_data = validation_data


class NlpVerticalFeaturizationSettings(FeaturizationSettings):
    """NlpVerticalFeaturizationSettings.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        "dataset_language": {"key": "datasetLanguage", "type": "str"},
    }

    def __init__(self, *, dataset_language: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super().__init__(dataset_language=dataset_language, **kwargs)


class NlpVerticalLimitSettings(_serialization.Model):
    """Job execution constraints.

    :ivar max_concurrent_trials: Maximum Concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        "max_concurrent_trials": {"key": "maxConcurrentTrials", "type": "int"},
        "max_trials": {"key": "maxTrials", "type": "int"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    def __init__(
        self, *, max_concurrent_trials: int = 1, max_trials: int = 1, timeout: datetime.timedelta = "P7D", **kwargs: Any
    ) -> None:
        """
        :keyword max_concurrent_trials: Maximum Concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.max_concurrent_trials = max_concurrent_trials
        self.max_trials = max_trials
        self.timeout = timeout


class NodeStateCounts(_serialization.Model):
    """Counts of various compute node states on the amlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar idle_node_count: Number of compute nodes in idle state.
    :vartype idle_node_count: int
    :ivar running_node_count: Number of compute nodes which are running jobs.
    :vartype running_node_count: int
    :ivar preparing_node_count: Number of compute nodes which are being prepared.
    :vartype preparing_node_count: int
    :ivar unusable_node_count: Number of compute nodes which are in unusable state.
    :vartype unusable_node_count: int
    :ivar leaving_node_count: Number of compute nodes which are leaving the amlCompute.
    :vartype leaving_node_count: int
    :ivar preempted_node_count: Number of compute nodes which are in preempted state.
    :vartype preempted_node_count: int
    """

    _validation = {
        "idle_node_count": {"readonly": True},
        "running_node_count": {"readonly": True},
        "preparing_node_count": {"readonly": True},
        "unusable_node_count": {"readonly": True},
        "leaving_node_count": {"readonly": True},
        "preempted_node_count": {"readonly": True},
    }

    _attribute_map = {
        "idle_node_count": {"key": "idleNodeCount", "type": "int"},
        "running_node_count": {"key": "runningNodeCount", "type": "int"},
        "preparing_node_count": {"key": "preparingNodeCount", "type": "int"},
        "unusable_node_count": {"key": "unusableNodeCount", "type": "int"},
        "leaving_node_count": {"key": "leavingNodeCount", "type": "int"},
        "preempted_node_count": {"key": "preemptedNodeCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.idle_node_count = None
        self.running_node_count = None
        self.preparing_node_count = None
        self.unusable_node_count = None
        self.leaving_node_count = None
        self.preempted_node_count = None


class NoneAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """NoneAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Authentication type of the connection target. Required. Known values are:
     "PAT", "ManagedIdentity", "UsernamePassword", "None", and "SAS".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Known values are: "PythonFeed",
     "ContainerRegistry", and "Git".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. "JSON"
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "value_format": {"key": "valueFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "_models.ValueFormat"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of the connection. Known values are: "PythonFeed",
         "ContainerRegistry", and "Git".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. "JSON"
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        """
        super().__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type: str = "None"


class NoneDatastoreCredentials(DatastoreCredentials):
    """Empty/none datastore credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: [Required] Credential type used to authentication with storage.
     Required. Known values are: "AccountKey", "Certificate", "None", "Sas", and "ServicePrincipal".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        "credentials_type": {"required": True},
    }

    _attribute_map = {
        "credentials_type": {"key": "credentialsType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.credentials_type: str = "None"


class NotebookAccessTokenResult(_serialization.Model):
    """NotebookAccessTokenResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar notebook_resource_id:
    :vartype notebook_resource_id: str
    :ivar host_name:
    :vartype host_name: str
    :ivar public_dns:
    :vartype public_dns: str
    :ivar access_token:
    :vartype access_token: str
    :ivar token_type:
    :vartype token_type: str
    :ivar expires_in:
    :vartype expires_in: int
    :ivar refresh_token:
    :vartype refresh_token: str
    :ivar scope:
    :vartype scope: str
    """

    _validation = {
        "notebook_resource_id": {"readonly": True},
        "host_name": {"readonly": True},
        "public_dns": {"readonly": True},
        "access_token": {"readonly": True},
        "token_type": {"readonly": True},
        "expires_in": {"readonly": True},
        "refresh_token": {"readonly": True},
        "scope": {"readonly": True},
    }

    _attribute_map = {
        "notebook_resource_id": {"key": "notebookResourceId", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "public_dns": {"key": "publicDns", "type": "str"},
        "access_token": {"key": "accessToken", "type": "str"},
        "token_type": {"key": "tokenType", "type": "str"},
        "expires_in": {"key": "expiresIn", "type": "int"},
        "refresh_token": {"key": "refreshToken", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.notebook_resource_id = None
        self.host_name = None
        self.public_dns = None
        self.access_token = None
        self.token_type = None
        self.expires_in = None
        self.refresh_token = None
        self.scope = None


class NotebookPreparationError(_serialization.Model):
    """NotebookPreparationError.

    :ivar error_message:
    :vartype error_message: str
    :ivar status_code:
    :vartype status_code: int
    """

    _attribute_map = {
        "error_message": {"key": "errorMessage", "type": "str"},
        "status_code": {"key": "statusCode", "type": "int"},
    }

    def __init__(
        self, *, error_message: Optional[str] = None, status_code: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error_message:
        :paramtype error_message: str
        :keyword status_code:
        :paramtype status_code: int
        """
        super().__init__(**kwargs)
        self.error_message = error_message
        self.status_code = status_code


class NotebookResourceInfo(_serialization.Model):
    """NotebookResourceInfo.

    :ivar fqdn:
    :vartype fqdn: str
    :ivar resource_id: the data plane resourceId that used to initialize notebook component.
    :vartype resource_id: str
    :ivar notebook_preparation_error: The error that occurs when preparing notebook.
    :vartype notebook_preparation_error:
     ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "notebook_preparation_error": {"key": "notebookPreparationError", "type": "NotebookPreparationError"},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        resource_id: Optional[str] = None,
        notebook_preparation_error: Optional["_models.NotebookPreparationError"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword fqdn:
        :paramtype fqdn: str
        :keyword resource_id: the data plane resourceId that used to initialize notebook component.
        :paramtype resource_id: str
        :keyword notebook_preparation_error: The error that occurs when preparing notebook.
        :paramtype notebook_preparation_error:
         ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.resource_id = resource_id
        self.notebook_preparation_error = notebook_preparation_error


class NotificationSetting(_serialization.Model):
    """Configuration for notification.

    :ivar email_on: Send email notification to user on specified notification type.
    :vartype email_on: list[str or
     ~azure.mgmt.machinelearningservices.models.EmailNotificationEnableType]
    :ivar emails: This is the email recipient list which has a limitation of 499 characters in
     total concat with comma separator.
    :vartype emails: list[str]
    :ivar webhooks: Send webhook callback to a service. Key is a user-provided name for the
     webhook.
    :vartype webhooks: dict[str, ~azure.mgmt.machinelearningservices.models.Webhook]
    """

    _attribute_map = {
        "email_on": {"key": "emailOn", "type": "[str]"},
        "emails": {"key": "emails", "type": "[str]"},
        "webhooks": {"key": "webhooks", "type": "{Webhook}"},
    }

    def __init__(
        self,
        *,
        email_on: Optional[List[Union[str, "_models.EmailNotificationEnableType"]]] = None,
        emails: Optional[List[str]] = None,
        webhooks: Optional[Dict[str, "_models.Webhook"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword email_on: Send email notification to user on specified notification type.
        :paramtype email_on: list[str or
         ~azure.mgmt.machinelearningservices.models.EmailNotificationEnableType]
        :keyword emails: This is the email recipient list which has a limitation of 499 characters in
         total concat with comma separator.
        :paramtype emails: list[str]
        :keyword webhooks: Send webhook callback to a service. Key is a user-provided name for the
         webhook.
        :paramtype webhooks: dict[str, ~azure.mgmt.machinelearningservices.models.Webhook]
        """
        super().__init__(**kwargs)
        self.email_on = email_on
        self.emails = emails
        self.webhooks = webhooks


class NumericalDataDriftMetricThreshold(DataDriftMetricThresholdBase):
    """NumericalDataDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The numerical data drift metric to calculate. Required. Known values
     are: "JensenShannonDistance", "PopulationStabilityIndex", "NormalizedWassersteinDistance", and
     "TwoSampleKolmogorovSmirnovTest".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.NumericalDataDriftMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.NumericalDataDriftMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The numerical data drift metric to calculate. Required. Known
         values are: "JensenShannonDistance", "PopulationStabilityIndex",
         "NormalizedWassersteinDistance", and "TwoSampleKolmogorovSmirnovTest".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.NumericalDataDriftMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Numerical"
        self.metric = metric


class NumericalDataQualityMetricThreshold(DataQualityMetricThresholdBase):
    """NumericalDataQualityMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The numerical data quality metric to calculate. Required. Known values
     are: "NullValueRate", "DataTypeErrorRate", and "OutOfBoundsRate".
    :vartype metric: str or ~azure.mgmt.machinelearningservices.models.NumericalDataQualityMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.NumericalDataQualityMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The numerical data quality metric to calculate. Required. Known
         values are: "NullValueRate", "DataTypeErrorRate", and "OutOfBoundsRate".
        :paramtype metric: str or ~azure.mgmt.machinelearningservices.models.NumericalDataQualityMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Numerical"
        self.metric = metric


class NumericalPredictionDriftMetricThreshold(PredictionDriftMetricThresholdBase):
    """NumericalPredictionDriftMetricThreshold.

    All required parameters must be populated in order to send to Azure.

    :ivar data_type: [Required] Specifies the data type of the metric threshold. Required. Known
     values are: "Numerical" and "Categorical".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType
    :ivar threshold: The threshold value. If null, a default value will be set depending on the
     selected metric.
    :vartype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
    :ivar metric: [Required] The numerical prediction drift metric to calculate. Required. Known
     values are: "JensenShannonDistance", "PopulationStabilityIndex",
     "NormalizedWassersteinDistance", and "TwoSampleKolmogorovSmirnovTest".
    :vartype metric: str or
     ~azure.mgmt.machinelearningservices.models.NumericalPredictionDriftMetric
    """

    _validation = {
        "data_type": {"required": True},
        "metric": {"required": True},
    }

    _attribute_map = {
        "data_type": {"key": "dataType", "type": "str"},
        "threshold": {"key": "threshold", "type": "MonitoringThreshold"},
        "metric": {"key": "metric", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric: Union[str, "_models.NumericalPredictionDriftMetric"],
        threshold: Optional["_models.MonitoringThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold: The threshold value. If null, a default value will be set depending on the
         selected metric.
        :paramtype threshold: ~azure.mgmt.machinelearningservices.models.MonitoringThreshold
        :keyword metric: [Required] The numerical prediction drift metric to calculate. Required. Known
         values are: "JensenShannonDistance", "PopulationStabilityIndex",
         "NormalizedWassersteinDistance", and "TwoSampleKolmogorovSmirnovTest".
        :paramtype metric: str or
         ~azure.mgmt.machinelearningservices.models.NumericalPredictionDriftMetric
        """
        super().__init__(threshold=threshold, **kwargs)
        self.data_type: str = "Numerical"
        self.metric = metric


class Objective(_serialization.Model):
    """Optimization objective.

    All required parameters must be populated in order to send to Azure.

    :ivar goal: [Required] Defines supported metric goals for hyperparameter tuning. Required.
     Known values are: "Minimize" and "Maximize".
    :vartype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
    :ivar primary_metric: [Required] Name of the metric to optimize. Required.
    :vartype primary_metric: str
    """

    _validation = {
        "goal": {"required": True},
        "primary_metric": {"required": True, "min_length": 1, "pattern": r"[a-zA-Z0-9_]"},
    }

    _attribute_map = {
        "goal": {"key": "goal", "type": "str"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
    }

    def __init__(self, *, goal: Union[str, "_models.Goal"], primary_metric: str, **kwargs: Any) -> None:
        """
        :keyword goal: [Required] Defines supported metric goals for hyperparameter tuning. Required.
         Known values are: "Minimize" and "Maximize".
        :paramtype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
        :keyword primary_metric: [Required] Name of the metric to optimize. Required.
        :paramtype primary_metric: str
        """
        super().__init__(**kwargs)
        self.goal = goal
        self.primary_metric = primary_metric


class OnlineDeployment(TrackedResource):
    """OnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "OnlineDeploymentProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.OnlineDeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class OnlineDeploymentTrackedResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of OnlineDeployment entities.

    :ivar next_link: The link to the next page of OnlineDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeployment]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OnlineDeployment]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.OnlineDeployment"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of OnlineDeployment objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeployment]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineEndpoint(TrackedResource):
    """OnlineEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: [Required] Additional attributes of the entity. Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointProperties
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "properties": {"key": "properties", "type": "OnlineEndpointProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.OnlineEndpointProperties",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: [Required] Additional attributes of the entity. Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointProperties
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.properties = properties
        self.sku = sku


class OnlineEndpointProperties(EndpointPropertiesBase):  # pylint: disable=too-many-instance-attributes
    """Online endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
     Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Required. Known values are: "AMLToken", "Key", and "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar compute: ARM resource ID of the compute if it exists.
     optional.
    :vartype compute: str
    :ivar mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
     returned scoring. Traffic values need to sum to utmost 50.
    :vartype mirror_traffic: dict[str, int]
    :ivar provisioning_state: Provisioning state for the endpoint. Known values are: "Creating",
     "Deleting", "Succeeded", "Failed", "Updating", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    :ivar public_network_access: Set to "Enabled" for endpoints that should allow public access
     when Private Link is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values
     need to sum to 100.
    :vartype traffic: dict[str, int]
    """

    _validation = {
        "auth_mode": {"required": True},
        "scoring_uri": {"readonly": True},
        "swagger_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "auth_mode": {"key": "authMode", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "keys": {"key": "keys", "type": "EndpointAuthKeys"},
        "properties": {"key": "properties", "type": "{str}"},
        "scoring_uri": {"key": "scoringUri", "type": "str"},
        "swagger_uri": {"key": "swaggerUri", "type": "str"},
        "compute": {"key": "compute", "type": "str"},
        "mirror_traffic": {"key": "mirrorTraffic", "type": "{int}"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "traffic": {"key": "traffic", "type": "{int}"},
    }

    def __init__(
        self,
        *,
        auth_mode: Union[str, "_models.EndpointAuthMode"],
        description: Optional[str] = None,
        keys: Optional["_models.EndpointAuthKeys"] = None,
        properties: Optional[Dict[str, str]] = None,
        compute: Optional[str] = None,
        mirror_traffic: Optional[Dict[str, int]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccessType"]] = None,
        traffic: Optional[Dict[str, int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure
         Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
         Required. Known values are: "AMLToken", "Key", and "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: ARM resource ID of the compute if it exists.
         optional.
        :paramtype compute: str
        :keyword mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
         returned scoring. Traffic values need to sum to utmost 50.
        :paramtype mirror_traffic: dict[str, int]
        :keyword public_network_access: Set to "Enabled" for endpoints that should allow public access
         when Private Link is enabled. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic
         values need to sum to 100.
        :paramtype traffic: dict[str, int]
        """
        super().__init__(auth_mode=auth_mode, description=description, keys=keys, properties=properties, **kwargs)
        self.compute = compute
        self.mirror_traffic = mirror_traffic
        self.provisioning_state = None
        self.public_network_access = public_network_access
        self.traffic = traffic


class OnlineEndpointTrackedResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of OnlineEndpoint entities.

    :ivar next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpoint]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OnlineEndpoint]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.OnlineEndpoint"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpoint]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OnlineRequestSettings(_serialization.Model):
    """Online deployment scoring requests configuration.

    :ivar max_concurrent_requests_per_instance: The number of maximum concurrent requests per node
     allowed per deployment. Defaults to 1.
    :vartype max_concurrent_requests_per_instance: int
    :ivar max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601
     format.
     Defaults to 500ms.
    :vartype max_queue_wait: ~datetime.timedelta
    :ivar request_timeout: The scoring timeout in ISO 8601 format.
     Defaults to 5000ms.
    :vartype request_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        "max_concurrent_requests_per_instance": {"key": "maxConcurrentRequestsPerInstance", "type": "int"},
        "max_queue_wait": {"key": "maxQueueWait", "type": "duration"},
        "request_timeout": {"key": "requestTimeout", "type": "duration"},
    }

    def __init__(
        self,
        *,
        max_concurrent_requests_per_instance: int = 1,
        max_queue_wait: datetime.timedelta = "PT0.5S",
        request_timeout: datetime.timedelta = "PT5S",
        **kwargs: Any
    ) -> None:
        """
        :keyword max_concurrent_requests_per_instance: The number of maximum concurrent requests per
         node allowed per deployment. Defaults to 1.
        :paramtype max_concurrent_requests_per_instance: int
        :keyword max_queue_wait: The maximum amount of time a request will stay in the queue in ISO
         8601 format.
         Defaults to 500ms.
        :paramtype max_queue_wait: ~datetime.timedelta
        :keyword request_timeout: The scoring timeout in ISO 8601 format.
         Defaults to 5000ms.
        :paramtype request_timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.max_concurrent_requests_per_instance = max_concurrent_requests_per_instance
        self.max_queue_wait = max_queue_wait
        self.request_timeout = request_timeout


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.machinelearningservices.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.machinelearningservices.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OutboundRuleBasicResource(Resource):
    """Outbound Rule Basic Resource for the managed network of a machine learning workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Outbound Rule for the managed network of a machine learning workspace.
     Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OutboundRule
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "OutboundRule"},
    }

    def __init__(self, *, properties: "_models.OutboundRule", **kwargs: Any) -> None:
        """
        :keyword properties: Outbound Rule for the managed network of a machine learning workspace.
         Required.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OutboundRule
        """
        super().__init__(**kwargs)
        self.properties = properties


class OutboundRuleListResult(_serialization.Model):
    """List of outbound rules for the managed network of a machine learning workspace.

    :ivar next_link: The link to the next page constructed using the continuationToken.  If null,
     there are no additional pages.
    :vartype next_link: str
    :ivar value: The list of machine learning workspaces. Since this list may be incomplete, the
     nextLink field should be used to request the next list of machine learning workspaces.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OutboundRuleBasicResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OutboundRuleBasicResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.OutboundRuleBasicResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page constructed using the continuationToken.  If
         null, there are no additional pages.
        :paramtype next_link: str
        :keyword value: The list of machine learning workspaces. Since this list may be incomplete, the
         nextLink field should be used to request the next list of machine learning workspaces.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OutboundRuleBasicResource]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OutputPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: [Required] Specifies the type of asset reference. Required. Known values
     are: "Id", "DataPath", and "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        "reference_type": {"required": True},
    }

    _attribute_map = {
        "reference_type": {"key": "referenceType", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, job_id: Optional[str] = None, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.reference_type: str = "OutputPath"
        self.job_id = job_id
        self.path = path


class PaginatedComputeResourcesList(_serialization.Model):
    """Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.

    :ivar value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
    :ivar next_link: A continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ComputeResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ComputeResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
        :keyword next_link: A continuation link (absolute URI) to the next page of results in the list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartialBatchDeployment(_serialization.Model):
    """Mutable batch inference settings per deployment.

    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.description = description


class PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties(_serialization.Model):
    """Strictly used in update requests.

    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "PartialBatchDeployment"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.PartialBatchDeployment"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class PartialManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar type: Managed service identity (system assigned and/or user assigned identities). Known
     values are: "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, JSON]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Managed service identity (system assigned and/or user assigned identities).
         Known values are: "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class PartialMinimalTrackedResource(_serialization.Model):
    """Strictly used in update requests.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class PartialMinimalTrackedResourceWithIdentity(PartialMinimalTrackedResource):
    """Strictly used in update requests.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "PartialManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.PartialManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        """
        super().__init__(tags=tags, **kwargs)
        self.identity = identity


class PartialMinimalTrackedResourceWithSku(PartialMinimalTrackedResource):
    """Strictly used in update requests.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "PartialSku"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.PartialSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku


class PartialRegistryPartialTrackedResource(_serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity:
     ~azure.mgmt.machinelearningservices.models.RegistryPartialManagedServiceIdentity
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "RegistryPartialManagedServiceIdentity"},
        "sku": {"key": "sku", "type": "PartialSku"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.RegistryPartialManagedServiceIdentity"] = None,
        sku: Optional["_models.PartialSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity:
         ~azure.mgmt.machinelearningservices.models.RegistryPartialManagedServiceIdentity
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags


class PartialSku(_serialization.Model):
    """Common SKU definition.

    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _attribute_map = {
        "capacity": {"key": "capacity", "type": "int"},
        "family": {"key": "family", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        capacity: Optional[int] = None,
        family: Optional[str] = None,
        name: Optional[str] = None,
        size: Optional[str] = None,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
         "Standard", and "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super().__init__(**kwargs)
        self.capacity = capacity
        self.family = family
        self.name = name
        self.size = size
        self.tier = tier


class Password(_serialization.Model):
    """Password.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class PATAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """PATAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Authentication type of the connection target. Required. Known values are:
     "PAT", "ManagedIdentity", "UsernamePassword", "None", and "SAS".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Known values are: "PythonFeed",
     "ContainerRegistry", and "Git".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. "JSON"
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar credentials:
    :vartype credentials:
     ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
    """

    _validation = {
        "auth_type": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "value_format": {"key": "valueFormat", "type": "str"},
        "credentials": {"key": "credentials", "type": "WorkspaceConnectionPersonalAccessToken"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "_models.ValueFormat"]] = None,
        credentials: Optional["_models.WorkspaceConnectionPersonalAccessToken"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of the connection. Known values are: "PythonFeed",
         "ContainerRegistry", and "Git".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. "JSON"
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword credentials:
        :paramtype credentials:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPersonalAccessToken
        """
        super().__init__(category=category, target=target, value=value, value_format=value_format, **kwargs)
        self.auth_type: str = "PAT"
        self.credentials = credentials


class PendingUploadCredentialDto(_serialization.Model):
    """PendingUploadCredentialDto.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SASCredentialDto

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: [Required] Credential type used to authentication with storage.
     Required. "SAS"
    :vartype credential_type: str or
     ~azure.mgmt.machinelearningservices.models.PendingUploadCredentialType
    """

    _validation = {
        "credential_type": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "credentialType", "type": "str"},
    }

    _subtype_map = {"credential_type": {"SAS": "SASCredentialDto"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.credential_type: Optional[str] = None


class PendingUploadRequestDto(_serialization.Model):
    """PendingUploadRequestDto.

    :ivar pending_upload_id: If PendingUploadId = null then random guid will be used.
    :vartype pending_upload_id: str
    :ivar pending_upload_type: TemporaryBlobReference is the only supported type. Known values are:
     "None" and "TemporaryBlobReference".
    :vartype pending_upload_type: str or
     ~azure.mgmt.machinelearningservices.models.PendingUploadType
    """

    _attribute_map = {
        "pending_upload_id": {"key": "pendingUploadId", "type": "str"},
        "pending_upload_type": {"key": "pendingUploadType", "type": "str"},
    }

    def __init__(
        self,
        *,
        pending_upload_id: Optional[str] = None,
        pending_upload_type: Optional[Union[str, "_models.PendingUploadType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pending_upload_id: If PendingUploadId = null then random guid will be used.
        :paramtype pending_upload_id: str
        :keyword pending_upload_type: TemporaryBlobReference is the only supported type. Known values
         are: "None" and "TemporaryBlobReference".
        :paramtype pending_upload_type: str or
         ~azure.mgmt.machinelearningservices.models.PendingUploadType
        """
        super().__init__(**kwargs)
        self.pending_upload_id = pending_upload_id
        self.pending_upload_type = pending_upload_type


class PendingUploadResponseDto(_serialization.Model):
    """PendingUploadResponseDto.

    :ivar blob_reference_for_consumption: Container level read, write, list SAS.
    :vartype blob_reference_for_consumption:
     ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto
    :ivar pending_upload_id: ID for this upload request.
    :vartype pending_upload_id: str
    :ivar pending_upload_type: TemporaryBlobReference is the only supported type. Known values are:
     "None" and "TemporaryBlobReference".
    :vartype pending_upload_type: str or
     ~azure.mgmt.machinelearningservices.models.PendingUploadType
    """

    _attribute_map = {
        "blob_reference_for_consumption": {
            "key": "blobReferenceForConsumption",
            "type": "BlobReferenceForConsumptionDto",
        },
        "pending_upload_id": {"key": "pendingUploadId", "type": "str"},
        "pending_upload_type": {"key": "pendingUploadType", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_reference_for_consumption: Optional["_models.BlobReferenceForConsumptionDto"] = None,
        pending_upload_id: Optional[str] = None,
        pending_upload_type: Optional[Union[str, "_models.PendingUploadType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_reference_for_consumption: Container level read, write, list SAS.
        :paramtype blob_reference_for_consumption:
         ~azure.mgmt.machinelearningservices.models.BlobReferenceForConsumptionDto
        :keyword pending_upload_id: ID for this upload request.
        :paramtype pending_upload_id: str
        :keyword pending_upload_type: TemporaryBlobReference is the only supported type. Known values
         are: "None" and "TemporaryBlobReference".
        :paramtype pending_upload_type: str or
         ~azure.mgmt.machinelearningservices.models.PendingUploadType
        """
        super().__init__(**kwargs)
        self.blob_reference_for_consumption = blob_reference_for_consumption
        self.pending_upload_id = pending_upload_id
        self.pending_upload_type = pending_upload_type


class PersonalComputeInstanceSettings(_serialization.Model):
    """Settings for a personal compute instance.

    :ivar assigned_user: A user explicitly assigned to a personal compute instance.
    :vartype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
    """

    _attribute_map = {
        "assigned_user": {"key": "assignedUser", "type": "AssignedUser"},
    }

    def __init__(self, *, assigned_user: Optional["_models.AssignedUser"] = None, **kwargs: Any) -> None:
        """
        :keyword assigned_user: A user explicitly assigned to a personal compute instance.
        :paramtype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
        """
        super().__init__(**kwargs)
        self.assigned_user = assigned_user


class PipelineJob(JobBaseProperties):  # pylint: disable=too-many-instance-attributes
    """Pipeline Job definition: defines generic to MFE attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar component_id: ARM resource ID of the component resource.
    :vartype component_id: str
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: [Required] Specifies the type of job. Required. Known values are: "AutoML",
     "Command", "Sweep", and "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Known values are: "NotStarted", "Starting", "Provisioning",
     "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed", "Failed",
     "Canceled", "NotResponding", "Paused", and "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar inputs: Inputs for the pipeline job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar jobs: Jobs construct the Pipeline Job.
    :vartype jobs: dict[str, JSON]
    :ivar outputs: Outputs for the pipeline job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
    :vartype settings: JSON
    :ivar source_job_id: ARM resource ID of source job.
    :vartype source_job_id: str
    """

    _validation = {
        "job_type": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
        "tags": {"key": "tags", "type": "{str}"},
        "component_id": {"key": "componentId", "type": "str"},
        "compute_id": {"key": "computeId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "experiment_name": {"key": "experimentName", "type": "str"},
        "identity": {"key": "identity", "type": "IdentityConfiguration"},
        "is_archived": {"key": "isArchived", "type": "bool"},
        "job_type": {"key": "jobType", "type": "str"},
        "services": {"key": "services", "type": "{JobService}"},
        "status": {"key": "status", "type": "str"},
        "inputs": {"key": "inputs", "type": "{JobInput}"},
        "jobs": {"key": "jobs", "type": "{object}"},
        "outputs": {"key": "outputs", "type": "{JobOutput}"},
        "settings": {"key": "settings", "type": "object"},
        "source_job_id": {"key": "sourceJobId", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        component_id: Optional[str] = None,
        compute_id: Optional[str] = None,
        display_name: Optional[str] = None,
        experiment_name: str = "Default",
        identity: Optional["_models.IdentityConfiguration"] = None,
        is_archived: bool = False,
        services: Optional[Dict[str, "_models.JobService"]] = None,
        inputs: Optional[Dict[str, "_models.JobInput"]] = None,
        jobs: Optional[Dict[str, JSON]] = None,
        outputs: Optional[Dict[str, "_models.JobOutput"]] = None,
        settings: Optional[JSON] = None,
        source_job_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword component_id: ARM resource ID of the component resource.
        :paramtype component_id: str
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword inputs: Inputs for the pipeline job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword jobs: Jobs construct the Pipeline Job.
        :paramtype jobs: dict[str, JSON]
        :keyword outputs: Outputs for the pipeline job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :paramtype settings: JSON
        :keyword source_job_id: ARM resource ID of source job.
        :paramtype source_job_id: str
        """
        super().__init__(
            description=description,
            properties=properties,
            tags=tags,
            component_id=component_id,
            compute_id=compute_id,
            display_name=display_name,
            experiment_name=experiment_name,
            identity=identity,
            is_archived=is_archived,
            services=services,
            **kwargs
        )
        self.job_type: str = "Pipeline"
        self.inputs = inputs
        self.jobs = jobs
        self.outputs = outputs
        self.settings = settings
        self.source_job_id = source_job_id


class PredictionDriftMonitoringSignal(MonitoringSignalBase):
    """PredictionDriftMonitoringSignal.

    All required parameters must be populated in order to send to Azure.

    :ivar notification_types: The current notification mode for this signal.
    :vartype notification_types: list[str or
     ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar signal_type: [Required] Specifies the type of signal to monitor. Required. Known values
     are: "DataDrift", "PredictionDrift", "DataQuality", "FeatureAttributionDrift", and "Custom".
    :vartype signal_type: str or ~azure.mgmt.machinelearningservices.models.MonitoringSignalType
    :ivar feature_data_type_override: A dictionary that maps feature names to their respective data
     types.
    :vartype feature_data_type_override: dict[str, str or
     ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
    :ivar metric_thresholds: [Required] A list of metrics to calculate and their associated
     thresholds. Required.
    :vartype metric_thresholds:
     list[~azure.mgmt.machinelearningservices.models.PredictionDriftMetricThresholdBase]
    :ivar production_data: [Required] The data which drift will be calculated for. Required.
    :vartype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    :ivar reference_data: [Required] The data to calculate drift against. Required.
    :vartype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
    """

    _validation = {
        "signal_type": {"required": True},
        "metric_thresholds": {"required": True},
        "production_data": {"required": True},
        "reference_data": {"required": True},
    }

    _attribute_map = {
        "notification_types": {"key": "notificationTypes", "type": "[str]"},
        "properties": {"key": "properties", "type": "{str}"},
        "signal_type": {"key": "signalType", "type": "str"},
        "feature_data_type_override": {"key": "featureDataTypeOverride", "type": "{str}"},
        "metric_thresholds": {"key": "metricThresholds", "type": "[PredictionDriftMetricThresholdBase]"},
        "production_data": {"key": "productionData", "type": "MonitoringInputDataBase"},
        "reference_data": {"key": "referenceData", "type": "MonitoringInputDataBase"},
    }

    def __init__(
        self,
        *,
        metric_thresholds: List["_models.PredictionDriftMetricThresholdBase"],
        production_data: "_models.MonitoringInputDataBase",
        reference_data: "_models.MonitoringInputDataBase",
        notification_types: Optional[List[Union[str, "_models.MonitoringNotificationType"]]] = None,
        properties: Optional[Dict[str, str]] = None,
        feature_data_type_override: Optional[Dict[str, Union[str, "_models.MonitoringFeatureDataType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_types: The current notification mode for this signal.
        :paramtype notification_types: list[str or
         ~azure.mgmt.machinelearningservices.models.MonitoringNotificationType]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword feature_data_type_override: A dictionary that maps feature names to their respective
         data types.
        :paramtype feature_data_type_override: dict[str, str or
         ~azure.mgmt.machinelearningservices.models.MonitoringFeatureDataType]
        :keyword metric_thresholds: [Required] A list of metrics to calculate and their associated
         thresholds. Required.
        :paramtype metric_thresholds:
         list[~azure.mgmt.machinelearningservices.models.PredictionDriftMetricThresholdBase]
        :keyword production_data: [Required] The data which drift will be calculated for. Required.
        :paramtype production_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        :keyword reference_data: [Required] The data to calculate drift against. Required.
        :paramtype reference_data: ~azure.mgmt.machinelearningservices.models.MonitoringInputDataBase
        """
        super().__init__(notification_types=notification_types, properties=properties, **kwargs)
        self.signal_type: str = "PredictionDrift"
        self.feature_data_type_override = feature_data_type_override
        self.metric_thresholds = metric_thresholds
        self.production_data = production_data
        self.reference_data = reference_data


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified workspace.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateEndpointDestination(_serialization.Model):
    """Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a
    machine learning workspace.

    :ivar service_resource_id:
    :vartype service_resource_id: str
    :ivar spark_enabled:
    :vartype spark_enabled: bool
    :ivar spark_status: Type of a managed network Outbound Rule of a machine learning workspace.
     Known values are: "Inactive" and "Active".
    :vartype spark_status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar subresource_target:
    :vartype subresource_target: str
    """

    _attribute_map = {
        "service_resource_id": {"key": "serviceResourceId", "type": "str"},
        "spark_enabled": {"key": "sparkEnabled", "type": "bool"},
        "spark_status": {"key": "sparkStatus", "type": "str"},
        "subresource_target": {"key": "subresourceTarget", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_resource_id: Optional[str] = None,
        spark_enabled: Optional[bool] = None,
        spark_status: Optional[Union[str, "_models.RuleStatus"]] = None,
        subresource_target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_resource_id:
        :paramtype service_resource_id: str
        :keyword spark_enabled:
        :paramtype spark_enabled: bool
        :keyword spark_status: Type of a managed network Outbound Rule of a machine learning workspace.
         Known values are: "Inactive" and "Active".
        :paramtype spark_status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword subresource_target:
        :paramtype subresource_target: str
        """
        super().__init__(**kwargs)
        self.service_resource_id = service_resource_id
        self.spark_enabled = spark_enabled
        self.spark_status = spark_status
        self.subresource_target = subresource_target


class PrivateEndpointOutboundRule(OutboundRule):
    """Private Endpoint Outbound Rule for the managed network of a machine learning workspace.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Category of a managed network Outbound Rule of a machine learning workspace.
     Known values are: "Required", "Recommended", and "UserDefined".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
    :ivar status: Type of a managed network Outbound Rule of a machine learning workspace. Known
     values are: "Inactive" and "Active".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
    :ivar type: Type of a managed network Outbound Rule of a machine learning workspace. Required.
     Known values are: "FQDN", "PrivateEndpoint", and "ServiceTag".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.RuleType
    :ivar destination: Private Endpoint destination for a Private Endpoint Outbound Rule for the
     managed network of a machine learning workspace.
    :vartype destination: ~azure.mgmt.machinelearningservices.models.PrivateEndpointDestination
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "destination": {"key": "destination", "type": "PrivateEndpointDestination"},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "_models.RuleCategory"]] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        destination: Optional["_models.PrivateEndpointDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Category of a managed network Outbound Rule of a machine learning workspace.
         Known values are: "Required", "Recommended", and "UserDefined".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.RuleCategory
        :keyword status: Type of a managed network Outbound Rule of a machine learning workspace. Known
         values are: "Inactive" and "Active".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.RuleStatus
        :keyword destination: Private Endpoint destination for a Private Endpoint Outbound Rule for the
         managed network of a machine learning workspace.
        :paramtype destination: ~azure.mgmt.machinelearningservices.models.PrivateEndpointDestination
        """
        super().__init__(category=category, status=status, **kwargs)
        self.type: str = "PrivateEndpoint"
        self.destination = destination


class PrivateEndpointResource(PrivateEndpoint):
    """The PE network resource that is linked to this PE connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    :ivar subnet_arm_id: The subnetId that the private endpoint is connected to.
    :vartype subnet_arm_id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subnet_arm_id": {"key": "subnetArmId", "type": "str"},
    }

    def __init__(self, *, subnet_arm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword subnet_arm_id: The subnetId that the private endpoint is connected to.
        :paramtype subnet_arm_id: str
        """
        super().__init__(**kwargs)
        self.subnet_arm_id = subnet_arm_id


class PrivateLinkResource(Resource):  # pylint: disable=too-many-instance-attributes
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", "Rejected", "Disconnected", and
     "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", "Rejected", "Disconnected", and
         "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProbeSettings(_serialization.Model):
    """Deployment container liveness/readiness probe configuration.

    :ivar failure_threshold: The number of failures to allow before returning an unhealthy status.
    :vartype failure_threshold: int
    :ivar initial_delay: The delay before the first probe in ISO 8601 format.
    :vartype initial_delay: ~datetime.timedelta
    :ivar period: The length of time between probes in ISO 8601 format.
    :vartype period: ~datetime.timedelta
    :ivar success_threshold: The number of successful probes before returning a healthy status.
    :vartype success_threshold: int
    :ivar timeout: The probe timeout in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        "failure_threshold": {"key": "failureThreshold", "type": "int"},
        "initial_delay": {"key": "initialDelay", "type": "duration"},
        "period": {"key": "period", "type": "duration"},
        "success_threshold": {"key": "successThreshold", "type": "int"},
        "timeout": {"key": "timeout", "type": "duration"},
    }

    def __init__(
        self,
        *,
        failure_threshold: int = 30,
        initial_delay: Optional[datetime.timedelta] = None,
        period: datetime.timedelta = "PT10S",
        success_threshold: int = 1,
        timeout: datetime.timedelta = "PT2S",
        **kwargs: Any
    ) -> None:
        """
        :keyword failure_threshold: The number of failures to allow before returning an unhealthy
         status.
        :paramtype failure_threshold: int
        :keyword initial_delay: The delay before the first probe in ISO 8601 format.
        :paramtype initial_delay: ~datetime.timedelta
        :keyword period: The length of time between probes in ISO 8601 format.
        :paramtype period: ~datetime.timedelta
        :keyword success_threshold: The number of successful probes before returning a healthy status.
        :paramtype success_threshold: int
        :keyword timeout: The probe timeout in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.failure_threshold = failure_threshold
        self.initial_delay = initial_delay
        self.period = period
        self.success_threshold = success_threshold
        self.timeout = timeout


class PyTorch(DistributionConfiguration):
    """PyTorch distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: [Required] Specifies the type of distribution framework. Required.
     Known values are: "PyTorch", "TensorFlow", and "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        "distribution_type": {"required": True},
    }

    _attribute_map = {
        "distribution_type": {"key": "distributionType", "type": "str"},
        "process_count_per_instance": {"key": "processCountPerInstance", "type": "int"},
    }

    def __init__(self, *, process_count_per_instance: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword process_count_per_instance: Number of processes per node.
        :paramtype process_count_per_instance: int
        """
        super().__init__(**kwargs)
        self.distribution_type: str = "PyTorch"
        self.process_count_per_instance = process_count_per_instance


class QueueSettings(_serialization.Model):
    """QueueSettings.

    :ivar job_tier: Controls the compute job tier. Known values are: "Null", "Spot", "Basic",
     "Standard", and "Premium".
    :vartype job_tier: str or ~azure.mgmt.machinelearningservices.models.JobTier
    """

    _attribute_map = {
        "job_tier": {"key": "jobTier", "type": "str"},
    }

    def __init__(self, *, job_tier: Optional[Union[str, "_models.JobTier"]] = None, **kwargs: Any) -> None:
        """
        :keyword job_tier: Controls the compute job tier. Known values are: "Null", "Spot", "Basic",
         "Standard", and "Premium".
        :paramtype job_tier: str or ~azure.mgmt.machinelearningservices.models.JobTier
        """
        super().__init__(**kwargs)
        self.job_tier = job_tier


class QuotaBaseProperties(_serialization.Model):
    """The properties for Quota update or retrieval.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: int
    :ivar unit: An enum describing the unit of quota measurement. "Count"
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "limit": {"key": "limit", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        limit: Optional[int] = None,
        unit: Optional[Union[str, "_models.QuotaUnit"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Specifies the resource ID.
        :paramtype id: str
        :keyword type: Specifies the resource type.
        :paramtype type: str
        :keyword limit: The maximum permitted quota of the resource.
        :paramtype limit: int
        :keyword unit: An enum describing the unit of quota measurement. "Count"
        :paramtype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.limit = limit
        self.unit = unit


class QuotaUpdateParameters(_serialization.Model):
    """Quota update parameters.

    :ivar value: The list for update quota.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
    :ivar location: Region of workspace quota to be updated.
    :vartype location: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[QuotaBaseProperties]"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.QuotaBaseProperties"]] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list for update quota.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
        :keyword location: Region of workspace quota to be updated.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.location = location


class RandomSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values randomly.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: [Required] The algorithm used for generating hyperparameter
     values, along with configuration properties. Required. Known values are: "Grid", "Random", and
     "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    :ivar rule: The specific type of random algorithm. Known values are: "Random" and "Sobol".
    :vartype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
    :ivar seed: An optional integer to use as the seed for random number generation.
    :vartype seed: int
    """

    _validation = {
        "sampling_algorithm_type": {"required": True},
    }

    _attribute_map = {
        "sampling_algorithm_type": {"key": "samplingAlgorithmType", "type": "str"},
        "rule": {"key": "rule", "type": "str"},
        "seed": {"key": "seed", "type": "int"},
    }

    def __init__(
        self,
        *,
        rule: Optional[Union[str, "_models.RandomSamplingAlgorithmRule"]] = None,
        seed: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule: The specific type of random algorithm. Known values are: "Random" and "Sobol".
        :paramtype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
        :keyword seed: An optional integer to use as the seed for random number generation.
        :paramtype seed: int
        """
        super().__init__(**kwargs)
        self.sampling_algorithm_type: str = "Random"
        self.rule = rule
        self.seed = seed


class Recurrence(_serialization.Model):
    """The workflow trigger recurrence for ComputeStartStop schedule type.

    :ivar frequency: [Required] The frequency to trigger schedule. Known values are: "Minute",
     "Hour", "Day", "Week", and "Month".
    :vartype frequency: str or
     ~azure.mgmt.machinelearningservices.models.ComputeRecurrenceFrequency
    :ivar interval: [Required] Specifies schedule interval in conjunction with frequency.
    :vartype interval: int
    :ivar start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar schedule: [Required] The recurrence schedule.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ComputeRecurrenceSchedule
    """

    _attribute_map = {
        "frequency": {"key": "frequency", "type": "str"},
        "interval": {"key": "interval", "type": "int"},
        "start_time": {"key": "startTime", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "schedule": {"key": "schedule", "type": "ComputeRecurrenceSchedule"},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "_models.ComputeRecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        start_time: Optional[str] = None,
        time_zone: str = "UTC",
        schedule: Optional["_models.ComputeRecurrenceSchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword frequency: [Required] The frequency to trigger schedule. Known values are: "Minute",
         "Hour", "Day", "Week", and "Month".
        :paramtype frequency: str or
         ~azure.mgmt.machinelearningservices.models.ComputeRecurrenceFrequency
        :keyword interval: [Required] Specifies schedule interval in conjunction with frequency.
        :paramtype interval: int
        :keyword start_time: The start time in yyyy-MM-ddTHH:mm:ss format.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword schedule: [Required] The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ComputeRecurrenceSchedule
        """
        super().__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.start_time = start_time
        self.time_zone = time_zone
        self.schedule = schedule


class RecurrenceSchedule(_serialization.Model):
    """RecurrenceSchedule.

    All required parameters must be populated in order to send to Azure.

    :ivar hours: [Required] List of hours for the schedule. Required.
    :vartype hours: list[int]
    :ivar minutes: [Required] List of minutes for the schedule. Required.
    :vartype minutes: list[int]
    :ivar month_days: List of month days for the schedule.
    :vartype month_days: list[int]
    :ivar week_days: List of days for the schedule.
    :vartype week_days: list[str or ~azure.mgmt.machinelearningservices.models.WeekDay]
    """

    _validation = {
        "hours": {"required": True},
        "minutes": {"required": True},
    }

    _attribute_map = {
        "hours": {"key": "hours", "type": "[int]"},
        "minutes": {"key": "minutes", "type": "[int]"},
        "month_days": {"key": "monthDays", "type": "[int]"},
        "week_days": {"key": "weekDays", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        hours: List[int],
        minutes: List[int],
        month_days: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "_models.WeekDay"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hours: [Required] List of hours for the schedule. Required.
        :paramtype hours: list[int]
        :keyword minutes: [Required] List of minutes for the schedule. Required.
        :paramtype minutes: list[int]
        :keyword month_days: List of month days for the schedule.
        :paramtype month_days: list[int]
        :keyword week_days: List of days for the schedule.
        :paramtype week_days: list[str or ~azure.mgmt.machinelearningservices.models.WeekDay]
        """
        super().__init__(**kwargs)
        self.hours = hours
        self.minutes = minutes
        self.month_days = month_days
        self.week_days = week_days


class RecurrenceTrigger(TriggerBase):
    """RecurrenceTrigger.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
     https://en.wikipedia.org/wiki/ISO_8601.
     Recommented format would be "2022-06-01T00:00:01"
     If not present, the schedule will run indefinitely.
    :vartype end_time: str
    :ivar start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
     offset.
    :vartype start_time: str
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format. Refer:
     https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
    :vartype time_zone: str
    :ivar trigger_type: [Required]. Required. Known values are: "Recurrence" and "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar frequency: [Required] The frequency to trigger schedule. Required. Known values are:
     "Minute", "Hour", "Day", "Week", and "Month".
    :vartype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
    :ivar interval: [Required] Specifies schedule interval in conjunction with frequency. Required.
    :vartype interval: int
    :ivar schedule: The recurrence schedule.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
    """

    _validation = {
        "trigger_type": {"required": True},
        "frequency": {"required": True},
        "interval": {"required": True},
    }

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "frequency": {"key": "frequency", "type": "str"},
        "interval": {"key": "interval", "type": "int"},
        "schedule": {"key": "schedule", "type": "RecurrenceSchedule"},
    }

    def __init__(
        self,
        *,
        frequency: Union[str, "_models.RecurrenceFrequency"],
        interval: int,
        end_time: Optional[str] = None,
        start_time: Optional[str] = None,
        time_zone: str = "UTC",
        schedule: Optional["_models.RecurrenceSchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer
         https://en.wikipedia.org/wiki/ISO_8601.
         Recommented format would be "2022-06-01T00:00:01"
         If not present, the schedule will run indefinitely.
        :paramtype end_time: str
        :keyword start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC
         offset.
        :paramtype start_time: str
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format. Refer:
         https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11.
        :paramtype time_zone: str
        :keyword frequency: [Required] The frequency to trigger schedule. Required. Known values are:
         "Minute", "Hour", "Day", "Week", and "Month".
        :paramtype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
        :keyword interval: [Required] Specifies schedule interval in conjunction with frequency.
         Required.
        :paramtype interval: int
        :keyword schedule: The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
        """
        super().__init__(end_time=end_time, start_time=start_time, time_zone=time_zone, **kwargs)
        self.trigger_type: str = "Recurrence"
        self.frequency = frequency
        self.interval = interval
        self.schedule = schedule


class RegenerateEndpointKeysRequest(_serialization.Model):
    """RegenerateEndpointKeysRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: [Required] Specification for which type of key to generate. Primary or
     Secondary. Required. Known values are: "Primary" and "Secondary".
    :vartype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
    :ivar key_value: The value the key is set to.
    :vartype key_value: str
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
        "key_value": {"key": "keyValue", "type": "str"},
    }

    def __init__(
        self, *, key_type: Union[str, "_models.KeyType"], key_value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_type: [Required] Specification for which type of key to generate. Primary or
         Secondary. Required. Known values are: "Primary" and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
        :keyword key_value: The value the key is set to.
        :paramtype key_value: str
        """
        super().__init__(**kwargs)
        self.key_type = key_type
        self.key_value = key_value


class Registry(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar discovery_url: Discovery URL for the Registry.
    :vartype discovery_url: str
    :ivar intellectual_property_publisher: IntellectualPropertyPublisher for the registry.
    :vartype intellectual_property_publisher: str
    :ivar managed_resource_group: ResourceId of the managed RG if the registry has system created
     resources.
    :vartype managed_resource_group: ~azure.mgmt.machinelearningservices.models.ArmResourceId
    :ivar ml_flow_registry_uri: MLFlow Registry URI for the Registry.
    :vartype ml_flow_registry_uri: str
    :ivar registry_private_endpoint_connections: Private endpoint connections info used for pending
     connections in private link portal.
    :vartype registry_private_endpoint_connections:
     list[~azure.mgmt.machinelearningservices.models.RegistryPrivateEndpointConnection]
    :ivar public_network_access: Is the Registry accessible from the internet?
     Possible values: "Enabled" or "Disabled".
    :vartype public_network_access: str
    :ivar region_details: Details of each region the registry is in.
    :vartype region_details:
     list[~azure.mgmt.machinelearningservices.models.RegistryRegionArmDetails]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "discovery_url": {"key": "properties.discoveryUrl", "type": "str"},
        "intellectual_property_publisher": {"key": "properties.intellectualPropertyPublisher", "type": "str"},
        "managed_resource_group": {"key": "properties.managedResourceGroup", "type": "ArmResourceId"},
        "ml_flow_registry_uri": {"key": "properties.mlFlowRegistryUri", "type": "str"},
        "registry_private_endpoint_connections": {
            "key": "properties.registryPrivateEndpointConnections",
            "type": "[RegistryPrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "region_details": {"key": "properties.regionDetails", "type": "[RegistryRegionArmDetails]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        discovery_url: Optional[str] = None,
        intellectual_property_publisher: Optional[str] = None,
        managed_resource_group: Optional["_models.ArmResourceId"] = None,
        ml_flow_registry_uri: Optional[str] = None,
        registry_private_endpoint_connections: Optional[List["_models.RegistryPrivateEndpointConnection"]] = None,
        public_network_access: Optional[str] = None,
        region_details: Optional[List["_models.RegistryRegionArmDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword discovery_url: Discovery URL for the Registry.
        :paramtype discovery_url: str
        :keyword intellectual_property_publisher: IntellectualPropertyPublisher for the registry.
        :paramtype intellectual_property_publisher: str
        :keyword managed_resource_group: ResourceId of the managed RG if the registry has system
         created resources.
        :paramtype managed_resource_group: ~azure.mgmt.machinelearningservices.models.ArmResourceId
        :keyword ml_flow_registry_uri: MLFlow Registry URI for the Registry.
        :paramtype ml_flow_registry_uri: str
        :keyword registry_private_endpoint_connections: Private endpoint connections info used for
         pending connections in private link portal.
        :paramtype registry_private_endpoint_connections:
         list[~azure.mgmt.machinelearningservices.models.RegistryPrivateEndpointConnection]
        :keyword public_network_access: Is the Registry accessible from the internet?
         Possible values: "Enabled" or "Disabled".
        :paramtype public_network_access: str
        :keyword region_details: Details of each region the registry is in.
        :paramtype region_details:
         list[~azure.mgmt.machinelearningservices.models.RegistryRegionArmDetails]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.kind = kind
        self.sku = sku
        self.discovery_url = discovery_url
        self.intellectual_property_publisher = intellectual_property_publisher
        self.managed_resource_group = managed_resource_group
        self.ml_flow_registry_uri = ml_flow_registry_uri
        self.registry_private_endpoint_connections = registry_private_endpoint_connections
        self.public_network_access = public_network_access
        self.region_details = region_details


class RegistryListCredentialsResult(_serialization.Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar username:
    :vartype username: str
    :ivar passwords:
    :vartype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    """

    _validation = {
        "location": {"readonly": True},
        "username": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[Password]"},
    }

    def __init__(self, *, passwords: Optional[List["_models.Password"]] = None, **kwargs: Any) -> None:
        """
        :keyword passwords:
        :paramtype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
        """
        super().__init__(**kwargs)
        self.location = None
        self.username = None
        self.passwords = passwords


class RegistryPartialManagedServiceIdentity(ManagedServiceIdentity):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super().__init__(type=type, user_assigned_identities=user_assigned_identities, **kwargs)


class RegistryPrivateEndpointConnection(_serialization.Model):
    """Private endpoint connection definition.

    :ivar id: This is the private endpoint connection name created on SRP
     Full resource id:
     /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/registryPrivateEndpointConnections/{peConnectionName}.
    :vartype id: str
    :ivar location: Same as workspace location.
    :vartype location: str
    :ivar group_ids: The group ids.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The PE network resource that is linked to this PE connection.
    :vartype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpointResource
    :ivar registry_private_link_service_connection_state: The connection state.
    :vartype registry_private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.RegistryPrivateLinkServiceConnectionState
    :ivar provisioning_state: One of null, "Succeeded", "Provisioning", "Failed". While not
     approved, it's null.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpointResource"},
        "registry_private_link_service_connection_state": {
            "key": "properties.registryPrivateLinkServiceConnectionState",
            "type": "RegistryPrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        private_endpoint: Optional["_models.PrivateEndpointResource"] = None,
        registry_private_link_service_connection_state: Optional[
            "_models.RegistryPrivateLinkServiceConnectionState"
        ] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: This is the private endpoint connection name created on SRP
         Full resource id:
         /subscriptions/{subId}/resourceGroups/{rgName}/providers/Microsoft.MachineLearningServices/{resourceType}/{resourceName}/registryPrivateEndpointConnections/{peConnectionName}.
        :paramtype id: str
        :keyword location: Same as workspace location.
        :paramtype location: str
        :keyword group_ids: The group ids.
        :paramtype group_ids: list[str]
        :keyword private_endpoint: The PE network resource that is linked to this PE connection.
        :paramtype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpointResource
        :keyword registry_private_link_service_connection_state: The connection state.
        :paramtype registry_private_link_service_connection_state:
         ~azure.mgmt.machinelearningservices.models.RegistryPrivateLinkServiceConnectionState
        :keyword provisioning_state: One of null, "Succeeded", "Provisioning", "Failed". While not
         approved, it's null.
        :paramtype provisioning_state: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.location = location
        self.group_ids = group_ids
        self.private_endpoint = private_endpoint
        self.registry_private_link_service_connection_state = registry_private_link_service_connection_state
        self.provisioning_state = provisioning_state


class RegistryPrivateLinkServiceConnectionState(_serialization.Model):
    """The connection state.

    :ivar actions_required: Some RP chose "None". Other RPs use this for region expansion.
    :vartype actions_required: str
    :ivar description: User-defined message that, per NRP doc, may be used for approval-related
     message.
    :vartype description: str
    :ivar status: Connection status of the service consumer with the service provider. Known values
     are: "Approved", "Pending", "Rejected", and "Disconnected".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
    """

    _attribute_map = {
        "actions_required": {"key": "actionsRequired", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        actions_required: Optional[str] = None,
        description: Optional[str] = None,
        status: Optional[Union[str, "_models.EndpointServiceConnectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword actions_required: Some RP chose "None". Other RPs use this for region expansion.
        :paramtype actions_required: str
        :keyword description: User-defined message that, per NRP doc, may be used for approval-related
         message.
        :paramtype description: str
        :keyword status: Connection status of the service consumer with the service provider. Known
         values are: "Approved", "Pending", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.EndpointServiceConnectionStatus
        """
        super().__init__(**kwargs)
        self.actions_required = actions_required
        self.description = description
        self.status = status


class RegistryRegionArmDetails(_serialization.Model):
    """Details for each region the registry is in.

    :ivar acr_details: List of ACR accounts.
    :vartype acr_details: list[~azure.mgmt.machinelearningservices.models.AcrDetails]
    :ivar location: The location where the registry exists.
    :vartype location: str
    :ivar storage_account_details: List of storage accounts.
    :vartype storage_account_details:
     list[~azure.mgmt.machinelearningservices.models.StorageAccountDetails]
    """

    _attribute_map = {
        "acr_details": {"key": "acrDetails", "type": "[AcrDetails]"},
        "location": {"key": "location", "type": "str"},
        "storage_account_details": {"key": "storageAccountDetails", "type": "[StorageAccountDetails]"},
    }

    def __init__(
        self,
        *,
        acr_details: Optional[List["_models.AcrDetails"]] = None,
        location: Optional[str] = None,
        storage_account_details: Optional[List["_models.StorageAccountDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword acr_details: List of ACR accounts.
        :paramtype acr_details: list[~azure.mgmt.machinelearningservices.models.AcrDetails]
        :keyword location: The location where the registry exists.
        :paramtype location: str
        :keyword storage_account_details: List of storage accounts.
        :paramtype storage_account_details:
         list[~azure.mgmt.machinelearningservices.models.StorageAccountDetails]
        """
        super().__init__(**kwargs)
        self.acr_details = acr_details
        self.location = location
        self.storage_account_details = storage_account_details


class RegistryTrackedResourceArmPaginatedResult(_serialization.Model):
    """A paginated list of Registry entities.

    :ivar next_link: The link to the next page of Registry objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Registry.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Registry]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Registry]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.Registry"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link to the next page of Registry objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Registry.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Registry]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Regression(TableVertical, AutoMLVertical):  # pylint: disable=too-many-instance-attributes
    """Regression task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
     "Warning", "Error", and "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar target_column_name: Target column name: This is prediction values column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar task_type: [Required] Task type for AutoMLJob. Required. Known values are:
     "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", and "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar training_data: [Required] Training data input. Required.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    :ivar validation_data: Validation data inputs.
    :vartype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    :ivar primary_metric: Primary metric for regression task. Known values are:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score", and
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings:
     ~azure.mgmt.machinelearningservices.models.RegressionTrainingSettings
    """

    _validation = {
        "task_type": {"required": True},
        "training_data": {"required": True},
    }

    _attribute_map = {
        "log_verbosity": {"key": "logVerbosity", "type": "str"},
        "target_column_name": {"key": "targetColumnName", "type": "str"},
        "task_type": {"key": "taskType", "type": "str"},
        "training_data": {"key": "trainingData", "type": "MLTableJobInput"},
        "cv_split_column_names": {"key": "cvSplitColumnNames", "type": "[str]"},
        "featurization_settings": {"key": "featurizationSettings", "type": "TableVerticalFeaturizationSettings"},
        "limit_settings": {"key": "limitSettings", "type": "TableVerticalLimitSettings"},
        "n_cross_validations": {"key": "nCrossValidations", "type": "NCrossValidations"},
        "test_data": {"key": "testData", "type": "MLTableJobInput"},
        "test_data_size": {"key": "testDataSize", "type": "float"},
        "validation_data": {"key": "validationData", "type": "MLTableJobInput"},
        "validation_data_size": {"key": "validationDataSize", "type": "float"},
        "weight_column_name": {"key": "weightColumnName", "type": "str"},
        "primary_metric": {"key": "primaryMetric", "type": "str"},
        "training_settings": {"key": "trainingSettings", "type": "RegressionTrainingSettings"},
    }

    def __init__(
        self,
        *,
        training_data: "_models.MLTableJobInput",
        log_verbosity: Optional[Union[str, "_models.LogVerbosity"]] = None,
        target_column_name: Optional[str] = None,
        cv_split_column_names: Optional[List[str]] = None,
        featurization_settings: Optional["_models.TableVerticalFeaturizationSettings"] = None,
        limit_settings: Optional["_models.TableVerticalLimitSettings"] = None,
        n_cross_validations: Optional["_models.NCrossValidations"] = None,
        test_data: Optional["_models.MLTableJobInput"] = None,
        test_data_size: Optional[float] = None,
        validation_data: Optional["_models.MLTableJobInput"] = None,
        validation_data_size: Optional[float] = None,
        weight_column_name: Optional[str] = None,
        primary_metric: Optional[Union[str, "_models.RegressionPrimaryMetrics"]] = None,
        training_settings: Optional["_models.RegressionTrainingSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_verbosity: Log verbosity for the job. Known values are: "NotSet", "Debug", "Info",
         "Warning", "Error", and "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword target_column_name: Target column name: This is prediction values column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword training_data: [Required] Training data input. Required.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        :keyword primary_metric: Primary metric for regression task. Known values are:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score", and
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings:
         ~azure.mgmt.machinelearningservices.models.RegressionTrainingSettings
        """
        super().__init__(
            cv_split_column_names=cv_split_column_names,
            featurization_settings=featurization_settings,
            limit_settings=limit_settings,
            n_cross_validations=n_cross_validations,
            test_data=test_data,
            test_data_size=test_data_size,
            validation_data=validation_data,
            validation_data_size=validation_data_size,
            weight_column_name=weight_column_name,
            log_verbosity=log_verbosity,
            target_column_name=target_column_name,
            training_data=training_data,
            **kwargs
        )
        self.log_verbosity = log_verbosity
        self.target_column_name = target_column_name
        self.task_type: str = "Regression"
        self.training_data = training_data
        self.primary_metric = primary_metric
        self.training_settings = training_settings
        self.cv_split_column_names = cv_split_column_names
        self.featurization_settings = featurization_settings
        self.limit_settings = limit_settings
        self.n_cross_validations = n_cross_validations
        self.test_data = test_data
        self.test_data_size = test_data_size
        self.validation_data = validation_data
        self.validation_data_size = validation_data_size
        self.weight_column_name = weight_column_name


class RegressionTrainingSettings(TrainingSettings):
    """Regression Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    :ivar allowed_training_algorithms: Allowed models for regression task.
    :vartype allowed_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    :ivar blocked_training_algorithms: Blocked models for regression task.
    :vartype blocked_training_algorithms: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    """

    _attribute_map = {
        "enable_dnn_training": {"key": "enableDnnTraining", "type": "bool"},
        "enable_model_explainability": {"key": "enableModelExplainability", "type": "bool"},
        "enable_onnx_compatible_models": {"key": "enableOnnxCompatibleModels", "type": "bool"},
        "enable_stack_ensemble": {"key": "enableStackEnsemble", "type": "bool"},
        "enable_vote_ensemble": {"key": "enableVoteEnsemble", "type": "bool"},
        "ensemble_model_download_timeout": {"key": "ensembleModelDownloadTimeout", "type": "duration"},
        "stack_ensemble_settings": {"key": "stackEnsembleSettings", "type": "StackEnsembleSettings"},
        "allowed_training_algorithms": {"key": "allowedTrainingAlgorithms", "type": "[str]"},
        "blocked_training_algorithms": {"key": "blockedTrainingAlgorithms", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enable_dnn_training: bool = False,
        enable_model_explainability: bool = True,
        enable_onnx_compatible_models: bool = False,
        enable_stack_ensemble: bool = True,
        enable_vote_ensemble: bool = True,
        ensemble_model_download_timeout: datetime.timedelta = "PT5M",
        stack_ensemble_settings: Optional["_models.StackEnsembleSettings"] = None,
        allowed_training_algorithms: Optional[List[Union[str, "_models.RegressionModels"]]] = None,
        blocked_training_algorithms: Optional[List[Union[str, "_models.RegressionModel