# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class AuthorizationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Authorization status of spacecraft.
    """

    ALLOWED = "Allowed"
    PENDING = "Pending"
    DENIED = "Denied"

class AutoTrackingConfiguration(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Auto track configuration.
    """

    DISABLED = "disabled"
    X_BAND = "xBand"
    S_BAND = "sBand"

class Capability(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Capability of the Ground Station.
    """

    EARTH_OBSERVATION = "EarthObservation"
    COMMUNICATION = "Communication"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class Direction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Direction (uplink or downlink)
    """

    UPLINK = "uplink"
    DOWNLINK = "downlink"

class Enum6(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    EARTH_OBSERVATION = "EarthObservation"
    COMMUNICATION = "Communication"

class Origin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system"
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"

class Polarization(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """polarization. eg (RHCP, LHCP)
    """

    RHCP = "RHCP"
    LHCP = "LHCP"
    DUAL_RHCP_LHCP = "dualRhcpLhcp"
    LINEAR_VERTICAL = "linearVertical"
    LINEAR_HORIZONTAL = "linearHorizontal"

class Protocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol either UDP or TCP.
    """

    TCP = "TCP"
    UDP = "UDP"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of a contact.
    """

    SCHEDULED = "scheduled"
    CANCELLED = "cancelled"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    PROVIDER_CANCELLED = "providerCancelled"
