# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._iot_hub_client_enums import *


class CloudToDeviceProperties(msrest.serialization.Model):
    """The IoT hub cloud-to-device messaging properties.

    :ivar max_delivery_count: The max delivery count for cloud-to-device messages in the device
     queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype max_delivery_count: int
    :ivar default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
     device queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype default_ttl_as_iso8601: ~datetime.timedelta
    :ivar feedback: The properties of the feedback queue for cloud-to-device messages.
    :vartype feedback: ~azure.mgmt.iothub.v2016_02_03.models.FeedbackProperties
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
        'default_ttl_as_iso8601': {'key': 'defaultTtlAsIso8601', 'type': 'duration'},
        'feedback': {'key': 'feedback', 'type': 'FeedbackProperties'},
    }

    def __init__(
        self,
        *,
        max_delivery_count: Optional[int] = None,
        default_ttl_as_iso8601: Optional[datetime.timedelta] = None,
        feedback: Optional["FeedbackProperties"] = None,
        **kwargs
    ):
        """
        :keyword max_delivery_count: The max delivery count for cloud-to-device messages in the device
         queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype max_delivery_count: int
        :keyword default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
         device queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype default_ttl_as_iso8601: ~datetime.timedelta
        :keyword feedback: The properties of the feedback queue for cloud-to-device messages.
        :paramtype feedback: ~azure.mgmt.iothub.v2016_02_03.models.FeedbackProperties
        """
        super(CloudToDeviceProperties, self).__init__(**kwargs)
        self.max_delivery_count = max_delivery_count
        self.default_ttl_as_iso8601 = default_ttl_as_iso8601
        self.feedback = feedback


class ErrorDetails(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'http_status_code': {'key': 'HttpStatusCode', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
        'details': {'key': 'Details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class EventHubConsumerGroupInfo(msrest.serialization.Model):
    """The properties of the EventHubConsumerGroupInfo object.

    :ivar tags: A set of tags. The tags.
    :vartype tags: dict[str, str]
    :ivar id: The Event Hub-compatible consumer group identifier.
    :vartype id: str
    :ivar name: The Event Hub-compatible consumer group name.
    :vartype name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags.
        :paramtype tags: dict[str, str]
        :keyword id: The Event Hub-compatible consumer group identifier.
        :paramtype id: str
        :keyword name: The Event Hub-compatible consumer group name.
        :paramtype name: str
        """
        super(EventHubConsumerGroupInfo, self).__init__(**kwargs)
        self.tags = tags
        self.id = id
        self.name = name


class EventHubConsumerGroupsListResult(msrest.serialization.Model):
    """The JSON-serialized array of Event Hub-compatible consumer group names with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of Event Hub-compatible consumer group names.
    :vartype value: list[str]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of Event Hub-compatible consumer group names.
        :paramtype value: list[str]
        """
        super(EventHubConsumerGroupsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EventHubProperties(msrest.serialization.Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retention_time_in_days: The retention time for device-to-cloud messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :vartype retention_time_in_days: long
    :ivar partition_count: The number of partitions for receiving device-to-cloud messages in the
     Event Hub-compatible endpoint. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :vartype partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retention_time_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword retention_time_in_days: The retention time for device-to-cloud messages in days. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :paramtype retention_time_in_days: long
        :keyword partition_count: The number of partitions for receiving device-to-cloud messages in
         the Event Hub-compatible endpoint. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :paramtype partition_count: int
        """
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = retention_time_in_days
        self.partition_count = partition_count
        self.partition_ids = None
        self.path = None
        self.endpoint = None


class ExportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an export of all devices in the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :ivar export_blob_container_uri: Required. The export blob container URI.
    :vartype export_blob_container_uri: str
    :ivar exclude_keys: Required. The value indicating whether keys should be excluded during
     export.
    :vartype exclude_keys: bool
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'ExportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'ExcludeKeys', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        export_blob_container_uri: str,
        exclude_keys: bool,
        **kwargs
    ):
        """
        :keyword export_blob_container_uri: Required. The export blob container URI.
        :paramtype export_blob_container_uri: str
        :keyword exclude_keys: Required. The value indicating whether keys should be excluded during
         export.
        :paramtype exclude_keys: bool
        """
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = export_blob_container_uri
        self.exclude_keys = exclude_keys


class FeedbackProperties(msrest.serialization.Model):
    """The properties of the feedback queue for cloud-to-device messages.

    :ivar lock_duration_as_iso8601: The lock duration for the feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype lock_duration_as_iso8601: ~datetime.timedelta
    :ivar ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype ttl_as_iso8601: ~datetime.timedelta
    :ivar max_delivery_count: The number of times the IoT hub attempts to deliver a message on the
     feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lock_duration_as_iso8601: Optional[datetime.timedelta] = None,
        ttl_as_iso8601: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword lock_duration_as_iso8601: The lock duration for the feedback queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype lock_duration_as_iso8601: ~datetime.timedelta
        :keyword ttl_as_iso8601: The period of time for which a message is available to consume before
         it is expired by the IoT hub. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype ttl_as_iso8601: ~datetime.timedelta
        :keyword max_delivery_count: The number of times the IoT hub attempts to deliver a message on
         the feedback queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype max_delivery_count: int
        """
        super(FeedbackProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class ImportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an import of all devices in the hub.

    All required parameters must be populated in order to send to Azure.

    :ivar input_blob_container_uri: Required. The input blob container URI.
    :vartype input_blob_container_uri: str
    :ivar output_blob_container_uri: Required. The output blob container URI.
    :vartype output_blob_container_uri: str
    """

    _validation = {
        'input_blob_container_uri': {'required': True},
        'output_blob_container_uri': {'required': True},
    }

    _attribute_map = {
        'input_blob_container_uri': {'key': 'InputBlobContainerUri', 'type': 'str'},
        'output_blob_container_uri': {'key': 'OutputBlobContainerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        input_blob_container_uri: str,
        output_blob_container_uri: str,
        **kwargs
    ):
        """
        :keyword input_blob_container_uri: Required. The input blob container URI.
        :paramtype input_blob_container_uri: str
        :keyword output_blob_container_uri: Required. The output blob container URI.
        :paramtype output_blob_container_uri: str
        """
        super(ImportDevicesRequest, self).__init__(**kwargs)
        self.input_blob_container_uri = input_blob_container_uri
        self.output_blob_container_uri = output_blob_container_uri


class IotHubCapacity(msrest.serialization.Model):
    """IoT Hub capacity information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum number of units.
    :vartype minimum: long
    :ivar maximum: The maximum number of units.
    :vartype maximum: long
    :ivar default: The default number of units.
    :vartype default: long
    :ivar scale_type: The type of the scaling enabled. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.iothub.v2016_02_03.models.IotHubScaleType
    """

    _validation = {
        'minimum': {'readonly': True, 'maximum': 1, 'minimum': 1},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IotHubCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class Resource(msrest.serialization.Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: Required. The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class IotHubDescription(Resource):
    """The description of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: Required. The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar subscriptionid: Required. The subscription identifier.
    :vartype subscriptionid: str
    :ivar resourcegroup: Required. The name of the resource group that contains the IoT hub. A
     resource group name uniquely identifies the resource group within the subscription.
    :vartype resourcegroup: str
    :ivar etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :vartype etag: str
    :ivar properties: The properties of an IoT hub.
    :vartype properties: ~azure.mgmt.iothub.v2016_02_03.models.IotHubProperties
    :ivar sku: Required. Information about the SKU of the IoT hub.
    :vartype sku: ~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'subscriptionid': {'required': True},
        'resourcegroup': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'subscriptionid': {'key': 'subscriptionid', 'type': 'str'},
        'resourcegroup': {'key': 'resourcegroup', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotHubProperties'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
    }

    def __init__(
        self,
        *,
        location: str,
        subscriptionid: str,
        resourcegroup: str,
        sku: "IotHubSkuInfo",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        properties: Optional["IotHubProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword subscriptionid: Required. The subscription identifier.
        :paramtype subscriptionid: str
        :keyword resourcegroup: Required. The name of the resource group that contains the IoT hub. A
         resource group name uniquely identifies the resource group within the subscription.
        :paramtype resourcegroup: str
        :keyword etag: The Etag field is *not* required. If it is provided in the response body, it
         must also be provided as a header per the normal ETag convention.
        :paramtype etag: str
        :keyword properties: The properties of an IoT hub.
        :paramtype properties: ~azure.mgmt.iothub.v2016_02_03.models.IotHubProperties
        :keyword sku: Required. Information about the SKU of the IoT hub.
        :paramtype sku: ~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuInfo
        """
        super(IotHubDescription, self).__init__(location=location, tags=tags, **kwargs)
        self.subscriptionid = subscriptionid
        self.resourcegroup = resourcegroup
        self.etag = etag
        self.properties = properties
        self.sku = sku


class IotHubDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of IotHubDescription objects.
    :vartype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubDescription"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of IotHubDescription objects.
        :paramtype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubDescription]
        """
        super(IotHubDescriptionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubNameAvailabilityInfo(msrest.serialization.Model):
    """The properties indicating whether a given IoT hub name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value which indicates whether the provided name is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.iothub.v2016_02_03.models.IotHubNameUnavailabilityReason
    :ivar message: The detailed reason message.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message: The detailed reason message.
        :paramtype message: str
        """
        super(IotHubNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = message


class IotHubProperties(msrest.serialization.Model):
    """The properties of an IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization_policies: The shared access policies you can use to secure a connection to
     the IoT hub.
    :vartype authorization_policies:
     list[~azure.mgmt.iothub.v2016_02_03.models.SharedAccessSignatureAuthorizationRule]
    :ivar ip_filter_rules: The IP filter rules.
    :vartype ip_filter_rules: list[~azure.mgmt.iothub.v2016_02_03.models.IpFilterRule]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    :ivar event_hub_endpoints: The Event Hub-compatible endpoint properties. The possible keys to
     this dictionary are events and operationsMonitoringEvents. Both of these keys have to be
     present in the dictionary while making create or update calls for the IoT hub.
    :vartype event_hub_endpoints: dict[str,
     ~azure.mgmt.iothub.v2016_02_03.models.EventHubProperties]
    :ivar storage_endpoints: The list of Azure Storage endpoints where you can upload files.
     Currently you can configure only one Azure Storage account and that MUST have its key as
     $default. Specifying more than one storage account causes an error to be thrown. Not specifying
     a value for this property when the enableFileUploadNotifications property is set to True,
     causes an error to be thrown.
    :vartype storage_endpoints: dict[str,
     ~azure.mgmt.iothub.v2016_02_03.models.StorageEndpointProperties]
    :ivar messaging_endpoints: The messaging endpoint properties for the file upload notification
     queue.
    :vartype messaging_endpoints: dict[str,
     ~azure.mgmt.iothub.v2016_02_03.models.MessagingEndpointProperties]
    :ivar enable_file_upload_notifications: If True, file upload notifications are enabled.
    :vartype enable_file_upload_notifications: bool
    :ivar cloud_to_device: The IoT hub cloud-to-device messaging properties.
    :vartype cloud_to_device: ~azure.mgmt.iothub.v2016_02_03.models.CloudToDeviceProperties
    :ivar comments: Comments.
    :vartype comments: str
    :ivar operations_monitoring_properties: The operations monitoring properties for the IoT hub.
     The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands,
     DeviceIdentityOperations, FileUploadOperations.
    :vartype operations_monitoring_properties:
     ~azure.mgmt.iothub.v2016_02_03.models.OperationsMonitoringProperties
    :ivar features: The capabilities and features enabled for the IoT hub. Possible values include:
     "None", "DeviceManagement".
    :vartype features: str or ~azure.mgmt.iothub.v2016_02_03.models.Capabilities
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'operations_monitoring_properties': {'key': 'operationsMonitoringProperties', 'type': 'OperationsMonitoringProperties'},
        'features': {'key': 'features', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authorization_policies: Optional[List["SharedAccessSignatureAuthorizationRule"]] = None,
        ip_filter_rules: Optional[List["IpFilterRule"]] = None,
        event_hub_endpoints: Optional[Dict[str, "EventHubProperties"]] = None,
        storage_endpoints: Optional[Dict[str, "StorageEndpointProperties"]] = None,
        messaging_endpoints: Optional[Dict[str, "MessagingEndpointProperties"]] = None,
        enable_file_upload_notifications: Optional[bool] = None,
        cloud_to_device: Optional["CloudToDeviceProperties"] = None,
        comments: Optional[str] = None,
        operations_monitoring_properties: Optional["OperationsMonitoringProperties"] = None,
        features: Optional[Union[str, "Capabilities"]] = None,
        **kwargs
    ):
        """
        :keyword authorization_policies: The shared access policies you can use to secure a connection
         to the IoT hub.
        :paramtype authorization_policies:
         list[~azure.mgmt.iothub.v2016_02_03.models.SharedAccessSignatureAuthorizationRule]
        :keyword ip_filter_rules: The IP filter rules.
        :paramtype ip_filter_rules: list[~azure.mgmt.iothub.v2016_02_03.models.IpFilterRule]
        :keyword event_hub_endpoints: The Event Hub-compatible endpoint properties. The possible keys
         to this dictionary are events and operationsMonitoringEvents. Both of these keys have to be
         present in the dictionary while making create or update calls for the IoT hub.
        :paramtype event_hub_endpoints: dict[str,
         ~azure.mgmt.iothub.v2016_02_03.models.EventHubProperties]
        :keyword storage_endpoints: The list of Azure Storage endpoints where you can upload files.
         Currently you can configure only one Azure Storage account and that MUST have its key as
         $default. Specifying more than one storage account causes an error to be thrown. Not specifying
         a value for this property when the enableFileUploadNotifications property is set to True,
         causes an error to be thrown.
        :paramtype storage_endpoints: dict[str,
         ~azure.mgmt.iothub.v2016_02_03.models.StorageEndpointProperties]
        :keyword messaging_endpoints: The messaging endpoint properties for the file upload
         notification queue.
        :paramtype messaging_endpoints: dict[str,
         ~azure.mgmt.iothub.v2016_02_03.models.MessagingEndpointProperties]
        :keyword enable_file_upload_notifications: If True, file upload notifications are enabled.
        :paramtype enable_file_upload_notifications: bool
        :keyword cloud_to_device: The IoT hub cloud-to-device messaging properties.
        :paramtype cloud_to_device: ~azure.mgmt.iothub.v2016_02_03.models.CloudToDeviceProperties
        :keyword comments: Comments.
        :paramtype comments: str
        :keyword operations_monitoring_properties: The operations monitoring properties for the IoT
         hub. The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands,
         DeviceIdentityOperations, FileUploadOperations.
        :paramtype operations_monitoring_properties:
         ~azure.mgmt.iothub.v2016_02_03.models.OperationsMonitoringProperties
        :keyword features: The capabilities and features enabled for the IoT hub. Possible values
         include: "None", "DeviceManagement".
        :paramtype features: str or ~azure.mgmt.iothub.v2016_02_03.models.Capabilities
        """
        super(IotHubProperties, self).__init__(**kwargs)
        self.authorization_policies = authorization_policies
        self.ip_filter_rules = ip_filter_rules
        self.provisioning_state = None
        self.host_name = None
        self.event_hub_endpoints = event_hub_endpoints
        self.storage_endpoints = storage_endpoints
        self.messaging_endpoints = messaging_endpoints
        self.enable_file_upload_notifications = enable_file_upload_notifications
        self.cloud_to_device = cloud_to_device
        self.comments = comments
        self.operations_monitoring_properties = operations_monitoring_properties
        self.features = features


class IotHubQuotaMetricInfo(msrest.serialization.Model):
    """Quota metrics properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the quota metric.
    :vartype name: str
    :ivar current_value: The current value for the quota metric.
    :vartype current_value: long
    :ivar max_value: The maximum value of the quota metric.
    :vartype max_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'current_value': {'readonly': True},
        'max_value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'current_value': {'key': 'CurrentValue', 'type': 'long'},
        'max_value': {'key': 'MaxValue', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IotHubQuotaMetricInfo, self).__init__(**kwargs)
        self.name = None
        self.current_value = None
        self.max_value = None


class IotHubQuotaMetricInfoListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubQuotaMetricInfo objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of quota metrics objects.
    :vartype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubQuotaMetricInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubQuotaMetricInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubQuotaMetricInfo"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of quota metrics objects.
        :paramtype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubQuotaMetricInfo]
        """
        super(IotHubQuotaMetricInfoListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubSkuDescription(msrest.serialization.Model):
    """SKU properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar sku: Required. Information about the SKU of the IoT hub.
    :vartype sku: ~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuInfo
    :ivar capacity: Required. IoT Hub capacity information.
    :vartype capacity: ~azure.mgmt.iothub.v2016_02_03.models.IotHubCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'capacity': {'key': 'capacity', 'type': 'IotHubCapacity'},
    }

    def __init__(
        self,
        *,
        sku: "IotHubSkuInfo",
        capacity: "IotHubCapacity",
        **kwargs
    ):
        """
        :keyword sku: Required. Information about the SKU of the IoT hub.
        :paramtype sku: ~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuInfo
        :keyword capacity: Required. IoT Hub capacity information.
        :paramtype capacity: ~azure.mgmt.iothub.v2016_02_03.models.IotHubCapacity
        """
        super(IotHubSkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = sku
        self.capacity = capacity


class IotHubSkuDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubSkuDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of IotHubSkuDescription.
    :vartype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubSkuDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubSkuDescription"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of IotHubSkuDescription.
        :paramtype value: list[~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuDescription]
        """
        super(IotHubSkuDescriptionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubSkuInfo(msrest.serialization.Model):
    """Information about the SKU of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3".
    :vartype name: str or ~azure.mgmt.iothub.v2016_02_03.models.IotHubSku
    :ivar tier: The billing tier for the IoT hub. Possible values include: "Free", "Standard".
    :vartype tier: str or ~azure.mgmt.iothub.v2016_02_03.models.IotHubSkuTier
    :ivar capacity: Required. The number of provisioned IoT Hub units. See:
     https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
    :vartype capacity: long
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "IotHubSku"],
        capacity: int,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3".
        :paramtype name: str or ~azure.mgmt.iothub.v2016_02_03.models.IotHubSku
        :keyword capacity: Required. The number of provisioned IoT Hub units. See:
         https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        :paramtype capacity: long
        """
        super(IotHubSkuInfo, self).__init__(**kwargs)
        self.name = name
        self.tier = None
        self.capacity = capacity


class IpFilterRule(msrest.serialization.Model):
    """The IP filter rules for the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_name: Required. The name of the IP filter rule.
    :vartype filter_name: str
    :ivar action: Required. The desired action for requests captured by this rule. Possible values
     include: "Accept", "Reject".
    :vartype action: str or ~azure.mgmt.iothub.v2016_02_03.models.IpFilterActionType
    :ivar ip_mask: Required. A string that contains the IP address range in CIDR notation for the
     rule.
    :vartype ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        filter_name: str,
        action: Union[str, "IpFilterActionType"],
        ip_mask: str,
        **kwargs
    ):
        """
        :keyword filter_name: Required. The name of the IP filter rule.
        :paramtype filter_name: str
        :keyword action: Required. The desired action for requests captured by this rule. Possible
         values include: "Accept", "Reject".
        :paramtype action: str or ~azure.mgmt.iothub.v2016_02_03.models.IpFilterActionType
        :keyword ip_mask: Required. A string that contains the IP address range in CIDR notation for
         the rule.
        :paramtype ip_mask: str
        """
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = filter_name
        self.action = action
        self.ip_mask = ip_mask


class JobResponse(msrest.serialization.Model):
    """The properties of the Job Response object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_id: The job identifier.
    :vartype job_id: str
    :ivar start_time_utc: The start time of the job.
    :vartype start_time_utc: ~datetime.datetime
    :ivar end_time_utc: The time the job stopped processing.
    :vartype end_time_utc: ~datetime.datetime
    :ivar type: The type of the job. Possible values include: "unknown", "export", "import",
     "backup", "readDeviceProperties", "writeDeviceProperties", "updateDeviceConfiguration",
     "rebootDevice", "factoryResetDevice", "firmwareUpdate".
    :vartype type: str or ~azure.mgmt.iothub.v2016_02_03.models.JobType
    :ivar status: The status of the job. Possible values include: "unknown", "enqueued", "running",
     "completed", "failed", "cancelled".
    :vartype status: str or ~azure.mgmt.iothub.v2016_02_03.models.JobStatus
    :ivar failure_reason: If status == failed, this string containing the reason for the failure.
    :vartype failure_reason: str
    :ivar status_message: The status message for the job.
    :vartype status_message: str
    :ivar parent_job_id: The job identifier of the parent job, if any.
    :vartype parent_job_id: str
    """

    _validation = {
        'job_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'status_message': {'readonly': True},
        'parent_job_id': {'readonly': True},
    }

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'rfc-1123'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'rfc-1123'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = None
        self.start_time_utc = None
        self.end_time_utc = None
        self.type = None
        self.status = None
        self.failure_reason = None
        self.status_message = None
        self.parent_job_id = None


class JobResponseListResult(msrest.serialization.Model):
    """The JSON-serialized array of JobResponse objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of JobResponse objects.
    :vartype value: list[~azure.mgmt.iothub.v2016_02_03.models.JobResponse]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobResponse"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of JobResponse objects.
        :paramtype value: list[~azure.mgmt.iothub.v2016_02_03.models.JobResponse]
        """
        super(JobResponseListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MessagingEndpointProperties(msrest.serialization.Model):
    """The properties of the messaging endpoints used by this IoT hub.

    :ivar lock_duration_as_iso8601: The lock duration. See:
     https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype lock_duration_as_iso8601: ~datetime.timedelta
    :ivar ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype ttl_as_iso8601: ~datetime.timedelta
    :ivar max_delivery_count: The number of times the IoT hub attempts to deliver a message. See:
     https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lock_duration_as_iso8601: Optional[datetime.timedelta] = None,
        ttl_as_iso8601: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword lock_duration_as_iso8601: The lock duration. See:
         https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype lock_duration_as_iso8601: ~datetime.timedelta
        :keyword ttl_as_iso8601: The period of time for which a message is available to consume before
         it is expired by the IoT hub. See:
         https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype ttl_as_iso8601: ~datetime.timedelta
        :keyword max_delivery_count: The number of times the IoT hub attempts to deliver a message.
         See: https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype max_delivery_count: int
        """
        super(MessagingEndpointProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class OperationInputs(msrest.serialization.Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the IoT hub to check.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the IoT hub to check.
        :paramtype name: str
        """
        super(OperationInputs, self).__init__(**kwargs)
        self.name = name


class OperationsMonitoringProperties(msrest.serialization.Model):
    """The operations monitoring properties for the IoT hub. The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations, FileUploadOperations.

    :ivar events: Dictionary of :code:`<OperationMonitoringLevel>`.
    :vartype events: dict[str, str or
     ~azure.mgmt.iothub.v2016_02_03.models.OperationMonitoringLevel]
    """

    _attribute_map = {
        'events': {'key': 'events', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        events: Optional[Dict[str, Union[str, "OperationMonitoringLevel"]]] = None,
        **kwargs
    ):
        """
        :keyword events: Dictionary of :code:`<OperationMonitoringLevel>`.
        :paramtype events: dict[str, str or
         ~azure.mgmt.iothub.v2016_02_03.models.OperationMonitoringLevel]
        """
        super(OperationsMonitoringProperties, self).__init__(**kwargs)
        self.events = events


class RegistryStatistics(msrest.serialization.Model):
    """Identity registry statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_device_count: The total count of devices in the identity registry.
    :vartype total_device_count: long
    :ivar enabled_device_count: The count of enabled devices in the identity registry.
    :vartype enabled_device_count: long
    :ivar disabled_device_count: The count of disabled devices in the identity registry.
    :vartype disabled_device_count: long
    """

    _validation = {
        'total_device_count': {'readonly': True},
        'enabled_device_count': {'readonly': True},
        'disabled_device_count': {'readonly': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'long'},
        'enabled_device_count': {'key': 'enabledDeviceCount', 'type': 'long'},
        'disabled_device_count': {'key': 'disabledDeviceCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryStatistics, self).__init__(**kwargs)
        self.total_device_count = None
        self.enabled_device_count = None
        self.disabled_device_count = None


class SharedAccessSignatureAuthorizationRule(msrest.serialization.Model):
    """The properties of an IoT hub shared access policy.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The name of the shared access policy.
    :vartype key_name: str
    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    :ivar rights: Required. The permissions assigned to the shared access policy. Possible values
     include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect", "RegistryRead,
     RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect", "RegistryWrite,
     ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite, DeviceConnect",
     "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
    :vartype rights: str or ~azure.mgmt.iothub.v2016_02_03.models.AccessRights
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        rights: Union[str, "AccessRights"],
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: Required. The name of the shared access policy.
        :paramtype key_name: str
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        :keyword rights: Required. The permissions assigned to the shared access policy. Possible
         values include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect",
         "RegistryRead, RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect",
         "RegistryWrite, ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect,
         DeviceConnect", "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite,
         DeviceConnect", "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect,
         DeviceConnect", "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
        :paramtype rights: str or ~azure.mgmt.iothub.v2016_02_03.models.AccessRights
        """
        super(SharedAccessSignatureAuthorizationRule, self).__init__(**kwargs)
        self.key_name = key_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.rights = rights


class SharedAccessSignatureAuthorizationRuleListResult(msrest.serialization.Model):
    """The list of shared access policies with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shared access policies.
    :vartype value:
     list[~azure.mgmt.iothub.v2016_02_03.models.SharedAccessSignatureAuthorizationRule]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SharedAccessSignatureAuthorizationRule"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of shared access policies.
        :paramtype value:
         list[~azure.mgmt.iothub.v2016_02_03.models.SharedAccessSignatureAuthorizationRule]
        """
        super(SharedAccessSignatureAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StorageEndpointProperties(msrest.serialization.Model):
    """The properties of the Azure Storage endpoint for file upload.

    All required parameters must be populated in order to send to Azure.

    :ivar sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
     file upload is valid. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
    :vartype sas_ttl_as_iso8601: ~datetime.timedelta
    :ivar connection_string: Required. The connection string for the Azure Storage account to which
     files are uploaded.
    :vartype connection_string: str
    :ivar container_name: Required. The name of the root container where you upload files. The
     container need not exist but should be creatable using the connectionString specified.
    :vartype container_name: str
    """

    _validation = {
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        container_name: str,
        sas_ttl_as_iso8601: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
         file upload is valid. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        :paramtype sas_ttl_as_iso8601: ~datetime.timedelta
        :keyword connection_string: Required. The connection string for the Azure Storage account to
         which files are uploaded.
        :paramtype connection_string: str
        :keyword container_name: Required. The name of the root container where you upload files. The
         container need not exist but should be creatable using the connectionString specified.
        :paramtype container_name: str
        """
        super(StorageEndpointProperties, self).__init__(**kwargs)
        self.sas_ttl_as_iso8601 = sas_ttl_as_iso8601
        self.connection_string = connection_string
        self.container_name = container_name
