# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Cluster(msrest.serialization.Model):
    """Define the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this cluster
     resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the cluster.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the cluster.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar datastore_ids: Gets or sets the datastore ARM ids.
    :vartype datastore_ids: list[str]
    :ivar network_ids: Gets or sets the network ARM ids.
    :vartype network_ids: list[str]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'statuses': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'datastore_ids': {'readonly': True},
        'network_ids': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'datastore_ids': {'key': 'properties.datastoreIds', 'type': '[str]'},
        'network_ids': {'key': 'properties.networkIds', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.datastore_ids = None
        self.network_ids = None
        self.provisioning_state = None


class InventoryItemProperties(msrest.serialization.Model):
    """Defines the resource properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ClusterInventoryItem, DatastoreInventoryItem, HostInventoryItem, ResourcePoolInventoryItem, VirtualMachineInventoryItem, VirtualMachineTemplateInventoryItem, VirtualNetworkInventoryItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    _subtype_map = {
        'inventory_type': {'Cluster': 'ClusterInventoryItem', 'Datastore': 'DatastoreInventoryItem', 'Host': 'HostInventoryItem', 'ResourcePool': 'ResourcePoolInventoryItem', 'VirtualMachine': 'VirtualMachineInventoryItem', 'VirtualMachineTemplate': 'VirtualMachineTemplateInventoryItem', 'VirtualNetwork': 'VirtualNetworkInventoryItem'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InventoryItemProperties, self).__init__(**kwargs)
        self.inventory_type = None  # type: Optional[str]
        self.managed_resource_id = kwargs.get('managed_resource_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.mo_name = kwargs.get('mo_name', None)
        self.provisioning_state = None


class ClusterInventoryItem(InventoryItemProperties):
    """The cluster inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'Cluster'  # type: str


class ClustersList(msrest.serialization.Model):
    """List of Clusters.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of Clusters.
    :type next_link: str
    :param value: Required. Array of Clusters.
    :type value: list[~azure.mgmt.connectedvmware.models.Cluster]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Cluster]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClustersList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class Condition(msrest.serialization.Model):
    """Condition defines an extension to status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Status of the condition.
    :vartype status: str
    :ivar reason: The reason for the condition's status.
    :vartype reason: str
    :ivar message: A human readable message indicating details about the status.
    :vartype message: str
    :ivar severity: Severity with which to treat failures of this type of condition.
    :vartype severity: str
    """

    _validation = {
        'status': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
        'severity': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Condition, self).__init__(**kwargs)
        self.status = None
        self.reason = None
        self.message = None
        self.severity = None


class Datastore(msrest.serialization.Model):
    """Define the datastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this datastore
     resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the
     datastore.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the datastore.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the datastore.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar provisioning_state: Provisioning state of the resource. Possible values include:
     "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", "Accepted",
     "Created".
    :vartype provisioning_state: str or ~azure.mgmt.connectedvmware.models.ProvisioningState
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'statuses': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Datastore, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.provisioning_state = None


class DatastoreInventoryItem(InventoryItemProperties):
    """The datastore inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :param capacity_gb: Gets or sets Maximum capacity of this datastore, in GBs.
    :type capacity_gb: long
    :param free_space_gb: Gets or sets Available space of this datastore, in GBs.
    :type free_space_gb: long
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'capacity_gb': {'key': 'capacityGB', 'type': 'long'},
        'free_space_gb': {'key': 'freeSpaceGB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatastoreInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'Datastore'  # type: str
        self.capacity_gb = kwargs.get('capacity_gb', None)
        self.free_space_gb = kwargs.get('free_space_gb', None)


class DatastoresList(msrest.serialization.Model):
    """List of Datastores.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of Datastores.
    :type next_link: str
    :param value: Required. Array of Datastores.
    :type value: list[~azure.mgmt.connectedvmware.models.Datastore]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Datastore]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatastoresList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.connectedvmware.models.ErrorDefinition]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorDetail(msrest.serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error's code.
    :type code: str
    :param message: Required. A human readable error message.
    :type message: str
    :param target: Indicates which property in the request is responsible for the error.
    :type target: str
    :param details: Additional error details.
    :type details: list[~azure.mgmt.connectedvmware.models.ErrorDetail]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: The error details.
    :type error: ~azure.mgmt.connectedvmware.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExtendedLocation(msrest.serialization.Model):
    """The extended location.

    :param type: The extended location type.
    :type type: str
    :param name: The extended location name.
    :type name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class GuestAgent(ProxyResource):
    """Defines the GuestAgent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param credentials: Username / Password Credentials to provision guest agent.
    :type credentials: ~azure.mgmt.connectedvmware.models.GuestCredential
    :param http_proxy_config: HTTP Proxy configuration for the VM.
    :type http_proxy_config: ~azure.mgmt.connectedvmware.models.HttpProxyConfiguration
    :param provisioning_action: Gets or sets the guest agent provisioning action. Possible values
     include: "install", "uninstall", "repair".
    :type provisioning_action: str or ~azure.mgmt.connectedvmware.models.ProvisioningAction
    :ivar status: Gets or sets the guest agent status.
    :vartype status: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'uuid': {'readonly': True},
        'status': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'GuestCredential'},
        'http_proxy_config': {'key': 'properties.httpProxyConfig', 'type': 'HttpProxyConfiguration'},
        'provisioning_action': {'key': 'properties.provisioningAction', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestAgent, self).__init__(**kwargs)
        self.system_data = None
        self.uuid = None
        self.credentials = kwargs.get('credentials', None)
        self.http_proxy_config = kwargs.get('http_proxy_config', None)
        self.provisioning_action = kwargs.get('provisioning_action', None)
        self.status = None
        self.custom_resource_name = None
        self.statuses = None
        self.provisioning_state = None


class GuestAgentList(msrest.serialization.Model):
    """List of GuestAgent.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of GuestAgent.
    :type next_link: str
    :param value: Required. Array of GuestAgent.
    :type value: list[~azure.mgmt.connectedvmware.models.GuestAgent]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[GuestAgent]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestAgentList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class GuestAgentProfile(msrest.serialization.Model):
    """Defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_uuid: Specifies the VM's unique SMBIOS ID.
    :vartype vm_uuid: str
    :ivar status: The status of the hybrid machine agent. Possible values include: "Connected",
     "Disconnected", "Error".
    :vartype status: str or ~azure.mgmt.connectedvmware.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: ~datetime.datetime
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.connectedvmware.models.ErrorDetail]
    """

    _validation = {
        'vm_uuid': {'readonly': True},
        'status': {'readonly': True},
        'last_status_change': {'readonly': True},
        'agent_version': {'readonly': True},
        'error_details': {'readonly': True},
    }

    _attribute_map = {
        'vm_uuid': {'key': 'vmUuid', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': '[ErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestAgentProfile, self).__init__(**kwargs)
        self.vm_uuid = None
        self.status = None
        self.last_status_change = None
        self.agent_version = None
        self.error_details = None


class GuestCredential(msrest.serialization.Model):
    """Username / Password Credentials to connect to guest.

    :param username: Gets or sets username to connect with the guest.
    :type username: str
    :param password: Gets or sets the password to connect with the guest.
    :type password: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestCredential, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class HardwareProfile(msrest.serialization.Model):
    """Defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param memory_size_mb: Gets or sets memory size in MBs for the vm.
    :type memory_size_mb: int
    :param num_cp_us: Gets or sets the number of vCPUs for the vm.
    :type num_cp_us: int
    :param num_cores_per_socket: Gets or sets the number of cores per socket for the vm. Defaults
     to 1 if unspecified.
    :type num_cores_per_socket: int
    :ivar cpu_hot_add_enabled: Gets or sets a value indicating whether virtual processors can be
     added while this virtual machine is running.
    :vartype cpu_hot_add_enabled: bool
    :ivar cpu_hot_remove_enabled: Gets or sets a value indicating whether virtual processors can be
     removed while this virtual machine is running.
    :vartype cpu_hot_remove_enabled: bool
    :ivar memory_hot_add_enabled: Gets or sets a value indicating whether memory can be added while
     this virtual machine is running.
    :vartype memory_hot_add_enabled: bool
    """

    _validation = {
        'cpu_hot_add_enabled': {'readonly': True},
        'cpu_hot_remove_enabled': {'readonly': True},
        'memory_hot_add_enabled': {'readonly': True},
    }

    _attribute_map = {
        'memory_size_mb': {'key': 'memorySizeMB', 'type': 'int'},
        'num_cp_us': {'key': 'numCPUs', 'type': 'int'},
        'num_cores_per_socket': {'key': 'numCoresPerSocket', 'type': 'int'},
        'cpu_hot_add_enabled': {'key': 'cpuHotAddEnabled', 'type': 'bool'},
        'cpu_hot_remove_enabled': {'key': 'cpuHotRemoveEnabled', 'type': 'bool'},
        'memory_hot_add_enabled': {'key': 'memoryHotAddEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.memory_size_mb = kwargs.get('memory_size_mb', None)
        self.num_cp_us = kwargs.get('num_cp_us', None)
        self.num_cores_per_socket = kwargs.get('num_cores_per_socket', None)
        self.cpu_hot_add_enabled = None
        self.cpu_hot_remove_enabled = None
        self.memory_hot_add_enabled = None


class Host(msrest.serialization.Model):
    """Define the host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this host resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the host.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the host.
    :vartype mo_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'statuses': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Host, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.statuses = None
        self.custom_resource_name = None
        self.provisioning_state = None


class HostInventoryItem(InventoryItemProperties):
    """The host inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :param parent: Parent host inventory resource details.
    :type parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'InventoryItemDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'Host'  # type: str
        self.parent = kwargs.get('parent', None)


class HostsList(msrest.serialization.Model):
    """List of Hosts.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of Hosts.
    :type next_link: str
    :param value: Required. Array of Hosts.
    :type value: list[~azure.mgmt.connectedvmware.models.Host]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Host]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class HttpProxyConfiguration(msrest.serialization.Model):
    """HTTP Proxy configuration for the VM.

    :param https_proxy: Gets or sets httpsProxy url.
    :type https_proxy: str
    """

    _attribute_map = {
        'https_proxy': {'key': 'httpsProxy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpProxyConfiguration, self).__init__(**kwargs)
        self.https_proxy = kwargs.get('https_proxy', None)


class HybridIdentityMetadata(ProxyResource):
    """Defines the HybridIdentityMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param vm_id: Gets or sets the Vm Id.
    :type vm_id: str
    :param public_key: Gets or sets the Public Key.
    :type public_key: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.connectedvmware.models.Identity
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'identity': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
        'identity': {'key': 'properties.identity', 'type': 'Identity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridIdentityMetadata, self).__init__(**kwargs)
        self.system_data = None
        self.vm_id = kwargs.get('vm_id', None)
        self.public_key = kwargs.get('public_key', None)
        self.identity = None
        self.provisioning_state = None


class HybridIdentityMetadataList(msrest.serialization.Model):
    """List of HybridIdentityMetadata.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of HybridIdentityMetadata.
    :type next_link: str
    :param value: Required. Array of HybridIdentityMetadata.
    :type value: list[~azure.mgmt.connectedvmware.models.HybridIdentityMetadata]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[HybridIdentityMetadata]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridIdentityMetadataList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class Identity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal id of managed service identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant of managed service identity.
    :vartype tenant_id: str
    :param type: Required. The type of managed service identity. Possible values include: "None",
     "SystemAssigned".
    :type type: str or ~azure.mgmt.connectedvmware.models.IdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']


class InventoryItem(ProxyResource):
    """Defines the inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'inventory_type': {'key': 'properties.inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'properties.managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InventoryItem, self).__init__(**kwargs)
        self.system_data = None
        self.kind = kwargs.get('kind', None)
        self.inventory_type = None  # type: Optional[str]
        self.managed_resource_id = kwargs.get('managed_resource_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.mo_name = kwargs.get('mo_name', None)
        self.provisioning_state = None


class InventoryItemDetails(msrest.serialization.Model):
    """Defines the resource properties.

    :param inventory_item_id: Gets or sets the inventory Item ID for the resource.
    :type inventory_item_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the resource.
    :type mo_name: str
    """

    _attribute_map = {
        'inventory_item_id': {'key': 'inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InventoryItemDetails, self).__init__(**kwargs)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = kwargs.get('mo_name', None)


class InventoryItemsList(msrest.serialization.Model):
    """List of InventoryItems.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of InventoryItems.
    :type next_link: str
    :param value: Required. Array of InventoryItems.
    :type value: list[~azure.mgmt.connectedvmware.models.InventoryItem]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[InventoryItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InventoryItemsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class MachineExtension(msrest.serialization.Model):
    """Describes a Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Gets or sets the location.
    :type location: str
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The machine extension instance view.
    :type instance_view: ~azure.mgmt.connectedvmware.models.MachineExtensionPropertiesInstanceView
    """

    _validation = {
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'MachineExtensionPropertiesInstanceView'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtension, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class MachineExtensionInstanceView(msrest.serialization.Model):
    """Describes the Machine Extension Instance View.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :param status: Instance view status.
    :type status: ~azure.mgmt.connectedvmware.models.MachineExtensionInstanceViewStatus
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_handler_version': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.type_handler_version = None
        self.status = kwargs.get('status', None)


class MachineExtensionInstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Possible values include: "Info", "Warning", "Error".
    :vartype level: str or ~azure.mgmt.connectedvmware.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtensionInstanceViewStatus, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.display_status = None
        self.message = None
        self.time = None


class MachineExtensionPropertiesInstanceView(MachineExtensionInstanceView):
    """The machine extension instance view.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :param status: Instance view status.
    :type status: ~azure.mgmt.connectedvmware.models.MachineExtensionInstanceViewStatus
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_handler_version': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtensionPropertiesInstanceView, self).__init__(**kwargs)


class MachineExtensionsListResult(msrest.serialization.Model):
    """Describes the Machine Extensions List Result.

    :param value: The list of extensions.
    :type value: list[~azure.mgmt.connectedvmware.models.MachineExtension]
    :param next_link: The uri to fetch the next page of machine extensions. Call ListNext() with
     this to fetch the next page of extensions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MachineExtension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtensionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ResourcePatch(msrest.serialization.Model):
    """Object containing updates for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class MachineExtensionUpdate(ResourcePatch):
    """Describes a Machine Extension Update.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineExtensionUpdate, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class NetworkInterface(msrest.serialization.Model):
    """Network Interface model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Gets or sets the name of the network interface.
    :type name: str
    :ivar label: Gets or sets the label of the virtual network in vCenter that the nic is connected
     to.
    :vartype label: str
    :ivar ip_addresses: Gets or sets the nic ip addresses.
    :vartype ip_addresses: list[str]
    :ivar mac_address: Gets or sets the NIC MAC address.
    :vartype mac_address: str
    :param network_id: Gets or sets the ARM Id of the network resource to connect the virtual
     machine.
    :type network_id: str
    :param nic_type: NIC type. Possible values include: "vmxnet3", "vmxnet2", "vmxnet", "e1000",
     "e1000e", "pcnet32".
    :type nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
    :param power_on_boot: Gets or sets the power on boot. Possible values include: "enabled",
     "disabled".
    :type power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
    :ivar network_mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID of the
     virtual network
     that the nic is connected to.
    :vartype network_mo_ref_id: str
    :ivar network_mo_name: Gets or sets the name of the virtual network in vCenter that the nic is
     connected to.
    :vartype network_mo_name: str
    :param device_key: Gets or sets the device key value.
    :type device_key: int
    :param ip_settings: Gets or sets the ipsettings.
    :type ip_settings: ~azure.mgmt.connectedvmware.models.NicIPSettings
    """

    _validation = {
        'label': {'readonly': True},
        'ip_addresses': {'readonly': True},
        'mac_address': {'readonly': True},
        'network_mo_ref_id': {'readonly': True},
        'network_mo_name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'nic_type': {'key': 'nicType', 'type': 'str'},
        'power_on_boot': {'key': 'powerOnBoot', 'type': 'str'},
        'network_mo_ref_id': {'key': 'networkMoRefId', 'type': 'str'},
        'network_mo_name': {'key': 'networkMoName', 'type': 'str'},
        'device_key': {'key': 'deviceKey', 'type': 'int'},
        'ip_settings': {'key': 'ipSettings', 'type': 'NicIPSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterface, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.label = None
        self.ip_addresses = None
        self.mac_address = None
        self.network_id = kwargs.get('network_id', None)
        self.nic_type = kwargs.get('nic_type', None)
        self.power_on_boot = kwargs.get('power_on_boot', None)
        self.network_mo_ref_id = None
        self.network_mo_name = None
        self.device_key = kwargs.get('device_key', None)
        self.ip_settings = kwargs.get('ip_settings', None)


class NetworkInterfaceUpdate(msrest.serialization.Model):
    """Defines the network interface update.

    :param name: Gets or sets the name of the network interface.
    :type name: str
    :param network_id: Gets or sets the ARM Id of the network resource to connect the virtual
     machine.
    :type network_id: str
    :param nic_type: NIC type. Possible values include: "vmxnet3", "vmxnet2", "vmxnet", "e1000",
     "e1000e", "pcnet32".
    :type nic_type: str or ~azure.mgmt.connectedvmware.models.NICType
    :param power_on_boot: Gets or sets the power on boot. Possible values include: "enabled",
     "disabled".
    :type power_on_boot: str or ~azure.mgmt.connectedvmware.models.PowerOnBootOption
    :param device_key: Gets or sets the device key value.
    :type device_key: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'nic_type': {'key': 'nicType', 'type': 'str'},
        'power_on_boot': {'key': 'powerOnBoot', 'type': 'str'},
        'device_key': {'key': 'deviceKey', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkInterfaceUpdate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.network_id = kwargs.get('network_id', None)
        self.nic_type = kwargs.get('nic_type', None)
        self.power_on_boot = kwargs.get('power_on_boot', None)
        self.device_key = kwargs.get('device_key', None)


class NetworkProfile(msrest.serialization.Model):
    """Defines the resource properties.

    :param network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :type network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterface]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterface]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class NetworkProfileUpdate(msrest.serialization.Model):
    """Defines the update resource properties.

    :param network_interfaces: Gets or sets the list of network interfaces associated with the
     virtual machine.
    :type network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterfaceUpdate]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterfaceUpdate]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfileUpdate, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)


class NicIPAddressSettings(msrest.serialization.Model):
    """IP address information for a virtual network adapter reported by the fabric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar allocation_method: Gets the ip address allocation method.
    :vartype allocation_method: str
    :ivar ip_address: Gets the ip address for the nic.
    :vartype ip_address: str
    :ivar subnet_mask: Gets the mask.
    :vartype subnet_mask: str
    """

    _validation = {
        'allocation_method': {'readonly': True},
        'ip_address': {'readonly': True},
        'subnet_mask': {'readonly': True},
    }

    _attribute_map = {
        'allocation_method': {'key': 'allocationMethod', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NicIPAddressSettings, self).__init__(**kwargs)
        self.allocation_method = None
        self.ip_address = None
        self.subnet_mask = None


class NicIPSettings(msrest.serialization.Model):
    """Defines the network interface ip settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param allocation_method: Gets or sets the nic allocation method. Possible values include:
     "unset", "dynamic", "static", "linklayer", "random", "other".
    :type allocation_method: str or ~azure.mgmt.connectedvmware.models.IPAddressAllocationMethod
    :param dns_servers: Gets or sets the dns servers.
    :type dns_servers: list[str]
    :param gateway: Gets or sets the gateway.
    :type gateway: list[str]
    :param ip_address: Gets or sets the ip address for the nic.
    :type ip_address: str
    :param subnet_mask: Gets or sets the mask.
    :type subnet_mask: str
    :ivar primary_wins_server: Gets or sets the primary server.
    :vartype primary_wins_server: str
    :ivar secondary_wins_server: Gets or sets the secondary server.
    :vartype secondary_wins_server: str
    :ivar ip_address_info: Gets or sets the IP address information being reported for this NIC.
     This contains the same IPv4 information above plus IPV6 information.
    :vartype ip_address_info: list[~azure.mgmt.connectedvmware.models.NicIPAddressSettings]
    """

    _validation = {
        'primary_wins_server': {'readonly': True},
        'secondary_wins_server': {'readonly': True},
        'ip_address_info': {'readonly': True},
    }

    _attribute_map = {
        'allocation_method': {'key': 'allocationMethod', 'type': 'str'},
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'gateway': {'key': 'gateway', 'type': '[str]'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
        'primary_wins_server': {'key': 'primaryWinsServer', 'type': 'str'},
        'secondary_wins_server': {'key': 'secondaryWinsServer', 'type': 'str'},
        'ip_address_info': {'key': 'ipAddressInfo', 'type': '[NicIPAddressSettings]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NicIPSettings, self).__init__(**kwargs)
        self.allocation_method = kwargs.get('allocation_method', None)
        self.dns_servers = kwargs.get('dns_servers', None)
        self.gateway = kwargs.get('gateway', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.subnet_mask = kwargs.get('subnet_mask', None)
        self.primary_wins_server = None
        self.secondary_wins_server = None
        self.ip_address_info = None


class Operation(msrest.serialization.Model):
    """Operation provided by provider.

    :param name: Name of the operation.
    :type name: str
    :param is_data_action: Indicates whether the operation is data action or not.
    :type is_data_action: bool
    :param display: Properties of the operation.
    :type display: ~azure.mgmt.connectedvmware.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Properties of the operation.

    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    :param operation: Operation name.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationsList(msrest.serialization.Model):
    """Lists the operations available.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of operations.
    :type next_link: str
    :param value: Required. Array of operations.
    :type value: list[~azure.mgmt.connectedvmware.models.Operation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class OsProfile(msrest.serialization.Model):
    """Defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param computer_name: Gets or sets computer name.
    :type computer_name: str
    :param admin_username: Gets or sets administrator username.
    :type admin_username: str
    :param admin_password: Gets or sets administrator password.
    :type admin_password: str
    :param os_type: Gets or sets the type of the os. Possible values include: "Windows", "Linux",
     "Other".
    :type os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar tools_running_status: Gets or sets the current running status of VMware Tools running in
     the guest operating system.
    :vartype tools_running_status: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    """

    _validation = {
        'os_name': {'readonly': True},
        'tools_running_status': {'readonly': True},
        'tools_version_status': {'readonly': True},
        'tools_version': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'tools_running_status': {'key': 'toolsRunningStatus', 'type': 'str'},
        'tools_version_status': {'key': 'toolsVersionStatus', 'type': 'str'},
        'tools_version': {'key': 'toolsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OsProfile, self).__init__(**kwargs)
        self.computer_name = kwargs.get('computer_name', None)
        self.admin_username = kwargs.get('admin_username', None)
        self.admin_password = kwargs.get('admin_password', None)
        self.os_type = kwargs.get('os_type', None)
        self.os_name = None
        self.tools_running_status = None
        self.tools_version_status = None
        self.tools_version = None


class PlacementProfile(msrest.serialization.Model):
    """Defines the resource properties.

    :param resource_pool_id: Gets or sets the ARM Id of the resourcePool resource on which this
     virtual machine will deploy.
    :type resource_pool_id: str
    :param cluster_id: Gets or sets the ARM Id of the cluster resource on which this virtual
     machine will deploy.
    :type cluster_id: str
    :param host_id: Gets or sets the ARM Id of the host resource on which this virtual machine will
     deploy.
    :type host_id: str
    :param datastore_id: Gets or sets the ARM Id of the datastore resource on which the data for
     the virtual machine will be kept.
    :type datastore_id: str
    """

    _attribute_map = {
        'resource_pool_id': {'key': 'resourcePoolId', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'str'},
        'host_id': {'key': 'hostId', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlacementProfile, self).__init__(**kwargs)
        self.resource_pool_id = kwargs.get('resource_pool_id', None)
        self.cluster_id = kwargs.get('cluster_id', None)
        self.host_id = kwargs.get('host_id', None)
        self.datastore_id = kwargs.get('datastore_id', None)


class ResourcePool(msrest.serialization.Model):
    """Define the resourcePool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource pool
     resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource
     pool.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the resource pool.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the resource pool.
    :vartype mo_name: str
    :ivar cpu_shares_level: Gets or sets CPUSharesLevel which specifies the CPU allocation level
     for this pool.
     This property is used in relative allocation between resource consumers.
    :vartype cpu_shares_level: str
    :ivar cpu_reservation_m_hz: Gets or sets CPUReservationMHz which specifies the CPU size in MHz
     that is guaranteed
     to be available.
    :vartype cpu_reservation_m_hz: long
    :ivar cpu_limit_m_hz: Gets or sets CPULimitMHz which specifies a CPU usage limit in MHz.
     Utilization will not exceed this limit even if there are available resources.
    :vartype cpu_limit_m_hz: long
    :ivar mem_shares_level: Gets or sets CPUSharesLevel which specifies the memory allocation level
     for this pool.
     This property is used in relative allocation between resource consumers.
    :vartype mem_shares_level: str
    :ivar mem_reservation_mb: Gets or sets MemReservationMB which specifies the guaranteed
     available memory in
     megabytes.
    :vartype mem_reservation_mb: long
    :ivar mem_limit_mb: Gets or sets MemLimitMB specifies a memory usage limit in megabytes.
     Utilization will not exceed the specified limit even if there are available resources.
    :vartype mem_limit_mb: long
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'cpu_shares_level': {'readonly': True},
        'cpu_reservation_m_hz': {'readonly': True},
        'cpu_limit_m_hz': {'readonly': True},
        'mem_shares_level': {'readonly': True},
        'mem_reservation_mb': {'readonly': True},
        'mem_limit_mb': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'cpu_shares_level': {'key': 'properties.cpuSharesLevel', 'type': 'str'},
        'cpu_reservation_m_hz': {'key': 'properties.cpuReservationMHz', 'type': 'long'},
        'cpu_limit_m_hz': {'key': 'properties.cpuLimitMHz', 'type': 'long'},
        'mem_shares_level': {'key': 'properties.memSharesLevel', 'type': 'str'},
        'mem_reservation_mb': {'key': 'properties.memReservationMB', 'type': 'long'},
        'mem_limit_mb': {'key': 'properties.memLimitMB', 'type': 'long'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourcePool, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.cpu_shares_level = None
        self.cpu_reservation_m_hz = None
        self.cpu_limit_m_hz = None
        self.mem_shares_level = None
        self.mem_reservation_mb = None
        self.mem_limit_mb = None
        self.custom_resource_name = None
        self.statuses = None
        self.provisioning_state = None


class ResourcePoolInventoryItem(InventoryItemProperties):
    """The resource pool inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :param parent: Parent resourcePool inventory resource details.
    :type parent: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'InventoryItemDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourcePoolInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'ResourcePool'  # type: str
        self.parent = kwargs.get('parent', None)


class ResourcePoolsList(msrest.serialization.Model):
    """List of ResourcePools.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of ResourcePools.
    :type next_link: str
    :param value: Required. Array of ResourcePools.
    :type value: list[~azure.mgmt.connectedvmware.models.ResourcePool]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ResourcePool]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourcePoolsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class ResourceStatus(msrest.serialization.Model):
    """The resource status information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the condition.
    :vartype type: str
    :ivar status: Status of the condition.
    :vartype status: str
    :ivar reason: The reason for the condition's status.
    :vartype reason: str
    :ivar message: A human readable message indicating details about the status.
    :vartype message: str
    :ivar severity: Severity with which to treat failures of this type of condition.
    :vartype severity: str
    :ivar last_updated_at: The last update time for this condition.
    :vartype last_updated_at: ~datetime.datetime
    """

    _validation = {
        'type': {'readonly': True},
        'status': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
        'severity': {'readonly': True},
        'last_updated_at': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'last_updated_at': {'key': 'lastUpdatedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceStatus, self).__init__(**kwargs)
        self.type = None
        self.status = None
        self.reason = None
        self.message = None
        self.severity = None
        self.last_updated_at = None


class StopVirtualMachineOptions(msrest.serialization.Model):
    """Defines the stop action properties.

    :param skip_shutdown: Gets or sets a value indicating whether to request non-graceful VM
     shutdown. True value for this flag indicates non-graceful shutdown whereas false indicates
     otherwise. Defaults to false.
    :type skip_shutdown: bool
    """

    _attribute_map = {
        'skip_shutdown': {'key': 'skipShutdown', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StopVirtualMachineOptions, self).__init__(**kwargs)
        self.skip_shutdown = kwargs.get('skip_shutdown', False)


class StorageProfile(msrest.serialization.Model):
    """Defines the resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :type disks: list[~azure.mgmt.connectedvmware.models.VirtualDisk]
    :ivar scsi_controllers: Gets or sets the list of virtual SCSI controllers associated with the
     virtual machine.
    :vartype scsi_controllers: list[~azure.mgmt.connectedvmware.models.VirtualSCSIController]
    """

    _validation = {
        'scsi_controllers': {'readonly': True},
    }

    _attribute_map = {
        'disks': {'key': 'disks', 'type': '[VirtualDisk]'},
        'scsi_controllers': {'key': 'scsiControllers', 'type': '[VirtualSCSIController]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.disks = kwargs.get('disks', None)
        self.scsi_controllers = None


class StorageProfileUpdate(msrest.serialization.Model):
    """Defines the resource update properties.

    :param disks: Gets or sets the list of virtual disks associated with the virtual machine.
    :type disks: list[~azure.mgmt.connectedvmware.models.VirtualDiskUpdate]
    """

    _attribute_map = {
        'disks': {'key': 'disks', 'type': '[VirtualDiskUpdate]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfileUpdate, self).__init__(**kwargs)
        self.disks = kwargs.get('disks', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.connectedvmware.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class VCenter(msrest.serialization.Model):
    """Defines the vCenter.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param fqdn: Required. Gets or sets the FQDN/IPAddress of the vCenter.
    :type fqdn: str
    :param port: Gets or sets the port of the vCenter.
    :type port: int
    :ivar version: Gets or sets the version of the vCenter.
    :vartype version: str
    :ivar instance_uuid: Gets or sets the instance UUID of the vCenter.
    :vartype instance_uuid: str
    :ivar connection_status: Gets or sets the connection status to the vCenter.
    :vartype connection_status: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :param credentials: Username / Password Credentials to connect to vcenter.
    :type credentials: ~azure.mgmt.connectedvmware.models.VICredential
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'fqdn': {'required': True},
        'port': {'maximum': 65535, 'minimum': 1},
        'version': {'readonly': True},
        'instance_uuid': {'readonly': True},
        'connection_status': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'instance_uuid': {'key': 'properties.instanceUuid', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': 'VICredential'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VCenter, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.fqdn = kwargs['fqdn']
        self.port = kwargs.get('port', None)
        self.version = None
        self.instance_uuid = None
        self.connection_status = None
        self.custom_resource_name = None
        self.credentials = kwargs.get('credentials', None)
        self.statuses = None
        self.provisioning_state = None


class VCentersList(msrest.serialization.Model):
    """List of VCenters.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of VCenters.
    :type next_link: str
    :param value: Required. Array of VCenters.
    :type value: list[~azure.mgmt.connectedvmware.models.VCenter]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[VCenter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VCentersList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class VICredential(msrest.serialization.Model):
    """Username / Password Credentials to connect to vcenter.

    :param username: Gets or sets username to connect with the vCenter.
    :type username: str
    :param password: Gets or sets the password to connect with the vCenter.
    :type password: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VICredential, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class VirtualDisk(msrest.serialization.Model):
    """Virtual disk model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Gets or sets the name of the virtual disk.
    :type name: str
    :ivar label: Gets or sets the label of the virtual disk in vCenter.
    :vartype label: str
    :ivar disk_object_id: Gets or sets the disk object id.
    :vartype disk_object_id: str
    :param disk_size_gb: Gets or sets the disk total size.
    :type disk_size_gb: int
    :param device_key: Gets or sets the device key value.
    :type device_key: int
    :param disk_mode: Gets or sets the disk mode. Possible values include: "persistent",
     "independent_persistent", "independent_nonpersistent".
    :type disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
    :param controller_key: Gets or sets the controller id.
    :type controller_key: int
    :param unit_number: Gets or sets the unit number of the disk on the controller.
    :type unit_number: int
    :param device_name: Gets or sets the device name.
    :type device_name: str
    :param disk_type: Gets or sets the disk backing type. Possible values include: "flat", "pmem",
     "rawphysical", "rawvirtual", "sparse", "sesparse", "unknown".
    :type disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
    """

    _validation = {
        'label': {'readonly': True},
        'disk_object_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'disk_object_id': {'key': 'diskObjectId', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'device_key': {'key': 'deviceKey', 'type': 'int'},
        'disk_mode': {'key': 'diskMode', 'type': 'str'},
        'controller_key': {'key': 'controllerKey', 'type': 'int'},
        'unit_number': {'key': 'unitNumber', 'type': 'int'},
        'device_name': {'key': 'deviceName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualDisk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.label = None
        self.disk_object_id = None
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.device_key = kwargs.get('device_key', None)
        self.disk_mode = kwargs.get('disk_mode', None)
        self.controller_key = kwargs.get('controller_key', None)
        self.unit_number = kwargs.get('unit_number', None)
        self.device_name = kwargs.get('device_name', None)
        self.disk_type = kwargs.get('disk_type', None)


class VirtualDiskUpdate(msrest.serialization.Model):
    """Defines the virtual disk update.

    :param name: Gets or sets the name of the virtual disk.
    :type name: str
    :param disk_size_gb: Gets or sets the disk total size.
    :type disk_size_gb: int
    :param device_key: Gets or sets the device key value.
    :type device_key: int
    :param disk_mode: Gets or sets the disk mode. Possible values include: "persistent",
     "independent_persistent", "independent_nonpersistent".
    :type disk_mode: str or ~azure.mgmt.connectedvmware.models.DiskMode
    :param controller_key: Gets or sets the controller id.
    :type controller_key: int
    :param unit_number: Gets or sets the unit number of the disk on the controller.
    :type unit_number: int
    :param device_name: Gets or sets the device name.
    :type device_name: str
    :param disk_type: Gets or sets the disk backing type. Possible values include: "flat", "pmem",
     "rawphysical", "rawvirtual", "sparse", "sesparse", "unknown".
    :type disk_type: str or ~azure.mgmt.connectedvmware.models.DiskType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'device_key': {'key': 'deviceKey', 'type': 'int'},
        'disk_mode': {'key': 'diskMode', 'type': 'str'},
        'controller_key': {'key': 'controllerKey', 'type': 'int'},
        'unit_number': {'key': 'unitNumber', 'type': 'int'},
        'device_name': {'key': 'deviceName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualDiskUpdate, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.device_key = kwargs.get('device_key', None)
        self.disk_mode = kwargs.get('disk_mode', None)
        self.controller_key = kwargs.get('controller_key', None)
        self.unit_number = kwargs.get('unit_number', None)
        self.device_name = kwargs.get('device_name', None)
        self.disk_type = kwargs.get('disk_type', None)


class VirtualMachine(msrest.serialization.Model):
    """Define the virtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.connectedvmware.models.Identity
    :param resource_pool_id: Gets or sets the ARM Id of the resourcePool resource on which this
     virtual machine will
     deploy.
    :type resource_pool_id: str
    :param template_id: Gets or sets the ARM Id of the template resource to deploy the virtual
     machine.
    :type template_id: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this resource pool
     resides.
    :type v_center_id: str
    :param placement_profile: Placement properties.
    :type placement_profile: ~azure.mgmt.connectedvmware.models.PlacementProfile
    :param os_profile: OS properties.
    :type os_profile: ~azure.mgmt.connectedvmware.models.OsProfile
    :param hardware_profile: Hardware properties.
    :type hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
    :param network_profile: Network properties.
    :type network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfile
    :param storage_profile: Storage properties.
    :type storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfile
    :param guest_agent_profile: Guest agent status properties.
    :type guest_agent_profile: ~azure.mgmt.connectedvmware.models.GuestAgentProfile
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     machine.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the virtual machine.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual machine.
    :vartype mo_name: str
    :ivar folder_path: Gets or sets the folder path of the vm.
    :vartype folder_path: str
    :ivar instance_uuid: Gets or sets the instance uuid of the vm.
    :vartype instance_uuid: str
    :param smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
    :type smbios_uuid: str
    :param firmware_type: Firmware type. Possible values include: "bios", "efi".
    :type firmware_type: str or ~azure.mgmt.connectedvmware.models.FirmwareType
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :ivar vm_id: Gets or sets a unique identifier for the vm resource.
    :vartype vm_id: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'mo_name': {'readonly': True},
        'folder_path': {'readonly': True},
        'instance_uuid': {'readonly': True},
        'power_state': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'uuid': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'resource_pool_id': {'key': 'properties.resourcePoolId', 'type': 'str'},
        'template_id': {'key': 'properties.templateId', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'placement_profile': {'key': 'properties.placementProfile', 'type': 'PlacementProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OsProfile'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'guest_agent_profile': {'key': 'properties.guestAgentProfile', 'type': 'GuestAgentProfile'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'instance_uuid': {'key': 'properties.instanceUuid', 'type': 'str'},
        'smbios_uuid': {'key': 'properties.smbiosUuid', 'type': 'str'},
        'firmware_type': {'key': 'properties.firmwareType', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'str'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.identity = kwargs.get('identity', None)
        self.resource_pool_id = kwargs.get('resource_pool_id', None)
        self.template_id = kwargs.get('template_id', None)
        self.v_center_id = kwargs.get('v_center_id', None)
        self.placement_profile = kwargs.get('placement_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.guest_agent_profile = kwargs.get('guest_agent_profile', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.folder_path = None
        self.instance_uuid = None
        self.smbios_uuid = kwargs.get('smbios_uuid', None)
        self.firmware_type = kwargs.get('firmware_type', None)
        self.power_state = None
        self.custom_resource_name = None
        self.uuid = None
        self.statuses = None
        self.provisioning_state = None
        self.vm_id = None


class VirtualMachineInventoryItem(InventoryItemProperties):
    """The VM inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :param os_type: Gets or sets the type of the os. Possible values include: "Windows", "Linux",
     "Other".
    :type os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :param os_name: Gets or sets os name.
    :type os_name: str
    :param ip_addresses: Gets or sets the nic ip addresses.
    :type ip_addresses: list[str]
    :param folder_path: Gets or sets the folder path of the vm.
    :type folder_path: str
    :param host: Host inventory resource details.
    :type host: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    :param resource_pool: ResourcePool inventory resource details.
    :type resource_pool: ~azure.mgmt.connectedvmware.models.InventoryItemDetails
    :param instance_uuid: Gets or sets the instance uuid of the vm.
    :type instance_uuid: str
    :param smbios_uuid: Gets or sets the SMBIOS UUID of the vm.
    :type smbios_uuid: str
    :ivar power_state: Gets the power state of the virtual machine.
    :vartype power_state: str
    :ivar tools_running_status: Gets or sets the current running status of VMware Tools running in
     the guest operating system.
    :vartype tools_running_status: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'power_state': {'readonly': True},
        'tools_running_status': {'readonly': True},
        'tools_version_status': {'readonly': True},
        'tools_version': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'folder_path': {'key': 'folderPath', 'type': 'str'},
        'host': {'key': 'host', 'type': 'InventoryItemDetails'},
        'resource_pool': {'key': 'resourcePool', 'type': 'InventoryItemDetails'},
        'instance_uuid': {'key': 'instanceUuid', 'type': 'str'},
        'smbios_uuid': {'key': 'smbiosUuid', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'str'},
        'tools_running_status': {'key': 'toolsRunningStatus', 'type': 'str'},
        'tools_version_status': {'key': 'toolsVersionStatus', 'type': 'str'},
        'tools_version': {'key': 'toolsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'VirtualMachine'  # type: str
        self.os_type = kwargs.get('os_type', None)
        self.os_name = kwargs.get('os_name', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)
        self.folder_path = kwargs.get('folder_path', None)
        self.host = kwargs.get('host', None)
        self.resource_pool = kwargs.get('resource_pool', None)
        self.instance_uuid = kwargs.get('instance_uuid', None)
        self.smbios_uuid = kwargs.get('smbios_uuid', None)
        self.power_state = None
        self.tools_running_status = None
        self.tools_version_status = None
        self.tools_version = None


class VirtualMachinesList(msrest.serialization.Model):
    """List of VirtualMachines.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of VirtualMachines.
    :type next_link: str
    :param value: Required. Array of VirtualMachines.
    :type value: list[~azure.mgmt.connectedvmware.models.VirtualMachine]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[VirtualMachine]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachinesList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class VirtualMachineTemplate(msrest.serialization.Model):
    """Define the virtualMachineTemplate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
     resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     machine
     template.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the virtual machine template.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual machine template.
    :vartype mo_name: str
    :ivar memory_size_mb: Gets or sets memory size in MBs for the template.
    :vartype memory_size_mb: int
    :ivar num_cp_us: Gets or sets the number of vCPUs for the template.
    :vartype num_cp_us: int
    :ivar num_cores_per_socket: Gets or sets the number of cores per socket for the template.
     Defaults to 1 if unspecified.
    :vartype num_cores_per_socket: int
    :ivar os_type: Gets or sets the type of the os. Possible values include: "Windows", "Linux",
     "Other".
    :vartype os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :ivar os_name: Gets or sets os name.
    :vartype os_name: str
    :ivar folder_path: Gets or sets the folder path of the template.
    :vartype folder_path: str
    :ivar network_interfaces: Gets or sets the network interfaces of the template.
    :vartype network_interfaces: list[~azure.mgmt.connectedvmware.models.NetworkInterface]
    :ivar disks: Gets or sets the disks the template.
    :vartype disks: list[~azure.mgmt.connectedvmware.models.VirtualDisk]
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar tools_version_status: Gets or sets the current version status of VMware Tools installed
     in the guest operating system.
    :vartype tools_version_status: str
    :ivar tools_version: Gets or sets the current version of VMware Tools.
    :vartype tools_version: str
    :ivar firmware_type: Firmware type. Possible values include: "bios", "efi".
    :vartype firmware_type: str or ~azure.mgmt.connectedvmware.models.FirmwareType
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'memory_size_mb': {'readonly': True},
        'num_cp_us': {'readonly': True},
        'num_cores_per_socket': {'readonly': True},
        'os_type': {'readonly': True},
        'os_name': {'readonly': True},
        'folder_path': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'disks': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'tools_version_status': {'readonly': True},
        'tools_version': {'readonly': True},
        'firmware_type': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'memory_size_mb': {'key': 'properties.memorySizeMB', 'type': 'int'},
        'num_cp_us': {'key': 'properties.numCPUs', 'type': 'int'},
        'num_cores_per_socket': {'key': 'properties.numCoresPerSocket', 'type': 'int'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'disks': {'key': 'properties.disks', 'type': '[VirtualDisk]'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'tools_version_status': {'key': 'properties.toolsVersionStatus', 'type': 'str'},
        'tools_version': {'key': 'properties.toolsVersion', 'type': 'str'},
        'firmware_type': {'key': 'properties.firmwareType', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineTemplate, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.memory_size_mb = None
        self.num_cp_us = None
        self.num_cores_per_socket = None
        self.os_type = None
        self.os_name = None
        self.folder_path = None
        self.network_interfaces = None
        self.disks = None
        self.custom_resource_name = None
        self.tools_version_status = None
        self.tools_version = None
        self.firmware_type = None
        self.statuses = None
        self.provisioning_state = None


class VirtualMachineTemplateInventoryItem(InventoryItemProperties):
    """The VM Template inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    :param memory_size_mb: Gets or sets memory size in MBs for the template.
    :type memory_size_mb: int
    :param num_cp_us: Gets or sets the number of vCPUs for the template.
    :type num_cp_us: int
    :param num_cores_per_socket: Gets or sets the number of cores per socket for the template.
     Defaults to 1 if unspecified.
    :type num_cores_per_socket: int
    :param os_type: Gets or sets the type of the os. Possible values include: "Windows", "Linux",
     "Other".
    :type os_type: str or ~azure.mgmt.connectedvmware.models.OsType
    :param os_name: Gets or sets os name.
    :type os_name: str
    :param folder_path: Gets or sets the folder path of the template.
    :type folder_path: str
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'memory_size_mb': {'key': 'memorySizeMB', 'type': 'int'},
        'num_cp_us': {'key': 'numCPUs', 'type': 'int'},
        'num_cores_per_socket': {'key': 'numCoresPerSocket', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineTemplateInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'VirtualMachineTemplate'  # type: str
        self.memory_size_mb = kwargs.get('memory_size_mb', None)
        self.num_cp_us = kwargs.get('num_cp_us', None)
        self.num_cores_per_socket = kwargs.get('num_cores_per_socket', None)
        self.os_type = kwargs.get('os_type', None)
        self.os_name = kwargs.get('os_name', None)
        self.folder_path = kwargs.get('folder_path', None)


class VirtualMachineTemplatesList(msrest.serialization.Model):
    """List of VirtualMachineTemplates.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of VirtualMachineTemplates.
    :type next_link: str
    :param value: Required. Array of VirtualMachineTemplates.
    :type value: list[~azure.mgmt.connectedvmware.models.VirtualMachineTemplate]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[VirtualMachineTemplate]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineTemplatesList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class VirtualMachineUpdate(msrest.serialization.Model):
    """Defines the virtualMachineUpdate.

    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.connectedvmware.models.Identity
    :param hardware_profile: Defines the resource properties.
    :type hardware_profile: ~azure.mgmt.connectedvmware.models.HardwareProfile
    :param storage_profile: Defines the resource update properties.
    :type storage_profile: ~azure.mgmt.connectedvmware.models.StorageProfileUpdate
    :param network_profile: Defines the update resource properties.
    :type network_profile: ~azure.mgmt.connectedvmware.models.NetworkProfileUpdate
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfileUpdate'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfileUpdate'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.network_profile = kwargs.get('network_profile', None)


class VirtualNetwork(msrest.serialization.Model):
    """Define the virtualNetwork.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Gets or sets the location.
    :type location: str
    :param extended_location: Gets or sets the extended location.
    :type extended_location: ~azure.mgmt.connectedvmware.models.ExtendedLocation
    :ivar system_data: The system data.
    :vartype system_data: ~azure.mgmt.connectedvmware.models.SystemData
    :param tags: A set of tags. Gets or sets the Resource tags.
    :type tags: dict[str, str]
    :ivar name: Gets or sets the name.
    :vartype name: str
    :ivar id: Gets or sets the Id.
    :vartype id: str
    :ivar type: Gets or sets the type of the resource.
    :vartype type: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar uuid: Gets or sets a unique identifier for this resource.
    :vartype uuid: str
    :param v_center_id: Gets or sets the ARM Id of the vCenter resource in which this template
     resides.
    :type v_center_id: str
    :param mo_ref_id: Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual
     network.
    :type mo_ref_id: str
    :param inventory_item_id: Gets or sets the inventory Item ID for the virtual network.
    :type inventory_item_id: str
    :ivar mo_name: Gets or sets the vCenter Managed Object name for the virtual network.
    :vartype mo_name: str
    :ivar custom_resource_name: Gets the name of the corresponding resource in Kubernetes.
    :vartype custom_resource_name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.connectedvmware.models.ResourceStatus]
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'system_data': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'uuid': {'readonly': True},
        'mo_name': {'readonly': True},
        'custom_resource_name': {'readonly': True},
        'statuses': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'uuid': {'key': 'properties.uuid', 'type': 'str'},
        'v_center_id': {'key': 'properties.vCenterId', 'type': 'str'},
        'mo_ref_id': {'key': 'properties.moRefId', 'type': 'str'},
        'inventory_item_id': {'key': 'properties.inventoryItemId', 'type': 'str'},
        'mo_name': {'key': 'properties.moName', 'type': 'str'},
        'custom_resource_name': {'key': 'properties.customResourceName', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ResourceStatus]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.system_data = None
        self.tags = kwargs.get('tags', None)
        self.name = None
        self.id = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.uuid = None
        self.v_center_id = kwargs.get('v_center_id', None)
        self.mo_ref_id = kwargs.get('mo_ref_id', None)
        self.inventory_item_id = kwargs.get('inventory_item_id', None)
        self.mo_name = None
        self.custom_resource_name = None
        self.statuses = None
        self.provisioning_state = None


class VirtualNetworkInventoryItem(InventoryItemProperties):
    """The Virtual network inventory item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param inventory_type: Required. They inventory type.Constant filled by server.  Possible
     values include: "ResourcePool", "VirtualMachine", "VirtualMachineTemplate", "VirtualNetwork",
     "Cluster", "Datastore", "Host".
    :type inventory_type: str or ~azure.mgmt.connectedvmware.models.InventoryType
    :param managed_resource_id: Gets or sets the tracked resource id corresponding to the inventory
     resource.
    :type managed_resource_id: str
    :param mo_ref_id: Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
    :type mo_ref_id: str
    :param mo_name: Gets or sets the vCenter Managed Object name for the inventory item.
    :type mo_name: str
    :ivar provisioning_state: Gets or sets the provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'inventory_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'inventory_type': {'key': 'inventoryType', 'type': 'str'},
        'managed_resource_id': {'key': 'managedResourceId', 'type': 'str'},
        'mo_ref_id': {'key': 'moRefId', 'type': 'str'},
        'mo_name': {'key': 'moName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkInventoryItem, self).__init__(**kwargs)
        self.inventory_type = 'VirtualNetwork'  # type: str


class VirtualNetworksList(msrest.serialization.Model):
    """List of VirtualNetworks.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Url to follow for getting next page of VirtualNetworks.
    :type next_link: str
    :param value: Required. Array of VirtualNetworks.
    :type value: list[~azure.mgmt.connectedvmware.models.VirtualNetwork]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworksList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class VirtualSCSIController(msrest.serialization.Model):
    """This data object type contains the properties of a SCSI controller device attached to a virtual machine that is reported by the controller.

    :param type: Gets or sets the controller type. Possible values include: "lsilogic", "buslogic",
     "pvscsi", "lsilogicsas".
    :type type: str or ~azure.mgmt.connectedvmware.models.SCSIControllerType
    :param controller_key: Gets or sets the key of the controller.
    :type controller_key: int
    :param bus_number: Gets or sets the bus number of the controller.
    :type bus_number: int
    :param scsi_ctlr_unit_number: Gets or sets the SCSI controller unit number.
    :type scsi_ctlr_unit_number: int
    :param sharing: Gets or sets the sharing mode. Possible values include: "noSharing",
     "physicalSharing", "virtualSharing".
    :type sharing: str or ~azure.mgmt.connectedvmware.models.VirtualSCSISharing
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'controller_key': {'key': 'controllerKey', 'type': 'int'},
        'bus_number': {'key': 'busNumber', 'type': 'int'},
        'scsi_ctlr_unit_number': {'key': 'scsiCtlrUnitNumber', 'type': 'int'},
        'sharing': {'key': 'sharing', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualSCSIController, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.controller_key = kwargs.get('controller_key', None)
        self.bus_number = kwargs.get('bus_number', None)
        self.scsi_ctlr_unit_number = kwargs.get('scsi_ctlr_unit_number', None)
        self.sharing = kwargs.get('sharing', None)
