#!/usr/bin/python3
#
# Title:       Moderate Security Announcement for pcp SUSE-SU-2021:1292-1
# Description: Security fixes for SUSE Linux Enterprise 15 SP0 LTSS
# Source:      Security Announcement Parser v1.6.1
# Modified:    2021 May 04
#
##############################################################################
# Copyright (C) 2021 SUSE LLC
##############################################################################
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
#  Authors/Contributors:
#   Jason Record <jason.record@suse.com>
#
##############################################################################

import os
import Core
import SUSE

META_CLASS = "Security"
META_CATEGORY = "SLE"
META_COMPONENT = "pcp"
PATTERN_ID = os.path.basename(__file__)
PRIMARY_LINK = "META_LINK_Security"
OVERALL = Core.TEMP
OVERALL_INFO = "NOT SET"
OTHER_LINKS = "META_LINK_Security=https://lists.suse.com/pipermail/sle-security-updates/2021-April/008668.html"
Core.init(META_CLASS, META_CATEGORY, META_COMPONENT, PATTERN_ID, PRIMARY_LINK, OVERALL, OVERALL_INFO, OTHER_LINKS)

LTSS = True
NAME = 'pcp'
MAIN = ''
SEVERITY = 'Moderate'
TAG = 'SUSE-SU-2021:1292-1'
PACKAGES = {}
SERVER = SUSE.getHostInfo()

if ( SERVER['DistroVersion'] == 15):
	if ( SERVER['DistroPatchLevel'] == 0 ):
		PACKAGES = {
			'libpcp-devel': '3.11.9-5.11.5',
			'libpcp3': '3.11.9-5.11.5',
			'libpcp3-debuginfo': '3.11.9-5.11.5',
			'libpcp_gui2': '3.11.9-5.11.5',
			'libpcp_gui2-debuginfo': '3.11.9-5.11.5',
			'libpcp_import1': '3.11.9-5.11.5',
			'libpcp_import1-debuginfo': '3.11.9-5.11.5',
			'libpcp_mmv1': '3.11.9-5.11.5',
			'libpcp_mmv1-debuginfo': '3.11.9-5.11.5',
			'libpcp_trace2': '3.11.9-5.11.5',
			'libpcp_trace2-debuginfo': '3.11.9-5.11.5',
			'libpcp_web1': '3.11.9-5.11.5',
			'libpcp_web1-debuginfo': '3.11.9-5.11.5',
			'pcp': '3.11.9-5.11.5',
			'pcp-conf': '3.11.9-5.11.5',
			'pcp-debuginfo': '3.11.9-5.11.5',
			'pcp-debugsource': '3.11.9-5.11.5',
			'pcp-devel': '3.11.9-5.11.5',
			'pcp-devel-debuginfo': '3.11.9-5.11.5',
			'pcp-doc': '3.11.9-5.11.5',
			'pcp-import-iostat2pcp': '3.11.9-5.11.5',
			'pcp-import-mrtg2pcp': '3.11.9-5.11.5',
			'pcp-import-sar2pcp': '3.11.9-5.11.5',
			'perl-PCP-LogImport': '3.11.9-5.11.5',
			'perl-PCP-LogImport-debuginfo': '3.11.9-5.11.5',
			'perl-PCP-LogSummary': '3.11.9-5.11.5',
			'perl-PCP-MMV': '3.11.9-5.11.5',
			'perl-PCP-MMV-debuginfo': '3.11.9-5.11.5',
			'perl-PCP-PMDA': '3.11.9-5.11.5',
			'perl-PCP-PMDA-debuginfo': '3.11.9-5.11.5',
			'python-pcp': '3.11.9-5.11.5',
			'python-pcp-debuginfo': '3.11.9-5.11.5',
		}
		SUSE.securityAnnouncementPackageCheck(NAME, MAIN, LTSS, SEVERITY, TAG, PACKAGES)
	else:
		Core.updateStatus(Core.ERROR, "ERROR: " + NAME + " Security Announcement: Outside the service pack scope")
else:
	Core.updateStatus(Core.ERROR, "ERROR: " + NAME + " Security Announcement: Outside the distribution scope")
Core.printPatternResults()

