#ifndef __BRL_H
#define __BRL_H

#define CMD_RESTARTBRL 5        /* reinitialize braille display */
struct brlinfo
{
  char name[50];
  char fullname[80];
  int cols;
  int st_cells;
  int offvert;
  int offhor;
  int baud;
};

/* Braille information structure */
typedef struct
{
  int brl_fd;
  int usb;
  unsigned char *disp;          /* contents of the display */
  int x, y;                     /* size of display */
}
brldim;                         /* used for writing to a braille display */

/* only for libs */
typedef struct
{
  char *identifier;             /* name of driver */
/* Routines provided by the braille driver library: */
  struct brlinfo (*identify) (const char *, const char *);      /* print
                                                                   start-up
                                                                   messages */
  void (*debug) (unsigned int dbg);
  void (*initialize) (brldim *, const char *);  /* initialise Braille display 
                                                 */
  void (*close) (brldim *);     /* close braille display */
  void (*write) (brldim *);     /* write to braille display */
  int (*read) (int *);          /* get key press from braille display */
  void (*setstatus) (const unsigned char *);    /* set status cells */

}
braille_driver;

extern braille_driver *braille; /* filled by dynamic libs */
extern char *braille_libname;   /* name of library */

#endif
