# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.7.4, generator: @autorest/python@5.12.4)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_check_docker_v2_support_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/v2/')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_manifest_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = kwargs.pop('accept', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/v2/{name}/manifests/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_create_manifest_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/v2/{name}/manifests/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_manifest_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/v2/{name}/manifests/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_repositories_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    last = kwargs.pop('last', None)  # type: Optional[str]
    n = kwargs.pop('n', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/_catalog')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if last is not None:
        query_parameters['last'] = _SERIALIZER.query("last", last, 'str')
    if n is not None:
        query_parameters['n'] = _SERIALIZER.query("n", n, 'int')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_properties_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_repository_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_properties_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_tags_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    last = kwargs.pop('last', None)  # type: Optional[str]
    n = kwargs.pop('n', None)  # type: Optional[int]
    orderby = kwargs.pop('orderby', None)  # type: Optional[str]
    digest = kwargs.pop('digest', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_tags')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if last is not None:
        query_parameters['last'] = _SERIALIZER.query("last", last, 'str')
    if n is not None:
        query_parameters['n'] = _SERIALIZER.query("n", n, 'int')
    if orderby is not None:
        query_parameters['orderby'] = _SERIALIZER.query("orderby", orderby, 'str')
    if digest is not None:
        query_parameters['digest'] = _SERIALIZER.query("digest", digest, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_tag_properties_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_tags/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_tag_attributes_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_tags/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_tag_request(
    name,  # type: str
    reference,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_tags/{reference}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "reference": _SERIALIZER.url("reference", reference, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_manifests_request(
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    last = kwargs.pop('last', None)  # type: Optional[str]
    n = kwargs.pop('n', None)  # type: Optional[int]
    orderby = kwargs.pop('orderby', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_manifests')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if last is not None:
        query_parameters['last'] = _SERIALIZER.query("last", last, 'str')
    if n is not None:
        query_parameters['n'] = _SERIALIZER.query("n", n, 'int')
    if orderby is not None:
        query_parameters['orderby'] = _SERIALIZER.query("orderby", orderby, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_manifest_properties_request(
    name,  # type: str
    digest,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_manifests/{digest}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "digest": _SERIALIZER.url("digest", digest, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_manifest_properties_request(
    name,  # type: str
    digest,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/acr/v1/{name}/_manifests/{digest}')
    path_format_arguments = {
        "name": _SERIALIZER.url("name", name, 'str'),
        "digest": _SERIALIZER.url("digest", digest, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class ContainerRegistryOperations(object):
    """ContainerRegistryOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~container_registry.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def check_docker_v2_support(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_check_docker_v2_support_request(
            template_url=self.check_docker_v2_support.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    check_docker_v2_support.metadata = {'url': '/v2/'}  # type: ignore


    @distributed_trace
    def get_manifest(
        self,
        name,  # type: str
        reference,  # type: str
        accept=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ManifestWrapper"
        """Get the manifest identified by ``name`` and ``reference`` where ``reference`` can be a tag or
        digest.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image.
        :type reference: str
        :param accept: Accept header string delimited by comma. For example,
         application/vnd.docker.distribution.manifest.v2+json.
        :type accept: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManifestWrapper, or the result of cls(response)
        :rtype: ~container_registry.models.ManifestWrapper
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ManifestWrapper"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_manifest_request(
            name=name,
            reference=reference,
            accept=accept,
            template_url=self.get_manifest.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ManifestWrapper', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_manifest.metadata = {'url': '/v2/{name}/manifests/{reference}'}  # type: ignore


    @distributed_trace
    def create_manifest(
        self,
        name,  # type: str
        reference,  # type: str
        payload,  # type: "_models.Manifest"
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Put the manifest identified by ``name`` and ``reference`` where ``reference`` can be a tag or
        digest.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: A tag or a digest, pointing to a specific image.
        :type reference: str
        :param payload: Manifest body, can take v1 or v2 values depending on accept header.
        :type payload: ~container_registry.models.Manifest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: any, or the result of cls(response)
        :rtype: any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/vnd.docker.distribution.manifest.v2+json")  # type: Optional[str]

        _json = self._serialize.body(payload, 'Manifest')

        request = build_create_manifest_request(
            name=name,
            reference=reference,
            content_type=content_type,
            json=_json,
            template_url=self.create_manifest.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Docker-Content-Digest']=self._deserialize('str', response.headers.get('Docker-Content-Digest'))
        response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))

        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    create_manifest.metadata = {'url': '/v2/{name}/manifests/{reference}'}  # type: ignore


    @distributed_trace
    def delete_manifest(
        self,
        name,  # type: str
        reference,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete the manifest identified by ``name`` and ``reference``. Note that a manifest can *only*
        be deleted by ``digest``.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: Digest of a BLOB.
        :type reference: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_manifest_request(
            name=name,
            reference=reference,
            template_url=self.delete_manifest.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_manifest.metadata = {'url': '/v2/{name}/manifests/{reference}'}  # type: ignore


    @distributed_trace
    def get_repositories(
        self,
        last=None,  # type: Optional[str]
        n=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.Repositories"]
        """List repositories.

        :param last: Query parameter for the last item in previous query. Result set will include
         values lexically after last.
        :type last: str
        :param n: query parameter for max number of items.
        :type n: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Repositories or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~container_registry.models.Repositories]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Repositories"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_get_repositories_request(
                    api_version=api_version,
                    last=last,
                    n=n,
                    template_url=self.get_repositories.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_get_repositories_request(
                    api_version=api_version,
                    last=last,
                    n=n,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("Repositories", pipeline_response)
            list_of_elem = deserialized.repositories
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    get_repositories.metadata = {'url': '/acr/v1/_catalog'}  # type: ignore

    @distributed_trace
    def get_properties(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ContainerRepositoryProperties"
        """Get repository attributes.

        :param name: Name of the image (including the namespace).
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerRepositoryProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ContainerRepositoryProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        
        request = build_get_properties_request(
            name=name,
            api_version=api_version,
            template_url=self.get_properties.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ContainerRepositoryProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_properties.metadata = {'url': '/acr/v1/{name}'}  # type: ignore


    @distributed_trace
    def delete_repository(
        self,
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete the repository identified by ``name``.

        :param name: Name of the image (including the namespace).
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        
        request = build_delete_repository_request(
            name=name,
            api_version=api_version,
            template_url=self.delete_repository.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_repository.metadata = {'url': '/acr/v1/{name}'}  # type: ignore


    @distributed_trace
    def update_properties(
        self,
        name,  # type: str
        value=None,  # type: Optional["_models.RepositoryWriteableProperties"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ContainerRepositoryProperties"
        """Update the attribute identified by ``name`` where ``reference`` is the name of the repository.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param value: Repository attribute value.
        :type value: ~container_registry.models.RepositoryWriteableProperties
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContainerRepositoryProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ContainerRepositoryProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ContainerRepositoryProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if value is not None:
            _json = self._serialize.body(value, 'RepositoryWriteableProperties')
        else:
            _json = None

        request = build_update_properties_request(
            name=name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.update_properties.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ContainerRepositoryProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_properties.metadata = {'url': '/acr/v1/{name}'}  # type: ignore


    @distributed_trace
    def get_tags(
        self,
        name,  # type: str
        last=None,  # type: Optional[str]
        n=None,  # type: Optional[int]
        orderby=None,  # type: Optional[str]
        digest=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.TagList"]
        """List tags of a repository.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param last: Query parameter for the last item in previous query. Result set will include
         values lexically after last.
        :type last: str
        :param n: query parameter for max number of items.
        :type n: int
        :param orderby: orderby query parameter.
        :type orderby: str
        :param digest: filter by digest.
        :type digest: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either TagList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~container_registry.models.TagList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TagList"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_get_tags_request(
                    name=name,
                    api_version=api_version,
                    last=last,
                    n=n,
                    orderby=orderby,
                    digest=digest,
                    template_url=self.get_tags.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_get_tags_request(
                    name=name,
                    api_version=api_version,
                    last=last,
                    n=n,
                    orderby=orderby,
                    digest=digest,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("TagList", pipeline_response)
            list_of_elem = deserialized.tag_attribute_bases
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    get_tags.metadata = {'url': '/acr/v1/{name}/_tags'}  # type: ignore

    @distributed_trace
    def get_tag_properties(
        self,
        name,  # type: str
        reference,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ArtifactTagProperties"
        """Get tag attributes by tag.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: Tag name.
        :type reference: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ArtifactTagProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ArtifactTagProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        
        request = build_get_tag_properties_request(
            name=name,
            reference=reference,
            api_version=api_version,
            template_url=self.get_tag_properties.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ArtifactTagProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_tag_properties.metadata = {'url': '/acr/v1/{name}/_tags/{reference}'}  # type: ignore


    @distributed_trace
    def update_tag_attributes(
        self,
        name,  # type: str
        reference,  # type: str
        value=None,  # type: Optional["_models.TagWriteableProperties"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ArtifactTagProperties"
        """Update tag attributes.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: Tag name.
        :type reference: str
        :param value: Tag attribute value.
        :type value: ~container_registry.models.TagWriteableProperties
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ArtifactTagProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ArtifactTagProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ArtifactTagProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if value is not None:
            _json = self._serialize.body(value, 'TagWriteableProperties')
        else:
            _json = None

        request = build_update_tag_attributes_request(
            name=name,
            reference=reference,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.update_tag_attributes.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ArtifactTagProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_tag_attributes.metadata = {'url': '/acr/v1/{name}/_tags/{reference}'}  # type: ignore


    @distributed_trace
    def delete_tag(
        self,
        name,  # type: str
        reference,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete tag.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param reference: Tag name.
        :type reference: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        
        request = build_delete_tag_request(
            name=name,
            reference=reference,
            api_version=api_version,
            template_url=self.delete_tag.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_tag.metadata = {'url': '/acr/v1/{name}/_tags/{reference}'}  # type: ignore


    @distributed_trace
    def get_manifests(
        self,
        name,  # type: str
        last=None,  # type: Optional[str]
        n=None,  # type: Optional[int]
        orderby=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.AcrManifests"]
        """List manifests of a repository.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param last: Query parameter for the last item in previous query. Result set will include
         values lexically after last.
        :type last: str
        :param n: query parameter for max number of items.
        :type n: int
        :param orderby: orderby query parameter.
        :type orderby: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AcrManifests or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~container_registry.models.AcrManifests]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AcrManifests"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_get_manifests_request(
                    name=name,
                    api_version=api_version,
                    last=last,
                    n=n,
                    orderby=orderby,
                    template_url=self.get_manifests.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_get_manifests_request(
                    name=name,
                    api_version=api_version,
                    last=last,
                    n=n,
                    orderby=orderby,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("AcrManifests", pipeline_response)
            list_of_elem = deserialized.manifests
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    get_manifests.metadata = {'url': '/acr/v1/{name}/_manifests'}  # type: ignore

    @distributed_trace
    def get_manifest_properties(
        self,
        name,  # type: str
        digest,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ArtifactManifestProperties"
        """Get manifest attributes.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param digest: Digest of a BLOB.
        :type digest: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ArtifactManifestProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ArtifactManifestProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str

        
        request = build_get_manifest_properties_request(
            name=name,
            digest=digest,
            api_version=api_version,
            template_url=self.get_manifest_properties.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ArtifactManifestProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_manifest_properties.metadata = {'url': '/acr/v1/{name}/_manifests/{digest}'}  # type: ignore


    @distributed_trace
    def update_manifest_properties(
        self,
        name,  # type: str
        digest,  # type: str
        value=None,  # type: Optional["_models.ManifestWriteableProperties"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ArtifactManifestProperties"
        """Update properties of a manifest.

        :param name: Name of the image (including the namespace).
        :type name: str
        :param digest: Digest of a BLOB.
        :type digest: str
        :param value: Manifest attribute value.
        :type value: ~container_registry.models.ManifestWriteableProperties
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ArtifactManifestProperties, or the result of cls(response)
        :rtype: ~container_registry.models.ArtifactManifestProperties
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ArtifactManifestProperties"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-07-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        if value is not None:
            _json = self._serialize.body(value, 'ManifestWriteableProperties')
        else:
            _json = None

        request = build_update_manifest_properties_request(
            name=name,
            digest=digest,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.update_manifest_properties.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "url": self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AcrErrors, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('ArtifactManifestProperties', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_manifest_properties.metadata = {'url': '/acr/v1/{name}/_manifests/{digest}'}  # type: ignore

