#ifndef _LIBBRLD_H
#define _LIBBRLD_H

#define BRLD_SOCK_NAME "/var/run/brld.sock"
#define MAX_MSG_LEN 800
/* registration types */
#define TEXT 1
#define X11 2
#define ADMIN 3
#define BRLD_TIMEOUT -3
#define BRLD_CMD_ERR -2
#define BRLD_NO_CONN -4
#define BRLD_CLIENT_TIMEOUT 20   /* in seconds */

typedef struct
{
  int (*open) (char *, int);
  int (*reg) (int, char *);
  void (*close) ();
  int (*getkey) (int *);
  int (*write) (int, char *, char *);
  int (*reset) ();
  int (*getname) (char *name);
  int (*getalias) (char *alias);
  int (*getxy) (int *x, int *y);
  int (*cursor) (int form);
  int (*attrtbl) ();
  int (*texttbl) ();
  int (*seteventmode) ();
  int (*unseteventmode) ();
} brld_interface;

/* connect to brld 
 * if hostname is NULL - we assume localhost
 * if port is 0 - we assume default 
 * returns >=0 = (socket_fd)  <0 = failed
 */

int brld_open (char *host, int port);

/* register your application */
int brld_reg (int type, char *authkey);

/* close connection to brld */
void brld_close ();

/* get a brlkey from brld
 * retunrs the key-value or <=0 on error
 * pressed is 1 on if key is pressed - 0 if key is released
 */
int brld_getkey (int *pressed);

/* write a string to the braille-display
 * the string will be translated in brld
 * csrpos - is the brl-cursor positon csrpos=-1 means cursor off
 * text - is a plain text string (zero terminated)
 * attr - is an attribute string (zero terminated)
 * text and attr should have the same length otherwise attr will be ignored
 * if you want to display the string "hello wolrd" 
 * and "world" should be underlined by dot 7 and 8
 * do the following:
 * brld_write(-1,"hello world","      -----");
 * the "-" character in attr indicates the underline
 */
int brld_write (int csrpos, char *text, char *attr);

/* braille device reset */
int brld_reset ();

/* get the fullname of the connected brailledisplay 
 * retunrn 0= OK - not 0 = failed
 */

int brld_getname (char *name);

/* get the shortname of the connected brailledisplay
 * retunr 0=OK - not 0 = failed
 */
int brld_getalias (char *alias);

/* get braille-celss and lines
 * return 0=OK - not 0=failed
 */
int brld_getxy (int *x, int *y);

/* set braille-cursor form
 * form=0 - block-cursor 
 * form=1 - underline the cursor position with dot 7 and 8
 * return 0=OK - not 0 failed
 */
int brld_cursor (int form);

/* set braille translation table to attribute
 * attribute mode for displaying a attribute pattern in conosle-applications
 * return 0=OK - not 0=failed
 */
int brld_attrtbl ();

/* set braille translation table to text
 * use the normal text-translation-table
 * return 0=OK - not 0=failed
 */
int brld_texttbl ();

/* set the event-mode for incoming key-storkes
 * needed if the connected applications wants to use SIGIO like orca
 */
int brld_seteventmode ();

/* disable event-mode
 * the application has to poll
 * return 0=OK - not 0=failed
 */
int brld_unseteventmode ();
#endif
