; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lasx < %s | FileCheck %s

define void @ctpop_v32i8(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvpcnt.b $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <32 x i8>, ptr %src
  %res = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %v)
  store <32 x i8> %res, ptr %dst
  ret void
}

define void @ctpop_v16i16(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvpcnt.h $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <16 x i16>, ptr %src
  %res = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %v)
  store <16 x i16> %res, ptr %dst
  ret void
}

define void @ctpop_v8i32(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvpcnt.w $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <8 x i32>, ptr %src
  %res = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %v)
  store <8 x i32> %res, ptr %dst
  ret void
}

define void @ctpop_v4i64(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvpcnt.d $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <4 x i64>, ptr %src
  %res = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %v)
  store <4 x i64> %res, ptr %dst
  ret void
}

define void @ctlz_v32i8(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvclz.b $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <32 x i8>, ptr %src
  %res = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %v, i1 false)
  store <32 x i8> %res, ptr %dst
  ret void
}

define void @ctlz_v16i16(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvclz.h $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <16 x i16>, ptr %src
  %res = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %v, i1 false)
  store <16 x i16> %res, ptr %dst
  ret void
}

define void @ctlz_v8i32(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvclz.w $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <8 x i32>, ptr %src
  %res = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %v, i1 false)
  store <8 x i32> %res, ptr %dst
  ret void
}

define void @ctlz_v4i64(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvclz.d $xr0, $xr0
; CHECK-NEXT:    xvst $xr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <4 x i64>, ptr %src
  %res = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %v, i1 false)
  store <4 x i64> %res, ptr %dst
  ret void
}

declare <32 x i8> @llvm.ctpop.v32i8(<32 x i8>)
declare <16 x i16> @llvm.ctpop.v16i16(<16 x i16>)
declare <8 x i32> @llvm.ctpop.v8i32(<8 x i32>)
declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>)
declare <32 x i8> @llvm.ctlz.v32i8(<32 x i8>, i1)
declare <16 x i16> @llvm.ctlz.v16i16(<16 x i16>, i1)
declare <8 x i32> @llvm.ctlz.v8i32(<8 x i32>, i1)
declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1)
