/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.ConstantTimer;
import com.clarkware.junitperf.ThreadBarrier;
import com.clarkware.junitperf.ThreadedTest;
import com.clarkware.junitperf.ThreadedTestGroup;
import com.clarkware.junitperf.Timer;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestResult;

public class LoadTest
implements Test {
    private final int users;
    private final Timer timer;
    private final ThreadedTest test;
    private final ThreadedTestGroup group;
    private final ThreadBarrier barrier;
    private boolean enforceTestAtomicity;

    public LoadTest(Test test, int users) {
        this(test, users, new ConstantTimer(0L));
    }

    public LoadTest(Test test, int users, int iterations) {
        this(test, users, iterations, new ConstantTimer(0L));
    }

    public LoadTest(Test test, int users, int iterations, Timer timer) {
        this((Test)new RepeatedTest(test, iterations), users, timer);
    }

    public LoadTest(Test test, int users, Timer timer) {
        if (users < 1) {
            throw new IllegalArgumentException("Number of users must be > 0");
        }
        if (timer == null) {
            throw new IllegalArgumentException("Delay timer is null");
        }
        if (test == null) {
            throw new IllegalArgumentException("Decorated test is null");
        }
        this.users = users;
        this.timer = timer;
        this.setEnforceTestAtomicity(false);
        this.barrier = new ThreadBarrier(users);
        this.group = new ThreadedTestGroup(this);
        this.test = new ThreadedTest(test, this.group, this.barrier);
    }

    public void setEnforceTestAtomicity(boolean isAtomic) {
        this.enforceTestAtomicity = isAtomic;
    }

    public int countTestCases() {
        return this.test.countTestCases() * this.users;
    }

    public void run(TestResult result) {
        this.group.setTestResult(result);
        for (int i = 0; i < this.users; ++i) {
            if (result.shouldStop()) {
                this.barrier.cancelThreads(this.users - i);
                break;
            }
            this.test.run(result);
            this.sleep(this.getDelay());
        }
        this.waitForTestCompletion();
        this.cleanup();
    }

    protected void waitForTestCompletion() {
        if (this.enforceTestAtomicity) {
            this.waitForAllThreadsToComplete();
        } else {
            this.waitForThreadedTestThreadsToComplete();
        }
    }

    protected void waitForThreadedTestThreadsToComplete() {
        while (!this.barrier.isReached()) {
            this.sleep(50L);
        }
    }

    protected void waitForAllThreadsToComplete() {
        while (this.group.activeCount() > 0) {
            this.sleep(50L);
        }
    }

    protected void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanup() {
        try {
            this.group.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        if (this.enforceTestAtomicity) {
            return "LoadTest (ATOMIC): " + this.test.toString();
        }
        return "LoadTest (NON-ATOMIC): " + this.test.toString();
    }

    protected long getDelay() {
        return this.timer.getDelay();
    }
}

