/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentImplementationNotFoundException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultComponentRepository
extends AbstractLogEnabled
implements ComponentRepository {
    private static String COMPONENTS = "components";
    private static String COMPONENT = "component";
    private PlexusConfiguration configuration;
    private ComponentRealmDescriptorMaps componentRealmDescriptorMaps = new ComponentRealmDescriptorMaps();
    private CompositionResolver compositionResolver;
    private ClassRealm classRealm;

    protected PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean hasComponent(String role, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.containsKey(role, realm);
    }

    public boolean hasComponent(String role, String roleHint, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.containsKey(role + roleHint, realm);
    }

    public Map getComponentDescriptorMap(String role, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.getComponentDescriptorMap(role, realm);
    }

    public ComponentDescriptor getComponentDescriptor(String key, ClassRealm realm) {
        return this.componentRealmDescriptorMaps.getComponentDescriptor(key, realm);
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public void configure(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize() throws ComponentRepositoryException {
        this.initializeComponentDescriptors();
    }

    public void initializeComponentDescriptors() throws ComponentRepositoryException {
        this.initializeComponentDescriptorsFromUserConfiguration();
    }

    private void initializeComponentDescriptorsFromUserConfiguration() throws ComponentRepositoryException {
        PlexusConfiguration[] componentConfigurations = this.configuration.getChild(COMPONENTS).getChildren(COMPONENT);
        for (int i = 0; i < componentConfigurations.length; ++i) {
            this.addComponentDescriptor(componentConfigurations[i]);
        }
    }

    public void addComponentDescriptor(PlexusConfiguration configuration) throws ComponentRepositoryException {
        ComponentDescriptor componentDescriptor = null;
        try {
            componentDescriptor = PlexusTools.buildComponentDescriptor(configuration);
        }
        catch (PlexusConfigurationException e) {
            throw new ComponentRepositoryException("Cannot unmarshall component descriptor:", (Throwable)e);
        }
        componentDescriptor.setRealmId(this.classRealm.getId());
        this.addComponentDescriptor(componentDescriptor);
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        try {
            this.validateComponentDescriptor(componentDescriptor);
        }
        catch (ComponentImplementationNotFoundException e) {
            throw new ComponentRepositoryException("Component descriptor validation failed: ", (Throwable)e);
        }
        RealmMaps maps = this.componentRealmDescriptorMaps.getRealmMap(componentDescriptor.getRealmId());
        String role = componentDescriptor.getRole();
        String roleHint = componentDescriptor.getRoleHint();
        if (roleHint != null) {
            ComponentDescriptor desc;
            if (maps.componentDescriptors.containsKey(role) && (desc = (ComponentDescriptor)maps.componentDescriptors.get(role)).getRoleHint() == null) {
                String message = "Component descriptor " + componentDescriptor.getHumanReadableKey() + " has a hint, but implementation " + desc.getImplementation() + " doesn't";
                throw new ComponentRepositoryException(message);
            }
            HashMap<String, ComponentDescriptor> map = (HashMap<String, ComponentDescriptor>)maps.componentDescriptorMaps.get(role);
            if (map == null) {
                map = new HashMap<String, ComponentDescriptor>();
                maps.componentDescriptorMaps.put(role, map);
            }
            map.put(roleHint, componentDescriptor);
        } else {
            if (maps.componentDescriptorMaps.containsKey(role)) {
                String message = "Component descriptor " + componentDescriptor.getHumanReadableKey() + " has no hint, but there are other implementations that do";
                throw new ComponentRepositoryException(message);
            }
            if (maps.componentDescriptors.containsKey(role) && !maps.componentDescriptors.get(role).equals(componentDescriptor)) {
                String message = "Component role " + role + " is already in the repository and different to attempted addition of " + componentDescriptor.getHumanReadableKey();
                throw new ComponentRepositoryException(message);
            }
        }
        try {
            this.compositionResolver.addComponentDescriptor(componentDescriptor);
        }
        catch (CompositionException e) {
            throw new ComponentRepositoryException(e.getMessage(), (Throwable)e);
        }
        maps.componentDescriptors.put(componentDescriptor.getComponentKey(), componentDescriptor);
        if (!maps.componentDescriptors.containsKey(role)) {
            maps.componentDescriptors.put(role, componentDescriptor);
        }
    }

    public void validateComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentImplementationNotFoundException {
        if (componentDescriptor.getRealmId() == null) {
            componentDescriptor.setRealmId(this.classRealm.getId());
        }
    }

    public List getComponentDependencies(ComponentDescriptor componentDescriptor) {
        return this.compositionResolver.getRequirements(componentDescriptor.getComponentKey());
    }

    private class ComponentRealmDescriptorMaps {
        private Map realmMaps = new HashMap();

        private ComponentRealmDescriptorMaps() {
        }

        public boolean containsKey(String role, ClassRealm realm) {
            if (realm == null) {
                return false;
            }
            RealmMaps maps = (RealmMaps)this.realmMaps.get(realm.getId());
            if (maps != null && maps.componentDescriptors.containsKey(role)) {
                return true;
            }
            return this.containsKey(role, realm.getParentRealm());
        }

        public Map getComponentDescriptorMap(String role, ClassRealm realm) {
            Map m;
            if (realm == null) {
                return null;
            }
            RealmMaps maps = (RealmMaps)this.realmMaps.get(realm.getId());
            if (maps != null && (m = (Map)maps.componentDescriptorMaps.get(role)) != null) {
                return m;
            }
            return this.getComponentDescriptorMap(role, realm.getParentRealm());
        }

        public ComponentDescriptor getComponentDescriptor(String key, ClassRealm realm) {
            ComponentDescriptor desc;
            if (realm == null) {
                return null;
            }
            RealmMaps maps = (RealmMaps)this.realmMaps.get(realm.getId());
            if (maps != null && (desc = (ComponentDescriptor)maps.componentDescriptors.get(key)) != null) {
                return desc;
            }
            return this.getComponentDescriptor(key, realm.getParentRealm());
        }

        public RealmMaps getRealmMap(String realmId) {
            RealmMaps rm = (RealmMaps)this.realmMaps.get(realmId);
            if (rm == null) {
                rm = new RealmMaps();
                this.realmMaps.put(realmId, rm);
            }
            return rm;
        }
    }

    private static class RealmMaps {
        private Map componentDescriptorMaps = new HashMap();
        private Map componentDescriptors = new HashMap();

        private RealmMaps() {
        }
    }
}

