# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CollectionConfigurationError(_serialization.Model):
    """Represents an error while SDK parsing and applying an instance of CollectionConfigurationInfo.

    :ivar collection_configuration_error_type: Collection configuration error type reported by SDK.
     Known values are: "Unknown", "PerformanceCounterParsing", "PerformanceCounterUnexpected",
     "PerformanceCounterDuplicateIds", "DocumentStreamDuplicateIds",
     "DocumentStreamFailureToCreate", "DocumentStreamFailureToCreateFilterUnexpected",
     "MetricDuplicateIds", "MetricTelemetryTypeUnsupported", "MetricFailureToCreate",
     "MetricFailureToCreateFilterUnexpected", "FilterFailureToCreateUnexpected", and
     "CollectionConfigurationFailureToCreateUnexpected".
    :vartype collection_configuration_error_type: str or
     ~quickpulse_client.models.CollectionConfigurationErrorType
    :ivar message: Error message.
    :vartype message: str
    :ivar full_exception: Exception that leads to the creation of the configuration error.
    :vartype full_exception: str
    :ivar data: Custom properties to add more information to the error.
    :vartype data: list[~quickpulse_client.models.KeyValuePairString]
    """

    _attribute_map = {
        "collection_configuration_error_type": {"key": "CollectionConfigurationErrorType", "type": "str"},
        "message": {"key": "Message", "type": "str"},
        "full_exception": {"key": "FullException", "type": "str"},
        "data": {"key": "Data", "type": "[KeyValuePairString]"},
    }

    def __init__(
        self,
        *,
        collection_configuration_error_type: Optional[Union[str, "_models.CollectionConfigurationErrorType"]] = None,
        message: Optional[str] = None,
        full_exception: Optional[str] = None,
        data: Optional[List["_models.KeyValuePairString"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword collection_configuration_error_type: Collection configuration error type reported by
         SDK. Known values are: "Unknown", "PerformanceCounterParsing", "PerformanceCounterUnexpected",
         "PerformanceCounterDuplicateIds", "DocumentStreamDuplicateIds",
         "DocumentStreamFailureToCreate", "DocumentStreamFailureToCreateFilterUnexpected",
         "MetricDuplicateIds", "MetricTelemetryTypeUnsupported", "MetricFailureToCreate",
         "MetricFailureToCreateFilterUnexpected", "FilterFailureToCreateUnexpected", and
         "CollectionConfigurationFailureToCreateUnexpected".
        :paramtype collection_configuration_error_type: str or
         ~quickpulse_client.models.CollectionConfigurationErrorType
        :keyword message: Error message.
        :paramtype message: str
        :keyword full_exception: Exception that leads to the creation of the configuration error.
        :paramtype full_exception: str
        :keyword data: Custom properties to add more information to the error.
        :paramtype data: list[~quickpulse_client.models.KeyValuePairString]
        """
        super().__init__(**kwargs)
        self.collection_configuration_error_type = collection_configuration_error_type
        self.message = message
        self.full_exception = full_exception
        self.data = data


class CollectionConfigurationInfo(_serialization.Model):
    """Represents the collection configuration - a customizable description of performance counters,
    metrics, and full telemetry documents to be collected by the SDK.

    :ivar etag: An encoded string that indicates whether the collection configuration is changed.
    :vartype etag: str
    :ivar metrics: An array of metric configuration info.
    :vartype metrics: list[~quickpulse_client.models.DerivedMetricInfo]
    :ivar document_streams: An array of document stream configuration info.
    :vartype document_streams: list[~quickpulse_client.models.DocumentStreamInfo]
    :ivar quota_info: Control document quotas for QuickPulse.
    :vartype quota_info: ~quickpulse_client.models.QuotaConfigurationInfo
    """

    _attribute_map = {
        "etag": {"key": "Etag", "type": "str"},
        "metrics": {"key": "Metrics", "type": "[DerivedMetricInfo]"},
        "document_streams": {"key": "DocumentStreams", "type": "[DocumentStreamInfo]"},
        "quota_info": {"key": "QuotaInfo", "type": "QuotaConfigurationInfo"},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        metrics: Optional[List["_models.DerivedMetricInfo"]] = None,
        document_streams: Optional[List["_models.DocumentStreamInfo"]] = None,
        quota_info: Optional["_models.QuotaConfigurationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: An encoded string that indicates whether the collection configuration is
         changed.
        :paramtype etag: str
        :keyword metrics: An array of metric configuration info.
        :paramtype metrics: list[~quickpulse_client.models.DerivedMetricInfo]
        :keyword document_streams: An array of document stream configuration info.
        :paramtype document_streams: list[~quickpulse_client.models.DocumentStreamInfo]
        :keyword quota_info: Control document quotas for QuickPulse.
        :paramtype quota_info: ~quickpulse_client.models.QuotaConfigurationInfo
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.metrics = metrics
        self.document_streams = document_streams
        self.quota_info = quota_info


class DerivedMetricInfo(_serialization.Model):
    """A metric configuration set by UX to scope the metrics it's interested in.

    :ivar id: metric configuration identifier.
    :vartype id: str
    :ivar telemetry_type: Telemetry type.
    :vartype telemetry_type: str
    :ivar filter_groups: A collection of filters to scope metrics that UX needs.
    :vartype filter_groups: list[~quickpulse_client.models.FilterConjunctionGroupInfo]
    :ivar projection: Telemetry's metric dimension whose value is to be aggregated. Example values:
     Duration, Count(),...
    :vartype projection: str
    :ivar aggregation: Aggregation type. Known values are: "Avg", "Sum", "Min", and "Max".
    :vartype aggregation: str or ~quickpulse_client.models.DerivedMetricInfoAggregation
    """

    _attribute_map = {
        "id": {"key": "Id", "type": "str"},
        "telemetry_type": {"key": "TelemetryType", "type": "str"},
        "filter_groups": {"key": "FilterGroups", "type": "[FilterConjunctionGroupInfo]"},
        "projection": {"key": "Projection", "type": "str"},
        "aggregation": {"key": "Aggregation", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        telemetry_type: Optional[str] = None,
        filter_groups: Optional[List["_models.FilterConjunctionGroupInfo"]] = None,
        projection: Optional[str] = None,
        aggregation: Optional[Union[str, "_models.DerivedMetricInfoAggregation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: metric configuration identifier.
        :paramtype id: str
        :keyword telemetry_type: Telemetry type.
        :paramtype telemetry_type: str
        :keyword filter_groups: A collection of filters to scope metrics that UX needs.
        :paramtype filter_groups: list[~quickpulse_client.models.FilterConjunctionGroupInfo]
        :keyword projection: Telemetry's metric dimension whose value is to be aggregated. Example
         values: Duration, Count(),...
        :paramtype projection: str
        :keyword aggregation: Aggregation type. Known values are: "Avg", "Sum", "Min", and "Max".
        :paramtype aggregation: str or ~quickpulse_client.models.DerivedMetricInfoAggregation
        """
        super().__init__(**kwargs)
        self.id = id
        self.telemetry_type = telemetry_type
        self.filter_groups = filter_groups
        self.projection = projection
        self.aggregation = aggregation


class DocumentFilterConjunctionGroupInfo(_serialization.Model):
    """A collection of filters for a specificy telemetry type.

    :ivar telemetry_type: Telemetry type. Known values are: "Request", "Dependency", "Exception",
     "Event", "Metric", "PerformanceCounter", and "Trace".
    :vartype telemetry_type: str or
     ~quickpulse_client.models.DocumentFilterConjunctionGroupInfoTelemetryType
    :ivar filters: An AND-connected group of FilterInfo objects.
    :vartype filters: ~quickpulse_client.models.FilterConjunctionGroupInfo
    """

    _attribute_map = {
        "telemetry_type": {"key": "TelemetryType", "type": "str"},
        "filters": {"key": "Filters", "type": "FilterConjunctionGroupInfo"},
    }

    def __init__(
        self,
        *,
        telemetry_type: Optional[Union[str, "_models.DocumentFilterConjunctionGroupInfoTelemetryType"]] = None,
        filters: Optional["_models.FilterConjunctionGroupInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword telemetry_type: Telemetry type. Known values are: "Request", "Dependency",
         "Exception", "Event", "Metric", "PerformanceCounter", and "Trace".
        :paramtype telemetry_type: str or
         ~quickpulse_client.models.DocumentFilterConjunctionGroupInfoTelemetryType
        :keyword filters: An AND-connected group of FilterInfo objects.
        :paramtype filters: ~quickpulse_client.models.FilterConjunctionGroupInfo
        """
        super().__init__(**kwargs)
        self.telemetry_type = telemetry_type
        self.filters = filters


class DocumentIngress(_serialization.Model):
    """Base class of the specific document types.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Event, Exception, RemoteDependency, Request, Trace

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    """

    _validation = {
        "document_type": {"required": True},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
    }

    _subtype_map = {
        "document_type": {
            "Event": "Event",
            "Exception": "Exception",
            "RemoteDependency": "RemoteDependency",
            "Request": "Request",
            "Trace": "Trace",
        }
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        """
        super().__init__(**kwargs)
        self.document_type: Optional[str] = None
        self.document_stream_ids = document_stream_ids
        self.properties = properties


class DocumentStreamInfo(_serialization.Model):
    """Configurations/filters set by UX to scope the document/telemetry it's interested in.

    :ivar id: Identifier of the document stream initiated by a UX.
    :vartype id: str
    :ivar document_filter_groups: Gets or sets an OR-connected collection of filter groups.
    :vartype document_filter_groups:
     list[~quickpulse_client.models.DocumentFilterConjunctionGroupInfo]
    """

    _attribute_map = {
        "id": {"key": "Id", "type": "str"},
        "document_filter_groups": {"key": "DocumentFilterGroups", "type": "[DocumentFilterConjunctionGroupInfo]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        document_filter_groups: Optional[List["_models.DocumentFilterConjunctionGroupInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Identifier of the document stream initiated by a UX.
        :paramtype id: str
        :keyword document_filter_groups: Gets or sets an OR-connected collection of filter groups.
        :paramtype document_filter_groups:
         list[~quickpulse_client.models.DocumentFilterConjunctionGroupInfo]
        """
        super().__init__(**kwargs)
        self.id = id
        self.document_filter_groups = document_filter_groups


class Event(DocumentIngress):
    """Event type document.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Event name.
    :vartype name: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 512},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Event name.
        :paramtype name: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Event"
        self.name = name


class Exception(DocumentIngress):
    """Exception type document.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar exception_type: Exception type name.
    :vartype exception_type: str
    :ivar exception_message: Exception message.
    :vartype exception_message: str
    """

    _validation = {
        "document_type": {"required": True},
        "exception_type": {"max_length": 1024},
        "exception_message": {"max_length": 32768},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "exception_type": {"key": "ExceptionType", "type": "str"},
        "exception_message": {"key": "ExceptionMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        exception_type: Optional[str] = None,
        exception_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword exception_type: Exception type name.
        :paramtype exception_type: str
        :keyword exception_message: Exception message.
        :paramtype exception_message: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Exception"
        self.exception_type = exception_type
        self.exception_message = exception_message


class FilterConjunctionGroupInfo(_serialization.Model):
    """An AND-connected group of FilterInfo objects.

    :ivar filters:
    :vartype filters: list[~quickpulse_client.models.FilterInfo]
    """

    _attribute_map = {
        "filters": {"key": "Filters", "type": "[FilterInfo]"},
    }

    def __init__(self, *, filters: Optional[List["_models.FilterInfo"]] = None, **kwargs: Any) -> None:
        """
        :keyword filters:
        :paramtype filters: list[~quickpulse_client.models.FilterInfo]
        """
        super().__init__(**kwargs)
        self.filters = filters


class FilterInfo(_serialization.Model):
    """A filter set on UX.

    :ivar field_name: dimension name of the filter.
    :vartype field_name: str
    :ivar predicate: Operator of the filter. Known values are: "Equal", "NotEqual", "LessThan",
     "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "Contains", and "DoesNotContain".
    :vartype predicate: str or ~quickpulse_client.models.FilterInfoPredicate
    :ivar comparand:
    :vartype comparand: str
    """

    _attribute_map = {
        "field_name": {"key": "FieldName", "type": "str"},
        "predicate": {"key": "Predicate", "type": "str"},
        "comparand": {"key": "Comparand", "type": "str"},
    }

    def __init__(
        self,
        *,
        field_name: Optional[str] = None,
        predicate: Optional[Union[str, "_models.FilterInfoPredicate"]] = None,
        comparand: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword field_name: dimension name of the filter.
        :paramtype field_name: str
        :keyword predicate: Operator of the filter. Known values are: "Equal", "NotEqual", "LessThan",
         "GreaterThan", "LessThanOrEqual", "GreaterThanOrEqual", "Contains", and "DoesNotContain".
        :paramtype predicate: str or ~quickpulse_client.models.FilterInfoPredicate
        :keyword comparand:
        :paramtype comparand: str
        """
        super().__init__(**kwargs)
        self.field_name = field_name
        self.predicate = predicate
        self.comparand = comparand


class KeyValuePairString(_serialization.Model):
    """KeyValuePairString.

    :ivar key:
    :vartype key: str
    :ivar value:
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key:
        :paramtype key: str
        :keyword value:
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class MetricPoint(_serialization.Model):
    """Metric data point.

    :ivar name: Metric name.
    :vartype name: str
    :ivar value: Metric value.
    :vartype value: float
    :ivar weight: Metric weight.
    :vartype weight: int
    """

    _attribute_map = {
        "name": {"key": "Name", "type": "str"},
        "value": {"key": "Value", "type": "float"},
        "weight": {"key": "Weight", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[float] = None, weight: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Metric name.
        :paramtype name: str
        :keyword value: Metric value.
        :paramtype value: float
        :keyword weight: Metric weight.
        :paramtype weight: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.weight = weight


class MonitoringDataPoint(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Monitoring data point coming from SDK, which includes metrics, documents and other metadata
    info.

    :ivar version: AI SDK version.
    :vartype version: str
    :ivar invariant_version: Version/generation of the data contract (MonitoringDataPoint) between
     SDK and QuickPulse.
    :vartype invariant_version: int
    :ivar instance: Service instance name where AI SDK lives.
    :vartype instance: str
    :ivar role_name: Service role name.
    :vartype role_name: str
    :ivar machine_name: Computer name where AI SDK lives.
    :vartype machine_name: str
    :ivar stream_id: Identifies an AI SDK as a trusted agent to report metrics and documents.
    :vartype stream_id: str
    :ivar timestamp: Data point generation timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar transmission_time: Timestamp when SDK transmits the metrics and documents to QuickPulse.
     A 8-byte long type of ticks.
    :vartype transmission_time: ~datetime.datetime
    :ivar is_web_app: True if the current application is an Azure Web App.
    :vartype is_web_app: bool
    :ivar performance_collection_supported: True if performance counters collection is supported.
    :vartype performance_collection_supported: bool
    :ivar metrics: An array of meric data points.
    :vartype metrics: list[~quickpulse_client.models.MetricPoint]
    :ivar documents: An array of documents of a specific type {Request}, {RemoteDependency},
     {Exception}, {Event}, or {Trace}.
    :vartype documents: list[~quickpulse_client.models.DocumentIngress]
    :ivar top_cpu_processes: An array of top cpu consumption data point.
    :vartype top_cpu_processes: list[~quickpulse_client.models.ProcessCpuData]
    :ivar collection_configuration_errors: An array of error while parsing and applying .
    :vartype collection_configuration_errors:
     list[~quickpulse_client.models.CollectionConfigurationError]
    """

    _attribute_map = {
        "version": {"key": "Version", "type": "str"},
        "invariant_version": {"key": "InvariantVersion", "type": "int"},
        "instance": {"key": "Instance", "type": "str"},
        "role_name": {"key": "RoleName", "type": "str"},
        "machine_name": {"key": "MachineName", "type": "str"},
        "stream_id": {"key": "StreamId", "type": "str"},
        "timestamp": {"key": "Timestamp", "type": "iso-8601"},
        "transmission_time": {"key": "TransmissionTime", "type": "iso-8601"},
        "is_web_app": {"key": "IsWebApp", "type": "bool"},
        "performance_collection_supported": {"key": "PerformanceCollectionSupported", "type": "bool"},
        "metrics": {"key": "Metrics", "type": "[MetricPoint]"},
        "documents": {"key": "Documents", "type": "[DocumentIngress]"},
        "top_cpu_processes": {"key": "TopCpuProcesses", "type": "[ProcessCpuData]"},
        "collection_configuration_errors": {
            "key": "CollectionConfigurationErrors",
            "type": "[CollectionConfigurationError]",
        },
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        invariant_version: Optional[int] = None,
        instance: Optional[str] = None,
        role_name: Optional[str] = None,
        machine_name: Optional[str] = None,
        stream_id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        transmission_time: Optional[datetime.datetime] = None,
        is_web_app: Optional[bool] = None,
        performance_collection_supported: Optional[bool] = None,
        metrics: Optional[List["_models.MetricPoint"]] = None,
        documents: Optional[List["_models.DocumentIngress"]] = None,
        top_cpu_processes: Optional[List["_models.ProcessCpuData"]] = None,
        collection_configuration_errors: Optional[List["_models.CollectionConfigurationError"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: AI SDK version.
        :paramtype version: str
        :keyword invariant_version: Version/generation of the data contract (MonitoringDataPoint)
         between SDK and QuickPulse.
        :paramtype invariant_version: int
        :keyword instance: Service instance name where AI SDK lives.
        :paramtype instance: str
        :keyword role_name: Service role name.
        :paramtype role_name: str
        :keyword machine_name: Computer name where AI SDK lives.
        :paramtype machine_name: str
        :keyword stream_id: Identifies an AI SDK as a trusted agent to report metrics and documents.
        :paramtype stream_id: str
        :keyword timestamp: Data point generation timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks.
        :paramtype transmission_time: ~datetime.datetime
        :keyword is_web_app: True if the current application is an Azure Web App.
        :paramtype is_web_app: bool
        :keyword performance_collection_supported: True if performance counters collection is
         supported.
        :paramtype performance_collection_supported: bool
        :keyword metrics: An array of meric data points.
        :paramtype metrics: list[~quickpulse_client.models.MetricPoint]
        :keyword documents: An array of documents of a specific type {Request}, {RemoteDependency},
         {Exception}, {Event}, or {Trace}.
        :paramtype documents: list[~quickpulse_client.models.DocumentIngress]
        :keyword top_cpu_processes: An array of top cpu consumption data point.
        :paramtype top_cpu_processes: list[~quickpulse_client.models.ProcessCpuData]
        :keyword collection_configuration_errors: An array of error while parsing and applying .
        :paramtype collection_configuration_errors:
         list[~quickpulse_client.models.CollectionConfigurationError]
        """
        super().__init__(**kwargs)
        self.version = version
        self.invariant_version = invariant_version
        self.instance = instance
        self.role_name = role_name
        self.machine_name = machine_name
        self.stream_id = stream_id
        self.timestamp = timestamp
        self.transmission_time = transmission_time
        self.is_web_app = is_web_app
        self.performance_collection_supported = performance_collection_supported
        self.metrics = metrics
        self.documents = documents
        self.top_cpu_processes = top_cpu_processes
        self.collection_configuration_errors = collection_configuration_errors


class ProcessCpuData(_serialization.Model):
    """CPU consumption datapoint.

    :ivar process_name: Process name.
    :vartype process_name: str
    :ivar cpu_percentage: CPU consumption percentage.
    :vartype cpu_percentage: int
    """

    _attribute_map = {
        "process_name": {"key": "ProcessName", "type": "str"},
        "cpu_percentage": {"key": "CpuPercentage", "type": "int"},
    }

    def __init__(
        self, *, process_name: Optional[str] = None, cpu_percentage: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword process_name: Process name.
        :paramtype process_name: str
        :keyword cpu_percentage: CPU consumption percentage.
        :paramtype cpu_percentage: int
        """
        super().__init__(**kwargs)
        self.process_name = process_name
        self.cpu_percentage = cpu_percentage


class QuotaConfigurationInfo(_serialization.Model):
    """Control document quotas for QuickPulse.

    All required parameters must be populated in order to send to server.

    :ivar initial_quota: Initial quota.
    :vartype initial_quota: float
    :ivar max_quota: Max quota. Required.
    :vartype max_quota: float
    :ivar quota_accrual_rate_per_sec: Quota accrual rate per second. Required.
    :vartype quota_accrual_rate_per_sec: float
    """

    _validation = {
        "max_quota": {"required": True},
        "quota_accrual_rate_per_sec": {"required": True},
    }

    _attribute_map = {
        "initial_quota": {"key": "InitialQuota", "type": "float"},
        "max_quota": {"key": "MaxQuota", "type": "float"},
        "quota_accrual_rate_per_sec": {"key": "QuotaAccrualRatePerSec", "type": "float"},
    }

    def __init__(
        self,
        *,
        max_quota: float,
        quota_accrual_rate_per_sec: float,
        initial_quota: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword initial_quota: Initial quota.
        :paramtype initial_quota: float
        :keyword max_quota: Max quota. Required.
        :paramtype max_quota: float
        :keyword quota_accrual_rate_per_sec: Quota accrual rate per second. Required.
        :paramtype quota_accrual_rate_per_sec: float
        """
        super().__init__(**kwargs)
        self.initial_quota = initial_quota
        self.max_quota = max_quota
        self.quota_accrual_rate_per_sec = quota_accrual_rate_per_sec


class RemoteDependency(DocumentIngress):
    """Dependency type document.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Name of the command initiated with this dependency call, e.g., GET /username.
    :vartype name: str
    :ivar command_name: URL of the dependency call to the target, with all query string parameters.
    :vartype command_name: str
    :ivar result_code: Result code of a dependency call. Examples are SQL error code and HTTP
     status code.
    :vartype result_code: str
    :ivar duration: Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S
     or P[n]W.
    :vartype duration: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 1024},
        "command_name": {"max_length": 2048},
        "result_code": {"max_length": 1024},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
        "command_name": {"key": "CommandName", "type": "str"},
        "result_code": {"key": "ResultCode", "type": "str"},
        "duration": {"key": "Duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        command_name: Optional[str] = None,
        result_code: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Name of the command initiated with this dependency call, e.g., GET /username.
        :paramtype name: str
        :keyword command_name: URL of the dependency call to the target, with all query string
         parameters.
        :paramtype command_name: str
        :keyword result_code: Result code of a dependency call. Examples are SQL error code and HTTP
         status code.
        :paramtype result_code: str
        :keyword duration: Request duration in ISO 8601 duration format, i.e.,
         P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W.
        :paramtype duration: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "RemoteDependency"
        self.name = name
        self.command_name = command_name
        self.result_code = result_code
        self.duration = duration


class Request(DocumentIngress):
    """Request type document.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar name: Name of the request, e.g., 'GET /values/{id}'.
    :vartype name: str
    :ivar url: Request URL with all query string parameters.
    :vartype url: str
    :ivar response_code: Result of a request execution. For http requestss, it could be some HTTP
     status code.
    :vartype response_code: str
    :ivar duration: Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S
     or P[n]W.
    :vartype duration: str
    """

    _validation = {
        "document_type": {"required": True},
        "name": {"max_length": 1024},
        "url": {"max_length": 2048},
        "response_code": {"max_length": 1024},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "name": {"key": "Name", "type": "str"},
        "url": {"key": "Url", "type": "str"},
        "response_code": {"key": "ResponseCode", "type": "str"},
        "duration": {"key": "Duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        name: Optional[str] = None,
        url: Optional[str] = None,
        response_code: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword name: Name of the request, e.g., 'GET /values/{id}'.
        :paramtype name: str
        :keyword url: Request URL with all query string parameters.
        :paramtype url: str
        :keyword response_code: Result of a request execution. For http requestss, it could be some
         HTTP status code.
        :paramtype response_code: str
        :keyword duration: Request duration in ISO 8601 duration format, i.e.,
         P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W.
        :paramtype duration: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Request"
        self.name = name
        self.url = url
        self.response_code = response_code
        self.duration = duration


class ServiceError(_serialization.Model):
    """Optional http response body, whose existance carries additional error descriptions.

    :ivar request_id: A guid of the request that triggers the service error.
    :vartype request_id: str
    :ivar response_date_time: Service error response date time.
    :vartype response_date_time: ~datetime.datetime
    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar exception: Message of the exception that triggers the error response.
    :vartype exception: str
    """

    _attribute_map = {
        "request_id": {"key": "RequestId", "type": "str"},
        "response_date_time": {"key": "ResponseDateTime", "type": "iso-8601"},
        "code": {"key": "Code", "type": "str"},
        "message": {"key": "Message", "type": "str"},
        "exception": {"key": "Exception", "type": "str"},
    }

    def __init__(
        self,
        *,
        request_id: Optional[str] = None,
        response_date_time: Optional[datetime.datetime] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        exception: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword request_id: A guid of the request that triggers the service error.
        :paramtype request_id: str
        :keyword response_date_time: Service error response date time.
        :paramtype response_date_time: ~datetime.datetime
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword exception: Message of the exception that triggers the error response.
        :paramtype exception: str
        """
        super().__init__(**kwargs)
        self.request_id = request_id
        self.response_date_time = response_date_time
        self.code = code
        self.message = message
        self.exception = exception


class Trace(DocumentIngress):
    """Trace type name.

    All required parameters must be populated in order to send to server.

    :ivar document_type: Telemetry type. Types not defined in enum will get replaced with a
     'Unknown' type. Required. Known values are: "Request", "RemoteDependency", "Exception",
     "Event", and "Trace".
    :vartype document_type: str or ~quickpulse_client.models.DocumentIngressDocumentType
    :ivar document_stream_ids: An array of document streaming ids. Each id identifies a flow of
     documents customized by UX customers.
    :vartype document_stream_ids: list[str]
    :ivar properties: Collection of custom properties.
    :vartype properties: list[~quickpulse_client.models.KeyValuePairString]
    :ivar message: Trace message.
    :vartype message: str
    """

    _validation = {
        "document_type": {"required": True},
        "message": {"max_length": 32768},
    }

    _attribute_map = {
        "document_type": {"key": "DocumentType", "type": "str"},
        "document_stream_ids": {"key": "DocumentStreamIds", "type": "[str]"},
        "properties": {"key": "Properties", "type": "[KeyValuePairString]"},
        "message": {"key": "Message", "type": "str"},
    }

    def __init__(
        self,
        *,
        document_stream_ids: Optional[List[str]] = None,
        properties: Optional[List["_models.KeyValuePairString"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword document_stream_ids: An array of document streaming ids. Each id identifies a flow of
         documents customized by UX customers.
        :paramtype document_stream_ids: list[str]
        :keyword properties: Collection of custom properties.
        :paramtype properties: list[~quickpulse_client.models.KeyValuePairString]
        :keyword message: Trace message.
        :paramtype message: str
        """
        super().__init__(document_stream_ids=document_stream_ids, properties=properties, **kwargs)
        self.document_type: str = "Trace"
        self.message = message
