# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._resource_management_client_enums import *


class Alias(msrest.serialization.Model):
    """The alias type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The alias name.
    :vartype name: str
    :ivar paths: The paths for an alias.
    :vartype paths: list[~azure.mgmt.resource.resources.v2021_04_01.models.AliasPath]
    :ivar type: The type of the alias. Possible values include: "NotSpecified", "PlainText",
     "Mask".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.AliasType
    :ivar default_path: The default path for an alias.
    :vartype default_path: str
    :ivar default_pattern: The default pattern for an alias.
    :vartype default_pattern: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPattern
    :ivar default_metadata: The default alias path metadata. Applies to the default path and to any
     alias path that doesn't have metadata.
    :vartype default_metadata: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPathMetadata
    """

    _validation = {
        'default_metadata': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[AliasPath]'},
        'type': {'key': 'type', 'type': 'str'},
        'default_path': {'key': 'defaultPath', 'type': 'str'},
        'default_pattern': {'key': 'defaultPattern', 'type': 'AliasPattern'},
        'default_metadata': {'key': 'defaultMetadata', 'type': 'AliasPathMetadata'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        paths: Optional[List["AliasPath"]] = None,
        type: Optional[Union[str, "AliasType"]] = None,
        default_path: Optional[str] = None,
        default_pattern: Optional["AliasPattern"] = None,
        **kwargs
    ):
        """
        :keyword name: The alias name.
        :paramtype name: str
        :keyword paths: The paths for an alias.
        :paramtype paths: list[~azure.mgmt.resource.resources.v2021_04_01.models.AliasPath]
        :keyword type: The type of the alias. Possible values include: "NotSpecified", "PlainText",
         "Mask".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.AliasType
        :keyword default_path: The default path for an alias.
        :paramtype default_path: str
        :keyword default_pattern: The default pattern for an alias.
        :paramtype default_pattern: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPattern
        """
        super(Alias, self).__init__(**kwargs)
        self.name = name
        self.paths = paths
        self.type = type
        self.default_path = default_path
        self.default_pattern = default_pattern
        self.default_metadata = None


class AliasPath(msrest.serialization.Model):
    """The type of the paths for alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of an alias.
    :vartype path: str
    :ivar api_versions: The API versions.
    :vartype api_versions: list[str]
    :ivar pattern: The pattern for an alias path.
    :vartype pattern: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPattern
    :ivar metadata: The metadata of the alias path. If missing, fall back to the default metadata
     of the alias.
    :vartype metadata: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPathMetadata
    """

    _validation = {
        'metadata': {'readonly': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'pattern': {'key': 'pattern', 'type': 'AliasPattern'},
        'metadata': {'key': 'metadata', 'type': 'AliasPathMetadata'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        api_versions: Optional[List[str]] = None,
        pattern: Optional["AliasPattern"] = None,
        **kwargs
    ):
        """
        :keyword path: The path of an alias.
        :paramtype path: str
        :keyword api_versions: The API versions.
        :paramtype api_versions: list[str]
        :keyword pattern: The pattern for an alias path.
        :paramtype pattern: ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPattern
        """
        super(AliasPath, self).__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions
        self.pattern = pattern
        self.metadata = None


class AliasPathMetadata(msrest.serialization.Model):
    """AliasPathMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the token that the alias path is referring to. Possible values include:
     "NotSpecified", "Any", "String", "Object", "Array", "Integer", "Number", "Boolean".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPathTokenType
    :ivar attributes: The attributes of the token that the alias path is referring to. Possible
     values include: "None", "Modifiable".
    :vartype attributes: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPathAttributes
    """

    _validation = {
        'type': {'readonly': True},
        'attributes': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AliasPathMetadata, self).__init__(**kwargs)
        self.type = None
        self.attributes = None


class AliasPattern(msrest.serialization.Model):
    """The type of the pattern for an alias path.

    :ivar phrase: The alias pattern phrase.
    :vartype phrase: str
    :ivar variable: The alias pattern variable.
    :vartype variable: str
    :ivar type: The type of alias pattern. Possible values include: "NotSpecified", "Extract".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPatternType
    """

    _attribute_map = {
        'phrase': {'key': 'phrase', 'type': 'str'},
        'variable': {'key': 'variable', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        phrase: Optional[str] = None,
        variable: Optional[str] = None,
        type: Optional[Union[str, "AliasPatternType"]] = None,
        **kwargs
    ):
        """
        :keyword phrase: The alias pattern phrase.
        :paramtype phrase: str
        :keyword variable: The alias pattern variable.
        :paramtype variable: str
        :keyword type: The type of alias pattern. Possible values include: "NotSpecified", "Extract".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.AliasPatternType
        """
        super(AliasPattern, self).__init__(**kwargs)
        self.phrase = phrase
        self.variable = variable
        self.type = type


class ApiProfile(msrest.serialization.Model):
    """ApiProfile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_version: The profile version.
    :vartype profile_version: str
    :ivar api_version: The API version.
    :vartype api_version: str
    """

    _validation = {
        'profile_version': {'readonly': True},
        'api_version': {'readonly': True},
    }

    _attribute_map = {
        'profile_version': {'key': 'profileVersion', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApiProfile, self).__init__(**kwargs)
        self.profile_version = None
        self.api_version = None


class BasicDependency(msrest.serialization.Model):
    """Deployment dependency information.

    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super(BasicDependency, self).__init__(**kwargs)
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class DebugSetting(msrest.serialization.Model):
    """The debug setting.

    :ivar detail_level: Specifies the type of information to log for debugging. The permitted
     values are none, requestContent, responseContent, or both requestContent and responseContent
     separated by a comma. The default is none. When setting this value, carefully consider the type
     of information you are passing in during deployment. By logging information about the request
     or response, you could potentially expose sensitive data that is retrieved through the
     deployment operations.
    :vartype detail_level: str
    """

    _attribute_map = {
        'detail_level': {'key': 'detailLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        detail_level: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword detail_level: Specifies the type of information to log for debugging. The permitted
         values are none, requestContent, responseContent, or both requestContent and responseContent
         separated by a comma. The default is none. When setting this value, carefully consider the type
         of information you are passing in during deployment. By logging information about the request
         or response, you could potentially expose sensitive data that is retrieved through the
         deployment operations.
        :paramtype detail_level: str
        """
        super(DebugSetting, self).__init__(**kwargs)
        self.detail_level = detail_level


class Dependency(msrest.serialization.Model):
    """Deployment dependency information.

    :ivar depends_on: The list of dependencies.
    :vartype depends_on: list[~azure.mgmt.resource.resources.v2021_04_01.models.BasicDependency]
    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        'depends_on': {'key': 'dependsOn', 'type': '[BasicDependency]'},
        'id': {'key': 'id', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        depends_on: Optional[List["BasicDependency"]] = None,
        id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword depends_on: The list of dependencies.
        :paramtype depends_on: list[~azure.mgmt.resource.resources.v2021_04_01.models.BasicDependency]
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super(Dependency, self).__init__(**kwargs)
        self.depends_on = depends_on
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class Deployment(msrest.serialization.Model):
    """Deployment operation parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location to store the deployment data.
    :vartype location: str
    :ivar properties: Required. The deployment properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentProperties
    :ivar tags: A set of tags. Deployment tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        properties: "DeploymentProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: The location to store the deployment data.
        :paramtype location: str
        :keyword properties: Required. The deployment properties.
        :paramtype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentProperties
        :keyword tags: A set of tags. Deployment tags.
        :paramtype tags: dict[str, str]
        """
        super(Deployment, self).__init__(**kwargs)
        self.location = location
        self.properties = properties
        self.tags = tags


class DeploymentExportResult(msrest.serialization.Model):
    """The deployment export result.

    :ivar template: The template content.
    :vartype template: any
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        template: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword template: The template content.
        :paramtype template: any
        """
        super(DeploymentExportResult, self).__init__(**kwargs)
        self.template = template


class DeploymentExtended(msrest.serialization.Model):
    """Deployment information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the deployment.
    :vartype id: str
    :ivar name: The name of the deployment.
    :vartype name: str
    :ivar type: The type of the deployment.
    :vartype type: str
    :ivar location: the location of the deployment.
    :vartype location: str
    :ivar properties: Deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentPropertiesExtended
    :ivar tags: A set of tags. Deployment tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentPropertiesExtended'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["DeploymentPropertiesExtended"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: the location of the deployment.
        :paramtype location: str
        :keyword properties: Deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentPropertiesExtended
        :keyword tags: A set of tags. Deployment tags.
        :paramtype tags: dict[str, str]
        """
        super(DeploymentExtended, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.properties = properties
        self.tags = tags


class DeploymentExtendedFilter(msrest.serialization.Model):
    """Deployment filter.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: The provisioning state.
        :paramtype provisioning_state: str
        """
        super(DeploymentExtendedFilter, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state


class DeploymentListResult(msrest.serialization.Model):
    """List of deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployments.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentExtended]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentExtended]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeploymentExtended"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of deployments.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentExtended]
        """
        super(DeploymentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentOperation(msrest.serialization.Model):
    """Deployment operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full deployment operation ID.
    :vartype id: str
    :ivar operation_id: Deployment operation ID.
    :vartype operation_id: str
    :ivar properties: Deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentOperationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentOperationProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DeploymentOperationProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentOperationProperties
        """
        super(DeploymentOperation, self).__init__(**kwargs)
        self.id = None
        self.operation_id = None
        self.properties = properties


class DeploymentOperationProperties(msrest.serialization.Model):
    """Deployment operation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_operation: The name of the current provisioning operation. Possible values
     include: "NotSpecified", "Create", "Delete", "Waiting", "AzureAsyncOperationWaiting",
     "ResourceCacheWaiting", "Action", "Read", "EvaluateDeploymentOutput", "DeploymentCleanup".
    :vartype provisioning_operation: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.ProvisioningOperation
    :ivar provisioning_state: The state of the provisioning.
    :vartype provisioning_state: str
    :ivar timestamp: The date and time of the operation.
    :vartype timestamp: ~datetime.datetime
    :ivar duration: The duration of the operation.
    :vartype duration: str
    :ivar service_request_id: Deployment operation service request id.
    :vartype service_request_id: str
    :ivar status_code: Operation status code from the resource provider. This property may not be
     set if a response has not yet been received.
    :vartype status_code: str
    :ivar status_message: Operation status message from the resource provider. This property is
     optional.  It will only be provided if an error was received from the resource provider.
    :vartype status_message: ~azure.mgmt.resource.resources.v2021_04_01.models.StatusMessage
    :ivar target_resource: The target resource.
    :vartype target_resource: ~azure.mgmt.resource.resources.v2021_04_01.models.TargetResource
    :ivar request: The HTTP request message.
    :vartype request: ~azure.mgmt.resource.resources.v2021_04_01.models.HttpMessage
    :ivar response: The HTTP response message.
    :vartype response: ~azure.mgmt.resource.resources.v2021_04_01.models.HttpMessage
    """

    _validation = {
        'provisioning_operation': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'timestamp': {'readonly': True},
        'duration': {'readonly': True},
        'service_request_id': {'readonly': True},
        'status_code': {'readonly': True},
        'status_message': {'readonly': True},
        'target_resource': {'readonly': True},
        'request': {'readonly': True},
        'response': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_operation': {'key': 'provisioningOperation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
        'service_request_id': {'key': 'serviceRequestId', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'StatusMessage'},
        'target_resource': {'key': 'targetResource', 'type': 'TargetResource'},
        'request': {'key': 'request', 'type': 'HttpMessage'},
        'response': {'key': 'response', 'type': 'HttpMessage'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeploymentOperationProperties, self).__init__(**kwargs)
        self.provisioning_operation = None
        self.provisioning_state = None
        self.timestamp = None
        self.duration = None
        self.service_request_id = None
        self.status_code = None
        self.status_message = None
        self.target_resource = None
        self.request = None
        self.response = None


class DeploymentOperationsListResult(msrest.serialization.Model):
    """List of deployment operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployment operations.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentOperation]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeploymentOperation"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of deployment operations.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentOperation]
        """
        super(DeploymentOperationsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeploymentProperties(msrest.serialization.Model):
    """Deployment properties.

    All required parameters must be populated in order to send to Azure.

    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: any
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link: ~azure.mgmt.resource.resources.v2021_04_01.models.TemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     You use this element when you want to provide the parameter values directly in the request
     rather than link to an existing parameter file. Use either the parametersLink property or the
     parameters property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: any
    :ivar parameters_link: The URI of parameters file. You use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link: ~azure.mgmt.resource.resources.v2021_04_01.models.ParametersLink
    :ivar mode: Required. The mode that is used to deploy resources. This value can be either
     Incremental or Complete. In Incremental mode, resources are deployed without deleting existing
     resources that are not included in the template. In Complete mode, resources are deployed and
     existing resources in the resource group that are not included in the template are deleted. Be
     careful when using Complete mode as you may unintentionally delete resources. Possible values
     include: "Incremental", "Complete".
    :vartype mode: str or ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.resources.v2021_04_01.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment:
     ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeployment
    :ivar expression_evaluation_options: Specifies whether template expressions are evaluated
     within the scope of the parent template or nested template. Only applicable to nested
     templates. If not specified, default value is outer.
    :vartype expression_evaluation_options:
     ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptions
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'template_link': {'key': 'templateLink', 'type': 'TemplateLink'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'parameters_link': {'key': 'parametersLink', 'type': 'ParametersLink'},
        'mode': {'key': 'mode', 'type': 'str'},
        'debug_setting': {'key': 'debugSetting', 'type': 'DebugSetting'},
        'on_error_deployment': {'key': 'onErrorDeployment', 'type': 'OnErrorDeployment'},
        'expression_evaluation_options': {'key': 'expressionEvaluationOptions', 'type': 'ExpressionEvaluationOptions'},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "DeploymentMode"],
        template: Optional[Any] = None,
        template_link: Optional["TemplateLink"] = None,
        parameters: Optional[Any] = None,
        parameters_link: Optional["ParametersLink"] = None,
        debug_setting: Optional["DebugSetting"] = None,
        on_error_deployment: Optional["OnErrorDeployment"] = None,
        expression_evaluation_options: Optional["ExpressionEvaluationOptions"] = None,
        **kwargs
    ):
        """
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: any
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link: ~azure.mgmt.resource.resources.v2021_04_01.models.TemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. You use this element when you want to provide the parameter values directly in the
         request rather than link to an existing parameter file. Use either the parametersLink property
         or the parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: any
        :keyword parameters_link: The URI of parameters file. You use this element to link to an
         existing parameters file. Use either the parametersLink property or the parameters property,
         but not both.
        :paramtype parameters_link: ~azure.mgmt.resource.resources.v2021_04_01.models.ParametersLink
        :keyword mode: Required. The mode that is used to deploy resources. This value can be either
         Incremental or Complete. In Incremental mode, resources are deployed without deleting existing
         resources that are not included in the template. In Complete mode, resources are deployed and
         existing resources in the resource group that are not included in the template are deleted. Be
         careful when using Complete mode as you may unintentionally delete resources. Possible values
         include: "Incremental", "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.resources.v2021_04_01.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment:
         ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeployment
        :keyword expression_evaluation_options: Specifies whether template expressions are evaluated
         within the scope of the parent template or nested template. Only applicable to nested
         templates. If not specified, default value is outer.
        :paramtype expression_evaluation_options:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptions
        """
        super(DeploymentProperties, self).__init__(**kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.mode = mode
        self.debug_setting = debug_setting
        self.on_error_deployment = on_error_deployment
        self.expression_evaluation_options = expression_evaluation_options


class DeploymentPropertiesExtended(msrest.serialization.Model):
    """Deployment properties with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Denotes the state of provisioning. Possible values include:
     "NotSpecified", "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted",
     "Canceled", "Failed", "Succeeded", "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.ProvisioningState
    :ivar correlation_id: The correlation ID of the deployment.
    :vartype correlation_id: str
    :ivar timestamp: The timestamp of the template deployment.
    :vartype timestamp: ~datetime.datetime
    :ivar duration: The duration of the template deployment.
    :vartype duration: str
    :ivar outputs: Key/value pairs that represent deployment output.
    :vartype outputs: any
    :ivar providers: The list of resource providers needed for the deployment.
    :vartype providers: list[~azure.mgmt.resource.resources.v2021_04_01.models.Provider]
    :ivar dependencies: The list of deployment dependencies.
    :vartype dependencies: list[~azure.mgmt.resource.resources.v2021_04_01.models.Dependency]
    :ivar template_link: The URI referencing the template.
    :vartype template_link: ~azure.mgmt.resource.resources.v2021_04_01.models.TemplateLink
    :ivar parameters: Deployment parameters.
    :vartype parameters: any
    :ivar parameters_link: The URI referencing the parameters.
    :vartype parameters_link: ~azure.mgmt.resource.resources.v2021_04_01.models.ParametersLink
    :ivar mode: The deployment mode. Possible values are Incremental and Complete. Possible values
     include: "Incremental", "Complete".
    :vartype mode: str or ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.resources.v2021_04_01.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment:
     ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeploymentExtended
    :ivar template_hash: The hash produced for the template.
    :vartype template_hash: str
    :ivar output_resources: Array of provisioned resources.
    :vartype output_resources:
     list[~azure.mgmt.resource.resources.v2021_04_01.models.ResourceReference]
    :ivar validated_resources: Array of validated resources.
    :vartype validated_resources:
     list[~azure.mgmt.resource.resources.v2021_04_01.models.ResourceReference]
    :ivar error: The deployment error.
    :vartype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'correlation_id': {'readonly': True},
        'timestamp': {'readonly': True},
        'duration': {'readonly': True},
        'outputs': {'readonly': True},
        'providers': {'readonly': True},
        'dependencies': {'readonly': True},
        'template_link': {'readonly': True},
        'parameters': {'readonly': True},
        'parameters_link': {'readonly': True},
        'mode': {'readonly': True},
        'debug_setting': {'readonly': True},
        'on_error_deployment': {'readonly': True},
        'template_hash': {'readonly': True},
        'output_resources': {'readonly': True},
        'validated_resources': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'providers': {'key': 'providers', 'type': '[Provider]'},
        'dependencies': {'key': 'dependencies', 'type': '[Dependency]'},
        'template_link': {'key': 'templateLink', 'type': 'TemplateLink'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'parameters_link': {'key': 'parametersLink', 'type': 'ParametersLink'},
        'mode': {'key': 'mode', 'type': 'str'},
        'debug_setting': {'key': 'debugSetting', 'type': 'DebugSetting'},
        'on_error_deployment': {'key': 'onErrorDeployment', 'type': 'OnErrorDeploymentExtended'},
        'template_hash': {'key': 'templateHash', 'type': 'str'},
        'output_resources': {'key': 'outputResources', 'type': '[ResourceReference]'},
        'validated_resources': {'key': 'validatedResources', 'type': '[ResourceReference]'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DeploymentPropertiesExtended, self).__init__(**kwargs)
        self.provisioning_state = None
        self.correlation_id = None
        self.timestamp = None
        self.duration = None
        self.outputs = None
        self.providers = None
        self.dependencies = None
        self.template_link = None
        self.parameters = None
        self.parameters_link = None
        self.mode = None
        self.debug_setting = None
        self.on_error_deployment = None
        self.template_hash = None
        self.output_resources = None
        self.validated_resources = None
        self.error = None


class DeploymentValidateResult(msrest.serialization.Model):
    """Information from validate template deployment response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The deployment validation error.
    :vartype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
    :ivar properties: The template deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentPropertiesExtended
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'properties': {'key': 'properties', 'type': 'DeploymentPropertiesExtended'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DeploymentPropertiesExtended"] = None,
        **kwargs
    ):
        """
        :keyword properties: The template deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentPropertiesExtended
        """
        super(DeploymentValidateResult, self).__init__(**kwargs)
        self.error = None
        self.properties = properties


class DeploymentWhatIf(msrest.serialization.Model):
    """Deployment What-if operation parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location to store the deployment data.
    :vartype location: str
    :ivar properties: Required. The deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentWhatIfProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DeploymentWhatIfProperties",
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: The location to store the deployment data.
        :paramtype location: str
        :keyword properties: Required. The deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfProperties
        """
        super(DeploymentWhatIf, self).__init__(**kwargs)
        self.location = location
        self.properties = properties


class DeploymentWhatIfProperties(DeploymentProperties):
    """Deployment What-if properties.

    All required parameters must be populated in order to send to Azure.

    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: any
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link: ~azure.mgmt.resource.resources.v2021_04_01.models.TemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     You use this element when you want to provide the parameter values directly in the request
     rather than link to an existing parameter file. Use either the parametersLink property or the
     parameters property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: any
    :ivar parameters_link: The URI of parameters file. You use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link: ~azure.mgmt.resource.resources.v2021_04_01.models.ParametersLink
    :ivar mode: Required. The mode that is used to deploy resources. This value can be either
     Incremental or Complete. In Incremental mode, resources are deployed without deleting existing
     resources that are not included in the template. In Complete mode, resources are deployed and
     existing resources in the resource group that are not included in the template are deleted. Be
     careful when using Complete mode as you may unintentionally delete resources. Possible values
     include: "Incremental", "Complete".
    :vartype mode: str or ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.resources.v2021_04_01.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment:
     ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeployment
    :ivar expression_evaluation_options: Specifies whether template expressions are evaluated
     within the scope of the parent template or nested template. Only applicable to nested
     templates. If not specified, default value is outer.
    :vartype expression_evaluation_options:
     ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptions
    :ivar what_if_settings: Optional What-If operation settings.
    :vartype what_if_settings:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfSettings
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'template_link': {'key': 'templateLink', 'type': 'TemplateLink'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'parameters_link': {'key': 'parametersLink', 'type': 'ParametersLink'},
        'mode': {'key': 'mode', 'type': 'str'},
        'debug_setting': {'key': 'debugSetting', 'type': 'DebugSetting'},
        'on_error_deployment': {'key': 'onErrorDeployment', 'type': 'OnErrorDeployment'},
        'expression_evaluation_options': {'key': 'expressionEvaluationOptions', 'type': 'ExpressionEvaluationOptions'},
        'what_if_settings': {'key': 'whatIfSettings', 'type': 'DeploymentWhatIfSettings'},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "DeploymentMode"],
        template: Optional[Any] = None,
        template_link: Optional["TemplateLink"] = None,
        parameters: Optional[Any] = None,
        parameters_link: Optional["ParametersLink"] = None,
        debug_setting: Optional["DebugSetting"] = None,
        on_error_deployment: Optional["OnErrorDeployment"] = None,
        expression_evaluation_options: Optional["ExpressionEvaluationOptions"] = None,
        what_if_settings: Optional["DeploymentWhatIfSettings"] = None,
        **kwargs
    ):
        """
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: any
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link: ~azure.mgmt.resource.resources.v2021_04_01.models.TemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. You use this element when you want to provide the parameter values directly in the
         request rather than link to an existing parameter file. Use either the parametersLink property
         or the parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: any
        :keyword parameters_link: The URI of parameters file. You use this element to link to an
         existing parameters file. Use either the parametersLink property or the parameters property,
         but not both.
        :paramtype parameters_link: ~azure.mgmt.resource.resources.v2021_04_01.models.ParametersLink
        :keyword mode: Required. The mode that is used to deploy resources. This value can be either
         Incremental or Complete. In Incremental mode, resources are deployed without deleting existing
         resources that are not included in the template. In Complete mode, resources are deployed and
         existing resources in the resource group that are not included in the template are deleted. Be
         careful when using Complete mode as you may unintentionally delete resources. Possible values
         include: "Incremental", "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.resources.v2021_04_01.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment:
         ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeployment
        :keyword expression_evaluation_options: Specifies whether template expressions are evaluated
         within the scope of the parent template or nested template. Only applicable to nested
         templates. If not specified, default value is outer.
        :paramtype expression_evaluation_options:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptions
        :keyword what_if_settings: Optional What-If operation settings.
        :paramtype what_if_settings:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfSettings
        """
        super(DeploymentWhatIfProperties, self).__init__(template=template, template_link=template_link, parameters=parameters, parameters_link=parameters_link, mode=mode, debug_setting=debug_setting, on_error_deployment=on_error_deployment, expression_evaluation_options=expression_evaluation_options, **kwargs)
        self.what_if_settings = what_if_settings


class DeploymentWhatIfSettings(msrest.serialization.Model):
    """Deployment What-If operation settings.

    :ivar result_format: The format of the What-If results. Possible values include:
     "ResourceIdOnly", "FullResourcePayloads".
    :vartype result_format: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfResultFormat
    """

    _attribute_map = {
        'result_format': {'key': 'resultFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        result_format: Optional[Union[str, "WhatIfResultFormat"]] = None,
        **kwargs
    ):
        """
        :keyword result_format: The format of the What-If results. Possible values include:
         "ResourceIdOnly", "FullResourcePayloads".
        :paramtype result_format: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfResultFormat
        """
        super(DeploymentWhatIfSettings, self).__init__(**kwargs)
        self.result_format = result_format


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.resources.v2021_04_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExportTemplateRequest(msrest.serialization.Model):
    """Export resource group template request parameters.

    :ivar resources: The IDs of the resources to filter the export by. To export all resources,
     supply an array with single entry '*'.
    :vartype resources: list[str]
    :ivar options: The export template options. A CSV-formatted list containing zero or more of the
     following: 'IncludeParameterDefaultValue', 'IncludeComments',
     'SkipResourceNameParameterization', 'SkipAllParameterization'.
    :vartype options: str
    """

    _attribute_map = {
        'resources': {'key': 'resources', 'type': '[str]'},
        'options': {'key': 'options', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resources: Optional[List[str]] = None,
        options: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resources: The IDs of the resources to filter the export by. To export all resources,
         supply an array with single entry '*'.
        :paramtype resources: list[str]
        :keyword options: The export template options. A CSV-formatted list containing zero or more of
         the following: 'IncludeParameterDefaultValue', 'IncludeComments',
         'SkipResourceNameParameterization', 'SkipAllParameterization'.
        :paramtype options: str
        """
        super(ExportTemplateRequest, self).__init__(**kwargs)
        self.resources = resources
        self.options = options


class ExpressionEvaluationOptions(msrest.serialization.Model):
    """Specifies whether template expressions are evaluated within the scope of the parent template or nested template.

    :ivar scope: The scope to be used for evaluation of parameters, variables and functions in a
     nested template. Possible values include: "NotSpecified", "Outer", "Inner".
    :vartype scope: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptionsScopeType
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scope: Optional[Union[str, "ExpressionEvaluationOptionsScopeType"]] = None,
        **kwargs
    ):
        """
        :keyword scope: The scope to be used for evaluation of parameters, variables and functions in a
         nested template. Possible values include: "NotSpecified", "Outer", "Inner".
        :paramtype scope: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExpressionEvaluationOptionsScopeType
        """
        super(ExpressionEvaluationOptions, self).__init__(**kwargs)
        self.scope = scope


class ExtendedLocation(msrest.serialization.Model):
    """Resource extended location.

    :ivar type: The extended location type. Possible values include: "EdgeZone".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocationType
    :ivar name: The extended location name.
    :vartype name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ExtendedLocationType"]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The extended location type. Possible values include: "EdgeZone".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocationType
        :keyword name: The extended location name.
        :paramtype name: str
        """
        super(ExtendedLocation, self).__init__(**kwargs)
        self.type = type
        self.name = name


class Resource(msrest.serialization.Model):
    """Specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar extended_location: Resource extended location.
    :vartype extended_location: ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword extended_location: Resource extended location.
        :paramtype extended_location:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.extended_location = extended_location
        self.tags = tags


class GenericResource(Resource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar extended_location: Resource extended location.
    :vartype extended_location: ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: The plan of the resource.
    :vartype plan: ~azure.mgmt.resource.resources.v2021_04_01.models.Plan
    :ivar properties: The resource properties.
    :vartype properties: any
    :ivar kind: The kind of the resource.
    :vartype kind: str
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.resources.v2021_04_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.resources.v2021_04_01.models.Identity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'properties': {'key': 'properties', 'type': 'object'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        properties: Optional[Any] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword extended_location: Resource extended location.
        :paramtype extended_location:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: The plan of the resource.
        :paramtype plan: ~azure.mgmt.resource.resources.v2021_04_01.models.Plan
        :keyword properties: The resource properties.
        :paramtype properties: any
        :keyword kind: The kind of the resource.
        :paramtype kind: str
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.resources.v2021_04_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.resources.v2021_04_01.models.Identity
        """
        super(GenericResource, self).__init__(location=location, extended_location=extended_location, tags=tags, **kwargs)
        self.plan = plan
        self.properties = properties
        self.kind = kind
        self.managed_by = managed_by
        self.sku = sku
        self.identity = identity


class GenericResourceExpanded(GenericResource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar extended_location: Resource extended location.
    :vartype extended_location: ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: The plan of the resource.
    :vartype plan: ~azure.mgmt.resource.resources.v2021_04_01.models.Plan
    :ivar properties: The resource properties.
    :vartype properties: any
    :ivar kind: The kind of the resource.
    :vartype kind: str
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.resources.v2021_04_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.resources.v2021_04_01.models.Identity
    :ivar created_time: The created time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype changed_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource. This is only present if
     requested via the $expand query parameter.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'properties': {'key': 'properties', 'type': 'object'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        properties: Optional[Any] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword extended_location: Resource extended location.
        :paramtype extended_location:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ExtendedLocation
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: The plan of the resource.
        :paramtype plan: ~azure.mgmt.resource.resources.v2021_04_01.models.Plan
        :keyword properties: The resource properties.
        :paramtype properties: any
        :keyword kind: The kind of the resource.
        :paramtype kind: str
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.resources.v2021_04_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.resources.v2021_04_01.models.Identity
        """
        super(GenericResourceExpanded, self).__init__(location=location, extended_location=extended_location, tags=tags, plan=plan, properties=properties, kind=kind, managed_by=managed_by, sku=sku, identity=identity, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.provisioning_state = None


class GenericResourceFilter(msrest.serialization.Model):
    """Resource filter.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar tagname: The tag name.
    :vartype tagname: str
    :ivar tagvalue: The tag value.
    :vartype tagvalue: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'tagname': {'key': 'tagname', 'type': 'str'},
        'tagvalue': {'key': 'tagvalue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        tagname: Optional[str] = None,
        tagvalue: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword tagname: The tag name.
        :paramtype tagname: str
        :keyword tagvalue: The tag value.
        :paramtype tagvalue: str
        """
        super(GenericResourceFilter, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.tagname = tagname
        self.tagvalue = tagvalue


class HttpMessage(msrest.serialization.Model):
    """HTTP message.

    :ivar content: HTTP message content.
    :vartype content: any
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        content: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword content: HTTP message content.
        :paramtype content: any
        """
        super(HttpMessage, self).__init__(**kwargs)
        self.content = content


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.resources.v2021_04_01.models.IdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{IdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "IdentityUserAssignedIdentitiesValue"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Possible values include: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.resources.v2021_04_01.models.IdentityUserAssignedIdentitiesValue]
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IdentityUserAssignedIdentitiesValue(msrest.serialization.Model):
    """IdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class OnErrorDeployment(msrest.serialization.Model):
    """Deployment on error behavior.

    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Possible values include: "LastSuccessful", "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Possible values include: "LastSuccessful", "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super(OnErrorDeployment, self).__init__(**kwargs)
        self.type = type
        self.deployment_name = deployment_name


class OnErrorDeploymentExtended(msrest.serialization.Model):
    """Deployment on error behavior with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The state of the provisioning for the on error deployment.
    :vartype provisioning_state: str
    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Possible values include: "LastSuccessful", "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Possible values include: "LastSuccessful", "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super(OnErrorDeploymentExtended, self).__init__(**kwargs)
        self.provisioning_state = None
        self.type = type
        self.deployment_name = deployment_name


class Operation(msrest.serialization.Model):
    """Microsoft.Resources operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.resources.v2021_04_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.resource.resources.v2021_04_01.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Resources.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Resources.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Microsoft.Resources operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Resources operations.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of Microsoft.Resources operations.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ParametersLink(msrest.serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar uri: Required. The URI of the parameters file.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        'uri': {'required': True},
    }

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        content_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword uri: Required. The URI of the parameters file.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super(ParametersLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class Permission(msrest.serialization.Model):
    """Role definition permissions.

    :ivar actions: Allowed actions.
    :vartype actions: list[str]
    :ivar not_actions: Denied actions.
    :vartype not_actions: list[str]
    :ivar data_actions: Allowed Data actions.
    :vartype data_actions: list[str]
    :ivar not_data_actions: Denied Data actions.
    :vartype not_data_actions: list[str]
    """

    _attribute_map = {
        'actions': {'key': 'actions', 'type': '[str]'},
        'not_actions': {'key': 'notActions', 'type': '[str]'},
        'data_actions': {'key': 'dataActions', 'type': '[str]'},
        'not_data_actions': {'key': 'notDataActions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        actions: Optional[List[str]] = None,
        not_actions: Optional[List[str]] = None,
        data_actions: Optional[List[str]] = None,
        not_data_actions: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword actions: Allowed actions.
        :paramtype actions: list[str]
        :keyword not_actions: Denied actions.
        :paramtype not_actions: list[str]
        :keyword data_actions: Allowed Data actions.
        :paramtype data_actions: list[str]
        :keyword not_data_actions: Denied Data actions.
        :paramtype not_data_actions: list[str]
        """
        super(Permission, self).__init__(**kwargs)
        self.actions = actions
        self.not_actions = not_actions
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions


class Plan(msrest.serialization.Model):
    """Plan for the resource.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The offer ID.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version.
    :vartype version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The offer ID.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version.
        :paramtype version: str
        """
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class Provider(msrest.serialization.Model):
    """Resource provider information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The provider ID.
    :vartype id: str
    :ivar namespace: The namespace of the resource provider.
    :vartype namespace: str
    :ivar registration_state: The registration state of the resource provider.
    :vartype registration_state: str
    :ivar registration_policy: The registration policy of the resource provider.
    :vartype registration_policy: str
    :ivar resource_types: The collection of provider resource types.
    :vartype resource_types:
     list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderResourceType]
    :ivar provider_authorization_consent_state: The provider authorization consent state. Possible
     values include: "NotSpecified", "Required", "NotRequired", "Consented".
    :vartype provider_authorization_consent_state: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderAuthorizationConsentState
    """

    _validation = {
        'id': {'readonly': True},
        'registration_state': {'readonly': True},
        'registration_policy': {'readonly': True},
        'resource_types': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'registration_state': {'key': 'registrationState', 'type': 'str'},
        'registration_policy': {'key': 'registrationPolicy', 'type': 'str'},
        'resource_types': {'key': 'resourceTypes', 'type': '[ProviderResourceType]'},
        'provider_authorization_consent_state': {'key': 'providerAuthorizationConsentState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        namespace: Optional[str] = None,
        provider_authorization_consent_state: Optional[Union[str, "ProviderAuthorizationConsentState"]] = None,
        **kwargs
    ):
        """
        :keyword namespace: The namespace of the resource provider.
        :paramtype namespace: str
        :keyword provider_authorization_consent_state: The provider authorization consent state.
         Possible values include: "NotSpecified", "Required", "NotRequired", "Consented".
        :paramtype provider_authorization_consent_state: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderAuthorizationConsentState
        """
        super(Provider, self).__init__(**kwargs)
        self.id = None
        self.namespace = namespace
        self.registration_state = None
        self.registration_policy = None
        self.resource_types = None
        self.provider_authorization_consent_state = provider_authorization_consent_state


class ProviderConsentDefinition(msrest.serialization.Model):
    """The provider consent.

    :ivar consent_to_authorization: A value indicating whether authorization is consented or not.
    :vartype consent_to_authorization: bool
    """

    _attribute_map = {
        'consent_to_authorization': {'key': 'consentToAuthorization', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        consent_to_authorization: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword consent_to_authorization: A value indicating whether authorization is consented or
         not.
        :paramtype consent_to_authorization: bool
        """
        super(ProviderConsentDefinition, self).__init__(**kwargs)
        self.consent_to_authorization = consent_to_authorization


class ProviderExtendedLocation(msrest.serialization.Model):
    """The provider extended location.

    :ivar location: The azure location.
    :vartype location: str
    :ivar type: The extended location type.
    :vartype type: str
    :ivar extended_locations: The extended locations for the azure location.
    :vartype extended_locations: list[str]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'extended_locations': {'key': 'extendedLocations', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        type: Optional[str] = None,
        extended_locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword location: The azure location.
        :paramtype location: str
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword extended_locations: The extended locations for the azure location.
        :paramtype extended_locations: list[str]
        """
        super(ProviderExtendedLocation, self).__init__(**kwargs)
        self.location = location
        self.type = type
        self.extended_locations = extended_locations


class ProviderListResult(msrest.serialization.Model):
    """List of resource providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resource providers.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.Provider]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Provider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Provider"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of resource providers.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.Provider]
        """
        super(ProviderListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProviderPermission(msrest.serialization.Model):
    """The provider permission.

    :ivar application_id: The application id.
    :vartype application_id: str
    :ivar role_definition: Role definition properties.
    :vartype role_definition: ~azure.mgmt.resource.resources.v2021_04_01.models.RoleDefinition
    :ivar managed_by_role_definition: Role definition properties.
    :vartype managed_by_role_definition:
     ~azure.mgmt.resource.resources.v2021_04_01.models.RoleDefinition
    :ivar provider_authorization_consent_state: The provider authorization consent state. Possible
     values include: "NotSpecified", "Required", "NotRequired", "Consented".
    :vartype provider_authorization_consent_state: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderAuthorizationConsentState
    """

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'role_definition': {'key': 'roleDefinition', 'type': 'RoleDefinition'},
        'managed_by_role_definition': {'key': 'managedByRoleDefinition', 'type': 'RoleDefinition'},
        'provider_authorization_consent_state': {'key': 'providerAuthorizationConsentState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        application_id: Optional[str] = None,
        role_definition: Optional["RoleDefinition"] = None,
        managed_by_role_definition: Optional["RoleDefinition"] = None,
        provider_authorization_consent_state: Optional[Union[str, "ProviderAuthorizationConsentState"]] = None,
        **kwargs
    ):
        """
        :keyword application_id: The application id.
        :paramtype application_id: str
        :keyword role_definition: Role definition properties.
        :paramtype role_definition: ~azure.mgmt.resource.resources.v2021_04_01.models.RoleDefinition
        :keyword managed_by_role_definition: Role definition properties.
        :paramtype managed_by_role_definition:
         ~azure.mgmt.resource.resources.v2021_04_01.models.RoleDefinition
        :keyword provider_authorization_consent_state: The provider authorization consent state.
         Possible values include: "NotSpecified", "Required", "NotRequired", "Consented".
        :paramtype provider_authorization_consent_state: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderAuthorizationConsentState
        """
        super(ProviderPermission, self).__init__(**kwargs)
        self.application_id = application_id
        self.role_definition = role_definition
        self.managed_by_role_definition = managed_by_role_definition
        self.provider_authorization_consent_state = provider_authorization_consent_state


class ProviderPermissionListResult(msrest.serialization.Model):
    """List of provider permissions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of provider permissions.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderPermission]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProviderPermission]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProviderPermission"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of provider permissions.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderPermission]
        """
        super(ProviderPermissionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProviderRegistrationRequest(msrest.serialization.Model):
    """The provider registration definition.

    :ivar third_party_provider_consent: The provider consent.
    :vartype third_party_provider_consent:
     ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderConsentDefinition
    """

    _attribute_map = {
        'third_party_provider_consent': {'key': 'thirdPartyProviderConsent', 'type': 'ProviderConsentDefinition'},
    }

    def __init__(
        self,
        *,
        third_party_provider_consent: Optional["ProviderConsentDefinition"] = None,
        **kwargs
    ):
        """
        :keyword third_party_provider_consent: The provider consent.
        :paramtype third_party_provider_consent:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ProviderConsentDefinition
        """
        super(ProviderRegistrationRequest, self).__init__(**kwargs)
        self.third_party_provider_consent = third_party_provider_consent


class ProviderResourceType(msrest.serialization.Model):
    """Resource type managed by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar locations: The collection of locations where this resource type can be created.
    :vartype locations: list[str]
    :ivar location_mappings: The location mappings that are supported by this resource type.
    :vartype location_mappings:
     list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderExtendedLocation]
    :ivar aliases: The aliases that are supported by this resource type.
    :vartype aliases: list[~azure.mgmt.resource.resources.v2021_04_01.models.Alias]
    :ivar api_versions: The API version.
    :vartype api_versions: list[str]
    :ivar default_api_version: The default API version.
    :vartype default_api_version: str
    :ivar zone_mappings:
    :vartype zone_mappings: list[~azure.mgmt.resource.resources.v2021_04_01.models.ZoneMapping]
    :ivar api_profiles: The API profiles for the resource provider.
    :vartype api_profiles: list[~azure.mgmt.resource.resources.v2021_04_01.models.ApiProfile]
    :ivar capabilities: The additional capabilities offered by this resource type.
    :vartype capabilities: str
    :ivar properties: The properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'default_api_version': {'readonly': True},
        'api_profiles': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_mappings': {'key': 'locationMappings', 'type': '[ProviderExtendedLocation]'},
        'aliases': {'key': 'aliases', 'type': '[Alias]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'default_api_version': {'key': 'defaultApiVersion', 'type': 'str'},
        'zone_mappings': {'key': 'zoneMappings', 'type': '[ZoneMapping]'},
        'api_profiles': {'key': 'apiProfiles', 'type': '[ApiProfile]'},
        'capabilities': {'key': 'capabilities', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        location_mappings: Optional[List["ProviderExtendedLocation"]] = None,
        aliases: Optional[List["Alias"]] = None,
        api_versions: Optional[List[str]] = None,
        zone_mappings: Optional[List["ZoneMapping"]] = None,
        capabilities: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword locations: The collection of locations where this resource type can be created.
        :paramtype locations: list[str]
        :keyword location_mappings: The location mappings that are supported by this resource type.
        :paramtype location_mappings:
         list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderExtendedLocation]
        :keyword aliases: The aliases that are supported by this resource type.
        :paramtype aliases: list[~azure.mgmt.resource.resources.v2021_04_01.models.Alias]
        :keyword api_versions: The API version.
        :paramtype api_versions: list[str]
        :keyword zone_mappings:
        :paramtype zone_mappings: list[~azure.mgmt.resource.resources.v2021_04_01.models.ZoneMapping]
        :keyword capabilities: The additional capabilities offered by this resource type.
        :paramtype capabilities: str
        :keyword properties: The properties.
        :paramtype properties: dict[str, str]
        """
        super(ProviderResourceType, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.locations = locations
        self.location_mappings = location_mappings
        self.aliases = aliases
        self.api_versions = api_versions
        self.default_api_version = None
        self.zone_mappings = zone_mappings
        self.api_profiles = None
        self.capabilities = capabilities
        self.properties = properties


class ProviderResourceTypeListResult(msrest.serialization.Model):
    """List of resource types of a resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resource types.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderResourceType]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProviderResourceType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProviderResourceType"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of resource types.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ProviderResourceType]
        """
        super(ProviderResourceTypeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceGroup(msrest.serialization.Model):
    """Resource group information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the resource group.
    :vartype id: str
    :ivar name: The name of the resource group.
    :vartype name: str
    :ivar type: The type of the resource group.
    :vartype type: str
    :ivar properties: The resource group properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroupProperties
    :ivar location: Required. The location of the resource group. It cannot be changed after the
     resource group has been created. It must be one of the supported Azure locations.
    :vartype location: str
    :ivar managed_by: The ID of the resource that manages this resource group.
    :vartype managed_by: str
    :ivar tags: A set of tags. The tags attached to the resource group.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceGroupProperties'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: Optional["ResourceGroupProperties"] = None,
        managed_by: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword properties: The resource group properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroupProperties
        :keyword location: Required. The location of the resource group. It cannot be changed after the
         resource group has been created. It must be one of the supported Azure locations.
        :paramtype location: str
        :keyword managed_by: The ID of the resource that manages this resource group.
        :paramtype managed_by: str
        :keyword tags: A set of tags. The tags attached to the resource group.
        :paramtype tags: dict[str, str]
        """
        super(ResourceGroup, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.location = location
        self.managed_by = managed_by
        self.tags = tags


class ResourceGroupExportResult(msrest.serialization.Model):
    """Resource group export result.

    :ivar template: The template content.
    :vartype template: any
    :ivar error: The template export error.
    :vartype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        template: Optional[Any] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        """
        :keyword template: The template content.
        :paramtype template: any
        :keyword error: The template export error.
        :paramtype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
        """
        super(ResourceGroupExportResult, self).__init__(**kwargs)
        self.template = template
        self.error = error


class ResourceGroupFilter(msrest.serialization.Model):
    """Resource group filter.

    :ivar tag_name: The tag name.
    :vartype tag_name: str
    :ivar tag_value: The tag value.
    :vartype tag_value: str
    """

    _attribute_map = {
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'tag_value': {'key': 'tagValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tag_name: Optional[str] = None,
        tag_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tag_name: The tag name.
        :paramtype tag_name: str
        :keyword tag_value: The tag value.
        :paramtype tag_value: str
        """
        super(ResourceGroupFilter, self).__init__(**kwargs)
        self.tag_name = tag_name
        self.tag_value = tag_value


class ResourceGroupListResult(msrest.serialization.Model):
    """List of resource groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resource groups.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroup]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ResourceGroup"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of resource groups.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroup]
        """
        super(ResourceGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceGroupPatchable(msrest.serialization.Model):
    """Resource group information.

    :ivar name: The name of the resource group.
    :vartype name: str
    :ivar properties: The resource group properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroupProperties
    :ivar managed_by: The ID of the resource that manages this resource group.
    :vartype managed_by: str
    :ivar tags: A set of tags. The tags attached to the resource group.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceGroupProperties'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["ResourceGroupProperties"] = None,
        managed_by: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the resource group.
        :paramtype name: str
        :keyword properties: The resource group properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.ResourceGroupProperties
        :keyword managed_by: The ID of the resource that manages this resource group.
        :paramtype managed_by: str
        :keyword tags: A set of tags. The tags attached to the resource group.
        :paramtype tags: dict[str, str]
        """
        super(ResourceGroupPatchable, self).__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.managed_by = managed_by
        self.tags = tags


class ResourceGroupProperties(msrest.serialization.Model):
    """The resource group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceGroupProperties, self).__init__(**kwargs)
        self.provisioning_state = None


class ResourceListResult(msrest.serialization.Model):
    """List of resource groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resources.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.GenericResourceExpanded]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GenericResourceExpanded]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GenericResourceExpanded"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of resources.
        :paramtype value:
         list[~azure.mgmt.resource.resources.v2021_04_01.models.GenericResourceExpanded]
        """
        super(ResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceProviderOperationDisplayProperties(msrest.serialization.Model):
    """Resource provider operation's display properties.

    :ivar publisher: Operation description.
    :vartype publisher: str
    :ivar provider: Operation provider.
    :vartype provider: str
    :ivar resource: Operation resource.
    :vartype resource: str
    :ivar operation: Resource provider operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword publisher: Operation description.
        :paramtype publisher: str
        :keyword provider: Operation provider.
        :paramtype provider: str
        :keyword resource: Operation resource.
        :paramtype resource: str
        :keyword operation: Resource provider operation.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super(ResourceProviderOperationDisplayProperties, self).__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceReference(msrest.serialization.Model):
    """The resource Id model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified resource Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceReference, self).__init__(**kwargs)
        self.id = None


class ResourcesMoveInfo(msrest.serialization.Model):
    """Parameters of move resources.

    :ivar resources: The IDs of the resources.
    :vartype resources: list[str]
    :ivar target_resource_group: The target resource group.
    :vartype target_resource_group: str
    """

    _attribute_map = {
        'resources': {'key': 'resources', 'type': '[str]'},
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resources: Optional[List[str]] = None,
        target_resource_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resources: The IDs of the resources.
        :paramtype resources: list[str]
        :keyword target_resource_group: The target resource group.
        :paramtype target_resource_group: str
        """
        super(ResourcesMoveInfo, self).__init__(**kwargs)
        self.resources = resources
        self.target_resource_group = target_resource_group


class RoleDefinition(msrest.serialization.Model):
    """Role definition properties.

    :ivar id: The role definition ID.
    :vartype id: str
    :ivar name: The role definition name.
    :vartype name: str
    :ivar is_service_role: If this is a service role.
    :vartype is_service_role: bool
    :ivar permissions: Role definition permissions.
    :vartype permissions: list[~azure.mgmt.resource.resources.v2021_04_01.models.Permission]
    :ivar scopes: Role definition assignable scopes.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'is_service_role': {'key': 'isServiceRole', 'type': 'bool'},
        'permissions': {'key': 'permissions', 'type': '[Permission]'},
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        is_service_role: Optional[bool] = None,
        permissions: Optional[List["Permission"]] = None,
        scopes: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: The role definition ID.
        :paramtype id: str
        :keyword name: The role definition name.
        :paramtype name: str
        :keyword is_service_role: If this is a service role.
        :paramtype is_service_role: bool
        :keyword permissions: Role definition permissions.
        :paramtype permissions: list[~azure.mgmt.resource.resources.v2021_04_01.models.Permission]
        :keyword scopes: Role definition assignable scopes.
        :paramtype scopes: list[str]
        """
        super(RoleDefinition, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.is_service_role = is_service_role
        self.permissions = permissions
        self.scopes = scopes


class ScopedDeployment(msrest.serialization.Model):
    """Deployment operation parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. The location to store the deployment data.
    :vartype location: str
    :ivar properties: Required. The deployment properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentProperties
    :ivar tags: A set of tags. Deployment tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentProperties'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "DeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location to store the deployment data.
        :paramtype location: str
        :keyword properties: Required. The deployment properties.
        :paramtype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentProperties
        :keyword tags: A set of tags. Deployment tags.
        :paramtype tags: dict[str, str]
        """
        super(ScopedDeployment, self).__init__(**kwargs)
        self.location = location
        self.properties = properties
        self.tags = tags


class ScopedDeploymentWhatIf(msrest.serialization.Model):
    """Deployment What-if operation parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. The location to store the deployment data.
    :vartype location: str
    :ivar properties: Required. The deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfProperties
    """

    _validation = {
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentWhatIfProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "DeploymentWhatIfProperties",
        **kwargs
    ):
        """
        :keyword location: Required. The location to store the deployment data.
        :paramtype location: str
        :keyword properties: Required. The deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2021_04_01.models.DeploymentWhatIfProperties
        """
        super(ScopedDeploymentWhatIf, self).__init__(**kwargs)
        self.location = location
        self.properties = properties


class Sku(msrest.serialization.Model):
    """SKU for the resource.

    :ivar name: The SKU name.
    :vartype name: str
    :ivar tier: The SKU tier.
    :vartype tier: str
    :ivar size: The SKU size.
    :vartype size: str
    :ivar family: The SKU family.
    :vartype family: str
    :ivar model: The SKU model.
    :vartype model: str
    :ivar capacity: The SKU capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        model: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The SKU name.
        :paramtype name: str
        :keyword tier: The SKU tier.
        :paramtype tier: str
        :keyword size: The SKU size.
        :paramtype size: str
        :keyword family: The SKU family.
        :paramtype family: str
        :keyword model: The SKU model.
        :paramtype model: str
        :keyword capacity: The SKU capacity.
        :paramtype capacity: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.model = model
        self.capacity = capacity


class StatusMessage(msrest.serialization.Model):
    """Operation status message object.

    :ivar status: Status of the deployment operation.
    :vartype status: str
    :ivar error: The error reported by the operation.
    :vartype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        """
        :keyword status: Status of the deployment operation.
        :paramtype status: str
        :keyword error: The error reported by the operation.
        :paramtype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
        """
        super(StatusMessage, self).__init__(**kwargs)
        self.status = status
        self.error = error


class SubResource(msrest.serialization.Model):
    """Sub-resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class TagCount(msrest.serialization.Model):
    """Tag count.

    :ivar type: Type of count.
    :vartype type: str
    :ivar value: Value of count.
    :vartype value: int
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        value: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword type: Type of count.
        :paramtype type: str
        :keyword value: Value of count.
        :paramtype value: int
        """
        super(TagCount, self).__init__(**kwargs)
        self.type = type
        self.value = value


class TagDetails(msrest.serialization.Model):
    """Tag details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag name ID.
    :vartype id: str
    :ivar tag_name: The tag name.
    :vartype tag_name: str
    :ivar count: The total number of resources that use the resource tag. When a tag is initially
     created and has no associated resources, the value is 0.
    :vartype count: ~azure.mgmt.resource.resources.v2021_04_01.models.TagCount
    :ivar values: The list of tag values.
    :vartype values: list[~azure.mgmt.resource.resources.v2021_04_01.models.TagValue]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'count': {'key': 'count', 'type': 'TagCount'},
        'values': {'key': 'values', 'type': '[TagValue]'},
    }

    def __init__(
        self,
        *,
        tag_name: Optional[str] = None,
        count: Optional["TagCount"] = None,
        values: Optional[List["TagValue"]] = None,
        **kwargs
    ):
        """
        :keyword tag_name: The tag name.
        :paramtype tag_name: str
        :keyword count: The total number of resources that use the resource tag. When a tag is
         initially created and has no associated resources, the value is 0.
        :paramtype count: ~azure.mgmt.resource.resources.v2021_04_01.models.TagCount
        :keyword values: The list of tag values.
        :paramtype values: list[~azure.mgmt.resource.resources.v2021_04_01.models.TagValue]
        """
        super(TagDetails, self).__init__(**kwargs)
        self.id = None
        self.tag_name = tag_name
        self.count = count
        self.values = values


class Tags(msrest.serialization.Model):
    """A dictionary of name and value pairs.

    :ivar tags: A set of tags. Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        """
        super(Tags, self).__init__(**kwargs)
        self.tags = tags


class TagsListResult(msrest.serialization.Model):
    """List of subscription tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of tags.
    :vartype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.TagDetails]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TagDetails"]] = None,
        **kwargs
    ):
        """
        :keyword value: An array of tags.
        :paramtype value: list[~azure.mgmt.resource.resources.v2021_04_01.models.TagDetails]
        """
        super(TagsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class TagsPatchResource(msrest.serialization.Model):
    """Wrapper resource for tags patch API request only.

    :ivar operation: The operation type for the patch API. Possible values include: "Replace",
     "Merge", "Delete".
    :vartype operation: str or ~azure.mgmt.resource.resources.v2021_04_01.models.TagsPatchOperation
    :ivar properties: The set of tags.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.Tags
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Tags'},
    }

    def __init__(
        self,
        *,
        operation: Optional[Union[str, "TagsPatchOperation"]] = None,
        properties: Optional["Tags"] = None,
        **kwargs
    ):
        """
        :keyword operation: The operation type for the patch API. Possible values include: "Replace",
         "Merge", "Delete".
        :paramtype operation: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.TagsPatchOperation
        :keyword properties: The set of tags.
        :paramtype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.Tags
        """
        super(TagsPatchResource, self).__init__(**kwargs)
        self.operation = operation
        self.properties = properties


class TagsResource(msrest.serialization.Model):
    """Wrapper resource for tags API requests and responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the tags wrapper resource.
    :vartype id: str
    :ivar name: The name of the tags wrapper resource.
    :vartype name: str
    :ivar type: The type of the tags wrapper resource.
    :vartype type: str
    :ivar properties: Required. The set of tags.
    :vartype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.Tags
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Tags'},
    }

    def __init__(
        self,
        *,
        properties: "Tags",
        **kwargs
    ):
        """
        :keyword properties: Required. The set of tags.
        :paramtype properties: ~azure.mgmt.resource.resources.v2021_04_01.models.Tags
        """
        super(TagsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class TagValue(msrest.serialization.Model):
    """Tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag value ID.
    :vartype id: str
    :ivar tag_value: The tag value.
    :vartype tag_value: str
    :ivar count: The tag value count.
    :vartype count: ~azure.mgmt.resource.resources.v2021_04_01.models.TagCount
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'tag_value': {'key': 'tagValue', 'type': 'str'},
        'count': {'key': 'count', 'type': 'TagCount'},
    }

    def __init__(
        self,
        *,
        tag_value: Optional[str] = None,
        count: Optional["TagCount"] = None,
        **kwargs
    ):
        """
        :keyword tag_value: The tag value.
        :paramtype tag_value: str
        :keyword count: The tag value count.
        :paramtype count: ~azure.mgmt.resource.resources.v2021_04_01.models.TagCount
        """
        super(TagValue, self).__init__(**kwargs)
        self.id = None
        self.tag_value = tag_value
        self.count = count


class TargetResource(msrest.serialization.Model):
    """Target resource.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The ID of the resource.
        :paramtype id: str
        :keyword resource_name: The name of the resource.
        :paramtype resource_name: str
        :keyword resource_type: The type of the resource.
        :paramtype resource_type: str
        """
        super(TargetResource, self).__init__(**kwargs)
        self.id = id
        self.resource_name = resource_name
        self.resource_type = resource_type


class TemplateHashResult(msrest.serialization.Model):
    """Result of the request to calculate template hash. It contains a string of minified template and its hash.

    :ivar minified_template: The minified template string.
    :vartype minified_template: str
    :ivar template_hash: The template hash.
    :vartype template_hash: str
    """

    _attribute_map = {
        'minified_template': {'key': 'minifiedTemplate', 'type': 'str'},
        'template_hash': {'key': 'templateHash', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minified_template: Optional[str] = None,
        template_hash: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword minified_template: The minified template string.
        :paramtype minified_template: str
        :keyword template_hash: The template hash.
        :paramtype template_hash: str
        """
        super(TemplateHashResult, self).__init__(**kwargs)
        self.minified_template = minified_template
        self.template_hash = template_hash


class TemplateLink(msrest.serialization.Model):
    """Entity representing the reference to the template.

    :ivar uri: The URI of the template to deploy. Use either the uri or id property, but not both.
    :vartype uri: str
    :ivar id: The resource id of a Template Spec. Use either the id or uri property, but not both.
    :vartype id: str
    :ivar relative_path: The relativePath property can be used to deploy a linked template at a
     location relative to the parent. If the parent template was linked with a TemplateSpec, this
     will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
     deployment will be a combination of the parent and relativePath URIs.
    :vartype relative_path: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    :ivar query_string: The query string (for example, a SAS token) to be used with the
     templateLink URI.
    :vartype query_string: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'query_string': {'key': 'queryString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        id: Optional[str] = None,
        relative_path: Optional[str] = None,
        content_version: Optional[str] = None,
        query_string: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword uri: The URI of the template to deploy. Use either the uri or id property, but not
         both.
        :paramtype uri: str
        :keyword id: The resource id of a Template Spec. Use either the id or uri property, but not
         both.
        :paramtype id: str
        :keyword relative_path: The relativePath property can be used to deploy a linked template at a
         location relative to the parent. If the parent template was linked with a TemplateSpec, this
         will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
         deployment will be a combination of the parent and relativePath URIs.
        :paramtype relative_path: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        :keyword query_string: The query string (for example, a SAS token) to be used with the
         templateLink URI.
        :paramtype query_string: str
        """
        super(TemplateLink, self).__init__(**kwargs)
        self.uri = uri
        self.id = id
        self.relative_path = relative_path
        self.content_version = content_version
        self.query_string = query_string


class WhatIfChange(msrest.serialization.Model):
    """Information about a single resource change predicted by What-If operation.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: Required. Resource ID.
    :vartype resource_id: str
    :ivar change_type: Required. Type of change that will be made to the resource when the
     deployment is executed. Possible values include: "Create", "Delete", "Ignore", "Deploy",
     "NoChange", "Modify", "Unsupported".
    :vartype change_type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ChangeType
    :ivar unsupported_reason: The explanation about why the resource is unsupported by What-If.
    :vartype unsupported_reason: str
    :ivar before: The snapshot of the resource before the deployment is executed.
    :vartype before: any
    :ivar after: The predicted snapshot of the resource after the deployment is executed.
    :vartype after: any
    :ivar delta: The predicted changes to resource properties.
    :vartype delta: list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfPropertyChange]
    """

    _validation = {
        'resource_id': {'required': True},
        'change_type': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'change_type': {'key': 'changeType', 'type': 'str'},
        'unsupported_reason': {'key': 'unsupportedReason', 'type': 'str'},
        'before': {'key': 'before', 'type': 'object'},
        'after': {'key': 'after', 'type': 'object'},
        'delta': {'key': 'delta', 'type': '[WhatIfPropertyChange]'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        change_type: Union[str, "ChangeType"],
        unsupported_reason: Optional[str] = None,
        before: Optional[Any] = None,
        after: Optional[Any] = None,
        delta: Optional[List["WhatIfPropertyChange"]] = None,
        **kwargs
    ):
        """
        :keyword resource_id: Required. Resource ID.
        :paramtype resource_id: str
        :keyword change_type: Required. Type of change that will be made to the resource when the
         deployment is executed. Possible values include: "Create", "Delete", "Ignore", "Deploy",
         "NoChange", "Modify", "Unsupported".
        :paramtype change_type: str or ~azure.mgmt.resource.resources.v2021_04_01.models.ChangeType
        :keyword unsupported_reason: The explanation about why the resource is unsupported by What-If.
        :paramtype unsupported_reason: str
        :keyword before: The snapshot of the resource before the deployment is executed.
        :paramtype before: any
        :keyword after: The predicted snapshot of the resource after the deployment is executed.
        :paramtype after: any
        :keyword delta: The predicted changes to resource properties.
        :paramtype delta: list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfPropertyChange]
        """
        super(WhatIfChange, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.change_type = change_type
        self.unsupported_reason = unsupported_reason
        self.before = before
        self.after = after
        self.delta = delta


class WhatIfOperationResult(msrest.serialization.Model):
    """Result of the What-If operation. Contains a list of predicted changes and a URL link to get to the next set of results.

    :ivar status: Status of the What-If operation.
    :vartype status: str
    :ivar error: Error when What-If operation fails.
    :vartype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
    :ivar changes: List of resource changes predicted by What-If operation.
    :vartype changes: list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfChange]
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
        'changes': {'key': 'properties.changes', 'type': '[WhatIfChange]'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error: Optional["ErrorResponse"] = None,
        changes: Optional[List["WhatIfChange"]] = None,
        **kwargs
    ):
        """
        :keyword status: Status of the What-If operation.
        :paramtype status: str
        :keyword error: Error when What-If operation fails.
        :paramtype error: ~azure.mgmt.resource.resources.v2021_04_01.models.ErrorResponse
        :keyword changes: List of resource changes predicted by What-If operation.
        :paramtype changes: list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfChange]
        """
        super(WhatIfOperationResult, self).__init__(**kwargs)
        self.status = status
        self.error = error
        self.changes = changes


class WhatIfPropertyChange(msrest.serialization.Model):
    """The predicted change to the resource property.

    All required parameters must be populated in order to send to Azure.

    :ivar path: Required. The path of the property.
    :vartype path: str
    :ivar property_change_type: Required. The type of property change. Possible values include:
     "Create", "Delete", "Modify", "Array", "NoEffect".
    :vartype property_change_type: str or
     ~azure.mgmt.resource.resources.v2021_04_01.models.PropertyChangeType
    :ivar before: The value of the property before the deployment is executed.
    :vartype before: any
    :ivar after: The value of the property after the deployment is executed.
    :vartype after: any
    :ivar children: Nested property changes.
    :vartype children: list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfPropertyChange]
    """

    _validation = {
        'path': {'required': True},
        'property_change_type': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'property_change_type': {'key': 'propertyChangeType', 'type': 'str'},
        'before': {'key': 'before', 'type': 'object'},
        'after': {'key': 'after', 'type': 'object'},
        'children': {'key': 'children', 'type': '[WhatIfPropertyChange]'},
    }

    def __init__(
        self,
        *,
        path: str,
        property_change_type: Union[str, "PropertyChangeType"],
        before: Optional[Any] = None,
        after: Optional[Any] = None,
        children: Optional[List["WhatIfPropertyChange"]] = None,
        **kwargs
    ):
        """
        :keyword path: Required. The path of the property.
        :paramtype path: str
        :keyword property_change_type: Required. The type of property change. Possible values include:
         "Create", "Delete", "Modify", "Array", "NoEffect".
        :paramtype property_change_type: str or
         ~azure.mgmt.resource.resources.v2021_04_01.models.PropertyChangeType
        :keyword before: The value of the property before the deployment is executed.
        :paramtype before: any
        :keyword after: The value of the property after the deployment is executed.
        :paramtype after: any
        :keyword children: Nested property changes.
        :paramtype children:
         list[~azure.mgmt.resource.resources.v2021_04_01.models.WhatIfPropertyChange]
        """
        super(WhatIfPropertyChange, self).__init__(**kwargs)
        self.path = path
        self.property_change_type = property_change_type
        self.before = before
        self.after = after
        self.children = children


class ZoneMapping(msrest.serialization.Model):
    """ZoneMapping.

    :ivar location: The location of the zone mapping.
    :vartype location: str
    :ivar zones:
    :vartype zones: list[str]
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        zones: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword location: The location of the zone mapping.
        :paramtype location: str
        :keyword zones:
        :paramtype zones: list[str]
        """
        super(ZoneMapping, self).__init__(**kwargs)
        self.location = location
        self.zones = zones
