/*
 * Copyright (c) 1997, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package jakarta.mail.event;

/**
 * The adapter which receives connection events.
 * The methods in this class are empty;  this class is provided as a
 * convenience for easily creating listeners by extending this class
 * and overriding only the methods of interest.
 *
 * @author John Mani
 */
public abstract class ConnectionAdapter implements ConnectionListener {


    /**
     * Creates a default {@code ConnectionAdapter}.
     */
    public ConnectionAdapter() {
    }

    @Override
    public void opened(ConnectionEvent e) {}
    @Override
    public void disconnected(ConnectionEvent e) {}
    @Override
    public void closed(ConnectionEvent e) {}
}
