/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.NekoDOMParser;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class NekoHTMLParser
implements HTMLParser {
    private static final char NBSP = '\u00a0';

    NekoHTMLParser() {
    }

    public void parse(URL pageURL, String pageText, DocumentAdapter adapter) throws IOException, SAXException {
        try {
            NekoDOMParser parser = NekoDOMParser.newParser(adapter, pageURL);
            parser.parse(new InputSource(new StringReader(pageText)));
            adapter.setRootNode(parser.getDocument());
        }
        catch (NekoDOMParser.ScriptException e) {
            throw e.getException();
        }
    }

    public String getCleanedText(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }

    public boolean supportsPreserveTagCase() {
        return true;
    }

    public boolean supportsReturnHTMLDocument() {
        return true;
    }

    public boolean supportsParserWarnings() {
        return true;
    }

    static {
        NBSP = (char)160;
    }
}

