/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class ExtensionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundAnyAttribute = false;
    private boolean foundAttributes = false;
    private boolean foundModelGroup = false;

    public ExtensionUnmarshaller(ComplexType complexType, AttributeSet atts, Resolver resolver) throws XMLException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._complexType.setDerivationMethod("extension");
        String base = atts.getValue("base");
        if (base != null && base.length() > 0) {
            XMLType baseType = this._schema.getType(base);
            if (baseType == null) {
                this._complexType.setBase(base);
                if (this._complexType.isSimpleContent()) {
                    this._complexType.setContentType(new SimpleContent(this._schema, base));
                }
            } else {
                if (baseType.isSimpleType() && this._complexType.isComplexContent()) {
                    String err = "In a 'complexContent', the base attribute must be a complexType but " + base + " is a simpleType.\n";
                    this.error(err);
                }
                this._complexType.setBaseType(baseType);
                if (this._complexType.isSimpleContent()) {
                    if (baseType.isSimpleType()) {
                        SimpleType simpleType = (SimpleType)baseType;
                        this._complexType.setContentType(new SimpleContent(simpleType));
                    } else {
                        ComplexType temp = (ComplexType)baseType;
                        SimpleContent simpleContent = (SimpleContent)temp.getContentType();
                        this._complexType.setContentType(simpleContent.copy());
                    }
                }
            }
        }
    }

    public String elementName() {
        return "extension";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("anyAttribute".equals(name)) {
            this.foundAnyAttribute = true;
            this.unmarshaller = new WildcardUnmarshaller(this._complexType, this._schema, name, atts, this.getResolver());
        } else if ("attribute".equals(name)) {
            this.foundAttributes = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, atts, this.getResolver());
        } else if ("attributeGroup".equals(name)) {
            if (atts.getValue("ref") == null) {
                String err = "A complexType may contain referring attribute groups, but not defining ones.";
                this.error(err);
            }
            this.foundAttributes = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, atts);
        } else if (name.equals("group")) {
            if (this.foundAttributes) {
                this.error("'" + name + "' must appear before any attribute " + "definitions when a child of 'complexType'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + name + "' cannot appear as a child of 'complexType' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, atts, this.getResolver());
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            if (this.foundAttributes) {
                this.error("'" + name + "' must appear before attribute " + "definitions in an 'extension' element.");
            }
            if (this.foundModelGroup) {
                this.error("'" + name + "' cannot appear as a child of 'extension' " + "if another 'all', 'sequence', 'choice' or " + "'group' already exists.");
            }
            if (this._complexType.isSimpleContent()) {
                this.error("'" + name + "' may not appear in a 'extension' of " + "'simpleContent'.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new GroupUnmarshaller(this._schema, name, atts, this.getResolver());
        } else if ("anyAttribute".equals(name)) {
            this.error("anyAttribute is not yet supported.");
        } else if (name.equals("annotation")) {
            if (this.foundAttributes || this.foundModelGroup) {
                this.error("An annotation must appear as the first child of an 'extension' element.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as the child of an 'extension' element.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("anyAttribute".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if ("attribute".equals(name)) {
            AttributeDecl attrDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attrDecl);
        } else if ("attributeGroup".equals(name)) {
            AttributeGroupReference attrGroupRef = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attrGroupRef);
        } else if (name.equals("group")) {
            ModelGroup group = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(ann);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

