/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.Wildcard;

public final class AttributeGroupReference
extends AttributeGroup {
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of AttributeGroupReference";
    private Schema _schema = null;
    private String _reference = null;

    public AttributeGroupReference(Schema schema, String reference) {
        if (schema == null) {
            String err = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (reference == null) {
            String err = NULL_ARGUMENT + "; 'reference' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._schema = schema;
        this._reference = reference;
    }

    public Wildcard getAnyAttribute() {
        return this.resolveReference().getAnyAttribute();
    }

    public String getReference() {
        return this._reference;
    }

    public AttributeGroup resolveReference() {
        AttributeGroup attrGroup = this._schema.getAttributeGroup(this._reference);
        if (attrGroup == null) {
            throw new IllegalStateException("Invalid AttributeGroupReference");
        }
        return attrGroup;
    }

    public AttributeDecl getAttribute(String name) {
        return this.resolveReference().getAttribute(name);
    }

    public Enumeration getAttributes() {
        return this.resolveReference().getAttributes();
    }

    public boolean isEmpty() {
        return this.resolveReference().isEmpty();
    }
}

