/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.DescriptorSourceFactory;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SourceFactory;
import org.exolab.castor.builder.binding.BindingException;
import org.exolab.castor.builder.binding.BindingLoader;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.PackageType;
import org.exolab.castor.builder.binding.PackageTypeChoice;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.binding.types.BindingType;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SourceGenerator
extends BuilderConfiguration {
    static final String APP_NAME = "Castor";
    static final String APP_DESC = "XML data binder for Java";
    static final String VERSION = "0.9.5.2";
    static final String APP_URI = "http://www.castor.org";
    private static final String DEFAULT_HEADER = "This class was automatically generated with \n<a href=\"http://www.castor.org\">Castor 0.9.5.2</a>, using an XML Schema.\n$Id$";
    private static final String ELEMENT_VALUE = "element";
    private static final String TYPE_VALUE = "type";
    private static final int ELEMENT_BINDING = 0;
    private static final int TYPE_BINDING = 1;
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private static final String CASTOR_TESTABLE_MSG = "The generated classes will implement org.exolab.castor.tests.CastorTestable";
    private static final String SAX1_MSG = "The generated classes will use SAX 1";
    private static final String IMPORT_WARNING = "Warning: Do not forget to generate source code for the following imported schema: ";
    private Configuration _config = LocalConfiguration.getInstance();
    private XMLBindingComponent _bindingComponent = null;
    private String _lineSeparator = null;
    private JComment _header = null;
    private boolean _warnOnOverwrite = true;
    private boolean _suppressNonFatalWarnings = false;
    private boolean _verbose = false;
    private String _destDir = null;
    private boolean _createDescriptors = true;
    private boolean _createMarshall = true;
    private boolean _testable = false;
    private DescriptorSourceFactory _descSourceFactory = null;
    private FieldInfoFactory _infoFactory = null;
    private SourceFactory _sourceFactory = null;
    private ConsoleDialog _dialog = new ConsoleDialog();

    public SourceGenerator() {
        this(null);
    }

    public SourceGenerator(FieldInfoFactory infoFactory) {
        this(infoFactory, null);
    }

    public SourceGenerator(FieldInfoFactory infoFactory, ExtendedBinding binding) {
        this._infoFactory = infoFactory == null ? new FieldInfoFactory() : infoFactory;
        this.load();
        this._sourceFactory = new SourceFactory(this, this._infoFactory);
        this._descSourceFactory = new DescriptorSourceFactory(this);
        this._header = new JComment(3);
        this._header.appendComment(DEFAULT_HEADER);
        this._bindingComponent = new XMLBindingComponent(this);
        this.setBinding(binding);
    }

    public void generateSource(Schema schema, String packageName) {
        if (schema == null) {
            String err = "The argument 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        SGStateInfo sInfo = new SGStateInfo(schema, this);
        try {
            schema.validate();
        }
        catch (ValidationException ve) {
            String err = "The schema:" + schema.getSchemaLocation() + " is not valid.\n";
            err = err + ve.getMessage();
            throw new IllegalArgumentException(err);
        }
        if (packageName != null) {
            String targetNamespace = schema.getTargetNamespace();
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            this.setNamespacePackageMapping(targetNamespace, packageName);
        }
        sInfo.packageName = packageName;
        sInfo.setDialog(this._dialog);
        sInfo.setPromptForOverwrite(this._warnOnOverwrite);
        sInfo.setVerbose(this._verbose);
        sInfo.setSuppressNonFatalWarnings(this._suppressNonFatalWarnings);
        this.createClasses(schema, sInfo);
    }

    public void generateSource(InputSource source, String packageName) {
        Parser parser = null;
        try {
            parser = this._config.getParser();
        }
        catch (RuntimeException rte) {
            // empty catch block
        }
        if (parser == null) {
            this._dialog.notify("fatal error: unable to create SAX parser.");
            return;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
        }
        catch (XMLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            this._dialog.notify("error reading XML Schema file");
            return;
        }
        catch (SAXException sx) {
            Exception except = sx.getException();
            if (except == null) {
                except = sx;
            }
            if (except instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)except;
                this._dialog.notify("SAXParseException: " + spe);
                this._dialog.notify(" - occured at line ");
                this._dialog.notify(new Integer(spe.getLineNumber()).toString());
                this._dialog.notify(", column ");
                this._dialog.notify(new Integer(spe.getColumnNumber()).toString());
            } else {
                except.printStackTrace();
            }
            return;
        }
        Schema schema = schemaUnmarshaller.getSchema();
        this.generateSource(schema, packageName);
    }

    public void generateSource(Reader reader, String packageName) {
        InputSource source = new InputSource(reader);
        this.generateSource(source, packageName);
    }

    public void generateSource(String filename, String packageName) throws FileNotFoundException {
        if (filename.startsWith("./")) {
            filename = filename.substring(2);
        }
        FileReader reader = new FileReader(filename);
        InputSource source = new InputSource(reader);
        source.setSystemId(SourceGenerator.toURIRepresentation(new File(filename).getAbsolutePath()));
        this.generateSource(source, packageName);
        try {
            reader.close();
        }
        catch (IOException iox) {
            // empty catch block
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public void setSAX1(boolean sax1) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setSAX1(sax1);
        }
    }

    public void setSuppressNonFatalWarnings(boolean suppress) {
        this._warnOnOverwrite = !suppress;
        this._suppressNonFatalWarnings = suppress;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setDescriptorCreation(boolean createDescriptors) {
        this._createDescriptors = createDescriptors;
    }

    public void setDestDir(String destDir) {
        this._destDir = destDir;
    }

    public void setCreateMarshalMethods(boolean createMarshalMethods) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setCreateMarshalMethods(createMarshalMethods);
        }
    }

    public void setTestable(boolean testable) {
        if (this._sourceFactory != null) {
            this._sourceFactory.setTestable(testable);
        }
    }

    public void setBinding(ExtendedBinding binding) {
        if (binding != null) {
            this.processNamespaces(binding.getPackage());
        }
        this._bindingComponent.setBinding(binding);
    }

    public void setBinding(String fileName) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(fileName);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "unable to load a binding file due to the following:\n";
            err = err + e.getMessage();
            err = err + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public void setBinding(InputSource source) {
        try {
            ExtendedBinding binding = BindingLoader.createBinding(source);
            this.setBinding(binding);
        }
        catch (BindingException e) {
            String err = "unable to load a binding file due to the following:\n";
            err = err + e.getMessage();
            err = err + "\nThe Source Generator will continue with no binding file.";
            this._dialog.notify(err);
        }
    }

    public static void main(String[] args) {
        boolean verbose;
        CommandLineOptions allOptions = new CommandLineOptions();
        allOptions.addFlag("i", "filename", "Sets the input filename");
        allOptions.addFlag("package", "package-name", "Sets the package name", true);
        String desc = "Sets the destination output directory";
        allOptions.addFlag("dest", "dest-dir", desc, true);
        desc = "Sets the line separator style for the desired platform";
        allOptions.addFlag("line-separator", "( unix | mac | win)", desc, true);
        desc = "Suppresses non fatal warnings, such as overwriting files.";
        allOptions.addFlag("f", "", desc, true);
        desc = "Displays this help screen.";
        allOptions.addFlag("h", "", desc, true);
        desc = "Prints out additional messages when creaing source";
        allOptions.addFlag("verbose", "", desc, true);
        desc = "Disables the generation of the Class descriptors";
        allOptions.addFlag("nodesc", "", desc, true);
        desc = "Sets the source generator types name (SGTypeFactory)";
        allOptions.addFlag("types", "types", desc, true);
        allOptions.addFlag("type-factory", "classname", "", true);
        desc = "Disables the generation of the methods specific to the XML marshalling framework";
        allOptions.addFlag("nomarshall", "", desc, true);
        desc = "Implements some specific methods to allow the generated classes to be used with Castor Testing Framework";
        allOptions.addFlag("testable", "", desc, true);
        desc = "Uses SAX 1 in the generated code.";
        allOptions.addFlag("sax1", "", desc, true);
        desc = "Sets the Source Generator Binding File name";
        allOptions.addFlag("binding-file", "filename", desc, true);
        Properties options = allOptions.getOptions(args);
        if (options.getProperty("h") != null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printHelp(pw);
            pw.flush();
            return;
        }
        String schemaFilename = options.getProperty("i");
        String packageName = options.getProperty("package");
        String lineSepStyle = options.getProperty("line-separator");
        boolean force = options.getProperty("f") != null;
        String typeFactory = options.getProperty("types");
        boolean bl = verbose = options.getProperty("verbose") != null;
        if (schemaFilename == null) {
            System.out.println(APP_NAME);
            allOptions.printUsage(new PrintWriter(System.out));
            return;
        }
        if (typeFactory == null) {
            typeFactory = options.getProperty("type-factory");
        }
        String lineSep = System.getProperty("line.separator");
        if (lineSepStyle != null) {
            if ("win".equals(lineSepStyle)) {
                System.out.println(" - using Windows style line separation.");
                lineSep = "\r\n";
            } else if ("unix".equals(lineSepStyle)) {
                System.out.println(" - using UNIX style line separation.");
                lineSep = "\n";
            } else if ("mac".equals(lineSepStyle)) {
                System.out.println(" - using Macintosh style line separation.");
                lineSep = "\r";
            } else {
                System.out.print("- invalid option for line-separator: ");
                System.out.println(lineSepStyle);
                System.out.println("-- using default line separator for this platform");
            }
        }
        SourceGenerator sgen = null;
        if (typeFactory != null) {
            if (typeFactory.equals("j2")) {
                typeFactory = "arraylist";
            }
            try {
                FieldInfoFactory factory = new FieldInfoFactory(typeFactory);
                sgen = new SourceGenerator(factory);
            }
            catch (Exception x) {
                try {
                    sgen = new SourceGenerator((FieldInfoFactory)Thread.currentThread().getContextClassLoader().loadClass(typeFactory).newInstance());
                }
                catch (Exception e) {
                    System.out.print("- invalid option for types: ");
                    System.out.println(typeFactory);
                    System.out.println(x);
                    System.out.println("-- using default source generator types");
                    sgen = new SourceGenerator();
                }
            }
        } else {
            sgen = new SourceGenerator();
        }
        sgen.setDestDir(options.getProperty("dest"));
        sgen.setLineSeparator(lineSep);
        sgen.setSuppressNonFatalWarnings(force);
        sgen.setVerbose(verbose);
        if (force) {
            System.out.println("-- Suppressing non fatal warnings.");
        }
        if (options.getProperty("nodesc") != null) {
            sgen.setDescriptorCreation(false);
            System.out.print("-- ");
            System.out.println(DISABLE_DESCRIPTORS_MSG);
        }
        if (options.getProperty("nomarshall") != null) {
            sgen.setCreateMarshalMethods(false);
            System.out.print("-- ");
            System.out.println(DISABLE_MARSHALL_MSG);
        }
        if (options.getProperty("testable") != null) {
            sgen.setTestable(true);
            System.out.print("-- ");
            System.out.println(CASTOR_TESTABLE_MSG);
        }
        if (options.getProperty("sax1") != null) {
            sgen.setSAX1(true);
            System.out.print("-- ");
            System.out.println(SAX1_MSG);
        }
        if (options.getProperty("binding-file") != null) {
            ExtendedBinding binding = null;
            try {
                binding = BindingLoader.createBinding(options.getProperty("binding-file"));
            }
            catch (BindingException e) {
                System.out.print("--");
                System.out.println("Unable to load a binding file due to the following Exception:");
                e.printStackTrace();
                System.out.println("-- No binding file will be used");
            }
            sgen.setBinding(binding);
        }
        try {
            sgen.generateSource(schemaFilename, packageName);
        }
        catch (FileNotFoundException fne) {
            System.out.println("unable to open XML schema file");
            return;
        }
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    private void createClasses(Schema schema, SGStateInfo sInfo) {
        if (!this._suppressNonFatalWarnings) {
            Enumeration enumeration = schema.getImportedSchema();
            while (enumeration.hasMoreElements()) {
                Schema importedSchema = (Schema)enumeration.nextElement();
                System.out.println();
                System.out.println(IMPORT_WARNING + importedSchema.getSchemaLocation());
            }
        }
        Enumeration structures = schema.getElementDecls();
        while (structures.hasMoreElements()) {
            this.createClasses((ElementDecl)structures.nextElement(), sInfo);
        }
        structures = schema.getComplexTypes();
        while (structures.hasMoreElements()) {
            this.processComplexType((ComplexType)structures.nextElement(), sInfo);
        }
        structures = schema.getSimpleTypes();
        while (structures.hasMoreElements()) {
            this.processSimpleType((SimpleType)structures.nextElement(), sInfo);
        }
        structures = schema.getModelGroups();
        while (structures.hasMoreElements()) {
            this.createClasses((ModelGroup)structures.nextElement(), sInfo);
        }
        Enumeration keys = sInfo.keys();
        while (keys.hasMoreElements()) {
            ClassInfo cInfo = sInfo.resolve(keys.nextElement());
            JClass jClass = cInfo.getJClass();
            if (sInfo.processed(jClass)) continue;
            this.processJClass(jClass, sInfo);
        }
    }

    public boolean mappingSchemaElement2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type.getType() == 0;
        }
        return super.mappingSchemaElement2Java();
    }

    public boolean mappingSchemaType2Java() {
        BindingType type;
        ExtendedBinding binding;
        if (this._bindingComponent != null && (binding = this._bindingComponent.getBinding()) != null && (type = binding.getDefaultBindingType()) != null) {
            return type.getType() == 1;
        }
        return super.mappingSchemaType2Java();
    }

    private void createClasses(ElementDecl elementDecl, SGStateInfo sInfo) {
        if (elementDecl == null) {
            return;
        }
        XMLType xmlType = elementDecl.getType();
        if (this.mappingSchemaType2Java() && (elementDecl.isReference() || xmlType != null && xmlType.getName() != null)) {
            return;
        }
        this._bindingComponent.setView(elementDecl);
        ClassInfo cInfo = sInfo.resolve(elementDecl);
        if (cInfo != null && cInfo.getJClass() != null) {
            JClass jClass = cInfo.getJClass();
            if (sInfo.processed(jClass)) {
                return;
            }
            jClass = null;
        }
        if (xmlType == null) {
            if (sInfo.verbose()) {
                String msg = "No type found for element: ";
                sInfo.getDialog().notify(msg + elementDecl.getName());
            }
            return;
        }
        if (xmlType.isComplexType()) {
            JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
            for (int i = 0; i < classes.length; ++i) {
                this.processJClass(classes[i], sInfo);
            }
            if (xmlType.getSchema() == this._bindingComponent.getSchema()) {
                this.processComplexType((ComplexType)xmlType, sInfo);
            }
        } else if (xmlType.isSimpleType()) {
            this.processSimpleType((SimpleType)xmlType, sInfo);
        }
    }

    private void createClasses(Group group, SGStateInfo sInfo) {
        if (group == null) {
            return;
        }
        if (group.getParticleCount() == 0) {
            if (group instanceof ModelGroup) {
                ModelGroup mg = (ModelGroup)group;
                if (mg.isReference() && (mg = mg.getReference()).getParticleCount() == 0) {
                    return;
                }
            } else {
                return;
            }
        }
        this._bindingComponent.setView(group);
        JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
        this.processContentModel(group, sInfo);
        for (int i = 0; i < classes.length; ++i) {
            this.processJClass(classes[i], sInfo);
        }
    }

    private void processComplexType(ComplexType complexType, SGStateInfo sInfo) {
        if (complexType == null) {
            return;
        }
        this._bindingComponent.setView(complexType);
        ClassInfo classInfo = sInfo.resolve(complexType);
        if (classInfo == null) {
            if (complexType.isTopLevel()) {
                JClass[] classes = this._sourceFactory.createSourceCode(this._bindingComponent, sInfo);
                for (int i = 0; i < classes.length; ++i) {
                    this.processJClass(classes[i], sInfo);
                }
            }
            this.processAttributes(complexType, sInfo);
            ContentType temp = complexType.getContentType();
            if (temp.getType() == 4) {
                this.processSimpleType(((SimpleContent)temp).getSimpleType(), sInfo);
            }
            this.processContentModel(complexType, sInfo);
        } else {
            JClass jClass = classInfo.getJClass();
            if (!sInfo.processed(jClass)) {
                this.processAttributes(complexType, sInfo);
                this.processContentModel(complexType, sInfo);
                this.processJClass(jClass, sInfo);
            }
        }
    }

    private void processAttributes(ComplexType complexType, SGStateInfo sInfo) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            AttributeDecl attribute = (AttributeDecl)enumeration.nextElement();
            this.processSimpleType(attribute.getSimpleType(), sInfo);
        }
    }

    private void processContentModel(ContentModelGroup cmGroup, SGStateInfo sInfo) {
        if (cmGroup == null) {
            return;
        }
        Enumeration enumeration = cmGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure struct = (Structure)enumeration.nextElement();
            switch (struct.getStructureType()) {
                case 8: {
                    ElementDecl eDecl = (ElementDecl)struct;
                    if (eDecl.isReference()) break;
                    this.createClasses(eDecl, sInfo);
                    break;
                }
                case 10: {
                    this.processContentModel((Group)struct, sInfo);
                    if (cmGroup instanceof ComplexType || cmGroup instanceof ModelGroup) break;
                    this.createClasses((Group)struct, sInfo);
                    break;
                }
            }
        }
    }

    private void processSimpleType(SimpleType simpleType, SGStateInfo sInfo) {
        if (simpleType == null) {
            return;
        }
        if (simpleType.getSchema() != sInfo.getSchema()) {
            return;
        }
        if (simpleType.hasFacet("enumeration")) {
            ClassInfo classInfo = sInfo.resolve(simpleType);
            if (classInfo == null) {
                JClass jClass = this._sourceFactory.createSourceCode(simpleType, sInfo);
                this.processJClass(jClass, sInfo);
            } else {
                JClass jClass = classInfo.getJClass();
                this.processJClass(jClass, sInfo);
            }
        }
    }

    private void processNamespaces(PackageType[] packages) {
        if (packages.length == 0) {
            return;
        }
        for (int i = 0; i < packages.length; ++i) {
            PackageType temp = packages[i];
            PackageTypeChoice choice = temp.getPackageTypeChoice();
            if (choice.getNamespace() != null) {
                this.setNamespacePackageMapping(choice.getNamespace(), temp.getName());
                continue;
            }
            if (choice.getSchemaLocation() == null) continue;
            String tempLocation = choice.getSchemaLocation();
            String currentDir = System.getProperty("user.dir");
            currentDir = currentDir.replace('\\', '/');
            if (tempLocation.startsWith("./")) {
                tempLocation = tempLocation.substring(1);
                tempLocation = currentDir + tempLocation;
            } else if (tempLocation.startsWith("../")) {
                tempLocation = tempLocation.substring(3);
                int lastDir = currentDir.lastIndexOf(47);
                currentDir = currentDir.substring(0, lastDir + 1);
                tempLocation = currentDir + tempLocation;
            }
            this.setLocationPackageMapping(tempLocation, temp.getName());
            currentDir = null;
            tempLocation = null;
        }
    }

    private void processJClass(JClass jClass, SGStateInfo state) {
        String filename;
        File file;
        if (state.processed(jClass)) {
            return;
        }
        boolean allowPrinting = true;
        if (state.promptForOverwrite() && (file = new File(filename = jClass.getFilename(this._destDir))).exists()) {
            String message = filename + " already exists. overwrite";
            char ch = this._dialog.confirm(message, "yna", "y = yes, n = no, a = all");
            if (ch == 'a') {
                state.setPromptForOverwrite(false);
                allowPrinting = true;
            } else {
                allowPrinting = ch == 'y';
            }
        }
        if (allowPrinting) {
            jClass.removeImport("org.exolab.castor.types.Date");
            jClass.setHeader(this._header);
            jClass.print(this._destDir, this._lineSeparator);
        }
        ClassInfo classInfo = state.resolve(jClass);
        if (this._createDescriptors && classInfo != null) {
            String filename2;
            File file2;
            JClass desc = this._descSourceFactory.createSource(classInfo);
            allowPrinting = true;
            if (state.promptForOverwrite() && (file2 = new File(filename2 = desc.getFilename(this._destDir))).exists()) {
                String message = filename2 + " already exists. overwrite";
                char ch = this._dialog.confirm(message, "yna", "y = yes, n = no, a = all");
                if (ch == 'a') {
                    state.setPromptForOverwrite(false);
                    allowPrinting = true;
                } else {
                    allowPrinting = ch == 'y';
                }
            }
            if (allowPrinting) {
                desc.setHeader(this._header);
                desc.print(this._destDir, this._lineSeparator);
            }
        }
        state.markAsProcessed(jClass);
    }

    public static String toURIRepresentation(String path) {
        String result = path;
        if (!new File(result).isAbsolute()) {
            throw new IllegalArgumentException("The parameter must represent an absolute path.");
        }
        if (File.separatorChar != '/') {
            result = result.replace(File.separatorChar, '/');
        }
        result = result.startsWith("/") ? "file://" + result : "file:///" + result;
        return result;
    }
}

