// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/io.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the Google Drive resource.
type GoogleDriveSource_ResourceId_ResourceType int32

const (
	// Unspecified resource type.
	GoogleDriveSource_ResourceId_RESOURCE_TYPE_UNSPECIFIED GoogleDriveSource_ResourceId_ResourceType = 0
	// File resource type.
	GoogleDriveSource_ResourceId_RESOURCE_TYPE_FILE GoogleDriveSource_ResourceId_ResourceType = 1
	// Folder resource type.
	GoogleDriveSource_ResourceId_RESOURCE_TYPE_FOLDER GoogleDriveSource_ResourceId_ResourceType = 2
)

// Enum value maps for GoogleDriveSource_ResourceId_ResourceType.
var (
	GoogleDriveSource_ResourceId_ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "RESOURCE_TYPE_FILE",
		2: "RESOURCE_TYPE_FOLDER",
	}
	GoogleDriveSource_ResourceId_ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"RESOURCE_TYPE_FILE":        1,
		"RESOURCE_TYPE_FOLDER":      2,
	}
)

func (x GoogleDriveSource_ResourceId_ResourceType) Enum() *GoogleDriveSource_ResourceId_ResourceType {
	p := new(GoogleDriveSource_ResourceId_ResourceType)
	*p = x
	return p
}

func (x GoogleDriveSource_ResourceId_ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GoogleDriveSource_ResourceId_ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_io_proto_enumTypes[0].Descriptor()
}

func (GoogleDriveSource_ResourceId_ResourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_io_proto_enumTypes[0]
}

func (x GoogleDriveSource_ResourceId_ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GoogleDriveSource_ResourceId_ResourceType.Descriptor instead.
func (GoogleDriveSource_ResourceId_ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{9, 0, 0}
}

// The storage details for Avro input content.
type AvroSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage location.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
}

func (x *AvroSource) Reset() {
	*x = AvroSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvroSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroSource) ProtoMessage() {}

func (x *AvroSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroSource.ProtoReflect.Descriptor instead.
func (*AvroSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{0}
}

func (x *AvroSource) GetGcsSource() *GcsSource {
	if x != nil {
		return x.GcsSource
	}
	return nil
}

// The storage details for CSV input content.
type CsvSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage location.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
}

func (x *CsvSource) Reset() {
	*x = CsvSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CsvSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CsvSource) ProtoMessage() {}

func (x *CsvSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CsvSource.ProtoReflect.Descriptor instead.
func (*CsvSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{1}
}

func (x *CsvSource) GetGcsSource() *GcsSource {
	if x != nil {
		return x.GcsSource
	}
	return nil
}

// The Google Cloud Storage location for the input content.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage URI(-s) to the input file(s). May contain
	// wildcards. For more information on wildcards, see
	// https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{2}
}

func (x *GcsSource) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// The Google Cloud Storage location where the output is to be written to.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage URI to output directory. If the uri doesn't
	// end with
	// '/', a '/' will be automatically appended. The directory is created if it
	// doesn't exist.
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{3}
}

func (x *GcsDestination) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// The BigQuery location for the input content.
type BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BigQuery URI to a table, up to 2000 characters long.
	// Accepted forms:
	//
	// *  BigQuery path. For example: `bq://projectId.bqDatasetId.bqTableId`.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
}

func (x *BigQuerySource) Reset() {
	*x = BigQuerySource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQuerySource) ProtoMessage() {}

func (x *BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQuerySource.ProtoReflect.Descriptor instead.
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{4}
}

func (x *BigQuerySource) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

// The BigQuery location for the output content.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BigQuery URI to a project or table, up to 2000 characters long.
	//
	// When only the project is specified, the Dataset and Table is created.
	// When the full table reference is specified, the Dataset must exist and
	// table must not exist.
	//
	// Accepted forms:
	//
	// *  BigQuery path. For example:
	// `bq://projectId` or `bq://projectId.bqDatasetId` or
	// `bq://projectId.bqDatasetId.bqTableId`.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{5}
}

func (x *BigQueryDestination) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// The storage details for CSV output content.
type CsvDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage location.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
}

func (x *CsvDestination) Reset() {
	*x = CsvDestination{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CsvDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CsvDestination) ProtoMessage() {}

func (x *CsvDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CsvDestination.ProtoReflect.Descriptor instead.
func (*CsvDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{6}
}

func (x *CsvDestination) GetGcsDestination() *GcsDestination {
	if x != nil {
		return x.GcsDestination
	}
	return nil
}

// The storage details for TFRecord output content.
type TFRecordDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage location.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
}

func (x *TFRecordDestination) Reset() {
	*x = TFRecordDestination{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TFRecordDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TFRecordDestination) ProtoMessage() {}

func (x *TFRecordDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TFRecordDestination.ProtoReflect.Descriptor instead.
func (*TFRecordDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{7}
}

func (x *TFRecordDestination) GetGcsDestination() *GcsDestination {
	if x != nil {
		return x.GcsDestination
	}
	return nil
}

// The Container Registry location for the container image.
type ContainerRegistryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Container Registry URI of a container image.
	// Only Google Container Registry and Artifact Registry are supported now.
	// Accepted forms:
	//
	//   - Google Container Registry path. For example:
	//     `gcr.io/projectId/imageName:tag`.
	//
	//   - Artifact Registry path. For example:
	//     `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`.
	//
	// If a tag is not specified, "latest" will be used as the default tag.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
}

func (x *ContainerRegistryDestination) Reset() {
	*x = ContainerRegistryDestination{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerRegistryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerRegistryDestination) ProtoMessage() {}

func (x *ContainerRegistryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerRegistryDestination.ProtoReflect.Descriptor instead.
func (*ContainerRegistryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{8}
}

func (x *ContainerRegistryDestination) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

// The Google Drive location for the input content.
type GoogleDriveSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Drive resource IDs.
	ResourceIds []*GoogleDriveSource_ResourceId `protobuf:"bytes,1,rep,name=resource_ids,json=resourceIds,proto3" json:"resource_ids,omitempty"`
}

func (x *GoogleDriveSource) Reset() {
	*x = GoogleDriveSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleDriveSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleDriveSource) ProtoMessage() {}

func (x *GoogleDriveSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleDriveSource.ProtoReflect.Descriptor instead.
func (*GoogleDriveSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{9}
}

func (x *GoogleDriveSource) GetResourceIds() []*GoogleDriveSource_ResourceId {
	if x != nil {
		return x.ResourceIds
	}
	return nil
}

// The input content is encapsulated and uploaded in the request.
type DirectUploadSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DirectUploadSource) Reset() {
	*x = DirectUploadSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectUploadSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectUploadSource) ProtoMessage() {}

func (x *DirectUploadSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectUploadSource.ProtoReflect.Descriptor instead.
func (*DirectUploadSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{10}
}

// The Slack source for the ImportRagFilesRequest.
type SlackSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Slack channels.
	Channels []*SlackSource_SlackChannels `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *SlackSource) Reset() {
	*x = SlackSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlackSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlackSource) ProtoMessage() {}

func (x *SlackSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlackSource.ProtoReflect.Descriptor instead.
func (*SlackSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{11}
}

func (x *SlackSource) GetChannels() []*SlackSource_SlackChannels {
	if x != nil {
		return x.Channels
	}
	return nil
}

// The Jira source for the ImportRagFilesRequest.
type JiraSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Jira queries.
	JiraQueries []*JiraSource_JiraQueries `protobuf:"bytes,1,rep,name=jira_queries,json=jiraQueries,proto3" json:"jira_queries,omitempty"`
}

func (x *JiraSource) Reset() {
	*x = JiraSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JiraSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JiraSource) ProtoMessage() {}

func (x *JiraSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JiraSource.ProtoReflect.Descriptor instead.
func (*JiraSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{12}
}

func (x *JiraSource) GetJiraQueries() []*JiraSource_JiraQueries {
	if x != nil {
		return x.JiraQueries
	}
	return nil
}

// The SharePointSources to pass to ImportRagFiles.
type SharePointSources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SharePoint sources.
	SharePointSources []*SharePointSources_SharePointSource `protobuf:"bytes,1,rep,name=share_point_sources,json=sharePointSources,proto3" json:"share_point_sources,omitempty"`
}

func (x *SharePointSources) Reset() {
	*x = SharePointSources{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SharePointSources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharePointSources) ProtoMessage() {}

func (x *SharePointSources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharePointSources.ProtoReflect.Descriptor instead.
func (*SharePointSources) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{13}
}

func (x *SharePointSources) GetSharePointSources() []*SharePointSources_SharePointSource {
	if x != nil {
		return x.SharePointSources
	}
	return nil
}

// The type and ID of the Google Drive resource.
type GoogleDriveSource_ResourceId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the Google Drive resource.
	ResourceType GoogleDriveSource_ResourceId_ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.aiplatform.v1beta1.GoogleDriveSource_ResourceId_ResourceType" json:"resource_type,omitempty"`
	// Required. The ID of the Google Drive resource.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
}

func (x *GoogleDriveSource_ResourceId) Reset() {
	*x = GoogleDriveSource_ResourceId{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoogleDriveSource_ResourceId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleDriveSource_ResourceId) ProtoMessage() {}

func (x *GoogleDriveSource_ResourceId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleDriveSource_ResourceId.ProtoReflect.Descriptor instead.
func (*GoogleDriveSource_ResourceId) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{9, 0}
}

func (x *GoogleDriveSource_ResourceId) GetResourceType() GoogleDriveSource_ResourceId_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return GoogleDriveSource_ResourceId_RESOURCE_TYPE_UNSPECIFIED
}

func (x *GoogleDriveSource_ResourceId) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

// SlackChannels contains the Slack channels and corresponding access token.
type SlackSource_SlackChannels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Slack channel IDs.
	Channels []*SlackSource_SlackChannels_SlackChannel `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty"`
	// Required. The SecretManager secret version resource name (e.g.
	// projects/{project}/secrets/{secret}/versions/{version}) storing the
	// Slack channel access token that has access to the slack channel IDs.
	// See: https://api.slack.com/tutorials/tracks/getting-a-token.
	ApiKeyConfig *ApiAuth_ApiKeyConfig `protobuf:"bytes,3,opt,name=api_key_config,json=apiKeyConfig,proto3" json:"api_key_config,omitempty"`
}

func (x *SlackSource_SlackChannels) Reset() {
	*x = SlackSource_SlackChannels{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlackSource_SlackChannels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlackSource_SlackChannels) ProtoMessage() {}

func (x *SlackSource_SlackChannels) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlackSource_SlackChannels.ProtoReflect.Descriptor instead.
func (*SlackSource_SlackChannels) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{11, 0}
}

func (x *SlackSource_SlackChannels) GetChannels() []*SlackSource_SlackChannels_SlackChannel {
	if x != nil {
		return x.Channels
	}
	return nil
}

func (x *SlackSource_SlackChannels) GetApiKeyConfig() *ApiAuth_ApiKeyConfig {
	if x != nil {
		return x.ApiKeyConfig
	}
	return nil
}

// SlackChannel contains the Slack channel ID and the time range to import.
type SlackSource_SlackChannels_SlackChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Slack channel ID.
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Optional. The starting timestamp for messages to import.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The ending timestamp for messages to import.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *SlackSource_SlackChannels_SlackChannel) Reset() {
	*x = SlackSource_SlackChannels_SlackChannel{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlackSource_SlackChannels_SlackChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlackSource_SlackChannels_SlackChannel) ProtoMessage() {}

func (x *SlackSource_SlackChannels_SlackChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlackSource_SlackChannels_SlackChannel.ProtoReflect.Descriptor instead.
func (*SlackSource_SlackChannels_SlackChannel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{11, 0, 0}
}

func (x *SlackSource_SlackChannels_SlackChannel) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *SlackSource_SlackChannels_SlackChannel) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *SlackSource_SlackChannels_SlackChannel) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// JiraQueries contains the Jira queries and corresponding authentication.
type JiraSource_JiraQueries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Jira projects to import in their entirety.
	Projects []string `protobuf:"bytes,3,rep,name=projects,proto3" json:"projects,omitempty"`
	// A list of custom Jira queries to import. For information about JQL (Jira
	// Query Language), see
	// https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
	CustomQueries []string `protobuf:"bytes,4,rep,name=custom_queries,json=customQueries,proto3" json:"custom_queries,omitempty"`
	// Required. The Jira email address.
	Email string `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// Required. The Jira server URI.
	ServerUri string `protobuf:"bytes,6,opt,name=server_uri,json=serverUri,proto3" json:"server_uri,omitempty"`
	// Required. The SecretManager secret version resource name (e.g.
	// projects/{project}/secrets/{secret}/versions/{version}) storing the
	// Jira API key. See [Manage API tokens for your Atlassian
	// account](https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
	ApiKeyConfig *ApiAuth_ApiKeyConfig `protobuf:"bytes,7,opt,name=api_key_config,json=apiKeyConfig,proto3" json:"api_key_config,omitempty"`
}

func (x *JiraSource_JiraQueries) Reset() {
	*x = JiraSource_JiraQueries{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JiraSource_JiraQueries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JiraSource_JiraQueries) ProtoMessage() {}

func (x *JiraSource_JiraQueries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JiraSource_JiraQueries.ProtoReflect.Descriptor instead.
func (*JiraSource_JiraQueries) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{12, 0}
}

func (x *JiraSource_JiraQueries) GetProjects() []string {
	if x != nil {
		return x.Projects
	}
	return nil
}

func (x *JiraSource_JiraQueries) GetCustomQueries() []string {
	if x != nil {
		return x.CustomQueries
	}
	return nil
}

func (x *JiraSource_JiraQueries) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *JiraSource_JiraQueries) GetServerUri() string {
	if x != nil {
		return x.ServerUri
	}
	return ""
}

func (x *JiraSource_JiraQueries) GetApiKeyConfig() *ApiAuth_ApiKeyConfig {
	if x != nil {
		return x.ApiKeyConfig
	}
	return nil
}

// An individual SharePointSource.
type SharePointSources_SharePointSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SharePoint folder source. If not provided, uses "root".
	//
	// Types that are assignable to FolderSource:
	//
	//	*SharePointSources_SharePointSource_SharepointFolderPath
	//	*SharePointSources_SharePointSource_SharepointFolderId
	FolderSource isSharePointSources_SharePointSource_FolderSource `protobuf_oneof:"folder_source"`
	// The SharePoint drive source.
	//
	// Types that are assignable to DriveSource:
	//
	//	*SharePointSources_SharePointSource_DriveName
	//	*SharePointSources_SharePointSource_DriveId
	DriveSource isSharePointSources_SharePointSource_DriveSource `protobuf_oneof:"drive_source"`
	// The Application ID for the app registered in Microsoft Azure Portal.
	// The application must also be configured with MS Graph permissions
	// "Files.ReadAll", "Sites.ReadAll" and BrowserSiteLists.Read.All.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// The application secret for the app registered in Azure.
	ClientSecret *ApiAuth_ApiKeyConfig `protobuf:"bytes,2,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// Unique identifier of the Azure Active Directory Instance.
	TenantId string `protobuf:"bytes,3,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// The name of the SharePoint site to download from. This can be the site
	// name or the site id.
	SharepointSiteName string `protobuf:"bytes,4,opt,name=sharepoint_site_name,json=sharepointSiteName,proto3" json:"sharepoint_site_name,omitempty"`
	// Output only. The SharePoint file id. Output only.
	FileId string `protobuf:"bytes,9,opt,name=file_id,json=fileId,proto3" json:"file_id,omitempty"`
}

func (x *SharePointSources_SharePointSource) Reset() {
	*x = SharePointSources_SharePointSource{}
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SharePointSources_SharePointSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SharePointSources_SharePointSource) ProtoMessage() {}

func (x *SharePointSources_SharePointSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SharePointSources_SharePointSource.ProtoReflect.Descriptor instead.
func (*SharePointSources_SharePointSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP(), []int{13, 0}
}

func (m *SharePointSources_SharePointSource) GetFolderSource() isSharePointSources_SharePointSource_FolderSource {
	if m != nil {
		return m.FolderSource
	}
	return nil
}

func (x *SharePointSources_SharePointSource) GetSharepointFolderPath() string {
	if x, ok := x.GetFolderSource().(*SharePointSources_SharePointSource_SharepointFolderPath); ok {
		return x.SharepointFolderPath
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetSharepointFolderId() string {
	if x, ok := x.GetFolderSource().(*SharePointSources_SharePointSource_SharepointFolderId); ok {
		return x.SharepointFolderId
	}
	return ""
}

func (m *SharePointSources_SharePointSource) GetDriveSource() isSharePointSources_SharePointSource_DriveSource {
	if m != nil {
		return m.DriveSource
	}
	return nil
}

func (x *SharePointSources_SharePointSource) GetDriveName() string {
	if x, ok := x.GetDriveSource().(*SharePointSources_SharePointSource_DriveName); ok {
		return x.DriveName
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetDriveId() string {
	if x, ok := x.GetDriveSource().(*SharePointSources_SharePointSource_DriveId); ok {
		return x.DriveId
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetClientSecret() *ApiAuth_ApiKeyConfig {
	if x != nil {
		return x.ClientSecret
	}
	return nil
}

func (x *SharePointSources_SharePointSource) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetSharepointSiteName() string {
	if x != nil {
		return x.SharepointSiteName
	}
	return ""
}

func (x *SharePointSources_SharePointSource) GetFileId() string {
	if x != nil {
		return x.FileId
	}
	return ""
}

type isSharePointSources_SharePointSource_FolderSource interface {
	isSharePointSources_SharePointSource_FolderSource()
}

type SharePointSources_SharePointSource_SharepointFolderPath struct {
	// The path of the SharePoint folder to download from.
	SharepointFolderPath string `protobuf:"bytes,5,opt,name=sharepoint_folder_path,json=sharepointFolderPath,proto3,oneof"`
}

type SharePointSources_SharePointSource_SharepointFolderId struct {
	// The ID of the SharePoint folder to download from.
	SharepointFolderId string `protobuf:"bytes,6,opt,name=sharepoint_folder_id,json=sharepointFolderId,proto3,oneof"`
}

func (*SharePointSources_SharePointSource_SharepointFolderPath) isSharePointSources_SharePointSource_FolderSource() {
}

func (*SharePointSources_SharePointSource_SharepointFolderId) isSharePointSources_SharePointSource_FolderSource() {
}

type isSharePointSources_SharePointSource_DriveSource interface {
	isSharePointSources_SharePointSource_DriveSource()
}

type SharePointSources_SharePointSource_DriveName struct {
	// The name of the drive to download from.
	DriveName string `protobuf:"bytes,7,opt,name=drive_name,json=driveName,proto3,oneof"`
}

type SharePointSources_SharePointSource_DriveId struct {
	// The ID of the drive to download from.
	DriveId string `protobuf:"bytes,8,opt,name=drive_id,json=driveId,proto3,oneof"`
}

func (*SharePointSources_SharePointSource_DriveName) isSharePointSources_SharePointSource_DriveSource() {
}

func (*SharePointSources_SharePointSource_DriveId) isSharePointSources_SharePointSource_DriveSource() {
}

var File_google_cloud_aiplatform_v1beta1_io_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_io_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x70,
	0x69, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5c, 0x0a,
	0x0a, 0x41, 0x76, 0x72, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x67,
	0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x09, 0x43,
	0x73, 0x76, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x67,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x24, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x22, 0x41,
	0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2f, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x22, 0x32, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x55, 0x72, 0x69, 0x22, 0x39, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69,
	0x22, 0x6f, 0x0a, 0x0e, 0x43, 0x73, 0x76, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x74, 0x0a, 0x13, 0x54, 0x46, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x0a, 0x1c, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x22, 0x86, 0x03, 0x0a, 0x11,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x65, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x73, 0x1a, 0x89, 0x02, 0x0a, 0x0a, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x74, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x22, 0x5f, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x4f, 0x4c, 0x44,
	0x45, 0x52, 0x10, 0x02, 0x22, 0x14, 0x0a, 0x12, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xf9, 0x03, 0x0a, 0x0b, 0x53,
	0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5b, 0x0a, 0x08, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x61, 0x63, 0x6b,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x1a, 0x8c, 0x03, 0x0a, 0x0d, 0x53, 0x6c, 0x61, 0x63,
	0x6b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x68, 0x0a, 0x08, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6c,
	0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x61, 0x63, 0x6b, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2e, 0x53, 0x6c, 0x61, 0x63, 0x6b, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x0e, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x70,
	0x69, 0x41, 0x75, 0x74, 0x68, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xae, 0x01, 0x0a, 0x0c, 0x53, 0x6c, 0x61, 0x63, 0x6b, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xe1, 0x02, 0x0a, 0x0a, 0x4a, 0x69, 0x72, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x0c, 0x6a, 0x69, 0x72, 0x61, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x69,
	0x72, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4a, 0x69, 0x72, 0x61, 0x51, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6a, 0x69, 0x72, 0x61, 0x51,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xf1, 0x01, 0x0a, 0x0b, 0x4a, 0x69, 0x72, 0x61, 0x51,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x60, 0x0a, 0x0e, 0x61, 0x70, 0x69, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x41, 0x75, 0x74, 0x68, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x70,
	0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xce, 0x04, 0x0a, 0x11, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x73, 0x0a, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x11, 0x73, 0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xc3, 0x03, 0x0a, 0x10, 0x53, 0x68, 0x61, 0x72, 0x65, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x16, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x14, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x32, 0x0a, 0x14, 0x73, 0x68, 0x61, 0x72, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x12, 0x73, 0x68, 0x61, 0x72, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0a, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x08, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x12, 0x5a, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x69, 0x41, 0x75,
	0x74, 0x68, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x68, 0x61, 0x72, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x53, 0x69, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0xde, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x07, 0x49, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_io_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_io_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_io_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_io_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_io_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_io_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_io_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_io_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_io_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_aiplatform_v1beta1_io_proto_goTypes = []any{
	(GoogleDriveSource_ResourceId_ResourceType)(0), // 0: google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
	(*AvroSource)(nil),                             // 1: google.cloud.aiplatform.v1beta1.AvroSource
	(*CsvSource)(nil),                              // 2: google.cloud.aiplatform.v1beta1.CsvSource
	(*GcsSource)(nil),                              // 3: google.cloud.aiplatform.v1beta1.GcsSource
	(*GcsDestination)(nil),                         // 4: google.cloud.aiplatform.v1beta1.GcsDestination
	(*BigQuerySource)(nil),                         // 5: google.cloud.aiplatform.v1beta1.BigQuerySource
	(*BigQueryDestination)(nil),                    // 6: google.cloud.aiplatform.v1beta1.BigQueryDestination
	(*CsvDestination)(nil),                         // 7: google.cloud.aiplatform.v1beta1.CsvDestination
	(*TFRecordDestination)(nil),                    // 8: google.cloud.aiplatform.v1beta1.TFRecordDestination
	(*ContainerRegistryDestination)(nil),           // 9: google.cloud.aiplatform.v1beta1.ContainerRegistryDestination
	(*GoogleDriveSource)(nil),                      // 10: google.cloud.aiplatform.v1beta1.GoogleDriveSource
	(*DirectUploadSource)(nil),                     // 11: google.cloud.aiplatform.v1beta1.DirectUploadSource
	(*SlackSource)(nil),                            // 12: google.cloud.aiplatform.v1beta1.SlackSource
	(*JiraSource)(nil),                             // 13: google.cloud.aiplatform.v1beta1.JiraSource
	(*SharePointSources)(nil),                      // 14: google.cloud.aiplatform.v1beta1.SharePointSources
	(*GoogleDriveSource_ResourceId)(nil),           // 15: google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
	(*SlackSource_SlackChannels)(nil),              // 16: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels
	(*SlackSource_SlackChannels_SlackChannel)(nil), // 17: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.SlackChannel
	(*JiraSource_JiraQueries)(nil),                 // 18: google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries
	(*SharePointSources_SharePointSource)(nil),     // 19: google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
	(*ApiAuth_ApiKeyConfig)(nil),                   // 20: google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
	(*timestamppb.Timestamp)(nil),                  // 21: google.protobuf.Timestamp
}
var file_google_cloud_aiplatform_v1beta1_io_proto_depIdxs = []int32{
	3,  // 0: google.cloud.aiplatform.v1beta1.AvroSource.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	3,  // 1: google.cloud.aiplatform.v1beta1.CsvSource.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	4,  // 2: google.cloud.aiplatform.v1beta1.CsvDestination.gcs_destination:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	4,  // 3: google.cloud.aiplatform.v1beta1.TFRecordDestination.gcs_destination:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	15, // 4: google.cloud.aiplatform.v1beta1.GoogleDriveSource.resource_ids:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId
	16, // 5: google.cloud.aiplatform.v1beta1.SlackSource.channels:type_name -> google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels
	18, // 6: google.cloud.aiplatform.v1beta1.JiraSource.jira_queries:type_name -> google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries
	19, // 7: google.cloud.aiplatform.v1beta1.SharePointSources.share_point_sources:type_name -> google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource
	0,  // 8: google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.resource_type:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource.ResourceId.ResourceType
	17, // 9: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.channels:type_name -> google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.SlackChannel
	20, // 10: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.api_key_config:type_name -> google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
	21, // 11: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.SlackChannel.start_time:type_name -> google.protobuf.Timestamp
	21, // 12: google.cloud.aiplatform.v1beta1.SlackSource.SlackChannels.SlackChannel.end_time:type_name -> google.protobuf.Timestamp
	20, // 13: google.cloud.aiplatform.v1beta1.JiraSource.JiraQueries.api_key_config:type_name -> google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
	20, // 14: google.cloud.aiplatform.v1beta1.SharePointSources.SharePointSource.client_secret:type_name -> google.cloud.aiplatform.v1beta1.ApiAuth.ApiKeyConfig
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_io_proto_init() }
func file_google_cloud_aiplatform_v1beta1_io_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_io_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_api_auth_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes[18].OneofWrappers = []any{
		(*SharePointSources_SharePointSource_SharepointFolderPath)(nil),
		(*SharePointSources_SharePointSource_SharepointFolderId)(nil),
		(*SharePointSources_SharePointSource_DriveName)(nil),
		(*SharePointSources_SharePointSource_DriveId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_io_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_io_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_io_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_io_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_io_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_io_proto = out.File
	file_google_cloud_aiplatform_v1beta1_io_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_io_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_io_proto_depIdxs = nil
}
