// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package bedrockiface provides an interface to enable mocking the Amazon Bedrock service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package bedrockiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/bedrock"
)

// BedrockAPI provides an interface to enable mocking the
// bedrock.Bedrock service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Bedrock.
//	func myFunc(svc bedrockiface.BedrockAPI) bool {
//	    // Make svc.CreateEvaluationJob request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := bedrock.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBedrockClient struct {
//	    bedrockiface.BedrockAPI
//	}
//	func (m *mockBedrockClient) CreateEvaluationJob(input *bedrock.CreateEvaluationJobInput) (*bedrock.CreateEvaluationJobOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBedrockClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BedrockAPI interface {
	CreateEvaluationJob(*bedrock.CreateEvaluationJobInput) (*bedrock.CreateEvaluationJobOutput, error)
	CreateEvaluationJobWithContext(aws.Context, *bedrock.CreateEvaluationJobInput, ...request.Option) (*bedrock.CreateEvaluationJobOutput, error)
	CreateEvaluationJobRequest(*bedrock.CreateEvaluationJobInput) (*request.Request, *bedrock.CreateEvaluationJobOutput)

	CreateGuardrail(*bedrock.CreateGuardrailInput) (*bedrock.CreateGuardrailOutput, error)
	CreateGuardrailWithContext(aws.Context, *bedrock.CreateGuardrailInput, ...request.Option) (*bedrock.CreateGuardrailOutput, error)
	CreateGuardrailRequest(*bedrock.CreateGuardrailInput) (*request.Request, *bedrock.CreateGuardrailOutput)

	CreateGuardrailVersion(*bedrock.CreateGuardrailVersionInput) (*bedrock.CreateGuardrailVersionOutput, error)
	CreateGuardrailVersionWithContext(aws.Context, *bedrock.CreateGuardrailVersionInput, ...request.Option) (*bedrock.CreateGuardrailVersionOutput, error)
	CreateGuardrailVersionRequest(*bedrock.CreateGuardrailVersionInput) (*request.Request, *bedrock.CreateGuardrailVersionOutput)

	CreateModelCustomizationJob(*bedrock.CreateModelCustomizationJobInput) (*bedrock.CreateModelCustomizationJobOutput, error)
	CreateModelCustomizationJobWithContext(aws.Context, *bedrock.CreateModelCustomizationJobInput, ...request.Option) (*bedrock.CreateModelCustomizationJobOutput, error)
	CreateModelCustomizationJobRequest(*bedrock.CreateModelCustomizationJobInput) (*request.Request, *bedrock.CreateModelCustomizationJobOutput)

	CreateProvisionedModelThroughput(*bedrock.CreateProvisionedModelThroughputInput) (*bedrock.CreateProvisionedModelThroughputOutput, error)
	CreateProvisionedModelThroughputWithContext(aws.Context, *bedrock.CreateProvisionedModelThroughputInput, ...request.Option) (*bedrock.CreateProvisionedModelThroughputOutput, error)
	CreateProvisionedModelThroughputRequest(*bedrock.CreateProvisionedModelThroughputInput) (*request.Request, *bedrock.CreateProvisionedModelThroughputOutput)

	DeleteCustomModel(*bedrock.DeleteCustomModelInput) (*bedrock.DeleteCustomModelOutput, error)
	DeleteCustomModelWithContext(aws.Context, *bedrock.DeleteCustomModelInput, ...request.Option) (*bedrock.DeleteCustomModelOutput, error)
	DeleteCustomModelRequest(*bedrock.DeleteCustomModelInput) (*request.Request, *bedrock.DeleteCustomModelOutput)

	DeleteGuardrail(*bedrock.DeleteGuardrailInput) (*bedrock.DeleteGuardrailOutput, error)
	DeleteGuardrailWithContext(aws.Context, *bedrock.DeleteGuardrailInput, ...request.Option) (*bedrock.DeleteGuardrailOutput, error)
	DeleteGuardrailRequest(*bedrock.DeleteGuardrailInput) (*request.Request, *bedrock.DeleteGuardrailOutput)

	DeleteModelInvocationLoggingConfiguration(*bedrock.DeleteModelInvocationLoggingConfigurationInput) (*bedrock.DeleteModelInvocationLoggingConfigurationOutput, error)
	DeleteModelInvocationLoggingConfigurationWithContext(aws.Context, *bedrock.DeleteModelInvocationLoggingConfigurationInput, ...request.Option) (*bedrock.DeleteModelInvocationLoggingConfigurationOutput, error)
	DeleteModelInvocationLoggingConfigurationRequest(*bedrock.DeleteModelInvocationLoggingConfigurationInput) (*request.Request, *bedrock.DeleteModelInvocationLoggingConfigurationOutput)

	DeleteProvisionedModelThroughput(*bedrock.DeleteProvisionedModelThroughputInput) (*bedrock.DeleteProvisionedModelThroughputOutput, error)
	DeleteProvisionedModelThroughputWithContext(aws.Context, *bedrock.DeleteProvisionedModelThroughputInput, ...request.Option) (*bedrock.DeleteProvisionedModelThroughputOutput, error)
	DeleteProvisionedModelThroughputRequest(*bedrock.DeleteProvisionedModelThroughputInput) (*request.Request, *bedrock.DeleteProvisionedModelThroughputOutput)

	GetCustomModel(*bedrock.GetCustomModelInput) (*bedrock.GetCustomModelOutput, error)
	GetCustomModelWithContext(aws.Context, *bedrock.GetCustomModelInput, ...request.Option) (*bedrock.GetCustomModelOutput, error)
	GetCustomModelRequest(*bedrock.GetCustomModelInput) (*request.Request, *bedrock.GetCustomModelOutput)

	GetEvaluationJob(*bedrock.GetEvaluationJobInput) (*bedrock.GetEvaluationJobOutput, error)
	GetEvaluationJobWithContext(aws.Context, *bedrock.GetEvaluationJobInput, ...request.Option) (*bedrock.GetEvaluationJobOutput, error)
	GetEvaluationJobRequest(*bedrock.GetEvaluationJobInput) (*request.Request, *bedrock.GetEvaluationJobOutput)

	GetFoundationModel(*bedrock.GetFoundationModelInput) (*bedrock.GetFoundationModelOutput, error)
	GetFoundationModelWithContext(aws.Context, *bedrock.GetFoundationModelInput, ...request.Option) (*bedrock.GetFoundationModelOutput, error)
	GetFoundationModelRequest(*bedrock.GetFoundationModelInput) (*request.Request, *bedrock.GetFoundationModelOutput)

	GetGuardrail(*bedrock.GetGuardrailInput) (*bedrock.GetGuardrailOutput, error)
	GetGuardrailWithContext(aws.Context, *bedrock.GetGuardrailInput, ...request.Option) (*bedrock.GetGuardrailOutput, error)
	GetGuardrailRequest(*bedrock.GetGuardrailInput) (*request.Request, *bedrock.GetGuardrailOutput)

	GetModelCustomizationJob(*bedrock.GetModelCustomizationJobInput) (*bedrock.GetModelCustomizationJobOutput, error)
	GetModelCustomizationJobWithContext(aws.Context, *bedrock.GetModelCustomizationJobInput, ...request.Option) (*bedrock.GetModelCustomizationJobOutput, error)
	GetModelCustomizationJobRequest(*bedrock.GetModelCustomizationJobInput) (*request.Request, *bedrock.GetModelCustomizationJobOutput)

	GetModelInvocationLoggingConfiguration(*bedrock.GetModelInvocationLoggingConfigurationInput) (*bedrock.GetModelInvocationLoggingConfigurationOutput, error)
	GetModelInvocationLoggingConfigurationWithContext(aws.Context, *bedrock.GetModelInvocationLoggingConfigurationInput, ...request.Option) (*bedrock.GetModelInvocationLoggingConfigurationOutput, error)
	GetModelInvocationLoggingConfigurationRequest(*bedrock.GetModelInvocationLoggingConfigurationInput) (*request.Request, *bedrock.GetModelInvocationLoggingConfigurationOutput)

	GetProvisionedModelThroughput(*bedrock.GetProvisionedModelThroughputInput) (*bedrock.GetProvisionedModelThroughputOutput, error)
	GetProvisionedModelThroughputWithContext(aws.Context, *bedrock.GetProvisionedModelThroughputInput, ...request.Option) (*bedrock.GetProvisionedModelThroughputOutput, error)
	GetProvisionedModelThroughputRequest(*bedrock.GetProvisionedModelThroughputInput) (*request.Request, *bedrock.GetProvisionedModelThroughputOutput)

	ListCustomModels(*bedrock.ListCustomModelsInput) (*bedrock.ListCustomModelsOutput, error)
	ListCustomModelsWithContext(aws.Context, *bedrock.ListCustomModelsInput, ...request.Option) (*bedrock.ListCustomModelsOutput, error)
	ListCustomModelsRequest(*bedrock.ListCustomModelsInput) (*request.Request, *bedrock.ListCustomModelsOutput)

	ListCustomModelsPages(*bedrock.ListCustomModelsInput, func(*bedrock.ListCustomModelsOutput, bool) bool) error
	ListCustomModelsPagesWithContext(aws.Context, *bedrock.ListCustomModelsInput, func(*bedrock.ListCustomModelsOutput, bool) bool, ...request.Option) error

	ListEvaluationJobs(*bedrock.ListEvaluationJobsInput) (*bedrock.ListEvaluationJobsOutput, error)
	ListEvaluationJobsWithContext(aws.Context, *bedrock.ListEvaluationJobsInput, ...request.Option) (*bedrock.ListEvaluationJobsOutput, error)
	ListEvaluationJobsRequest(*bedrock.ListEvaluationJobsInput) (*request.Request, *bedrock.ListEvaluationJobsOutput)

	ListEvaluationJobsPages(*bedrock.ListEvaluationJobsInput, func(*bedrock.ListEvaluationJobsOutput, bool) bool) error
	ListEvaluationJobsPagesWithContext(aws.Context, *bedrock.ListEvaluationJobsInput, func(*bedrock.ListEvaluationJobsOutput, bool) bool, ...request.Option) error

	ListFoundationModels(*bedrock.ListFoundationModelsInput) (*bedrock.ListFoundationModelsOutput, error)
	ListFoundationModelsWithContext(aws.Context, *bedrock.ListFoundationModelsInput, ...request.Option) (*bedrock.ListFoundationModelsOutput, error)
	ListFoundationModelsRequest(*bedrock.ListFoundationModelsInput) (*request.Request, *bedrock.ListFoundationModelsOutput)

	ListGuardrails(*bedrock.ListGuardrailsInput) (*bedrock.ListGuardrailsOutput, error)
	ListGuardrailsWithContext(aws.Context, *bedrock.ListGuardrailsInput, ...request.Option) (*bedrock.ListGuardrailsOutput, error)
	ListGuardrailsRequest(*bedrock.ListGuardrailsInput) (*request.Request, *bedrock.ListGuardrailsOutput)

	ListGuardrailsPages(*bedrock.ListGuardrailsInput, func(*bedrock.ListGuardrailsOutput, bool) bool) error
	ListGuardrailsPagesWithContext(aws.Context, *bedrock.ListGuardrailsInput, func(*bedrock.ListGuardrailsOutput, bool) bool, ...request.Option) error

	ListModelCustomizationJobs(*bedrock.ListModelCustomizationJobsInput) (*bedrock.ListModelCustomizationJobsOutput, error)
	ListModelCustomizationJobsWithContext(aws.Context, *bedrock.ListModelCustomizationJobsInput, ...request.Option) (*bedrock.ListModelCustomizationJobsOutput, error)
	ListModelCustomizationJobsRequest(*bedrock.ListModelCustomizationJobsInput) (*request.Request, *bedrock.ListModelCustomizationJobsOutput)

	ListModelCustomizationJobsPages(*bedrock.ListModelCustomizationJobsInput, func(*bedrock.ListModelCustomizationJobsOutput, bool) bool) error
	ListModelCustomizationJobsPagesWithContext(aws.Context, *bedrock.ListModelCustomizationJobsInput, func(*bedrock.ListModelCustomizationJobsOutput, bool) bool, ...request.Option) error

	ListProvisionedModelThroughputs(*bedrock.ListProvisionedModelThroughputsInput) (*bedrock.ListProvisionedModelThroughputsOutput, error)
	ListProvisionedModelThroughputsWithContext(aws.Context, *bedrock.ListProvisionedModelThroughputsInput, ...request.Option) (*bedrock.ListProvisionedModelThroughputsOutput, error)
	ListProvisionedModelThroughputsRequest(*bedrock.ListProvisionedModelThroughputsInput) (*request.Request, *bedrock.ListProvisionedModelThroughputsOutput)

	ListProvisionedModelThroughputsPages(*bedrock.ListProvisionedModelThroughputsInput, func(*bedrock.ListProvisionedModelThroughputsOutput, bool) bool) error
	ListProvisionedModelThroughputsPagesWithContext(aws.Context, *bedrock.ListProvisionedModelThroughputsInput, func(*bedrock.ListProvisionedModelThroughputsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*bedrock.ListTagsForResourceInput) (*bedrock.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *bedrock.ListTagsForResourceInput, ...request.Option) (*bedrock.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*bedrock.ListTagsForResourceInput) (*request.Request, *bedrock.ListTagsForResourceOutput)

	PutModelInvocationLoggingConfiguration(*bedrock.PutModelInvocationLoggingConfigurationInput) (*bedrock.PutModelInvocationLoggingConfigurationOutput, error)
	PutModelInvocationLoggingConfigurationWithContext(aws.Context, *bedrock.PutModelInvocationLoggingConfigurationInput, ...request.Option) (*bedrock.PutModelInvocationLoggingConfigurationOutput, error)
	PutModelInvocationLoggingConfigurationRequest(*bedrock.PutModelInvocationLoggingConfigurationInput) (*request.Request, *bedrock.PutModelInvocationLoggingConfigurationOutput)

	StopEvaluationJob(*bedrock.StopEvaluationJobInput) (*bedrock.StopEvaluationJobOutput, error)
	StopEvaluationJobWithContext(aws.Context, *bedrock.StopEvaluationJobInput, ...request.Option) (*bedrock.StopEvaluationJobOutput, error)
	StopEvaluationJobRequest(*bedrock.StopEvaluationJobInput) (*request.Request, *bedrock.StopEvaluationJobOutput)

	StopModelCustomizationJob(*bedrock.StopModelCustomizationJobInput) (*bedrock.StopModelCustomizationJobOutput, error)
	StopModelCustomizationJobWithContext(aws.Context, *bedrock.StopModelCustomizationJobInput, ...request.Option) (*bedrock.StopModelCustomizationJobOutput, error)
	StopModelCustomizationJobRequest(*bedrock.StopModelCustomizationJobInput) (*request.Request, *bedrock.StopModelCustomizationJobOutput)

	TagResource(*bedrock.TagResourceInput) (*bedrock.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *bedrock.TagResourceInput, ...request.Option) (*bedrock.TagResourceOutput, error)
	TagResourceRequest(*bedrock.TagResourceInput) (*request.Request, *bedrock.TagResourceOutput)

	UntagResource(*bedrock.UntagResourceInput) (*bedrock.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *bedrock.UntagResourceInput, ...request.Option) (*bedrock.UntagResourceOutput, error)
	UntagResourceRequest(*bedrock.UntagResourceInput) (*request.Request, *bedrock.UntagResourceOutput)

	UpdateGuardrail(*bedrock.UpdateGuardrailInput) (*bedrock.UpdateGuardrailOutput, error)
	UpdateGuardrailWithContext(aws.Context, *bedrock.UpdateGuardrailInput, ...request.Option) (*bedrock.UpdateGuardrailOutput, error)
	UpdateGuardrailRequest(*bedrock.UpdateGuardrailInput) (*request.Request, *bedrock.UpdateGuardrailOutput)

	UpdateProvisionedModelThroughput(*bedrock.UpdateProvisionedModelThroughputInput) (*bedrock.UpdateProvisionedModelThroughputOutput, error)
	UpdateProvisionedModelThroughputWithContext(aws.Context, *bedrock.UpdateProvisionedModelThroughputInput, ...request.Option) (*bedrock.UpdateProvisionedModelThroughputOutput, error)
	UpdateProvisionedModelThroughputRequest(*bedrock.UpdateProvisionedModelThroughputInput) (*request.Request, *bedrock.UpdateProvisionedModelThroughputOutput)
}

var _ BedrockAPI = (*bedrock.Bedrock)(nil)
