/*
 * Copyright 2023 The Error Prone Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.errorprone.bugpatterns.testdata;

import java.security.SecureClassLoader;

class BanClassLoaderPositiveCases {
  /** OK to extend SecureClassLoader */
  class AnotherSecureClassLoader extends SecureClassLoader {}

  /** OK to call loadClass if it's not on RMIClassLoader */
  public final Class<?> overrideClassLoader() throws ClassNotFoundException {
    SecureClassLoader loader = new AnotherSecureClassLoader();
    return loader.loadClass("BadClass");
  }

  /** OK to define loadClass */
  private class NotClassLoader {
    protected void loadClass() {}
  }
}
