/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleSelect {
    private String tableName;
    private String orderBy;
    private List columns = new ArrayList();
    private Map aliases = new HashMap();
    private List whereTokens = new ArrayList();

    public SimpleSelect addColumns(String[] columnNames, String[] aliases) {
        int i = 0;
        while (i < columnNames.length) {
            this.addColumn(columnNames[i], aliases[i]);
            ++i;
        }
        return this;
    }

    public SimpleSelect addColumns(String[] columnNames) {
        int i = 0;
        while (i < columnNames.length) {
            this.addColumn(columnNames[i]);
            ++i;
        }
        return this;
    }

    public SimpleSelect addColumn(String columnName) {
        this.columns.add(columnName);
        return this;
    }

    public SimpleSelect addColumn(String columnName, String alias) {
        this.columns.add(columnName);
        this.aliases.put(columnName, alias);
        return this;
    }

    public SimpleSelect setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SimpleSelect addWhereToken(String token) {
        this.whereTokens.add(token);
        return this;
    }

    public SimpleSelect addCondition(String lhs, String op, String rhs) {
        this.whereTokens.add(lhs + ' ' + op + ' ' + rhs);
        return this;
    }

    public SimpleSelect addCondition(String lhs, String condition) {
        this.whereTokens.add(lhs + ' ' + condition);
        return this;
    }

    public SimpleSelect addCondition(String[] lhs, String op, String[] rhs) {
        int i = 0;
        while (i < lhs.length) {
            this.addCondition(lhs[i], op, rhs[i]);
            if (i != lhs.length - 1) {
                this.whereTokens.add("and");
            }
            ++i;
        }
        return this;
    }

    public SimpleSelect addCondition(String[] lhs, String condition) {
        int i = 0;
        while (i < lhs.length) {
            this.addCondition(lhs[i], condition);
            if (i != lhs.length - 1) {
                this.whereTokens.add("and");
            }
            ++i;
        }
        return this;
    }

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.columns.size() * 10 + this.tableName.length() + this.whereTokens.size() * 10 + 10);
        buf.append("select ");
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            String col = (String)iter.next();
            buf.append(col);
            String alias = (String)this.aliases.get(col);
            if (alias != null && !alias.equals(col)) {
                buf.append(" as ").append(alias);
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" from ").append(this.tableName);
        if (this.whereTokens.size() > 0) {
            buf.append(" where ").append(this.toWhereClause());
        }
        if (this.orderBy != null) {
            buf.append(this.orderBy);
        }
        return buf.toString();
    }

    public String toWhereClause() {
        StringBuffer buf = new StringBuffer(this.whereTokens.size() * 5);
        Iterator iter = this.whereTokens.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }
}

